/*
 * xd.h	Headers for Simple X etc pp
 *
 * Stefan Haenssgen 10-Mar-92
 *
 * Updates:	08-Apr-92  Introduced colors
 * 		10-Apr-92  Introduced title string
 * 		13-Apr-92  Default colors (B&W)
 *			   Added GetMouseData() for user interaction
 *			   Added auto/manual positioning of window
 *
 */

/*
 * A note on colors:
 *
 * The colors the user wants to see are given in the array "colors"
 * that points to the single colors as follows:
 *
 * One single color has the type  "singleColor" which is a
 *     struct { unsigned short  red,green,blue; }
 *
 * 
 * singleColor *colors   ->   colors[0] (with colors[0].red, colors[0].green
 *                                       and colors[0].blue as RGB values)
 * 			      colors[1] = ...etc...
 *
 *
 * The user just fills in the values for red, green and blue, ranging
 * from 0 (nothing) to 65535 (full brightness of this color),
 * e.g. (0,0,65535) is perfect blue, (0,0,0) is black, (65535,65535,65535)
 * is white and (65535,65535,0) is yellow etc.
 *
 * If no colors are given, i.e. numcolors==0 or colors==NULL, then black
 * and white are used as the two default colors.
 */

/*
 *
 * Functions:
 * ---------
 *
 * OpenDisplayWindow(x,y,width,heigth,numcolors,colors,wtitle)
 *		Opens a display window of the given size at (x,y)
 *		If x or y are negative, the window is manually positioned
 *
 *		int         numcolors = number of wanted colors
 *		singleColor colors[]  = array with RGB values
 *				        (i.e. colors[0].red = red value
 *				         colors[0].green, colors[0].blue dito)
 *		char        *title    = title of window
 *
 * DrawPixel(x,y,color)
 *		Draws a pixel of the given color internally (!)
 *
 * FastDrawPixel(x,y,color)
 *		Draws a pixel of the given color internally (!), faster
 *
 * GetMouseData(&x,&y,&button)
 *		Get most recent mouse coordinates & button status:
 *		button = 1*left + 2*middle + 4*right  (if l/m/r button pressed)
 *		x = y = -1  if mouse not in window
 *
 * ClearDisplayWindow()
 *		Quickly clears the drawing area internally (!)
 *
 * UpdateDisplayWindow()
 *		Updates displayed window, makes recent changes visible
 *
 * CloseDisplayWindow()
 *		Destroys the window and closes the connection to X
 *
 */


/* Functions in the X Interface */

extern int  OpenDisplayWindow(/* x,y,width,height,numcolors,colors,wtitle */);
extern void DrawPixel(/* x,y,color */);
extern void FastDrawPixel(/* x,y,color */);
extern void GetMouseData(/* &x,&y,&button */);
extern void UpdateDisplayWindow();
extern void CloseDisplayWindow();
extern void ClearScreen();


/* Used variables */

typedef struct {				/* Color type		   */
    unsigned short red,green,blue;
} singleColor;

typedef singleColor *colorPtr;

extern singleColor *colors;
extern char* pixelbuffer;			/* Pixel buffer, direct	   */
extern int width;				/* Size of window	   */
extern int height;
extern int maxcolors;				/* # of colors we got	   */
extern unsigned long foregrounds[];		/* Pixel values for colors */
extern unsigned long backgrounds[];
extern int mouse_x,mouse_y,mouse_button;	/* Mouse data		   */


/* Abbreviations (hello Ernst :-) */

#define OpenDW		OpenDisplayWindow
#define Draw		DrawPixel
#define FDraw		FastDrawPixel
#define UpdateDW	UpdateDisplayWindow
#define CloseDW		CloseDisplayWindow
#define ClearDW		ClearDisplayWindow
#define GetMouse	GetMouseData

#define p_0_OpenDW(a,b,c,d,e,f,g,h)
#define p_0_Draw		  p_0_DrawPixel
#define p_0_FDraw		  p_0_FastDrawPixel
#define p_0_UpdateDW()
#define p_0_CloseDW()
#define p_0_ClearDW()
#define p_0_GetMouse		  p_0_GetMouseData
