#ifndef MSSYSTEM

/* This file contains definitions necessary to run Moduls 2* programms on the MasPar */
/*              						                     */ 
/*                     by Paul Lukowicz 1992                                         */


/*  macros and procedure for the computation of virtualisaton loop bounderies  */ 
/*-----------------------------------------------------------------------------*/
extern plural int _low_proc();
extern plural int _hi_proc_();
extern plural int _vlow_();
extern plural int _vhi_();
#define _InitBounds_(a,b,c)c=p_0_ABS((a)-(b))+1
#define _MaxBounds_(a,b,c)c=(p_0_ABS((a)-(b))+1>c) ? p_0_ABS((a)-(b))+1: c
/******************************************************************************/

#define actBits 1
#define desc    2
#define actBitSize 1
#define StackSize 512
#define VARStackSize 512
#define ThreadStackSize 10048
#define maxxproc  128
#define maxyproc  128

/*  macros neccessary for the computation of data addresses  */ 
/*-----------------------------------------------------------*/
#define _s_(a,b,c)((a)*(b)+(c))
#define _pl_(a,b,c)(((a)&(b))<<(c)) 
#define _ll_(a,b,c)(((a)&(b))<<(c))
#define _pr_(a,b,c)(((a)&(b)) >>(c)) 
#define _lr_(a,b,c)(((a)&(b))>>(c)) 
#define _no_(a)(a)
/*************************************************************/



/*                             communication macros                        */ 
/*-------------------------------------------------------------------------*/


/*  ACU-PE write routine                                */
#define _PutGlobal_(a,b,c,d)	      			\
 {regvar char *s_p_s;					\
  plural regvar char *plural t_p_s;			\
  int s_s_s;						\
  a = c;						\
  s_p_s = (char *) &(a); t_p_s = (plural char *) &(d);	\
  for(s_s_s = sizeof(a); s_s_s > 0;			\
      proc[b].*t_p_s++ = *s_p_s++, s_s_s--);		\
  }							\
           
#define _PutGlobal1_(a,b,c,d) proc[b].d = c;	

/*  ACU-PE read routine                                */
#define _GetGlobal_(a,b,c)	      			\
 {regvar char *s_p_s;					\
  plural regvar char * t_p_s;				\
  int s_s_s;					        \
  s_p_s = (char *) &(a); t_p_s = (plural char *) &(c);	\
  for(s_s_s = 0 ; s_s_s < sizeof(a);			\
      *s_p_s++ = proc[b].*t_p_s++,s_s_s++);		\
  }							\

#define _GetGlobal1_(a,b,c) a = proc[b].c
	

#define _PutGlobalP_(a,b,c,d)a = c; sp_rsend(b,&(a),&(d),sizeof(a))
#define _GetGlobalP_(a,b,c)ps_rfetch(b,&(c),&(a),sizeof(a))

#define _PutBorderNNE_(_tmp_,a,de,si,hv) sp_rsend(_tmp_,a,de,si);	
/* all {				\
sp_xsend(0,1,a,a),si);							\
sp_xsend(0,1,a,de),si);}						\
*/

#define _GetBorderNNE_(_tmp_,c,a,si,hv)  ps_rfetch(_tmp_,c,a,si);
/* all{				\
if(iyproc != 128){ps_xfetch(1,0,c,a,si);				\
ps_xfetch(0,1,a,a,si);} ps_rfetch(_tmp_,c,a,si);}						\		
*/


#define _PutBorderNNW_(_tmp_,a,de,si,hv) sp_rsend(_tmp_,a,de,si);	 

/* all {				\
sp_xsend(0,-1,a,a),si);							\
sp_xsend(0,-1,a,de),si);}						\
*/

#define _GetBorderNNW_(_tmp_,c,a,si,hv)  ps_rfetch(_tmp_,c,a,si);
/* all{				\
if(iyproc != 1){ps_xfetch(-1,0,c,a,si);					\
ps_xfetch(0,-1,a,a,si); } ps_rfetch(_tmp_,c,a,si);}			\
 */

#define _PutBorderNNS_(_tmp_,a,de,si,hv) sp_rsend(_tmp_,a,de,si);	
#define _GetBorderNNS_(_tmp_,c,a,si,hv) ps_rfetch(_tmp_,c,a,si);

#define _PutBorderNNN_(_tmp_,a,de,si,hv) sp_rsend(_tmp_,a,de,si);	
#define _GetBorderNNN_(_tmp_,c,a,si,hv) ps_rfetch(_tmp_,c,a,si);

/*  PE-PE write routine using general communication     */
#define _PutGlobalPT_(a,b,c,de) 			\
{ regvar plural LONGINT _tmp_;				\
  if((_tmp_ =b) == _thispe_()) de = c;			\
  else	{						\
   a = c; sp_rsend(_tmp_,&(a),&(de),sizeof(a));		\
  }							\
}  

/*  PE-PE write routine using general communication     */
#define _PutGlobalPT1_(a,b,c,de) 			\
{ regvar plural LONGINT _tmp_;				\
   a = c; sp_rsend(_tmp_,&(a),&(de),sizeof(a));		\
}  

/*  PE-PE read routine using general communication     */   
#define _GetGlobalPT_(a,b,c)				\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) a = c;			\
 else							\
     {ps_rfetch(_tmp_,&(c),&(a),sizeof(a));	}	\
}							\


/*  PE-PE write routine using NN west communication    */
#define _PutNNW_(a,b,c,de)			       \
{ regvar plural LONGINT _tmp_;				\
  if((_tmp_ =b) == _thispe_()) {de = c;}		\
  else {if _borderW_					\
   {_PutBorderNNW_(_tmp_,&(a),&(de),sizeof(a),a);}		\
  else							\
   {a = c; sp_xsend(0,-1,&(a),&(de),sizeof(a));}}	\
}  

/*  PE-PE write routine using NN west communication    */
#define _GetNNW_(a,b,c,)				\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c;}			\
  else {if _borderW_					\
   {_GetBorderNNW_(_tmp_,&(c),&(a),sizeof(a),a);}		\
   else							\
    {ps_xfetch(0,-1,&(c),&(a),sizeof(a));}	}	\
}							\

/*
#define _GetNNW_(a,b,c,dist)					\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c;}			\
  else {if _borderW_					\
   {_GetBorderNNW_(_tmp_,&(c),&(a),sizeof(a),a);}	\
   else							\
    {ps_xfetch(0,-1,&(c),&(a),sizeof(a));}	}	\
}							\
*/

/*  PE-PE write routine using NN east communication    */

#define _GetNNW2_(a,b,c,dist)				\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c;}			\
  else { ps_xfetch(0,-dist,&(c),&(a),sizeof(a));	\
   if ((ixproc-dist < 0) && (iyproc >0))					\
    {ss_xfetch(-1,0,&(a),&(a),sizeof(a));}}		\
}							\							
#define _GetNNW3_(a,b,c,dist)				\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c;}			\
  else { a = c; a = xnetW[dist].(a);				\
   if ((dist+ixproc < 0) & (iyproc >0))			\
    {a = xnetN[1].a;}}					\
}							\


/*  PE-PE write routine using NN east communication    */
#define _PutNNE_(a,b,c,de) 			        \
{ regvar plural LONGINT _tmp_;				\
  if((_tmp_ =b) == _thispe_()) {de = c;}		\
  else { if (_borderE_)					\
   {_PutBorderNNE_(_tmp_,&(a),&(de),sizeof(a),a);} 	\
  else							\
   {a = c; sp_xsend(0,1,&(a),&(de),sizeof(a));}} 	\
} 

#define _PutNNE2_(a,b,c,dist)				\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c;}			\
  else {  a = c;					\
   if ((dist+ixproc > 127) & (iyproc <127))		\
    {sp_xsend(1,0,&(a),&(a),sizeof(a));}		\
   sp_xsend(0,dist,&(a),&(de),sizeof(a));}		\
}							\

#define _PutNNE3_(a,b,c,dist)				\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c;}			\
  else {  a = c;					\
   if ((dist+ixproc > 127) & (iyproc <127))		\
    {sp_xsend(1,0,&(a),&(a),sizeof(a));}		\
   sp_xsend(0,dist,&(a),&(de),sizeof(a));}		\
}							\



/*  PE-PE write routine using NN east communication    */
#define _GetNNE_(a,b,c)				        \
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c;}			\
  else { if (_borderE_)					\
   {_GetBorderNNE_(_tmp_,&(c),&(a),sizeof(a),a);}		\
   else							\
    {ps_xfetch(0,1,&(c),&(a),sizeof(a));	}}	\
}							\

/*  PE-PE write routine using NN east communication    */
#define _GetNNE2_(a,b,c,dist)				\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c;}			\
  else { ps_xfetch(0,dist,&(c),&(a),sizeof(a));		\
   if ((dist+ixproc > 127) & (iyproc <127))		\
    {ss_xfetch(1,0,&(a),&(a),sizeof(a));}}		\
}							\
					
/*  PE-PE write routine using NN east communication    */
#define _GetNNE3_(a,b,c,dist)				\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c;}			\
  else { a = c; a = xnetE[dist].(a);				\
   if ((dist+ixproc > 127) & (iyproc <127))		\
    {a = xnetS[1].a;}}					\
}							\
					

/*  PE-PE write routine using NN south communication    */
#define _PutNNS_(a,b,c,de)				\
{ regvar plural LONGINT _tmp_;				\
  if((_tmp_ =b) == _thispe_()) {de = c;}		\
  else {if _borderS_					\
   {_PutBorderNNS_(_tmp_,&(a),&(de),sizeof(a),a);}	\
  else							\
   {a = c; sp_xsend(1,0,&(a),&(de),sizeof(a));}}	\
}  

/*  PE-PE write routine using NN south communication    */
#define _GetNNS_(a,b,c)				\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) {a = c};			\
  else if _borderS_					\
   _GetBorderNNS_(_tmp_,&(c),&(a),sizeof(a),a);		\
   else							\
    {ps_xfetch(1,0,&(c),&(a),sizeof(a));	}	\
}							\

/*  PE-PE write routine using NN north communication    */
#define _PutNNN_(a,b,c,de)				\
{ regvar plural LONGINT _tmp_;				\
  if((_tmp_ =b) == _thispe_()) de = c;			\
  else if _borderN_					\
   _PutBorderNNN_(_tmp_,&(a),&(de),sizeof(a),a);		\
  else							\
   {a = c; sp_xsend(-1,0,&(a),&(de),sizeof(a));}	\
}  

/*  PE-PE write routine using NN north communication    */
#define _GetNNN_(a,b,c)					\
{ regvar plural int _tmp_;				\
 if((_tmp_ = b) == _thispe_()) a = c;			\
  else if _borderN_					\
   _GetBorderNNS_(_tmp_,&(c),&(a),sizeof(a),a);		\
   else							\
    {ps_xfetch(-1,0,&(c),&(a),sizeof(a));	}	\
}							\

/*************************************************************************/


/*              macros neccessary for the allocation of temporary variables         */ 
/*----------------------------------------------------------------------------------*/
#define _AllocTmpVar_(aa,b,c) aa = (plural c *) p_malloc(reduceMax32((plural int) ((b)+1)*sizeof(c))); 
#define _FreeTmpVar_(a)p_free(a)
/************************************************************************************/


/*              other macros                                   */ 
/*-------------------------------------------------------------*/

/* Synchronisation barrier. Void on the MasPar  */
#define _Sync_(a)

/*  registrer variable */
#define regvar register

/*   Get the number of the executing PE    */
#define _thispe_() iproc

#define _borderW_ (ixproc == 0) 
#define _borderE_ (ixproc == maxxproc-1)
#define _borderN_ (iyproc == 0)
#define _borderS_ (ixproc == maxxproc-1) 

/***************************************************************/


/*             Void definitions for code distribution          */ 
/*-------------------------------------------------------------*/
#define _ParProcStart_(a)
#define _ParProcEnd_(a)
#define _ParItem_(a,b)
#define _InitPEs_(a)
#define _EndPEs_()
#define _check_counter_(a)a
/***************************************************************/


/*  definitions  of some standard procedures  */
/*--------------------------------------------*/

#define BEGIN_IO() 

#define ABSLI(x)((x) < 0 ? (-x) : (x))
#define ABSLR(x)((x) < 0 ? (-x) : (x))

#define p_0_ABSLI(x)((plural LONGINT)((x) < 0 ? (-x) : (x)))
#define p_0_ABSLR(x)((plural LONGREAL)((x) < 0 ? (-x) : (x)))

#define HIGH(a)(a)
#define p_0_HIGH(a)(a)

#define p_0__SIZE_(a)(a)
#define _SIZE_(a)(a)

#define p_0_sizeof(a) sizeof(a)
#define _singular_(a) proc[selectOne()].(a)

/***************************************************************/

#endif
#define MSSYSTEM
