/*
 * XDisplay.c		X Windows Interface for Graphics
 *
 *
 * Stefan Haenssgen	09-Mar-92  started it
 *			10-Mar-92  got Images to work :-)
 *			11-Mar-92  Debugging (now also likes color displays)
 *				   Improved comments and documentation
 *			12-Mar-92  Still better docu :-)
 *				   FastDrawPixel()
 *				   Nicer colors
 *				...holidays...
 *			08-Apr-92  Experiments with color
 *				   Added colors to OpenDisplayWindow()
 *			09-Apr-92  Added RGB definition of colors
 *			10-Apr-92  Added window title
 *				   Added ClearDisplayWindow
 *
 * Paul Lukovwicz      adapted for the maspar;
 * 
 *  Functions:
 * ---------
 *
 * OpenDisplayWindow(x,y,width,heigth,numcolors,colors,wtitle)
 *		Opens a display window of the given size at (x,y)
 *
 *		int         numcolors = number of wanted colors
 *		singleColor colors[]  = array with RGB values
 *				        (i.e. colors[0].red = red value
 *				         colors[0].green, colors[0].blue dito)
 *		char        *title    = title of window
 *
 * DrawPixel(x,y,color)
 *		Draws a pixel of the given color internally (!)
 *
 * FastDrawPixel(x,y,color)
 *		Draws a pixel of the given color internally (!), faster
 *
 * UpdateDisplayWindow()
 *		Updates displayed window
 *
 * CloseDisplayWindow()
 *		Destroys the window and closes the connection to X
 *
 * ClearDisplayWindow()
 *		Quickly clears the screen
 *
 * History:
 *	- tried multiple GCs and drawing directly... too slow
 *	- dito with off-screen drawing and copying all at once... not better
 *	- dito with pixmaps instead of multiple GCs... nothing
 *	- use XImages - faster, ok...
 *	- use XImages and direct memset - TURBO!!!!
 *	- note: just (char)s in the buffer! ulong not necessary!
 */

#define wau
#include <stdio.h>

#include "msXDW.MASP.h"

visible extern int FE_OpenDisplayWindow();
visible extern void FE_UpdateDisplayWindow();
visible extern void FE_CloseDisplayWindow();
visible extern char* pixelbuffer;			/* Pixel buffer, direct	*/

/*typedef struct {				/* Color type		*/
/*    unsigned short red,green,blue;
/*} singleColor;
 */

#define BORDER_WIDTH 2   	/* Window border width */
#define num_PEs		(8192*2)
#define Sticky False     	/* For TWM (True) makes the window appear on */
				/*   screen without user intervention. */

int     screen; 		/* Screen of Display		*/
unsigned long blackPixel;	/* Black and white pixel values	*/
unsigned long whitePixel;
int	depth;			/* Depth (in bits) of display	*/
int	bits_per_pixel;		/* Pixmap information		*/
int	scanline_pad;		/* Padding for the pixelbuffer	*/
int	maxcolors;		/* Number of colors we got	*/
int	width,height;		/* Size of window		*/
int	local_size;	
plural	char * plural BE_pixelbuffer;		/* Off-screen drawing area	*/
plural char * tmp_pixelbuffer, *tmp1, *tmp2, *tmp3;
int     numcolors;

visible char 	    *win_tit;
visible singleColor *win_cols;

visible unsigned long BE_foregrounds[256];	/* Pixel values for colors */
visible unsigned long BE_backgrounds[256];


/* Public interface routines */



int OpenDisplayWindow(xc,yc,wi,he,numcol,col,wtit,wtitlen)
int xc,yc,wi,he;
int numcol;				/* Number of colors wanted */
singleColor *col;			/* RGB-Values of colors	   */
char *wtit;				/* Title of window	   */
unsigned long wtitlen;
{
    long size;
    /* call the OpenDisplayWindow Routine on the Frontend  */
    size = wi*he;
    local_size = (size+(num_PEs-(size % num_PEs))+1) /num_PEs;
    while ((local_size > 2) &  (local_size % 4 != 0)) local_size++;
    size = local_size*num_PEs;    
    callRequest(FE_OpenDisplayWindow,7*sizeof(int)+8+sizeof(long),xc,yc,wi,he,size,numcol,col,wtit,wtitlen);	
    /* Allocate Pixel Buffer and Create Image */
    width = wi;
    height = he;
    tmp_pixelbuffer = p_malloc(local_size);
    tmp1 = tmp_pixelbuffer+1;
    tmp2 = tmp_pixelbuffer+2;
    tmp3 = tmp_pixelbuffer+3;
    BE_pixelbuffer = (plural char*) tmp_pixelbuffer;
}


void DrawPixel(x,y,color)	/* Draw a point in the given color	*/
int x,y,color;
{
/* 
    FastDrawPixel(x,y,color); */

}
# define p_0_DrawPixel p_0_FastDrawPixel
/* plural void p_0_DrawPixel(x,y,color)	
plural int x,y,color;
{
 p_0_FastDrawPixel(x,y,color); 
}
*/

void FastDrawPixel(x,y,color)	/* Draw a point via direct access	*/
int x,y,color;
{

    proc[(x+y*width) / num_PEs].BE_pixelbuffer[(x+y*width) % num_PEs] = (char) (char)BE_foregrounds[color]; 

}

plural void p_0_FastDrawPixel(x,y,color)	/* Draw a point via direct access	*/
plural int x,y,color;
{   plural int pe,lo;
    plural char co;
    co = (plural char) BE_foregrounds[color]; 
    pe = (x+y*((plural)width)) / (plural) local_size;
    lo = (x+y*((plural)width)) % (plural) local_size;
    sp_rsend(pe,&co,BE_pixelbuffer+lo,1);
}


void UpdateDisplayWindow()
{   char *tmp;
    callRequest(FE_UpdateDisplayWindow,sizeof(char *)+sizeof(int),tmp_pixelbuffer,local_size);
}

void CloseDisplayWindow()
{
  callRequest(FE_CloseDisplayWindow,0);
}

void ClearDisplayWindow()
{ plural int res;
  plural char * tmpp;
/*  tmpp = tmp_pixelbuffer;
  res = p_memset(tmpp,(char) 0,local_size); */
  for(tmpp = tmp_pixelbuffer; tmpp <= tmp_pixelbuffer+local_size; *tmpp++ =0);
}

void ClearScreen()
{
    ClearDisplayWindow();
}



















