/*
 * XDisplay.c		X Windows Interface for Graphics
 *
 *
 * Stefan Haenssgen	09-Mar-92  started it
 *			10-Mar-92  got Images to work :-)
 *			11-Mar-92  Debugging (now also likes color displays)
 *				   Improved comments and documentation
 *			12-Mar-92  Still better docu :-)
 *				   FastDrawPixel()
 *				   Nicer colors
 *				...holidays...
 *			08-Apr-92  Experiments with color
 *				   Added colors to OpenDisplayWindow()
 *			09-Apr-92  Added RGB definition of colors
 *			10-Apr-92  Added window title
 *				   Added ClearDisplayWindow
 *
 *
 * Functions:
 * ---------
 *
 * OpenDisplayWindow(x,y,width,heigth,numcolors,colors,wtitle)
 *		Opens a display window of the given size at (x,y)
 *
 *		int         numcolors = number of wanted colors
 *		singleColor colors[]  = array with RGB values
 *				        (i.e. colors[0].red = red value
 *				         colors[0].green, colors[0].blue dito)
 *		char        *title    = title of window
 *
 * DrawPixel(x,y,color)
 *		Draws a pixel of the given color internally (!)
 *
 * FastDrawPixel(x,y,color)
 *		Draws a pixel of the given color internally (!), faster
 *
 * UpdateDisplayWindow()
 *		Updates displayed window
 *
 * CloseDisplayWindow()
 *		Destroys the window and closes the connection to X
 *
 * ClearDisplayWindow()
 *		Quickly clears the screen
 *
 * History:
 *	- tried multiple GCs and drawing directly... too slow
 *	- dito with off-screen drawing and copying all at once... not better
 *	- dito with pixmaps instead of multiple GCs... nothing
 *	- use XImages - faster, ok...
 *	- use XImages and direct memset - TURBO!!!!
 *	- note: just (char)s in the buffer! ulong not necessary!
 */


#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>

#include "msXDW.MASP.h" 

#define wau 
#define num_PEs		(8192*2)
#define x_PEs		(128)
#define y_PEs		(128)

/*typedef struct {				/* Color type		*/
/*    unsigned short red,green,blue;
/*} singleColor;
 */

#define BORDER_WIDTH 2   	/* Window border width */
#define Sticky False     	/* For TWM (True) makes the window appear on */
				/*   screen without user intervention. */
#define EV_MASK ExposureMask | ButtonPressMask | KeyPressMask


Display *disp;  		/* Display			*/
int     screen; 		/* Screen of Display		*/
unsigned long blackPixel;	/* Black and white pixel values	*/
unsigned long whitePixel;
int	depth;			/* Depth (in bits) of display	*/
int	bits_per_pixel;		/* Pixmap information		*/
int	scanline_pad;		/* Padding for the pixelbuffer	*/
int	maxcolors;		/* Number of colors we got	*/
int	width,height;		/* Size of window		*/
char	*pixelbuffer, *pixelbuffer1;	/* Off-screen drawing area	*/
int     numcolors;


unsigned long foregrounds[256];	/* Pixel values for colors */
unsigned long backgrounds[256];

extern long BE_foregrounds[256];	
extern long BE_backgrounds[256];	

GC	gc;			/* Graphic Context for drawing	*/
Window	win;			/* Our Window			*/
XImage	*img;			/* ouir off-screen buffer	*/
XGCValues	gcval;		/* For modification of GC		*/
XFontStruct	*font=NULL;	/* Font to use				*/


GC MakeGC(win,fore,back)	/* Create new GC		*/
Window win;
unsigned long fore;
unsigned long back;
{
  XGCValues gcv;

  gcv.foreground = fore;
  gcv.background = back;
  gcv.graphics_exposures=False;
  return(XCreateGC(disp,win,(GCForeground | GCBackground | GCGraphicsExposures),&gcv));

}

int createGC(win,gc)		/* Create GC with default pixels */
Window win;
GC *gc;
{
  XGCValues GCValues;
  int fore = blackPixel;
  int back = whitePixel;

  if (!(*gc = MakeGC(win,blackPixel, whitePixel)))
    return(0);
  else 
    return(1);
}


init_colors(numcolors,colors)		/* Allocate wanted colors	*/
int numcolors;
singleColor *colors;
{
  int i;
  int cells;
  Colormap cmap;
  XColor col;

  cmap = DefaultColormap(disp,screen);	/* Get color map to work on	*/

  maxcolors=2;
  for (i = 0 ; i < numcolors; i++) {
      unsigned long fore = blackPixel;
      unsigned long back = whitePixel;

      cells = DisplayCells(disp,screen);/* Number of entries in color map */

      if (cells > 2) {

/*	  if (cells > numcolors) {
/*	      col.red = col.green = col.blue = 30000; /* Gray for rest */
/*              col.flags = DoRed | DoGreen | DoBlue;
/*	  } else {*/
              col.red   = colors[i].red;	/* Get new color as wanted */
              col.green = colors[i].green;
              col.blue  = colors[i].blue;
              col.flags = DoRed | DoGreen | DoBlue;
/*	  }*/
	  if (XAllocColor(disp,cmap,&col) == 0)  {
	      printf("Can't alloc color (%5d,%5d,%5d) as no.%5d .. using default.\n",colors[i].red,colors[i].green,colors[i].blue,fore);
	  } else {
	      fore = col.pixel;
              maxcolors++;
	  }

      } else {
          /* Get black/white on monochrome systems depending on brightness */

          printf("mapping (%5d,%5d,%5d) to ",colors[i].red,colors[i].green,colors[i].blue);
          if (colors[i].red + colors[i].blue + colors[i].green > 65535*3/2) { 
              fore = 0;
              back = 1;
              printf("black\n");
          } else {
              fore = 1;
              back = 0;
              printf("white\n");
          }
      }
      foregrounds[i] = fore;
      backgrounds[i] = back;
  }
  printf("got %d colors\n",maxcolors);
  }


int initX(displayname,numcolors,colors)		/* Init X Server connection */
char *displayname;
int numcolors;
singleColor *colors;
{ 
    if (!(disp = XOpenDisplay(displayname))) {
        fprintf(stderr,"Cannot establish a connection to the X Server %s\n",
              XDisplayName(displayname));
        exit(1);
    }

    /* Get default screen and pixel values */

    screen = DefaultScreen(disp);	
    depth=DefaultDepth(disp,screen);

    blackPixel = WhitePixel(disp,screen);
    whitePixel = BlackPixel(disp,screen);	

    init_colors(numcolors,colors);
    return(1);
    }

   
void SetDisplayWindowFont(FontName,flen)		/* Select new font to use	*/
char *FontName;
unsigned long flen;
{
    XFontStruct *fontStruct;

    if (font != NULL) {			/* Free old font...		*/
        XFreeFont(disp,font);		/* ...if there was one 		*/
    };
    if (font = XLoadQueryFont(disp,FontName)) {	/* Load new font	*/
        gcval.font = font->fid;
        XChangeGC(disp,gc,GCFont,&gcval);
        printf("Set Font to %s\n",FontName);
    } else {					/* Complain if error	*/
        fprintf(stderr,"Couldn`t open font %s!\n",FontName);
    };
}

 
Window OpenWindow(x,y,w,h,gc,wtitle)		/* Open the window itself */
int x, y, w, h; 
GC *gc;
char *wtitle;
{
  XSetWindowAttributes	attribs;
  XSizeHints		hints;
  unsigned long		mask;
  Window		win;
  XWMHints		WMhints;	/* Window Manager Hints	*/
  int			max_width,max_height;
  int			i;
  char			auto_position;
  XSetWindowAttributes  attr;		/* What we want to monitor */


  /* Automatically position window using given coordinates (x,y) */
  /* if x and y are positive, else let user position manually	 */

  auto_position = (x>=0 && y>=0);
 
  width  = w;				/* Set global dimensions */
  height = h;
  max_width=DisplayWidth(disp,screen);
  max_height=DisplayHeight(disp,screen);
  printf("Screen is %dx%d pixels\n",max_width,max_height);

  attribs.border_pixel = blackPixel;
  attribs.background_pixel = whitePixel;
  attribs.override_redirect= auto_position;
  
  mask = CWBackPixel | CWBorderPixel | CWOverrideRedirect;

  win = XCreateWindow(disp,		/* Create Window for Display */
	 RootWindow(disp,screen),
         x,y,
         width, height,
         BORDER_WIDTH,
         CopyFromParent,
         InputOutput,
	 CopyFromParent,
	 mask,
 	&attribs);

  WMhints.initial_state	= NormalState;
  WMhints.flags		= StateHint;

  XSetWMHints(disp,win,&WMhints);

  hints.flags	= PPosition | PSize | PMinSize | PMaxSize;
  hints.x	= x;
  hints.y	= y;
  hints.max_width=width;
  hints.min_width=width;		/* Set Window Manager Parameters */
  hints.max_height=height;
  hints.min_height=height;
  hints.width	= width;
  hints.height	= height;

  XSetNormalHints(disp,win,&hints);

  if (!(createGC(win,gc))) {
    XDestroyWindow(disp,win);
    return( (Window) 0);
  }

  XMapWindow(disp,win);			/* Show Window on Screen */

  XFlush(disp);

  XStoreName(disp,win,wtitle);		/* Set window title	 */
  XMapRaised(disp,win);

  attr.event_mask = EV_MASK;		/* Define which events we want to get*/
  XChangeWindowAttributes(disp,win,CWEventMask,&attr);

  SetDisplayWindowFont("fixed",5);	/* Set Font to default	 */

  return(win);
}



/* Public interface routines */



int FE_OpenDisplayWindow(x,y,w,h,buff_size,	/* Open the display window */
                      numcolors,cols,wtit,wtitlen)
int x,y,w,h,buff_size;
int numcolors;				/* Number of colors wanted */
singleColor *cols;			/* RGB-Values of colors	   */
unsigned long  wtitlen;
char *wtit;				/* Title of window	   */
{   
    char *wtitle;
    singleColor *colors;
    int i;
    int scanline_pad = 32;		/* Bits to pad scanline */
    colors = malloc(numcolors*sizeof(singleColor));
    wtitle = malloc(wtitlen+1); 
    copyIn(wtit,wtitle,wtitlen+1);
    copyIn(cols,colors,numcolors*sizeof(singleColor));    
    initX(NULL,numcolors,colors);
    win=OpenWindow(x,y,w,h,&gc,wtitle);

/*    def_vis = DefaultVisual(disp,screen);*/
/*    printf("default visual = %d\n",def_vis);*/


    /* Allocate Pixel Buffer and Create Image */
    pixelbuffer = (char*) malloc(buff_size);
    pixelbuffer1 = (char*) malloc(buff_size);
    img = XCreateImage(disp,DefaultVisual(disp,screen),DefaultDepth(disp,screen),ZPixmap,0,pixelbuffer, (unsigned int)w, (unsigned int) h, scanline_pad, 0);

   copyOut(foregrounds,BE_foregrounds,256*sizeof(long));


}


void DrawPixel(x,y,color)	/* Draw a point in the given color	*/
int x,y,color;
{
    XPutPixel(img,x,y,color); 

}


void FastDrawPixel(x,y,color)	/* Draw a point via direct access	*/
int x,y,color;
{

    *(pixelbuffer +x+y*width) = foregrounds[color];

}


void FE_UpdateDisplayWindow(BE_buffer,size)
   char * BE_buffer;
    int size;
{   int i, wsize;
    char * ttt;
    wsize = size*num_PEs;
    if(maxcolors == 2) {
     i = blockIn(BE_buffer,pixelbuffer1,(int) 0, (int) 0,(int) x_PEs,(int) y_PEs,size);
     for(i=0,ttt = pixelbuffer1;i < wsize; i++,ttt++){
      DrawPixel(i % width, i / height, (int) *ttt);
     } 
    } 
    else
     i = blockIn(BE_buffer,pixelbuffer,(int) 0, (int) 0,(int) x_PEs,(int) y_PEs,size);
    XPutImage(disp,win,gc,img,0,0,0,0,(unsigned int)width,(unsigned int)height); 
}

void FE_CloseDisplayWindow()
{int i;
XFreeGC(disp,gc); free(pixelbuffer);XDestroyImage(img); XCloseDisplay(disp); 
}
#ifndef wau

void ClearDisplayWindow()
{
  memset(pixelbuffer,(int) 0,(width*height+1));
}

void ClearScreen() 
{
    ClearDisplayWindow();
}
#endif
