/*
 *  Easy Timer Library for Modula-2*
 *
 *  "TimerElapsed" returns the user time since the last
 *  call to "TimerStart" measured in seconds
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz, Lutz Prechelt
 *
 *  Last change:  24.07.1994
 */

#include "msTimer.MASP.h"

extern void   dpuTimerStart();
extern double dpuTimerElapsed();
extern unsigned dpuTimerTicks();

unsigned dpuTimerTicks2 ()
{
  register unsigned t1, t2;
  do {
    t1 = dpuTimerTicks();
    t2 = dpuTimerTicks();
  }
  while (t2-t1 > 500 || t2-t1 < 10);
  return (t2);
}

void
TimerStart()
{
  dpuTimerStart();
}

double
TimerElapsed()
{
  /*  return(dpuTimerElapsed()); */
  return (dpuTimerTicks2() / 12.5 /1000000);
}
