
/*
 *  Scan Library for Modula-2*
 *
 *  allows for efficient scan operations on
 *  arbitrarily large and distributed arrays
 *
 *  MPL implementation by Ernst A. Heinz
 *
 *  Last change: 02.10.1992
 */

#include "msScan.MASP.h"


/* singular versions */

#define SCalcScan(elemType)	\
    l = lx / sizeof(elemType);	\
    k = nx % l;			\
    pe = nx / l;		\
    if (k==0) {			\
      k = l;			\
      pe--;			\
    };
/*
    printf("nx = %u  l = %i  k = %i  pe = %i \n",nx,l,k,pe);
*/

#define ScanShiftRight(val)	\
    val = xnetW[1].val;		\
    if (ixproc==0)		\
      val = xnetN[1].val;

#define GlobalScan(scanFunc,accu)	\
    if (iproc<pe)			\
      accu = scanFunc(accu,(plural char) 0);

#define ScanFunc1(funcName,elemType,infoCalc,localReduction,scanFunc,localScan,accu) \
    void				\
    funcName(x, nx, lx, y, ny, ly)	\
    plural elemType *x;			\
    LONGCARD nx, lx;			\
    register plural elemType *y;	\
    LONGCARD ny, ly;			\
    {					\
      register plural elemType accu;	\
      register plural elemType *xp;	\
      register int j, k, l, pe;		\
					\
      if (nx!=ny) return;		\
					\
      infoCalc(elemType);		\
      all {				\
        localReduction;			\
        GlobalScan(scanFunc,accu);	\
	ScanShiftRight(accu);		\
	localScan;			\
      }					\
    }

#define ScanFunc2(funcName,elemType,infoCalc,localReduction,scanFunc,localScan,accu) \
    void				\
    funcName(x, nx, lx, y, ny, ly)	\
    plural elemType *x;			\
    LONGCARD nx, lx;			\
    register plural elemType *y;	\
    LONGCARD ny, ly;			\
    {					\
      register plural elemType accu, tmp; \
      register plural elemType *xp;	\
      register int j, k, l, pe;		\
					\
      if (nx!=ny) return;		\
					\
      infoCalc(elemType);		\
      all {				\
        localReduction;			\
        globalScan(scanFunc,accu);	\
	ScanShiftRight(accu);		\
	localScan;			\
      }					\
    }


/*
 *  routines with reduction operator "addition"
 */

#define ScanSLocalAddition	\
    xp = x;			\
    sum = 0;			\
    if (iproc<=pe)		\
      for (j=1; j<=k; j++)	\
        sum += *xp++;		\
    if (k<l)			\
      if (iproc<pe)		\
        for (j=k+1; j<=l; j++)	\
          sum += *xp++;

#define ScanSLocalScanAdd	\
    xp = x;			\
    proc[0].sum = 0;		\
    if (iproc<=pe)		\
      for (j=1; j<=k; j++) {	\
        sum += *xp++;		\
        *y++ = sum;		\
      };			\
    if (k<l)			\
      if (iproc<pe)		\
        for (j=k+1; j<=l; j++) {\
          sum += *xp++;		\
	  *y++ = sum;		\
	};


#define ScanAddFunc(funcName,elemType,scanAddition) \
    ScanFunc1(funcName,elemType,SCalcScan,ScanSLocalAddition,scanAddition,ScanSLocalScanAdd,sum)

ScanAddFunc( SScanAddCh, CHAR,      scanAdd8u  )
ScanAddFunc( SScanAddSC, SHORTCARD, scanAdd16u )
ScanAddFunc( SScanAddC,  CARDINAL,  scanAdd32u )
ScanAddFunc( SScanAddSI, SHORTINT,  scanAdd16  )
ScanAddFunc( SScanAddI,  INTEGER,   scanAdd32  )
ScanAddFunc( SScanAddR,  REAL,	    scanAddf   )
ScanAddFunc( SScanAddLR, LONGREAL,  scanAddd   )

#define p_0_SScanAddI(x,nx,lx,y,ny,ly)

/*--- end ---*

 *
 *  routines with reduction operator "logical AND"
 *

#define SLocalAnd		\
    and = 0xFFFFFFFF;		\
    if (iproc<=pe)		\
      for (j=1; j<=k; j++)	\
        and &= *x++;		\
    if (k<l)			\
      if (iproc<pe)		\
        for (j=k+1; j<=l; j++)	\
          and &= *x++;

#define ScanAndFunc(funcName,elemType,infoCalc,localAnd,ScanAnd) \
    ScanFunc1(funcName,elemType,infoCalc,localAnd,ScanAnd,and)

ScanAndFunc( SScanAndCh, CHAR,    	SCalcScan, SLocalAnd, scanAnd8u  )
ScanAndFunc( SScanAndSC, SHORTCARD, SCalcScan, SLocalAnd, scanAnd16u )
ScanAndFunc( SScanAndC,  CARDINAL,	SCalcScan, SLocalAnd, scanAnd32u )
ScanAndFunc( SScanAndSI, SHORTINT,	SCalcScan, SLocalAnd, scanAnd16  )
ScanAndFunc( SScanAndI,  INTEGER,	SCalcScan, SLocalAnd, scanAnd32  )


 *
 *  routines with reduction operator "maximum"
 *

#define SLocalMaximum		\
    result = proc[0].*x;	\
    max = result;		\
    if (iproc<=pe)		\
      for (j=1; j<=k; j++) {	\
        tmp = *x++;		\
        if (max<tmp)		\
	  max = tmp;		\
      };			\
    if (k<l)			\
      if (iproc<pe)		\
        for (j=k+1; j<=l; j++) {\
          tmp = *x++;		\
          if (max<tmp)		\
	    max = tmp;		\
	};

#define ScanMaxFunc(funcName,elemType,infoCalc,localMax,ScanMaximum) \
    ScanFunc2(funcName,elemType,infoCalc,localMax,ScanMaximum,max)

ScanMaxFunc( SScanMaxCh, CHAR,    	SCalcScan, SLocalMaximum, scanMax8u  )
ScanMaxFunc( SScanMaxSC, SHORTCARD, SCalcScan, SLocalMaximum, scanMax16u )
ScanMaxFunc( SScanMaxC,  CARDINAL,	SCalcScan, SLocalMaximum, scanMax32u )
ScanMaxFunc( SScanMaxSI, SHORTINT,	SCalcScan, SLocalMaximum, scanMax16  )
ScanMaxFunc( SScanMaxI,  INTEGER,	SCalcScan, SLocalMaximum, scanMax32  )
ScanMaxFunc( SScanMaxR,  REAL,	SCalcScan, SLocalMaximum, scanMaxf	)
ScanMaxFunc( SScanMaxLR, LONGREAL,	SCalcScan, SLocalMaximum, scanMaxd	)


 *
 *  routines with reduction operator "minimum"
 *

#define SLocalMinimum		\
    result = proc[0].*x;	\
    min = result;		\
    if (iproc<=pe)		\
      for (j=1; j<=k; j++) {	\
        tmp = *x++;		\
        if (min>tmp)		\
	  min = tmp;		\
      };			\
    if (k<l)			\
      if (iproc<pe)		\
        for (j=k+1; j<=l; j++) {\
          tmp = *x++;		\
          if (min>tmp)		\
	    min = tmp;		\
	};

#define ScanMinFunc(funcName,elemType,infoCalc,localMin,ScanMinimum) \
    ScanFunc2(funcName,elemType,infoCalc,localMin,ScanMinimum,min)

ScanMinFunc( SScanMinCh, CHAR,    	SCalcScan, SLocalMinimum, scanMin8u  )
ScanMinFunc( SScanMinSC, SHORTCARD, SCalcScan, SLocalMinimum, scanMin16u )
ScanMinFunc( SScanMinC,  CARDINAL,	SCalcScan, SLocalMinimum, scanMin32u )
ScanMinFunc( SScanMinSI, SHORTINT,	SCalcScan, SLocalMinimum, scanMin16  )
ScanMinFunc( SScanMinI,  INTEGER,	SCalcScan, SLocalMinimum, scanMin32  )
ScanMinFunc( SScanMinR,  REAL,	SCalcScan, SLocalMinimum, scanMinf	)
ScanMinFunc( SScanMinLR, LONGREAL,	SCalcScan, SLocalMinimum, scanMind	)


 *
 *  routines with reduction operator "multiplication"
 *

#define SLocalMultiplication	\
    prod = 1;			\
    if (iproc<=pe)		\
      for (j=1; j<=k; j++)	\
        prod *= *x++;		\
    if (k<l)			\
      if (iproc<pe)		\
        for (j=k+1; j<=l; j++)	\
          prod *= *x++;

#define ScanMulFunc(funcName,elemType,infoCalc,localMul,ScanMultiplication) \
    ScanFunc1(funcName,elemType,infoCalc,localMul,ScanMultiplication,prod)

ScanMulFunc( SScanMulCh, CHAR,    	SCalcScan, SLocalMultiplication, scanMul8u  )
ScanMulFunc( SScanMulSC, SHORTCARD, SCalcScan, SLocalMultiplication, scanMul16u )
ScanMulFunc( SScanMulC,  CARDINAL,	SCalcScan, SLocalMultiplication, scanMul32u )
ScanMulFunc( SScanMulSI, SHORTINT,	SCalcScan, SLocalMultiplication, scanMul16  )
ScanMulFunc( SScanMulI,  INTEGER,	SCalcScan, SLocalMultiplication, scanMul32  )
ScanMulFunc( SScanMulR,  REAL,	SCalcScan, SLocalMultiplication, scanMulf   )
ScanMulFunc( SScanMulLR, LONGREAL,	SCalcScan, SLocalMultiplication, scanMuld   )


 *
 *  routines with reduction operator "logical OR"
 *

#define SLocalOr		\
    or = 0x0;			\
    if (iproc<=pe)		\
      for (j=1; j<=k; j++)	\
        or |= *x++;		\
    if (k<l)			\
      if (iproc<pe)		\
        for (j=k+1; j<=l; j++)	\
          or |= *x++;

#define ScanOrFunc(funcName,elemType,infoCalc,localOr,ScanOr) \
    ScanFunc1(funcName,elemType,infoCalc,localOr,ScanOr,or)

ScanOrFunc( SScanOrCh, CHAR,      SCalcScan, SLocalOr, scanOr8u  )
ScanOrFunc( SScanOrSC, SHORTCARD, SCalcScan, SLocalOr, scanOr16u )
ScanOrFunc( SScanOrC,  CARDINAL,  SCalcScan, SLocalOr, scanOr32u )
ScanOrFunc( SScanOrSI, SHORTINT,  SCalcScan, SLocalOr, scanOr16  )
ScanOrFunc( SScanOrI,  INTEGER,   SCalcScan, SLocalOr, scanOr32  )


 * plural versions *

#define pSCalcScan(elemType)

#define pScanFunc1(funcName,elemType,infoCalc,localFunc,ScanFunc,accu) \
    plural elemType		\
    funcName(x, n, ls)		\
    register plural elemType *plural x; \
    plural LONGCARD n, ls;	\
    {				\
      *			\
      register plural elemType accu; \
      elemType result;		\
      register int j, k, l, pe;	\
				\
      infoCalc(elemType);	\
      all {			\
        localFunc;		\
        result = ScanFunc(accu); \
      }				\
      return (result);		\
      *			\
    }

#define pScanFunc2(funcName,elemType,infoCalc,localFunc,ScanFunc,accu) \
    plural elemType		\
    funcName(x, n, ls)		\
    register plural elemType *plural x; \
    plural LONGCARD n, ls;	\
    {				\
      *			\
      register plural elemType accu, tmp; \
      elemType result;		\
      register int j, k, l, pe;	\
				\
      infoCalc(elemType);	\
      all {			\
        localFunc;		\
        result = ScanFunc(accu); \
      }				\
      return (result);		\
      *			\
    }


 *
 *  routines with reduction operator "addition"
 *

#define pSLocalAddition

#define pScanAddFunc(funcName,elemType,infoCalc,localAdd,ScanAddition) \
    pScanFunc1(funcName,elemType,infoCalc,localAdd,ScanAddition,sum)

pScanAddFunc( p_0_SScanAddCh, CHAR,      pSCalcScan, pSLocalAddition, scanAdd8u  )
pScanAddFunc( p_0_SScanAddSC, SHORTCARD, pSCalcScan, pSLocalAddition, scanAdd16u )
pScanAddFunc( p_0_SScanAddC,  CARDINAL,  pSCalcScan, pSLocalAddition, scanAdd32u )
pScanAddFunc( p_0_SScanAddSI, SHORTINT,  pSCalcScan, pSLocalAddition, scanAdd16  )
pScanAddFunc( p_0_SScanAddI,  INTEGER,   pSCalcScan, pSLocalAddition, scanAdd32  )
pScanAddFunc( p_0_SScanAddR,  REAL,	     pSCalcScan, pSLocalAddition, scanAddf   )
pScanAddFunc( p_0_SScanAddLR, LONGREAL,  pSCalcScan, pSLocalAddition, scanAddd   )


 *
 *  routines with reduction operator "logical AND"
 *

#define pSLocalAnd

#define pScanAndFunc(funcName,elemType,infoCalc,localAnd,ScanAnd) \
    pScanFunc1(funcName,elemType,infoCalc,localAnd,ScanAnd,and)

pScanAndFunc( p_0_SScanAndCh, CHAR,      pSCalcScan, pSLocalAnd, scanAnd8u  )
pScanAndFunc( p_0_SScanAndSC, SHORTCARD, pSCalcScan, pSLocalAnd, scanAnd16u )
pScanAndFunc( p_0_SScanAndC,  CARDINAL,  pSCalcScan, pSLocalAnd, scanAnd32u )
pScanAndFunc( p_0_SScanAndSI, SHORTINT,  pSCalcScan, pSLocalAnd, scanAnd16  )
pScanAndFunc( p_0_SScanAndI,  INTEGER,   pSCalcScan, pSLocalAnd, scanAnd32  )


 *
 *  routines with reduction operator "maximum"
 *

#define pSLocalMaximum

#define pScanMaxFunc(funcName,elemType,infoCalc,localMax,ScanMaximum) \
    pScanFunc2(funcName,elemType,infoCalc,localMax,ScanMaximum,max)

pScanMaxFunc( p_0_SScanMaxCh, CHAR,      pSCalcScan, pSLocalMaximum, scanMax8u  )
pScanMaxFunc( p_0_SScanMaxSC, SHORTCARD, pSCalcScan, pSLocalMaximum, scanMax16u )
pScanMaxFunc( p_0_SScanMaxC,  CARDINAL,  pSCalcScan, pSLocalMaximum, scanMax32u )
pScanMaxFunc( p_0_SScanMaxSI, SHORTINT,  pSCalcScan, pSLocalMaximum, scanMax16  )
pScanMaxFunc( p_0_SScanMaxI,  INTEGER,   pSCalcScan, pSLocalMaximum, scanMax32  )
pScanMaxFunc( p_0_SScanMaxR,  REAL,	     pSCalcScan, pSLocalMaximum, scanMaxf   )
pScanMaxFunc( p_0_SScanMaxLR, LONGREAL,  pSCalcScan, pSLocalMaximum, scanMaxd   )


 *
 *  routines with reduction operator "minimum"
 *

#define pSLocalMinimum

#define pScanMinFunc(funcName,elemType,infoCalc,localMin,ScanMinimum) \
    pScanFunc2(funcName,elemType,infoCalc,localMin,ScanMinimum,min)

pScanMinFunc( p_0_SScanMinCh, CHAR,      pSCalcScan, pSLocalMinimum, scanMin8u  )
pScanMinFunc( p_0_SScanMinSC, SHORTCARD, pSCalcScan, pSLocalMinimum, scanMin16u )
pScanMinFunc( p_0_SScanMinC,  CARDINAL,  pSCalcScan, pSLocalMinimum, scanMin32u )
pScanMinFunc( p_0_SScanMinSI, SHORTINT,  pSCalcScan, pSLocalMinimum, scanMin16  )
pScanMinFunc( p_0_SScanMinI,  INTEGER,   pSCalcScan, pSLocalMinimum, scanMin32  )
pScanMinFunc( p_0_SScanMinR,  REAL,	     pSCalcScan, pSLocalMinimum, scanMinf   )
pScanMinFunc( p_0_SScanMinLR, LONGREAL,  pSCalcScan, pSLocalMinimum, scanMind   )


 *
 *  routines with reduction operator "multiplication"
 *

#define pSLocalMultiplication

#define pScanMulFunc(funcName,elemType,infoCalc,localMul,ScanMultiplication) \
    pScanFunc1(funcName,elemType,infoCalc,localMul,ScanMultiplication,prod)

pScanMulFunc( p_0_SScanMulCh, CHAR,      pSCalcScan, pSLocalMultiplication, scanMul8u  )
pScanMulFunc( p_0_SScanMulSC, SHORTCARD, pSCalcScan, pSLocalMultiplication, scanMul16u )
pScanMulFunc( p_0_SScanMulC,  CARDINAL,  pSCalcScan, pSLocalMultiplication, scanMul32u )
pScanMulFunc( p_0_SScanMulSI, SHORTINT,  pSCalcScan, pSLocalMultiplication, scanMul16  )
pScanMulFunc( p_0_SScanMulI,  INTEGER,   pSCalcScan, pSLocalMultiplication, scanMul32  )
pScanMulFunc( p_0_SScanMulR,  REAL,	     pSCalcScan, pSLocalMultiplication, scanMulf   )
pScanMulFunc( p_0_SScanMulLR, LONGREAL,  pSCalcScan, pSLocalMultiplication, scanMuld   )


 *
 *  routines with reduction operator "logical OR"
 *

#define pSLocalOr

#define pScanOrFunc(funcName,elemType,infoCalc,localOr,ScanOr) \
    pScanFunc1(funcName,elemType,infoCalc,localOr,ScanOr,or)

pScanOrFunc( p_0_SScanOrCh, CHAR,      pSCalcScan, pSLocalOr, scanOr8u  )
pScanOrFunc( p_0_SScanOrSC, SHORTCARD, pSCalcScan, pSLocalOr, scanOr16u )
pScanOrFunc( p_0_SScanOrC,  CARDINAL,  pSCalcScan, pSLocalOr, scanOr32u )
pScanOrFunc( p_0_SScanOrSI, SHORTINT,  pSCalcScan, pSLocalOr, scanOr16  )
pScanOrFunc( p_0_SScanOrI,  INTEGER,   pSCalcScan, pSLocalOr, scanOr32  )
*/