
/* msRandom Implementation Module, MPL Version */

#include "mpl.h"
#include "msRandom.MASP.h"
extern long random ();
extern srandom();
visible extern int time (/* int* */);

INTEGER
Random(INTEGER from, INTEGER to)
{
  return (((INTEGER)random() % (to-from+1)) + from);
}


void
InitRandom(INTEGER seed)
{
  plural int r = 0;
  int step;
  srandom (seed ? seed 
                : (INTEGER)callRequest (time, sizeof(int*), (int*)0));
  /* now seed p_random on all processors */
  proc[0].r = (int)random ();
  for (step = 1; step < nxproc; step <<= 1) {
    if (iyproc == 0 && ixproc < step) {
      p_srandom (r);
      xnetE[step].r = (plural int)p_random();
    }
  }
  if (iyproc == 0)
    r = (plural int)p_random ();
  for (step = 1; step < nyproc; step <<= 1) {
    if (iyproc < step) {
      p_srandom (r);
      xnetS[step].r = (plural int)p_random();
    }
  }
  /* now it happens: */
  p_srandom (r);
}



plural INTEGER
p_0_Random(plural INTEGER from, plural INTEGER to)
{
  return (((plural INTEGER)p_random() % (to-from+1)) + from);
}


plural void
p_0_InitRandom(plural INTEGER seed)
{
  /* does not make much sense */
  p_srandom (seed);
}
