
/*
 *  I/O Library for Modula-2*
 *
 *  all output goes to "stdout", all input comes from "stdin"
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change: 15.10.1992
 */

#include "msIO.MASP.h"
#include <stdio.h>


#define EolCh		'\n'
#define IOExitValue	-88


/* singular ACU routines */

void
WrB(b)
BOOLEAN b;
{
  if (b) {
    WrCh('T');
  } else {
    WrCh('F');
  }
}

void
WrC(n, w)
LONGCARD n;
SHORTINT w;
{
  printf("%*u",w,n);
}

void
WrCh(ch)
CHAR ch;
{ 
  printf("%c",ch);
}

void
WrE(n, w, prec)
LONGREAL n;
SHORTINT w;
SHORTCARD prec;
{
  char format[10];
  sprintf(format,"%%%d.%de",w,prec);
  printf(format,n);
}

void
WrF(n, w, prec, exp)
LONGREAL n;
SHORTINT w;
SHORTCARD prec;
BOOLEAN exp;
{
  if (exp) {
    WrE(n,w,prec);
  } else {
    WrR(n,w,prec);
  }  
}

void
WrH(n, w)
LONGCARD n;
SHORTINT w;
{
  printf("%*x",w,n);
}

void
WrI(n, w)
LONGINT n;
SHORTINT w;
{ 
  printf("%*d",w,n);
}
 
void
WrNl()
{ 
  printf("\n");
}

void
WrO(n, w)
LONGCARD n;
SHORTINT w;
{
  printf("%*o",w,n);
}

void
WrR(n, w, prec)
LONGREAL n;
SHORTINT w;
SHORTCARD prec;
{
  char format[10];
  sprintf(format,"%%%d.%df",w,prec);
  printf(format,n);
}

void
WrS(s, l)
CHAR *s;
LONGCARD l;
{ 
  char format[10];
  sprintf(format,"%%.%ds",l);
  printf(format,s);
}  

BOOLEAN
RdB()
{
  CHAR ch;
  do {
    ch = RdCh();
  } while (ch != 'f' && ch != 'F' && ch != 't' && ch != 'T');
  return (ch == 't' || ch == 'T');
}

LONGCARD
RdC()
{ 
  LONGCARD c;
  scanf("%lu",&c);
  return c;
}

CHAR
RdCh()
{ 
  char ch;
  scanf("%c",&ch);
  return ch;
}

LONGCARD
RdH()
{ 
  LONGCARD c;
  scanf("%lx",&c);
  return c;
}

LONGINT
RdI()
{ 
  LONGINT i;
  scanf("%ld",&i);
  return i;
}

void
RdNl()
{
  do {
  } while (RdCh() != EolCh);
}

LONGCARD
RdO()
{ 
  LONGCARD c;
  scanf("%lo",&c);
  return c;
}

LONGREAL
RdR()
{
  LONGREAL r;
  scanf("%lf",&r);
  return r;
}

void
RdS(s, l)
CHAR *s;
LONGCARD l;
{
  scanf("%s",s);
}


/* plural PE routines */

plural void
p_0_WrB(b)
plural BOOLEAN b;
{
  if (b) {
    p_0_WrCh('T');
  } else {
    p_0_WrCh('F');
  }
}

plural void
p_0_WrC(n, w)
plural LONGCARD n;
plural SHORTINT w;
{
  p_printf("%*u",w,n);
}

plural void
p_0_WrCh(ch)
plural CHAR ch;
{ 
  p_printf("%c",ch);
}

plural void
p_0_WrE(n, w, prec)
plural LONGREAL n;
plural SHORTINT w;
plural SHORTCARD prec;
{
  plural char format[10];
  p_sprintf(format,"%%%d.%de",w,prec);
  p_printf(format,n);
}

plural void
p_0_WrF(n, w, prec, exp)
plural LONGREAL n;
plural SHORTINT w;
plural SHORTCARD prec;
plural BOOLEAN exp;
{
  if (exp) {
    p_0_WrE(n,w,prec);
  } else {
    p_0_WrR(n,w,prec);
  }  
}

plural void
p_0_WrH(n, w)
plural LONGCARD n;
plural SHORTINT w;
{
  p_printf("%*x",w,n);
}

plural void
p_0_WrI(n, w)
plural LONGINT n;
plural SHORTINT w;
{ 
  p_printf("%*d",w,n);
}
 
plural void
p_0_WrNl()
{ 
  p_printf("\n");
}

plural void
p_0_WrO(n, w)
plural LONGCARD n;
plural SHORTINT w;
{
  p_printf("%*o",w,n);
}

plural void
p_0_WrR(n, w, prec)
plural LONGREAL n;
plural SHORTINT w;
plural SHORTCARD prec;
{
  plural char format[10];
  p_sprintf(format,"%%%d.%df",w,prec);
  p_printf(format,n);
}

plural void
p_0_WrS(s, l)
plural CHAR *s;
plural LONGCARD l;
{ 
  plural char format[10];
  p_sprintf(format,"%%.%ds",l);
  p_printf(format,s);
}  

plural BOOLEAN
p_0_RdB()
{
  printf("p_0_RdB: not implemented yet\n");
  exit(IOExitValue);
}

plural LONGCARD
p_0_RdC()
{ 
  printf("p_0_RdC: not implemented yet\n");
  exit(IOExitValue);
}

plural CHAR
p_0_RdCh()
{
  printf("p_0_RdCh: not implemented yet\n");
  exit(IOExitValue);
}

plural LONGCARD
p_0_RdH()
{
  printf("p_0_RdH: not implemented yet\n");
  exit(IOExitValue);
}

plural LONGINT
p_0_RdI()
{ 
  printf("p_0_RdI: not implemented yet\n");
  exit(IOExitValue);
}

plural void
p_0_RdNl()
{
  printf("p_0_RdNl: not implemented yet\n");
  exit(IOExitValue);
}

plural LONGCARD
p_0_RdO()
{ 
  printf("p_0_RdO: not implemented yet\n");
  exit(IOExitValue);
}

plural LONGREAL
p_0_RdR()
{
  printf("p_0_RdR: not implemented yet\n");
  exit(IOExitValue);
}

plural void
p_0_RdS(s, l)
plural CHAR *s;
plural LONGCARD l;
{
  printf("p_0_RdS: not implemented yet\n");
  exit(IOExitValue);
}
