/*
 *  File I/O Library for Modula-2*
 *
 *
 *  Modula-2* interface by Hendrik Mager
 *
 *  C implementation by Hendirk Mager & Thomas Gauweiler
 *
 *  Last change:
 *
 *  06.02.1993	created 				[HM]
 *  29.11.1993	string handling with parameters		[TG]
 *  20.01.1994  only buffered routines are used		[TG]
 *  02.09.1994  dummy parallel routines			[TG]
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <errno.h>
/*#include <string.h>*/
/*#include <malloc.h> is already from system done */

#include "msFIO.MASP.h"

#define EolCh	'\n'
#define IOExitValue     -88


BOOLEAN
FEOF (F)
  File F;
  {
    return (feof((FILE *) F));
  }

LONGINT
FError (F)
  File F;
  {
    if (F != 0)
      return (ferror ((FILE *) F));
    else
      return (EBADF);	/* Bad file number */
  }

void
ClearError (F)
  File F;
  {
    if (F != 0)
      clearerr ((FILE *) F);
  }
     
void
Close (F)
  File F;
  {
    if (fclose ((FILE *) F) == EOF) {
     return;
    }
    else {
       return;
    } 
  }


File
Create (Name, l)
  CHAR *Name;
  LONGCARD l;
  {
    FILE *fileptr;
    char *CopName;
    CopName = malloc ((l+1) * sizeof (char));
    strncpy (CopName, Name, l);
    CopName[l] =0;
    
    if ((fileptr = fopen (CopName, "w+")) == NULL) {
      free (CopName);
      return (NIL);
    }
    else {
      free (CopName);
      return ((File) fileptr);
    }
  }

File
Open (Name, l)
  CHAR *Name;
  LONGCARD l;
  {
    FILE *fileptr;
    char *CopName;
    CopName = malloc ((l+1) * sizeof (char));
    strncpy (CopName, Name, l);
    CopName[l] = 0;
    
    if ((fileptr = fopen (CopName, "rw")) == NULL) {
      free (CopName);
      return (0);
    }
    else {
      free (CopName);
      return ((File) fileptr);
    }
  }

File
OpenRead (Name, l)
  CHAR *Name;
  LONGCARD l;
  {
    FILE *fileptr;
    char *CopName;
    CopName = malloc ((l+1) * sizeof (char));
    strncpy (CopName, Name, l);
    CopName[l] = 0;
    
    if ((fileptr = fopen (CopName, "r")) == NULL) {
      free (CopName);
      return ((File) NIL);
    }
    else {
      free (CopName);
      return ((File) fileptr);
    }
  }


void
Erase (Name, l)
  char *Name;
  LONGCARD l;
  {
    int error;
    char *CopName;
    CopName = malloc ((l+1) * sizeof (char));
    strncpy (CopName, Name, l);
    CopName[l] = 0;
/*    printf ("\n msFIO.Erase: N=<%s> CN=<%s> l=%d\n", Name, CopName, l); */
    error = unlink (CopName);
    free (CopName);
  }
  
BOOLEAN
Exists (Name, l)
  CHAR *Name;
  LONGCARD l;
  {
    FILE *fileptr;
    char *CopName;
    CopName = malloc ((l+1) * sizeof (char));
    strncpy (CopName, Name, l);
    CopName[l] = 0;
    if ((fileptr = fopen (CopName, "r")) == NULL) {
      free (CopName);
      return(0);
    }
    else {
      free (CopName);
      return(1);
    } 
  }

void
Flush (F)
  File F;
  {
    fflush ((FILE *) F);
  }

LONGINT
FGetPos (F)
  File F;
  {
    int pos;
    
/*    if ((pos =ftell ((FILE *) F)) == -1 ) {*/
    if ((fgetpos ((FILE *) F, &pos)) == -1 ) {
      return (-1);
    }
    else {
      return (pos);
    }
  }

LONGINT
Seek (F, Pos)
  File F;
  LONGCARD Pos;
  {
    int offset;

    fseek ((FILE *) F,(long) Pos, 0);
/*    offset = ftell((FILE *) F);*/
    fgetpos((FILE *) F, &offset);
/*    printf ("Seek: %d, %d\n", offset, ((FILE *) F)->_cnt);*/
    return (offset);
  }

LONGINT
FSize (F)
  File F;
  {
    long length, oldpos;

    oldpos = ftell ((FILE *) F);
    fseek ((FILE *) F, 0L, 2);
/*    length = ftell ((FILE *) F);*/
    fgetpos ((FILE *) F, &length);
    fseek ((FILE *) F, oldpos, 0);
    return (length);

  }


/* write routines */

void
FWrBin (F, Buf, n)
  File F;
  ADDRESS Buf;
  LONGCARD n;
  {
    fwrite ((char *) Buf, sizeof(char), n, (FILE *) F);
  }    
    
void
FWrB(F, B)
  File F;
  BOOLEAN B;
  {
    if (B) {
      FWrCh((FILE *) F, 'T');
    }
    else {
      FWrCh((FILE *) F, 'F');
    }
  }



void
FWrCh(F, Ch)
  File F;
  CHAR Ch;
  { 
    fprintf ((FILE *) F, "%c",Ch);
  }
  

    /* write integers */
    
void
FWrI(F, I, w)
  File F;
  LONGINT I;
  SHORTINT w;
  { 
    fprintf ((FILE *) F, "%*d",w,I);
  }


void
FWrC(F, C, w)
  File   F;
  LONGCARD C;
  SHORTINT w;
  {
    fprintf((FILE *) F,"%*u",w,C);
  }


void
FWrH(F, H, w)
  File F;
  LONGCARD H;
  SHORTINT w;
  {
    fprintf ((FILE *) F, "%*x",w,H);   
  }


void
FWrO(F, O, w)
  File F;
  LONGCARD O;
  SHORTINT w;
  {
    fprintf ((FILE *) F, "%*o",w,O);
  }

    /* write floating points */
void
FWrE(F, R, w, prec)
  File F;
  LONGREAL R;
  SHORTINT w;
  SHORTCARD prec;
  {
    char format[20];
    sprintf (format, "%%%d.%de",w,prec);
    fprintf ((FILE *) F, format,R);
  }

    
void
FWrR(F, R, w, prec)
  File F;
  LONGREAL R;
  SHORTINT w;
  SHORTCARD prec;
  {
    fprintf ((FILE *) F, "%*.*f",w,prec,R);
  }
    

void
FWrF(F, R, w, prec, exp)
  File F;
  LONGREAL R;
  SHORTINT w;
  SHORTCARD prec;
  BOOLEAN exp;
{
  if (exp) {
    FWrE((FILE *) F,R,w,prec);
  }
  else {
    FWrR((FILE *) F,R,w,prec);
  }  
}
 

void
FWrS(F, Str, l)
  CHAR *Str;
  LONGCARD l;
  { 
    char format[10];
    sprintf (format, "%%.%ds",l);
    fprintf ((FILE *) F, format,Str);
  }  


void
FWrNl(F)
  File F;
  { 
    fprintf ((FILE *) F, "\n");
  }


/* read routines */


void
FRdBin (F, Buf, n)
  File F;
  ADDRESS Buf;
  LONGCARD n;
  {
    fread ((char *) Buf, sizeof (char), n, (FILE *) F);
  }
     
BOOLEAN
FRdB(F)
  File F;
  {
    CHAR ch;
    do {
      ch = FRdCh((FILE *) F);
    } while (ch != 'f' && ch != 'F' && ch != 't' && ch != 'T');
    return (ch == 't' || ch == 'T');
  }

LONGCARD
FRdC(F)
  File F;
  { 
    LONGCARD c;
    fscanf((FILE *) F, "%lu",&c);
    return c;
  }

CHAR
FRdCh(F)
  File F;
  { 
    CHAR ch;
    fscanf((FILE *) F, "%c",&ch);
    return ch;
  }  

LONGCARD
FRdH(F)
  File F;
  { 
    LONGCARD c;
    fscanf((FILE *) F, "%lx",&c);
    return c;
  }

LONGINT
FRdI(F)
  File F;
  { 
    LONGINT i;
    fscanf((FILE *) F, "%ld",&i);
    return i;
  }

void
FRdNl(F)
  File F;
  {
    do {
    } while (FRdCh(F) != EolCh);
  }

LONGCARD
FRdO(F)
  File F;
  { 
    LONGCARD c;
    fscanf((FILE *) F, "%lo",&c);
    return c;
  }

LONGREAL
FRdR(F)
  File F;
  {
    LONGREAL r;
    fscanf((FILE *) F, "%lf",&r);
    return r;
  }

void
FRdS(F, s, l)
  File F;
  CHAR *s;
  LONGCARD l;
  { 
    fscanf((FILE *) F, "%s",s);
  }



plural BOOLEAN p_0_FEOF () 
{ 
  printf("p_0_FEOF: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural LONGINT p_0_FError () 
{ 
  printf("p_0_FError: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_ClearError () 
{ 
  printf("p_0_ClearError: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_Close() 
{ 
  printf("p_0_Close: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural File p_0_Create() 
{ 
  printf("p_0_Create: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_Erase() 
{ 
  printf("p_0_Erase: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural BOOLEAN p_0_Exists() 
{ 
  printf("p_0_Exists: not implemented yet\n"); 
  exit(IOExitValue); 
}
plural void p_0_Flush() 
{ 
  printf("p_0_Flush: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural LONGINT p_0_FGetPos() 
{ 
  printf("p_0_FGetPos: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural File p_0_Open() 
{ 
  printf("p_0_Open: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural File p_0_OpenRead() 
{ 
  printf("p_0_OpenRead: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural LONGINT p_0_Seek() 
{ 
  printf("p_0_Seek: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural LONGINT p_0_FSize() 
{ 
  printf("p_0_FSize: not implemented yet\n"); 
  exit(IOExitValue); 
}



/* note: buffered read -> unbuffered read:
         fread, fflush, read, fseek, fread, ... */
plural void p_0_FRdBin() 
{ 
  printf("p_0_FRdBin: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural BOOLEAN p_0_FRdB() 
{ 
  printf("p_0_FRdB: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural CHAR p_0_FRdCh() 
{ 
  printf("p_0_FRdCh: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural LONGCARD p_0_FRdC() 
{ 
  printf("p_0_FRdC: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural LONGCARD p_0_FRdH() 
{ 
  printf("p_0_FRdH: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural LONGINT p_0_FRdI() 
{ 
  printf("p_0_FRdI: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FRdNl() 
{ 
  printf("p_0_FRdNl: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural LONGCARD p_0_FRdO() 
{ 
  printf("p_0_FRdO: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural LONGREAL p_0_FRdR() 
{ 
  printf("p_0_FRdR: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FRdS() 
{ 
  printf("p_0_FRdS: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrBin() 
{ 
  printf("p_0_FRdBin: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrB() 
{ 
  printf("p_0_FRdB: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrCh() 
{ 
  printf("p_0_FWrCh: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrC() 
{ 
  printf("p_0_FWrC: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrH() 
{ 
  printf("p_0_FWrH: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrI() 
{ 
  printf("p_0_FWrI: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrNl() 
{ 
  printf("p_0_FWrNl: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrO() 
{ 
  printf("p_0_FWrO: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrR() 
{ 
  printf("p_0_FWrR: not implemented yet\n"); 
  exit(IOExitValue); 
}

plural void p_0_FWrS() 
{ 
  printf("p_0_FWrS: not implemented yet\n"); 
  exit(IOExitValue); 
}
