
/*
 *  Enumeration Library for Modula-2*
 *
 *  allows for efficient enumeration operations
 *  on arbitrarily large and distributed arrays
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change: 15.10.1992
 */

#include "msEnum.MASP.h"
#include <stdio.h>


#define EnumExitValue -88

#define EnumShiftRight(val)	\
    val = xnetW[1].val;		\
    if (ixproc==0)		\
      val = xnetN[1].val;

#define EnumRotateRight(elemType,val)	\
    {					\
      register elemType tmp;		\
					\
      /* wrap around ? */		\
      if (globalor(seg))		\
        tmp = proc[pe].val;		\
      else				\
        tmp = 0;			\
					\
      EnumShiftRight(val);		\
      proc[0].val = tmp;		\
    };

#define SCalcEnum(elemType)	\
    l = lx / sizeof(elemType);	\
    k = nx % l;			\
    pe = nx / l;		\
    if (k==0) {			\
      k = l;			\
      pe--;			\
    };
/*
    printf("nx = %u  l = %i  k = %i  pe = %i \n",nx,l,k,pe);
*/


/*
 *  masked enumeration routines for 1-dimensional spread arrays
 *  (singular versions)
 */

#define SLocalMaskEnum			\
    maskp = mask;			\
    num = 0;				\
    if (iproc<=pe)			\
      for (j=1; j<=k; j++, maskp++)	\
        if (*maskp)			\
	  num++;			\
    if (k<l)				\
      if (iproc<pe)			\
        for (j=k+1; j<=l; j++, maskp++)	\
          if (*maskp)			\
	    num++;

#define SGlobalMaskEnum(scanAddFunc)		\
    maskp = mask;				\
    proc[0].num = 0;				\
    if (iproc<=pe) {				\
      num = scanAddFunc(num,			\
	    		(plural char)0);	\
      for (j=1; j<=k; j++, maskp++, x++)	\
        if (*maskp)				\
	  *x = num++;				\
    };						\
    if (k<l)					\
      if (iproc<pe)				\
        for (j=k+1; j<=l; j++, maskp++, x++)	\
          if (*maskp)				\
	    *x = num++;

#define SMaskEnumFunc(funcName,elemType,scanAddFunc) \
    void					     \
    funcName(mask, nm, lm, x, nx, lx)		     \
    plural BOOLEAN *mask;			     \
    LONGCARD nm, lm;				     \
    register plural elemType *x;		     \
    LONGCARD nx, lx;				     \
    {						     \
      register plural elemType num;		     \
      register plural BOOLEAN *maskp;		     \
      register int j, k, l, pe;			     \
						     \
      if (nx!=nm) return;			     \
						     \
      SCalcEnum(elemType);			     \
      all {					     \
        SLocalMaskEnum;				     \
	EnumShiftRight(num);			     \
	SGlobalMaskEnum(scanAddFunc);		     \
      }						     \
    }

SMaskEnumFunc( SMaskEnumCh, CHAR,      scanAdd8u  )
SMaskEnumFunc( SMaskEnumSC, SHORTCARD, scanAdd16u )
SMaskEnumFunc( SMaskEnumC,  CARDINAL,  scanAdd32u )
SMaskEnumFunc( SMaskEnumSI, SHORTINT,  scanAdd16  )
SMaskEnumFunc( SMaskEnumI,  INTEGER,   scanAdd32  )
SMaskEnumFunc( SMaskEnumR,  REAL,      scanAddf   )
SMaskEnumFunc( SMaskEnumLR, LONGREAL,  scanAddd   )


/*
 *  segmented enumeration routines for 1-dimensional spread arrays
 *  (singular versions)
 */

#define SLocalSegEnum			      \
    num = 0;				      \
    seg = 1;				      \
    if (k<l)				      \
      if (iproc<pe)			      \
	segp = &segs[l-1];		      \
        for (j=l; j>k && globalor(seg); j--)  \
	  if (seg)			      \
            if (*segp--)		      \
	      seg = 0;			      \
	    else			      \
	      num++;			      \
    if (iproc<=pe && seg)		      \
      segp = &segs[k-1];		      \
      for (j=k; j>0 && globalor(seg); j--)    \
        if (seg)			      \
          if (*segp--)			      \
	    seg = 0;			      \
	  else				      \
	    num++;			      \
    seg = !seg;

#define SGlobalSegEnum(scanAddFunc)		\
    segp = segs;				\
    if (iproc<=pe) {				\
      num = scanAddFunc(num,seg);		\
      for (j=1; j<=k; j++, segp++, x++) {	\
	*x = num++;				\
        if (*segp)				\
	  num = 0;				\
      }						\
    };						\
    if (k<l)					\
      if (iproc<pe)				\
        for (j=k+1; j<=l; j++, segp++, x++) {	\
	  *x = num++;				\
          if (*segp)				\
	    num = 0;				\
        };

#define SSegEnumFunc(funcName,elemType,scanAddFunc) \
    void					   \
    funcName(segs, ns, ls, x, nx, lx)		   \
    plural BOOLEAN *segs;			   \
    LONGCARD ns, ls;				   \
    register plural elemType *x;		   \
    LONGCARD nx, lx;				   \
    {						   \
      register plural BOOLEAN *segp;		   \
      register plural elemType num;		   \
      register plural char seg;			   \
      register int j, k, l, pe;			   \
						   \
      if (nx!=ns) return;			   \
						   \
      SCalcEnum(elemType);			   \
      all {					   \
        SLocalSegEnum;				   \
	EnumRotateRight(elemType,num);		   \
	SGlobalSegEnum(scanAddFunc);		   \
      }						   \
    }

SSegEnumFunc( SSegEnumCh, CHAR,	     scanAdd8u  )
SSegEnumFunc( SSegEnumSC, SHORTCARD, scanAdd16u )
SSegEnumFunc( SSegEnumC,  CARDINAL,  scanAdd32u )
SSegEnumFunc( SSegEnumSI, SHORTINT,  scanAdd16  )
SSegEnumFunc( SSegEnumI,  INTEGER,   scanAdd32  )
SSegEnumFunc( SSegEnumR,  REAL,	     scanAddf   )
SSegEnumFunc( SSegEnumLR, LONGREAL,  scanAddd   )


/*
 *  universal enumeration routines for 1-dimensional spread arrays
 *  (singular versions)
 */

#define SLocalUnivEnum			      \
    num = 0;				      \
    seg = 1;				      \
    if (k<l)				      \
      if (iproc<pe)			      \
	maskp = &mask[l-1];		      \
	segp = &segs[l-1];		      \
        for (j=l; j>k && globalor(seg); j--)  \
	  if (seg)			      \
            if (*segp--)		      \
	      seg = 0;			      \
	    else if (*maskp--)		      \
	      num++;			      \
    if (iproc<=pe && seg)		      \
      maskp = &mask[k-1];		      \
      segp = &segs[k-1];		      \
      for (j=k; j>0 && globalor(seg); j--)    \
        if (seg)			      \
          if (*segp--)			      \
	    seg = 0;			      \
	  else if (*maskp--)		      \
	    num++;			      \
    seg = !seg;

#define SGlobalUnivEnum(scanAddFunc)			\
    maskp = mask;					\
    segp = segs;					\
    if (iproc<=pe) {					\
      num = scanAddFunc(num,seg);			\
      for (j=1; j<=k; j++, maskp++, segp++, x++) {	\
	if (*maskp)					\
	  *x = num++;					\
        if (*segp)					\
	  num = 0;					\
      }							\
    };							\
    if (k<l)						\
      if (iproc<pe)					\
        for (j=k+1; j<=l; j++, maskp++, segp++, x++) {	\
	  if (*maskp)					\
	    *x = num++;					\
          if (*segp)					\
	    num = 0;					\
        };

#define SUnivEnumFunc(funcName,elemType,scanAddFunc) \
    void					     \
    funcName(mask, nm, lm, segs, ns, ls, x, nx, lx)  \
    plural BOOLEAN *mask;			     \
    LONGCARD nm, lm;				     \
    plural BOOLEAN *segs;			     \
    LONGCARD ns, ls;				     \
    register plural elemType *x;		     \
    LONGCARD nx, lx;				     \
    {						     \
      register plural BOOLEAN *maskp, *segp;	     \
      register plural elemType num;		     \
      register plural char seg;			     \
      register int j, k, l, pe;			     \
						     \
      if (nx!=nm || nx!=ns) return;		     \
						     \
      SCalcEnum(elemType);			     \
      all {					     \
        SLocalUnivEnum;				     \
	EnumRotateRight(elemType,num);		     \
	SGlobalUnivEnum(scanAddFunc);		     \
      }						     \
    }

SUnivEnumFunc( SUnivEnumCh, CHAR,      scanAdd8u  )
SUnivEnumFunc( SUnivEnumSC, SHORTCARD, scanAdd16u )
SUnivEnumFunc( SUnivEnumC,  CARDINAL,  scanAdd32u )
SUnivEnumFunc( SUnivEnumSI, SHORTINT,  scanAdd16  )
SUnivEnumFunc( SUnivEnumI,  INTEGER,   scanAdd32  )
SUnivEnumFunc( SUnivEnumR,  REAL,      scanAddf   )
SUnivEnumFunc( SUnivEnumLR, LONGREAL,  scanAddd   )


/*
 *  masked enumeration routines for 1-dimensional spread arrays
 *  (plural versions)
 */

#define pSMaskEnumFunc(funcName,funcNameString,elemType,scanAddFunc) \
    plural void					\
    funcName(mask, nm, lm, x, nx, lx)		\
    plural BOOLEAN *plural mask;		\
    plural LONGCARD nm, lm;			\
    plural elemType *plural x;			\
    plural LONGCARD nx, lx;			\
    {						\
      printf(funcNameString);			\
      printf(": not implemented yet\n");	\
      exit(EnumExitValue);			\
    }

pSMaskEnumFunc( p_0_SMaskEnumCh, "p_0_SMaskEnumCh", CHAR,      scanAdd8u  )
pSMaskEnumFunc( p_0_SMaskEnumSC, "p_0_SMaskEnumSC", SHORTCARD, scanAdd16u )
pSMaskEnumFunc( p_0_SMaskEnumC,	 "p_0_SMaskEnumC",  CARDINAL,  scanAdd32u )
pSMaskEnumFunc( p_0_SMaskEnumSI, "p_0_SMaskEnumSI", SHORTINT,  scanAdd16  )
pSMaskEnumFunc( p_0_SMaskEnumI,	 "p_0_SMaskEnumI",  INTEGER,   scanAdd32  )
pSMaskEnumFunc( p_0_SMaskEnumR,	 "p_0_SMaskEnumR",  REAL,      scanAddf   )
pSMaskEnumFunc( p_0_SMaskEnumLR, "p_0_SMaskEnumLR", LONGREAL,  scanAddd   )


/*
 *  segmented enumeration routines for 1-dimensional spread arrays
 *  (plural versions)
 */

#define pSSegEnumFunc(funcName,funcNameString,elemType,scanAddFunc) \
    plural void					\
    funcName(segs, ns, ls, x, nx, lx)		\
    plural BOOLEAN *plural segs;		\
    plural LONGCARD ns, ls;			\
    plural elemType *plural x;			\
    plural LONGCARD nx, lx;			\
    {						\
      printf(funcNameString);			\
      printf(": not implemented yet\n");	\
      exit(EnumExitValue);			\
    }

pSSegEnumFunc( p_0_SSegEnumCh, "p_0_SSegEnumCh", CHAR,      scanAdd8u  )
pSSegEnumFunc( p_0_SSegEnumSC, "p_0_SSegEnumSC", SHORTCARD, scanAdd16u )
pSSegEnumFunc( p_0_SSegEnumC,  "p_0_SSegEnumC",	 CARDINAL,  scanAdd32u )
pSSegEnumFunc( p_0_SSegEnumSI, "p_0_SSegEnumSI", SHORTINT,  scanAdd16  )
pSSegEnumFunc( p_0_SSegEnumI,  "p_0_SSegEnumI",	 INTEGER,   scanAdd32  )
pSSegEnumFunc( p_0_SSegEnumR,  "p_0_SSegEnumR",	 REAL,      scanAddf   )
pSSegEnumFunc( p_0_SSegEnumLR, "p_0_SSegEnumLR", LONGREAL,  scanAddd   )


/*
 *  universal enumeration routines for 1-dimensional spread arrays
 *  (plural versions)
 */

#define pSUnivEnumFunc(funcName,funcNameString,elemType,scanAddFunc) \
    plural void					\
    funcName(mask, nm, lm, segs, ns, ls, x, nx, lx)  \
    plural BOOLEAN *plural mask;		\
    plural LONGCARD nm, lm;			\
    plural BOOLEAN *plural segs;		\
    plural LONGCARD ns, ls;			\
    plural elemType *plural x;			\
    plural LONGCARD nx, lx;			\
    {						\
      printf(funcNameString);			\
      printf(": not implemented yet\n");	\
      exit(EnumExitValue);			\
    }

pSUnivEnumFunc( p_0_SUnivEnumCh, "p_0_SUnivEnumCh", CHAR,      scanAdd8u  )
pSUnivEnumFunc( p_0_SUnivEnumSC, "p_0_SUnivEnumSC", SHORTCARD, scanAdd16u )
pSUnivEnumFunc( p_0_SUnivEnumC,	 "p_0_SUnivEnumC",  CARDINAL,  scanAdd32u )
pSUnivEnumFunc( p_0_SUnivEnumSI, "p_0_SUnivEnumSI", SHORTINT,  scanAdd16  )
pSUnivEnumFunc( p_0_SUnivEnumI,	 "p_0_SUnivEnumI",  INTEGER,   scanAdd32  )
pSUnivEnumFunc( p_0_SUnivEnumR,	 "p_0_SUnivEnumR",  REAL,      scanAddf   )
pSUnivEnumFunc( p_0_SUnivEnumLR, "p_0_SUnivEnumLR", LONGREAL,  scanAddd   )
