#include <stdio.h>
#include <stdlib.h>
#include <time.h>

/* from Numerical Recipes: The Art of Scientific Computing */

#define M 714025
#define IA 1366
#define IC 150889

float ran2(idum)
long *idum;
{
      static long iy,ir[98];
      static int iff=0;
      int j;
      void nrerror();

      if (*idum < 0 || iff == 0) {
              iff=1;
              if ((*idum=(IC-(*idum)) % M) < 0) *idum = -(*idum);
              for (j=1;j<=97;j++) {
                      *idum=(IA*(*idum)+IC) % M;
                      ir[j]=(*idum);
              }
              *idum=(IA*(*idum)+IC) % M;
              iy=(*idum);
    }
      j=1 + 97.0*iy/M;
      if (j > 97 || j < 1) exit();
      iy=ir[j];
      *idum=(IA*(*idum)+IC) % M;
      ir[j]=(*idum);
      return (float) iy/M;
}

int GenRand(off,var,seed)
int off;
int var;
long *seed;
{
   int temp;
   temp = off+ (int) (ran2(seed) * var);
   return temp;
}

void swap_PW(P,W,i,j)
int *P;
int *W;
int i;
int j;
{
   int temp;
   temp = P[i];
   P[i] = P[j];
   P[j] = temp;
   temp = W[i];
   W[i] = W[j];
   W[j] = temp;
}

void sort_PW(P,W,n)
int *P;
int *W;
int n;
{
   int i,j;
   float maxPW = 0.0;
   int maxPWindex;

   for(j=0;j<n;j++){
      for(i=j;i<n;i++){
         if( (float)P[i]/(float)W[i] > maxPW){
            maxPW = (float)P[i]/(float)W[i];
            maxPWindex = i;
         }
      }
      swap_PW(P,W,maxPWindex,j);
      maxPW = 0.0;
   }
}

void main(argc,argv)
int argc;
char **argv;

{  int n, cap, c;
   int *P, *W;
   int i,j;
   int total_weight=0;

   long iseed;
   long *seed;

   if(argc < 3) { printf("More parameters please\nFirst param: Number of objects, second param: int seed for random numbers\n"); exit(0); }

   sscanf(argv[1],"%d",&n);
   if(n<1) { printf("Bad amount of objects parameter\n"); exit(0); }

   sscanf(argv[2],"%d",&iseed);
   seed = &iseed;
 
   cap = 10;
   for(i=0;i<=(n/20);i++) cap = cap*10;

   P = (int *)malloc(sizeof(int)*n);
   W = (int *)malloc(sizeof(int)*n);

   c = cap;
   for(i=0;i<(n/10);i++){
   c = c/3;
   for(j=0;j<10;j++){
      W[10*i+j] = c + GenRand(1,n-10*i,seed);
      P[10*i+j] = (n/10+1-i)* W[10*i+j] + GenRand(1,10,seed);
    }
   };

   sort_PW(P,W,n);
   printf("n = %d; cap = %d;\n\n",n, cap);
   printf("P = {1d_array (1,%d) of \n", n);
   for(i=0;i<n;i++) printf("%d ", P[i]); printf("};\n\n");
   printf("W = {1d_array (1,%d) of \n", n);
   for(i=0;i<n;i++) printf("%d ", W[i]); printf("};\n\n");
   free(P);
   free(W);

}
