cccccccccccccccccccccccc
c
c      hydflo.h
c
cccccccccccccccccccccccc        
c
c      dimensions for arrays
c           NQ      Problem size is NQ   x NQ   x NQ
c           NQP     Mesh    size is NQP  x NQP  x NQP
c           NQPX    Memory  size is NQPX x NQPX x NQPX
c
      integer   NQ,NQP
      
c Run full problem 100+ Mbytes min 4 nodes
C 48 is the verification problem size
c     parameter (NQ=48, NQP=NQ+2, NQPX=NQP)
c     parameter (NQ=30, NQP=NQ+2, NQPX=NQP)

C 16 sized problem runs fast, also has verification results
C is runnable on a single node
!      parameter (NQ=32, NQP=NQ+2, NQPX=NQP)
       parameter (NQ=24, NQP=NQ+2, NQPX=NQP)
!      parameter (NQ=16, NQP=NQ+2, NQPX=NQP)
!      parameter (NQ=8, NQP=NQ+2, NQPX=NQP)

C 78 problem will run on 20 nodes
C     parameter (NQ=62, NQP=NQ+2, NQPX=NQP)    
C     parameter (NQ=78, NQP=NQ+2, NQPX=NQP)    

C 94 is a good size for 32 node machine 
C (around 30Mb/node)
C     parameter (NQ=94, NQP=NQ+2, NQPX=NQP)    

C Could also run a larger problem on 32 nodes
C (Maybe 100 ?)
C     parameter (NQ=100, NQP=NQ+2, NQPX=NQP)

C 4 nodes with tiddly space and big exchanges
C     parameter (NQ=100, NQP=100, NQPX=12)    

c
c      physical constants
c
      real*8    GAM,GAMM1
      parameter (GAM=5.0d0/3.0d0,GAMM1=GAM-1.0d0)
      real*8    GX,GY,GZ
      parameter (GX=0.0d0,GY=0.0d0,GZ=-0.0125d0)
c
c      message types, etc.
c
      integer   WE,EW,SN,NS
      parameter (WE=10000,EW=20000,SN=30000,NS=40000)
      integer   CNTL
      parameter (CNTL=0)
      integer   INIT
      parameter (INIT=5)
      integer   NPS,NPSS
      parameter (NPS=1, NPSS=NPS*NPS)
      integer   NK,NKP
      parameter (NK=NQ*NPS, NKP=NK+2, NKPX=NKP)
      integer   NL,NLU
      parameter (NL=NQP*NKP, NLU=5*NL)
      integer   MJ,MK,MB
      parameter (MJ=NQP, MK=NQP*NQP, MB=NKP*MK)
      integer   MBU,MBG
      parameter (MBU=5*MB, MBG=3*MB)
      integer   MJP,MJM,MKP,MKM,MJKP,MJKM
      parameter (MJP=MJ+1, MJM=MJ-1, MKP=MK+1)
      parameter (MKM=MK-1, MJKP=MJ+MK, MJKM=MJ-MK)
cc
ccccccccccccccccccc
!hpf$  template T (NQPX, NQPX, NKPX)

C Data distribution choice made here
C Choose one of the following lines.
C *,*,BLOCK appears to be very slightly the best
C !hpf$  distribute T (BLOCK, *, *)
C !hpf$  distribute T (*,BLOCK,*)
!hpf$  distribute T (*,BLOCK,BLOCK)
C !hpf$  distribute T (*,cyclic,cyclic)
c     
