/*************************************************************************
*                                                                        *
*  Name : gmdhpfglobal.h                                                 *
*                                                                        *
*  Purpose : declaration of global data for gmdhpf (driver for ADAPTOR)  *
*                                                                        *
*  Author : Resi Hoever-Klier, GMD, SCAI.LAB                             *
*                                                                        *
*  Last Update : Feb  1998                                               *
*                                                                        *
*  Updates                                                               *
*  =======                                                               *
*                                                                        *
*    02/98 compilation for multiprocessing                               *
*                                                                        *
*************************************************************************/

# include "ratc.h"

          /*************************************************
          *                                                *
          *  DRIVER  FLAGS                                 *
          *                                                *
          *************************************************/

extern char    ADPRC_FILES[];          /* names of configuration files */

/*#define FADAPT_PREFIX "ADP"*/
#define FADAPT_PREFIX ""

extern int     no_input_files;
extern char ** input_file_name;    /* many files */
extern char ** ld_input_file;      /* many files */

extern int     no_generated_files;
extern int     file_factor;  /* how many filenames to gener. from 1 inputfile*/
extern char *  generated_file_names;    /* names of many files */

extern char    output_file_name[];   /* only one file */

extern int verbose_flag;
extern int dryrun_flag;     /* show commands and files but don't exec */
extern int keep_flag;       /* do not delete intermediate files (gmdhpf) */

extern int ld_flag;         /* invoke linker or not */
extern int uniproc_flag;    /* generate single node program or not */
 
extern int list_flag;       /* generate listfile of fadapt messages */


          /*************************************************
          *                                                *
          *  TARGET MACHINE                                *
          *                                                *
          *************************************************/

extern int no_machine;            /* number of entries of machine_items */
extern char *machine_items   [];  /* character description of machine   */
extern char *machine_options [];  /* option for choosing machine item   */
extern int target_machine;        /* value of target_machine            */

/* possible values for target_machine, must be conform to the
   machine items and machine options defined in global.c        */

#define NO_MACHINES 20

#define CM5       0
#define PGON      1
#define CS        2
#define KSR       3
#define RS6K      4
#define SUN4      5
#define SUN4SOL2  6
#define SGI       7
#define I860      8
#define HPPA      9
#define ALPHA     10
#define PPC       11
#define CENJU3    12
#define CRAY_MPP  13
#define CRAY_T3E  14
#define LINUX     15
#define SX4       16
#define VPP       17
#define CONVEX    18
#define NEW       19

          /*************************************************
          *                                                *
          *  TARGET COMMUNICATION                          *
          *                                                *
          *************************************************/

extern int no_communication;             /* number of possible entries */
extern char *communication_items   [];   /* descriptions of entries    */
extern char *communication_options [];   /* correpsonding option       */
extern int target_communication;         /* selected entry             */

/* possible values for target_communication, must be conform to
   the corresponding descriptions specified in global.c          */

#define NATIVE   0
#define MPI      1
#define PVM3     2
#define SHM      3

          
          /*************************************************
          *                                                *
          *  PHOME Directory                               *
          *                                                *
          *************************************************/

extern char PHOME [160];          /* home directory of ADAPTOR */


/* machine parameters for different machines */

          /*************************************************
          *                                                *
          *  PREDEFINED VALUES for VARIABLES               *
          *                                                *
          *    (machine-, installation-dependent)          *
          *                                                *
          *************************************************/

#define predefined_target_machine        SUN4SOL2
#define predefined_target_communication  PVM3

#define PHOME_envvar     "PHOME"

 
          /*************************************************
          *                                                *
          *  Global Variables for the Customization        *
          *                                                *
          *************************************************/

extern char CPP[];     /* cpp for adaptor */
extern char CPP_OPT[]; /* options for cpp for adaptor */
extern char FADAPT[];  /* adaptor */
extern char GENLIST[]; /* genlist */
extern char FADAPT_OPT[]; /* options for adaptor */
extern char FADAPT_MP[];  /* multiprocessing option for adaptor */
extern char FC[];     /* FORTRAN-Compiler */
extern char FC_OPT[];    /* options for fc */
extern char FC_MP[];    /* options for fc */
extern char LD[];     /* linker for cube-program */
extern char LD_OPT[]; /* linker-flags */
extern char LD_MP[]; /* linker-flags */
extern char LD1[];    /* linker for single-node-program */
extern char LD1_OPT[]; /* linker-flags */
extern char LD1_MP[]; /* linker-flags */

extern int USER_DEFINED_DALIB_FLAG; /*dalib-name defined in .adprc-f. or not*/
extern char DALIB[];  /* directory of adaptor's implementation for this mach.*/

extern char MESS_PASS_LIB[];  /* routines for choosen mess.pass.sys. fe PVM */
extern char MPI_LIB[];  /* routines for MPI */
extern char PVM_LIB[];  /* routines for PVM */
extern char SHM_LIB[];  /* routines for SHM */
 
extern char *environment [NO_MACHINES][13];


extern int INITIALIZED_FLAG;  /* 1 if fadapt called by gmdhpf */

#define predefined_FADAPT "$PHOME/bin/fadapt"
#define predefined_DALIB   "$PHOME/dalib"
#define predefined_MPI_LIB ""
/* VPP : /usr/lang/mpi/lib/libmpi.a /usr/lang/mpi/lib/libmp.a */

#define predefined_PVM_LIB "$PVM_ROOT/lib/$PVM_ARCH/libpvm3.a"
#define predefined_SHM_LIB "$SHM_ROOT/lib/$ARCH/libshm.a"

/* maximal number of character for directory, FC, LD, ... */

#define MAXPATHLEN 128

/***********************************************************************
*                                                                      *
*  <machine_env>  { CPP, CPP_OPT,                                      *
*                   FADAPT_OPT, FADAPT_MP,                             *
*                   FC, FC_OPT, FC_MP,                                 *
*                   LD, LD_OPT, LD_MP,                                 *
*                   LD1, LD1_OPT, LD1_MP }                             *
*                                                                      *
***********************************************************************/

#define CM5_env  { "cpp", "", \
                   "", "", \
                   "f77", "-O -e -f -w", "", \
                   "f77", "", "", \
                   "f77", "" ,""  }

#define PGON_env { "cpp", "", \
                   "", "", \
                   "if77", "-O -Mvect -Knoieee -Mextend", "", \
                   "if77", "", "" \
                   "if77", "", "" }

#define CS_env   { "cpp", "", \
                   "", "", \
                   "f77", "-O -e -f -w", "", \
                   "f77", "-L/opt/MEIKOcs2/lib -lmpsc -lew -lelan", "", \
                   "f77", "", "" }

#define KSR_env   { "cpp", "", \
                    "", "", \
                    "f77", "-O2 -i4 -r8", "", \
                    "f77", "", "", \
                    "f77", "" , "" }

#define RS6K_env  { "cpp", "-P", \
                    "", "", \
                    "xlf", "-O3 -qstrict -w", "", \
                    "mpxlf", "", "", \
                    "xlf", "" , "" }

#define SUN4_env  { "cpp", "", \
                    "", "", \
                    "f77", "-O -e -f -w", "", \
                    "f77", "", "", \
                    "f77", "" , "" }

#define SUN4SOL2_env  { "cpp", "-P", \
                        "", "-mp=sun", \
                        "f77", "-O -e -f -w", "-explicitpar", \
                        "f77", "-lnsl -lsocket", "-explicitpar", \
                        "f77", "" , "-explicitpar" }

#define SGI_env  { "cpp", "", \
                   "", "-mp=cray", \
                   "f90", "-O3 -mips4 -extend_source -w", "-cray_mp", \
                   "f90", "", "-cray_mp", \
                   "f90", "" , "-cray_mp" }

#define I860_env  { "cpp", "", \
                    "", "", \
                    "if77", "-O -Mvect -Knoieee -Mextend", "", \
                    "if77", "", "", \
                    "if77", "" , "" }

#define HPPA_env  { "cpp", "", \
                    "", "", \
                    "fort77", "-O +es -w +U77", "", \
                    "fort77", "", "", \
                    "fort77", "" , "" }

#define ALPHA_env { "cpp", "", \
                    "", "", \
                    "f77", "-O", "", \
                    "f77", "", "", \
                    "f77", "" , "" }

#define PPC_env   { "cpp", "", \
                    "", "", \
                    "f77.px", "-O -e -f -w", "", \
                    "f77.px", "", "", \
                    "f77.px", "", "" }

#define CENJU3_env { "cpp", "-P", \
                     "", "", \
                     "cjf77", "-O -w -Zextend_source", "", \
                     "cjf77", "", "", \
                     "cjf77", "", "" }

#define CRAY_T3D_env { "cpp", "", \
                       "", "", \
                       "cf77", "-Wf\"-e v\" -Oscalar3 -Ccray-t3d", "", \
                       "cf77", "-Ccray-t3d", "", \
                       "cf77", "-Ccray-t3d" , "" }

#define CRAY_T3E_env { "cpp", "-P", \
                       "", "", \
                       "f90", "-O3 -N132", "", \
                       "f90", "-Xm", "", \
                       "f90", "" , "" }

#define LINUX_env  { "cpp", "", \
                     "", "", \
                     "f77", "-O -e -f -w", "", \
                     "f77", "", "", \
                     "f77", "" , "" }

#define SX4_env { "cpp", "", \
                  "", "", \
                  "f90", "-float0", "", \
                  "f90", "-float0", "", \
                  "f90", "-float0" , "" }

#define VPP_env { "frt", "-Cpp -Wp,-P", \
                  "", "", \
                  "frt", "-w", "", \
                  "frt", "", "", \
                  "frt", "-Wl,-P" , "" }

#define CONVEX_env { "cpp", "", \
                  "", "", \
                  "f90", "-O +es -w +U77", "", \
                  "mpif90", "", "", \
                  "f90", "" , "" }

#define NEW_env { "cpp", "", \
                  "", "", \
                  "f77", "-O -e -f -w", "", \
                  "f77", "", "", \
                  "f77", "" , "" }
 
#define VERSION_STRING "GMDHPF 2.0 (Jan 1998)"
