/* $Id: rSystem.c,v 1.28 1998/02/18 09:41:27 grosch rel $ */

/* $Log:
 */

/* Ich, Doktor Josef Grosch, Informatiker, Jan. 1992 */

/* interface for machine dependencies */

/* compilation with the option -DUNIX uses UNIX system calls for IO (efficient),
   otherwise the C library routines are used for IO (portable).		*/

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef rbool
# define rbool char
# endif
# define tFile int

# ifdef m68000
# define rticks 50
# else
#    ifdef linux
#    define rticks 100
#    else
#    define rticks 60
#    endif
# endif

# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

/* binary IO */

extern tFile	OpenInput	ARGS ((char * FileName));
			/* Opens the file whose name is given by the	*/
			/* string parameter 'FileName' for input.	*/
			/* Returns an integer file descriptor.		*/

extern tFile	OpenOutput	ARGS ((char * FileName));
			/* Opens the file whose name is given by the	*/
			/* string parameter 'FileName' for output.	*/
			/* Returns an integer file descriptor.		*/

extern int	rRead		ARGS ((tFile File, char * Buffer, int Size));
			/* Reads 'Size' bytes from file 'tFile' and	*/
			/* stores them in a buffer starting at address	*/
			/* 'Buffer'.					*/
			/* Returns the number of bytes actually read.	*/

extern int	rWrite		ARGS ((tFile File, char * Buffer, int Size));
			/* Writes 'Size' bytes from a buffer starting	*/
			/* at address 'Buffer' to file 'tFile'.		*/
			/* Returns the number of bytes actually written.*/

extern void	rClose		ARGS ((tFile File));
			/* Closes file 'tFile'.				*/

extern rbool IsCharacterSpecial	ARGS ((tFile File));
			/* Returns TRUE when file 'tFile' is connected	*/
			/* to a character device like a terminal.	*/

extern char  DirectorySeparator	ARGS ((void));
			/* Returns '\' under Windows otherwise '/'.	*/


/* calls other than IO */

extern char *	rAlloc		ARGS ((long ByteCount));
			/* Returns a pointer to dynamically allocated	*/
			/* memory space of size 'ByteCount' bytes.	*/
			/* Returns NIL if space is exhausted.		*/

extern void	rFree		ARGS ((char * ptr));
			/* The memory space allocated at 'ptr' is released. */

extern long	rTime		ARGS ((void));
			/* Returns consumed cpu-time in milliseconds.	*/

extern	char *	rtpqx		ARGS ((char *));

extern int	GetArgCount	ARGS ((void));
			/* Returns number of arguments.			*/

extern void	GetArgument	ARGS ((int ArgNum, char * Argument));
			/* Stores a string-valued argument whose index	*/
			/* is 'ArgNum' in the memory area 'Argument'.	*/

extern char *	GetEnvVar	ARGS ((char * Name));
			/* Returns a pointer to the environment		*/
			/* variable named 'Name'.			*/

extern void	PutArgs		ARGS ((int Argc, char * * Argv));
			/* Dummy procedure that passes the values	*/
			/* 'argc' and 'argv' from Modula-2 to C.	*/

extern int	rErrNo		ARGS ((void));
			/* Returns the current system error code.	*/

extern int	rSystem		ARGS ((char * String));
			/* Executes an operating system command given	*/
			/* as the string 'String'. Returns an exit or	*/
			/* return code.					*/

extern void	rExit		ARGS ((int Status));
			/* Terminates program execution and passes the	*/
			/* value 'Status' to the operating system.	*/

extern void	BEGIN_System	ARGS ((void));
			/* Dummy procedure with empty body.		*/

# if defined _MSC_VER | defined MSDOS | defined __BORLANDC__
#    define _MS_
# endif

# include "Reuse.h"
# if HAVE_STDLIB_H | defined _MS_
#    include <stdlib.h>
# endif

# ifdef UNIX
# if HAVE_UNISTD_H
#    include <unistd.h>
# endif
# else

# ifdef __cplusplus
extern "C" {
# include <stdio.h>
}
# else
# include <stdio.h>
# endif

# define NOFILES 64

static rbool IsInitialized = rfalse;

static char IsLineBuffered [NOFILES] = { 1, 1, 1, };

static FILE *	FileStore [NOFILES] = {
   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
   NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
};

static void InitFileStore ARGS ((void))
{
   FileStore [0] = stdin;
   FileStore [1] = stdout;
   FileStore [2] = stderr;
   IsInitialized = rtrue;
}

static tFile FileToInt
# if defined __STDC__ | defined __cplusplus
   (FILE * File)
# else
   (File) FILE * File;
# endif
{
   register int	f = fileno (File);
   FileStore [f] = File;
   return f;
}

static FILE * IntToFile
# if defined __STDC__ | defined __cplusplus
   (tFile File)
# else
   (File) tFile File;
# endif
{
   if (! IsInitialized) InitFileStore ();
   return FileStore [File];
}

# endif

/* binary IO */

# ifdef OS2

#    ifdef __cplusplus
extern "C" {
# include <fcntl.h>
# include <sys\types.h>
# include <sys\stat.h>
}
#    else
# include <fcntl.h>
# include <sys\types.h>
# include <sys\stat.h>
#    endif

# else

#    ifdef MVS

# include <sys/times.h>

#    else

#       ifdef __cplusplus
extern "C" {
# include <fcntl.h>
# include <sys/types.h>
# include <sys/stat.h>
# ifndef _MSC_VER
# include <sys/times.h>
# endif
}
#       else
# include <fcntl.h>
# include <sys/types.h>
# include <sys/stat.h>
# if ! defined _MSC_VER && !defined __BORLANDC__
# include <sys/times.h>
# endif
#       endif

#    endif
# endif

rbool IsCharacterSpecial
# if defined __STDC__ | defined __cplusplus
   (tFile File)
# else
   (File) tFile File;
# endif
{
# ifdef MVS
   return rfalse;
# else
   struct stat	buf;
   (void) fstat (File, & buf);
   return (0020000 & buf.st_mode) == 0020000;
# endif
}

char DirectorySeparator ARGS ((void))
{
# ifdef _MS_
   return '\\';
# else
   return '/';
# endif
}

tFile OpenInput
# if defined __STDC__ | defined __cplusplus
   (char * FileName)
# else
   (FileName) char * FileName;
# endif
{
# ifdef UNIX
   return open (FileName, O_RDONLY);
# else
   FILE * FilePtr;
   tFile File;
# ifdef _MS_
   int i, l = strlen (FileName);
   for (i = 0; i < l; i ++) if (FileName [i] == '/') FileName [i] = '\\';
   FilePtr = fopen (FileName, "rb");
# else
#    ifdef MVS
   FilePtr = fopen (FileName, "r+,lrecl=80,blksize=240,recfm=f,type=record");
#    else
   FilePtr = fopen (FileName, "r");
#    endif
# endif
   if (FilePtr == NULL) return -1;
   if (! IsInitialized) InitFileStore ();
   File = FileToInt (FilePtr);
   IsLineBuffered [File] = IsCharacterSpecial (File);
   return File;
# endif
}

tFile OpenOutput
# if defined __STDC__ | defined __cplusplus
   (char * FileName)
# else
   (FileName) char * FileName;
# endif
{
# ifdef UNIX
   return creat (FileName, 0666);
# else
# ifdef _MS_
   FILE * FilePtr = fopen (FileName, "wb");
# else
   FILE * FilePtr = fopen (FileName, "w");
# endif
   if (! IsInitialized) InitFileStore ();
   return FilePtr == NULL ? -1 : FileToInt (FilePtr);
# endif
}

int rRead
# if defined __STDC__ | defined __cplusplus
   (tFile File, char * Buffer, int Size)
# else
   (File, Buffer, Size) tFile File; char * Buffer; int Size;
# endif
{
# ifdef UNIX
   return read (File, Buffer, Size);
# else
   if (IsLineBuffered [File]) {
      Buffer [0] = '\0';
      (void) fgets (Buffer, Size, IntToFile (File));
      return strlen (Buffer);
   } else
      return fread (Buffer, 1, Size, IntToFile (File));
# endif
}

int rWrite
# if defined __STDC__ | defined __cplusplus
   (tFile File, char * Buffer, int Size)
# else
   (File, Buffer, Size) tFile File; char * Buffer; int Size;
# endif
{
# ifdef UNIX
   return write (File, Buffer, Size);
# else
   return fwrite (Buffer, 1, Size, IntToFile (File));
# endif
}

void rClose
# if defined __STDC__ | defined __cplusplus
   (tFile File)
# else
   (File) tFile File;
# endif
{
# ifdef UNIX
   (void) close (File);
# else
   (void) fclose (IntToFile (File));
# endif
}

/* calls other than IO */

# ifdef _MS_
# include <malloc.h>
# include <time.h>
# endif

char * rAlloc
# if defined __STDC__ | defined __cplusplus
   (long ByteCount)
# else
   (ByteCount) long ByteCount;
# endif
{
# if defined _MSC_VER & (_MSC_VER <= 800)
   return (char *) _halloc ((unsigned long) ByteCount, 1);
# else
   return (char *) malloc ((unsigned long) ByteCount);
# endif
}

void rFree
# if defined __STDC__ | defined __cplusplus
   (char * ptr)
# else
   (ptr) char * ptr;
# endif
{
   free (ptr);
}

long rTime ARGS ((void))
{
# ifdef _MS_
   return 0;
# else
   struct tms	buffer;
   (void) times (& buffer);
   return (buffer.tms_utime + buffer.tms_stime) * 1000 / rticks;
# endif
}

char * rtpqx
# if defined __STDC__ | defined __cplusplus
   (char * p)
# else
   (p) char * p;
# endif
{
   static char q [10];
   time_t x = time ((time_t *) NULL);
   (void) strftime (q, 10, p, localtime (& x));
   return q;
}

static int	argc;
static char * *	argv;

int GetArgCount ARGS ((void))
{ return argc; }

void GetArgument
# if defined __STDC__ | defined __cplusplus
   (int ArgNum, char * Argument)
# else
   (ArgNum, Argument) int ArgNum; char * Argument;
# endif
{
   register int	i = 0;
   for (;; i ++)
      if ((Argument [i] = argv [ArgNum][i]) == '\0') return;
}

char * GetEnvVar
# if defined __STDC__ | defined __cplusplus
   (char * Name)
# else
   (Name) char * Name;
# endif
{ return getenv (Name); }

void PutArgs
# if defined __STDC__ | defined __cplusplus
   (int Argc, char * * Argv)
# else
   (Argc, Argv) int Argc; char * * Argv;
# endif
{
   argc = Argc;
   argv = Argv;
}

# include <errno.h>

int rErrNo ARGS ((void))
{ return errno; }

int rSystem
# if defined __STDC__ | defined __cplusplus
   (char * String)
# else
   (String) char * String;
# endif
{
# ifdef _MSC_VER
   return -1;
# else
   return system (String);
# endif
}

void rExit
# if defined __STDC__ | defined __cplusplus
   (int Status)
# else
   (Status) int Status;
# endif
{ (void) exit (Status); }

void BEGIN_rSystem ARGS ((void))
{}
