/*************************************************************************
*                                                                        *
*  Name : precision.c                                                    *
*                                                                        *
*  Purpose : intrinsics that must be evaluated at compile time           *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, SCAI.LAB                            *
*  Date   : 19. 11. 1995                                                 *
*                                                                        *
*************************************************************************/

# include "precision.h"

/*************************************************************************
*                                                                        *
*   Real arithmetic                                                      *
*   ---------------                                                      *
*   32 bits is a common word size, but 64 bits is also available         *
*                                                                        *
*   32 bit integers 8 bit exponent, 24 bit mantissa                      *
*   This applies on both DEC VAX and the Intel family                    *
*   of processors, i.e. 80386, 80486.                                    *
*                                                                        *
*   64 bits. Two choices here, simply double the precision               *
*   and keep the mantissa the same or alter both.                        *
*                                                                        *
*   64 bit  8/56 exponent/mantissa - same as for 32 bit                  *
*   64 bit 11/53 exponent/mantissa - now got approximately the same      *
*   precision as for 56 bit mantissa, but the range is now ~ 10**308     *
*   much more useful in the scientific world.                            *
*                                                                        *
*************************************************************************/

int real_digits (kind)
int kind;

{ 
  if (kind == 4) return (24);
  if (kind == 8) return (53);
  if (kind == 16) return (106);

} /* real_digits */

int real_precision (kind)
int kind;

{ 
  if (kind == 4) return (6);
  if (kind == 8) return (15);
  if (kind == 16) return (31);
 
} /* real_precision */

int real_range (kind)
int kind;

{ 
  if (kind == 4) return (37);
  if (kind == 8) return (307);
  if (kind == 16) return (291);
 
} /* real_range */

int real_minexponent (kind)

{ 
  if (kind == 4) return (-125);
  if (kind == 8) return (-1021);
  if (kind == 16) return (-968);
 
} /* real_minexponent */

int real_maxexponent (kind)

{ 
  if (kind == 4) return (128);
  if (kind == 8) return (1024);
  if (kind == 16) return (1024);
 
} /* real_maxexponent */

void real_epsilon (val, kind)
char val[];
int  kind;

{ 
  if (kind == 4)  sprintf (val,"1.192092896E-07");
  if (kind == 8)  sprintf (val,"2.22044604925031308D-16");
  if (kind == 16) sprintf (val,"0.24651903288156618919116517665087070E-31");
}

void real_huge (val, kind)
char val[];
int  kind;
 
{
  if (kind == 4)  sprintf (val,"3.40282345E+38");
  if (kind == 8)  sprintf (val,"1.797693134862313D+308");
  if (kind == 16) sprintf (val,"1.7976931348623159077293051907890026E+308");
}

void real_tiny (val, kind)
char val[];
int  kind;
 
{
  if (kind == 4)  sprintf (val,"1.175494351E-38");
  if (kind == 8)  sprintf (val,"2.22507385850720138D-308");
  if (kind == 16) sprintf (val,"2.0041683600089727779961080513501620E-292");
}

int selected_real_kind (p, r)
int p, r;

{
  if (p <= 6)
    { if (r <= 37) return (4);
      if (r <= 307) return (8);
      return (-2);
    }

  if (p <= 15)
    { if (r <= 307) return (8);
      return (-2);
    }

  if (p <= 31)
    { if (r <= 291) return (16);
      return (-2);
    }

  return (-1);

} /* selected_real_kind */

int selected_x_kind (p, r)
int p, r;

{
  if (p < 6) return (default_real_size);
  return (2*default_real_size);

} /* selected_real_kind */

/*************************************************************************
*                                                                        *
*  32 bits is a common word size, and this leads quite cleanly           *
*  to the following                                                      *
*                                                                        *
*  8 bit integers       -128   to        127     10**2                   *
*  16 bit integers    -32768   to       32767    10**4                   *
*  32 bit integers -2147483648 to   2147483647   10**9                   *
*  64 bit integer   ...        to     ....       10**18                  *
*                                                                        *
*************************************************************************/

int int_range (kind)
int kind;

{ if (kind == 2) return (4);
  if (kind == 4) return (9);
  if (kind == 8) return (18);
}

int int_digits (kind)
int kind;

{ if (kind == 2) return (15);
  if (kind == 4) return (31);
  if (kind == 8) return (63);
}

int int_huge (kind)
int kind;

{ if (kind == 2) return (32767);
  if (kind == 4) return (2147483647);
  /* if (kind == 8) return (9223372036854775807); */
}

int selected_int_kind (r)
int r;
{
  /* if (r <= 2)  return (1); */
  /* if (r <= 4)  return (2); */

  if (r <= 9)  return (4); 
  /* if (r <= 18) return (8); */
  return (-1);

} /* selected_int_kind */

