/*********************************************************************
*                                                                    *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                      *
*  Date        : Mar 93                                              *
*  Last Update : Mar 93                                              *
*                                                                    *
*  Module      : permutations.c                                      *
*                                                                    *
*********************************************************************/

# include "permutations.h"

# include <string.h>    /* strcat         */
# include "TreeOps.h"   /* TreeListLength */
# include "Rank.h"      /* TreeRank       */


       /*************************************************
       *                                                *
       *  some operations on Permutations               *
       *                                                *
       *  make_id_permuatation (5)  :  1 2 3 4 5        *
       *                                                *
       *************************************************/

Permutation make_id_permutation (n)          /* create identity */
int n;

{ Permutation perm;
  int i;

  if (n > MAX_DIMENSIONS)
    { printf ("make_id_permutation, %d too big\n", n);
      exit (-1);
    }

  perm.n = n;
  for (i=1; i<=n; i++) perm.pa[i-1] = i;

  return (perm);

} /* make_id_permutation */

       /*************************************************
       *                                                *
       *  make_trans_permuatation (5)  :  1 2 3 5 4     *
       *                                                *
       *************************************************/

Permutation make_trans_permutation (n)          /* create transpose */
int n;

{ Permutation perm;
  int i;

  if (n > MAX_DIMENSIONS)
    { printf ("make_id_permutation, %d too big\n", n);
      exit (-1);
    }

  perm.n = n;
  for (i=1; i<=n-2; i++) perm.pa[i-1] = i;
  perm.pa[n-2] = n;
  perm.pa[n-1] = n-1;

  return (perm);

} /* make_trans_permutation */

rbool is_id_permutation (perm) 

Permutation perm;

{ rbool ok;

  int i;

  ok = rtrue;

  for (i=1; i<=perm.n; i++)
    ok = ok && perm.pa[i-1] == i;

  return (ok);

} /* is_id_permutation */

int new_perm_position (perm, pos) 
Permutation perm;
int pos;
{ int i, newpos; 

  newpos = 0;
  for (i=1; i<=perm.n; i++)
     if (perm.pa[i-1] == pos)
        newpos = i;

  if (newpos == 0)
      { printf (
         "INTERNAL ERROR: pos = %d not found for new_perm_position\n",
                 pos);
        print_permutation (perm);
        exit(-1);
      }
  return (newpos);
}

       /****************************************************
       *                                                   *
       *       1  2  3  4  5                               *
       *  p :  3  4  5  2  1                               *
       *                                                   *
       *   olddim = 4     newdim = 2                       *
       *                                                   *
       *  n :  3  4  2  1                                  *
       *                                                   *
       ****************************************************/

Permutation reduce_permutation (p, olddim, newdim)
Permutation p;
int olddim, newdim;

{ Permutation new_perm;
  int i;

  new_perm = p;
  /* decrease all entries greater than olddim by  */
  for (i=0; i<new_perm.n; i++)
     if (new_perm.pa[i] > olddim) 
        new_perm.pa[i] = new_perm.pa[i]-1;
  /* remove entry for newdim, this should be olddim */
  if (new_perm.pa[newdim-1] != olddim)
      { printf ("internal error for reduce_permutation\n");
        exit (-1);
      }
  for (i=newdim; i<new_perm.n; i++)
     new_perm.pa[i-1] = new_perm.pa[i];
  new_perm.n = new_perm.n-1;

  return (new_perm);
}

Permutation extend_permutation (p, olddim, newdim)
Permutation p;
int olddim, newdim;

{ Permutation new_perm;
  int i, n;

  new_perm = p;
  n = new_perm.n;
  /* increase all entries greater equal olddim by 1 */
  for (i=0; i<n; i++)
     if (new_perm.pa[i] >= olddim)
         new_perm.pa[i] += 1;
  /* move all entries from newdim up 1 */
  for (i=n; i>=newdim; i--)
     new_perm.pa[i] = new_perm.pa[i-1];
  new_perm.pa[newdim-1] = olddim;

  new_perm.n = n + 1;

  return (new_perm);

} /* extend_permutation */

rbool equal_permutations (perm1, perm2)

Permutation perm1, perm2;

{ rbool ok;
  int i;

  ok = (perm1.n == perm2.n);
  if (ok)
    { for (i=0; i<perm1.n; i++)
        ok = ok && (perm1.pa[i] == perm2.pa[i]);
    }
  return (ok);
}

rbool conform_permutations (perm1, perm2)

Permutation perm1, perm2;

{  rbool ok;

   if (perm1.n == 0)
      ok = rtrue;
    else if (perm2.n == 0)
      ok = rtrue;
    else
      ok = equal_permutations (perm1, perm2);

   return (ok);

} /* conform_permutations */

       /****************************************************
       *                                                   *
       *  transpose_permutations (perm1, perm2)            *
       *                                                   *
       *   rtrue  iff last dimensions are switched          *
       *                                                   *
       ****************************************************/

rbool transpose_permutations (perm1, perm2)
Permutation perm1, perm2;
{  rbool ok;
   int i, n;
   n = perm1.n;
   if (n != perm2.n) return (rfalse);
   if (n < 2) return (rfalse);
   ok = rtrue;
   for (i=0; i<n-2; i++)
     ok = ok && (perm1.pa[i] == perm2.pa[i]);
   ok = ok && (perm1.pa[n-2] == perm2.pa[n-1]);
   ok = ok && (perm1.pa[n-1] == perm2.pa[n-2]);
   return (ok);
}

Permutation merge_permutation (perm1, perm2)

Permutation perm1, perm2;

{ if (perm1.n == 0)
     return (perm2);
   else
     return (perm1);

} /* merge_permutation */

void print_permutation (perm)
Permutation perm;
{ int i;
  printf ("Permutation (n=%d) : ", perm.n);
  for (i=1; i<=perm.n; i++) printf ("%d ", perm.pa[i-1]);
  printf ("\n");
}

void sprint_permutation (string, perm)
char string[];
Permutation perm;
{ int i;
  char digit[5];
  strcpy (string, "<");
  for (i=1; i < perm.n; i++) 
    { sprintf (digit, "%d,", perm.pa[i-1]);
      strcat (string, digit);
    }
  sprintf (digit, "%d>,", perm.pa[perm.n-1]);
  strcat (string, digit);
}  /* sprint_permutation */

       /****************************************************
       *                                                   *
       *  solve_permutation (perm1, perm2)                 *
       *                                                   *
       *  find perm3 with perm1 = perm3 * perm2            *
       *                                                   *
       ****************************************************/

Permutation solve_permutation (perm1, perm2)
Permutation perm1, perm2;

{ int i, k;
  Permutation result;
 
  result.n = perm1.n;

  for (i=0; i<result.n; i++)
    { k = perm1.pa[i];
      result.pa[i] = new_perm_position (perm2, k);
    }

  return (result);
}
       /****************************************************
       *                                                   *
       *  make_last_in_permutation (dist, dim)             *
       *                                                   *
       *  A (N1,N2,N3,N4,N5)  (*,BLOCK,*,BLOCK,*)          *
       *                                                   *
       *  ->      1, 3, 5, 2, 4                            *
       *                                                   *
       *  call sequence: (id = make_id_permutation)        *
       *                                                   *
       *  make_last_in_permutation (id, 2)                 *
       *  make_last_in_permutation (id, 4)                 *
       *                                                   *
       ****************************************************/

void make_last_in_permutation (perm, dim)
Permutation *perm;
int dim;

{ int i, move;

  /* e.g.  (2, 4, 3, 1, 5), 4 ->  2, 3, 1, 5, 4 */
  move = 0;
  for (i=0; i<perm->n; i++)
    { if (perm->pa[i] == dim)
         move = 1;
       else if (move == 1)
         perm->pa[i-1] = perm->pa[i];
    }
  perm->pa[perm->n-1] = dim;

} /* make_last_in_permutation */


       /****************************************************
       *                                                   *
       *  index_list returns a sequence of ranks of index  *
       *                                                   *
       *  [1:n,A,I,J,B] ->  1  2  0  0  3                  *
       *                                                   *
       ****************************************************/

Permutation index_list (indexes)

tTree indexes;

{ Permutation perm;
  int i, n, count;
  tTree hl, elem;

  n      = TreeListLength (indexes);
  perm.n = n;
  count  = 0;
  hl     = indexes;

  for (i=0; i<n; i++)
     { elem = hl->BTE_LIST.Elem;
       hl   = hl->BTE_LIST.Next;
       if (TreeRank (elem) > 0)
         { count ++;
           perm.pa[i] = count;
         }
        else
         perm.pa[i] = 0;
     }

  return (perm);

}  /* index_list */

       /****************************************************
       *                                                   *
       *  get_rank_permutation :                           *
       *                                                   *
       *  index_vector  :   1  0  2  0  3                  *
       *  perm          :   4  1  5  2  3                  *
       *                                                   *
       *  results in    :   0  1  3  0  2                  *
       *                                                   *
       *  compressed    :   1  3  2  0  0                  *
       *                                                   *
       ****************************************************/

Permutation get_rank_permutation (index_vector, perm)

Permutation index_vector, perm;

{ Permutation new;
  int i, count;

  /* permute index_vector to new */

  new.n = index_vector.n;
  for (i=0; i<new.n; i++)
    new.pa[i] = index_vector.pa [perm.pa[i] - 1];

  /* compress the new index vector  */

  count = 0;
  for (i=0; i<new.n; i++)
    if (new.pa[i] > 0)
      { new.pa[count] = new.pa[i];
        count ++;
      }
  new.n = count;

  return (new);

} /* get_rank_permutation */

       /****************************************************
       *                                                   *
       *  switch_index_types :                             *
       *  switch_indexes     :                             *
       *                                                   *
       *     perm = 4  2  3  1  5                          *
       *                                                   *
       *  (N1,N2,N3,N4,N5)  -> (N4,N2,N3,N1,N5)            *
       *                                                   *
       ****************************************************/

void switch_index_types (typelist, perm)
tTree typelist;
Permutation perm;

{ tTree tarray [MAX_DIMENSIONS];
  tTree hlist;
  int i;

  hlist = typelist;
  for (i=0; i<perm.n; i++)
   { tarray[i] = hlist->SHAPE_LIST .Elem;
     hlist     = hlist->SHAPE_LIST.Next;
   }

  hlist = typelist;
  for (i=0; i<perm.n; i++)
   { hlist->SHAPE_LIST.Elem = tarray[perm.pa[i]-1];
     hlist     = hlist->SHAPE_LIST.Next;
   }

} /* switch_index_types */

void switch_indexes (indexlist, perm)
tTree indexlist;
Permutation perm;

{ tTree tarray [MAX_DIMENSIONS];
  tTree hlist;
  int i;

  /* put indexes in an array */
  hlist = indexlist;
  for (i=0; i<perm.n; i++)
   { tarray[i] = hlist->BTE_LIST.Elem;
     hlist     = hlist->BTE_LIST.Next;
   }

  /* refill with permuted list */
  hlist = indexlist;
  for (i=0; i<perm.n; i++)
   { hlist->BTE_LIST.Elem = tarray[perm.pa[i]-1];
     hlist     = hlist->BTE_LIST.Next;
   }

} /* switch_indexes */

void switch_parameters (paramlist, perm)
tTree paramlist;
Permutation perm;

{ tTree tarray [MAX_DIMENSIONS];
  tTree hlist;
  int i;

  /* put parameters in an array */
  hlist = paramlist;
  for (i=0; i<perm.n; i++)
   { tarray[i] = hlist->BTP_LIST.Elem;
     hlist     = hlist->BTP_LIST.Next;
   }

  /* refill with permuted list */
  hlist = paramlist;
  for (i=0; i<perm.n; i++)
   { hlist->BTP_LIST.Elem = tarray[perm.pa[i]-1];
     hlist     = hlist->BTP_LIST.Next;
   }

} /* switch_parameters */

void switch_dist_formats (distlist, perm)
tTree distlist;
Permutation perm;

{ tTree tarray [MAX_DIMENSIONS];
  tTree hlist;
  int i;

  /* put parameters in an array */
  hlist = distlist;
  for (i=0; i<perm.n; i++)
   { tarray[i] = hlist->DIST_LIST.Elem;
     hlist     = hlist->DIST_LIST.Next;
   }

  /* refill with permuted list */
  hlist = distlist;
  for (i=0; i<perm.n; i++)
   { hlist->DIST_LIST.Elem = tarray[perm.pa[i]-1];
     hlist     = hlist->DIST_LIST.Next;
   }

} /* switch_dist_formats */

void switch_dim_list (dimlist, perm)
tDefinitions dimlist;
Permutation perm;

{ tDefinitions tarray [MAX_DIMENSIONS];
  tDefinitions hlist;
  int i;

  /* put parameters in an array */
  hlist = dimlist;
  for (i=0; i<perm.n; i++)
   { tarray[i] = hlist->DIM_LIST.Elem;
     hlist     = hlist->DIM_LIST.Next;
   }

  /* refill with permuted list */
  hlist = dimlist;
  for (i=0; i<perm.n; i++)
   { hlist->DIM_LIST.Elem = tarray[perm.pa[i]-1];
     hlist     = hlist->DIM_LIST.Next;
   }

} /* switch_dim_list */
