/*************************************************************************
*                                                                        *
*  Name : labels.c                                                       *
*                                                                        *
*  Purpose : Data Structures for Label Tables                            *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, SCAI.WR                             *
*                                                                        *
*  Date   : 15. 4. 1993                                                  *
*                                                                        *
*************************************************************************/

#include "labels.h"
#include "DynArray.h"
#include "Scanner.h"  /* MakeEndDos */

#undef DEBUG
#define LABEL_SIZE 25

static int  LabelCounter = 0;
static long LabelMax     = 0;

typedef struct
 { int name, used, defined, inDos ;
 } label_info;

static label_info *Labels;

     /***************************************************************
     *                                                              *
     *   nr    name   used    defined   inDos                       *
     *        --------------------------------                      *
     *    1    10      3        1       0                           *
     *    2    30      0        1       1                           *
     *    3    100     1        1       0      <- LabelCounter(=3)  *
     *                                                              *
     ***************************************************************/

void VerifyLabelArray ()
{ if (Labels == (label_info *) 0)
    { printf ("Could not extend Label array to size %d\n", LabelMax);
      printf ("Internal Error\n");
      exit (-1);
    }
}

void InitLabels ()

{ LabelCounter = 0;

  /* allocate memory for the first time */

  if (LabelMax == 0)
    { LabelMax = LABEL_SIZE;
      MakeArray ((char * *) &Labels, &LabelMax, (long) sizeof (label_info));
      VerifyLabelArray ();
    }

#ifdef DEBUG
      printf ("label array created, LabelMax = %d\n", LabelMax);
#endif

}

int SearchLabel (label)
int label;
{  int found, i;
   i = 0;
   found = 0;
   while ((i < LabelCounter) && (found == 0))
     { if (Labels[i].name == label)
          found = 1;
        else
          i++;
     }
   /* printf ("Search: Position of Label %d is %d\n",label,i); */
   return (i);
}

/*************************************************************************
*                                                                        *
*  NewLabel (name, used, defined, inDos)                                 *
*                                                                        *
*************************************************************************/

void NewLabel (name, used, defined, inDos)
int name, used, defined, inDos;

{ if (LabelCounter == LabelMax)
    { /* extend the label array from LabelMax to 2*LabelMax */
#ifdef DEBUG
      printf ("extend label array, LabelMax = %d\n", LabelMax);
#endif
      ExtendArray ((char **) &Labels, &LabelMax, (long) sizeof (label_info));
#ifdef DEBUG
      printf ("label array extended, LabelMax = %d\n", LabelMax);
#endif
      VerifyLabelArray ();
    }
  Labels[LabelCounter].name = name;
  Labels[LabelCounter].used = used;
  Labels[LabelCounter].defined = defined;
  Labels[LabelCounter].inDos = inDos;
  LabelCounter += 1;
}

/*************************************************************************
*                                                                        *
*   DO 15, I = 1, N   ->  will call 'LabelDo(15)'                        *
*                                                                        *
*************************************************************************/

void LabelDo (label)
int label;
{  int pos;
   /* printf ("%d will be a Do Label \n", label); */
   pos = SearchLabel (label);
   if (pos == LabelCounter) /* not found, define */
     NewLabel (label, 1, 0, 1);
    else
     { Labels[pos].used = 1;
       Labels[pos].inDos += 1;  }
}

/*************************************************************************
*                                                                        *
*   15  ....    ->  will call 'LabelDefine(15)'                          *
*                                                                        *
*************************************************************************/

void LabelDefine (label)
int label;

{ int pos;

  if (label == 0) return;   /* this label does not exist */

  pos = SearchLabel (label);

  if (pos < LabelCounter)  /* found */

   { if (Labels[pos].defined > 0)
       printf ("Label %d defined twice\n", label);

     MakeEndDos = Labels[pos].inDos;
     Labels[pos].defined ++;

#ifdef DEBUG
     printf ("%d EndDos inserted\n", MakeEndDos); 
#endif

     return;
   }

  NewLabel (label, 0, 1, 0);

} /* LabelDefine */
           
/*************************************************************************
*                                                                        *
*   GOTO 15     ->  will call 'LabelUse(15)'                             *
*                                                                        *
*************************************************************************/

void LabelUse (label)
int label;

{  int pos;

   pos = SearchLabel (label);

   if (pos < LabelCounter)  /* found */

    { Labels[pos].used ++; return; }

  NewLabel (label, 1, 0, 0);

} /* LabelUse */


/*************************************************************************
*                                                                        *
*  int GetNoLabels ()    ! returns number of labels defined/used         *
*                                                                        *
*************************************************************************/

int GetNoLabels ()

{ return LabelCounter;
}

/*************************************************************************
*                                                                        *
*  void GetLabelInfo (int no => int label, int used, int defined)        *
*                                                                        *
*    - 1 <= no <= GetNoLabels ()                                         *
*    - returns the name of the label and number of uses/defines          *
*                                                                        *
*************************************************************************/

void GetLabelInfo (no, label, used, defined)

int no;
int *label, *used, *defined;

{ *label   = Labels[no-1].name;
  *used    = Labels[no-1].used;
  *defined = Labels[no-1].defined;
}

/*************************************************************************
*                                                                        *
*  int GetLabelPos (int label)    ! returns position of label in table   *
*                                                                        *
*************************************************************************/

int GetLabelPos (label)
int label;

{ int pos;

  pos = SearchLabel(label);

  if (pos < LabelCounter)
     pos++;
    else
     pos = 0;

  return pos;

} /* GetLabelPos */

/*************************************************************************
*                                                                        *
*  int GetNewLabel ()    ! returns an unused label                       *
*                                                                        *
*************************************************************************/

int GetNewLabel ()

{ int label;
  int pos;

  label = 1;    /* make an  initial try */
  pos   = 0;    /* assume not found     */

  while (!pos)

    { pos = SearchLabel (label);

      if (pos < LabelCounter)  /* label exists */

         { label++;              /* try the next one */
           pos = 0;
         }

        else

           pos = 1;              /* stop loop, label found */

    }

   return label;

}  /* GetNewLabel */
