/*************************************************************************
*                                                                        *
*  Name : precision.h                                                    *
*                                                                        *
*  Purpose : intrinsics that must be evaluated at compile time           *
*                                                                        *
*************************************************************************/

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)       parameters
# else
# define ARGS(parameters)       ()
# endif

# include "global.h"

/*************************************************************************
*                                                                        *
*   Real arithmetic                                                      *
*   ---------------                                                      *
*   32 bits is a common word size, but 64 bits is also available         *
*                                                                        *
*   32 bit integers 8 bit exponent, 24 bit mantissa                      *
*   This applies on both DEC VAX and the Intel family                    *
*   of processors, i.e. 80386, 80486.                                    *
*                                                                        *
*   64 bits. Two choices here, simply double the precision               *
*   and keep the mantissa the same or alter both.                        *
*                                                                        *
*   64 bit  8/56 exponent/mantissa - same as for 32 bit                  *
*   64 bit 11/53 exponent/mantissa - now got approximately the same      *
*   precision as for 56 bit mantissa, but the range is now ~ 10**308     *
*   much more useful in the scientific world.                            *
*                                                                        *
*************************************************************************/

extern int real_digits ARGS((int kind));
extern int real_precision ARGS((int kind));
extern int real_range ARGS((int kind));
extern int real_minexponent ARGS((int kind));
extern int real_maxexponent ARGS((int kind));
extern void real_epsilon ARGS((char val[], int kind));
extern void real_huge ARGS((char val[], int kind));
extern void real_tiny ARGS((char val[], int kind));

extern int selected_real_kind ARGS((int p, int r));
extern int selected_x_kind ARGS((int p, int r));

/*************************************************************************
*                                                                        *
*  32 bits is a common word size, and this leads quite cleanly           *
*  to the following                                                      *
*                                                                        *
*  8 bit integers       -128   to        127     10**2                   *
*  16 bit integers    -32768   to       32767    10**4                   *
*  32 bit integers -2147483648 to   2147483647   10**9                   *
*  64 bit integer   ...        to     ....       10**18                  *
*                                                                        *
*************************************************************************/

extern int int_range ARGS((int kind));
extern int int_digits ARGS((int kind));
extern int int_huge ARGS((int kind));
extern int selected_int_kind ARGS((int kind));

