#ifndef _GLOBAL_H
#define _GLOBAL_H

/*************************************************************************
*                                                                        *
*  Name : global.h                                                       *
*                                                                        *
*  Purpose : declaration of global data for ADAPTOR translation          *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, SCAI.LAB                            *
*                                                                        *
*  Last Update : Oct 1996                                                *
*                                                                        *
*************************************************************************/

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# include "stdio.h"
# include "ratc.h"
# include "Idents.h"

          /*************************************************
          *                                                *
          *  Some global type definitions                  *
          *                                                *
          *************************************************/

typedef char* MsgString;

          /*************************************************
          *                                                *
          *  DRIVER  FLAGS                                 *
          *                                                *
          *************************************************/

extern int     no_input_files;
extern char ** input_file_name;    /* many files */

extern char *  output_file_name;   /* only one file */

/* possible values for adapt_command */

# define FULL_ADAPT     0   /* concatenate all source files, ande
                               generate host.f | node[1].f , cube.f */
# define SINGLE_ADAPT   1   /* compile every single source file     */
# define MAKE_INTERFACE 2   /* make interface of all source files   */
# define MAKE_CALLGRAPH 3   /* make call graph of all source files  */

extern int adapt_command;   /* command for whole source translation */

extern int verbose_flag;
extern int debug_flag;    /* do not delete intermediate files */
extern int list_flag;     /* do not delete protocol files     */

extern int no_warnings;
extern int no_messages;

extern char last_message [160];   /* last error/hints message  */

          /*************************************************
          *                                                *
          *  constants dependent on target F77 compiler    *
          *                                                *
          *************************************************/

#define IOSTAT_END_OF_FILE    -1    /* IOSTAT for END  */
#define IOSTAT_END_OF_RECORD  -1    /* IOSTAT for EOR  */

          /*************************************************
          *                                                *
          *  SOURCE LANGUAGE                               *
          *                                                *
          *************************************************/

extern int no_slanguage;
extern char *slanguage_items   [];
extern char *slanguage_options [];
extern int source_language;

/* possible values for source_language */

#define HPF_SUBSET 0
#define HPF_BASE   1
#define HPF_FULL   2
#define HPF_ADP    3

          /*************************************************
          *                                                *
          *  TARGET LANGUAGE                               *
          *                                                *
          *************************************************/

extern int no_tlanguage;
extern char *tlanguage_items   [];
extern char *tlanguage_options [];
extern int target_language;

/* possible values for target_language */

#define FORTRAN_77 0
#define FORTRAN_90 1
#define FORTRAN_95 2    /* F90 + forall          */

          /*************************************************
          *                                                *
          *  TARGET MODEL                                  *
          *                                                *
          *************************************************/

extern int no_model;
extern char *model_items [];
extern char *model_options [];
extern char *model_srcfile [];
extern int target_model;

#define HPF_SERIAL        0
#define HPF_GLOBAL        1
#define HPF_LOCAL         2
#define HPF_TASK          3

          /*************************************************
          *                                                *
          *  Vectorization                                 *
          *                                                *
          *  (default is always: NO_VECTOR)                *
          *                                                *
          *************************************************/

extern int no_vec;
extern int vectorization;

extern char *vec_items [];
extern char *vec_options [];

#define NO_VECTOR         0
#define VECTORIZE         1

          /*************************************************
          *                                                *
          *  Loop Parallelization                          *
          *                                                *
          *  (default is always: NO_LOOPO)                *
          *                                                *
          *************************************************/

extern int no_loopo;
extern int loop_parallelization;

extern char *loopo_items [];
extern char *loopo_options [];

#define NO_LOOPO         0
#define LOOPO            1

          /*************************************************
          *                                                *
          *  Shared Memory Parallelization                 *
          *                                                *
          *  (default is always: NO_MP)                    *
          *                                                *
          *************************************************/

extern int no_smp;
extern int sm_parallelization;

extern char *smp_items [];
extern char *smp_options [];

#define NO_MP             0
#define OPEN_MP           1
#define SUN_MP            2
#define SGI_MP            3
#define CRAY_MP           4

          /*************************************************
          *                                                *
          *  DEFAULT DISTRIBUTION                          *
          *                                                *
          *************************************************/

extern int no_ddefault;
extern char *ddefault_items [];
extern char *ddefault_options [];
extern int ddefault_kind;

/* possible values for ddefault_kind */

#define DDEFAULT_REPLICATED    0
#define DDEFAULT_DISTRIBUTED   1

          /*************************************************
          *                                                *
          *  MAXIMAL NUMBER OF DISTRIBUTED DIMENSIONS      *
          *                                                *
          *************************************************/

extern int MaxDistributedDims;

          /*************************************************
          *                                                *
          *  OPTIMIZATION LEVEL 0, 1, 2 or 3               *
          *                                                *
          *************************************************/

extern int optimization;

          /*************************************************
          *                                                *
          *  TEST  (1 : allows more untested features)     *
          *                                                *
          *************************************************/

extern int test_flag;

          /*************************************************
          *                                                *
          *  SAFETY  LEVEL 0, 1, or 2                      *
          *                                                *
          *************************************************/

extern int safety;

          /*************************************************
          *                                                *
          *  Semantic Check                                *
          *                                                *
          *************************************************/

extern int semantic_check;

          /*************************************************
          *                                                *
          *  Static arrays sizes remain unchanged          *
          *                                                *
          *************************************************/

extern int static_flag;
extern int shared_flag;

          /*************************************************
          *                                                *
          *  Fix Length                                    *
          *                                                *
          *    (relevant number of columns in input file)  *
          *                                                *
          *  Strip Length                                  *
          *                                                *
          *    (maximal number of columns in the generated *
          *     Fortran source, usually 72 or 132)         *
          *                                                *
          *************************************************/

extern int fix_length;
extern int strip_length;

/* machine parameters for different machines */

          /*************************************************
          *                                                *
          *  PREDEFINED VALUES for VARIABLES               *
          *                                                *
          *    (machine-, installation-dependent)          *
          *                                                *
          *************************************************/

#define predefined_target_language       FORTRAN_77
#define predefined_source_language       HPF_ADP
#define predefined_vectorization         NO_VECTOR
#define predefined_loop_parallelization  NO_LOOPO
#define predefined_sm_parallelization    NO_MP
#define predefined_target_model          HPF_GLOBAL
#define predefined_ddefault_kind         DDEFAULT_REPLICATED

#define predefined_MaxDistributedDims    3
#define predefined_optimization          4
#define predefined_safety                2

#define MAX_LINE_LENGTH                  132 

#define predefined_fix_length            72
#define predefined_strip_length          132

          /*************************************************
          *                                                *
          *  MACHINE-SIZES                                 *
          *                                                *
          *  - changes necessary for CRAY_MPP, ...         *
          *    (int : 8, float : 4, addr : 8)              *
          *                                                *
          *************************************************/

extern int default_int_size;
extern int default_real_size;
extern int default_addr_size;
extern int is_double_precision;

  /* 0 : REAL is REAL*n
     1 : REAL is REAL*2n  with n == default_real_size */

#define predefined_default_int_size  (sizeof(int))
#define predefined_default_real_size (sizeof(float))
#define predefined_default_addr_size (sizeof(int *))

extern char *filename;

#define unparse_file "unparse.f"

/* internal compiler sizes, the values might be critical */

#define WORD_LENGTH 2048     /* maximal length of a token       */
#define STRING_LENGTH 2048   /* maximal characters for a string */

/* internal compiler sizes, the values are not critical */

#define MAX_LINE_LENGTH 132   /* maximal size of an input line     */
#define MAX_ID_LENGTH    50   /* maximal characters for identifier */

#define MAX_FORALL      10    /* maximal nested foralls            */

#define MAX_PARAMETERS  20    /* maximal number of parameters for
                                 the dependence analysis           */

#define MAX_DUMMIES    256    /* maximal number of dummy arguments */

/* A T T E N T I O N    
   =================

   do not increase the following values without extending the DALIB
   increasing will only make sense if DALIB supports features         

*/

#define MAX_DIMENSIONS   7    /* maximal rank of an array       */
#define MAX_TORUS_RANK   4    /* maximal rank of torus topology */


#define MAX_SHADOW_SIZE 5     /* maximal shadow size           */

          /*************************************************
          *                                                *
          *  Additional Operations for Identifier          *
          *                                                *
          *************************************************/

extern tIdent DefaultId ();   /* will be used later for queries
                                 about such an id                */

extern tIdent IsIdent ();     /* more convenient than MakeIdent  */

          /*************************************************
          *                                                *
          *  CONSTANTS for the DALIB (must fit)            *
          *                                                *
          *************************************************/

#define kANY_TOPOLOGY        -2

#define kSERIAL_DIM           0

#define kBLOCK_DIM            1
#define kCYCLIC_DIM           2
#define kGEN_BLOCK_DIM        3
#define kINDIRECT_DIM         4
#define kARBITRARY_DIM        5

#define kALIGNED_DIM          6
#define kMAPPED_DIM           7
#define kREPLICATED_DIM       8
#define kEMBEDDED_DIM         9
#define kSOURCE_DIM          10

#define kANY_BLOCK_DIM       11
#define kANY_CYCLIC_DIM      12
#define kANY_GEN_BLOCK_DIM   13
#define kANY_INDIRECT_DIM    14
#define kANY_ARBITRARY_DIM   15
#define kANY_DISTRIBUTED_DIM 16

#define kUNKNOWN_DIM      -1

          /*************************************************
          *                                                *
          *  Constant for dynamic kind of arrays           *
          *                                                *
          *************************************************/

#define kIS_STATIC       0
#define kIS_DYNAMIC      1
#define kIS_HPF_DYNAMIC  2

#define VERSION_STRING "ADAPTOR 6.1 (Dec 1998)"

#define MAX_INCLUDE_DIRS 30

extern char *include_dirs [MAX_INCLUDE_DIRS];
extern int  no_include_dirs;

extern FILE *include_open ARGS((char *filename));
extern void SetIncludeDir ARGS((char *dir_name));

extern rbool FortranAllocatable ();
extern rbool FortranNoDynamicArrays ();

extern rbool IsNonLocalModel ARGS((int kind));

#endif  /* _GLOBAL_H */
