# ifndef yyVarDescriptor
# define yyVarDescriptor

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef rbool
# define rbool char
# endif

# include "Tree.h"
# include "Definitions.h"

/* line 44 "VarDescriptor.puma" */


   /***********************************************************
   *                                                          *
   *   var_descriptor is record structure for complete        *
   *   formal and actual structure of a variable              *
   *                                                          *
   *   (record is only on stack and not on heap)              *
   *                                                          *
   ***********************************************************/

typedef struct

   { tTree   var_tree;         /* is used to get lbound or ubound   */

     tObject var_obj;          /* variable object specified by selector */

     tTree  reach_info;        /* used if new var object is created */

     int    formal_rank;
     int    actual_rank;

     int    type_kind;
     int    type_size;

     rbool   expanded;          /* make sure that expanded for temporary */

     int    shared;            /* 1 if variable is shared               */

     /*         real a(m)

          !hpf$ template t(-1:8)
          !hpf$ align a(i) with t(i)

                var : a(2:m-1:2)

          shapes = formal : -1:8, alloc : 1:m, actual : 2:m-1:2     */

     tTree  formal_shape [MAX_DIMENSIONS][2];     /* full shape as distrib */
     tTree  alloc_shape  [MAX_DIMENSIONS][2];     /* declared shape of var */
     tTree  expand_shape [MAX_DIMENSIONS][2];     /* shape for expansion   */
     tTree  actual_shape [MAX_DIMENSIONS][3];     /* subset of alloc_shape */

     int    shadow  [MAX_DIMENSIONS][2];          /* left and right ovlp */

     int    distribution_kind [MAX_DIMENSIONS];   /* serial/block/cyclic */
     tTree  distribution_size [MAX_DIMENSIONS];   /* block(size), ...    */

     int    selections [MAX_DIMENSIONS];          /* vector/concur/...   */

     tObject template_obj;                        /* template object      */
     tTree   template_selector;                   /* selector of template */
     int     template_rank;                       /* rank of template     */
     int     template_inherited;                  /* template implicitly  */

     int    template_dim   [MAX_DIMENSIONS]; 
     int    align_mult     [MAX_DIMENSIONS];
     int    align_add      [MAX_DIMENSIONS];

     tObject topology_obj;                    /* NoObject for inherited    */

     int topology_rank;                       /* also valid for ONTO *    */

     int    topology_dim [MAX_DIMENSIONS];   /* 1 <= .. <= topology_rank  */
                                             /* 0 stands for serial       */

     /* the following values are needed for topology -> array 
        and will be refered as the ownership values            */

     int    on_index_dim [MAX_DIMENSIONS];    /* 0 if independent of index  */
     int    on_temp_dim  [MAX_DIMENSIONS];    /* template dim aligned to it */
     int    on_kind      [MAX_DIMENSIONS];    /* kind of distribution       */
     tTree  on_size      [MAX_DIMENSIONS];    /* size of distribution       */
     tTree  on_val       [MAX_DIMENSIONS];    /* NoTree if replicated       */
     tTree  on_range     [MAX_DIMENSIONS][2]; /* range aligned to top dim   */

     /* on_index_dim == 0 -> top dim is replicated or embedded
                             but on_val == NoTree implies then replicated */

   } var_descriptor;

/**************************************************************************
*                                                                         *
*  The following properties of VarDescriptors are important:              *
*                                                                         *
*  +   vard is descriptor of a processor array / processor subset         *
*      iff vard->topology_obj == vard->template_obj                       *
*                                                                         *
*  1)  type_kind == kDUMMY_TYPE  :  Descriptor of a Template              *
*  2)  formal_rank == -1         :  NoDescriptor                          *
*                                                                         *
**************************************************************************/

typedef var_descriptor *pvar;

#define no_descriptor ((pvar) 0)



extern void (* VarDescriptor_Exit) ARGS ((void));

extern void SetVarDescriptor ARGS ((tTree var, pvar vard));
extern void SetVarObjDescriptor ARGS ((pvar vard, tDefinitions obj, tTree rinfo));
extern void SetProcDescriptor ARGS ((tTree t, pvar vard));
extern void PrintVarDescriptor ARGS ((pvar vard));
extern tTree MakeDescriptorVar ARGS ((pvar vard));
extern int GetFormalDim ARGS ((pvar vard, int dim));

extern void BeginVarDescriptor ARGS ((void));
extern void CloseVarDescriptor ARGS ((void));

# endif
