# ifndef yyTypes
# define yyTypes

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef rbool
# define rbool char
# endif

# include "Tree.h"
# include "Definitions.h"

/* line 54 "Types.puma" */


# include <stdio.h>

   /***********************************************************
   *                                                          *
   *   type_rec  :  struct for description of a type          *
   *                                                          *
   ***********************************************************/

typedef struct

   { int    type_kind;
     int    type_size;

   } type_rec;

typedef type_rec *ptype;

extern void OutType ARGS((char *Str, type_rec t));



extern void (* Types_Exit) ARGS ((void));

extern tTree GetObjectType ARGS ((tDefinitions obj));
extern tTree GetVariableType ARGS ((tTree var));
extern int GetObjectSize ARGS ((tDefinitions obj));
extern tTree TreeType ARGS ((tTree var));
extern tTree GetBaseType ARGS ((tTree t));
extern int TreeSize ARGS ((tTree t));
extern int TargetTypeSize ARGS ((tTree t));
extern rbool IsDummyType ARGS ((tTree t));
extern rbool IsArrayType ARGS ((tTree type));
extern rbool IsDerivedType ARGS ((tTree type));
extern rbool IsStringType ARGS ((tTree type));
extern void GetExpType ARGS ((tTree exp, type_rec * yyP1));
extern void GetParamType ARGS ((tTree param, type_rec * yyP3));
extern void GetTypeRecord ARGS ((tTree type, type_rec * yyP5));
extern tTree GetTypeZero ARGS ((tTree texp));
extern rbool IsSameExpType ARGS ((tTree t1, tTree t2));
extern rbool IsSameBaseType ARGS ((tTree t1, tTree t2));
extern rbool IsSubType ARGS ((type_rec type1, type_rec type2));
extern rbool SameTypeRecord ARGS ((type_rec type1, type_rec type2));
extern void GetOp1Type ARGS ((tTree op, type_rec type1, type_rec * yyP6));
extern void GetOp2Type ARGS ((tTree op, type_rec t1, type_rec t2, type_rec * yyP7));
extern rbool LegalAssignmentTypes ARGS ((type_rec t1, type_rec t2));

extern void BeginTypes ARGS ((void));
extern void CloseTypes ARGS ((void));

# endif
