# ifndef yyTreeOps
# define yyTreeOps

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef rbool
# define rbool char
# endif

# include "Tree.h"
# include "Definitions.h"


extern void (* TreeOps_Exit) ARGS ((void));

extern int TreeListLength ARGS ((tTree t));
extern tTree TreeListGet ARGS ((tTree list, int n));
extern tIdent TreeVarName ARGS ((tTree var));
extern int IsVarInExp ARGS ((tIdent name, tTree exp));
extern rbool IsDeferredShape ARGS ((tTree formals));
extern rbool IsAssumedShape ARGS ((tTree formals));
extern rbool IsExplicitShape ARGS ((tTree formals));
extern rbool IsAssumedSize ARGS ((tTree formals));
extern tIdent GetGenericId ARGS ((tTree t));
extern tIdent MakeOperatorId ARGS ((tTree t));
extern rbool IsForallLoop ARGS ((tTree loop));
extern rbool IsIndepLoop ARGS ((tTree loop));
extern rbool IsIndepDoLoop ARGS ((tTree loop));
extern rbool IsSelector ARGS ((tTree t));
extern int GetLayout ARGS ((rbool is_f77, int model));
extern int GeneralIndexListLength ARGS ((tTree t));
extern tDefinitions GetVarAccessObject ARGS ((tTree var));
extern tTree GetUsedVar ARGS ((tTree var));

extern void BeginTreeOps ARGS ((void));
extern void CloseTreeOps ARGS ((void));

# endif
