# ifndef yyLoops
# define yyLoops

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef rbool
# define rbool char
# endif

# include "Tree.h"
# include "Definitions.h"


extern void (* Loops_Exit) ARGS ((void));

extern rbool IsFullParLoopVar ARGS ((tTree var));
extern rbool LoopInvariantAddressing ARGS ((tTree var, tTree loop));
extern rbool IsFullLoopVar ARGS ((tTree var));
extern rbool IsLinParLoopVar ARGS ((tTree var));
extern rbool IsParallelLoop ARGS ((tTree loop));
extern rbool HasOuterParallelLoop ARGS ((void));
extern void ForallVarCheck ARGS ((tTree var));
extern rbool NoParallelLoopIndex ARGS ((tTree index_exp));
extern rbool IsLoopInvariant ARGS ((tTree exp, tTree loop));
extern rbool IsUnchanged ARGS ((tTree var, tTree stmt));

extern void BeginLoops ARGS ((void));
extern void CloseLoops ARGS ((void));

# endif
