# ifndef yyExpressions
# define yyExpressions

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef rbool
# define rbool char
# endif

# include "Tree.h"
# include "Definitions.h"


extern void (* Expressions_Exit) ARGS ((void));

extern void GetIntConstValue ARGS ((tTree exp, rbool * found, int * val));
extern void GetConstDifference ARGS ((tTree exp1, tTree exp2, rbool * found, int * val));
extern tTree MakeNotExp ARGS ((tTree e));
extern rbool EqualExpression ARGS ((tTree e1, tTree e2));
extern rbool EqualIndexes ARGS ((tTree indexes1, tTree indexes2));
extern tTree MakeConstant ARGS ((int n));
extern tTree AddConstant ARGS ((tTree exp, int c));
extern tTree MultConstant ARGS ((tTree exp, int c));
extern tTree DivConstant ARGS ((tTree exp, int c));
extern tTree MinusExpression ARGS ((tTree exp));
extern tTree InverseExpression ARGS ((tTree exp));
extern void ResolveExpression ARGS ((tTree exp, rbool * found, int * a, int * b, tTree * var));
extern void SliceIncrement ARGS ((tTree exp, rbool * yyP4, int * yyP3));
extern tTree MakeSliceExp ARGS ((tTree start, tTree stop));
extern tTree MakeRangeExp ARGS ((tTree start, tTree stop, tTree inc));
extern rbool IsStride1 ARGS ((tTree stride));
extern void GetExplicitShapeSize ARGS ((tTree shape, rbool * yyP6, int * yyP5));

extern void BeginExpressions ARGS ((void));
extern void CloseExpressions ARGS ((void));

# endif
