# ifndef yyExpNormal
# define yyExpNormal

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef rbool
# define rbool char
# endif

# include "Tree.h"
# include "Definitions.h"

/* line 58 "ExpNormal.puma" */


#include "Nesting.h"          /* pointer to loop nest */
#include "Expressions.h"

#define MAXDIM  MAX_FORALL+MAX_PARAMETERS

/*********************************************************************
*                                                                    * 
*    Normalization of an expression                                  *
*                                                                    *
*    For i, j:   I + 2*J - I + 3  ->  (3, 0, 2)                      *
*                                                                    *
*********************************************************************/

typedef struct

   { int vals[MAXDIM+1];

   } ExpNormRecord;

       /*****************************************************
       *                                                    *
       *  Exp = vals[1] * I1 + ... + vals[n] * In + vals[0] *
       *                                                    *
       *****************************************************/

extern void PrintNormRecord ARGS((char s[], char routine[], ExpNormRecord e, tTree loops[], int n));



extern void (* ExpNormal_Exit) ARGS ((void));

extern void ExpNormal ARGS ((tTree e, ptree loops, int n, rbool * yyP2, ExpNormRecord * yyP1));
extern rbool ExpDifferent ARGS ((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int ConstLoops));
extern void DiffUppBound ARGS ((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, rbool * yyP10, int * yyP9));
extern void DiffLowBound ARGS ((ExpNormRecord e1, ptree loops1, int n1, ExpNormRecord e2, ptree loops2, int n2, int CommonLoops, int ConstLoops, rbool * yyP12, int * yyP11));

extern void BeginExpNormal ARGS ((void));
extern void CloseExpNormal ARGS ((void));

# endif
