# ifndef yyBuildTree
# define yyBuildTree

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef rbool
# define rbool char
# endif

# include "Tree.h"


extern void (* BuildTree_Exit) ARGS ((void));

extern tTree ConcatDecls ARGS ((tTree list1, tTree list2));
extern tTree CompleteDecls ARGS ((tTree list));
extern tTree ConcatUnits ARGS ((tTree list1, tTree list2));
extern tTree CompleteUnits ARGS ((tTree list));
extern tTree SetDefaultSize ARGS ((tTree type));
extern tTree SetTypeSize ARGS ((tTree type, int size));
extern tTree SetTypeKind ARGS ((tTree type, tTree kind));
extern void SetImplicitType ARGS ((tTree declist, tTree type));
extern void SetIntent ARGS ((tTree declist, int intent));
extern void SetAttributes ARGS ((tTree attlist, tTree entlist));
extern void SetACFNode ARGS ((tTree node, int label, int line));
extern void SetACFNodeLine ARGS ((tTree node, int line));
extern void SetACFNodeLabel ARGS ((tTree node, int label));
extern void Spec_Exec_Separation ARGS ((tTree body));
extern void LabelForEnd ARGS ((tTree body, int label, int line));
extern void SetDefinitionLabel ARGS ((tTree decls, int label));
extern void MakePublicDecls ARGS ((tTree t));
extern void MakePrivateDecls ARGS ((tTree t));
extern tTree MakeComplexConstant ARGS ((tTree exp1, tTree exp2));
extern tTree SetParInfoHome ARGS ((tTree info, tTree home));
extern tTree SetParInfoResident ARGS ((tTree info, tTree res_var));
extern tTree SetParInfoNew ARGS ((tTree info, tTree new));
extern tTree SetParInfoReduction ARGS ((tTree info, tTree new));
extern void SetBody ARGS ((tTree stmt, tTree new_body));
extern void SetIndependent ARGS ((tTree loop));
extern void SetSerial ARGS ((tTree loop));
extern tTree ApplyParInfo ARGS ((tTree stmt, tTree info, int line));
extern void ApplyNewClause ARGS ((tTree stmt, tTree new_vars, int line));
extern void ApplyResidentClause ARGS ((tTree stmt, tTree res_vars, int line));
extern void SetProcessorId ARGS ((tTree spec, tTree id));
extern void CheckSameIdent ARGS ((tIdent id1, tIdent id2));
extern void SetMapKind ARGS ((int kind, tStringRef val, tTree decls));
extern void SetSharedKind ARGS ((int kind, tTree decls));
extern tTree BuildSingleReductions ARGS ((tTree t));
extern void SpreadSelection ARGS ((tTree selectees, tTree selections));
extern tIdent DecodeExtrinsic ARGS ((int kind));
extern int CodeExtrinsic ARGS ((tStringRef t));
extern int CodeExtrinsic1 ARGS ((tIdent id, tStringRef t));
extern int MixExtrinsic ARGS ((int kind1, int kind2));

extern void BeginBuildTree ARGS ((void));
extern void CloseBuildTree ARGS ((void));

# endif
