/*************************************************************************
*                                                                        *
*  Name : global.c                                                       *
*                                                                        *
*  Purpose : declaration of global data for ADAPTOR translation          *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, SCAI.LAB                            *
*                                                                        *
*  Date        : April 1993                                              *
*  Last Update : April 1998                                              *
*                                                                        *
*************************************************************************/

#include <string.h>

#include "ratc.h"
#include "global.h"
#include "Idents.h"

#define NOF(X) (sizeof((X))/sizeof((X)[0]))

          /*************************************************
          *                                                *
          *  Version String                                *
          *                                                *
          *************************************************/

static char SccsID[] = "@(#)ADAPTOR (6.1), Dec 1998, Copyright T.B. GMD";

          /*************************************************
          *                                                *
          *  DRIVER  FLAGS                                 *
          *                                                *
          *************************************************/

#define MAX_FILE_NAMES 100

int     no_input_files;
char ** input_file_name;

char *  output_file_name = (char *) 0 ;

int adapt_command;   /* command for whole source translation */

int verbose_flag;
int debug_flag;    /* do not delete intermediate files */
int list_flag;     /* do not delete protocol files     */

int no_warnings;    /* suppresses warning messages      */
int no_messages;    /* suppresses info messages         */

char last_message [160];   /* last error/hints message */

char *filename;

          /*************************************************
          *                                                *
          *  SOURCE LANGUAGE                               *
          *                                                *
          *************************************************/

/* possible source languages */

char *slanguage_items [] = 

    { "HPF1.1 (subset)", 
      "HPF2 (base)    ",
      "HPF2 (full)    ",
      "HPF2 + ADP ext."
    };

char *slanguage_options [] = 

    { "-HPF_SUBSET", 
      "-HPF_BASE",
      "-HPF",
      "-HPF_ADP"
    };

int  no_slanguage = 4;

int source_language;

          /*************************************************
          *                                                *
          *  TARGET LANGUAGE                               *
          *                                                *
          *************************************************/

/* possible target languages */

char *tlanguage_items [] = 

    { "Fortran 77", 
      "Fortran 90", 
      "Fortran 95", };

char *tlanguage_options [] = 

    { "-F77", 
      "-F90", 
      "-F95"     };

int  no_tlanguage = 3;

int target_language;

rbool FortranNoDynamicArrays ()

{ return rtrue;  /* Version 3.0 does not generate dynamic arrays at all */
  if (target_language == FORTRAN_77) return rtrue;
  return rfalse;
}

rbool FortranNoForall ()

{ if (target_language == FORTRAN_77) return rtrue;
  if (target_language == FORTRAN_90) return rtrue;
  return rfalse;  /* forall in CM Fortran and Fortran 95 */
}

rbool FortranAllocatable ()

{ if (target_language == FORTRAN_90) return rtrue;
  if (target_language == FORTRAN_95) return rtrue;
  return rfalse;
}

          /*************************************************
          *                                                *
          *  TARGET MODEL                                  *
          *                                                *
          *************************************************/

/* possible target models */

char *model_items [] = { "Serial Model   ", 
                         "MessPass Model " };

char *model_options [] = { "-1", "-N"};
char *model_srcfile [] = { "node1.f", "cube.f" };
int  no_model    = 2;

int  target_model;          /* will be HPF_SERIAL, ...        */

          /*************************************************
          *                                                *
          *  VECTORIZATION                                 *
          *                                                *
          *************************************************/

char *vec_items[] = { "NoVector",
                      "Vector" };

char *vec_options[] = { "-novector", "-vector"};

int  no_vec = 2;

int  vectorization;   /* drives possible optimizations for vectorization */

          /*************************************************
          *                                                *
          *  LOOP PARALLELIZATION                          *
          *                                                *
          *************************************************/

char *loopo_items[] = { "NoAuto ",
                        "Auto" };

char *loopo_options[] = { "-noauto", "-auto"};

int  no_loopo = 2;

int  loop_parallelization; /* drives possible loop parallelization */

          /*************************************************
          *                                                *
          *  Shared Memory Parallelization                 *
          *                                                *
          *************************************************/

char *smp_items[] = { "No SMP ",
                      "Open MP",
                      "SUN MP ",
                      "SGI MP ",
                      "CRAY MP" };

char *smp_options[] = { "-mp=no", "-mp", "-mp=sun",
                        "-mp=sgi", "-mp=cray"            };

int  no_smp = 5;

int  sm_parallelization;


          /*************************************************
          *                                                *
          *  DEFAULT DISTRIBUTION                          *
          *                                                *
          *************************************************/

/* possible default distributions */

char *ddefault_items [] = {"replicated ", "block distr" };
char *ddefault_options [] = {"-ddr", "-ddb"};
int  no_ddefault  = 2;
int  ddefault_kind;

          /*************************************************
          *                                                *
          *  MAXIMAL NUMBER OF DISTRIBUTED DIMENSIONS      *
          *                                                *
          *************************************************/

int MaxDistributedDims;

          /*************************************************
          *                                                *
          *  OPTIMIZATION LEVEL                            *
          *                                                *
          *************************************************/

int optimization;

          /*************************************************
          *                                                *
          *  TEST LEVEL                                    *
          *                                                *
          *************************************************/

int test_flag;

          /*************************************************
          *                                                *
          *  RUN TIME checking                             *
          *                                                *
          *   - safety = 0  : no checks/no mismatch        *
          *   - safety = 1  : only check, but no redistr.  *
          *   - safety = 2  : with redistribution          *
          *                                                *
          *************************************************/

int safety;

          /*************************************************
          *                                                *
          *  SEMANTIC CHECK                                *
          *                                                *
          *   check == 0 : no check for arguments          *
          *                                                *
          *************************************************/

int semantic_check = 1;

int static_flag = 0;
int shared_flag = 0;

          /*************************************************
          *                                                *
          *  machine sizes                                 *
          *                                                *
          *************************************************/

int default_int_size;     /* size of integer in bytes */
int default_real_size;    /* size of real in bytes    */
int default_addr_size;    /* size of address in bytes */
int is_double_precision;  /* REAL is REAL*8, not REAL*4 */

          /*************************************************
          *                                                *
          *  Strip Length (columns in generated sources)   *
          *                                                *
          *************************************************/

int strip_length;
int fix_length;

          /*************************************************
          *                                                *
          *  INCLUDE directories                           *
          *                                                *
          *************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_INCLUDE_DIRS 30

char *include_dirs [MAX_INCLUDE_DIRS];
int  no_include_dirs = 0;

void SetIncludeDir (dir_name)
char *dir_name;

{ char *new_name;

  if (no_include_dirs >= 30)
     { printf ("INTERNAL ERROR : too many include directories\n");
       exit (-1);
     }

  new_name = (char *) malloc (strlen(dir_name+2));
  strcpy (new_name, dir_name);
  include_dirs [no_include_dirs] = new_name;
   
  no_include_dirs ++;

} /* SetIncludeDir */

          /*************************************************
          *                                                *
          *  INCLUDE directories                           *
          *                                                *
          *************************************************/

FILE *include_open (filename)
char *filename;

{ char fullname [MAX_LINE_LENGTH];
  int  i;

  FILE *f;

  f = fopen (filename, "r");
  if (f != (FILE *) NULL) return (f);

  for (i=0; i < no_include_dirs; i++)

     {  sprintf (fullname, "%s/%s", include_dirs[i], filename);
        f = fopen (fullname, "r");
        if (f != (FILE *) NULL) return (f);
     }

  return (f);

} /* include_open */

          /*************************************************
          *                                                *
          *  Additional Operations for Identifer           *
          *                                                *
          *************************************************/

tIdent DefaultId ()

{ return (MakeIdent ("__", 2)); }

tIdent IsIdent (name)
char *name;

{ return (MakeIdent (name, strlen (name)));
} /* IsIdent */

          /*************************************************
          *                                                *
          *  rbool IsNonLocalModel (kind : int)            *
          *                                                *
          *  - rtrue for HPF_GLOBAL, HPF_TASK              *
          *                                                *
          *************************************************/

rbool IsNonLocalModel
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
  if (kind == HPF_GLOBAL) return rtrue;
  if (kind == HPF_TASK) return rtrue;

  return rfalse;
}

