/*************************************************************************
*                                                                        *
*  Name : fadapt.c                                                       *
*                                                                        *
*  Purpose : Driver program of the ADAPTOR translation tool              *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, SCAI.WR                             *
*                                                                        *
*  Last Update : Nov 1998                                                *
*                                                                        *
*************************************************************************/

# include <stdio.h>   /* stderr */
# include <string.h>
# include <stdlib.h>  /* system */

#ifdef WIN32
# include <io.h>
# include <process.h>
#else
# include <unistd.h>            /* getpid, and for testing fileaccess */
#endif

# include "global.h"

/*************************************************************************
*                                                                        *
*************************************************************************/

extern int eval_arg ARGS((int argc, char **argv));

# include "translate.h"

/*************************************************************************
*                                                                        *
*************************************************************************/

/* external variables defined in this module */

#define TMP_FILE_LENGTH 30
#define TMP "/tmp/adaptor"

static char tempfile [TMP_FILE_LENGTH];

#define CMD_LENGTH 4096

void cat_input_files (tempfile_name)
char *tempfile_name;

{ char command [CMD_LENGTH];
  int i, cur_len;
  
  strcpy (command,"cat ");
  cur_len = 4;

  for (i=0; i<no_input_files; i++)
     {  cur_len += strlen (input_file_name[i]) + 1;
        if (cur_len >= CMD_LENGTH)
          { fprintf (stderr, "cat command too large, max size = %d\n",
                             CMD_LENGTH);
            fprintf (stderr, "%s\n", command);
            exit (-1);
          }
        strcat (command, input_file_name[i]);
        strcat (command, " ");
     }

  cur_len += strlen (tempfile_name) + 3;
  if (cur_len >= CMD_LENGTH)
     { fprintf (stderr, "cat command too large, max size = %d\n",
                         CMD_LENGTH);
       fprintf (stderr, "%s\n", command);
       exit (-1);
     }
   strcat (command, " > ");
   strcat (command, tempfile);

   if (verbose_flag)
      printf ("%s\n", command);

   i = system (command);
   if (i != 0)
     { fprintf (stderr, "cat command with error\n");
       exit (-1);
     }
}

void remove_tempfile (tempfile_name)
char *tempfile_name;

{ char command [CMD_LENGTH]; 
  sprintf(command,"rm -f %s",tempfile_name);
  printf ("%s\n", command);
  system (command);
}

  /*****************************************************
  *                                                    *
  *  file_name_prefix (main_name, filename)            *
  *                                                    *
  *    input: filename (e.g. main.fcm, sub.f9)         *
  *                                                    *
  *    output: main_name (e.g. main, sub)              *
  *                                                    *
  *****************************************************/

void file_name_prefix (main_name, filename)
char *main_name, *filename;

{ int length;

  length = strlen (filename);

  strcpy (main_name, filename);
  if (main_name[length-2] == '.')
     main_name[length-2] = '\0';
  else if (main_name[length-3] == '.')
     main_name[length-3] = '\0';
  else if (main_name[length-4] == '.')
     main_name[length-4] = '\0';
  else
    { fprintf (stderr, "ERROR: no prefix found for file %s\n", filename);
      exit (-1);
    }
}  /* file_name_prefix */

  /*****************************************************
  *                                                    *
  *  single_adapt (filename)                           *
  *                                                    *
  *    translates a single HPF file to *.f file        *
  *                                                    *
  *    - note: exit on error                           *
  *                                                    *
  *****************************************************/

void single_adapt (filename)
char * filename;

{ char main_name [256];

  printf ("ADAPT %s\n", filename);

  /* find prefix of filename */

  file_name_prefix (main_name, filename);

  strcat (main_name, ".f");

#ifdef WIN32
  if (access (main_name, 0) == 0)
#else
  if (access (main_name,R_OK) == 0)
#endif
    { fprintf(stderr,"Fortran 77 file does exist %s\n", main_name);
      exit (-1);
    }
  translate_file (filename, main_name);
}

int main(argc, argv)

int argc;
char **argv;

{  int ErrorCount;
   int i, no_arg;

   no_arg = eval_arg (argc, argv);

   if (no_arg > 0)

      { fprintf (stderr, "Unrecognized options\n");
        for (i=1; i<=no_arg; i++)
           fprintf (stderr, "invalid option = %s\n", argv[i]);
        printf ("  fadapt -help\n");
        printf ("  fadapt -settings\n");
        exit (-1);
      }

   if (no_input_files == 0)

       { printf ("missing input files\n");
         exit(-1);
       }

   if (adapt_command == SINGLE_ADAPT)
      { for (i=0; i<no_input_files; i++)
           single_adapt (input_file_name[i]);
        exit(0);
      }

   /* otherwise it is a command that requires all sources in one file */

   if (no_input_files > 1)

      { sprintf(tempfile,"%s%d",TMP,getpid());
        cat_input_files (tempfile);
        filename = tempfile;
      }

     else
 
        filename = input_file_name[0];

   if (adapt_command == FULL_ADAPT)
       translate_file (filename, "");
   else if (adapt_command == MAKE_INTERFACE)
       interface_file (filename, "");
   else if (adapt_command == MAKE_CALLGRAPH)
       callgraph_file (filename, "CallGraph");

   if (no_input_files > 1)
     remove_tempfile (tempfile);

   exit (0);
}

