# include "VarSets.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 38 "VarSets.puma" */


# define MODULE "ControlFlow"

# include "Idents.h"
# include "StringM.h"
# include "DynArray.h"

# include "protocol.h"

# include "Rank.h"         /* VarRank */

static int     status = 0;

static tObject cur_unit;
static tObject *object_list;
static unsigned long object_list_length;
static int     pos;

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyVarSets.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* VarSets_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module VarSets, routine %s failed\n",
  yyFunction);
 VarSets_Exit ();
}

int MakeLocalVarSet ARGS ((tDefinitions unit));
void ReleaseLocalVarSet ARGS ((void));
void PrintVarSet ARGS ((pVarSet vars, MsgString msg));
static int CountLocalVariables ARGS ((tDefinitions entries, tDefinitions unit));
static void SetLocalVariables ARGS ((tDefinitions entries, tDefinitions unit));
static rbool IsLocalVar ARGS ((tDefinitions obj, tDefinitions unit));
void FindVarSetIndex ARGS ((tDefinitions obj, rbool * yyP2, int * yyP1));
void ScalarLocalVarSet ARGS ((pVarSet scalars));

int MakeLocalVarSet
# if defined __STDC__ | defined __cplusplus
(register tDefinitions unit)
# else
(unit)
 register tDefinitions unit;
# endif
{
/* line 80 "VarSets.puma" */
  {
/* line 82 "VarSets.puma" */
   if (! ((status == 1))) goto yyL1;
  {
/* line 84 "VarSets.puma" */
   failure_protocol (MODULE, "MakeLocalVarSet (no release before)", NoTree);
  }
  }
   return 0;
yyL1:;

  if (unit->Kind == kProcObject) {
/* line 89 "VarSets.puma" */
  {
/* line 91 "VarSets.puma" */
   cur_unit = unit;
/* line 93 "VarSets.puma" */
   object_list_length = CountLocalVariables (unit->ProcObject.Declarations, unit);
/* line 95 "VarSets.puma" */
   if ((object_list_length == 0)) {
/* line 95 "VarSets.puma" */
   return 0;
   }
/* line 97 "VarSets.puma" */
 MakeArray ((char **) &object_list, &object_list_length,
                sizeof (tObject)); 
/* line 100 "VarSets.puma" */
   pos = 0;
/* line 102 "VarSets.puma" */
   SetLocalVariables (unit->ProcObject.Declarations, unit);
/* line 104 "VarSets.puma" */
   status = 1;
  }
   return object_list_length;

  }
  if (unit->Kind == kFuncObject) {
/* line 109 "VarSets.puma" */
  {
/* line 111 "VarSets.puma" */
   cur_unit = unit;
/* line 113 "VarSets.puma" */
   object_list_length = CountLocalVariables (unit->FuncObject.Declarations, unit);
/* line 115 "VarSets.puma" */
   if ((object_list_length == 0)) {
/* line 115 "VarSets.puma" */
   return 0;
   }
/* line 117 "VarSets.puma" */
 MakeArray ((char **) &object_list, &object_list_length,
                sizeof (tObject)); 
/* line 120 "VarSets.puma" */
   pos = 0;
/* line 122 "VarSets.puma" */
   SetLocalVariables (unit->FuncObject.Declarations, unit);
/* line 124 "VarSets.puma" */
   status = 1;
  }
   return object_list_length;

  }
/* line 129 "VarSets.puma" */
   return 0;

}

void ReleaseLocalVarSet
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 140 "VarSets.puma" */
  {
/* line 142 "VarSets.puma" */
   if (! ((status == 1))) goto yyL1;
  {
/* line 144 "VarSets.puma" */
 ReleaseArray ((char **) &object_list, &object_list_length,
                    sizeof (tObject));
   
/* line 148 "VarSets.puma" */
   status = 0;
  }
  }
   return;
yyL1:;

;
}

void PrintVarSet
# if defined __STDC__ | defined __cplusplus
(pVarSet vars, MsgString msg)
# else
(vars, msg)
 pVarSet vars;
 MsgString msg;
# endif
{
/* line 161 "VarSets.puma" */

int i;
char var_name[25];

/* line 166 "VarSets.puma" */
 {
  tDefinitions obj;
  {
/* line 170 "VarSets.puma" */
   printf ("%s : ", msg);
/* line 171 "VarSets.puma" */
   WriteSet (stdout, vars);
/* line 171 "VarSets.puma" */
   printf ("\n");
/* line 173 "VarSets.puma" */
   printf ("  ->  ");
/* line 175 "VarSets.puma" */
/* line 175 "VarSets.puma" */
   i = 0;
   while (i < object_list_length) {
/* line 177 "VarSets.puma" */
   if ((IsElement (i, vars))) {
/* line 179 "VarSets.puma" */
   obj = object_list [i];
/* line 181 "VarSets.puma" */
   GetString (obj->Object.Ident, var_name);
/* line 183 "VarSets.puma" */
   printf ("%s ", var_name);
   }
/* line 175 "VarSets.puma" */
   i ++;
   }
/* line 189 "VarSets.puma" */
   printf ("\n");
  }
   return;
 }

;
}

static int CountLocalVariables
# if defined __STDC__ | defined __cplusplus
(register tDefinitions entries, register tDefinitions unit)
# else
(entries, unit)
 register tDefinitions entries;
 register tDefinitions unit;
# endif
{
 yyRecursion:
  if (entries->Kind == kENTRY_LIST) {
/* line 203 "VarSets.puma" */
  {
/* line 205 "VarSets.puma" */
   if (! ((IsLocalVar (entries->ENTRY_LIST.Elem, unit)))) goto yyL1;
  }
   return CountLocalVariables (entries->ENTRY_LIST.Next, unit) + 1;
yyL1:;

/* line 210 "VarSets.puma" */
   entries = entries->ENTRY_LIST.Next;
   goto yyRecursion;

  }
  if (entries->Kind == kENTRY_EMPTY) {
/* line 215 "VarSets.puma" */
   return 0;

  }
 yyAbort ("CountLocalVariables");
 { int yyDummy; return yyDummy; }
}

static void SetLocalVariables
# if defined __STDC__ | defined __cplusplus
(register tDefinitions entries, register tDefinitions unit)
# else
(entries, unit)
 register tDefinitions entries;
 register tDefinitions unit;
# endif
{
 yyRecursion:
  if (entries->Kind == kENTRY_LIST) {
/* line 222 "VarSets.puma" */
  {
/* line 224 "VarSets.puma" */
   if (! ((IsLocalVar (entries->ENTRY_LIST.Elem, unit)))) goto yyL1;
  {
/* line 226 "VarSets.puma" */
 object_list [pos++] = entries->ENTRY_LIST.Elem; 
/* line 228 "VarSets.puma" */
   entries = entries->ENTRY_LIST.Next;
   goto yyRecursion;
  }
  }
yyL1:;

/* line 231 "VarSets.puma" */
  {
/* line 233 "VarSets.puma" */
   entries = entries->ENTRY_LIST.Next;
   goto yyRecursion;
  }

  }
  if (entries->Kind == kENTRY_EMPTY) {
/* line 236 "VarSets.puma" */
   return;

  }
;
}

static rbool IsLocalVar
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions unit)
# else
(obj, unit)
 register tDefinitions obj;
 register tDefinitions unit;
# endif
{
/* line 246 "VarSets.puma" */
  {
/* line 248 "VarSets.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 250 "VarSets.puma" */
   failure_protocol (MODULE, "IsLocalVar", NoTree);
  }
  }
   return rtrue;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.Kind->Kind == kVarLocal) {
/* line 253 "VarSets.puma" */
  {
/* line 255 "VarSets.puma" */
   if (! ((obj->VarObject.in == unit))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

void FindVarSetIndex
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register rbool * yyP2, register int * yyP1)
# else
(obj, yyP2, yyP1)
 register tDefinitions obj;
 register rbool * yyP2;
 register int * yyP1;
# endif
{
/* line 269 "VarSets.puma" */

int i;
char name[MAX_ID_LENGTH];

/* line 274 "VarSets.puma" */
  {
/* line 276 "VarSets.puma" */
   if (! ((! IsLocalVar (obj, cur_unit)))) goto yyL1;
  }
   * yyP2 = rfalse;
   * yyP1 = 0;
   return;
yyL1:;

/* line 279 "VarSets.puma" */
 {
  rbool found;
  int index;
  {
/* line 284 "VarSets.puma" */
   found = rfalse;
/* line 285 "VarSets.puma" */
   index = 0;
/* line 287 "VarSets.puma" */
/* line 287 "VarSets.puma" */
   i = 0;
   while ((i < object_list_length) && (! found)) {
/* line 289 "VarSets.puma" */
   if ((object_list [i] == obj)) {
/* line 291 "VarSets.puma" */
   found = rtrue;
/* line 291 "VarSets.puma" */
   index = i;
   }
/* line 287 "VarSets.puma" */
   i ++;
   }
/* line 297 "VarSets.puma" */

#ifdef DEBUG
      GetString (obj->Object.Ident, name);
      printf ("FindVarSetIndex of %s, found = %d, index = %d\n",
               name, found, index);
#endif 
   
  }
   * yyP2 = found;
   * yyP1 = index;
   return;
 }

;
}

void ScalarLocalVarSet
# if defined __STDC__ | defined __cplusplus
(pVarSet scalars)
# else
(scalars)
 pVarSet scalars;
# endif
{
/* line 314 "VarSets.puma" */

int i;

/* line 318 "VarSets.puma" */
  {
/* line 320 "VarSets.puma" */
   AssignEmpty (scalars);
/* line 322 "VarSets.puma" */
/* line 322 "VarSets.puma" */
   i = 0;
   while ((i < object_list_length)) {
/* line 324 "VarSets.puma" */
   if ((VarRank (object_list [i]) == 0)) {
/* line 326 "VarSets.puma" */
   Include (scalars, i);
   }
/* line 322 "VarSets.puma" */
   i ++;
   }
  }
   return;

;
}

void BeginVarSets ARGS ((void))
{
}

void CloseVarSets ARGS ((void))
{
}
