# include "VarDescriptor.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 143 "VarDescriptor.puma" */


#undef DEBUG

# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "DefTable.h"
# include "Objects.h"

# include "Types.h"             /* type_rec, ...    */
# include "Rank.h"              /* */
# include "TreeOps.h"           /* */
# include "Distributions.h"     /* DimListLength, ... */
# include "Expressions.h"       /* MakeConstant, ... */
# include "ShowDefs.h"          /* SemFile, ...       */
# include "Nesting.h"
# include "Unparse.h"

# define MODULE "VarDescriptor"

/***********************************************************
*                                                          *
*  FUNCTION GetFormalDim (*var_descripor, dim)  int        *
*                                                          *
*   GetFormalDim (A(2,3,1:4,1:5,1:3), 2) -> 4              *
*                                                          *
***********************************************************/

int LocalGetFormalDim (vard, dim)

var_descriptor *vard;
int dim;

{  int i, rank;
   int rank_pos;
   int index_dim;

   /* error handling at first */

   rank     = vard->actual_rank;

   if ((dim < 1) || (dim > rank))

     { printf ("illegal dimension %d (must be 1 - %d)\n", dim, rank);
       failure_protocol (MODULE, "GetFormalDim", NoTree);
     }

   rank     = vard->formal_rank;
   rank_pos = 0;

   index_dim = 0;

   for (i=0; i<rank; i++)

     { if (vard->actual_shape[i][0] != vard->actual_shape[i][1])

          { rank_pos += 1;
            if (rank_pos == dim) index_dim = i+1;
          }

     } /* for */

   return (index_dim);

} /* GetFormalDim */
 


# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyVarDescriptor.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* VarDescriptor_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module VarDescriptor, routine %s failed\n",
  yyFunction);
 VarDescriptor_Exit ();
}

void SetVarDescriptor ARGS ((tTree var, pvar vard));
void SetProcDescriptor ARGS ((tTree t, pvar vard));
static void SetActualShape ARGS ((tTree actuals, int n, pvar vard));
void SetVarObjDescriptor ARGS ((pvar vard, tDefinitions obj, tTree rinfo));
static void SetTopObjDescriptor ARGS ((pvar vard, tDefinitions obj));
static void SetObjectInfo ARGS ((pvar vard, tDefinitions v, tTree rinfo));
static tDefinitions GetActualVarMapping ARGS ((tDefinitions def_mapping, tTree reach_info));
static void GetReachingVarMapping ARGS ((tTree reach_info, tDefinitions * yyP1));
static tDefinitions GetSpecMapping ARGS ((tDefinitions mapping));
static tDefinitions GetActualTempMapping ARGS ((tDefinitions def_mapping, tTree reach_info));
static void GetReachingTempMapping ARGS ((tTree reach_info, tDefinitions * yyP2));
static tTree GetValidVarShape ARGS ((tTree formals, tTree reach_info));
static tTree GetValidTempShape ARGS ((tTree formals, tTree reach_info));
static void SetTemplateInfo ARGS ((pvar vard, tDefinitions tobj, tTree reach_def));
static void GetObjectBaseInfo ARGS ((tDefinitions v, tIdent * yyP6, int * yyP5, tTree * yyP4, tDefinitions * yyP3));
static tTree GetObjectSelection ARGS ((tDefinitions v));
static void SetAllocShape ARGS ((tTree formals, tTree allocs, int n, pvar vard));
static void SetAlloc1Shape ARGS ((tTree formal, tTree alloc, int n, pvar vard));
static void SetShadow ARGS ((tTree shadow_spec, int n, pvar vard));
static void SetReplicated ARGS ((pvar vard));
static void SetSpecMapping ARGS ((tDefinitions d, pvar vard, tTree rinfo));
static void SetRangeMapping ARGS ((tDefinitions d, pvar vard));
static void SetDistDimList ARGS ((tDefinitions d, pvar vard));
static void SetSimpleDistribution ARGS ((tDefinitions d, pvar vard));
static int NoDistributedDims ARGS ((tDefinitions dlist));
static void SetAlignment ARGS ((tDefinitions d, pvar tempd, pvar vard));
static void SetSourceAlignList ARGS ((tDefinitions d, pvar tempd, pvar vard));
static void SetSourceAlignment ARGS ((tDefinitions d, pvar tempd, pvar vard));
static void SetTargetAlignList ARGS ((tDefinitions d, pvar tempd, pvar vard));
static void SetTargetAlignment ARGS ((tDefinitions d, pvar tempd, pvar vard));
static void SetSelection ARGS ((tTree s, pvar vard));
static void SetSelectionList ARGS ((tTree s, pvar vard, int dim));
tTree MakeDescriptorVar ARGS ((pvar vard));
static int source_of_tempdim ARGS ((pvar vard, int tdim));
static int target_of_tempdim ARGS ((pvar vard, int tdim));
static void SetTemplateObject ARGS ((tTree v, tDefinitions tobj, tTree rinfo));
static tTree TranslateActual ARGS ((tTree exp));
void PrintVarDescriptor ARGS ((pvar vard));
static void PrintReachingInfo ARGS ((tTree rinfo));
int GetFormalDim ARGS ((pvar vard, int dim));
static void AppendVarDescriptor ARGS ((pvar vard1, pvar vard2));
static void AppendSelector ARGS ((pvar vard, tTree selector));

void SetVarDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar vard)
# else
(var, vard)
 register tTree var;
 pvar vard;
# endif
{
 yyRecursion:
/* line 275 "VarDescriptor.puma" */
  {
/* line 277 "VarDescriptor.puma" */
 
#ifdef DEBUG
    printf ("SetVarDescripor : ");
    FileUnparse (stdout, var);
    printf ("\n");
#endif
  
/* line 284 "VarDescriptor.puma" */
   goto yyL1;
  }
yyL1:;

  if (var->Kind == kUSED_VAR) {
/* line 287 "VarDescriptor.puma" */
  {
/* line 289 "VarDescriptor.puma" */
 

    if ( (VarRank (var->USED_VAR.VARNAME->VAR_OBJ.Object) > 0) && (var->USED_VAR.VARNAME->VAR_OBJ.Reaching == NoTree) )
      { error_protocol ("used var without reaching info");
        tree_protocol ("used var is : ", var);
      }
  
/* line 297 "VarDescriptor.puma" */
   SetVarObjDescriptor (vard, var->USED_VAR.VARNAME->VAR_OBJ.Object, var->USED_VAR.VARNAME->VAR_OBJ.Reaching);
/* line 299 "VarDescriptor.puma" */
 vard->var_tree = var; 
  }
   return;

  }
  if (var->Kind == kLOOP_VAR) {
/* line 302 "VarDescriptor.puma" */
  {
/* line 306 "VarDescriptor.puma" */
   SetVarObjDescriptor (vard, var->LOOP_VAR.LOOP_VARNAME->VAR_OBJ.Object, NoTree);
/* line 308 "VarDescriptor.puma" */
 vard->var_tree = var; 
  }
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 311 "VarDescriptor.puma" */
 {
  int actual_rank;
  int formal_rank;
  int no_indexes;
  {
/* line 313 "VarDescriptor.puma" */
   SetVarDescriptor (var->INDEXED_VAR.IND_VAR, vard);
/* line 319 "VarDescriptor.puma" */
 actual_rank = vard->actual_rank;
    formal_rank = vard->formal_rank;

    no_indexes = TreeListLength (var->INDEXED_VAR.IND_EXPS);

    

    vard->actual_rank = actual_rank - no_indexes;

    

#ifdef DEBUG
    printf ("set indexes ");
    FileUnparse (stdout, var->INDEXED_VAR.IND_EXPS);
    printf (" in this var descriptor from pos %d: \n", 
             formal_rank - no_indexes + 1);
    PrintVarDescriptor (vard);
#endif
    
    SetActualShape (var->INDEXED_VAR.IND_EXPS, formal_rank - no_indexes + 1, vard);

#ifdef DEBUG
    printf ("have set indexes\n");
    PrintVarDescriptor (vard);
#endif

    vard->var_tree = var;
  
  }
   return;
 }

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 349 "VarDescriptor.puma" */
 {
  type_rec t;
  {
/* line 351 "VarDescriptor.puma" */
   SetVarDescriptor (var->SELECTED_VAR.SELEC_VAR, vard);
/* line 352 "VarDescriptor.puma" */
   AppendSelector (vard, var->SELECTED_VAR.SELECTOR);
/* line 356 "VarDescriptor.puma" */
 

    GetTypeRecord (GetBaseType (GetObjectType (var->SELECTED_VAR.SELECTOR->REC_COMP.Object)), &t);

    vard->type_kind = t.type_kind;
    vard->type_size = t.type_size;

    vard->var_tree = var;
  
  }
   return;
 }

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 367 "VarDescriptor.puma" */
  {
/* line 369 "VarDescriptor.puma" */
   var = var->SUBSTRING_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
/* line 374 "VarDescriptor.puma" */
  {
/* line 376 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetVarDescriptor", var);
  }
   return;

;
}

void SetProcDescriptor
# if defined __STDC__ | defined __cplusplus
(register tTree t, pvar vard)
# else
(t, vard)
 register tTree t;
 pvar vard;
# endif
{
  if (t->Kind == kPROCESSOR_ARRAY) {
/* line 389 "VarDescriptor.puma" */
  {
/* line 391 "VarDescriptor.puma" */
   SetTopObjDescriptor (vard, t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object);
/* line 393 "VarDescriptor.puma" */
 vard->var_tree = t; 
  }
   return;

  }
  if (t->Kind == kPROCESSOR_SUBSET) {
/* line 396 "VarDescriptor.puma" */
  {
/* line 398 "VarDescriptor.puma" */
   SetTopObjDescriptor (vard, t->PROCESSOR_SUBSET.FULLTOP->TOP_OBJ.Object);
/* line 400 "VarDescriptor.puma" */
 vard->actual_rank = 0;                
     vard->var_tree    = t;
     vard->var_obj     = t->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Object;
   
/* line 405 "VarDescriptor.puma" */
   SetActualShape (t->PROCESSOR_SUBSET.SUBSCRIPTS, 1, vard);
  }
   return;

  }
/* line 408 "VarDescriptor.puma" */
  {
/* line 410 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetProcDescriptor", t);
  }
   return;

;
}

static void SetActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree actuals, register int n, pvar vard)
# else
(actuals, n, vard)
 register tTree actuals;
 register int n;
 pvar vard;
# endif
{
 yyRecursion:
  if (actuals->Kind == kBTE_EMPTY) {
/* line 423 "VarDescriptor.puma" */
   return;

  }
  if (actuals->Kind == kBTE_LIST) {
/* line 426 "VarDescriptor.puma" */
  {
/* line 428 "VarDescriptor.puma" */
   SetActualShape (actuals->BTE_LIST.Elem, n, vard);
/* line 429 "VarDescriptor.puma" */
   actuals = actuals->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
/* line 432 "VarDescriptor.puma" */
 {
  int top_dim;
  {
/* line 438 "VarDescriptor.puma" */
 if (n > vard->formal_rank)
         failure_protocol (MODULE, "SetActualShape", actuals);

      top_dim = vard->topology_dim[n-1];
      if (top_dim > 0)
         vard->on_val[top_dim-1] = actuals;
    
/* line 446 "VarDescriptor.puma" */
   goto yyL3;
  }
 }
yyL3:;

  if (actuals->Kind == kSLICE_EXP) {
/* line 449 "VarDescriptor.puma" */
  {
/* line 451 "VarDescriptor.puma" */
 vard->actual_rank ++;
      vard->actual_shape[n-1][0] = actuals->SLICE_EXP.FIRST;
      vard->actual_shape[n-1][1] = actuals->SLICE_EXP.STOP;
      vard->actual_shape[n-1][2] = actuals->SLICE_EXP.INC;
    
  }
   return;

  }
/* line 458 "VarDescriptor.puma" */
  {
/* line 460 "VarDescriptor.puma" */
 if (TreeRank (actuals) == 1)
         vard->actual_rank ++;
      vard->actual_shape[n-1][0] = actuals;
      vard->actual_shape[n-1][1] = actuals;
      vard->actual_shape[n-1][2] = NoTree;
    
  }
   return;

;
}

void SetVarObjDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tDefinitions obj, register tTree rinfo)
# else
(vard, obj, rinfo)
 pvar vard;
 register tDefinitions obj;
 register tTree rinfo;
# endif
{
/* line 476 "VarDescriptor.puma" */
 {
  type_rec t;
  {
/* line 480 "VarDescriptor.puma" */
 int i;

    SetObjectInfo (vard, obj, rinfo);

    

    if (IsTemplate(obj))

      { t.type_kind = kDUMMY_TYPE;
        t.type_size = 0;
      }

     else  GetTypeRecord (GetBaseType (GetObjectType (obj)), &t);

    vard->type_kind = t.type_kind;
    vard->type_size = t.type_size;

    vard->actual_rank = vard->formal_rank;

    vard->var_tree = NoTree;
    vard->var_obj  = obj;
    
    for (i=0; i<vard->actual_rank; i++)

      { vard->actual_shape[i][0] = vard->alloc_shape[i][0];
        vard->actual_shape[i][1] = vard->alloc_shape[i][1];
        vard->actual_shape[i][2] = NoTree;
      };

    vard->reach_info = rinfo;

    vard->expanded = rfalse;

  
  }
   return;
 }

;
}

static void SetTopObjDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tDefinitions obj)
# else
(vard, obj)
 pvar vard;
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kTopologyObject) {
  if (obj->TopologyObject.decl->Kind == kPROCESSORS_DECL) {
/* line 526 "VarDescriptor.puma" */
  {
/* line 528 "VarDescriptor.puma" */
 int idim, rank;

    rank = TreeListLength (obj->TopologyObject.decl->PROCESSORS_DECL.DIMENSIONS);

    vard->formal_rank = rank;

    vard->template_obj       = obj;      
    vard->template_selector  = NoTree;   
    vard->template_rank      = rank;
    vard->template_inherited = 0;

    vard->shared = 0;

    SetAllocShape (obj->TopologyObject.decl->PROCESSORS_DECL.DIMENSIONS, obj->TopologyObject.decl->PROCESSORS_DECL.DIMENSIONS, 1, vard);

    vard->topology_obj   = obj;
    vard->topology_rank  = rank;

    for (idim=0; idim<rank; idim++)

      { vard->distribution_kind [idim] = kBLOCK_DIM;
        vard->distribution_size [idim] = NoTree;
        vard->topology_dim [idim] = idim+1;
        vard->template_dim [idim] = idim+1; 
        vard->align_add [idim]    = 0;
        vard->align_mult [idim]   = 1;

        vard->formal_shape [idim][0] = vard->alloc_shape[idim][0];
        vard->formal_shape [idim][1] = vard->alloc_shape[idim][1];

        

        vard->on_index_dim [idim]    = idim+1;
        vard->on_temp_dim  [idim]    = idim+1;
        vard->on_kind      [idim]    = kBLOCK_DIM;
        vard->on_size      [idim]    = NoTree;
        vard->on_val       [idim]    = NoTree;
        vard->on_range     [idim][0] = vard->formal_shape[idim][0];
        vard->on_range     [idim][1] = vard->formal_shape[idim][1];

      }

    vard->type_kind = kDUMMY_TYPE;
    vard->type_size = 0;

    vard->actual_rank = vard->formal_rank;

    vard->var_tree = NoTree;
    vard->var_obj  = obj;

    for (idim=0; idim<vard->actual_rank; idim++)

      { vard->actual_shape[idim][0] = vard->alloc_shape[idim][0];
        vard->actual_shape[idim][1] = vard->alloc_shape[idim][1];
        vard->actual_shape[idim][2] = NoTree;
      };

    vard->reach_info = NoTree;
    vard->expanded = rfalse;

  
  }
   return;

  }
  }
/* line 591 "VarDescriptor.puma" */
  {
/* line 593 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetTopObjDescriptor", obj->Object.decl);
  }
   return;

;
}

static void SetObjectInfo
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tDefinitions v, register tTree rinfo)
# else
(vard, v, rinfo)
 pvar vard;
 register tDefinitions v;
 register tTree rinfo;
# endif
{
/* line 606 "VarDescriptor.puma" */
 {
  tIdent yyV1;
  int yyV2;
  tTree yyV3;
  tDefinitions yyV4;
  tDefinitions spec_map;
  {
/* line 608 "VarDescriptor.puma" */
   GetObjectBaseInfo (v, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 610 "VarDescriptor.puma" */
 vard->formal_rank = yyV2;

     vard->template_obj       = v;      
     vard->template_selector  = NoTree; 
     vard->template_rank      = yyV2;   
     vard->template_inherited = 0;

     vard->shared = yyV4->Mapping.shared;    

     

     if (yyV2 > 0)
        SetAllocShape (yyV3, GetValidVarShape (yyV3, rinfo), 1, vard);

   
/* line 629 "VarDescriptor.puma" */
 spec_map = GetActualVarMapping (yyV4, rinfo);

     if (spec_map != NoDefinitions)

        SetSpecMapping (spec_map, vard, rinfo);

      else

        SetRangeMapping (yyV4->Mapping.range, vard);

   
/* line 641 "VarDescriptor.puma" */
   SetShadow (GetVarShadow (v), 1, vard);
/* line 642 "VarDescriptor.puma" */
   SetSelection (GetObjectSelection (v), vard);
  }
   return;
 }

;
}

static tDefinitions GetActualVarMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions def_mapping, register tTree reach_info)
# else
(def_mapping, reach_info)
 register tDefinitions def_mapping;
 register tTree reach_info;
# endif
{
/* line 660 "VarDescriptor.puma" */
 {
  tDefinitions yyV1;
  {
/* line 662 "VarDescriptor.puma" */
   GetReachingVarMapping (reach_info, & yyV1);
/* line 664 "VarDescriptor.puma" */
   if (! ((yyV1 != NoDefinitions))) goto yyL1;
  }
   return yyV1;
 }
yyL1:;

/* line 669 "VarDescriptor.puma" */
   return GetSpecMapping (def_mapping);

}

static void GetReachingVarMapping
# if defined __STDC__ | defined __cplusplus
(register tTree reach_info, register tDefinitions * yyP1)
# else
(reach_info, yyP1)
 register tTree reach_info;
 register tDefinitions * yyP1;
# endif
{
/* line 676 "VarDescriptor.puma" */
  {
/* line 678 "VarDescriptor.puma" */
   if (! ((reach_info == NoTree))) goto yyL1;
  }
   * yyP1 = NoDefinitions;
   return;
yyL1:;

  if (reach_info->Kind == kREACHING_INFO) {
/* line 681 "VarDescriptor.puma" */
  {
/* line 683 "VarDescriptor.puma" */
   if (! ((reach_info->REACHING_INFO.var_distribution == NoDefinitions))) goto yyL2;
  }
   * yyP1 = NoDefinitions;
   return;
yyL2:;

  if (reach_info->REACHING_INFO.var_distribution->Kind == kMapInherited) {
/* line 686 "VarDescriptor.puma" */
   * yyP1 = NoDefinitions;
   return;

  }
/* line 689 "VarDescriptor.puma" */
   * yyP1 = reach_info->REACHING_INFO.var_distribution;
   return;

  }
;
}

static tDefinitions GetSpecMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions mapping)
# else
(mapping)
 register tDefinitions mapping;
# endif
{
  if (mapping->Mapping.spec->Kind == kMapInherited) {
/* line 701 "VarDescriptor.puma" */
   return NoDefinitions;

  }
  if (mapping->Mapping.range->Kind == kRangeNone) {
/* line 708 "VarDescriptor.puma" */
   return mapping->Mapping.spec;

  }
  if (mapping->Mapping.range->Kind == kRangeDefault) {
/* line 713 "VarDescriptor.puma" */
  {
/* line 717 "VarDescriptor.puma" */
   failure_protocol (MODULE, "GetSpecMapping (default range)", NoTree);
  }
   return NoDefinitions;

  }
/* line 722 "VarDescriptor.puma" */
   return NoDefinitions;

}

static tDefinitions GetActualTempMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions def_mapping, register tTree reach_info)
# else
(def_mapping, reach_info)
 register tDefinitions def_mapping;
 register tTree reach_info;
# endif
{
/* line 749 "VarDescriptor.puma" */
 {
  tDefinitions yyV1;
  {
/* line 751 "VarDescriptor.puma" */
   GetReachingTempMapping (reach_info, & yyV1);
/* line 753 "VarDescriptor.puma" */
   if (! ((yyV1 != NoDefinitions))) goto yyL1;
  }
   return yyV1;
 }
yyL1:;

/* line 758 "VarDescriptor.puma" */
   return GetSpecMapping (def_mapping);

}

static void GetReachingTempMapping
# if defined __STDC__ | defined __cplusplus
(register tTree reach_info, register tDefinitions * yyP2)
# else
(reach_info, yyP2)
 register tTree reach_info;
 register tDefinitions * yyP2;
# endif
{
/* line 765 "VarDescriptor.puma" */
  {
/* line 767 "VarDescriptor.puma" */
   if (! ((reach_info == NoTree))) goto yyL1;
  }
   * yyP2 = NoDefinitions;
   return;
yyL1:;

  if (reach_info->Kind == kREACHING_INFO) {
/* line 770 "VarDescriptor.puma" */
  {
/* line 772 "VarDescriptor.puma" */
   if (! ((reach_info->REACHING_INFO.temp_distribution == NoDefinitions))) goto yyL2;
  }
   * yyP2 = NoDefinitions;
   return;
yyL2:;

  if (reach_info->REACHING_INFO.temp_distribution->Kind == kMapInherited) {
/* line 775 "VarDescriptor.puma" */
   * yyP2 = NoDefinitions;
   return;

  }
/* line 778 "VarDescriptor.puma" */
   * yyP2 = reach_info->REACHING_INFO.temp_distribution;
   return;

  }
;
}

static tTree GetValidVarShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree reach_info)
# else
(formals, reach_info)
 register tTree formals;
 register tTree reach_info;
# endif
{
/* line 789 "VarDescriptor.puma" */
  {
/* line 791 "VarDescriptor.puma" */
   if (! ((reach_info == NoTree))) goto yyL1;
  }
   return formals;
yyL1:;

  if (reach_info->Kind == kREACHING_INFO) {
/* line 796 "VarDescriptor.puma" */
   return reach_info->REACHING_INFO.var_allocate;

  }
/* line 801 "VarDescriptor.puma" */
  {
/* line 803 "VarDescriptor.puma" */
   failure_protocol (MODULE, "GetValidVarShape", reach_info);
  }
   return formals;

}

static tTree GetValidTempShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree reach_info)
# else
(formals, reach_info)
 register tTree formals;
 register tTree reach_info;
# endif
{
/* line 815 "VarDescriptor.puma" */
  {
/* line 817 "VarDescriptor.puma" */
   if (! ((reach_info == NoTree))) goto yyL1;
  }
   return formals;
yyL1:;

  if (reach_info->Kind == kREACHING_INFO) {
/* line 822 "VarDescriptor.puma" */
   return reach_info->REACHING_INFO.temp_allocate;

  }
/* line 827 "VarDescriptor.puma" */
  {
/* line 829 "VarDescriptor.puma" */
   failure_protocol (MODULE, "GetValidTempShape", reach_info);
  }
   return formals;

}

static void SetTemplateInfo
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tDefinitions tobj, register tTree reach_def)
# else
(vard, tobj, reach_def)
 pvar vard;
 register tDefinitions tobj;
 register tTree reach_def;
# endif
{
/* line 844 "VarDescriptor.puma" */
 {
  tIdent yyV1;
  int yyV2;
  tTree yyV3;
  tDefinitions yyV4;
  tDefinitions spec_map;
  {
/* line 846 "VarDescriptor.puma" */
   GetObjectBaseInfo (tobj, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 848 "VarDescriptor.puma" */
 vard->formal_rank = yyV2;

     vard->template_obj       = tobj;    
     vard->template_selector  = NoTree; 
     vard->template_rank      = yyV2;
     vard->template_inherited = 0;

     if (yyV2 > 0)

        SetAllocShape (yyV3, GetValidTempShape(yyV3, reach_def), 
                       1, vard);

   
/* line 864 "VarDescriptor.puma" */
 spec_map = GetActualTempMapping (yyV4, reach_def);

     if (spec_map != NoDefinitions)

        SetSpecMapping (spec_map, vard, reach_def);

      else

        SetRangeMapping (yyV4->Mapping.range, vard);

   
/* line 876 "VarDescriptor.puma" */
   SetSelection (GetObjectSelection (tobj), vard);
  }
   return;
 }

;
}

static void GetObjectBaseInfo
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v, register tIdent * yyP6, register int * yyP5, register tTree * yyP4, register tDefinitions * yyP3)
# else
(v, yyP6, yyP5, yyP4, yyP3)
 register tDefinitions v;
 register tIdent * yyP6;
 register int * yyP5;
 register tTree * yyP4;
 register tDefinitions * yyP3;
# endif
{
/* line 887 "VarDescriptor.puma" */
  {
/* line 889 "VarDescriptor.puma" */
   if (! ((v == NoObject))) goto yyL1;
  {
/* line 891 "VarDescriptor.puma" */
   failure_protocol (MODULE, "GetObjectBaseInfo (NoObject)", NoTree);
  }
  }
   * yyP6 = DefaultId ();
   * yyP5 = 0;
   * yyP4 = NoTree;
   * yyP3 = NoDefinitions;
   return;
yyL1:;

  if (v->Kind == kVarObject) {
/* line 894 "VarDescriptor.puma" */
  {
/* line 896 "VarDescriptor.puma" */
   if (! ((VarRank (v) == 0))) goto yyL2;
  }
   * yyP6 = v->VarObject.Ident;
   * yyP5 = 0;
   * yyP4 = NoTree;
   * yyP3 = v->VarObject.Dist;
   return;
yyL2:;

/* line 899 "VarDescriptor.puma" */
   * yyP6 = v->VarObject.Ident;
   * yyP5 = VarRank (v);
   * yyP4 = GetObjDimension (v);
   * yyP3 = v->VarObject.Dist;
   return;

  }
  if (v->Kind == kTemplateObject) {
/* line 902 "VarDescriptor.puma" */
  {
/* line 904 "VarDescriptor.puma" */
   if (! ((VarRank (v) == 0))) goto yyL4;
  }
   * yyP6 = v->TemplateObject.Ident;
   * yyP5 = 0;
   * yyP4 = NoTree;
   * yyP3 = v->TemplateObject.Dist;
   return;
yyL4:;

/* line 907 "VarDescriptor.puma" */
   * yyP6 = v->TemplateObject.Ident;
   * yyP5 = VarRank (v);
   * yyP4 = GetObjDimension (v);
   * yyP3 = v->TemplateObject.Dist;
   return;

  }
/* line 911 "VarDescriptor.puma" */
  {
/* line 913 "VarDescriptor.puma" */
   failure_protocol (MODULE, "GetObjectBaseInfo", v->Object.decl);
  }
   * yyP6 = v->Object.Ident;
   * yyP5 = 0;
   * yyP4 = NoTree;
   * yyP3 = NoDefinitions;
   return;

;
}

static tTree GetObjectSelection
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 926 "VarDescriptor.puma" */
   return v->VarObject.select;

  }
  if (v->Kind == kTemplateObject) {
/* line 931 "VarDescriptor.puma" */
   return v->TemplateObject.select;

  }
/* line 936 "VarDescriptor.puma" */
   return NoTree;

}

static void SetAllocShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals, register tTree allocs, register int n, pvar vard)
# else
(formals, allocs, n, vard)
 register tTree formals;
 register tTree allocs;
 register int n;
 pvar vard;
# endif
{
 yyRecursion:
/* line 954 "VarDescriptor.puma" */
  {
/* line 956 "VarDescriptor.puma" */
   if (! ((allocs == NoTree))) goto yyL1;
  {
/* line 958 "VarDescriptor.puma" */
   allocs = formals;
   goto yyRecursion;
  }
  }
yyL1:;

  if (formals->Kind == kSHAPE_EMPTY) {
/* line 961 "VarDescriptor.puma" */
  {
/* line 963 "VarDescriptor.puma" */
   if (! ((formals == allocs))) goto yyL2;
  }
   return;
yyL2:;

  if (allocs->Kind == kBTE_EMPTY) {
/* line 966 "VarDescriptor.puma" */
   return;

  }
  }
  if (formals->Kind == kSHAPE_LIST) {
/* line 969 "VarDescriptor.puma" */
  {
/* line 971 "VarDescriptor.puma" */
   if (! ((formals == allocs))) goto yyL4;
  {
/* line 973 "VarDescriptor.puma" */
   SetAlloc1Shape (formals->SHAPE_LIST.Elem, formals->SHAPE_LIST.Elem, n, vard);
/* line 974 "VarDescriptor.puma" */
   SetAllocShape (formals->SHAPE_LIST.Next, formals->SHAPE_LIST.Next, n + 1, vard);
  }
  }
   return;
yyL4:;

  if (allocs->Kind == kBTE_LIST) {
/* line 977 "VarDescriptor.puma" */
  {
/* line 979 "VarDescriptor.puma" */
   SetAlloc1Shape (formals->SHAPE_LIST.Elem, allocs->BTE_LIST.Elem, n, vard);
/* line 980 "VarDescriptor.puma" */
   formals = formals->SHAPE_LIST.Next;
   allocs = allocs->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
  }
/* line 983 "VarDescriptor.puma" */
  {
/* line 984 "VarDescriptor.puma" */
   failure2_protocol (MODULE, "SetAllocShape", formals, allocs);
  }
   return;

;
}

static void SetAlloc1Shape
# if defined __STDC__ | defined __cplusplus
(register tTree formal, register tTree alloc, register int n, pvar vard)
# else
(formal, alloc, n, vard)
 register tTree formal;
 register tTree alloc;
 register int n;
 pvar vard;
# endif
{
  if (formal->Kind == kEXPLICIT_SHAPE) {
/* line 993 "VarDescriptor.puma" */
  {
/* line 995 "VarDescriptor.puma" */
   if (! ((alloc == formal))) goto yyL1;
  {
/* line 997 "VarDescriptor.puma" */
 vard->alloc_shape[n-1][0]  = formal->EXPLICIT_SHAPE.LOWER;
      vard->alloc_shape[n-1][1]  = formal->EXPLICIT_SHAPE.UPPER;
    
  }
  }
   return;
yyL1:;

  }
  if (Tree_IsType (formal, kSHAPE_SPEC)) {
/* line 1002 "VarDescriptor.puma" */
  {
/* line 1004 "VarDescriptor.puma" */
   if (! ((alloc == formal))) goto yyL2;
  {
/* line 1006 "VarDescriptor.puma" */
 vard->alloc_shape[n-1][0] = NoTree;
      vard->alloc_shape[n-1][1] = NoTree;
    
  }
  }
   return;
yyL2:;

  if (alloc->Kind == kSLICE_EXP) {
/* line 1011 "VarDescriptor.puma" */
  {
/* line 1013 "VarDescriptor.puma" */
 vard->alloc_shape[n-1][0] = alloc->SLICE_EXP.FIRST;
      vard->alloc_shape[n-1][1] = alloc->SLICE_EXP.STOP;
    
  }
   return;

  }
  }
/* line 1018 "VarDescriptor.puma" */
  {
/* line 1020 "VarDescriptor.puma" */
   failure2_protocol (MODULE, "SetAlloc1Shape", formal, alloc);
  }
   return;

;
}

static void SetShadow
# if defined __STDC__ | defined __cplusplus
(register tTree shadow_spec, register int n, pvar vard)
# else
(shadow_spec, n, vard)
 register tTree shadow_spec;
 register int n;
 pvar vard;
# endif
{
 yyRecursion:
/* line 1033 "VarDescriptor.puma" */
  {
/* line 1035 "VarDescriptor.puma" */
   if (! ((shadow_spec == NoTree))) goto yyL1;
  {
/* line 1037 "VarDescriptor.puma" */
   if (! ((n <= vard -> formal_rank))) goto yyL1;
  {
/* line 1039 "VarDescriptor.puma" */
 vard->shadow [n-1][0]      = 0;
     vard->shadow [n-1][1]      = 0;
     vard->selections[n-1]      = 0;
   
/* line 1044 "VarDescriptor.puma" */
   shadow_spec = NoTree;
   n = n + 1;
   goto yyRecursion;
  }
  }
  }
yyL1:;

/* line 1047 "VarDescriptor.puma" */
  {
/* line 1049 "VarDescriptor.puma" */
   if (! ((shadow_spec == NoTree))) goto yyL2;
  }
   return;
yyL2:;

  if (shadow_spec->Kind == kSHADOW_LIST) {
/* line 1052 "VarDescriptor.puma" */
  {
/* line 1054 "VarDescriptor.puma" */
   SetShadow (shadow_spec->SHADOW_LIST.Elem, n, vard);
/* line 1055 "VarDescriptor.puma" */
   shadow_spec = shadow_spec->SHADOW_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
  if (shadow_spec->Kind == kSHADOW_SPEC) {
/* line 1058 "VarDescriptor.puma" */
  {
/* line 1060 "VarDescriptor.puma" */
   if (! ((n <= vard -> formal_rank))) goto yyL4;
  {
/* line 1062 "VarDescriptor.puma" */
 vard->shadow [n-1][0]      = shadow_spec->SHADOW_SPEC.left_size;
     vard->shadow [n-1][1]      = shadow_spec->SHADOW_SPEC.right_size;
     vard->selections[n-1]      = 0;
   
  }
  }
   return;
yyL4:;

  }
  if (shadow_spec->Kind == kSHADOW_EMPTY) {
/* line 1068 "VarDescriptor.puma" */
  {
/* line 1070 "VarDescriptor.puma" */
   if (! ((n > vard -> formal_rank))) goto yyL5;
  }
   return;
yyL5:;

  }
/* line 1073 "VarDescriptor.puma" */
  {
/* line 1075 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetShadow (rank problem)", shadow_spec);
  }
   return;

;
}

static void SetReplicated
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 1088 "VarDescriptor.puma" */
  {
/* line 1090 "VarDescriptor.puma" */
 int i;

     

     vard->topology_obj   = GetDefaultTopology (0);
     vard->topology_rank  = 0;

     for (i=0; i<vard->formal_rank; i++)

        { vard->distribution_kind[i] = kSERIAL_DIM;
          vard->distribution_size[i] = NoTree;
          vard->template_dim[i] = i+1;
          vard->topology_dim[i] = 0;
          vard->align_mult[i] = 1;
          vard->align_add[i] = 0;
          vard->formal_shape[i][0] = vard->alloc_shape[i][0];
          vard->formal_shape[i][1] = vard->alloc_shape[i][1];
        }
   
  }
   return;

;
}

static void SetSpecMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar vard, register tTree rinfo)
# else
(d, vard, rinfo)
 register tDefinitions d;
 pvar vard;
 register tTree rinfo;
# endif
{
/* line 1121 "VarDescriptor.puma" */
  {
/* line 1123 "VarDescriptor.puma" */
   if (! ((d == NoDefinitions))) goto yyL1;
  {
/* line 1125 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetSpecDistribution - no reaching", NoTree);
  }
  }
   return;
yyL1:;

/* line 1128 "VarDescriptor.puma" */
  {
/* line 1130 "VarDescriptor.puma" */
   if (! ((GetCurrentModel () == HPF_LOCAL))) goto yyL2;
  {
/* line 1132 "VarDescriptor.puma" */
   SetReplicated (vard);
  }
  }
   return;
yyL2:;

  if (d->Kind == kMapReplicated) {
/* line 1135 "VarDescriptor.puma" */
  {
/* line 1137 "VarDescriptor.puma" */
   SetReplicated (vard);
  }
   return;

  }
  if (d->Kind == kMapDist) {
/* line 1140 "VarDescriptor.puma" */
  {
/* line 1144 "VarDescriptor.puma" */
 vard->topology_obj   = d->MapDist.Distribution->Distribution.top_obj;

     if (d->MapDist.Distribution->Distribution.top_obj == NoObject)
        vard->topology_rank  = NoDistributedDims (d->MapDist.Distribution->Distribution.ArrayList);
       else
        vard->topology_rank  = VarRank (d->MapDist.Distribution->Distribution.top_obj);

     if (vard->topology_rank > MAX_TORUS_RANK)

       { printf ("too many distributed dimensions, max = %d\n", 
                 MAX_TORUS_RANK);
         failure_protocol (MODULE, "SetDistribution", NoTree);
       }
   
/* line 1159 "VarDescriptor.puma" */
   SetDistDimList (d->MapDist.Distribution->Distribution.ArrayList, vard);
  }
   return;

  }
  if (d->Kind == kMapDecl) {
/* line 1162 "VarDescriptor.puma" */
  {
/* line 1164 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetSpecMapping (still decl)", NoTree);
  }
   return;

  }
  if (d->Kind == kMapAlign) {
/* line 1167 "VarDescriptor.puma" */
 {
  var_descriptor tempd;
  {
/* line 1171 "VarDescriptor.puma" */
 SetTemplateInfo (&tempd, d->MapAlign.Alignment->Alignment.template_obj, rinfo);
 
     SetAlignment (d->MapAlign.Alignment, &tempd, vard);

   
  }
   return;
 }

  }
  if (d->Kind == kMapDefault) {
/* line 1178 "VarDescriptor.puma" */
  {
/* line 1180 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetSpecMapping (default dist)", NoTree);
  }
   return;

  }
/* line 1183 "VarDescriptor.puma" */
  {
/* line 1185 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetSpecMapping", NoTree);
  }
   return;

;
}

static void SetRangeMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar vard)
# else
(d, vard)
 register tDefinitions d;
 pvar vard;
# endif
{
 yyRecursion:
  if (d->Kind == kRangeSelection) {
/* line 1199 "VarDescriptor.puma" */
  {
/* line 1201 "VarDescriptor.puma" */
   d = d->RangeSelection.Selections;
   goto yyRecursion;
  }

  }
  if (d->Kind == kRangeList) {
  if (d->RangeList.Next->Kind == kRangeEmpty) {
/* line 1204 "VarDescriptor.puma" */
  {
/* line 1206 "VarDescriptor.puma" */
   d = d->RangeList.Elem;
   goto yyRecursion;
  }

  }
  }
  if (d->Kind == kRangeDist) {
/* line 1209 "VarDescriptor.puma" */
  {
/* line 1213 "VarDescriptor.puma" */
 int i;

     vard->topology_obj   = NoObject;
     vard->topology_rank  = NoDistributedDims (d->RangeDist.ArrayList);

     if (vard->topology_rank > MAX_TORUS_RANK)

       { printf ("too many distributed dimensions, max = %d\n", 
                 MAX_TORUS_RANK);
         failure_protocol (MODULE, "SetDistribution", NoTree);
       }

     

     vard->template_inherited = 1;

     

     for (i=0; i<vard->formal_rank; i++)

        { vard->formal_shape[i][0] = NoTree;
          vard->formal_shape[i][1] = NoTree;

          vard->on_range     [i][0] = vard->formal_shape[i][0];
          vard->on_range     [i][1] = vard->formal_shape[i][1];
        }
   
/* line 1242 "VarDescriptor.puma" */
   SetDistDimList (d->RangeDist.ArrayList, vard);
  }
   return;

  }
  if (d->Kind == kRangeNone) {
/* line 1245 "VarDescriptor.puma" */
  {
/* line 1247 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetRangeMapping - none range", NoTree);
  }
   return;

  }
  if (d->Kind == kRangeDefault) {
/* line 1250 "VarDescriptor.puma" */
  {
/* line 1252 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetRangeMapping - default range", NoTree);
  }
   return;

  }
/* line 1255 "VarDescriptor.puma" */
  {
/* line 1257 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetRangeMapping - illegal range", NoTree);
  }
   return;

;
}

static void SetDistDimList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar vard)
# else
(d, vard)
 register tDefinitions d;
 pvar vard;
# endif
{
 yyRecursion:
  if (d->Kind == kDIM_EMPTY) {
/* line 1268 "VarDescriptor.puma" */
   return;

  }
  if (d->Kind == kDIM_LIST) {
/* line 1271 "VarDescriptor.puma" */
  {
/* line 1273 "VarDescriptor.puma" */
   SetSimpleDistribution (d->DIM_LIST.Elem, vard);
/* line 1274 "VarDescriptor.puma" */
   d = d->DIM_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 1277 "VarDescriptor.puma" */
  {
/* line 1279 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetDistDimList", NoTree);
  }
   return;

;
}

static void SetSimpleDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar vard)
# else
(d, vard)
 register tDefinitions d;
 pvar vard;
# endif
{
  if (d->Kind == kSerialDimension) {
/* line 1290 "VarDescriptor.puma" */
  {
/* line 1292 "VarDescriptor.puma" */
 vard->distribution_kind [d->SerialDimension.dimension-1] = kSERIAL_DIM; 
     vard->distribution_size [d->SerialDimension.dimension-1] = NoTree; 
     vard->topology_dim [d->SerialDimension.dimension-1] = 0; 
     vard->template_dim [d->SerialDimension.dimension-1] = 0; 
     vard->align_add [d->SerialDimension.dimension-1]    = 0; 
     vard->align_mult [d->SerialDimension.dimension-1]   = 1; 
     vard->formal_shape [d->SerialDimension.dimension-1][0] = vard->alloc_shape[d->SerialDimension.dimension-1][0];
     vard->formal_shape [d->SerialDimension.dimension-1][1] = vard->alloc_shape[d->SerialDimension.dimension-1][1]; 
   
  }
   return;

  }
  if (d->Kind == kDistributedDimension) {
/* line 1303 "VarDescriptor.puma" */
  {
/* line 1305 "VarDescriptor.puma" */
 vard->distribution_kind [d->DistributedDimension.dimension-1] = d->DistributedDimension.kind;
     vard->distribution_size [d->DistributedDimension.dimension-1] = d->DistributedDimension.size;
     vard->topology_dim [d->DistributedDimension.dimension-1] = d->DistributedDimension.topology_dim; 
     vard->template_dim [d->DistributedDimension.dimension-1] = d->DistributedDimension.dimension;      
     vard->align_add [d->DistributedDimension.dimension-1]    = 0; 
     vard->align_mult [d->DistributedDimension.dimension-1]   = 1; 

     vard->formal_shape [d->DistributedDimension.dimension-1][0] = vard->alloc_shape[d->DistributedDimension.dimension-1][0]; 
     vard->formal_shape [d->DistributedDimension.dimension-1][1] = vard->alloc_shape[d->DistributedDimension.dimension-1][1]; 

     

     vard->on_index_dim [d->DistributedDimension.topology_dim-1]    = d->DistributedDimension.dimension;
     vard->on_temp_dim  [d->DistributedDimension.topology_dim-1]    = d->DistributedDimension.dimension;
     vard->on_kind      [d->DistributedDimension.topology_dim-1]    = d->DistributedDimension.kind;
     vard->on_size      [d->DistributedDimension.topology_dim-1]    = d->DistributedDimension.size;
     vard->on_val       [d->DistributedDimension.topology_dim-1]    = NoTree;
     vard->on_range     [d->DistributedDimension.topology_dim-1][0] = vard->formal_shape[d->DistributedDimension.dimension-1][0];
     vard->on_range     [d->DistributedDimension.topology_dim-1][1] = vard->formal_shape[d->DistributedDimension.dimension-1][1];

   
  }
   return;

  }
/* line 1328 "VarDescriptor.puma" */
  {
/* line 1330 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetSimpleDistribution", NoTree);
  }
   return;

;
}

static int NoDistributedDims
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dlist)
# else
(dlist)
 register tDefinitions dlist;
# endif
{
 yyRecursion:
  if (dlist->Kind == kDIM_EMPTY) {
/* line 1341 "VarDescriptor.puma" */
   return 0;

  }
  if (dlist->Kind == kDIM_LIST) {
  if (dlist->DIM_LIST.Elem->Kind == kDistributedDimension) {
/* line 1346 "VarDescriptor.puma" */
   return NoDistributedDims (dlist->DIM_LIST.Next) + 1;

  }
/* line 1351 "VarDescriptor.puma" */
   dlist = dlist->DIM_LIST.Next;
   goto yyRecursion;

  }
 yyAbort ("NoDistributedDims");
 { int yyDummy; return yyDummy; }
}

static void SetAlignment
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
/* line 1366 "VarDescriptor.puma" */
  {
/* line 1368 "VarDescriptor.puma" */
   if (! ((d == NoDefinitions))) goto yyL1;
  {
/* line 1370 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetAlignment - no reaching", NoTree);
  }
  }
   return;
yyL1:;

/* line 1373 "VarDescriptor.puma" */
  {
/* line 1376 "VarDescriptor.puma" */
   if (! ((d->Alignment.TargetList != d->Alignment.SourceList))) goto yyL2;
  {
/* line 1378 "VarDescriptor.puma" */
 vard->topology_obj       = tempd->topology_obj;
     vard->topology_rank      = tempd->topology_rank;

     vard->template_obj       = d->Alignment.template_obj;
     vard->template_selector  = NoTree;
     vard->template_rank      = VarRank (d->Alignment.template_obj);
     vard->template_inherited = 0;

   
/* line 1388 "VarDescriptor.puma" */
   SetSourceAlignList (d->Alignment.SourceList, tempd, vard);
/* line 1389 "VarDescriptor.puma" */
   SetTargetAlignList (d->Alignment.TargetList, tempd, vard);
  }
  }
   return;
yyL2:;

/* line 1392 "VarDescriptor.puma" */
  {
/* line 1394 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetAlignment", NoTree);
  }
   return;

;
}

static void SetSourceAlignList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
 yyRecursion:
  if (d->Kind == kDIM_EMPTY) {
/* line 1405 "VarDescriptor.puma" */
   return;

  }
  if (d->Kind == kDIM_LIST) {
/* line 1408 "VarDescriptor.puma" */
  {
/* line 1410 "VarDescriptor.puma" */
   SetSourceAlignment (d->DIM_LIST.Elem, tempd, vard);
/* line 1411 "VarDescriptor.puma" */
   d = d->DIM_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 1414 "VarDescriptor.puma" */
  {
/* line 1415 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetSourceAlignList", NoTree);
  }
   return;

;
}

static void SetSourceAlignment
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
  if (d->Kind == kSerialDimension) {
/* line 1426 "VarDescriptor.puma" */
  {
/* line 1428 "VarDescriptor.puma" */
 vard->distribution_kind [d->SerialDimension.dimension-1] = 0; 
     vard->distribution_size [d->SerialDimension.dimension-1] = NoTree; 
     vard->topology_dim [d->SerialDimension.dimension-1] = 0; 
     vard->template_dim [d->SerialDimension.dimension-1] = 0; 
     vard->align_add [d->SerialDimension.dimension-1]    = 0; 
     vard->align_mult [d->SerialDimension.dimension-1]   = 1; 
     vard->formal_shape [d->SerialDimension.dimension-1][0] = vard->alloc_shape[d->SerialDimension.dimension-1][0];
     vard->formal_shape [d->SerialDimension.dimension-1][1] = vard->alloc_shape[d->SerialDimension.dimension-1][1];
   
  }
   return;

  }
  if (d->Kind == kAlignedDimension) {
/* line 1439 "VarDescriptor.puma" */
  {
/* line 1443 "VarDescriptor.puma" */
 int kind;
     tTree size;     
     int selection;  
     int top_dim;
     rbool found;
     int  val;

     kind      = tempd->distribution_kind [d->AlignedDimension.template_dim-1];
     size      = tempd->distribution_size [d->AlignedDimension.template_dim-1];
     top_dim   = tempd->topology_dim [d->AlignedDimension.template_dim-1];
     selection = tempd->selections [d->AlignedDimension.template_dim-1];

     vard->distribution_kind [d->AlignedDimension.dimension-1] = kind;
     vard->distribution_size [d->AlignedDimension.dimension-1] = size;

     vard->selections [d->AlignedDimension.dimension-1] = selection;

     vard->topology_dim [d->AlignedDimension.dimension-1] = top_dim; 
     vard->template_dim [d->AlignedDimension.dimension-1] = d->AlignedDimension.template_dim; 

     

     GetIntConstValue (d->AlignedDimension.add, &found, &val);
     vard->align_add  [d->AlignedDimension.dimension-1]   = val; 
     GetIntConstValue (d->AlignedDimension.mult, &found, &val);
     vard->align_mult [d->AlignedDimension.dimension-1]   = val; 

     vard->formal_shape [d->AlignedDimension.dimension-1][0] = tempd->formal_shape[d->AlignedDimension.template_dim-1][0];
     vard->formal_shape [d->AlignedDimension.dimension-1][1] = tempd->formal_shape[d->AlignedDimension.template_dim-1][1];

     if (top_dim > 0)

        { 

          vard->on_index_dim [top_dim-1]    = d->AlignedDimension.dimension;
          vard->on_temp_dim  [top_dim-1]    = d->AlignedDimension.template_dim;
          vard->on_kind      [top_dim-1]    = kind;
          vard->on_size      [top_dim-1]    = size;
          vard->on_val       [top_dim-1]    = NoTree;
          vard->on_range     [top_dim-1][0] = vard->formal_shape[d->AlignedDimension.dimension-1][0];
          vard->on_range     [top_dim-1][1] = vard->formal_shape[d->AlignedDimension.dimension-1][1];

        }
   
  }
   return;

  }
/* line 1489 "VarDescriptor.puma" */
  {
/* line 1491 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetSourceAlignment", NoTree);
  }
   return;

;
}

static void SetTargetAlignList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
 yyRecursion:
  if (d->Kind == kDIM_EMPTY) {
/* line 1502 "VarDescriptor.puma" */
   return;

  }
  if (d->Kind == kDIM_LIST) {
/* line 1505 "VarDescriptor.puma" */
  {
/* line 1507 "VarDescriptor.puma" */
   SetTargetAlignment (d->DIM_LIST.Elem, tempd, vard);
/* line 1508 "VarDescriptor.puma" */
   d = d->DIM_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 1511 "VarDescriptor.puma" */
  {
/* line 1513 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetTargetAlignList", NoTree);
  }
   return;

;
}

static void SetTargetAlignment
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d, pvar tempd, pvar vard)
# else
(d, tempd, vard)
 register tDefinitions d;
 pvar tempd;
 pvar vard;
# endif
{
  if (d->Kind == kDistributedDimension) {
/* line 1524 "VarDescriptor.puma" */
   return;

  }
  if (d->Kind == kAlignedDimension) {
/* line 1529 "VarDescriptor.puma" */
   return;

  }
  if (d->Kind == kEmbeddedDimension) {
/* line 1534 "VarDescriptor.puma" */
  {
/* line 1536 "VarDescriptor.puma" */
 int kind;
    tTree size;
    int top_dim;

    kind    = tempd->distribution_kind [d->EmbeddedDimension.dimension-1];
    size    = tempd->distribution_size [d->EmbeddedDimension.dimension-1];
    top_dim = tempd->topology_dim [d->EmbeddedDimension.dimension-1];

    if (top_dim > 0)

     { 

       vard->on_index_dim [top_dim-1]    = 0;  
       vard->on_temp_dim  [top_dim-1]    = d->EmbeddedDimension.dimension;
       vard->on_kind      [top_dim-1]    = kind;
       vard->on_size      [top_dim-1]    = size;
       vard->on_val       [top_dim-1]    = d->EmbeddedDimension.val;
       vard->on_range     [top_dim-1][0] = tempd->alloc_shape[d->EmbeddedDimension.dimension-1][0];
       vard->on_range     [top_dim-1][1] = tempd->alloc_shape[d->EmbeddedDimension.dimension-1][1];

     }
  
  }
   return;

  }
  if (d->Kind == kReplicatedDimension) {
/* line 1560 "VarDescriptor.puma" */
  {
/* line 1562 "VarDescriptor.puma" */
 int kind;
    tTree size;
    int top_dim;

    kind    = tempd->distribution_kind [d->ReplicatedDimension.dimension-1];
    size    = tempd->distribution_size [d->ReplicatedDimension.dimension-1];
    top_dim = tempd->topology_dim [d->ReplicatedDimension.dimension-1];

    if (top_dim > 0)

     { 

       vard->on_index_dim [top_dim-1]    = 0;  
       vard->on_temp_dim  [top_dim-1]    = d->ReplicatedDimension.dimension;
       vard->on_kind      [top_dim-1]    = kind;
       vard->on_size      [top_dim-1]    = size;
       vard->on_val       [top_dim-1]    = NoTree;
       vard->on_range     [top_dim-1][0] = tempd->alloc_shape[d->ReplicatedDimension.dimension-1][0];
       vard->on_range     [top_dim-1][1] = tempd->alloc_shape[d->ReplicatedDimension.dimension-1][1];

     }
  
  }
   return;

  }
/* line 1586 "VarDescriptor.puma" */
  {
/* line 1588 "VarDescriptor.puma" */
   failure_protocol (MODULE, "SetTargetAlignment", NoTree);
  }
   return;

;
}

static void SetSelection
# if defined __STDC__ | defined __cplusplus
(register tTree s, pvar vard)
# else
(s, vard)
 register tTree s;
 pvar vard;
# endif
{
/* line 1601 "VarDescriptor.puma" */
  {
/* line 1603 "VarDescriptor.puma" */
   if (! ((s == NoTree))) goto yyL1;
  }
   return;
yyL1:;

/* line 1606 "VarDescriptor.puma" */
  {
/* line 1608 "VarDescriptor.puma" */
   SetSelectionList (s, vard, 1);
  }
   return;

;
}

static void SetSelectionList
# if defined __STDC__ | defined __cplusplus
(register tTree s, pvar vard, register int dim)
# else
(s, vard, dim)
 register tTree s;
 pvar vard;
 register int dim;
# endif
{
 yyRecursion:
  if (s->Kind == kSELECT_LIST) {
/* line 1613 "VarDescriptor.puma" */
  {
/* line 1617 "VarDescriptor.puma" */
 if (s->SELECT_LIST.Elem->SELECT_SPEC.selector)
        vard->selections [dim-1] = s->SELECT_LIST.Elem->SELECT_SPEC.selector; 
   
/* line 1621 "VarDescriptor.puma" */
   s = s->SELECT_LIST.Next;
   dim = dim + 1;
   goto yyRecursion;
  }

  }
  if (s->Kind == kSELECT_EMPTY) {
/* line 1624 "VarDescriptor.puma" */
   return;

  }
;
}

tTree MakeDescriptorVar
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 1659 "VarDescriptor.puma" */
  {
/* line 1661 "VarDescriptor.puma" */
   if (! ((vard -> var_tree != NoTree))) goto yyL1;
  }
   return CopyTree (vard -> var_tree);
yyL1:;

/* line 1666 "VarDescriptor.puma" */
 {
  tTree var;
  {
/* line 1668 "VarDescriptor.puma" */
   if (! ((vard -> topology_obj != NoObject))) goto yyL2;
  {
/* line 1672 "VarDescriptor.puma" */
   if (! ((SameTopologyObject (vard -> topology_obj, GetDefaultTopology (0)) || SameTopologyObject (vard -> topology_obj, GetDefaultTopology (- 1))))) goto yyL2;
  {
/* line 1676 "VarDescriptor.puma" */
   if (! ((vard -> var_tree != NoTree))) goto yyL2;
  {
/* line 1680 "VarDescriptor.puma" */
 if (vard->template_obj == NoObject)

       { var = mDUMMY_VAR (); }

     else

       { var = mVAR_OBJ (0, DefaultId());
         SetTemplateObject (var, vard->template_obj, vard->reach_info);
         var = mUSED_VAR (var);
       }
  
  }
  }
  }
  }
   return var;
 }
yyL2:;

/* line 1695 "VarDescriptor.puma" */
 {
  tTree var;
  {
/* line 1699 "VarDescriptor.puma" */
 int tdim, rank;
    tTree il;
 
#ifdef DEBUG
    printf ("MakeDescriptorVar : \n");
    PrintVarDescriptor (vard);
#endif

    il = mBTE_EMPTY ();
 
    rank = vard->template_rank;
 
    for (tdim=rank; tdim>=1; tdim--)   
 
      { int idim, pdim;
        tTree index;

        idim = source_of_tempdim (vard, tdim);
        pdim = target_of_tempdim (vard, tdim);

        if (idim > 0)

           { int align_add, align_mult;
             tTree lb, ub, inc;

             lb  = vard->actual_shape[idim-1][0];
             ub  = vard->actual_shape[idim-1][1];
             inc = vard->actual_shape[idim-1][2];

             

             if (lb == NoTree) lb = mDUMMY_EXP ();
             if (ub == NoTree) ub = mDUMMY_EXP ();
             if (inc == NoTree) inc = mDUMMY_EXP ();

             align_add  = vard->align_add[idim-1];
             align_mult = vard->align_mult[idim-1];

             if (lb == ub)

                { index = TranslateActual (lb);
                  index = MultConstant (index, align_mult);
                  index = AddConstant  (index, align_add);
                }

              else
 
                { lb = MultConstant (lb, align_mult);
                  lb = AddConstant  (lb, align_add);
                  ub = MultConstant (ub, align_mult);
                  ub = AddConstant  (ub, align_add);

                  if (align_mult != 1)

                     { 
                       if (IsStride1 (inc))
                          inc = MakeConstant (align_mult);
                        else
                          inc = MultConstant (inc, align_mult);
                     }

                  index = mSLICE_EXP (lb, ub, inc);
                 
                } 
 
           } 

         else if (pdim > 0)

           { tTree val, range;

             val = vard->on_val [pdim-1];

             if (val == NoTree)
                index = mSLICE_EXP (mDUMMY_EXP(), mDUMMY_EXP(),mDUMMY_EXP());
               else
                index = CopyTree (val);
              
           }

         else 

           { 

             index = mSLICE_EXP (mDUMMY_EXP(), mDUMMY_EXP(),mDUMMY_EXP());

           }

        il = mBTE_LIST (index, il);

      }   

    if (vard->template_obj == NoObject)

       { var = mDUMMY_VAR (); }

     else

       { var = mVAR_OBJ (0, DefaultId());
         SetTemplateObject (var, vard->template_obj, vard->reach_info);
         var = mUSED_VAR (var);
       }
 
    var = mINDEXED_VAR (var, il);
 
  
  }
   return var;
 }

}

static int source_of_tempdim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int tdim)
# else
(vard, tdim)
 pvar vard;
 register int tdim;
# endif
{
/* line 1815 "VarDescriptor.puma" */
 {
  int idim;
  {
/* line 1819 "VarDescriptor.puma" */
 int i, rank;

     idim = 0;
     rank = vard->formal_rank;
     for (i=0; i<rank; i++)
        if (vard->template_dim[i] == tdim)
           idim = i+1;
   
  }
   return idim;
 }

}

static int target_of_tempdim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int tdim)
# else
(vard, tdim)
 pvar vard;
 register int tdim;
# endif
{
/* line 1837 "VarDescriptor.puma" */
 {
  int pdim;
  {
/* line 1841 "VarDescriptor.puma" */
 int i, rank;

     pdim = 0;
     rank = vard->topology_rank;
     for (i=0; i<rank; i++)
        if (vard->on_temp_dim[i] == tdim)
           pdim = i+1;
   
  }
   return pdim;
 }

}

static void SetTemplateObject
# if defined __STDC__ | defined __cplusplus
(register tTree v, register tDefinitions tobj, register tTree rinfo)
# else
(v, tobj, rinfo)
 register tTree v;
 register tDefinitions tobj;
 register tTree rinfo;
# endif
{
  if (v->Kind == kVAR_OBJ) {
/* line 1859 "VarDescriptor.puma" */
  {
/* line 1862 "VarDescriptor.puma" */
   if (! ((rinfo == NoTree))) goto yyL1;
  {
/* line 1864 "VarDescriptor.puma" */
 v->VAR_OBJ.Ident     = tobj->Object.Ident;
     v->VAR_OBJ.Object      = tobj;
     v->VAR_OBJ.Reaching = NoTree;
   
  }
  }
   return;
yyL1:;

  if (rinfo->Kind == kREACHING_INFO) {
/* line 1872 "VarDescriptor.puma" */
  {
/* line 1876 "VarDescriptor.puma" */
 v->VAR_OBJ.Ident     = tobj->Object.Ident;
     v->VAR_OBJ.Object      = tobj;
     v->VAR_OBJ.Reaching = mREACHING_INFO (rinfo->REACHING_INFO.temp_allocate, rinfo->REACHING_INFO.temp_allocate, rinfo->REACHING_INFO.temp_distribution, rinfo->REACHING_INFO.temp_distribution);
   
  }
   return;

  }
  }
/* line 1882 "VarDescriptor.puma" */
  {
/* line 1884 "VarDescriptor.puma" */
   failure2_protocol (MODULE, "SetTemplateObject", v, rinfo);
  }
   return;

;
}

static tTree TranslateActual
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
/* line 1898 "VarDescriptor.puma" */
  {
/* line 1899 "VarDescriptor.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  }
   return exp;
yyL1:;

  if (exp->Kind == kLOOP_VAR) {
/* line 1903 "VarDescriptor.puma" */
   return mVAR_EXP (exp);

  }
/* line 1907 "VarDescriptor.puma" */
   return exp;

}

void PrintVarDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 1919 "VarDescriptor.puma" */

int dim, rank;
char string[MAX_ID_LENGTH];

/* line 1924 "VarDescriptor.puma" */
  {
/* line 1926 "VarDescriptor.puma" */
 rank = vard->formal_rank;

    

    printf ("VarDescriptor of ");
    FileUnparse (stdout, vard->var_tree); 
    
    printf (" rank (actual=%d,formal=%d)", 
              vard->actual_rank, rank);
    if (vard->type_kind == kINTEGER_TYPE)
       printf (" INTEGER*%d\n", vard->type_size);
     else if (vard->type_kind == kREAL_TYPE)
       printf (" REAL*%d\n", vard->type_size);
     else if (vard->type_kind == kBOOLEAN_TYPE)
       printf (" LOGICAL*%d\n", vard->type_size);
     else if (vard->type_kind == kCOMPLEX_TYPE)
       printf (" COMPLEX*%d\n", vard->type_size);
     else 
       printf (" type kind = %d, size = %d\n", vard->type_kind,
                                               vard->type_size);

    printf ("  shared=%d, ", vard->shared);

    if (vard->template_obj == NoObject)

        printf ("no template ");

      else if (vard->template_obj == vard->var_obj)

        printf ("is own template");

      else
      
      { GetString (vard->template_obj->Object.Ident, string);
        printf ("aligned to template %s (rank=%d)",
                 string, vard->template_rank);
      }

    if (vard->topology_obj == NoObject)

        printf (" onto * (rank = %d)\n", vard->topology_rank);

      else
 
        { tIdent top_ident;

          top_ident = vard->topology_obj->Object.Ident;

          if (top_ident == DefaultId())

            printf (" onto default topology #%d\n", vard->topology_rank);

            else

             { GetString (vard->topology_obj->Object.Ident, string);
               printf (" onto topology %s (rank=%d)\n",
                        string, vard->topology_rank);
             }
        }

    for (dim=0; dim<rank; dim++)
      { printf ("  idim %d: ", dim+1);
        FileUnparse (stdout, vard->actual_shape[dim][0]);
        if (vard->actual_shape[dim][0] != vard->actual_shape[dim][1])
          { printf (":");
            FileUnparse (stdout, vard->actual_shape[dim][1]);
          }
        if (vard->actual_shape[dim][2] != NoTree)
          { printf (":");
            FileUnparse (stdout, vard->actual_shape[dim][2]);
          }

        if (vard->expanded)

           { 
             printf (" expanded to ");
             FileUnparse (stdout, vard->expand_shape[dim][0]);
             if (vard->expand_shape[dim][0] != vard->expand_shape[dim][1])
              { printf (":");
                FileUnparse (stdout, vard->expand_shape[dim][1]);
              }
           }

        

        if (vard->alloc_shape[dim][0] != NoTree)

           { printf (" (");
             FileUnparse (stdout, vard->alloc_shape[dim][0]);
             printf (":");
             FileUnparse (stdout, vard->alloc_shape[dim][1]);
             printf (")");
           }

        

        printf (" align to tdim=%d : %d*I+%d (", 
                 vard->template_dim[dim], vard->align_mult[dim], 
                                          vard->align_add[dim]);

        if (vard->alloc_shape[dim][0] != NoTree)

         { FileUnparse (stdout, vard->formal_shape[dim][0]);
           printf (":");
           FileUnparse (stdout, vard->formal_shape[dim][1]);
         }

        printf (") distr on pdim=%d", vard->topology_dim[dim]);

        if (vard->distribution_kind[dim] == kBLOCK_DIM) 
           printf (" block(k)");
        if (vard->distribution_kind[dim] == kGEN_BLOCK_DIM) 
           printf (" gen_block(ISIZE)");
        if (vard->distribution_kind[dim] == kSERIAL_DIM) 
           printf (" serial");
        if (vard->distribution_kind[dim] == kCYCLIC_DIM) 
           { printf (" cyclic(");
             FileUnparse (stdout, vard->distribution_size[dim]);
             printf (")");
           }
        if (vard->distribution_kind[dim] == kINDIRECT_DIM) 
           printf (" indirect(MAP)");
        if (vard->distribution_kind[dim] == kANY_BLOCK_DIM) 
           printf (" block()");
        if (vard->distribution_kind[dim] == kANY_CYCLIC_DIM) 
           printf (" cyclic()");
        if (vard->distribution_kind[dim] == kANY_GEN_BLOCK_DIM) 
           printf (" gen_block()");
        if (vard->distribution_kind[dim] == kANY_INDIRECT_DIM) 
           printf (" indirect()");
        if (vard->distribution_kind[dim] == kANY_DISTRIBUTED_DIM) 
           printf (" all");

        if (vard->selections[dim] & kSELECT_VECTOR)
           printf (" vector");
        if (vard->selections[dim] & kSELECT_NOVECTOR)
           printf (" novector");
        if (vard->selections[dim] & kSELECT_SHORT)
           printf (" short");
        if (vard->selections[dim] & kSELECT_EXPAND)
           printf (" expand");
        if (vard->selections[dim] & kSELECT_CONCUR)
           printf (" concur");
        if (vard->selections[dim] & kSELECT_NOCONCUR)
           printf (" noconcur");

        printf ("\n");
      }

    rank = vard->topology_rank;  

    for (dim=0; dim<rank; dim++)
     { printf ("  pdim %d : -> index_dim %d temp_dim %d", 
               dim+1, vard->on_index_dim[dim], vard->on_temp_dim[dim]);
       printf (" range : ");
       FileUnparse (stdout, vard->on_range[dim][0]);
       printf ("-");
       FileUnparse (stdout, vard->on_range[dim][1]);
       if (vard->on_val[dim] != NoTree)
         { printf (" on value : "); 
           FileUnparse (stdout, vard->on_val[dim]);
         }
       printf ("\n");
     }
   
  }
   return;

;
}

static void PrintReachingInfo
# if defined __STDC__ | defined __cplusplus
(register tTree rinfo)
# else
(rinfo)
 register tTree rinfo;
# endif
{
/* line 2102 "VarDescriptor.puma" */
  {
/* line 2103 "VarDescriptor.puma" */
   if (! ((rinfo == NoTree))) goto yyL1;
  {
/* line 2105 "VarDescriptor.puma" */
   printf ("no reaching info\n");
  }
  }
   return;
yyL1:;

  if (rinfo->Kind == kREACHING_INFO) {
/* line 2108 "VarDescriptor.puma" */
  {
/* line 2110 "VarDescriptor.puma" */
   printf ("reaching info \n ");
/* line 2111 "VarDescriptor.puma" */
   printf (" size var  ");
/* line 2111 "VarDescriptor.puma" */
   FileUnparse (stdout, rinfo->REACHING_INFO.var_allocate);
/* line 2111 "VarDescriptor.puma" */
   printf ("\n");
/* line 2112 "VarDescriptor.puma" */
   printf (" size temp ");
/* line 2112 "VarDescriptor.puma" */
   FileUnparse (stdout, rinfo->REACHING_INFO.temp_allocate);
/* line 2112 "VarDescriptor.puma" */
   printf ("\n");
/* line 2114 "VarDescriptor.puma" */
   SemFile = stdout;
/* line 2116 "VarDescriptor.puma" */
   printf (" dist var  ");
/* line 2116 "VarDescriptor.puma" */
   ShowSpecifiedMapping (rinfo->REACHING_INFO.var_distribution);
/* line 2116 "VarDescriptor.puma" */
   printf ("\n");
/* line 2117 "VarDescriptor.puma" */
   printf (" dist temp ");
/* line 2117 "VarDescriptor.puma" */
   ShowSpecifiedMapping (rinfo->REACHING_INFO.temp_distribution);
/* line 2117 "VarDescriptor.puma" */
   printf ("\n");
  }
   return;

  }
;
}

int GetFormalDim
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int dim)
# else
(vard, dim)
 pvar vard;
 register int dim;
# endif
{
/* line 2128 "VarDescriptor.puma" */
   return LocalGetFormalDim (vard, dim);

}

static void AppendVarDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard1, pvar vard2)
# else
(vard1, vard2)
 pvar vard1;
 pvar vard2;
# endif
{
/* line 2146 "VarDescriptor.puma" */
  {
/* line 2148 "VarDescriptor.puma" */
 int i, rank1, rank2;

     rank1 = vard1->formal_rank;
     rank2 = vard2->formal_rank;

     if (rank1 + rank2 > MAX_DIMENSIONS)

       failure_protocol (MODULE, 
                         "AppendVarDescriptor (result in too high rank)", 
                         vard1->var_tree);

     for (i=0; i<rank2; i++)

      { vard1->formal_shape [rank1+i][0] = vard2->formal_shape [i][0];
        vard1->formal_shape [rank1+i][1] = vard2->formal_shape [i][1];

        vard1->alloc_shape [rank1+i][0] = vard2->alloc_shape [i][0];
        vard1->alloc_shape [rank1+i][1] = vard2->alloc_shape [i][1];

        vard1->expand_shape [rank1+i][0] = vard2->expand_shape [i][0];
        vard1->expand_shape [rank1+i][1] = vard2->expand_shape [i][1];

        vard1->actual_shape [rank1+i][0] = vard2->actual_shape [i][0];
        vard1->actual_shape [rank1+i][1] = vard2->actual_shape [i][1];
        vard1->actual_shape [rank1+i][2] = vard2->actual_shape [i][2];

        vard1->shadow [rank1+i][0] = vard2->shadow [i][0];
        vard1->shadow [rank1+i][1] = vard2->shadow [i][1];

        vard1->distribution_kind [rank1+i] = vard2->distribution_kind [i];
        vard1->distribution_size [rank1+i] = vard2->distribution_size [i];

        vard1->selections [rank1+i] = vard2->selections [i];

        vard1->template_dim [rank1+i] = vard2->template_dim[i];
        vard1->align_mult   [rank1+i] = vard2->align_mult  [i];
        vard1->align_add    [rank1+i] = vard2->align_add   [i];
        vard1->topology_dim [rank1+i] = vard2->topology_dim[i];

      }

     if (SameTopologyObject (vard2->topology_obj, GetDefaultTopology (0)))

      { 

        for (i=0; i<rank2; i++)

         { vard1->template_dim [rank1+i] = 0;
           vard1->align_mult   [rank1+i] = 1;
           vard1->align_add    [rank1+i] = 0;
           vard1->topology_dim [rank1+i] = 0;
         }

        

      }

     else if (SameTopologyObject (vard1->topology_obj, GetDefaultTopology (0)))

       { 

         vard1->shared = vard2->shared;

         vard1->template_obj       = vard2->template_obj;
         vard1->template_rank      = vard2->template_rank;
         vard1->template_inherited = vard2->template_inherited;

         vard1->topology_obj = vard2->topology_obj;
         vard1->topology_rank = vard2->topology_rank;

         for (i=0; i<vard2->topology_rank; i++) 

           { vard1->on_index_dim[i] = vard2->on_index_dim[i] + rank1;
             vard1->on_temp_dim [i] = vard2->on_temp_dim [i];
             vard1->on_kind     [i] = vard2->on_kind[i];
             vard1->on_size     [i] = vard2->on_size[i];
             vard1->on_val      [i] = vard2->on_val[i];
             vard1->on_range [i][0] = vard2->on_range[i][0];
             vard1->on_range [i][1] = vard2->on_range[i][1];
           }

         

         for (i=0; i<rank1; i++)

          { vard1->template_dim [i] = 0;
            vard1->align_mult   [i] = 1;
            vard1->align_add    [i] = 0;
            vard1->topology_dim [i] = 0;
          }

       }

     else

       { 

         printf ("AppendVarDescriptor (failure, two distributions): \n");
         PrintVarDescriptor (vard1);
         PrintVarDescriptor (vard2);

         failure_protocol (MODULE, "AppendVarDescriptor", NoTree);
       } 

     vard1->formal_rank = rank1 + rank2;
     vard1->actual_rank = vard1->actual_rank + vard2->actual_rank;

     

     vard1->type_kind = vard2->type_kind;
     vard1->type_size = vard2->type_size;

   
  }
   return;

;
}

static void AppendSelector
# if defined __STDC__ | defined __cplusplus
(pvar vard, register tTree selector)
# else
(vard, selector)
 pvar vard;
 register tTree selector;
# endif
{
  if (selector->Kind == kREC_COMP) {
/* line 2275 "VarDescriptor.puma" */
  {
/* line 2277 "VarDescriptor.puma" */
 int rank; 

     rank = vard->formal_rank;

#ifdef DEBUG
     printf ("Append Selector ");
     FileUnparse (stdout, selector);
     printf (" to this variable descriptor\n");
     PrintVarDescriptor (vard);
#endif

     if (rank >= MAX_DIMENSIONS)

       failure_protocol (MODULE, "AppendSelector (result in too high rank)", 
                         vard->var_tree);

     vard->formal_shape [rank][0] = NoTree;
     vard->formal_shape [rank][1] = NoTree;

     vard->alloc_shape [rank][0] = NoTree;
     vard->alloc_shape [rank][1] = NoTree;

     vard->expand_shape [rank][0] = NoTree;
     vard->expand_shape [rank][1] = NoTree;

     vard->actual_shape [rank][0] = selector;
     vard->actual_shape [rank][1] = selector;
     vard->actual_shape [rank][2] = NoTree;

     vard->shadow [rank][0] = 0;
     vard->shadow [rank][1] = 0;

     vard->distribution_kind [rank] = kSERIAL_DIM;
     vard->distribution_size [rank] = NoTree;

     vard->selections [rank] = 0;  

     vard->template_dim [rank] = 0;
     vard->align_mult   [rank] = 1;
     vard->align_add    [rank] = 0;
     vard->topology_dim [rank] = 0;

     vard->formal_rank = rank + 1;

     

     if (VarRank (selector->REC_COMP.Object) > 0)  

       { var_descriptor vard1;

          

          SetVarObjDescriptor (&vard1, selector->REC_COMP.Object, NoTree);

#ifdef DEBUG
          printf ("rec component is array with this descriptor :\n");
          PrintVarDescriptor (&vard1);
#endif

          AppendVarDescriptor (vard, &vard1);

        }

#ifdef DEBUG
     printf ("new descriptor with selected component :\n");
     PrintVarDescriptor (vard);
#endif

   
  }
   return;

  }
/* line 2348 "VarDescriptor.puma" */
  {
/* line 2350 "VarDescriptor.puma" */
   failure_protocol (MODULE, "AppendSelector", selector);
  }
   return;

;
}

void BeginVarDescriptor ARGS ((void))
{
}

void CloseVarDescriptor ARGS ((void))
{
}
