# include "VarComm.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 35 "VarComm.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Nesting.h"
# include "ParNest.h"

# include "TreeOps.h"    /* GetVarAcccess */
# include "Objects.h"    /* IsGlobalVar   */

# include "Descriptor.h"
# include "HomeDescriptor.h"   /* IsParallelLoopDescriptor */
# include "Extraction.h"

# include "Distributions.h"
# include "IndShadow.h"
# include "MoveDescriptor.h"
# include "MoveControl.h"     /* VDHasCopy, ... */
# include "StrUnparse.h"
# include "Loops.h"

# define MODULE "VarComm"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyVarComm.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* VarComm_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module VarComm, routine %s failed\n",
  yyFunction);
 VarComm_Exit ();
}

rbool IsLocalVarRead ARGS ((tTree var, pvar home));
tTree CheckReadComm ARGS ((tTree read_var, pvar home));
rbool IsLocalVarWrite ARGS ((tTree var, pvar home));
tTree CheckWriteComm ARGS ((tTree write_var, pvar home));
rbool IsLocalVarGlobal ARGS ((tTree var, pvar home));
tTree CheckReductionComm ARGS ((tTree red_var, pvar home));
static tTree CheckExtraction ARGS ((tTree var, rbool is_read));
static tTree CheckExtractionFrom ARGS ((tTree var, rbool is_read, tTree stmt));
static rbool GoodCommunicationMask ARGS ((tTree var, rbool before));
static rbool ExtractableMask ARGS ((tTree stmt, tTree var, rbool before));
static rbool IsIfStmt ARGS ((tTree stmt));
static rbool IsRMAVar ARGS ((tTree var));
static tTree GlobalReadAccess ARGS ((tTree read_var, int shared_kind));
static tTree GlobalWriteAccess ARGS ((tTree write_var, int shared_kind));
static tTree CheckBCVectorization ARGS ((tTree write_var, pvar write_vd, pvar home));

rbool IsLocalVarRead
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
/* line 75 "VarComm.puma" */
  {
/* line 77 "VarComm.puma" */
   return rfalse;
  }

  }
/* line 80 "VarComm.puma" */
 {
  var_descriptor vard;
  {
/* line 84 "VarComm.puma" */
   SetVarDescriptor (var, & vard);
/* line 85 "VarComm.puma" */
   if (! ((VDHasLocalCopy (home, & vard)))) goto yyL2;
  }
   return rtrue;
 }
yyL2:;

/* line 88 "VarComm.puma" */
  {
/* line 90 "VarComm.puma" */
   if (! ((IsResidentVariable (var)))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 93 "VarComm.puma" */
  {
/* line 95 "VarComm.puma" */
   if (! ((IsNewVariable (var)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  return rfalse;
}

tTree CheckReadComm
# if defined __STDC__ | defined __cplusplus
(register tTree read_var, pvar home)
# else
(read_var, home)
 register tTree read_var;
 pvar home;
# endif
{
/* line 111 "VarComm.puma" */
 {
  tDefinitions var_obj;
  {
/* line 113 "VarComm.puma" */
   if (! ((GetCurrentModel () == HPF_TASK))) goto yyL1;
  {
/* line 114 "VarComm.puma" */
   if (! ((IsGlobalVar (read_var, GetCurrentUnitObject ())))) goto yyL1;
  {
/* line 118 "VarComm.puma" */
   var_obj = GetVarAccessObject (read_var);
/* line 120 "VarComm.puma" */
   if (! ((VarDistribution (var_obj) != 0))) goto yyL1;
  }
  }
  }
   return GlobalReadAccess (read_var, GetVarSharedKind (var_obj));
 }
yyL1:;

/* line 125 "VarComm.puma" */
 {
  var_descriptor vard;
  {
/* line 129 "VarComm.puma" */
   SetVarDescriptor (read_var, & vard);
/* line 130 "VarComm.puma" */
   if (! ((VDHasLocalCopy (home, & vard)))) goto yyL2;
  }
   return read_var;
 }
yyL2:;

/* line 135 "VarComm.puma" */
  {
/* line 137 "VarComm.puma" */
   if (! ((IsResidentVariable (read_var)))) goto yyL3;
  {
/* line 139 "VarComm.puma" */
   tree_protocol ("NO COMMUNICATION (resident, read) needed for : ", read_var);
  }
  }
   return read_var;
yyL3:;

/* line 144 "VarComm.puma" */
  {
/* line 146 "VarComm.puma" */
   if (! ((IsNewVariable (read_var)))) goto yyL4;
  {
/* line 148 "VarComm.puma" */
   tree_protocol ("NO COMMUNICATION (resident, new) needed for : ", read_var);
  }
  }
   return read_var;
yyL4:;

/* line 153 "VarComm.puma" */
  {
/* line 155 "VarComm.puma" */
   if (! ((IsIndShadowVariable (read_var, home)))) goto yyL5;
  {
/* line 157 "VarComm.puma" */
   tree_protocol ("SHADOW COMMUNICATION (get) needed for : ", read_var);
  }
  }
   return read_var;
yyL5:;

/* line 162 "VarComm.puma" */
  {
/* line 164 "VarComm.puma" */
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, read_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (read %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
   return CheckExtraction (read_var, rtrue);

}

rbool IsLocalVarWrite
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
/* line 186 "VarComm.puma" */
  {
/* line 188 "VarComm.puma" */
   return rfalse;
  }

  }
/* line 191 "VarComm.puma" */
 {
  var_descriptor vard;
  {
/* line 195 "VarComm.puma" */
   SetVarDescriptor (var, & vard);
/* line 196 "VarComm.puma" */
   if (! ((VDIsSingleOwner (home, & vard)))) goto yyL2;
  }
   return rtrue;
 }
yyL2:;

/* line 199 "VarComm.puma" */
  {
/* line 201 "VarComm.puma" */
   if (! ((IsNewVariable (var)))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 204 "VarComm.puma" */
  {
/* line 206 "VarComm.puma" */
   if (! ((IsResidentVariable (var)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  return rfalse;
}

tTree CheckWriteComm
# if defined __STDC__ | defined __cplusplus
(register tTree write_var, pvar home)
# else
(write_var, home)
 register tTree write_var;
 pvar home;
# endif
{
/* line 220 "VarComm.puma" */
 {
  tDefinitions var_obj;
  {
/* line 222 "VarComm.puma" */
   if (! ((GetCurrentModel () == HPF_TASK))) goto yyL1;
  {
/* line 223 "VarComm.puma" */
   if (! ((IsGlobalVar (write_var, GetCurrentUnitObject ())))) goto yyL1;
  {
/* line 227 "VarComm.puma" */
   var_obj = GetVarAccessObject (write_var);
  }
  }
  }
   return GlobalWriteAccess (write_var, GetVarSharedKind (var_obj));
 }
yyL1:;

/* line 236 "VarComm.puma" */
 {
  var_descriptor vard;
  {
/* line 240 "VarComm.puma" */
   SetVarDescriptor (write_var, & vard);
/* line 241 "VarComm.puma" */
   if (! ((VDIsSingleOwner (home, & vard)))) goto yyL2;
  }
   return write_var;
 }
yyL2:;

/* line 250 "VarComm.puma" */
  {
/* line 252 "VarComm.puma" */
   if (! ((IsNewVariable (write_var)))) goto yyL3;
  {
/* line 254 "VarComm.puma" */
   tree_protocol ("NO COMMUNICATION (write, new) for : ", write_var);
  }
  }
   return write_var;
yyL3:;

/* line 259 "VarComm.puma" */
  {
/* line 265 "VarComm.puma" */
   if (! ((IsResidentVariable (write_var)))) goto yyL4;
  {
/* line 267 "VarComm.puma" */
   tree_protocol ("NO COMMUNICATION (write, resident) for : ", write_var);
  }
  }
   return write_var;
yyL4:;

/* line 272 "VarComm.puma" */
  {
/* line 274 "VarComm.puma" */
   if (! ((IsIndShadowVariable (write_var, home)))) goto yyL5;
  {
/* line 276 "VarComm.puma" */
   tree_protocol ("SHADOW COMMUNICATION (write) needed for : ", write_var);
  }
  }
   return write_var;
yyL5:;

/* line 281 "VarComm.puma" */
 {
  var_descriptor vard;
  {
/* line 289 "VarComm.puma" */
   SetVarDescriptor (write_var, & vard);
/* line 290 "VarComm.puma" */
   if (! ((VDIsOwner (home, & vard)))) goto yyL6;
  {
/* line 292 "VarComm.puma" */
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, write_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (broadcast %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
  }
   return CheckBCVectorization (write_var, & vard, home);
 }
yyL6:;

/* line 305 "VarComm.puma" */
  {
/* line 307 "VarComm.puma" */
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, write_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (write %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
   return CheckExtraction (write_var, rfalse);

}

rbool IsLocalVarGlobal
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home)
# else
(var, home)
 register tTree var;
 pvar home;
# endif
{
/* line 329 "VarComm.puma" */
 {
  var_descriptor vard;
  {
/* line 333 "VarComm.puma" */
   SetVarDescriptor (var, & vard);
/* line 334 "VarComm.puma" */
   if (! ((VDIsOwner (home, & vard)))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

/* line 337 "VarComm.puma" */
  {
/* line 339 "VarComm.puma" */
   if (! ((IsNewVariable (var)))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 342 "VarComm.puma" */
  {
/* line 344 "VarComm.puma" */
   if (! ((IsResidentVariable (var)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  return rfalse;
}

tTree CheckReductionComm
# if defined __STDC__ | defined __cplusplus
(register tTree red_var, pvar home)
# else
(red_var, home)
 register tTree red_var;
 pvar home;
# endif
{
/* line 358 "VarComm.puma" */
 {
  var_descriptor vard;
  {
/* line 362 "VarComm.puma" */
   SetVarDescriptor (red_var, & vard);
/* line 363 "VarComm.puma" */
   if (! ((VDIsSingleOwner (home, & vard)))) goto yyL1;
  }
   return red_var;
 }
yyL1:;

/* line 368 "VarComm.puma" */
  {
/* line 370 "VarComm.puma" */
   if (! ((IsNewVariable (red_var)))) goto yyL2;
  {
/* line 372 "VarComm.puma" */
   warning_protocol ("reduction on NEW variable not possible");
  }
  }
   return red_var;
yyL2:;

/* line 377 "VarComm.puma" */
  {
/* line 379 "VarComm.puma" */
   if (! ((IsResidentVariable (red_var)))) goto yyL3;
  {
/* line 381 "VarComm.puma" */
   warning_protocol ("reduction on RESIDENT variable not possible");
  }
  }
   return red_var;
yyL3:;

/* line 386 "VarComm.puma" */
  {
/* line 388 "VarComm.puma" */
   if (! ((IsIndShadowVariable (red_var, home)))) goto yyL4;
  {
/* line 390 "VarComm.puma" */
   tree_protocol ("SHADOW COMMUNICATION (reduce) needed for : ", red_var);
  }
  }
   return red_var;
yyL4:;

/* line 395 "VarComm.puma" */
 {
  var_descriptor vard;
  {
/* line 399 "VarComm.puma" */
   SetVarDescriptor (red_var, & vard);
/* line 400 "VarComm.puma" */
   if (! ((VDIsOwner (home, & vard)))) goto yyL5;
  {
/* line 402 "VarComm.puma" */
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, red_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (reduction %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
  }
   return red_var;
 }
yyL5:;

/* line 431 "VarComm.puma" */
  {
/* line 433 "VarComm.puma" */
 char msg[150], str_var[40], str_home[40];
     StrUnparse (str_var, 40, red_var);
     StrUnparse (str_home, 40, PrintableDescriptorVar (home));
     sprintf (msg, "COMMUNICATION (scatter reduction %s) on home %s needed", 
                    str_var, str_home);
     stmt_protocol (msg);
   
  }
   return CheckExtraction (red_var, rfalse);

}

static tTree CheckExtraction
# if defined __STDC__ | defined __cplusplus
(register tTree var, register rbool is_read)
# else
(var, is_read)
 register tTree var;
 register rbool is_read;
# endif
{
/* line 473 "VarComm.puma" */
 {
  tTree new_var;
  {
/* line 477 "VarComm.puma" */
   if (! ((! IsExtractableVar (var, is_read, is_read)))) goto yyL1;
  {
/* line 479 "VarComm.puma" */
 stmt_protocol ("cannot extract communication (DEPENDENCES!!)");
     tree_protocol ("communication needed for ", var);

     new_var = NoTree;

     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
  }
   return new_var;
 }
yyL1:;

/* line 494 "VarComm.puma" */
 {
  tTree new_var;
  rbool before;
  {
/* line 499 "VarComm.puma" */
   before = is_read;
/* line 501 "VarComm.puma" */
   if (! ((! GoodCommunicationMask (var, before)))) goto yyL2;
  {
/* line 503 "VarComm.puma" */
 stmt_protocol ("cannot extract communication (MASK!!)");
     new_var = NoTree;
     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
  }
   return new_var;
 }
yyL2:;

/* line 515 "VarComm.puma" */
 {
  tTree new_var;
  {
/* line 519 "VarComm.puma" */
 int i, n;

     n = GetParNestingDepth ();

     new_var = var;

     for (i=1; i<=n; i++)

        new_var = CheckExtractionFrom (new_var, is_read, GetParNestACF(i));

   
  }
   return new_var;
 }

}

static tTree CheckExtractionFrom
# if defined __STDC__ | defined __cplusplus
(register tTree var, register rbool is_read, register tTree stmt)
# else
(var, is_read, stmt)
 register tTree var;
 register rbool is_read;
 register tTree stmt;
# endif
{
/* line 545 "VarComm.puma" */
  {
/* line 547 "VarComm.puma" */
   if (! ((var == NoTree))) goto yyL1;
  }
   return var;
yyL1:;

  if (var->Kind == kREMOTE_VAR) {
/* line 552 "VarComm.puma" */
   return var;

  }
  if (stmt->Kind == kACF_WHILE) {
/* line 557 "VarComm.puma" */
 {
  tTree new_var;
  {
/* line 561 "VarComm.puma" */
 set_protocol_stmt (stmt);
     stmt_protocol ("cannot extract communication from DO WHILE loop");
     tree_protocol ("communication needed for : ", var);

     new_var = NoTree;
     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
   return new_var;
 }

  }
  if (stmt->Kind == kACF_FORALL) {
/* line 572 "VarComm.puma" */
 {
  tTree new_var;
  {
/* line 574 "VarComm.puma" */
   if (! ((! IsLoopInvariant (GetLoopSlice (stmt), GetParNestACF (1))))) goto yyL4;
  {
/* line 578 "VarComm.puma" */
 tree_protocol ("cannot extract comm from FORALL loop (not rectangular)\n",
                     stmt);

     new_var = NoTree;
     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
  }
   return new_var;
 }
yyL4:;

  }
  if (stmt->Kind == kACF_DO) {
/* line 588 "VarComm.puma" */
 {
  tTree new_var;
  {
/* line 590 "VarComm.puma" */
   if (! ((! IsLoopInvariant (GetLoopSlice (stmt), GetParNestACF (1))))) goto yyL5;
  {
/* line 594 "VarComm.puma" */
 tree_protocol ("cannot extract comm from DO loop (not rectangular):\n",
                    stmt);

     new_var = NoTree;
     if (IsRMAVar (var)) new_var = mREMOTE_VAR (var);;
   
  }
  }
   return new_var;
 }
yyL5:;

  }
/* line 606 "VarComm.puma" */
   return var;

}

static rbool GoodCommunicationMask
# if defined __STDC__ | defined __cplusplus
(register tTree var, register rbool before)
# else
(var, before)
 register tTree var;
 register rbool before;
# endif
{
/* line 628 "VarComm.puma" */
 {
  rbool okay;
  {
/* line 632 "VarComm.puma" */
 tTree SaveNest [50];
     int   i, n;
     int   masks;     

     okay  = rtrue;
     n     = GetParNestingDepth ();
     masks = 0;    

     for (i=n; i>=1; i--)

        { tTree node;
          node = GetParNestACF (i);
          SaveNest[i-1] = node;
          DecParNesting (node);

          if (IsIfStmt (node))

           { if (masks) 

               { okay = rfalse;  
                 stmt_protocol ("too many surrounding IF to extract comm");
               }

              else if (!ExtractableMask (node, var, before))
               
               { okay = rfalse;
                 tree_protocol ("cannot extract mask of this IF stmt:\n", node);
               }

              else masks++;

           } 

        }

     

     for (i=1; i<=n; i++) IncParNesting (SaveNest[i-1]);

   
/* line 673 "VarComm.puma" */
   if (! ((okay))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static rbool ExtractableMask
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree var, register rbool before)
# else
(stmt, var, before)
 register tTree stmt;
 register tTree var;
 register rbool before;
# endif
{
  if (stmt->Kind == kACF_IF) {
  if (stmt->ACF_IF.IF_EXP->Kind == kVAR_EXP) {
/* line 678 "VarComm.puma" */
 {
  rbool is_read;
  {
/* line 682 "VarComm.puma" */
   is_read = rtrue;
/* line 684 "VarComm.puma" */
   if (! ((IsExtractableVar (stmt->ACF_IF.IF_EXP->VAR_EXP.V, is_read, before)))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  }
/* line 687 "VarComm.puma" */
  {
/* line 689 "VarComm.puma" */
   return rfalse;
  }

  }
  return rfalse;
}

static rbool IsIfStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_IF) {
/* line 698 "VarComm.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsRMAVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 711 "VarComm.puma" */
 {
  var_descriptor vard;
  {
/* line 715 "VarComm.puma" */
   SetVarDescriptor (var, & vard);
/* line 717 "VarComm.puma" */
   if (! (((vard . shared == kREMOTE_SHARED) || (vard . shared == kDISTRIBUTED_SHARED) || (vard . shared == kIS_SHARED)))) goto yyL1;
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static tTree GlobalReadAccess
# if defined __STDC__ | defined __cplusplus
(register tTree read_var, register int shared_kind)
# else
(read_var, shared_kind)
 register tTree read_var;
 register int shared_kind;
# endif
{
/* line 731 "VarComm.puma" */

char msg[150], str_var[40];

/* line 735 "VarComm.puma" */
  {
/* line 737 "VarComm.puma" */
   if (! ((shared_kind == kGLOBAL_SHARED))) goto yyL1;
  {
/* line 739 "VarComm.puma" */
 StrUnparse (str_var, 40, read_var);
     sprintf (msg, "shared access for global var %s (kind=%d)",  
                    str_var, shared_kind);
     stmt_protocol (msg);
   
  }
  }
   return read_var;
yyL1:;

/* line 748 "VarComm.puma" */
  {
/* line 750 "VarComm.puma" */
   if (! ((shared_kind == kREMOTE_SHARED))) goto yyL2;
  {
/* line 752 "VarComm.puma" */
 StrUnparse (str_var, 40, read_var);
     sprintf (msg, "remote read access: %s", str_var);
     serious_warning_protocol (msg);
   
  }
  }
   return mREMOTE_VAR (read_var);
yyL2:;

/* line 760 "VarComm.puma" */
  {
/* line 762 "VarComm.puma" */
   if (! ((shared_kind == kDISTRIBUTED_SHARED))) goto yyL3;
  {
/* line 764 "VarComm.puma" */
 StrUnparse (str_var, 40, read_var);
     sprintf (msg, "remote read access: %s", str_var);
     serious_warning_protocol (msg);
   
  }
  }
   return mREMOTE_VAR (read_var);
yyL3:;

/* line 772 "VarComm.puma" */
  {
/* line 774 "VarComm.puma" */
 StrUnparse (str_var, 40, read_var);
     sprintf (msg, "no read access for global var %s (kind=%d)",  
                    str_var, shared_kind);
     error_protocol (msg);
   
  }
   return read_var;

}

static tTree GlobalWriteAccess
# if defined __STDC__ | defined __cplusplus
(register tTree write_var, register int shared_kind)
# else
(write_var, shared_kind)
 register tTree write_var;
 register int shared_kind;
# endif
{
/* line 791 "VarComm.puma" */

char msg[150], str_var[40];

/* line 795 "VarComm.puma" */
  {
/* line 797 "VarComm.puma" */
   if (! ((shared_kind == kGLOBAL_SHARED))) goto yyL1;
  {
/* line 799 "VarComm.puma" */
 StrUnparse (str_var, 40, write_var);
     sprintf (msg, "shared access for global var %s (kind=%d)",  
                    str_var, shared_kind);
     stmt_protocol (msg);
   
  }
  }
   return write_var;
yyL1:;

/* line 808 "VarComm.puma" */
  {
/* line 810 "VarComm.puma" */
   if (! ((shared_kind == kREMOTE_SHARED))) goto yyL2;
  {
/* line 812 "VarComm.puma" */
 StrUnparse (str_var, 40, write_var);
     sprintf (msg, "remote write access: %s", str_var);
     serious_warning_protocol (msg);
   
  }
  }
   return mREMOTE_VAR (write_var);
yyL2:;

/* line 820 "VarComm.puma" */
  {
/* line 822 "VarComm.puma" */
   if (! ((shared_kind == kDISTRIBUTED_SHARED))) goto yyL3;
  {
/* line 824 "VarComm.puma" */
 StrUnparse (str_var, 40, write_var);
     sprintf (msg, "remote write access: %s", str_var);
     serious_warning_protocol (msg);
   
  }
  }
   return mREMOTE_VAR (write_var);
yyL3:;

/* line 832 "VarComm.puma" */
  {
/* line 834 "VarComm.puma" */
 StrUnparse (str_var, 40, write_var);
     sprintf (msg, "no write access for global var %s (kind=%d)",  
                    str_var, shared_kind);
     error_protocol (msg);
   
  }
   return write_var;

}

static tTree CheckBCVectorization
# if defined __STDC__ | defined __cplusplus
(register tTree write_var, pvar write_vd, pvar home)
# else
(write_var, write_vd, home)
 register tTree write_var;
 pvar write_vd;
 pvar home;
# endif
{
/* line 852 "VarComm.puma" */
 {
  rbool okay;
  int i;
  tTree new;
  {
/* line 858 "VarComm.puma" */
 new = write_var;
     okay = rtrue;

     for (i=1; i <= GetParNestingDepth (); i++)

        { rbool inv_home;
          rbool inv_write;
          tTree loop;

          loop = GetParNestACF (i);

          if (IsCountLoop (loop))

            { inv_home = IsLoopInvariantDescriptor (home, loop);
              inv_write = IsLoopInvariantDescriptor (write_vd, loop);

              

              if (inv_write && !inv_home) okay = rfalse;
            }
        }

     if (!okay)

      { stmt_protocol ("cannot vectorize broadcast");
        tree_protocol ("variable is ", write_var);
        new = NoTree;
      }

   
  }
   return new;
 }

}

void BeginVarComm ARGS ((void))
{
}

void CloseVarComm ARGS ((void))
{
}
