# include "Unparse.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 26 "FUnparse.puma" */


# include "Tree.h"
# include "Idents.h"
# include "StringM.h"

# define IndentLength 3    /* indent for nested statements */

# define LineFlag    0     /* 1 prints line comments */
# define CombineFlag 0     /* 1 combines syntax      */

static FILE *f;
static int  indent;

char string[1024];  /* might be very long */

/***********************************************************************
*                                                                      *
*  PROCEDURE FileUnparse (FILE *ef, t : Tree)  - unparsing AST on file *
*                                                                      *
***********************************************************************/

void FileUnparse (ef, t)
FILE *ef;
tTree t;
{ FILE *h;
  h = f;      /* save local file pointer */
  f = ef;     /* set external file */
  Unparse (t);
  f = h;
}

void ind ()
{ int i;
  for (i=0;i<indent+6;i++)
     fprintf (f," ");
}

     /********************************************************
     *                                                       *
     ********************************************************/

void hpf_ind ()

{ int i;
  fprintf (f, "!hpf$ ");
  for (i=6;i<indent+6;i++) fprintf (f," ");

} /* hpf_ind */

     /********************************************************
     *                                                       *
     *  !$OMP      Open MP sm parallel directive             *
     *  !MIC$      CRAY MP sm parallel directive             *
     *  C$PAR .... shared memory parallelization directive   *
     *                                                       *
     ********************************************************/

void par_ind ()

{ int i;

  if (sm_parallelization == OPEN_MP) fprintf (f, "!$OMP ");
   else if (sm_parallelization == CRAY_MP) fprintf (f, "!MIC$ ");
   else fprintf (f, "C$PAR ");
  for (i=6;i<indent+6;i++) fprintf (f," ");

} /* par_ind */

     /********************************************************
     *                                                       *
     ********************************************************/

void adp_ind ()

{ int i;
  fprintf (f, "!ADP$ ");

  for (i=6;i<indent+6;i++) fprintf (f," ");
} /* adp_ind */

     /********************************************************
     *                                                       *
     ********************************************************/

void label_ind (label)
int label;
{ int i;
  char name[100];

  if (label == 0) 
     ind ();
   else if (label < 0)
     { /* label stands for a name */
       for (i=0; i<indent+6;i++)
         fprintf (f," ");
       GetString (-label, name);
       fprintf (f,"%s: ", name);
     }
   else 
     { fprintf (f,"%4d  ",label);
       for (i=0; i<indent;i++)
       fprintf (f," ");
     }
}

void IncIndent () { indent += IndentLength; }
void DecIndent () { indent -= IndentLength; }

void cont_ind ()
{ int i;
  fprintf (f,"     $");
  for (i=0; i<indent;i++)
     fprintf (f," ");
}

void LCR (line)
int line;
{ if (LineFlag)
     fprintf (f," ! line=%d\n", line);
    else
     fprintf (f,"\n");
} /* LCR */

void MyPrintString (f, str)
FILE *f;
char *str;
{ char *spos;
  spos = str;
  while (*spos != 0)
   { if (*spos == '\'')
       fprintf (f, "\'\'");
      else
       fprintf (f, "%c", *spos);
     spos++;
   }
}



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyUnparse.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Unparse_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Unparse, routine %s failed\n",
  yyFunction);
 Unparse_Exit ();
}

void Unparse ARGS ((tTree t));
static int Priority ARGS ((tTree yyP1));
static void ComUnparse ARGS ((tTree t));
static void UnparseElse ARGS ((tTree t));
static void UnparseDoRange ARGS ((tTree slice));
static void ExpUnparse ARGS ((tTree t, int leftprio, int rightprio));
static void GetCenjuExp ARGS ((tTree t, tTree * yyP3, tTree * yyP2));
static tTree MakeCenjuInt ARGS ((tTree exp));
static void OpUnparse ARGS ((tTree t));
static void FormatUnparse ARGS ((tTree t));
static void LayoutUnparse ARGS ((tTree t));
static void ProcSpecUnparse ARGS ((tTree t));
static rbool IsDeferredShape ARGS ((tTree t));
static int UP_List_Length ARGS ((tTree t));
static void FormalParamUnparse ARGS ((tTree t));
static void ParamUnparse ARGS ((tTree t));
static void AttributeUnparse ARGS ((tTree t));
static void AlignSpecUnparse ARGS ((tTree t));
static void UseNameUnparse ARGS ((tTree t));
static void GenSpecUnparse ARGS ((tTree t));
static void CaseSelectorUnparse ARGS ((tTree t));
static void OnSpecUnparse ARGS ((tTree ontop, tTree onlist));
static void OnListUnparse ARGS ((tTree list));
static rbool MoreParameters ARGS ((tTree parameterlist));
static void StatusUnparse ARGS ((tTree status));
static void DepInfoUnparse ARGS ((tTree info));
static void HomeInfoUnparse ARGS ((tTree info));
static void VecInfoUnparse ARGS ((tTree dep_info));
static void SizeUnparse ARGS ((tTree size));
static void EndUnparse ARGS ((tTree t));
static void PrefixUnparse ARGS ((tTree t));
static void DspKindUnparse ARGS ((int kind));
static void HPFBodyUnparse ARGS ((int line, tTree body, int kind));
static void ResidentUnparse ARGS ((tTree resident_vars));
static void NewUnparse ARGS ((tTree new_vars));
static void ResolveACFHome ARGS ((tTree home_body, tTree * yyP6, tTree * yyP5, tTree * yyP4));
static rbool IsDummyParam ARGS ((tTree param));
static void SMParUnparse ARGS ((tTree red_vars, tTree shared_vars, tTree local_vars));
static void SMVarUnparse ARGS ((int kind, tTree var_list, rbool cont));
static rbool EmptyList ARGS ((tTree var_list));
static void SMGetParLoop ARGS ((tTree body, rbool * yyP8, tTree * yyP7));
static void SelectorUnparse ARGS ((int selector));
static void PrintIdent ARGS ((tIdent name));

void Unparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
/* line 185 "FUnparse.puma" */
  {
/* line 187 "FUnparse.puma" */
   if (! ((t == NoTree))) goto yyL1;
  {
/* line 188 "FUnparse.puma" */
   fprintf (f, "<NoTree>");
  }
  }
   return;
yyL1:;


  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 191 "FUnparse.puma" */
  {
/* line 193 "FUnparse.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_LIST:
/* line 196 "FUnparse.puma" */
  {
/* line 198 "FUnparse.puma" */
   Unparse (t->UNIT_LIST.Elem);
/* line 199 "FUnparse.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 202 "FUnparse.puma" */
   return;

  case kDECL_LIST:
  if (t->DECL_LIST.Elem->Kind == kVAR_PARAM_DECL) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
/* line 211 "FUnparse.puma" */
  {
/* line 213 "FUnparse.puma" */
   GetString (t->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, string);
/* line 214 "FUnparse.puma" */
   fprintf (f, "%s ", string);
  }
   return;

  }
/* line 217 "FUnparse.puma" */
  {
/* line 219 "FUnparse.puma" */
   GetString (t->DECL_LIST.Elem->VAR_PARAM_DECL.Ident, string);
/* line 220 "FUnparse.puma" */
   fprintf (f, "%s, ", string);
/* line 221 "FUnparse.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 224 "FUnparse.puma" */
  {
/* line 226 "FUnparse.puma" */
   Unparse (t->DECL_LIST.Elem);
/* line 227 "FUnparse.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kDECL_EMPTY:
/* line 230 "FUnparse.puma" */
   return;

  case kPROGRAM_DECL:
/* line 239 "FUnparse.puma" */
  {
/* line 242 "FUnparse.puma" */
   ind ();
/* line 243 "FUnparse.puma" */
   GetString (t->PROGRAM_DECL.Ident, string);
/* line 244 "FUnparse.puma" */
   fprintf (f, "program %s", string);
/* line 245 "FUnparse.puma" */
   LCR (t->PROGRAM_DECL.Line);
/* line 246 "FUnparse.puma" */
   Unparse (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 247 "FUnparse.puma" */
   EndUnparse (t);
/* line 248 "FUnparse.puma" */
   fprintf (f, "\n");
  }
   return;

  case kPROC_DECL:
/* line 251 "FUnparse.puma" */
  {
/* line 253 "FUnparse.puma" */
   ind ();
/* line 254 "FUnparse.puma" */
   PrefixUnparse (t);
/* line 255 "FUnparse.puma" */
   GetString (t->PROC_DECL.Ident, string);
/* line 256 "FUnparse.puma" */
   fprintf (f, "subroutine %s (", string);
/* line 257 "FUnparse.puma" */
   FormalParamUnparse (t->PROC_DECL.FORMALS);
/* line 258 "FUnparse.puma" */
   fprintf (f, ")");
/* line 259 "FUnparse.puma" */
   LCR (t->PROC_DECL.Line);
/* line 260 "FUnparse.puma" */
   Unparse (t->PROC_DECL.PROC_BODY);
/* line 261 "FUnparse.puma" */
   EndUnparse (t);
/* line 262 "FUnparse.puma" */
   fprintf (f, "\n");
  }
   return;

  case kFUNC_DECL:
/* line 265 "FUnparse.puma" */
  {
/* line 268 "FUnparse.puma" */
   ind ();
/* line 269 "FUnparse.puma" */
   PrefixUnparse (t);
/* line 270 "FUnparse.puma" */
   GetString (t->FUNC_DECL.Ident, string);
/* line 271 "FUnparse.puma" */
   fprintf (f, "function %s (", string);
/* line 272 "FUnparse.puma" */
   FormalParamUnparse (t->FUNC_DECL.FORMALS);
/* line 273 "FUnparse.puma" */
   fprintf (f, ")");
/* line 274 "FUnparse.puma" */
 if (t->FUNC_DECL.RESULT_ID != DefaultId())
        {  GetString (t->FUNC_DECL.RESULT_ID, string);
           fprintf (f," RESULT (%s)", string);
        }
   
/* line 279 "FUnparse.puma" */
   LCR (t->FUNC_DECL.Line);
/* line 280 "FUnparse.puma" */
   Unparse (t->FUNC_DECL.FUNC_BODY);
/* line 281 "FUnparse.puma" */
   EndUnparse (t);
/* line 282 "FUnparse.puma" */
   fprintf (f, "\n");
  }
   return;

  case kMODULE_DECL:
/* line 285 "FUnparse.puma" */
  {
/* line 287 "FUnparse.puma" */
   ind ();
/* line 288 "FUnparse.puma" */
   GetString (t->MODULE_DECL.Ident, string);
/* line 289 "FUnparse.puma" */
   fprintf (f, "module %s\n", string);
/* line 290 "FUnparse.puma" */
   Unparse (t->MODULE_DECL.MODULE_BODY);
/* line 291 "FUnparse.puma" */
   EndUnparse (t);
/* line 292 "FUnparse.puma" */
   fprintf (f, "\n");
  }
   return;

  case kMODULE_PROC_DECL:
/* line 295 "FUnparse.puma" */
  {
/* line 297 "FUnparse.puma" */
   ind ();
/* line 298 "FUnparse.puma" */
   GetString (t->MODULE_PROC_DECL.Ident, string);
/* line 299 "FUnparse.puma" */
   fprintf (f, "module procedure %s\n", string);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 302 "FUnparse.puma" */
  {
/* line 304 "FUnparse.puma" */
   ind ();
/* line 305 "FUnparse.puma" */
   GetString (t->BLOCK_DATA_DECL.Ident, string);
/* line 306 "FUnparse.puma" */
   fprintf (f, "block data %s\n", string);
/* line 307 "FUnparse.puma" */
   Unparse (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 308 "FUnparse.puma" */
   fprintf (f, "\n");
  }
   return;

  case kSTMT_FUNC_DECL:
/* line 311 "FUnparse.puma" */
  {
/* line 313 "FUnparse.puma" */
   ind ();
/* line 314 "FUnparse.puma" */
   GetString (t->STMT_FUNC_DECL.Ident, string);
/* line 315 "FUnparse.puma" */
   fprintf (f, "%s (", string);
/* line 316 "FUnparse.puma" */
   Unparse (t->STMT_FUNC_DECL.FORMALS);
/* line 317 "FUnparse.puma" */
   fprintf (f, ") = ");
/* line 318 "FUnparse.puma" */
   Unparse (t->STMT_FUNC_DECL.FFUNC_BODY);
/* line 319 "FUnparse.puma" */
   fprintf (f, "\n");
  }
   return;

  case kEXTERNAL_DECL:
/* line 322 "FUnparse.puma" */
  {
/* line 324 "FUnparse.puma" */
   ind ();
/* line 325 "FUnparse.puma" */
   GetString (t->EXTERNAL_DECL.Ident, string);
/* line 326 "FUnparse.puma" */
   fprintf (f, "external %s\n", string);
  }
   return;

  case kINTRINSIC_DECL:
/* line 329 "FUnparse.puma" */
  {
/* line 331 "FUnparse.puma" */
   ind ();
/* line 332 "FUnparse.puma" */
   GetString (t->INTRINSIC_DECL.Ident, string);
/* line 333 "FUnparse.puma" */
   fprintf (f, "intrinsic %s\n", string);
  }
   return;

  case kVAR_DECL:
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
  if (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE->Kind == kDUMMY_TYPE) {
/* line 342 "FUnparse.puma" */
  {
/* line 344 "FUnparse.puma" */
   ind ();
/* line 346 "FUnparse.puma" */
 if (FortranAllocatable() && IsDeferredShape (t->VAR_DECL.VAL))
     {  fprintf (f,"allocatable :: ");
        GetString (t->VAR_DECL.Ident, string);
        fprintf (f," %s (", string);
        Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
        fprintf (f,")");
        LCR (t->VAR_DECL.Line);
     }
     else
     {  fprintf (f,"dimension ");
        GetString (t->VAR_DECL.Ident, string);
        fprintf (f,"%s (", string);
        Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
        fprintf (f,")");
        LCR (t->VAR_DECL.Line);
     }
   
  }
   return;

  }
/* line 365 "FUnparse.puma" */
  {
/* line 367 "FUnparse.puma" */
   ind ();
/* line 368 "FUnparse.puma" */
   Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE);
/* line 370 "FUnparse.puma" */
 if (FortranAllocatable() && IsDeferredShape (t->VAR_DECL.VAL))
     {  fprintf (f,", allocatable :: ");
        GetString (t->VAR_DECL.Ident, string);
        fprintf (f," %s (", string);
        Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
        fprintf (f,")");
        LCR (t->VAR_DECL.Line);
     }
     else
     {  GetString (t->VAR_DECL.Ident, string);
        fprintf (f," %s (", string);
        Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
        fprintf (f,")");
        LCR (t->VAR_DECL.Line);
     }
   
  }
   return;

  }
/* line 388 "FUnparse.puma" */
  {
/* line 390 "FUnparse.puma" */
   ind ();
/* line 391 "FUnparse.puma" */
   Unparse (t->VAR_DECL.VAL);
/* line 392 "FUnparse.puma" */
   GetString (t->VAR_DECL.Ident, string);
/* line 393 "FUnparse.puma" */
   fprintf (f, " %s", string);
/* line 394 "FUnparse.puma" */
   LCR (t->VAR_DECL.Line);
  }
   return;

  case kVAR_PARAM_DECL:
/* line 397 "FUnparse.puma" */
  {
/* line 399 "FUnparse.puma" */
   ind ();
/* line 400 "FUnparse.puma" */
   Unparse (t->VAR_PARAM_DECL.VAL);
/* line 401 "FUnparse.puma" */
   GetString (t->VAR_PARAM_DECL.Ident, string);
/* line 402 "FUnparse.puma" */
   fprintf (f, " %s", string);
/* line 403 "FUnparse.puma" */
   LCR (t->VAR_PARAM_DECL.Line);
  }
   return;

  case kENTITY_DECL:
  if (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Elem->Kind == kTYPESPEC_DECL) {
/* line 406 "FUnparse.puma" */
  {
/* line 408 "FUnparse.puma" */
   ind ();
/* line 409 "FUnparse.puma" */
   Unparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Elem->TYPESPEC_DECL.VAL);
/* line 410 "FUnparse.puma" */
   AttributeUnparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Next);
/* line 411 "FUnparse.puma" */
   GetString (t->ENTITY_DECL.Ident, string);
/* line 412 "FUnparse.puma" */
   fprintf (f, " :: %s", string);
/* line 413 "FUnparse.puma" */
   LCR (t->ENTITY_DECL.Line);
  }
   return;

  }
/* line 416 "FUnparse.puma" */
  {
/* line 418 "FUnparse.puma" */
   fprintf (f, "!HPF$ ");
/* line 419 "FUnparse.puma" */
   AttributeUnparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Elem);
/* line 420 "FUnparse.puma" */
   AttributeUnparse (t->ENTITY_DECL.ATTRIBUTES->DECL_LIST.Next);
/* line 421 "FUnparse.puma" */
   GetString (t->ENTITY_DECL.Ident, string);
/* line 422 "FUnparse.puma" */
   fprintf (f, " :: %s", string);
/* line 423 "FUnparse.puma" */
   LCR (t->ENTITY_DECL.Line);
  }
   return;

  case kTEMPLATE_DECL:
  if (t->TEMPLATE_DECL.DIMENSIONS->Kind == kSHAPE_EMPTY) {
/* line 434 "FUnparse.puma" */
  {
/* line 436 "FUnparse.puma" */
   GetString (t->TEMPLATE_DECL.Ident, string);
/* line 437 "FUnparse.puma" */
   fprintf (f, "!hpf$ template %s", string);
/* line 438 "FUnparse.puma" */
   LCR (t->TEMPLATE_DECL.Line);
  }
   return;

  }
/* line 441 "FUnparse.puma" */
  {
/* line 443 "FUnparse.puma" */
   GetString (t->TEMPLATE_DECL.Ident, string);
/* line 444 "FUnparse.puma" */
   fprintf (f, "!hpf$ template %s (", string);
/* line 445 "FUnparse.puma" */
   Unparse (t->TEMPLATE_DECL.DIMENSIONS);
/* line 446 "FUnparse.puma" */
   fprintf (f, ")");
/* line 447 "FUnparse.puma" */
   LCR (t->TEMPLATE_DECL.Line);
  }
   return;

  case kRAGGED_DECL:
/* line 450 "FUnparse.puma" */
  {
/* line 452 "FUnparse.puma" */
   GetString (t->RAGGED_DECL.Ident, string);
/* line 453 "FUnparse.puma" */
   fprintf (f, "!adp$ ragged %s (", string);
/* line 454 "FUnparse.puma" */
   Unparse (t->RAGGED_DECL.DIMENSIONS);
/* line 455 "FUnparse.puma" */
   fprintf (f, ")");
/* line 456 "FUnparse.puma" */
   LCR (t->RAGGED_DECL.Line);
  }
   return;

  case kPROCESSORS_DECL:
  if (t->PROCESSORS_DECL.DIMENSIONS->Kind == kSHAPE_EMPTY) {
/* line 459 "FUnparse.puma" */
  {
/* line 461 "FUnparse.puma" */
   GetString (t->PROCESSORS_DECL.Ident, string);
/* line 462 "FUnparse.puma" */
   fprintf (f, "!hpf$ processors %s", string);
/* line 463 "FUnparse.puma" */
   LCR (t->PROCESSORS_DECL.Line);
  }
   return;

  }
/* line 466 "FUnparse.puma" */
  {
/* line 468 "FUnparse.puma" */
   GetString (t->PROCESSORS_DECL.Ident, string);
/* line 469 "FUnparse.puma" */
   fprintf (f, "!hpf$ processors %s (", string);
/* line 470 "FUnparse.puma" */
   Unparse (t->PROCESSORS_DECL.DIMENSIONS);
/* line 471 "FUnparse.puma" */
   fprintf (f, ")");
/* line 472 "FUnparse.puma" */
   LCR (t->PROCESSORS_DECL.Line);
  }
   return;

  case kSUB_PROCS_DECL:
/* line 475 "FUnparse.puma" */
  {
/* line 477 "FUnparse.puma" */
   GetString (t->SUB_PROCS_DECL.Ident, string);
/* line 478 "FUnparse.puma" */
   fprintf (f, "!hpf$ sub_procs %s of ", string);
/* line 479 "FUnparse.puma" */
   Unparse (t->SUB_PROCS_DECL.TOP);
/* line 480 "FUnparse.puma" */
   fprintf (f, "(");
/* line 481 "FUnparse.puma" */
   Unparse (t->SUB_PROCS_DECL.DIMENSIONS);
/* line 482 "FUnparse.puma" */
   fprintf (f, ")");
/* line 483 "FUnparse.puma" */
   LCR (t->SUB_PROCS_DECL.Line);
  }
   return;

  case kIMPLICIT_DECL:
  if (t->IMPLICIT_DECL.TYPE->Kind == kDUMMY_TYPE) {
/* line 486 "FUnparse.puma" */
  {
/* line 488 "FUnparse.puma" */
   ind ();
/* line 489 "FUnparse.puma" */
   fprintf (f, "implicit none");
/* line 490 "FUnparse.puma" */
   LCR (t->IMPLICIT_DECL.Line);
  }
   return;

  }
/* line 493 "FUnparse.puma" */
  {
/* line 495 "FUnparse.puma" */
   ind ();
/* line 496 "FUnparse.puma" */
   fprintf (f, "implicit ");
/* line 497 "FUnparse.puma" */
   Unparse (t->IMPLICIT_DECL.TYPE);
/* line 498 "FUnparse.puma" */
   GetString (t->IMPLICIT_DECL.first, string);
/* line 499 "FUnparse.puma" */
   fprintf (f, " (%s-", string);
/* line 500 "FUnparse.puma" */
   GetString (t->IMPLICIT_DECL.last, string);
/* line 501 "FUnparse.puma" */
   fprintf (f, "%s)", string);
/* line 502 "FUnparse.puma" */
   LCR (t->IMPLICIT_DECL.Line);
  }
   return;

  case kCOMMON_DECL:
  if (t->COMMON_DECL.IDS->Kind == kDECL_EMPTY) {
/* line 505 "FUnparse.puma" */
   return;

  }
/* line 510 "FUnparse.puma" */
  {
/* line 512 "FUnparse.puma" */
   GetString (t->COMMON_DECL.Ident, string);
/* line 513 "FUnparse.puma" */
   ind ();
/* line 515 "FUnparse.puma" */
   if ((t->COMMON_DECL.Ident == DefaultId ())) {
/* line 516 "FUnparse.puma" */
   fprintf (f, "common / /");
   } else {
/* line 518 "FUnparse.puma" */
   fprintf (f, "common /%s/", string);
   }
/* line 521 "FUnparse.puma" */
   ComUnparse (t->COMMON_DECL.IDS);
/* line 522 "FUnparse.puma" */
   LCR (t->COMMON_DECL.Line);
  }
   return;

  case kNAMELIST_DECL:
/* line 525 "FUnparse.puma" */
  {
/* line 527 "FUnparse.puma" */
   GetString (t->NAMELIST_DECL.Ident, string);
/* line 528 "FUnparse.puma" */
   ind ();
/* line 529 "FUnparse.puma" */
   fprintf (f, "namelist /%s/", string);
/* line 530 "FUnparse.puma" */
   ComUnparse (t->NAMELIST_DECL.IDS);
/* line 531 "FUnparse.puma" */
   LCR (t->NAMELIST_DECL.Line);
  }
   return;

  case kEQV_DECL:
/* line 534 "FUnparse.puma" */
  {
/* line 536 "FUnparse.puma" */
   ind ();
/* line 537 "FUnparse.puma" */
   fprintf (f, "equivalence (");
/* line 538 "FUnparse.puma" */
   Unparse (t->EQV_DECL.VARS);
/* line 539 "FUnparse.puma" */
   fprintf (f, ")");
/* line 540 "FUnparse.puma" */
   LCR (t->EQV_DECL.Line);
  }
   return;

  case kUSE_DECL:
  if (t->USE_DECL.RENAMINGS->Kind == kDECL_EMPTY) {
/* line 549 "FUnparse.puma" */
  {
/* line 551 "FUnparse.puma" */
   ind ();
/* line 552 "FUnparse.puma" */
   GetString (t->USE_DECL.use, string);
/* line 553 "FUnparse.puma" */
   fprintf (f, "use %s", string);
/* line 554 "FUnparse.puma" */
   LCR (t->USE_DECL.Line);
  }
   return;

  }
/* line 557 "FUnparse.puma" */
  {
/* line 559 "FUnparse.puma" */
   ind ();
/* line 560 "FUnparse.puma" */
   GetString (t->USE_DECL.use, string);
/* line 561 "FUnparse.puma" */
   fprintf (f, "use %s , ", string);
/* line 562 "FUnparse.puma" */
   UseNameUnparse (t->USE_DECL.RENAMINGS);
/* line 563 "FUnparse.puma" */
   LCR (t->USE_DECL.Line);
  }
   return;

  case kONLY_USE_DECL:
/* line 566 "FUnparse.puma" */
  {
/* line 568 "FUnparse.puma" */
   ind ();
/* line 569 "FUnparse.puma" */
   GetString (t->ONLY_USE_DECL.use, string);
/* line 570 "FUnparse.puma" */
   fprintf (f, "use %s only : ", string);
/* line 571 "FUnparse.puma" */
   UseNameUnparse (t->ONLY_USE_DECL.NAMES);
/* line 572 "FUnparse.puma" */
   LCR (t->ONLY_USE_DECL.Line);
  }
   return;

  case kTYPE_DECL:
  if (t->TYPE_DECL.VAL->Kind == kRECORD_TYPE) {
/* line 581 "FUnparse.puma" */
  {
/* line 583 "FUnparse.puma" */
   ind ();
/* line 584 "FUnparse.puma" */
   GetString (t->TYPE_DECL.Ident, string);
/* line 585 "FUnparse.puma" */
   fprintf (f, "type %s", string);
/* line 586 "FUnparse.puma" */
   LCR (t->TYPE_DECL.Line);
/* line 587 "FUnparse.puma" */
   IncIndent ();
/* line 588 "FUnparse.puma" */
   Unparse (t->TYPE_DECL.VAL->RECORD_TYPE.COMPONENTS);
/* line 589 "FUnparse.puma" */
   DecIndent ();
/* line 590 "FUnparse.puma" */
   ind ();
/* line 591 "FUnparse.puma" */
   fprintf (f, "end type\n");
  }
   return;

  }
  break;
  case kINTERFACE:
/* line 600 "FUnparse.puma" */
  {
/* line 602 "FUnparse.puma" */
   ind ();
/* line 603 "FUnparse.puma" */
   fprintf (f, "interface");
/* line 604 "FUnparse.puma" */
   GenSpecUnparse (t->INTERFACE.SPEC);
/* line 605 "FUnparse.puma" */
   LCR (t->INTERFACE.Line);
/* line 606 "FUnparse.puma" */
   IncIndent ();
/* line 607 "FUnparse.puma" */
   Unparse (t->INTERFACE.ITEMS);
/* line 608 "FUnparse.puma" */
   DecIndent ();
/* line 609 "FUnparse.puma" */
   ind ();
/* line 610 "FUnparse.puma" */
   fprintf (f, "end interface\n");
  }
   return;

  case kINTERFACE_DECL:
/* line 613 "FUnparse.puma" */
  {
/* line 615 "FUnparse.puma" */
   ind ();
/* line 616 "FUnparse.puma" */
   fprintf (f, "interface");
/* line 617 "FUnparse.puma" */
   GenSpecUnparse (t->INTERFACE_DECL.SPEC);
/* line 618 "FUnparse.puma" */
   LCR (t->INTERFACE_DECL.Line);
/* line 619 "FUnparse.puma" */
   IncIndent ();
/* line 620 "FUnparse.puma" */
   Unparse (t->INTERFACE_DECL.ITEMS);
/* line 621 "FUnparse.puma" */
   DecIndent ();
/* line 622 "FUnparse.puma" */
   ind ();
/* line 623 "FUnparse.puma" */
   fprintf (f, "end interface\n");
  }
   return;

  case kDIMENSION_DECL:
/* line 632 "FUnparse.puma" */
  {
/* line 634 "FUnparse.puma" */
   ind ();
/* line 635 "FUnparse.puma" */
   GetString (t->DIMENSION_DECL.Ident, string);
/* line 636 "FUnparse.puma" */
   fprintf (f, "dimension %s (", string);
/* line 637 "FUnparse.puma" */
   Unparse (t->DIMENSION_DECL.INDEXES);
/* line 638 "FUnparse.puma" */
   fprintf (f, ")");
/* line 639 "FUnparse.puma" */
   LCR (t->DIMENSION_DECL.Line);
  }
   return;

  case kPARAMETER_DECL:
/* line 642 "FUnparse.puma" */
  {
/* line 644 "FUnparse.puma" */
   ind ();
/* line 645 "FUnparse.puma" */
   GetString (t->PARAMETER_DECL.Ident, string);
/* line 646 "FUnparse.puma" */
   fprintf (f, "parameter (%s = ", string);
/* line 647 "FUnparse.puma" */
   Unparse (t->PARAMETER_DECL.VAL);
/* line 648 "FUnparse.puma" */
   fprintf (f, ")");
/* line 649 "FUnparse.puma" */
   LCR (t->PARAMETER_DECL.Line);
  }
   return;

  case kSAVE_DECL:
/* line 652 "FUnparse.puma" */
  {
/* line 654 "FUnparse.puma" */
   if (! ((t->SAVE_DECL.Ident == DefaultId ()))) goto yyL45;
  {
/* line 656 "FUnparse.puma" */
   ind ();
/* line 657 "FUnparse.puma" */
   fprintf (f, "save", string);
/* line 658 "FUnparse.puma" */
   LCR (t->SAVE_DECL.Line);
  }
  }
   return;
yyL45:;

/* line 661 "FUnparse.puma" */
  {
/* line 663 "FUnparse.puma" */
   ind ();
/* line 664 "FUnparse.puma" */
   GetString (t->SAVE_DECL.Ident, string);
/* line 665 "FUnparse.puma" */
   fprintf (f, "save %s", string);
/* line 666 "FUnparse.puma" */
   LCR (t->SAVE_DECL.Line);
  }
   return;

  case kINTENT_DECL:
/* line 669 "FUnparse.puma" */
  {
/* line 671 "FUnparse.puma" */
   ind ();
/* line 672 "FUnparse.puma" */
   GetString (t->INTENT_DECL.Ident, string);
/* line 674 "FUnparse.puma" */
 switch (t->INTENT_DECL.intent) {
       case IntentIn    : fprintf (f,"intent(in) %s", string); break;
       case IntentInOut : fprintf (f,"intent(inout) %s", string); break;
       case IntentOut   : fprintf (f,"intent(out) %s", string); break;
       default          : fprintf (f,"intent(:-:-:-) %s", string); break;
     } 
   
/* line 681 "FUnparse.puma" */
   LCR (t->INTENT_DECL.Line);
  }
   return;

  case kOPTIONAL_DECL:
/* line 684 "FUnparse.puma" */
  {
/* line 686 "FUnparse.puma" */
   ind ();
/* line 687 "FUnparse.puma" */
   GetString (t->OPTIONAL_DECL.Ident, string);
/* line 688 "FUnparse.puma" */
   fprintf (f, "optional %s", string);
/* line 689 "FUnparse.puma" */
   LCR (t->OPTIONAL_DECL.Line);
  }
   return;

  case kTARGET_DECL:
/* line 692 "FUnparse.puma" */
  {
/* line 694 "FUnparse.puma" */
   ind ();
/* line 695 "FUnparse.puma" */
   GetString (t->TARGET_DECL.Ident, string);
/* line 696 "FUnparse.puma" */
   fprintf (f, "target %s", string);
/* line 697 "FUnparse.puma" */
   LCR (t->TARGET_DECL.Line);
  }
   return;

  case kPOINTER_DECL:
/* line 700 "FUnparse.puma" */
  {
/* line 702 "FUnparse.puma" */
   ind ();
/* line 703 "FUnparse.puma" */
   GetString (t->POINTER_DECL.Ident, string);
/* line 704 "FUnparse.puma" */
   fprintf (f, "pointer %s", string);
/* line 705 "FUnparse.puma" */
   LCR (t->POINTER_DECL.Line);
  }
   return;

  case kALLOCATABLE_DECL:
/* line 708 "FUnparse.puma" */
  {
/* line 710 "FUnparse.puma" */
   ind ();
/* line 711 "FUnparse.puma" */
   GetString (t->ALLOCATABLE_DECL.Ident, string);
/* line 712 "FUnparse.puma" */
   fprintf (f, "allocatable %s", string);
/* line 713 "FUnparse.puma" */
   LCR (t->ALLOCATABLE_DECL.Line);
  }
   return;

  case kPUBLIC_DECL:
/* line 716 "FUnparse.puma" */
  {
/* line 718 "FUnparse.puma" */
   ind ();
/* line 719 "FUnparse.puma" */
   GetString (t->PUBLIC_DECL.Ident, string);
/* line 720 "FUnparse.puma" */
   fprintf (f, "public %s", string);
/* line 721 "FUnparse.puma" */
   LCR (t->PUBLIC_DECL.Line);
  }
   return;

  case kPRIVATE_DECL:
/* line 724 "FUnparse.puma" */
  {
/* line 726 "FUnparse.puma" */
   ind ();
/* line 727 "FUnparse.puma" */
   GetString (t->PRIVATE_DECL.Ident, string);
/* line 728 "FUnparse.puma" */
   fprintf (f, "private %s", string);
/* line 729 "FUnparse.puma" */
   LCR (t->PRIVATE_DECL.Line);
  }
   return;

  case kALIGN_DECL:
  if (t->ALIGN_DECL.ALIGN_SOURCE->Kind == kBTE_EMPTY) {
/* line 732 "FUnparse.puma" */
  {
/* line 734 "FUnparse.puma" */
   GetString (t->ALIGN_DECL.Ident, string);
/* line 735 "FUnparse.puma" */
   fprintf (f, "!hpf$ align %s with ", string);
/* line 736 "FUnparse.puma" */
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_TARGET);
/* line 737 "FUnparse.puma" */
   LCR (t->ALIGN_DECL.Line);
  }
   return;

  }
/* line 740 "FUnparse.puma" */
  {
/* line 742 "FUnparse.puma" */
   GetString (t->ALIGN_DECL.Ident, string);
/* line 743 "FUnparse.puma" */
   fprintf (f, "!hpf$ align %s (", string);
/* line 744 "FUnparse.puma" */
   Unparse (t->ALIGN_DECL.ALIGN_SOURCE);
/* line 745 "FUnparse.puma" */
   fprintf (f, ") with ");
/* line 746 "FUnparse.puma" */
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_TARGET);
/* line 747 "FUnparse.puma" */
   LCR (t->ALIGN_DECL.Line);
  }
   return;

  case kDYNAMIC_DECL:
/* line 750 "FUnparse.puma" */
  {
/* line 752 "FUnparse.puma" */
   GetString (t->DYNAMIC_DECL.Ident, string);
/* line 753 "FUnparse.puma" */
   fprintf (f, "!hpf$ dynamic %s", string);
/* line 754 "FUnparse.puma" */
   LCR (t->DYNAMIC_DECL.Line);
  }
   return;

  case kINHERIT_DECL:
/* line 757 "FUnparse.puma" */
  {
/* line 759 "FUnparse.puma" */
   GetString (t->INHERIT_DECL.Ident, string);
/* line 760 "FUnparse.puma" */
   fprintf (f, "!hpf$ inherit %s", string);
/* line 761 "FUnparse.puma" */
   LCR (t->INHERIT_DECL.Line);
  }
   return;

  case kRANGE_DECL:
/* line 764 "FUnparse.puma" */
  {
/* line 766 "FUnparse.puma" */
   GetString (t->RANGE_DECL.Ident, string);
/* line 767 "FUnparse.puma" */
   fprintf (f, "!hpf$ range %s ", string);
/* line 768 "FUnparse.puma" */
   Unparse (t->RANGE_DECL.RANGES);
/* line 769 "FUnparse.puma" */
   LCR (t->RANGE_DECL.Line);
  }
   return;

  case kRANGE_LIST:
  if (t->RANGE_LIST.Next->Kind == kRANGE_LIST) {
/* line 772 "FUnparse.puma" */
  {
/* line 774 "FUnparse.puma" */
   LayoutUnparse (t->RANGE_LIST.Elem);
/* line 775 "FUnparse.puma" */
   fprintf (f, " ");
/* line 776 "FUnparse.puma" */
   t = t->RANGE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->RANGE_LIST.Next->Kind == kRANGE_EMPTY) {
/* line 779 "FUnparse.puma" */
  {
/* line 781 "FUnparse.puma" */
   LayoutUnparse (t->RANGE_LIST.Elem);
  }
   return;

  }
  break;
  case kDISTRIBUTE_DECL:
/* line 784 "FUnparse.puma" */
  {
/* line 786 "FUnparse.puma" */
   GetString (t->DISTRIBUTE_DECL.Ident, string);
/* line 787 "FUnparse.puma" */
   fprintf (f, "!hpf$ distribute %s ", string);
/* line 788 "FUnparse.puma" */
   LayoutUnparse (t->DISTRIBUTE_DECL.DISTRIBUTION);
/* line 789 "FUnparse.puma" */
   ProcSpecUnparse (t->DISTRIBUTE_DECL.TARGET);
/* line 790 "FUnparse.puma" */
   LCR (t->DISTRIBUTE_DECL.Line);
  }
   return;

  case kSHARED_DECL:
/* line 793 "FUnparse.puma" */
  {
/* line 795 "FUnparse.puma" */
   GetString (t->SHARED_DECL.Ident, string);
/* line 797 "FUnparse.puma" */
 switch (t->SHARED_DECL.kind) {

      case kGLOBAL_SHARED      : fprintf (f,"!adp$ shared %s", string);
                                 break;
      case kREMOTE_SHARED      : fprintf (f,"!adp$ remote shared %s", 
                                          string); break;
      case kDISTRIBUTED_SHARED : fprintf (f,"!adp$ distributed shared %s",
                                          string); break;
      case kIS_SHARED          : fprintf (f,"!adp$ *shared %s", string);
                                 break;
      case kNOT_SHARED         : fprintf (f,"!adp$ distributed %s", string);
                                 break;
      default                  : fprintf (f,"adp$ :-:-:- shared %s", string);

     } 
   
/* line 814 "FUnparse.puma" */
   LCR (t->SHARED_DECL.Line);
  }
   return;

  case kTRACE_DECL:
/* line 817 "FUnparse.puma" */
  {
/* line 819 "FUnparse.puma" */
   GetString (t->TRACE_DECL.Ident, string);
/* line 820 "FUnparse.puma" */
   fprintf (f, "!adp$ trace %s", string);
/* line 821 "FUnparse.puma" */
   LCR (t->TRACE_DECL.Line);
  }
   return;

  case kNODSP_DECL:
/* line 824 "FUnparse.puma" */
  {
/* line 826 "FUnparse.puma" */
   GetString (t->NODSP_DECL.Ident, string);
/* line 827 "FUnparse.puma" */
   fprintf (f, "!adp$ nodescriptor %s", string);
/* line 828 "FUnparse.puma" */
   LCR (t->NODSP_DECL.Line);
  }
   return;

  case kTREE_DECL:
/* line 831 "FUnparse.puma" */
  {
/* line 833 "FUnparse.puma" */
   GetString (t->TREE_DECL.Ident, string);
/* line 834 "FUnparse.puma" */
   fprintf (f, "!adp$ tree %s", string);
/* line 835 "FUnparse.puma" */
   LCR (t->TREE_DECL.Line);
  }
   return;

  case kSELECT_DECL:
/* line 838 "FUnparse.puma" */
  {
/* line 840 "FUnparse.puma" */
   GetString (t->SELECT_DECL.Ident, string);
/* line 841 "FUnparse.puma" */
   fprintf (f, "!adp$ select %s (", string);
/* line 842 "FUnparse.puma" */
   Unparse (t->SELECT_DECL.SELECTIONS);
/* line 843 "FUnparse.puma" */
   fprintf (f, ")");
/* line 844 "FUnparse.puma" */
   LCR (t->SELECT_DECL.Line);
  }
   return;

  case kSELECT_LIST:
  if (t->SELECT_LIST.Next->Kind == kSELECT_EMPTY) {
/* line 847 "FUnparse.puma" */
  {
/* line 849 "FUnparse.puma" */
   t = t->SELECT_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 852 "FUnparse.puma" */
  {
/* line 854 "FUnparse.puma" */
   Unparse (t->SELECT_LIST.Elem);
/* line 855 "FUnparse.puma" */
   fprintf (f, ",");
/* line 856 "FUnparse.puma" */
   t = t->SELECT_LIST.Next;
   goto yyRecursion;
  }

  case kSELECT_SPEC:
/* line 859 "FUnparse.puma" */
  {
/* line 861 "FUnparse.puma" */
   if (! ((! t->SELECT_SPEC.selector))) goto yyL69;
  {
/* line 863 "FUnparse.puma" */
   fprintf (f, "*");
  }
  }
   return;
yyL69:;

/* line 866 "FUnparse.puma" */
  {
/* line 868 "FUnparse.puma" */
   SelectorUnparse (t->SELECT_SPEC.selector);
  }
   return;

  case kSHADOW_DECL:
/* line 871 "FUnparse.puma" */
  {
/* line 873 "FUnparse.puma" */
   GetString (t->SHADOW_DECL.Ident, string);
/* line 874 "FUnparse.puma" */
   fprintf (f, "!hpf$ shadow %s (", string);
/* line 875 "FUnparse.puma" */
   Unparse (t->SHADOW_DECL.SHADOWS);
/* line 876 "FUnparse.puma" */
   fprintf (f, ")");
/* line 877 "FUnparse.puma" */
   LCR (t->SHADOW_DECL.Line);
  }
   return;

  case kSHADOW_LIST:
  if (t->SHADOW_LIST.Next->Kind == kSHADOW_EMPTY) {
/* line 880 "FUnparse.puma" */
  {
/* line 882 "FUnparse.puma" */
   t = t->SHADOW_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 885 "FUnparse.puma" */
  {
/* line 887 "FUnparse.puma" */
   Unparse (t->SHADOW_LIST.Elem);
/* line 888 "FUnparse.puma" */
   fprintf (f, ",");
/* line 889 "FUnparse.puma" */
   t = t->SHADOW_LIST.Next;
   goto yyRecursion;
  }

  case kSHADOW_SPEC:
/* line 892 "FUnparse.puma" */
  {
/* line 895 "FUnparse.puma" */
   Unparse (t->SHADOW_SPEC.SHADOW_LEFT);
/* line 896 "FUnparse.puma" */
   fprintf (f, ":");
/* line 897 "FUnparse.puma" */
   Unparse (t->SHADOW_SPEC.SHADOW_RIGHT);
/* line 899 "FUnparse.puma" */
   if ((t->SHADOW_SPEC.full_flag)) {
/* line 900 "FUnparse.puma" */
   fprintf (f, "[!%d:!%d]", t->SHADOW_SPEC.left_size, t->SHADOW_SPEC.right_size);
   } else {
/* line 902 "FUnparse.puma" */
   fprintf (f, "[%d:%d]", t->SHADOW_SPEC.left_size, t->SHADOW_SPEC.right_size);
   }
  }
   return;

  case kSEQUENCE_DECL:
/* line 906 "FUnparse.puma" */
  {
/* line 908 "FUnparse.puma" */
   ind ();
/* line 909 "FUnparse.puma" */
   GetString (t->SEQUENCE_DECL.Ident, string);
/* line 910 "FUnparse.puma" */
   fprintf (f, "sequence %s", string);
/* line 911 "FUnparse.puma" */
   LCR (t->SEQUENCE_DECL.Line);
  }
   return;

  case kHPF_SEQUENCE_DECL:
/* line 914 "FUnparse.puma" */
  {
/* line 916 "FUnparse.puma" */
   hpf_ind ();
/* line 917 "FUnparse.puma" */
   GetString (t->HPF_SEQUENCE_DECL.Ident, string);
/* line 918 "FUnparse.puma" */
   fprintf (f, "sequence %s", string);
/* line 919 "FUnparse.puma" */
   LCR (t->HPF_SEQUENCE_DECL.Line);
  }
   return;

  case kNOSEQUENCE_DECL:
/* line 922 "FUnparse.puma" */
  {
/* line 924 "FUnparse.puma" */
   hpf_ind ();
/* line 925 "FUnparse.puma" */
   GetString (t->NOSEQUENCE_DECL.Ident, string);
/* line 926 "FUnparse.puma" */
   fprintf (f, "no sequence %s", string);
/* line 927 "FUnparse.puma" */
   LCR (t->NOSEQUENCE_DECL.Line);
  }
   return;

  case kFORMAT_DECL:
/* line 930 "FUnparse.puma" */
  {
/* line 932 "FUnparse.puma" */
   label_ind (t->FORMAT_DECL.label);
/* line 933 "FUnparse.puma" */
   fprintf (f, "format ");
/* line 934 "FUnparse.puma" */
   FormatUnparse (t->FORMAT_DECL.FORMAT_PARAMS);
/* line 935 "FUnparse.puma" */
   LCR (t->FORMAT_DECL.Line);
  }
   return;

  case kDATA_DECL:
/* line 938 "FUnparse.puma" */
  {
/* line 940 "FUnparse.puma" */
   ind ();
/* line 941 "FUnparse.puma" */
   fprintf (f, "data ");
/* line 942 "FUnparse.puma" */
   Unparse (t->DATA_DECL.VARS);
/* line 943 "FUnparse.puma" */
   fprintf (f, " / ");
/* line 944 "FUnparse.puma" */
   Unparse (t->DATA_DECL.VALS);
/* line 945 "FUnparse.puma" */
   fprintf (f, " /");
/* line 946 "FUnparse.puma" */
   LCR (t->DATA_DECL.Line);
  }
   return;

  case kMAP_TO_DECL:
/* line 949 "FUnparse.puma" */
  {
/* line 951 "FUnparse.puma" */
   ind ();
/* line 952 "FUnparse.puma" */
   GetString (t->MAP_TO_DECL.Ident, string);
/* line 953 "FUnparse.puma" */
   fprintf (f, "map_to %s (", string);
/* line 954 "FUnparse.puma" */
   fprintf (f, "\'");
/* line 955 "FUnparse.puma" */
   StGetString (t->MAP_TO_DECL.kind, string);
/* line 956 "FUnparse.puma" */
   MyPrintString (f, string);
/* line 957 "FUnparse.puma" */
   LCR (t->MAP_TO_DECL.Line);
  }
   return;

  case kLAYOUT_DECL:
/* line 960 "FUnparse.puma" */
  {
/* line 962 "FUnparse.puma" */
   ind ();
/* line 963 "FUnparse.puma" */
   GetString (t->LAYOUT_DECL.Ident, string);
/* line 964 "FUnparse.puma" */
   fprintf (f, "layout %s (", string);
/* line 965 "FUnparse.puma" */
   fprintf (f, "\'");
/* line 966 "FUnparse.puma" */
   StGetString (t->LAYOUT_DECL.kind, string);
/* line 967 "FUnparse.puma" */
   MyPrintString (f, string);
/* line 968 "FUnparse.puma" */
   LCR (t->LAYOUT_DECL.Line);
  }
   return;

  case kPASS_BY_DECL:
/* line 971 "FUnparse.puma" */
  {
/* line 973 "FUnparse.puma" */
   ind ();
/* line 974 "FUnparse.puma" */
   GetString (t->PASS_BY_DECL.Ident, string);
/* line 975 "FUnparse.puma" */
   fprintf (f, "pass_by %s (", string);
/* line 976 "FUnparse.puma" */
   fprintf (f, "\'");
/* line 977 "FUnparse.puma" */
   StGetString (t->PASS_BY_DECL.kind, string);
/* line 978 "FUnparse.puma" */
   MyPrintString (f, string);
/* line 979 "FUnparse.puma" */
   fprintf (f, "\')");
/* line 980 "FUnparse.puma" */
   LCR (t->PASS_BY_DECL.Line);
  }
   return;

  case kBODY_NODE:
  if (t->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
/* line 989 "FUnparse.puma" */
  {
/* line 991 "FUnparse.puma" */
   Unparse (t->BODY_NODE.DECLS);
/* line 992 "FUnparse.puma" */
   fprintf (f, "!    these are the new variables\n");
/* line 993 "FUnparse.puma" */
   Unparse (t->BODY_NODE.NEW_DECLS);
/* line 994 "FUnparse.puma" */
   Unparse (t->BODY_NODE.STATS);
/* line 995 "FUnparse.puma" */
   ind ();
/* line 996 "FUnparse.puma" */
   fprintf (f, "end");
  }
   return;

  }
/* line 999 "FUnparse.puma" */
  {
/* line 1001 "FUnparse.puma" */
   Unparse (t->BODY_NODE.DECLS);
/* line 1002 "FUnparse.puma" */
   Unparse (t->BODY_NODE.NEW_DECLS);
/* line 1003 "FUnparse.puma" */
   Unparse (t->BODY_NODE.STATS);
/* line 1004 "FUnparse.puma" */
   ind ();
/* line 1005 "FUnparse.puma" */
   fprintf (f, "contains\n");
/* line 1006 "FUnparse.puma" */
   Unparse (t->BODY_NODE.INTERNALS);
/* line 1007 "FUnparse.puma" */
   ind ();
/* line 1008 "FUnparse.puma" */
   fprintf (f, "end");
  }
   return;

  case kACF_LIST:
/* line 1011 "FUnparse.puma" */
  {
/* line 1013 "FUnparse.puma" */
   Unparse (t->ACF_LIST.Elem);
/* line 1014 "FUnparse.puma" */
 if (t->ACF_LIST.Next != NoTree) Unparse (t->ACF_LIST.Next); 
  }
   return;

  case kACF_EMPTY:
/* line 1017 "FUnparse.puma" */
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kATOMIC_STMT) {
/* line 1020 "FUnparse.puma" */
  {
/* line 1022 "FUnparse.puma" */
   fprintf (f, "!adp$ atomic\n");
/* line 1023 "FUnparse.puma" */
   label_ind (t->ACF_BASIC.Label);
/* line 1024 "FUnparse.puma" */
   Unparse (t->ACF_BASIC.BASIC_STMT);
/* line 1025 "FUnparse.puma" */
   LCR (t->ACF_BASIC.Line);
  }
   return;

  }
/* line 1028 "FUnparse.puma" */
  {
/* line 1030 "FUnparse.puma" */
   label_ind (t->ACF_BASIC.Label);
/* line 1031 "FUnparse.puma" */
   Unparse (t->ACF_BASIC.BASIC_STMT);
/* line 1032 "FUnparse.puma" */
   LCR (t->ACF_BASIC.Line);
  }
   return;

  case kACF_DUMMY:
/* line 1035 "FUnparse.puma" */
  {
/* line 1037 "FUnparse.puma" */
   label_ind (t->ACF_DUMMY.Label);
/* line 1038 "FUnparse.puma" */
   fprintf (f, "continue");
/* line 1039 "FUnparse.puma" */
   LCR (t->ACF_DUMMY.Line);
  }
   return;

  case kACF_WHILE:
/* line 1042 "FUnparse.puma" */
  {
/* line 1044 "FUnparse.puma" */
   label_ind (t->ACF_WHILE.Label);
/* line 1045 "FUnparse.puma" */
   fprintf (f, "do while (");
/* line 1046 "FUnparse.puma" */
   Unparse (t->ACF_WHILE.WHILE_EXP);
/* line 1047 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1048 "FUnparse.puma" */
   LCR (t->ACF_WHILE.Line);
/* line 1049 "FUnparse.puma" */
   IncIndent ();
/* line 1050 "FUnparse.puma" */
   Unparse (t->ACF_WHILE.WHILE_BODY);
/* line 1051 "FUnparse.puma" */
   DecIndent ();
/* line 1052 "FUnparse.puma" */
   ind ();
/* line 1053 "FUnparse.puma" */
   fprintf (f, "end do\n");
  }
   return;

  case kACF_DO:
  if (t->ACF_DO.DO_ID->Kind == kDUMMY_VAR) {
/* line 1056 "FUnparse.puma" */
  {
/* line 1058 "FUnparse.puma" */
   label_ind (t->ACF_DO.Label);
/* line 1059 "FUnparse.puma" */
   fprintf (f, "do (");
/* line 1060 "FUnparse.puma" */
   Unparse (t->ACF_DO.DO_RANGE->SLICE_EXP.STOP);
/* line 1061 "FUnparse.puma" */
   fprintf (f, ") times");
/* line 1062 "FUnparse.puma" */
   LCR (t->ACF_DO.Line);
/* line 1063 "FUnparse.puma" */
   IncIndent ();
/* line 1064 "FUnparse.puma" */
   Unparse (t->ACF_DO.DO_BODY);
/* line 1065 "FUnparse.puma" */
   DecIndent ();
/* line 1066 "FUnparse.puma" */
   ind ();
/* line 1067 "FUnparse.puma" */
   fprintf (f, "end do\n");
  }
   return;

  }
  if (t->ACF_DO.DO_DEP_INFO->Kind == kPARDO_INFO) {
/* line 1070 "FUnparse.puma" */
  {
/* line 1072 "FUnparse.puma" */
   if (! ((sm_parallelization == SGI_MP))) goto yyL92;
  {
/* line 1074 "FUnparse.puma" */
   par_ind ();
/* line 1075 "FUnparse.puma" */
   fprintf (f, "pdo\n");
/* line 1076 "FUnparse.puma" */
   label_ind (t->ACF_DO.Label);
/* line 1077 "FUnparse.puma" */
   fprintf (f, "do ");
/* line 1078 "FUnparse.puma" */
   Unparse (t->ACF_DO.DO_ID);
/* line 1079 "FUnparse.puma" */
   fprintf (f, "=");
/* line 1080 "FUnparse.puma" */
   UnparseDoRange (t->ACF_DO.DO_RANGE);
/* line 1081 "FUnparse.puma" */
   LCR (t->ACF_DO.Line);
/* line 1082 "FUnparse.puma" */
   IncIndent ();
/* line 1083 "FUnparse.puma" */
   Unparse (t->ACF_DO.DO_BODY);
/* line 1084 "FUnparse.puma" */
   DecIndent ();
/* line 1085 "FUnparse.puma" */
   ind ();
/* line 1086 "FUnparse.puma" */
   fprintf (f, "end do\n");
/* line 1087 "FUnparse.puma" */
   par_ind ();
/* line 1088 "FUnparse.puma" */
   fprintf (f, "end pdo\n");
  }
  }
   return;
yyL92:;

  }
/* line 1091 "FUnparse.puma" */
  {
/* line 1093 "FUnparse.puma" */
   VecInfoUnparse (t->ACF_DO.DO_DEP_INFO);
/* line 1094 "FUnparse.puma" */
   label_ind (t->ACF_DO.Label);
/* line 1095 "FUnparse.puma" */
   fprintf (f, "do ");
/* line 1096 "FUnparse.puma" */
   Unparse (t->ACF_DO.DO_ID);
/* line 1097 "FUnparse.puma" */
   fprintf (f, "=");
/* line 1098 "FUnparse.puma" */
   UnparseDoRange (t->ACF_DO.DO_RANGE);
/* line 1099 "FUnparse.puma" */
   DepInfoUnparse (t->ACF_DO.DO_DEP_INFO);
/* line 1100 "FUnparse.puma" */
   HomeInfoUnparse (t->ACF_DO.DO_HOME_INFO);
/* line 1101 "FUnparse.puma" */
   LCR (t->ACF_DO.Line);
/* line 1102 "FUnparse.puma" */
   IncIndent ();
/* line 1103 "FUnparse.puma" */
   Unparse (t->ACF_DO.DO_BODY);
/* line 1104 "FUnparse.puma" */
   DecIndent ();
/* line 1105 "FUnparse.puma" */
   ind ();
/* line 1106 "FUnparse.puma" */
   fprintf (f, "end do\n");
  }
   return;

  case kACF_FORALL:
/* line 1109 "FUnparse.puma" */
  {
/* line 1111 "FUnparse.puma" */
   label_ind (t->ACF_FORALL.Label);
/* line 1112 "FUnparse.puma" */
   fprintf (f, "forall (");
/* line 1113 "FUnparse.puma" */
   Unparse (t->ACF_FORALL.FORALL_ID);
/* line 1114 "FUnparse.puma" */
   fprintf (f, "=");
/* line 1115 "FUnparse.puma" */
   Unparse (t->ACF_FORALL.FORALL_RANGE);
/* line 1116 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1117 "FUnparse.puma" */
   DepInfoUnparse (t->ACF_FORALL.FORALL_DEP_INFO);
/* line 1118 "FUnparse.puma" */
   HomeInfoUnparse (t->ACF_FORALL.FORALL_HOME_INFO);
/* line 1119 "FUnparse.puma" */
   LCR (t->ACF_FORALL.Line);
/* line 1120 "FUnparse.puma" */
   IncIndent ();
/* line 1121 "FUnparse.puma" */
   Unparse (t->ACF_FORALL.FORALL_BODY);
/* line 1122 "FUnparse.puma" */
   DecIndent ();
/* line 1123 "FUnparse.puma" */
   ind ();
/* line 1124 "FUnparse.puma" */
   fprintf (f, "end forall\n");
  }
   return;

  case kACF_LOOP:
/* line 1127 "FUnparse.puma" */
  {
/* line 1129 "FUnparse.puma" */
   label_ind (t->ACF_LOOP.Label);
/* line 1130 "FUnparse.puma" */
   fprintf (f, "do while (.TRUE.)");
/* line 1131 "FUnparse.puma" */
   LCR (t->ACF_LOOP.Line);
/* line 1132 "FUnparse.puma" */
   IncIndent ();
/* line 1133 "FUnparse.puma" */
   Unparse (t->ACF_LOOP.LOOP_BODY);
/* line 1134 "FUnparse.puma" */
   DecIndent ();
/* line 1135 "FUnparse.puma" */
   ind ();
/* line 1136 "FUnparse.puma" */
   fprintf (f, "end do\n");
  }
   return;

  case kACF_IF:
/* line 1139 "FUnparse.puma" */
  {
/* line 1141 "FUnparse.puma" */
   label_ind (t->ACF_IF.Label);
/* line 1142 "FUnparse.puma" */
   fprintf (f, "if (");
/* line 1143 "FUnparse.puma" */
   Unparse (t->ACF_IF.IF_EXP);
/* line 1144 "FUnparse.puma" */
   fprintf (f, ") then");
/* line 1145 "FUnparse.puma" */
   LCR (t->ACF_IF.Line);
/* line 1146 "FUnparse.puma" */
   IncIndent ();
/* line 1147 "FUnparse.puma" */
   Unparse (t->ACF_IF.THEN_PART);
/* line 1148 "FUnparse.puma" */
   DecIndent ();
/* line 1149 "FUnparse.puma" */
   UnparseElse (t->ACF_IF.ELSE_PART);
/* line 1150 "FUnparse.puma" */
   ind ();
/* line 1151 "FUnparse.puma" */
   fprintf (f, "end if\n");
  }
   return;

  case kACF_WHERE:
  if (t->ACF_WHERE.FALSE_PART->Kind == kACF_EMPTY) {
/* line 1154 "FUnparse.puma" */
  {
/* line 1156 "FUnparse.puma" */
   label_ind (t->ACF_WHERE.Label);
/* line 1157 "FUnparse.puma" */
   fprintf (f, "where (");
/* line 1158 "FUnparse.puma" */
   Unparse (t->ACF_WHERE.WHERE_EXP);
/* line 1159 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1160 "FUnparse.puma" */
   LCR (t->ACF_WHERE.Line);
/* line 1161 "FUnparse.puma" */
   IncIndent ();
/* line 1162 "FUnparse.puma" */
   Unparse (t->ACF_WHERE.TRUE_PART);
/* line 1163 "FUnparse.puma" */
   DecIndent ();
/* line 1164 "FUnparse.puma" */
   ind ();
/* line 1165 "FUnparse.puma" */
   fprintf (f, "end where\n");
  }
   return;

  }
/* line 1168 "FUnparse.puma" */
  {
/* line 1170 "FUnparse.puma" */
   label_ind (t->ACF_WHERE.Label);
/* line 1171 "FUnparse.puma" */
   fprintf (f, "where (");
/* line 1172 "FUnparse.puma" */
   Unparse (t->ACF_WHERE.WHERE_EXP);
/* line 1173 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1174 "FUnparse.puma" */
   LCR (t->ACF_WHERE.Line);
/* line 1175 "FUnparse.puma" */
   IncIndent ();
/* line 1176 "FUnparse.puma" */
   Unparse (t->ACF_WHERE.TRUE_PART);
/* line 1177 "FUnparse.puma" */
   DecIndent ();
/* line 1178 "FUnparse.puma" */
   ind ();
/* line 1179 "FUnparse.puma" */
   fprintf (f, " elsewhere\n");
/* line 1180 "FUnparse.puma" */
   IncIndent ();
/* line 1181 "FUnparse.puma" */
   Unparse (t->ACF_WHERE.FALSE_PART);
/* line 1182 "FUnparse.puma" */
   DecIndent ();
/* line 1183 "FUnparse.puma" */
   ind ();
/* line 1184 "FUnparse.puma" */
   fprintf (f, "end where\n");
  }
   return;

  case kACF_CASE:
/* line 1187 "FUnparse.puma" */
  {
/* line 1189 "FUnparse.puma" */
   label_ind (t->ACF_CASE.Label);
/* line 1190 "FUnparse.puma" */
   fprintf (f, "select case (");
/* line 1191 "FUnparse.puma" */
   Unparse (t->ACF_CASE.CASE_EXP);
/* line 1192 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1193 "FUnparse.puma" */
   LCR (t->ACF_CASE.Line);
/* line 1194 "FUnparse.puma" */
   IncIndent ();
/* line 1195 "FUnparse.puma" */
   Unparse (t->ACF_CASE.CASE_ALTS);
/* line 1196 "FUnparse.puma" */
   DecIndent ();
/* line 1197 "FUnparse.puma" */
   ind ();
/* line 1198 "FUnparse.puma" */
   fprintf (f, "end select\n");
  }
   return;

  case kACF_HOME:
/* line 1201 "FUnparse.puma" */
  {
/* line 1204 "FUnparse.puma" */
   fprintf (f, "!hpf$ ");
/* line 1205 "FUnparse.puma" */
   Unparse (t->ACF_HOME.HOME_VAR);
/* line 1206 "FUnparse.puma" */
 if (t->ACF_HOME.user_home) fprintf (f, " by user"); 
         else  fprintf (f, " by system");
   
/* line 1209 "FUnparse.puma" */
   HPFBodyUnparse (t->ACF_HOME.Line, t->ACF_HOME.HOME_BODY, 0);
  }
   return;

  case kON_PROC_CLAUSE:
/* line 1212 "FUnparse.puma" */
  {
/* line 1214 "FUnparse.puma" */
   fprintf (f, "on (");
/* line 1215 "FUnparse.puma" */
   Unparse (t->ON_PROC_CLAUSE.ON_PROC);
/* line 1216 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kPROCESSOR_ARRAY:
/* line 1221 "FUnparse.puma" */
  {
/* line 1223 "FUnparse.puma" */
   GetString (t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident, string);
/* line 1224 "FUnparse.puma" */
   fprintf (f, " %s", string);
  }
   return;

  case kPROCESSOR_SUBSET:
/* line 1227 "FUnparse.puma" */
  {
/* line 1229 "FUnparse.puma" */
   GetString (t->PROCESSOR_SUBSET.FULLTOP->TOP_OBJ.Ident, string);
/* line 1230 "FUnparse.puma" */
   fprintf (f, "%s(", string);
/* line 1231 "FUnparse.puma" */
   Unparse (t->PROCESSOR_SUBSET.SUBSCRIPTS);
/* line 1232 "FUnparse.puma" */
   fprintf (f, ") = ");
/* line 1233 "FUnparse.puma" */
   GetString (t->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Ident, string);
/* line 1234 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

  case kON_VAR_CLAUSE:
/* line 1237 "FUnparse.puma" */
  {
/* line 1239 "FUnparse.puma" */
   fprintf (f, "on home (");
/* line 1240 "FUnparse.puma" */
   Unparse (t->ON_VAR_CLAUSE.ON_VAR);
/* line 1241 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kON_ALL_CLAUSE:
/* line 1244 "FUnparse.puma" */
  {
/* line 1246 "FUnparse.puma" */
   fprintf (f, "on all");
  }
   return;

  case kON_HOST_CLAUSE:
/* line 1249 "FUnparse.puma" */
  {
/* line 1251 "FUnparse.puma" */
   fprintf (f, "on host");
  }
   return;

  case kACF_PARALLEL:
/* line 1254 "FUnparse.puma" */
 {
  rbool yyV1;
  tTree yyV2;
  {
/* line 1256 "FUnparse.puma" */
   if (! (((sm_parallelization == SUN_MP) || (sm_parallelization == CRAY_MP)))) goto yyL107;
  {
/* line 1258 "FUnparse.puma" */
   SMGetParLoop (t->ACF_PARALLEL.PARALLEL_BODY, & yyV1, & yyV2);
/* line 1260 "FUnparse.puma" */
   if (! ((yyV1))) goto yyL107;
  {
/* line 1262 "FUnparse.puma" */
   par_ind ();
/* line 1263 "FUnparse.puma" */
   fprintf (f, "doall ");
/* line 1264 "FUnparse.puma" */
   SMParUnparse (t->ACF_PARALLEL.REDUCTION_VARS, t->ACF_PARALLEL.SHARED_VARS, t->ACF_PARALLEL.LOCAL_VARS);
/* line 1265 "FUnparse.puma" */
   fprintf (f, "\n");
/* line 1266 "FUnparse.puma" */
   t = yyV2;
   goto yyRecursion;
  }
  }
  }
 }
yyL107:;

/* line 1269 "FUnparse.puma" */
  {
/* line 1271 "FUnparse.puma" */
   par_ind ();
/* line 1272 "FUnparse.puma" */
   fprintf (f, "parallel ");
/* line 1273 "FUnparse.puma" */
   SMParUnparse (t->ACF_PARALLEL.REDUCTION_VARS, t->ACF_PARALLEL.SHARED_VARS, t->ACF_PARALLEL.LOCAL_VARS);
/* line 1274 "FUnparse.puma" */
   fprintf (f, "\n");
/* line 1275 "FUnparse.puma" */
   Unparse (t->ACF_PARALLEL.PARALLEL_BODY);
/* line 1276 "FUnparse.puma" */
   par_ind ();
/* line 1277 "FUnparse.puma" */
   fprintf (f, "end parallel\n");
  }
   return;

  case kACF_CRITICAL:
/* line 1280 "FUnparse.puma" */
  {
/* line 1282 "FUnparse.puma" */
   par_ind ();
/* line 1283 "FUnparse.puma" */
   fprintf (f, "critical section\n");
/* line 1284 "FUnparse.puma" */
   Unparse (t->ACF_CRITICAL.CRITICAL_BODY);
/* line 1285 "FUnparse.puma" */
   par_ind ();
/* line 1286 "FUnparse.puma" */
   fprintf (f, "end critical section\n");
  }
   return;

  case kACF_TASK_REGION:
/* line 1289 "FUnparse.puma" */
  {
/* line 1291 "FUnparse.puma" */
 if (t->ACF_TASK_REGION.task_flag)
         fprintf (f, "!hpf$ independent task_region\n");
       else
         fprintf (f, "!hpf$ task_region\n");
   
/* line 1296 "FUnparse.puma" */
   Unparse (t->ACF_TASK_REGION.TASK_BODY);
/* line 1297 "FUnparse.puma" */
   fprintf (f, "!hpf$ end task_region\n");
  }
   return;

  case kACF_NEW:
/* line 1300 "FUnparse.puma" */
  {
/* line 1302 "FUnparse.puma" */
   fprintf (f, "!hpf$ new (");
/* line 1303 "FUnparse.puma" */
   Unparse (t->ACF_NEW.NEW_VAR);
/* line 1304 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1305 "FUnparse.puma" */
   HPFBodyUnparse (t->ACF_NEW.Line, t->ACF_NEW.NEW_BODY, 2);
  }
   return;

  case kACF_REDUCTION:
/* line 1308 "FUnparse.puma" */
  {
/* line 1310 "FUnparse.puma" */
   fprintf (f, "!hpf$ reduction (");
/* line 1311 "FUnparse.puma" */
   Unparse (t->ACF_REDUCTION.REDUCTION_VAR);
/* line 1312 "FUnparse.puma" */
   fprintf (f, ") op = ");
/* line 1313 "FUnparse.puma" */
   Unparse (t->ACF_REDUCTION.REDUCTION_FUNC);
/* line 1315 "FUnparse.puma" */
 if (t->ACF_REDUCTION.red_kind == kDEFAULT_REDUCTION) 
        fprintf (f, " (default) ");
      else  if (t->ACF_REDUCTION.red_kind == kPRIVATE_REDUCTION)
        fprintf (f, " (private)");
      else  if (t->ACF_REDUCTION.red_kind == kATOMIC_REDUCTION)
        fprintf (f, " (atomic)");
      else 
        fprintf (f, " (unknown)");
   
/* line 1325 "FUnparse.puma" */
   HPFBodyUnparse (t->ACF_REDUCTION.Line, t->ACF_REDUCTION.REDUCTION_BODY, 3);
  }
   return;

  case kACF_RESIDENT:
  if (t->ACF_RESIDENT.RESIDENT_VAR->Kind == kBTV_LIST) {
  if (t->ACF_RESIDENT.RESIDENT_VAR->BTV_LIST.Elem->Kind == kDUMMY_VAR) {
  if (t->ACF_RESIDENT.RESIDENT_VAR->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 1328 "FUnparse.puma" */
  {
/* line 1330 "FUnparse.puma" */
   fprintf (f, "!hpf$ resident");
/* line 1331 "FUnparse.puma" */
   HPFBodyUnparse (t->ACF_RESIDENT.Line, t->ACF_RESIDENT.RESIDENT_BODY, 1);
  }
   return;

  }
  }
  }
/* line 1334 "FUnparse.puma" */
  {
/* line 1336 "FUnparse.puma" */
   fprintf (f, "!hpf$ resident(");
/* line 1337 "FUnparse.puma" */
   Unparse (t->ACF_RESIDENT.RESIDENT_VAR);
/* line 1338 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1339 "FUnparse.puma" */
   HPFBodyUnparse (t->ACF_RESIDENT.Line, t->ACF_RESIDENT.RESIDENT_BODY, 1);
  }
   return;

  case kACF_ON:
/* line 1342 "FUnparse.puma" */
  {
/* line 1344 "FUnparse.puma" */
   label_ind (t->ACF_ON.Label);
/* line 1345 "FUnparse.puma" */
   fprintf (f, "on ");
/* line 1346 "FUnparse.puma" */
   OnSpecUnparse (t->ACF_ON.ON_HOME, t->ACF_ON.ON_SPECS);
/* line 1347 "FUnparse.puma" */
   fprintf (f, "\n");
/* line 1348 "FUnparse.puma" */
   IncIndent ();
/* line 1349 "FUnparse.puma" */
   Unparse (t->ACF_ON.ON_BODY);
/* line 1350 "FUnparse.puma" */
   DecIndent ();
/* line 1351 "FUnparse.puma" */
   ind ();
/* line 1352 "FUnparse.puma" */
   fprintf (f, "end on\n");
  }
   return;

  case kACF_BARRIER:
/* line 1355 "FUnparse.puma" */
  {
/* line 1357 "FUnparse.puma" */
   label_ind (t->ACF_BARRIER.Label);
/* line 1358 "FUnparse.puma" */
   fprintf (f, "barrier (");
/* line 1359 "FUnparse.puma" */
   Unparse (t->ACF_BARRIER.BARRIER_VARS);
/* line 1360 "FUnparse.puma" */
   fprintf (f, ")\n");
  }
   return;

  case kACF_RM_READ:
/* line 1363 "FUnparse.puma" */
  {
/* line 1365 "FUnparse.puma" */
   label_ind (t->ACF_RM_READ.Label);
/* line 1366 "FUnparse.puma" */
   fprintf (f, "RMA read ");
/* line 1367 "FUnparse.puma" */
   Unparse (t->ACF_RM_READ.REMOTE_VAR);
/* line 1368 "FUnparse.puma" */
   fprintf (f, " into ");
/* line 1369 "FUnparse.puma" */
   Unparse (t->ACF_RM_READ.LOCAL_VAR);
/* line 1370 "FUnparse.puma" */
   LCR (t->ACF_RM_READ.Line);
  }
   return;

  case kACF_RM_WRITE:
/* line 1373 "FUnparse.puma" */
  {
/* line 1375 "FUnparse.puma" */
   if (! ((t->ACF_RM_WRITE.op == 0))) goto yyL118;
  {
/* line 1377 "FUnparse.puma" */
   label_ind (t->ACF_RM_WRITE.Label);
/* line 1378 "FUnparse.puma" */
   fprintf (f, "RMA write ");
/* line 1379 "FUnparse.puma" */
   Unparse (t->ACF_RM_WRITE.LOCAL_DATA);
/* line 1380 "FUnparse.puma" */
   fprintf (f, " into ");
/* line 1381 "FUnparse.puma" */
   Unparse (t->ACF_RM_WRITE.REMOTE_VAR);
/* line 1382 "FUnparse.puma" */
   LCR (t->ACF_RM_WRITE.Line);
  }
  }
   return;
yyL118:;

/* line 1385 "FUnparse.puma" */
  {
/* line 1387 "FUnparse.puma" */
   label_ind (t->ACF_RM_WRITE.Label);
/* line 1388 "FUnparse.puma" */
   fprintf (f, "RMA update (op = %d) ", t->ACF_RM_WRITE.op);
/* line 1389 "FUnparse.puma" */
   Unparse (t->ACF_RM_WRITE.LOCAL_DATA);
/* line 1390 "FUnparse.puma" */
   fprintf (f, " into ");
/* line 1391 "FUnparse.puma" */
   Unparse (t->ACF_RM_WRITE.REMOTE_VAR);
/* line 1392 "FUnparse.puma" */
   LCR (t->ACF_RM_WRITE.Line);
  }
   return;

  case kACF_MOVE:
/* line 1395 "FUnparse.puma" */
  {
/* line 1397 "FUnparse.puma" */
   fprintf (f, "C      movement\n");
/* line 1398 "FUnparse.puma" */
   label_ind (t->ACF_MOVE.Label);
/* line 1399 "FUnparse.puma" */
   Unparse (t->ACF_MOVE.MOVE_STMT);
/* line 1400 "FUnparse.puma" */
   LCR (t->ACF_MOVE.Line);
  }
   return;

  case kSELECTED_ACF_LIST:
/* line 1403 "FUnparse.puma" */
  {
/* line 1404 "FUnparse.puma" */
   Unparse (t->SELECTED_ACF_LIST.Elem);
/* line 1405 "FUnparse.puma" */
   t = t->SELECTED_ACF_LIST.Next;
   goto yyRecursion;
  }

  case kSELECTED_ACF_EMPTY:
/* line 1408 "FUnparse.puma" */
   return;

  case kSELECTED_ACF_NODE:
  if (t->SELECTED_ACF_NODE.SELECT_LIST->Kind == kBTE_EMPTY) {
/* line 1411 "FUnparse.puma" */
  {
/* line 1413 "FUnparse.puma" */
   ind ();
/* line 1414 "FUnparse.puma" */
   fprintf (f, "case default \n");
/* line 1415 "FUnparse.puma" */
   IncIndent ();
/* line 1416 "FUnparse.puma" */
   Unparse (t->SELECTED_ACF_NODE.SELECT_ACFS);
/* line 1417 "FUnparse.puma" */
   DecIndent ();
  }
   return;

  }
/* line 1420 "FUnparse.puma" */
  {
/* line 1422 "FUnparse.puma" */
   ind ();
/* line 1423 "FUnparse.puma" */
   fprintf (f, "case (");
/* line 1424 "FUnparse.puma" */
   CaseSelectorUnparse (t->SELECTED_ACF_NODE.SELECT_LIST);
/* line 1425 "FUnparse.puma" */
   fprintf (f, ")\n");
/* line 1426 "FUnparse.puma" */
   IncIndent ();
/* line 1427 "FUnparse.puma" */
   Unparse (t->SELECTED_ACF_NODE.SELECT_ACFS);
/* line 1428 "FUnparse.puma" */
   DecIndent ();
  }
   return;

  case kACF_ENTRY:
  if (t->ACF_ENTRY.ENTRY_DECL->Kind == kFUNC_DECL) {
/* line 1431 "FUnparse.puma" */
  {
/* line 1433 "FUnparse.puma" */
   label_ind (t->ACF_ENTRY.Label);
/* line 1434 "FUnparse.puma" */
   GetString (t->ACF_ENTRY.ENTRY_DECL->FUNC_DECL.Ident, string);
/* line 1435 "FUnparse.puma" */
   fprintf (f, "entry %s (", string);
/* line 1436 "FUnparse.puma" */
   Unparse (t->ACF_ENTRY.ENTRY_DECL->FUNC_DECL.FORMALS);
/* line 1437 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1438 "FUnparse.puma" */
   LCR (t->ACF_ENTRY.Line);
  }
   return;

  }
  if (t->ACF_ENTRY.ENTRY_DECL->Kind == kPROC_DECL) {
/* line 1441 "FUnparse.puma" */
  {
/* line 1443 "FUnparse.puma" */
   label_ind (t->ACF_ENTRY.Label);
/* line 1444 "FUnparse.puma" */
   GetString (t->ACF_ENTRY.ENTRY_DECL->PROC_DECL.Ident, string);
/* line 1445 "FUnparse.puma" */
   fprintf (f, "entry %s (", string);
/* line 1446 "FUnparse.puma" */
   Unparse (t->ACF_ENTRY.ENTRY_DECL->PROC_DECL.FORMALS);
/* line 1447 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1448 "FUnparse.puma" */
   LCR (t->ACF_ENTRY.Line);
  }
   return;

  }
  break;
  }


  switch (t->Kind) {
  case kACF_NODE:
  case kACF_BASIC:
  case kACF_WHERE:
  case kACF_REPEAT:
  case kACF_DO:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
  case kACF_RESIDENT:
  case kACF_UPDATE:
/* line 1451 "FUnparse.puma" */
  {
/* line 1453 "FUnparse.puma" */
   label_ind (t->ACF_NODE.Label);
/* line 1454 "FUnparse.puma" */
   fprintf (f, "Statement");
/* line 1455 "FUnparse.puma" */
   LCR (t->ACF_NODE.Line);
  }
   return;

  case kASSIGN_STMT:
/* line 1466 "FUnparse.puma" */
  {
/* line 1468 "FUnparse.puma" */
   Unparse (t->ASSIGN_STMT.ASSIGN_VAR);
/* line 1469 "FUnparse.puma" */
   fprintf (f, " = ");
/* line 1470 "FUnparse.puma" */
   t = t->ASSIGN_STMT.ASSIGN_EXP;
   goto yyRecursion;
  }

  case kATOMIC_STMT:
/* line 1473 "FUnparse.puma" */
  {
/* line 1475 "FUnparse.puma" */
   Unparse (t->ATOMIC_STMT.ASSIGN_VAR);
/* line 1476 "FUnparse.puma" */
   fprintf (f, " = ");
/* line 1477 "FUnparse.puma" */
   t = t->ATOMIC_STMT.ASSIGN_EXP;
   goto yyRecursion;
  }

  case kPTR_ASSIGN_STMT:
/* line 1480 "FUnparse.puma" */
  {
/* line 1482 "FUnparse.puma" */
   Unparse (t->PTR_ASSIGN_STMT.ASSIGN_VAR);
/* line 1483 "FUnparse.puma" */
   fprintf (f, " => ");
/* line 1484 "FUnparse.puma" */
   t = t->PTR_ASSIGN_STMT.ASSIGN_EXP;
   goto yyRecursion;
  }

  case kLABEL_ASSIGN_STMT:
/* line 1487 "FUnparse.puma" */
  {
/* line 1489 "FUnparse.puma" */
   fprintf (f, "assign %d to ", t->LABEL_ASSIGN_STMT.assign_label);
/* line 1490 "FUnparse.puma" */
   t = t->LABEL_ASSIGN_STMT.LABEL_VAR;
   goto yyRecursion;
  }

  case kFORMAT_STMT:
/* line 1493 "FUnparse.puma" */
  {
/* line 1495 "FUnparse.puma" */
   fprintf (f, "FORMAT ");
/* line 1496 "FUnparse.puma" */
   FormatUnparse (t->FORMAT_STMT.FORMAT_PARAMS);
  }
   return;

  case kSTOP_STMT:
  if (t->STOP_STMT.STOP_CONST->Kind == kDUMMY_EXP) {
/* line 1499 "FUnparse.puma" */
  {
/* line 1501 "FUnparse.puma" */
   fprintf (f, "stop");
  }
   return;

  }
/* line 1504 "FUnparse.puma" */
  {
/* line 1506 "FUnparse.puma" */
   fprintf (f, "stop ");
/* line 1507 "FUnparse.puma" */
   t = t->STOP_STMT.STOP_CONST;
   goto yyRecursion;
  }

  case kEXIT_STMT:
/* line 1510 "FUnparse.puma" */
  {
/* line 1512 "FUnparse.puma" */
 if (t->EXIT_STMT.loopid == DefaultId ())
         fprintf (f,"exit");
       else
         { GetString (t->EXIT_STMT.loopid, string);
           fprintf (f,"exit %s", string);
         }
   
  }
   return;

  case kCYCLE_STMT:
/* line 1521 "FUnparse.puma" */
  {
/* line 1523 "FUnparse.puma" */
 if (t->CYCLE_STMT.loopid == DefaultId ())
        fprintf (f,"cycle");
       else
        { GetString (t->CYCLE_STMT.loopid, string);
          fprintf (f,"cycle %s", string);
        }
   
  }
   return;

  case kRETURN_STMT:
  if (t->RETURN_STMT.RETURN_EXP->Kind == kDUMMY_EXP) {
/* line 1532 "FUnparse.puma" */
  {
/* line 1534 "FUnparse.puma" */
   fprintf (f, "return");
  }
   return;

  }
/* line 1537 "FUnparse.puma" */
  {
/* line 1539 "FUnparse.puma" */
   fprintf (f, "return ");
/* line 1540 "FUnparse.puma" */
   t = t->RETURN_STMT.RETURN_EXP;
   goto yyRecursion;
  }

  case kASS_GOTO_STMT:
  if (t->ASS_GOTO_STMT.LABELS->Kind == kLABEL_EMPTY) {
/* line 1543 "FUnparse.puma" */
  {
/* line 1545 "FUnparse.puma" */
   fprintf (f, "goto ");
/* line 1546 "FUnparse.puma" */
   t = t->ASS_GOTO_STMT.GOTO_VAR;
   goto yyRecursion;
  }

  }
/* line 1549 "FUnparse.puma" */
  {
/* line 1551 "FUnparse.puma" */
   fprintf (f, "goto ");
/* line 1552 "FUnparse.puma" */
   Unparse (t->ASS_GOTO_STMT.GOTO_VAR);
/* line 1553 "FUnparse.puma" */
   fprintf (f, " (");
/* line 1554 "FUnparse.puma" */
   Unparse (t->ASS_GOTO_STMT.LABELS);
/* line 1555 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kGOTO_STMT:
/* line 1558 "FUnparse.puma" */
  {
/* line 1560 "FUnparse.puma" */
   fprintf (f, "goto %d", t->GOTO_STMT.GOTO_LABEL);
  }
   return;

  case kCOMP_GOTO_STMT:
/* line 1563 "FUnparse.puma" */
  {
/* line 1565 "FUnparse.puma" */
   fprintf (f, "goto (");
/* line 1566 "FUnparse.puma" */
   Unparse (t->COMP_GOTO_STMT.GOTO_LABELS);
/* line 1567 "FUnparse.puma" */
   fprintf (f, ") ");
/* line 1568 "FUnparse.puma" */
   t = t->COMP_GOTO_STMT.GOTO_EXP;
   goto yyRecursion;
  }

  case kLABEL_LIST:
  if (t->LABEL_LIST.Next->Kind == kLABEL_EMPTY) {
/* line 1571 "FUnparse.puma" */
  {
/* line 1573 "FUnparse.puma" */
   fprintf (f, "%d", t->LABEL_LIST.Elem);
  }
   return;

  }
/* line 1576 "FUnparse.puma" */
  {
/* line 1578 "FUnparse.puma" */
   fprintf (f, "%d, ", t->LABEL_LIST.Elem);
/* line 1579 "FUnparse.puma" */
   t = t->LABEL_LIST.Next;
   goto yyRecursion;
  }

  case kCOMP_IF_STMT:
/* line 1582 "FUnparse.puma" */
  {
/* line 1584 "FUnparse.puma" */
   fprintf (f, "if (");
/* line 1585 "FUnparse.puma" */
   Unparse (t->COMP_IF_STMT.IF_EXP);
/* line 1586 "FUnparse.puma" */
   fprintf (f, ") ");
/* line 1587 "FUnparse.puma" */
   fprintf (f, "%d , %d , %d", t->COMP_IF_STMT.IF_LT_LABEL, t->COMP_IF_STMT.IF_EQ_LABEL, t->COMP_IF_STMT.IF_GT_LABEL);
  }
   return;

  case kREDUCE_STMT:
/* line 1590 "FUnparse.puma" */
  {
/* line 1592 "FUnparse.puma" */
   GetString (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident, string);
/* line 1593 "FUnparse.puma" */
   fprintf (f, "reduce (%s,", string);
/* line 1594 "FUnparse.puma" */
   ParamUnparse (t->REDUCE_STMT.RED_PARAMS);
/* line 1595 "FUnparse.puma" */
   fprintf (f, ")");
/* line 1596 "FUnparse.puma" */
 if (t->REDUCE_STMT.red_kind == kDEFAULT_REDUCTION)
        fprintf (f, " (default) ");
      else  if (t->REDUCE_STMT.red_kind == kPRIVATE_REDUCTION)
        fprintf (f, " (private)");
      else  if (t->REDUCE_STMT.red_kind == kATOMIC_REDUCTION)
        fprintf (f, " (atomic)");
      else
        fprintf (f, " (unknown)");
   
  }
   return;

  case kCALL_STMT:
/* line 1607 "FUnparse.puma" */
  {
/* line 1609 "FUnparse.puma" */
   GetString (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, string);
/* line 1610 "FUnparse.puma" */
   fprintf (f, "call %s (", string);
/* line 1611 "FUnparse.puma" */
   ParamUnparse (t->CALL_STMT.CALL_PARAMS);
/* line 1612 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kMOVE_STMT:
  if (t->MOVE_STMT.MASK->Kind == kNO_PARAM) {
/* line 1615 "FUnparse.puma" */
  {
/* line 1617 "FUnparse.puma" */
   Unparse (t->MOVE_STMT.TARGET);
/* line 1618 "FUnparse.puma" */
   fprintf (f, " = ");
/* line 1619 "FUnparse.puma" */
   Unparse (t->MOVE_STMT.SOURCE);
/* line 1620 "FUnparse.puma" */
   fprintf (f, " ! communication");
  }
   return;

  }
/* line 1623 "FUnparse.puma" */
  {
/* line 1625 "FUnparse.puma" */
   Unparse (t->MOVE_STMT.TARGET);
/* line 1626 "FUnparse.puma" */
   fprintf (f, " = ");
/* line 1627 "FUnparse.puma" */
   Unparse (t->MOVE_STMT.SOURCE);
/* line 1628 "FUnparse.puma" */
   fprintf (f, " for ");
/* line 1629 "FUnparse.puma" */
   Unparse (t->MOVE_STMT.MASK);
/* line 1630 "FUnparse.puma" */
   fprintf (f, " ! communication");
  }
   return;

  case kSCATTER_STMT:
/* line 1633 "FUnparse.puma" */
  {
/* line 1635 "FUnparse.puma" */
   GetString (t->SCATTER_STMT.func, string);
/* line 1636 "FUnparse.puma" */
   fprintf (f, "%s ", string);
/* line 1637 "FUnparse.puma" */
   Unparse (t->SCATTER_STMT.ARRAY);
/* line 1638 "FUnparse.puma" */
 if (t->SCATTER_STMT.func == IsIdent ("GET_SCATTER"))
        fprintf (f," from ");
      else
        fprintf (f," to ");
   
/* line 1643 "FUnparse.puma" */
   Unparse (t->SCATTER_STMT.BASE);
/* line 1644 "FUnparse.puma" */
   fprintf (f, "(");
/* line 1645 "FUnparse.puma" */
   ParamUnparse (t->SCATTER_STMT.INDEXES);
/* line 1646 "FUnparse.puma" */
   fprintf (f, ") with MASK = ");
/* line 1647 "FUnparse.puma" */
   t = t->SCATTER_STMT.MASK;
   goto yyRecursion;
  }

  case kREDUCTION_STMT:
/* line 1650 "FUnparse.puma" */
  {
/* line 1652 "FUnparse.puma" */
   fprintf (f, "reduction (");
/* line 1653 "FUnparse.puma" */
   Unparse (t->REDUCTION_STMT.REDFUNC);
/* line 1654 "FUnparse.puma" */
   fprintf (f, ",");
/* line 1655 "FUnparse.puma" */
   Unparse (t->REDUCTION_STMT.ELEMS);
/* line 1656 "FUnparse.puma" */
   fprintf (f, ") along ");
/* line 1657 "FUnparse.puma" */
   OnSpecUnparse (t->REDUCTION_STMT.RED_TOP, t->REDUCTION_STMT.RED_SPEC);
  }
   return;

  case kBROADCAST_STMT:
/* line 1660 "FUnparse.puma" */
  {
/* line 1662 "FUnparse.puma" */
   fprintf (f, "broadcast (");
/* line 1663 "FUnparse.puma" */
   Unparse (t->BROADCAST_STMT.ELEMS);
/* line 1664 "FUnparse.puma" */
   fprintf (f, ") from ");
/* line 1665 "FUnparse.puma" */
   OnSpecUnparse (t->BROADCAST_STMT.OWNER_TOP, t->BROADCAST_STMT.OWNER_SPEC);
  }
   return;

  case kALLOCATE_STMT:
/* line 1668 "FUnparse.puma" */
  {
/* line 1670 "FUnparse.puma" */
   fprintf (f, "allocate (");
/* line 1671 "FUnparse.puma" */
   Unparse (t->ALLOCATE_STMT.PARAMS);
/* line 1672 "FUnparse.puma" */
   StatusUnparse (t->ALLOCATE_STMT.STATUS);
/* line 1673 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kDEALLOCATE_STMT:
/* line 1676 "FUnparse.puma" */
  {
/* line 1678 "FUnparse.puma" */
   fprintf (f, "deallocate (");
/* line 1679 "FUnparse.puma" */
   Unparse (t->DEALLOCATE_STMT.PARAMS);
/* line 1680 "FUnparse.puma" */
   StatusUnparse (t->DEALLOCATE_STMT.STATUS);
/* line 1681 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kACCESS_STMT:
/* line 1684 "FUnparse.puma" */
  {
/* line 1686 "FUnparse.puma" */
   fprintf (f, "access to ");
/* line 1687 "FUnparse.puma" */
   t = t->ACCESS_STMT.VAR;
   goto yyRecursion;
  }

  case kCREATE_DSP_STMT:
/* line 1690 "FUnparse.puma" */
  {
/* line 1692 "FUnparse.puma" */
   fprintf (f, "create_descriptor [");
/* line 1693 "FUnparse.puma" */
   DspKindUnparse (t->CREATE_DSP_STMT.flag);
/* line 1694 "FUnparse.puma" */
   fprintf (f, "] ");
/* line 1695 "FUnparse.puma" */
   Unparse (t->CREATE_DSP_STMT.VAR);
/* line 1696 "FUnparse.puma" */
   fprintf (f, "(");
/* line 1697 "FUnparse.puma" */
   Unparse (t->CREATE_DSP_STMT.SHAPE);
/* line 1698 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kINHERIT_DSP_STMT:
/* line 1701 "FUnparse.puma" */
  {
/* line 1703 "FUnparse.puma" */
   fprintf (f, "inherit_descriptor [");
/* line 1704 "FUnparse.puma" */
   DspKindUnparse (t->INHERIT_DSP_STMT.flag);
/* line 1705 "FUnparse.puma" */
   fprintf (f, "] ", t->INHERIT_DSP_STMT.flag);
/* line 1706 "FUnparse.puma" */
   Unparse (t->INHERIT_DSP_STMT.VAR);
/* line 1707 "FUnparse.puma" */
   fprintf (f, "(");
/* line 1708 "FUnparse.puma" */
   Unparse (t->INHERIT_DSP_STMT.SHAPE);
/* line 1709 "FUnparse.puma" */
   fprintf (f, ") safe = %d", t->INHERIT_DSP_STMT.safety);
  }
   return;

  case kFREE_DSP_STMT:
/* line 1712 "FUnparse.puma" */
  {
/* line 1714 "FUnparse.puma" */
   fprintf (f, "free_descriptor [");
/* line 1715 "FUnparse.puma" */
   DspKindUnparse (t->FREE_DSP_STMT.flag);
/* line 1716 "FUnparse.puma" */
   fprintf (f, "] ", t->FREE_DSP_STMT.flag);
/* line 1717 "FUnparse.puma" */
   t = t->FREE_DSP_STMT.VAR;
   goto yyRecursion;
  }

  case kNULLIFY_STMT:
/* line 1720 "FUnparse.puma" */
  {
/* line 1722 "FUnparse.puma" */
   fprintf (f, "nullify (");
/* line 1723 "FUnparse.puma" */
   Unparse (t->NULLIFY_STMT.PARAMS);
/* line 1724 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kREALIGN_STMT:
/* line 1727 "FUnparse.puma" */
  {
/* line 1729 "FUnparse.puma" */
   fprintf (f, "realign (");
/* line 1730 "FUnparse.puma" */
   Unparse (t->REALIGN_STMT.ALIGN_SOURCE);
/* line 1731 "FUnparse.puma" */
   fprintf (f, ") WITH ");
/* line 1732 "FUnparse.puma" */
   AlignSpecUnparse (t->REALIGN_STMT.ALIGN_TARGET);
/* line 1733 "FUnparse.puma" */
   fprintf (f, " :: ");
/* line 1734 "FUnparse.puma" */
   t = t->REALIGN_STMT.ALIGNEE;
   goto yyRecursion;
  }

  case kREDISTRIBUTE_STMT:
/* line 1737 "FUnparse.puma" */
  {
/* line 1739 "FUnparse.puma" */
   fprintf (f, "redistribute ");
/* line 1740 "FUnparse.puma" */
   Unparse (t->REDISTRIBUTE_STMT.DISTRIBUTEE);
/* line 1741 "FUnparse.puma" */
   LayoutUnparse (t->REDISTRIBUTE_STMT.DISTRIBUTION);
/* line 1742 "FUnparse.puma" */
   ProcSpecUnparse (t->REDISTRIBUTE_STMT.TARGET);
  }
   return;

  case kREG_SHADOW_GET:
/* line 1745 "FUnparse.puma" */
  {
/* line 1747 "FUnparse.puma" */
   fprintf (f, "overlap_get ");
/* line 1748 "FUnparse.puma" */
   Unparse (t->REG_SHADOW_GET.SHADOW_VAR);
/* line 1749 "FUnparse.puma" */
   fprintf (f, " BY [");
/* line 1750 "FUnparse.puma" */
   Unparse (t->REG_SHADOW_GET.SHADOW_SIZE);
/* line 1751 "FUnparse.puma" */
   fprintf (f, "]");
  }
   return;

  case kREG_SHADOW_PUT:
/* line 1754 "FUnparse.puma" */
  {
/* line 1756 "FUnparse.puma" */
   fprintf (f, "overlap_put (op = %d) ", t->REG_SHADOW_PUT.op);
/* line 1757 "FUnparse.puma" */
   Unparse (t->REG_SHADOW_PUT.SHADOW_VAR);
/* line 1758 "FUnparse.puma" */
   fprintf (f, " BY [");
/* line 1759 "FUnparse.puma" */
   Unparse (t->REG_SHADOW_PUT.SHADOW_SIZE);
/* line 1760 "FUnparse.puma" */
   fprintf (f, "]");
  }
   return;

  case kREG_SHADOW_SET:
/* line 1763 "FUnparse.puma" */
  {
/* line 1765 "FUnparse.puma" */
   fprintf (f, "overlap_set ");
/* line 1766 "FUnparse.puma" */
   Unparse (t->REG_SHADOW_SET.SHADOW_VAR);
/* line 1767 "FUnparse.puma" */
   fprintf (f, " BY [");
/* line 1768 "FUnparse.puma" */
   Unparse (t->REG_SHADOW_SET.SHADOW_SIZE);
/* line 1769 "FUnparse.puma" */
   fprintf (f, "] with ");
/* line 1770 "FUnparse.puma" */
   t = t->REG_SHADOW_SET.VAL;
   goto yyRecursion;
  }

  case kIND_SHADOW_CREATE:
/* line 1773 "FUnparse.puma" */
  {
/* line 1775 "FUnparse.puma" */
   fprintf (f, "create_shadow (id=%d) for ", t->IND_SHADOW_CREATE.id);
/* line 1776 "FUnparse.puma" */
   Unparse (t->IND_SHADOW_CREATE.SHADOW_VAR);
/* line 1777 "FUnparse.puma" */
   fprintf (f, " by ");
/* line 1778 "FUnparse.puma" */
   Unparse (t->IND_SHADOW_CREATE.INDEX_VAR);
/* line 1779 "FUnparse.puma" */
   fprintf (f, " <- ");
/* line 1780 "FUnparse.puma" */
   Unparse (t->IND_SHADOW_CREATE.MASK);
/* line 1781 "FUnparse.puma" */
   fprintf (f, " mask = ");
/* line 1782 "FUnparse.puma" */
   t = t->IND_SHADOW_CREATE.TMP_INDEX_VAR;
   goto yyRecursion;
  }

  case kIND_SHADOW_FREE:
/* line 1785 "FUnparse.puma" */
  {
/* line 1787 "FUnparse.puma" */
   fprintf (f, "free_shadow (id=%d) by ", t->IND_SHADOW_FREE.id);
/* line 1788 "FUnparse.puma" */
   t = t->IND_SHADOW_FREE.INDEX_VAR;
   goto yyRecursion;
  }

  case kIND_SHADOW_GET:
/* line 1791 "FUnparse.puma" */
  {
/* line 1793 "FUnparse.puma" */
   fprintf (f, "get_shadow (id=%d) for ", t->IND_SHADOW_GET.id);
/* line 1794 "FUnparse.puma" */
   t = t->IND_SHADOW_GET.SHADOW_VAR;
   goto yyRecursion;
  }

  case kIND_SHADOW_PUT:
/* line 1797 "FUnparse.puma" */
  {
/* line 1799 "FUnparse.puma" */
   fprintf (f, "put_shadow (id=%d, op=%d) for ", t->IND_SHADOW_PUT.id, t->IND_SHADOW_PUT.op);
/* line 1800 "FUnparse.puma" */
   t = t->IND_SHADOW_PUT.SHADOW_VAR;
   goto yyRecursion;
  }

  case kIND_SHADOW_SET:
/* line 1803 "FUnparse.puma" */
  {
/* line 1805 "FUnparse.puma" */
   fprintf (f, "set_shadow (id=%d) for ", t->IND_SHADOW_SET.id);
/* line 1806 "FUnparse.puma" */
   Unparse (t->IND_SHADOW_SET.SHADOW_VAR);
/* line 1807 "FUnparse.puma" */
   fprintf (f, " with ");
/* line 1808 "FUnparse.puma" */
   t = t->IND_SHADOW_SET.VAL;
   goto yyRecursion;
  }

  case kDIRTY_STMT:
/* line 1811 "FUnparse.puma" */
  {
/* line 1813 "FUnparse.puma" */
   fprintf (f, "dirty [");
/* line 1814 "FUnparse.puma" */
   Unparse (t->DIRTY_STMT.ELEMS);
/* line 1815 "FUnparse.puma" */
   fprintf (f, "]");
  }
   return;

  case kIO_STMT:
  if (t->IO_STMT.IO_ITEMS->Kind == kBTP_EMPTY) {
/* line 1824 "FUnparse.puma" */
  {
/* line 1826 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("PRINT")))) goto yyL171;
  {
/* line 1828 "FUnparse.puma" */
   fprintf (f, "print ");
/* line 1829 "FUnparse.puma" */
   t = t->IO_STMT.IO_SPECS;
   goto yyRecursion;
  }
  }
yyL171:;

  }
/* line 1832 "FUnparse.puma" */
  {
/* line 1834 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("PRINT")))) goto yyL172;
  {
/* line 1836 "FUnparse.puma" */
   fprintf (f, "print ");
/* line 1837 "FUnparse.puma" */
   Unparse (t->IO_STMT.IO_SPECS);
/* line 1838 "FUnparse.puma" */
   fprintf (f, ",");
/* line 1839 "FUnparse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }
  }
yyL172:;

  if (t->IO_STMT.IO_SPECS->Kind == kBTP_LIST) {
  if (t->IO_STMT.IO_SPECS->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 1842 "FUnparse.puma" */
  {
/* line 1844 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("READ")))) goto yyL173;
  {
/* line 1846 "FUnparse.puma" */
   if (! ((IsDummyParam (t->IO_STMT.IO_SPECS->BTP_LIST.Elem)))) goto yyL173;
  {
/* line 1848 "FUnparse.puma" */
   fprintf (f, "read *, ");
/* line 1849 "FUnparse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }
  }
  }
yyL173:;

  }
  }
/* line 1852 "FUnparse.puma" */
  {
/* line 1854 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("READ")))) goto yyL174;
  {
/* line 1856 "FUnparse.puma" */
   fprintf (f, "read (");
/* line 1857 "FUnparse.puma" */
   Unparse (t->IO_STMT.IO_SPECS);
/* line 1858 "FUnparse.puma" */
   fprintf (f, ") ");
/* line 1859 "FUnparse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }
  }
yyL174:;

/* line 1862 "FUnparse.puma" */
  {
/* line 1864 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("WRITE")))) goto yyL175;
  {
/* line 1866 "FUnparse.puma" */
   fprintf (f, "write (");
/* line 1867 "FUnparse.puma" */
   Unparse (t->IO_STMT.IO_SPECS);
/* line 1868 "FUnparse.puma" */
   fprintf (f, ") ");
/* line 1869 "FUnparse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }
  }
yyL175:;

/* line 1872 "FUnparse.puma" */
  {
/* line 1874 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("OPEN")))) goto yyL176;
  {
/* line 1876 "FUnparse.puma" */
   fprintf (f, "open (");
/* line 1877 "FUnparse.puma" */
   Unparse (t->IO_STMT.IO_SPECS);
/* line 1878 "FUnparse.puma" */
   fprintf (f, ") ");
/* line 1879 "FUnparse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }
  }
yyL176:;

/* line 1882 "FUnparse.puma" */
  {
/* line 1884 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("CLOSE")))) goto yyL177;
  {
/* line 1886 "FUnparse.puma" */
   fprintf (f, "close (");
/* line 1887 "FUnparse.puma" */
   Unparse (t->IO_STMT.IO_SPECS);
/* line 1888 "FUnparse.puma" */
   fprintf (f, ") ");
/* line 1889 "FUnparse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }
  }
yyL177:;

/* line 1892 "FUnparse.puma" */
  {
/* line 1894 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("REWIND")))) goto yyL178;
  {
/* line 1896 "FUnparse.puma" */
   fprintf (f, "rewind (");
/* line 1897 "FUnparse.puma" */
   Unparse (t->IO_STMT.IO_SPECS);
/* line 1898 "FUnparse.puma" */
   fprintf (f, ") ");
/* line 1899 "FUnparse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }
  }
yyL178:;

/* line 1902 "FUnparse.puma" */
  {
/* line 1904 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("BACKSPACE")))) goto yyL179;
  {
/* line 1906 "FUnparse.puma" */
   fprintf (f, "backspace (");
/* line 1907 "FUnparse.puma" */
   Unparse (t->IO_STMT.IO_SPECS);
/* line 1908 "FUnparse.puma" */
   fprintf (f, ") ");
/* line 1909 "FUnparse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }
  }
yyL179:;

/* line 1912 "FUnparse.puma" */
  {
/* line 1914 "FUnparse.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("INQUIRE")))) goto yyL180;
  {
/* line 1916 "FUnparse.puma" */
   fprintf (f, "inquire (");
/* line 1917 "FUnparse.puma" */
   Unparse (t->IO_STMT.IO_SPECS);
/* line 1918 "FUnparse.puma" */
   fprintf (f, ") ");
/* line 1919 "FUnparse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }
  }
yyL180:;

/* line 1922 "FUnparse.puma" */
  {
/* line 1924 "FUnparse.puma" */
   GetString (t->IO_STMT.ID->PROC_OBJ.Ident, string);
/* line 1925 "FUnparse.puma" */
   fprintf (f, "%s is unknown io-statement", string);
  }
   return;

  case kBTP_LIST:
/* line 1934 "FUnparse.puma" */
  {
/* line 1936 "FUnparse.puma" */
   if (! ((MoreParameters (t->BTP_LIST.Next)))) goto yyL182;
  {
/* line 1938 "FUnparse.puma" */
   Unparse (t->BTP_LIST.Elem);
/* line 1939 "FUnparse.puma" */
   fprintf (f, ",");
/* line 1940 "FUnparse.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }
  }
yyL182:;

/* line 1943 "FUnparse.puma" */
  {
/* line 1944 "FUnparse.puma" */
   t = t->BTP_LIST.Elem;
   goto yyRecursion;
  }

  case kBTP_EMPTY:
/* line 1947 "FUnparse.puma" */
   return;

  case kNO_PARAM:
/* line 1950 "FUnparse.puma" */
  {
/* line 1952 "FUnparse.puma" */
   if (! ((t->NO_PARAM.type == kSTRING_TYPE))) goto yyL185;
  {
/* line 1953 "FUnparse.puma" */
   fprintf (f, "%%val(1)");
  }
  }
   return;
yyL185:;

/* line 1956 "FUnparse.puma" */
  {
/* line 1958 "FUnparse.puma" */
   fprintf (f, "%%val(0)");
  }
   return;

  case kNAMED_PARAM:
/* line 1961 "FUnparse.puma" */
  {
/* line 1962 "FUnparse.puma" */
   GetString (t->NAMED_PARAM.Name, string);
/* line 1963 "FUnparse.puma" */
   fprintf (f, "%s=", string);
/* line 1964 "FUnparse.puma" */
   t = t->NAMED_PARAM.VAL;
   goto yyRecursion;
  }

  case kVAR_PARAM:
/* line 1967 "FUnparse.puma" */
  {
/* line 1968 "FUnparse.puma" */
   t = t->VAR_PARAM.V;
   goto yyRecursion;
  }

  case kVALUE_PARAM:
/* line 1971 "FUnparse.puma" */
  {
/* line 1972 "FUnparse.puma" */
   t = t->VALUE_PARAM.E;
   goto yyRecursion;
  }

  case kRETURN_PARAM:
/* line 1975 "FUnparse.puma" */
  {
/* line 1976 "FUnparse.puma" */
   fprintf (f, "*%d", t->RETURN_PARAM.label);
  }
   return;

  case kPROC_PARAM:
/* line 1979 "FUnparse.puma" */
  {
/* line 1980 "FUnparse.puma" */
   t = t->PROC_PARAM.P;
   goto yyRecursion;
  }

  case kFUNC_PARAM:
/* line 1983 "FUnparse.puma" */
  {
/* line 1984 "FUnparse.puma" */
   t = t->FUNC_PARAM.F;
   goto yyRecursion;
  }

  case kPROC_OBJ:
/* line 1987 "FUnparse.puma" */
  {
/* line 1988 "FUnparse.puma" */
   GetString (t->PROC_OBJ.Ident, string);
/* line 1989 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

  case kBTE_LIST:
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 1998 "FUnparse.puma" */
  {
/* line 2000 "FUnparse.puma" */
   t = t->BTE_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 2003 "FUnparse.puma" */
  {
/* line 2005 "FUnparse.puma" */
   Unparse (t->BTE_LIST.Elem);
/* line 2006 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2007 "FUnparse.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  case kBTE_EMPTY:
/* line 2010 "FUnparse.puma" */
   return;

  case kDUMMY_EXP:
/* line 2013 "FUnparse.puma" */
  {
/* line 2013 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kCONST_EXP:
/* line 2014 "FUnparse.puma" */
  {
/* line 2014 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kVAR_EXP:
/* line 2015 "FUnparse.puma" */
  {
/* line 2015 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kOP_EXP:
/* line 2016 "FUnparse.puma" */
  {
/* line 2016 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kOP1_EXP:
/* line 2017 "FUnparse.puma" */
  {
/* line 2017 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kTYPE_EXP:
/* line 2018 "FUnparse.puma" */
  {
/* line 2018 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kARRAY_EXP:
/* line 2019 "FUnparse.puma" */
  {
/* line 2019 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kBOUND_EXP:
/* line 2020 "FUnparse.puma" */
  {
/* line 2020 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kRANK_EXP:
/* line 2021 "FUnparse.puma" */
  {
/* line 2021 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kSIZE_EXP:
/* line 2022 "FUnparse.puma" */
  {
/* line 2022 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kSLICE_EXP:
/* line 2023 "FUnparse.puma" */
  {
/* line 2023 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kFUNC_CALL_EXP:
/* line 2024 "FUnparse.puma" */
  {
/* line 2024 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kDO_EXP:
/* line 2025 "FUnparse.puma" */
  {
/* line 2025 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kNAMED_EXP:
/* line 2026 "FUnparse.puma" */
  {
/* line 2026 "FUnparse.puma" */
   ExpUnparse (t, 0, 0);
  }
   return;

  case kBOOL_CONSTANT:
  if (equalint (t->BOOL_CONSTANT.value, 1)) {
/* line 2034 "FUnparse.puma" */
  {
/* line 2036 "FUnparse.puma" */
   fprintf (f, ".TRUE.");
  }
   return;

  }
  if (equalint (t->BOOL_CONSTANT.value, 0)) {
/* line 2039 "FUnparse.puma" */
  {
/* line 2041 "FUnparse.puma" */
   fprintf (f, ".FALSE.");
  }
   return;

  }
  break;
  case kINT_CONSTANT:
/* line 2044 "FUnparse.puma" */
  {
/* line 2046 "FUnparse.puma" */
   fprintf (f, "%d", t->INT_CONSTANT.value);
  }
   return;

  case kREAL_CONSTANT:
/* line 2049 "FUnparse.puma" */
  {
/* line 2051 "FUnparse.puma" */
   StGetString (t->REAL_CONSTANT.value, string);
/* line 2052 "FUnparse.puma" */
   MyPrintString (f, string);
  }
   return;

  case kCOMPLEX_CONSTANT:
/* line 2055 "FUnparse.puma" */
  {
/* line 2057 "FUnparse.puma" */
   fprintf (f, "(");
/* line 2058 "FUnparse.puma" */
   StGetString (t->COMPLEX_CONSTANT.rvalue, string);
/* line 2059 "FUnparse.puma" */
   MyPrintString (f, string);
/* line 2060 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2061 "FUnparse.puma" */
   StGetString (t->COMPLEX_CONSTANT.ivalue, string);
/* line 2062 "FUnparse.puma" */
   MyPrintString (f, string);
/* line 2063 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kSTRING_CONSTANT:
/* line 2066 "FUnparse.puma" */
  {
/* line 2068 "FUnparse.puma" */
   StGetString (t->STRING_CONSTANT.value, string);
/* line 2069 "FUnparse.puma" */
   fprintf (f, "\'");
/* line 2070 "FUnparse.puma" */
   MyPrintString (f, string);
/* line 2071 "FUnparse.puma" */
   fprintf (f, "\'");
  }
   return;

  case kBTV_LIST:
/* line 2080 "FUnparse.puma" */
  {
/* line 2082 "FUnparse.puma" */
   if (! ((t->BTV_LIST.Next == NoTree))) goto yyL217;
  {
/* line 2084 "FUnparse.puma" */
   t = t->BTV_LIST.Elem;
   goto yyRecursion;
  }
  }
yyL217:;

  if (t->BTV_LIST.Next->Kind == kBTV_LIST) {
/* line 2087 "FUnparse.puma" */
  {
/* line 2089 "FUnparse.puma" */
   Unparse (t->BTV_LIST.Elem);
/* line 2090 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2091 "FUnparse.puma" */
   t = t->BTV_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 2094 "FUnparse.puma" */
  {
/* line 2096 "FUnparse.puma" */
   t = t->BTV_LIST.Elem;
   goto yyRecursion;
  }

  }
  break;
  case kBTV_EMPTY:
/* line 2099 "FUnparse.puma" */
   return;

  case kLOOP_VAR:
/* line 2102 "FUnparse.puma" */
  {
/* line 2104 "FUnparse.puma" */
   t = t->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;
  }

  case kUSED_VAR:
/* line 2107 "FUnparse.puma" */
  {
/* line 2109 "FUnparse.puma" */
   t = t->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  case kDUMMY_VAR:
/* line 2112 "FUnparse.puma" */
  {
/* line 2114 "FUnparse.puma" */
   fprintf (f, "*");
  }
   return;

  case kREMOTE_VAR:
/* line 2117 "FUnparse.puma" */
  {
/* line 2119 "FUnparse.puma" */
   fprintf (f, "#");
/* line 2120 "FUnparse.puma" */
   t = t->REMOTE_VAR.VAR;
   goto yyRecursion;
  }

  case kINDEXED_VAR:
/* line 2123 "FUnparse.puma" */
  {
/* line 2125 "FUnparse.puma" */
   Unparse (t->INDEXED_VAR.IND_VAR);
/* line 2126 "FUnparse.puma" */
   fprintf (f, "(");
/* line 2127 "FUnparse.puma" */
   Unparse (t->INDEXED_VAR.IND_EXPS);
/* line 2128 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kSUBSTRING_VAR:
/* line 2131 "FUnparse.puma" */
  {
/* line 2133 "FUnparse.puma" */
   Unparse (t->SUBSTRING_VAR.IND_VAR);
/* line 2134 "FUnparse.puma" */
   fprintf (f, "(");
/* line 2135 "FUnparse.puma" */
   Unparse (t->SUBSTRING_VAR.IND_EXP);
/* line 2136 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kADDR:
/* line 2139 "FUnparse.puma" */
  {
/* line 2141 "FUnparse.puma" */
   t = t->ADDR.E;
   goto yyRecursion;
  }

  case kSELECTED_VAR:
/* line 2144 "FUnparse.puma" */
  {
/* line 2146 "FUnparse.puma" */
   Unparse (t->SELECTED_VAR.SELEC_VAR);
/* line 2147 "FUnparse.puma" */
   fprintf (f, "%%");
/* line 2148 "FUnparse.puma" */
   t = t->SELECTED_VAR.SELECTOR;
   goto yyRecursion;
  }

  case kPERM_VAR:
/* line 2151 "FUnparse.puma" */
 {
  int i;
  {
/* line 2155 "FUnparse.puma" */
   fprintf (f, "permute(");
/* line 2156 "FUnparse.puma" */
   Unparse (t->PERM_VAR.VAL);
/* line 2157 "FUnparse.puma" */
   fprintf (f, ",<");
/* line 2158 "FUnparse.puma" */
 for (i=1; i<=t->PERM_VAR.perm.n; i++) 
       { fprintf (f,"%d", t->PERM_VAR.perm.pa[i-1]);
         if (i<t->PERM_VAR.perm.n) fprintf (f,",");
       }
   
/* line 2163 "FUnparse.puma" */
   fprintf (f, ",>)");
  }
   return;
 }

  case kDO_VAR:
/* line 2166 "FUnparse.puma" */
  {
/* line 2168 "FUnparse.puma" */
   fprintf (f, "(");
/* line 2169 "FUnparse.puma" */
   Unparse (t->DO_VAR.BODY);
/* line 2170 "FUnparse.puma" */
   fprintf (f, ", ");
/* line 2171 "FUnparse.puma" */
   Unparse (t->DO_VAR.DO_ID);
/* line 2172 "FUnparse.puma" */
   fprintf (f, "=");
/* line 2173 "FUnparse.puma" */
   UnparseDoRange (t->DO_VAR.RANGE);
/* line 2174 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kSHAPE_LIST:
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_LIST) {
/* line 2183 "FUnparse.puma" */
  {
/* line 2185 "FUnparse.puma" */
   Unparse (t->SHAPE_LIST.Elem);
/* line 2186 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2187 "FUnparse.puma" */
   t = t->SHAPE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
/* line 2190 "FUnparse.puma" */
  {
/* line 2192 "FUnparse.puma" */
   t = t->SHAPE_LIST.Elem;
   goto yyRecursion;
  }

  }
  break;
  case kTYPE_ID:
/* line 2195 "FUnparse.puma" */
  {
/* line 2197 "FUnparse.puma" */
   fprintf (f, "type (");
/* line 2198 "FUnparse.puma" */
   Unparse (t->TYPE_ID.ID);
/* line 2199 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kSTRING_TYPE:
  if (t->STRING_TYPE.LENGTH->Kind == kCONST_EXP) {
  if (t->STRING_TYPE.LENGTH->CONST_EXP.C->Kind == kINT_CONSTANT) {
  if (equalint (t->STRING_TYPE.LENGTH->CONST_EXP.C->INT_CONSTANT.value, - 1)) {
/* line 2202 "FUnparse.puma" */
  {
/* line 2204 "FUnparse.puma" */
   fprintf (f, "character*(*)");
  }
   return;

  }
  }
  }
  if (t->STRING_TYPE.LENGTH->Kind == kDUMMY_EXP) {
/* line 2207 "FUnparse.puma" */
  {
/* line 2209 "FUnparse.puma" */
   fprintf (f, "character*(*)");
  }
   return;

  }
/* line 2212 "FUnparse.puma" */
  {
/* line 2214 "FUnparse.puma" */
   fprintf (f, "character*");
/* line 2215 "FUnparse.puma" */
   t = t->STRING_TYPE.LENGTH;
   goto yyRecursion;
  }

  case kARRAY_TYPE:
/* line 2218 "FUnparse.puma" */
  {
/* line 2220 "FUnparse.puma" */
   Unparse (t->ARRAY_TYPE.ARRAY_COMP_TYPE);
/* line 2221 "FUnparse.puma" */
   fprintf (f, " (", string);
/* line 2222 "FUnparse.puma" */
   Unparse (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);
/* line 2223 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kRECORD_TYPE:
/* line 2226 "FUnparse.puma" */
  {
/* line 2228 "FUnparse.puma" */
   fprintf (f, "type\n");
/* line 2229 "FUnparse.puma" */
   IncIndent ();
/* line 2230 "FUnparse.puma" */
   Unparse (t->RECORD_TYPE.COMPONENTS);
/* line 2231 "FUnparse.puma" */
   DecIndent ();
/* line 2232 "FUnparse.puma" */
   ind ();
/* line 2233 "FUnparse.puma" */
   fprintf (f, "end");
  }
   return;

  case kEXPLICIT_SHAPE:
/* line 2236 "FUnparse.puma" */
  {
/* line 2238 "FUnparse.puma" */
   Unparse (t->EXPLICIT_SHAPE.LOWER);
/* line 2239 "FUnparse.puma" */
   fprintf (f, ":");
/* line 2240 "FUnparse.puma" */
   t = t->EXPLICIT_SHAPE.UPPER;
   goto yyRecursion;
  }

  case kDEFERRED_SHAPE:
/* line 2243 "FUnparse.puma" */
  {
/* line 2245 "FUnparse.puma" */
   fprintf (f, ":");
  }
   return;

  case kASSUMED_SHAPE:
/* line 2248 "FUnparse.puma" */
  {
/* line 2250 "FUnparse.puma" */
   Unparse (t->ASSUMED_SHAPE.LOWER);
/* line 2251 "FUnparse.puma" */
   fprintf (f, ":");
  }
   return;

  case kASSUMED_SIZE:
/* line 2254 "FUnparse.puma" */
  {
/* line 2256 "FUnparse.puma" */
   Unparse (t->ASSUMED_SIZE.LOWER);
/* line 2257 "FUnparse.puma" */
   fprintf (f, ":*");
  }
   return;

  case kINTEGER_TYPE:
/* line 2260 "FUnparse.puma" */
  {
/* line 2262 "FUnparse.puma" */
   fprintf (f, "integer");
/* line 2263 "FUnparse.puma" */
   SizeUnparse (t->INTEGER_TYPE.SIZE);
  }
   return;

  case kBOOLEAN_TYPE:
/* line 2266 "FUnparse.puma" */
  {
/* line 2268 "FUnparse.puma" */
   fprintf (f, "logical");
/* line 2269 "FUnparse.puma" */
   SizeUnparse (t->BOOLEAN_TYPE.SIZE);
  }
   return;

  case kCOMPLEX_TYPE:
/* line 2272 "FUnparse.puma" */
  {
/* line 2274 "FUnparse.puma" */
   fprintf (f, "complex");
/* line 2275 "FUnparse.puma" */
   SizeUnparse (t->COMPLEX_TYPE.SIZE);
  }
   return;

  case kREAL_TYPE:
/* line 2278 "FUnparse.puma" */
  {
/* line 2280 "FUnparse.puma" */
   fprintf (f, "real");
/* line 2281 "FUnparse.puma" */
   SizeUnparse (t->REAL_TYPE.SIZE);
  }
   return;

  case kTYPE_OBJ:
/* line 2284 "FUnparse.puma" */
  {
/* line 2286 "FUnparse.puma" */
   GetString (t->TYPE_OBJ.Ident, string);
/* line 2287 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

  case kREC_COMP:
/* line 2290 "FUnparse.puma" */
  {
/* line 2292 "FUnparse.puma" */
   GetString (t->REC_COMP.Ident, string);
/* line 2293 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

  case kDUMMY_TYPE:
/* line 2296 "FUnparse.puma" */
   return;

  case kALIGN_TYPE:
/* line 2299 "FUnparse.puma" */
   return;

  case kVAR_OBJ:
/* line 2302 "FUnparse.puma" */
  {
/* line 2304 "FUnparse.puma" */
   GetString (t->VAR_OBJ.Ident, string);
/* line 2305 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

  case kTOP_OBJ:
/* line 2308 "FUnparse.puma" */
  {
/* line 2310 "FUnparse.puma" */
   GetString (t->TOP_OBJ.Ident, string);
/* line 2311 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

  }

/* line 2314 "FUnparse.puma" */
  {
/* line 2315 "FUnparse.puma" */
   fprintf (f, "<unknown_structure>");
/* line 2316 "FUnparse.puma" */
   WriteTree (f, t);
  }
   return;

;
}

static int Priority
# if defined __STDC__ | defined __cplusplus
(register tTree yyP1)
# else
(yyP1)
 register tTree yyP1;
# endif
{

  switch (yyP1->Kind) {
  case kOP_DEFINED:
/* line 2338 "FUnparse.puma" */
   return 1;

  case kOP_EQV:
/* line 2340 "FUnparse.puma" */
   return 2;

  case kOP_NEQV:
/* line 2341 "FUnparse.puma" */
   return 2;

  case kOP_OR:
/* line 2343 "FUnparse.puma" */
   return 3;

  case kOP_XOR:
/* line 2344 "FUnparse.puma" */
   return 3;

  case kOP_AND:
/* line 2346 "FUnparse.puma" */
   return 4;

  case kOP1_NOT:
/* line 2348 "FUnparse.puma" */
   return 5;

  case kOP_EQ:
/* line 2350 "FUnparse.puma" */
   return 6;

  case kOP_NE:
/* line 2351 "FUnparse.puma" */
   return 6;

  case kOP_LE:
/* line 2352 "FUnparse.puma" */
   return 6;

  case kOP_LT:
/* line 2353 "FUnparse.puma" */
   return 6;

  case kOP_GE:
/* line 2354 "FUnparse.puma" */
   return 6;

  case kOP_GT:
/* line 2355 "FUnparse.puma" */
   return 6;

  case kOP_CONCAT:
/* line 2357 "FUnparse.puma" */
   return 7;

  case kOP_PLUS:
/* line 2359 "FUnparse.puma" */
   return 8;

  case kOP_MINUS:
/* line 2360 "FUnparse.puma" */
   return 8;

  case kOP1_SIGN:
/* line 2361 "FUnparse.puma" */
   return 8;

  case kOP1_PSIGN:
/* line 2362 "FUnparse.puma" */
   return 8;

  case kOP_TIMES:
/* line 2364 "FUnparse.puma" */
   return 9;

  case kOP_DIVIDE:
/* line 2365 "FUnparse.puma" */
   return 9;

  case kOP_EXPO:
/* line 2367 "FUnparse.puma" */
   return 10;

  }

 yyAbort ("Priority");
 { int yyDummy; return yyDummy; }
}

static void ComUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 2377 "FUnparse.puma" */
 char string [256]; 
 yyRecursion:
  if (t->Kind == kDECL_EMPTY) {
/* line 2379 "FUnparse.puma" */
   return;

  }
  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
/* line 2382 "FUnparse.puma" */
  {
/* line 2384 "FUnparse.puma" */
   t = t->DECL_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 2387 "FUnparse.puma" */
  {
/* line 2389 "FUnparse.puma" */
   ComUnparse (t->DECL_LIST.Elem);
/* line 2390 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2391 "FUnparse.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kVAR_DECL) {
  if (t->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
/* line 2394 "FUnparse.puma" */
  {
/* line 2396 "FUnparse.puma" */
   GetString (t->VAR_DECL.Ident, string);
/* line 2397 "FUnparse.puma" */
   fprintf (f, " %s (", string);
/* line 2398 "FUnparse.puma" */
   Unparse (t->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES);
/* line 2399 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  }
/* line 2402 "FUnparse.puma" */
  {
/* line 2404 "FUnparse.puma" */
   GetString (t->VAR_DECL.Ident, string);
/* line 2405 "FUnparse.puma" */
   fprintf (f, " %s", string);
  }
   return;

  }
/* line 2408 "FUnparse.puma" */
  {
/* line 2409 "FUnparse.puma" */
   fprintf (f, "<unknown_common_structure>");
  }
   return;

;
}

static void UnparseElse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kACF_EMPTY) {
/* line 2420 "FUnparse.puma" */
   return;

  }
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_IF) {
  if (equalint (t->ACF_LIST.Elem->ACF_IF.Label, 0)) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 2426 "FUnparse.puma" */
  {
/* line 2430 "FUnparse.puma" */
   ind ();
/* line 2431 "FUnparse.puma" */
   fprintf (f, " else if (");
/* line 2432 "FUnparse.puma" */
   Unparse (t->ACF_LIST.Elem->ACF_IF.IF_EXP);
/* line 2433 "FUnparse.puma" */
   fprintf (f, ") then");
/* line 2434 "FUnparse.puma" */
   LCR (t->ACF_LIST.Elem->ACF_IF.Line);
/* line 2435 "FUnparse.puma" */
   IncIndent ();
/* line 2436 "FUnparse.puma" */
   Unparse (t->ACF_LIST.Elem->ACF_IF.THEN_PART);
/* line 2437 "FUnparse.puma" */
   DecIndent ();
/* line 2438 "FUnparse.puma" */
   t = t->ACF_LIST.Elem->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  }
  }
  }
  }
/* line 2441 "FUnparse.puma" */
  {
/* line 2442 "FUnparse.puma" */
   ind ();
/* line 2443 "FUnparse.puma" */
   fprintf (f, " else\n");
/* line 2444 "FUnparse.puma" */
   IncIndent ();
/* line 2445 "FUnparse.puma" */
   Unparse (t);
/* line 2446 "FUnparse.puma" */
   DecIndent ();
  }
   return;

;
}

static void UnparseDoRange
# if defined __STDC__ | defined __cplusplus
(register tTree slice)
# else
(slice)
 register tTree slice;
# endif
{
  if (slice->Kind == kSLICE_EXP) {
  if (slice->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
/* line 2457 "FUnparse.puma" */
  {
/* line 2459 "FUnparse.puma" */
   Unparse (slice->SLICE_EXP.FIRST);
/* line 2460 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2461 "FUnparse.puma" */
   Unparse (slice->SLICE_EXP.STOP);
  }
   return;

  }
/* line 2464 "FUnparse.puma" */
  {
/* line 2466 "FUnparse.puma" */
   Unparse (slice->SLICE_EXP.FIRST);
/* line 2467 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2468 "FUnparse.puma" */
   Unparse (slice->SLICE_EXP.STOP);
/* line 2469 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2470 "FUnparse.puma" */
   Unparse (slice->SLICE_EXP.INC);
  }
   return;

  }
;
}

static void ExpUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int leftprio, register int rightprio)
# else
(t, leftprio, rightprio)
 register tTree t;
 register int leftprio;
 register int rightprio;
# endif
{
/* line 2494 "FUnparse.puma" */

char string [100];
int i;

/* line 2499 "FUnparse.puma" */
  {
/* line 2500 "FUnparse.puma" */
   if (! ((t == NoTree))) goto yyL1;
  {
/* line 2501 "FUnparse.puma" */
   fprintf (f, "<NoTree>");
  }
  }
   return;
yyL1:;


  switch (t->Kind) {
  case kOP_EXP:
/* line 2504 "FUnparse.puma" */
 {
  int myleftprio;
  int myrightprio;
  tTree yyV1;
  tTree yyV2;
  {
/* line 2509 "FUnparse.puma" */
   GetCenjuExp (t, & yyV1, & yyV2);
/* line 2511 "FUnparse.puma" */
   myleftprio = Priority (t->OP_EXP.EXP_OP);
/* line 2512 "FUnparse.puma" */
   myrightprio = myleftprio;
/* line 2514 "FUnparse.puma" */
 if (t->OP_EXP.EXP_OP->Kind == kOP_EXPO) myleftprio += 1; 
/* line 2516 "FUnparse.puma" */
 if ((leftprio >= myleftprio) || (rightprio > myrightprio))
      { fprintf (f, "(");
        ExpUnparse (t, 0, 0);
        fprintf (f, ")");
      }
     else
      { ExpUnparse (yyV1, leftprio, myleftprio);
        OpUnparse (t->OP_EXP.EXP_OP);
        ExpUnparse (yyV2, myrightprio, rightprio);
      }
    
  }
   return;
 }

  case kOP1_EXP:
/* line 2529 "FUnparse.puma" */
 {
  int priority;
  {
/* line 2533 "FUnparse.puma" */
 if (t->OP1_EXP.EXP_OP1->Kind == kOP_DEFINED) priority = 12;
        else priority = Priority (t->OP1_EXP.EXP_OP1);
    
/* line 2537 "FUnparse.puma" */
 if ((leftprio >= priority) || (rightprio > priority))
      { fprintf (f, "(");
        ExpUnparse (t, 0, 0);
        fprintf (f, ")");
      }
     else
      { OpUnparse (t->OP1_EXP.EXP_OP1);
        ExpUnparse (t->OP1_EXP.OPND, priority, rightprio);
      }
    
  }
   return;
 }

  case kDUMMY_EXP:
/* line 2549 "FUnparse.puma" */
  {
/* line 2550 "FUnparse.puma" */
   fprintf (f, "*");
  }
   return;

  case kCONST_EXP:
/* line 2553 "FUnparse.puma" */
  {
/* line 2554 "FUnparse.puma" */
   Unparse (t->CONST_EXP.C);
  }
   return;

  case kVAR_EXP:
/* line 2557 "FUnparse.puma" */
  {
/* line 2558 "FUnparse.puma" */
   Unparse (t->VAR_EXP.V);
  }
   return;

  case kTYPE_EXP:
/* line 2561 "FUnparse.puma" */
  {
/* line 2562 "FUnparse.puma" */
   GetString (t->TYPE_EXP.ID->TYPE_OBJ.Ident, string);
/* line 2563 "FUnparse.puma" */
   fprintf (f, "%s (", string);
/* line 2564 "FUnparse.puma" */
   Unparse (t->TYPE_EXP.ELEMENTS);
/* line 2565 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kARRAY_EXP:
/* line 2568 "FUnparse.puma" */
  {
/* line 2570 "FUnparse.puma" */
   fprintf (f, "(/");
/* line 2571 "FUnparse.puma" */
   Unparse (t->ARRAY_EXP.ELEMENTS);
/* line 2572 "FUnparse.puma" */
   fprintf (f, "/)");
  }
   return;

  case kBOUND_EXP:
/* line 2575 "FUnparse.puma" */
  {
/* line 2577 "FUnparse.puma" */
 if (t->BOUND_EXP.local == 1)
        fprintf (f,"local_");
       else if (t->BOUND_EXP.local == 2)
        fprintf (f,"global_");

     if (t->BOUND_EXP.kind == 0)
        fprintf (f,"lbound(");
      else
        fprintf (f,"ubound(");
   
/* line 2587 "FUnparse.puma" */
   Unparse (t->BOUND_EXP.VAR);
/* line 2588 "FUnparse.puma" */
   fprintf (f, ",%d)", t->BOUND_EXP.dim);
  }
   return;

  case kSIZE_EXP:
/* line 2591 "FUnparse.puma" */
  {
/* line 2593 "FUnparse.puma" */
   fprintf (f, "sizeof(");
/* line 2594 "FUnparse.puma" */
   Unparse (t->SIZE_EXP.VAR);
/* line 2595 "FUnparse.puma" */
   fprintf (f, "=%d)", t->SIZE_EXP.ass_size);
  }
   return;

  case kRANK_EXP:
  if (equalint (t->RANK_EXP.kind, 0)) {
/* line 2598 "FUnparse.puma" */
  {
/* line 2600 "FUnparse.puma" */
   fprintf (f, "size(processors_shape())");
  }
   return;

  }
  if (equalint (t->RANK_EXP.kind, 1)) {
/* line 2603 "FUnparse.puma" */
  {
/* line 2605 "FUnparse.puma" */
   fprintf (f, "size (active_procs_shape ())");
  }
   return;

  }
  break;
  case kSLICE_EXP:
/* line 2608 "FUnparse.puma" */
  {
/* line 2610 "FUnparse.puma" */
 if (t->SLICE_EXP.FIRST->Kind != kDUMMY_EXP)
         ExpUnparse (t->SLICE_EXP.FIRST, 0, 0);           
/* line 2612 "FUnparse.puma" */
   fprintf (f, ":");
/* line 2613 "FUnparse.puma" */
 if (t->SLICE_EXP.STOP->Kind != kDUMMY_EXP)
         ExpUnparse (t->SLICE_EXP.STOP, 0, 0);           
/* line 2615 "FUnparse.puma" */
 if (t->SLICE_EXP.INC->Kind != kDUMMY_EXP)
       { fprintf (f,":");
         ExpUnparse (t->SLICE_EXP.INC,0,0);
       }                           
   
  }
   return;

  case kFUNC_CALL_EXP:
/* line 2622 "FUnparse.puma" */
  {
/* line 2624 "FUnparse.puma" */
   Unparse (t->FUNC_CALL_EXP.FUNC_ID);
/* line 2625 "FUnparse.puma" */
   fprintf (f, "(");
/* line 2626 "FUnparse.puma" */
   Unparse (t->FUNC_CALL_EXP.FUNC_PARAMS);
/* line 2627 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kDO_EXP:
/* line 2630 "FUnparse.puma" */
  {
/* line 2632 "FUnparse.puma" */
   fprintf (f, "(");
/* line 2633 "FUnparse.puma" */
   Unparse (t->DO_EXP.BODY);
/* line 2634 "FUnparse.puma" */
   fprintf (f, ", ");
/* line 2635 "FUnparse.puma" */
   Unparse (t->DO_EXP.DO_ID);
/* line 2636 "FUnparse.puma" */
   fprintf (f, "=");
/* line 2637 "FUnparse.puma" */
   UnparseDoRange (t->DO_EXP.RANGE);
/* line 2638 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kNAMED_EXP:
/* line 2641 "FUnparse.puma" */
  {
/* line 2643 "FUnparse.puma" */
   GetString (t->NAMED_EXP.Name, string);
/* line 2644 "FUnparse.puma" */
   fprintf (f, "%s=", string);
/* line 2645 "FUnparse.puma" */
   Unparse (t->NAMED_EXP.VAL);
  }
   return;

  }

/* line 2648 "FUnparse.puma" */
  {
/* line 2650 "FUnparse.puma" */
   fprintf (f, "<unknown_exp>");
  }
   return;

;
}

static void GetCenjuExp
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree * yyP3, register tTree * yyP2)
# else
(t, yyP3, yyP2)
 register tTree t;
 register tTree * yyP3;
 register tTree * yyP2;
# endif
{
  if (t->Kind == kOP_EXP) {
  if (t->OP_EXP.EXP_OP->Kind == kOP_EXPO) {
/* line 2655 "FUnparse.puma" */
   * yyP3 = t->OP_EXP.OPND1;
   * yyP2 = MakeCenjuInt (t->OP_EXP.OPND2);
   return;

  }
/* line 2658 "FUnparse.puma" */
   * yyP3 = t->OP_EXP.OPND1;
   * yyP2 = t->OP_EXP.OPND2;
   return;

  }
;
}

static tTree MakeCenjuInt
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->Kind == kADDR) {
/* line 2662 "FUnparse.puma" */
  {
/* line 2664 "FUnparse.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL1;
  {
/* line 2665 "FUnparse.puma" */
   if (! (((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("DBLE")) || (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("REAL"))))) goto yyL1;
  }
  }
   return exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V->ADDR.E;
yyL1:;

  }
  }
  }
  }
/* line 2670 "FUnparse.puma" */
   return exp;

}

static void OpUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kOP_EQ:
/* line 2677 "FUnparse.puma" */
  {
/* line 2677 "FUnparse.puma" */
   fprintf (f, " .eq. ");
  }
   return;

  case kOP_NE:
/* line 2678 "FUnparse.puma" */
  {
/* line 2678 "FUnparse.puma" */
   fprintf (f, " .ne. ");
  }
   return;

  case kOP_LE:
/* line 2679 "FUnparse.puma" */
  {
/* line 2679 "FUnparse.puma" */
   fprintf (f, " .le. ");
  }
   return;

  case kOP_LT:
/* line 2680 "FUnparse.puma" */
  {
/* line 2680 "FUnparse.puma" */
   fprintf (f, " .lt. ");
  }
   return;

  case kOP_GE:
/* line 2681 "FUnparse.puma" */
  {
/* line 2681 "FUnparse.puma" */
   fprintf (f, " .ge. ");
  }
   return;

  case kOP_GT:
/* line 2682 "FUnparse.puma" */
  {
/* line 2682 "FUnparse.puma" */
   fprintf (f, " .gt. ");
  }
   return;

  case kOP_PLUS:
/* line 2683 "FUnparse.puma" */
  {
/* line 2683 "FUnparse.puma" */
   fprintf (f, "+");
  }
   return;

  case kOP_MINUS:
/* line 2684 "FUnparse.puma" */
  {
/* line 2684 "FUnparse.puma" */
   fprintf (f, "-");
  }
   return;

  case kOP_OR:
/* line 2685 "FUnparse.puma" */
  {
/* line 2685 "FUnparse.puma" */
   fprintf (f, " .or. ");
  }
   return;

  case kOP_XOR:
/* line 2686 "FUnparse.puma" */
  {
/* line 2686 "FUnparse.puma" */
   fprintf (f, " .xor. ");
  }
   return;

  case kOP_CONCAT:
/* line 2687 "FUnparse.puma" */
  {
/* line 2687 "FUnparse.puma" */
   fprintf (f, " //");
  }
   return;

  case kOP_TIMES:
/* line 2688 "FUnparse.puma" */
  {
/* line 2688 "FUnparse.puma" */
   fprintf (f, "*");
  }
   return;

  case kOP_DIVIDE:
/* line 2689 "FUnparse.puma" */
  {
/* line 2689 "FUnparse.puma" */
   fprintf (f, "/");
  }
   return;

  case kOP_AND:
/* line 2690 "FUnparse.puma" */
  {
/* line 2690 "FUnparse.puma" */
   fprintf (f, " .and. ");
  }
   return;

  case kOP_EQV:
/* line 2691 "FUnparse.puma" */
  {
/* line 2691 "FUnparse.puma" */
   fprintf (f, " .eqv. ");
  }
   return;

  case kOP_NEQV:
/* line 2692 "FUnparse.puma" */
  {
/* line 2692 "FUnparse.puma" */
   fprintf (f, " .neqv. ");
  }
   return;

  case kOP_EXPO:
/* line 2693 "FUnparse.puma" */
  {
/* line 2693 "FUnparse.puma" */
   fprintf (f, "**");
  }
   return;

  case kOP1_NOT:
/* line 2695 "FUnparse.puma" */
  {
/* line 2695 "FUnparse.puma" */
   fprintf (f, " .not. ");
  }
   return;

  case kOP1_SIGN:
/* line 2696 "FUnparse.puma" */
  {
/* line 2696 "FUnparse.puma" */
   fprintf (f, "-");
  }
   return;

  case kOP1_PSIGN:
/* line 2697 "FUnparse.puma" */
  {
/* line 2697 "FUnparse.puma" */
   fprintf (f, "+");
  }
   return;

  case kOP_DEFINED:
/* line 2699 "FUnparse.puma" */
  {
/* line 2701 "FUnparse.puma" */
   fprintf (f, " ");
/* line 2702 "FUnparse.puma" */
   PrintIdent (t->OP_DEFINED.opname);
/* line 2703 "FUnparse.puma" */
   fprintf (f, " ");
  }
   return;

  }

/* line 2706 "FUnparse.puma" */
  {
/* line 2708 "FUnparse.puma" */
   fprintf (f, "<op:->");
  }
   return;

;
}

static void FormatUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 2719 "FUnparse.puma" */
 char string[2048]; 
 yyRecursion:
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 2721 "FUnparse.puma" */
  {
/* line 2723 "FUnparse.puma" */
   t = t->BTP_LIST.Elem;
   goto yyRecursion;
  }

  }
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 2726 "FUnparse.puma" */
  {
/* line 2728 "FUnparse.puma" */
   FormatUnparse (t->BTP_LIST.Elem);
/* line 2729 "FUnparse.puma" */
   fprintf (f, "\n", string);
/* line 2730 "FUnparse.puma" */
   cont_ind ();
/* line 2731 "FUnparse.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (t->Kind == kFORMAT_PARAM) {
/* line 2734 "FUnparse.puma" */
  {
/* line 2736 "FUnparse.puma" */
   StGetString (t->FORMAT_PARAM.S, string);
/* line 2737 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

  }
;
}

static void LayoutUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 2748 "FUnparse.puma" */
 char string[256]; 
 yyRecursion:

  switch (t->Kind) {
  case kANY_DISTRIBUTION:
/* line 2750 "FUnparse.puma" */
  {
/* line 2752 "FUnparse.puma" */
   fprintf (f, "*");
  }
   return;

  case kDEFAULT_DISTRIBUTION:
/* line 2755 "FUnparse.puma" */
   return;

  case kREPL_DISTRIBUTION:
/* line 2758 "FUnparse.puma" */
  {
/* line 2760 "FUnparse.puma" */
   fprintf (f, "(:replicated)");
  }
   return;

  case kNODE_DISTRIBUTION:
  if (equalint (t->NODE_DISTRIBUTION.is_descriptive, 0)) {
/* line 2763 "FUnparse.puma" */
  {
/* line 2765 "FUnparse.puma" */
   fprintf (f, "(");
/* line 2766 "FUnparse.puma" */
   LayoutUnparse (t->NODE_DISTRIBUTION.MAPPING);
/* line 2767 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  }
  if (equalint (t->NODE_DISTRIBUTION.is_descriptive, 1)) {
/* line 2770 "FUnparse.puma" */
  {
/* line 2772 "FUnparse.puma" */
   fprintf (f, "* (");
/* line 2773 "FUnparse.puma" */
   LayoutUnparse (t->NODE_DISTRIBUTION.MAPPING);
/* line 2774 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  }
  break;
  case kDIST_LIST:
  if (t->DIST_LIST.Next->Kind == kDIST_EMPTY) {
/* line 2777 "FUnparse.puma" */
  {
/* line 2778 "FUnparse.puma" */
   t = t->DIST_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 2781 "FUnparse.puma" */
  {
/* line 2783 "FUnparse.puma" */
   LayoutUnparse (t->DIST_LIST.Elem);
/* line 2784 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2785 "FUnparse.puma" */
   t = t->DIST_LIST.Next;
   goto yyRecursion;
  }

  case kBLOCK_DISTRIBUTION:
  if (t->BLOCK_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
/* line 2788 "FUnparse.puma" */
  {
/* line 2790 "FUnparse.puma" */
   fprintf (f, "block");
  }
   return;

  }
/* line 2793 "FUnparse.puma" */
  {
/* line 2795 "FUnparse.puma" */
   fprintf (f, "block(");
/* line 2796 "FUnparse.puma" */
   Unparse (t->BLOCK_DISTRIBUTION.SIZE);
/* line 2797 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kCYCLIC_DISTRIBUTION:
  if (t->CYCLIC_DISTRIBUTION.SIZE->Kind == kDUMMY_EXP) {
/* line 2800 "FUnparse.puma" */
  {
/* line 2802 "FUnparse.puma" */
   fprintf (f, "cyclic");
  }
   return;

  }
/* line 2805 "FUnparse.puma" */
  {
/* line 2807 "FUnparse.puma" */
   fprintf (f, "cyclic(");
/* line 2808 "FUnparse.puma" */
   Unparse (t->CYCLIC_DISTRIBUTION.SIZE);
/* line 2809 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kGEN_BLOCK_DISTRIBUTION:
/* line 2812 "FUnparse.puma" */
  {
/* line 2814 "FUnparse.puma" */
   fprintf (f, "gen_block(");
/* line 2815 "FUnparse.puma" */
   Unparse (t->GEN_BLOCK_DISTRIBUTION.ARRAY);
/* line 2816 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kINDIRECT_DISTRIBUTION:
/* line 2819 "FUnparse.puma" */
  {
/* line 2821 "FUnparse.puma" */
   fprintf (f, "indirect(");
/* line 2822 "FUnparse.puma" */
   Unparse (t->INDIRECT_DISTRIBUTION.ARRAY);
/* line 2823 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kARBITRARY_DISTRIBUTION:
/* line 2826 "FUnparse.puma" */
  {
/* line 2828 "FUnparse.puma" */
   fprintf (f, "arbitrary(");
/* line 2829 "FUnparse.puma" */
   Unparse (t->ARBITRARY_DISTRIBUTION.SIZE);
/* line 2830 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2831 "FUnparse.puma" */
   Unparse (t->ARBITRARY_DISTRIBUTION.LENGTH);
/* line 2832 "FUnparse.puma" */
   fprintf (f, ",");
/* line 2833 "FUnparse.puma" */
   Unparse (t->ARBITRARY_DISTRIBUTION.MAP);
/* line 2834 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kSERIAL_DISTRIBUTION:
/* line 2837 "FUnparse.puma" */
  {
/* line 2839 "FUnparse.puma" */
   fprintf (f, "*");
  }
   return;

  case kANY_BLOCK_DISTRIBUTION:
/* line 2842 "FUnparse.puma" */
  {
/* line 2844 "FUnparse.puma" */
   fprintf (f, "block ()");
  }
   return;

  case kANY_CYCLIC_DISTRIBUTION:
/* line 2847 "FUnparse.puma" */
  {
/* line 2849 "FUnparse.puma" */
   fprintf (f, "cyclic ()");
  }
   return;

  case kANY_GEN_BLOCK_DISTRIBUTION:
/* line 2852 "FUnparse.puma" */
  {
/* line 2854 "FUnparse.puma" */
   fprintf (f, "gen_block ()");
  }
   return;

  case kANY_INDIRECT_DISTRIBUTION:
/* line 2857 "FUnparse.puma" */
  {
/* line 2859 "FUnparse.puma" */
   fprintf (f, "indirect ()");
  }
   return;

  case kANY_DIM_DISTRIBUTION:
/* line 2862 "FUnparse.puma" */
  {
/* line 2864 "FUnparse.puma" */
   fprintf (f, "all");
  }
   return;

  }

/* line 2867 "FUnparse.puma" */
  {
/* line 2868 "FUnparse.puma" */
   fprintf (f, "<unknown-layout>");
  }
   return;

;
}

static void ProcSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kANY_PROCESSOR_ARRAY) {
/* line 2884 "FUnparse.puma" */
  {
/* line 2886 "FUnparse.puma" */
   fprintf (f, " onto *");
  }
   return;

  }
  if (t->Kind == kDEFAULT_PROCESSOR_ARRAY) {
/* line 2889 "FUnparse.puma" */
   return;

  }
  if (t->Kind == kPROCESSOR_ARRAY) {
/* line 2892 "FUnparse.puma" */
  {
/* line 2894 "FUnparse.puma" */
   if (! (((t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident != DefaultId ()) || (t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object == NoObject)))) goto yyL3;
  {
/* line 2895 "FUnparse.puma" */
   fprintf (f, " onto ");
/* line 2896 "FUnparse.puma" */
   Unparse (t->PROCESSOR_ARRAY.TOPNAME);
  }
  }
   return;
yyL3:;

  if (t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object->Kind == kTopologyObject) {
/* line 2899 "FUnparse.puma" */
  {
/* line 2901 "FUnparse.puma" */
 

     if (t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object->TopologyObject.rank == 0)
        fprintf (f," onto #all");
      else
        fprintf (f," onto #%d", t->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Object->TopologyObject.rank);
   
  }
   return;

  }
  }
  if (t->Kind == kPROCESSOR_SUBSET) {
/* line 2910 "FUnparse.puma" */
  {
/* line 2912 "FUnparse.puma" */
   fprintf (f, " onto ");
/* line 2913 "FUnparse.puma" */
   Unparse (t->PROCESSOR_SUBSET.FULLTOP);
/* line 2914 "FUnparse.puma" */
   fprintf (f, "(");
/* line 2915 "FUnparse.puma" */
   Unparse (t->PROCESSOR_SUBSET.SUBSCRIPTS);
/* line 2916 "FUnparse.puma" */
   fprintf (f, ") = ");
/* line 2917 "FUnparse.puma" */
   Unparse (t->PROCESSOR_SUBSET.SUBTOP);
  }
   return;

  }
/* line 2920 "FUnparse.puma" */
  {
/* line 2921 "FUnparse.puma" */
   fprintf (f, "<unknown-proc-spec>");
  }
   return;

;
}

static rbool IsDeferredShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kARRAY_TYPE) {
/* line 2932 "FUnparse.puma" */
  {
/* line 2934 "FUnparse.puma" */
   if (! ((IsDeferredShape (t->ARRAY_TYPE.ARRAY_INDEX_TYPES)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  if (t->Kind == kSHAPE_LIST) {
/* line 2937 "FUnparse.puma" */
  {
/* line 2939 "FUnparse.puma" */
   if (! ((IsDeferredShape (t->SHAPE_LIST.Elem)))) goto yyL2;
  {
/* line 2940 "FUnparse.puma" */
   if (! ((IsDeferredShape (t->SHAPE_LIST.Next)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  if (t->Kind == kSHAPE_EMPTY) {
/* line 2943 "FUnparse.puma" */
   return rtrue;

  }
  if (t->Kind == kDEFERRED_SHAPE) {
/* line 2946 "FUnparse.puma" */
   return rtrue;

  }
  return rfalse;
}

static int UP_List_Length
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDECL_LIST) {
/* line 2957 "FUnparse.puma" */
   return (1 + UP_List_Length (t->DECL_LIST.Next));

  }
  if (t->Kind == kDECL_EMPTY) {
/* line 2961 "FUnparse.puma" */
   return 0;

  }
  if (t->Kind == kBTP_LIST) {
/* line 2965 "FUnparse.puma" */
   return (1 + UP_List_Length (t->BTP_LIST.Next));

  }
  if (t->Kind == kBTP_EMPTY) {
/* line 2969 "FUnparse.puma" */
   return 0;

  }
 yyAbort ("UP_List_Length");
 { int yyDummy; return yyDummy; }
}

static void FormalParamUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kDECL_EMPTY) {
/* line 2981 "FUnparse.puma" */
   return;

  }
  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
/* line 2984 "FUnparse.puma" */
  {
/* line 2986 "FUnparse.puma" */
   t = t->DECL_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 2989 "FUnparse.puma" */
  {
/* line 2991 "FUnparse.puma" */
   FormalParamUnparse (t->DECL_LIST.Elem);
/* line 2992 "FUnparse.puma" */
   fprintf (f, ", ");
/* line 2994 "FUnparse.puma" */
   if ((((UP_List_Length (t->DECL_LIST.Next) + 1) % 8) == 0)) {
/* line 2998 "FUnparse.puma" */
   fprintf (f, "\n");
/* line 2999 "FUnparse.puma" */
   fprintf (f, "     $  ");
   }
/* line 3003 "FUnparse.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kVAR_PARAM_DECL) {
/* line 3006 "FUnparse.puma" */
  {
/* line 3008 "FUnparse.puma" */
   PrintIdent (t->VAR_PARAM_DECL.Ident);
  }
   return;

  }
  if (t->Kind == kRET_PARAM_DECL) {
/* line 3011 "FUnparse.puma" */
  {
/* line 3013 "FUnparse.puma" */
   fprintf (f, "*");
  }
   return;

  }
/* line 3016 "FUnparse.puma" */
  {
/* line 3018 "FUnparse.puma" */
   fprintf (f, "<unknown_formal_param>");
  }
   return;

;
}

static void ParamUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 3029 "FUnparse.puma" */
 
char string[256]; 

 yyRecursion:
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 3033 "FUnparse.puma" */
  {
/* line 3034 "FUnparse.puma" */
   Unparse (t->BTP_LIST.Elem);
/* line 3035 "FUnparse.puma" */
   fprintf (f, ",");
/* line 3036 "FUnparse.puma" */
 if (((UP_List_Length (t->BTP_LIST.Next) + 1) % 8) == 0)
            
            { fprintf (f, "\n");
              fprintf (f, "     $  ");
            }
        
/* line 3042 "FUnparse.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 3045 "FUnparse.puma" */
  {
/* line 3046 "FUnparse.puma" */
   Unparse (t->BTP_LIST.Elem);
  }
   return;

  }
  }
;
}

static void AttributeUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 3059 "FUnparse.puma" */
 
char string[256]; 

 yyRecursion:

  switch (t->Kind) {
  case kDECL_EMPTY:
/* line 3063 "FUnparse.puma" */
   return;

  case kDECL_LIST:
/* line 3066 "FUnparse.puma" */
  {
/* line 3068 "FUnparse.puma" */
   fprintf (f, ", ");
/* line 3069 "FUnparse.puma" */
   AttributeUnparse (t->DECL_LIST.Elem);
/* line 3070 "FUnparse.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kDIMENSION_DECL:
/* line 3073 "FUnparse.puma" */
  {
/* line 3075 "FUnparse.puma" */
   fprintf (f, "dimension(");
/* line 3076 "FUnparse.puma" */
   Unparse (t->DIMENSION_DECL.INDEXES);
/* line 3077 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kTYPESPEC_DECL:
/* line 3080 "FUnparse.puma" */
  {
/* line 3082 "FUnparse.puma" */
   Unparse (t->TYPESPEC_DECL.VAL);
  }
   return;

  case kINIT_DATA_DECL:
  if (t->INIT_DATA_DECL.VAL->Kind == kDUMMY_EXP) {
/* line 3085 "FUnparse.puma" */
  {
/* line 3087 "FUnparse.puma" */
   fprintf (f, "data");
  }
   return;

  }
/* line 3090 "FUnparse.puma" */
  {
/* line 3092 "FUnparse.puma" */
   fprintf (f, "init = ");
/* line 3093 "FUnparse.puma" */
   Unparse (t->INIT_DATA_DECL.VAL);
  }
   return;

  case kALLOCATABLE_DECL:
/* line 3096 "FUnparse.puma" */
  {
/* line 3098 "FUnparse.puma" */
   fprintf (f, "allocatable");
  }
   return;

  case kEXTERNAL_DECL:
/* line 3101 "FUnparse.puma" */
  {
/* line 3103 "FUnparse.puma" */
   fprintf (f, "external");
  }
   return;

  case kINTENT_DECL:
/* line 3106 "FUnparse.puma" */
  {
/* line 3108 "FUnparse.puma" */
 switch (t->INTENT_DECL.intent) {
       case IntentIn    : fprintf (f,"intent(in)"); break;
       case IntentInOut : fprintf (f,"intent(inout)"); break;
       case IntentOut   : fprintf (f,"intent(out)\n"); break;
       default          : fprintf (f,"INTENT(:-:-:-)\n"); break;
     } 
   
  }
   return;

  case kINTRINSIC_DECL:
/* line 3117 "FUnparse.puma" */
  {
/* line 3119 "FUnparse.puma" */
   fprintf (f, "intrinsic");
  }
   return;

  case kOPTIONAL_DECL:
/* line 3122 "FUnparse.puma" */
  {
/* line 3124 "FUnparse.puma" */
   fprintf (f, "optional");
  }
   return;

  case kPOINTER_DECL:
/* line 3127 "FUnparse.puma" */
  {
/* line 3129 "FUnparse.puma" */
   fprintf (f, "pointer");
  }
   return;

  case kSAVE_DECL:
/* line 3132 "FUnparse.puma" */
  {
/* line 3134 "FUnparse.puma" */
   fprintf (f, "save");
  }
   return;

  case kTARGET_DECL:
/* line 3137 "FUnparse.puma" */
  {
/* line 3139 "FUnparse.puma" */
   fprintf (f, "target");
  }
   return;

  case kPARAMETER_DECL:
/* line 3142 "FUnparse.puma" */
  {
/* line 3144 "FUnparse.puma" */
   fprintf (f, "parameter");
  }
   return;

  case kPUBLIC_DECL:
/* line 3147 "FUnparse.puma" */
  {
/* line 3149 "FUnparse.puma" */
   fprintf (f, "public");
  }
   return;

  case kPRIVATE_DECL:
/* line 3152 "FUnparse.puma" */
  {
/* line 3154 "FUnparse.puma" */
   fprintf (f, "private");
  }
   return;

  case kTEMPLATE_DECL:
  if (t->TEMPLATE_DECL.DIMENSIONS->Kind == kSHAPE_EMPTY) {
/* line 3157 "FUnparse.puma" */
  {
/* line 3159 "FUnparse.puma" */
   fprintf (f, "template");
  }
   return;

  }
/* line 3162 "FUnparse.puma" */
  {
/* line 3164 "FUnparse.puma" */
   fprintf (f, "template (");
/* line 3165 "FUnparse.puma" */
   Unparse (t->TEMPLATE_DECL.DIMENSIONS);
/* line 3166 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kPROCESSORS_DECL:
  if (t->PROCESSORS_DECL.DIMENSIONS->Kind == kSHAPE_EMPTY) {
/* line 3169 "FUnparse.puma" */
  {
/* line 3171 "FUnparse.puma" */
   fprintf (f, "processors");
  }
   return;

  }
/* line 3174 "FUnparse.puma" */
  {
/* line 3176 "FUnparse.puma" */
   fprintf (f, "processors (");
/* line 3177 "FUnparse.puma" */
   Unparse (t->PROCESSORS_DECL.DIMENSIONS);
/* line 3178 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  case kALIGN_DECL:
  if (t->ALIGN_DECL.ALIGN_SOURCE->Kind == kBTE_EMPTY) {
/* line 3181 "FUnparse.puma" */
  {
/* line 3183 "FUnparse.puma" */
   fprintf (f, "align with ");
/* line 3184 "FUnparse.puma" */
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_TARGET);
  }
   return;

  }
/* line 3187 "FUnparse.puma" */
  {
/* line 3189 "FUnparse.puma" */
   fprintf (f, "align (");
/* line 3190 "FUnparse.puma" */
   Unparse (t->ALIGN_DECL.ALIGN_SOURCE);
/* line 3191 "FUnparse.puma" */
   fprintf (f, ") with ");
/* line 3192 "FUnparse.puma" */
   AlignSpecUnparse (t->ALIGN_DECL.ALIGN_TARGET);
  }
   return;

  case kDYNAMIC_DECL:
/* line 3195 "FUnparse.puma" */
  {
/* line 3197 "FUnparse.puma" */
   fprintf (f, "dynamic", string);
  }
   return;

  case kDISTRIBUTE_DECL:
/* line 3200 "FUnparse.puma" */
  {
/* line 3202 "FUnparse.puma" */
   fprintf (f, "distribute ");
/* line 3203 "FUnparse.puma" */
   LayoutUnparse (t->DISTRIBUTE_DECL.DISTRIBUTION);
/* line 3204 "FUnparse.puma" */
   ProcSpecUnparse (t->DISTRIBUTE_DECL.TARGET);
  }
   return;

  }

/* line 3207 "FUnparse.puma" */
  {
/* line 3208 "FUnparse.puma" */
   fprintf (f, "<attribute>");
  }
   return;

;
}

static void AlignSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 3223 "FUnparse.puma" */
 
char string[256]; 

  if (t->Kind == kALIGN_SPEC) {
  if (t->ALIGN_SPEC.SUBSCRIPTS->Kind == kBTE_EMPTY) {
/* line 3227 "FUnparse.puma" */
  {
/* line 3228 "FUnparse.puma" */
   GetString (t->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Ident, string);
/* line 3229 "FUnparse.puma" */
 if (t->ALIGN_SPEC.is_descriptive == 1)
         fprintf (f, "* ");
      fprintf (f, "%s", string);
    
  }
   return;

  }
/* line 3235 "FUnparse.puma" */
  {
/* line 3236 "FUnparse.puma" */
   GetString (t->ALIGN_SPEC.TEMPNAME->TEMP_OBJ.Ident, string);
/* line 3237 "FUnparse.puma" */
 if (t->ALIGN_SPEC.is_descriptive == 1)
         fprintf (f, "* ");
      fprintf (f, "%s(", string);
      Unparse (t->ALIGN_SPEC.SUBSCRIPTS);
      fprintf (f, ")");
    
  }
   return;

  }
/* line 3245 "FUnparse.puma" */
  {
/* line 3246 "FUnparse.puma" */
   fprintf (f, "<unknown_align_spec>");
  }
   return;

;
}

static void UseNameUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 3251 "FUnparse.puma" */
 
char string[256]; 

 yyRecursion:
  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Next->Kind == kDECL_EMPTY) {
/* line 3255 "FUnparse.puma" */
  {
/* line 3256 "FUnparse.puma" */
   t = t->DECL_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 3259 "FUnparse.puma" */
  {
/* line 3260 "FUnparse.puma" */
   UseNameUnparse (t->DECL_LIST.Elem);
/* line 3261 "FUnparse.puma" */
   fprintf (f, ", ");
/* line 3262 "FUnparse.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kPRIVATE_DECL) {
/* line 3265 "FUnparse.puma" */
  {
/* line 3266 "FUnparse.puma" */
   fprintf (f, "PRIVATE");
  }
   return;

  }
  if (t->Kind == kPUBLIC_DECL) {
/* line 3269 "FUnparse.puma" */
  {
/* line 3270 "FUnparse.puma" */
   fprintf (f, "PUBLIC");
  }
   return;

  }
  if (t->Kind == kNAME_DECL) {
/* line 3273 "FUnparse.puma" */
  {
/* line 3274 "FUnparse.puma" */
   GetString (t->NAME_DECL.Ident, string);
/* line 3275 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

  }
  if (t->Kind == kRENAME_DECL) {
/* line 3277 "FUnparse.puma" */
  {
/* line 3278 "FUnparse.puma" */
   GetString (t->RENAME_DECL.Ident, string);
/* line 3279 "FUnparse.puma" */
   fprintf (f, "%s => ", string);
/* line 3280 "FUnparse.puma" */
   GetString (t->RENAME_DECL.oldname, string);
/* line 3281 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

  }
;
}

static void GenSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 3286 "FUnparse.puma" */
 
char string[256]; 

  if (t->Kind == kNO_GENERIC_SPEC) {
/* line 3290 "FUnparse.puma" */
   return;

  }
  if (t->Kind == kID_GENERIC_SPEC) {
/* line 3293 "FUnparse.puma" */
  {
/* line 3294 "FUnparse.puma" */
   GetString (t->ID_GENERIC_SPEC.name, string);
/* line 3295 "FUnparse.puma" */
   fprintf (f, " %s", string);
  }
   return;

  }
  if (t->Kind == kOP_GENERIC_SPEC) {
/* line 3298 "FUnparse.puma" */
  {
/* line 3299 "FUnparse.puma" */
   fprintf (f, " OPERATOR (");
/* line 3300 "FUnparse.puma" */
   OpUnparse (t->OP_GENERIC_SPEC.OPERATOR);
/* line 3301 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  }
  if (t->Kind == kASSIGN_GENERIC_SPEC) {
/* line 3304 "FUnparse.puma" */
  {
/* line 3305 "FUnparse.puma" */
   fprintf (f, "ASSIGNMENT (=)");
  }
   return;

  }
;
}

static void CaseSelectorUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 3316 "FUnparse.puma" */
  {
/* line 3317 "FUnparse.puma" */
   t = t->BTE_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 3320 "FUnparse.puma" */
  {
/* line 3321 "FUnparse.puma" */
   CaseSelectorUnparse (t->BTE_LIST.Elem);
/* line 3322 "FUnparse.puma" */
   fprintf (f, ", ");
/* line 3323 "FUnparse.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kSLICE_EXP) {
  if (t->SLICE_EXP.FIRST->Kind == kDUMMY_EXP) {
/* line 3326 "FUnparse.puma" */
  {
/* line 3327 "FUnparse.puma" */
   fprintf (f, ":");
/* line 3328 "FUnparse.puma" */
   Unparse (t->SLICE_EXP.STOP);
  }
   return;

  }
  if (t->SLICE_EXP.STOP->Kind == kDUMMY_EXP) {
/* line 3331 "FUnparse.puma" */
  {
/* line 3332 "FUnparse.puma" */
   Unparse (t->SLICE_EXP.FIRST);
/* line 3333 "FUnparse.puma" */
   fprintf (f, ":");
  }
   return;

  }
/* line 3336 "FUnparse.puma" */
  {
/* line 3337 "FUnparse.puma" */
   Unparse (t->SLICE_EXP.FIRST);
/* line 3338 "FUnparse.puma" */
   fprintf (f, ":");
/* line 3339 "FUnparse.puma" */
   Unparse (t->SLICE_EXP.STOP);
  }
   return;

  }
/* line 3342 "FUnparse.puma" */
  {
/* line 3343 "FUnparse.puma" */
   Unparse (t);
  }
   return;

;
}

static void OnSpecUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree ontop, register tTree onlist)
# else
(ontop, onlist)
 register tTree ontop;
 register tTree onlist;
# endif
{
/* line 3354 "FUnparse.puma" */

char string[50];

/* line 3358 "FUnparse.puma" */
  {
/* line 3360 "FUnparse.puma" */
   if (! ((ontop == NoTree))) goto yyL1;
  {
/* line 3362 "FUnparse.puma" */
   fprintf (f, "(:-)");
/* line 3364 "FUnparse.puma" */
   OnListUnparse (onlist);
  }
  }
   return;
yyL1:;

  if (ontop->Kind == kON_ALL) {
  if (onlist->Kind == kON_EMPTY) {
/* line 3367 "FUnparse.puma" */
  {
/* line 3369 "FUnparse.puma" */
   fprintf (f, "(all)");
  }
   return;

  }
  }
  if (ontop->Kind == kON_HOST) {
  if (onlist->Kind == kON_EMPTY) {
/* line 3372 "FUnparse.puma" */
  {
/* line 3373 "FUnparse.puma" */
   fprintf (f, "(host)");
  }
   return;

  }
  }
  if (ontop->Kind == kON_PROCS) {
/* line 3376 "FUnparse.puma" */
  {
/* line 3378 "FUnparse.puma" */
 GetString (ontop->ON_PROCS.topid->Object.Ident, string);
      fprintf (f, "(top %s (#%d))", string, ontop->ON_PROCS.topid->TopologyObject.rank);
    
/* line 3381 "FUnparse.puma" */
   OnListUnparse (onlist);
  }
   return;

  }
  if (ontop->Kind == kON_VAR) {
/* line 3384 "FUnparse.puma" */
  {
/* line 3386 "FUnparse.puma" */
 if (ontop->ON_VAR.topid == NoObject)
         fprintf (f, "(top *, ");
       else
         { GetString (ontop->ON_VAR.topid->Object.Ident, string);
           fprintf (f, "(top %s (#%d), ", string, ontop->ON_VAR.topid->TopologyObject.rank);
         }
      if (ontop->ON_VAR.tempid == NoObject)
         fprintf (f, "template *, ");
       else
         { GetString (ontop->ON_VAR.tempid->Object.Ident, string);
           fprintf (f, "template %s, ", string);
         }
      if (ontop->ON_VAR.arrayid == NoObject)
         fprintf (f, "array *)");
       else
         { GetString (ontop->ON_VAR.arrayid->Object.Ident, string);
           fprintf (f, "array %s)", string);
         }
    
/* line 3405 "FUnparse.puma" */
   OnListUnparse (onlist);
  }
   return;

  }
;
}

static void OnListUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
 yyRecursion:
  if (list->Kind == kON_LIST) {
/* line 3410 "FUnparse.puma" */
  {
/* line 3411 "FUnparse.puma" */
   OnListUnparse (list->ON_LIST.Elem);
/* line 3412 "FUnparse.puma" */
   list = list->ON_LIST.Next;
   goto yyRecursion;
  }

  }
  if (list->Kind == kON_EMPTY) {
/* line 3415 "FUnparse.puma" */
   return;

  }
  if (list->Kind == kON_SPEC) {
/* line 3418 "FUnparse.puma" */
  {
/* line 3420 "FUnparse.puma" */
   fprintf (f, "(%d:", list->ON_SPEC.top_dim);
/* line 3421 "FUnparse.puma" */
   Unparse (list->ON_SPEC.ON_VAL);
/* line 3422 "FUnparse.puma" */
   fprintf (f, ") ");
  }
   return;

  }
/* line 3425 "FUnparse.puma" */
  {
/* line 3426 "FUnparse.puma" */
   fprintf (f, "<on-spec>");
  }
   return;

;
}

static rbool MoreParameters
# if defined __STDC__ | defined __cplusplus
(register tTree parameterlist)
# else
(parameterlist)
 register tTree parameterlist;
# endif
{
  if (parameterlist->Kind == kBTP_LIST) {
/* line 3432 "FUnparse.puma" */
   return rtrue;

  }
  return rfalse;
}

static void StatusUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree status)
# else
(status)
 register tTree status;
# endif
{
  if (status->Kind == kDUMMY_VAR) {
/* line 3439 "FUnparse.puma" */
   return;

  }
/* line 3442 "FUnparse.puma" */
  {
/* line 3443 "FUnparse.puma" */
   fprintf (f, ",STAT=");
/* line 3444 "FUnparse.puma" */
   Unparse (status);
  }
   return;

;
}

static void DepInfoUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree info)
# else
(info)
 register tTree info;
# endif
{
  if (info->Kind == kSERIAL_INFO) {
/* line 3457 "FUnparse.puma" */
   return;

  }
  if (info->Kind == kPARDO_INFO) {
/* line 3460 "FUnparse.puma" */
  {
/* line 3462 "FUnparse.puma" */
   fprintf (f, "  ! parallel ");
  }
   return;

  }
  if (info->Kind == kINDEP_INFO) {
/* line 3465 "FUnparse.puma" */
  {
/* line 3467 "FUnparse.puma" */
 fprintf (f," ! independent");
     if (info->INDEP_INFO.user_independent)
        fprintf (f, " (user)");
       else
        fprintf (f, " (system)");
     if (info->INDEP_INFO.selection)
        { fprintf (f, ", select(");
          SelectorUnparse (info->INDEP_INFO.selection);
          fprintf (f, ")");
        }
   
  }
   return;

  }
;
}

static void HomeInfoUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree info)
# else
(info)
 register tTree info;
# endif
{
  if (info->Kind == kNO_HOME_INFO) {
/* line 3490 "FUnparse.puma" */
   return;

  }
  if (info->Kind == kCOMM_INFO) {
/* line 3493 "FUnparse.puma" */
  {
/* line 3495 "FUnparse.puma" */
 if (info->COMM_INFO.is_local)
        fprintf (f, ", resident");
     if (info->COMM_INFO.home_var != NoTree)
        { fprintf (f,", on ");
          Unparse (info->COMM_INFO.home_var);
        }
   
  }
   return;

  }
  if (info->Kind == kON_INFO) {
/* line 3504 "FUnparse.puma" */
  {
/* line 3506 "FUnparse.puma" */
 fprintf (f," ! on ");

     if (info->ON_INFO.on_id == NoObject)
        fprintf (f, "*");
      else
        { GetString (info->ON_INFO.on_id->Object.Ident, string);
          fprintf (f, "%s", string);
        }
     fprintf (f," dim = %d, kind = %d, %d+%d*I", info->ON_INFO.on_dim, info->ON_INFO.kind, info->ON_INFO.base, info->ON_INFO.stride);
     
   
  }
   return;

  }
/* line 3519 "FUnparse.puma" */
  {
/* line 3521 "FUnparse.puma" */
   fprintf (f, "<comm-info>");
  }
   return;

;
}

static void VecInfoUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree dep_info)
# else
(dep_info)
 register tTree dep_info;
# endif
{
  if (dep_info->Kind == kVECTOR_INFO) {
/* line 3532 "FUnparse.puma" */
  {
/* line 3536 "FUnparse.puma" */
   if (! ((dep_info->VECTOR_INFO.is_independent))) goto yyL1;
  {
/* line 3538 "FUnparse.puma" */
   fprintf (f, "!CDIR nodep");
/* line 3540 "FUnparse.puma" */
 if (dep_info->VECTOR_INFO.selection & kSELECT_NOVECTOR)
       fprintf (f, ", novector");
     if (dep_info->VECTOR_INFO.selection & kSELECT_SHORT)
       fprintf (f, ", shortloop");
     if (dep_info->VECTOR_INFO.selection & kSELECT_EXPAND)
       { if (dep_info->VECTOR_INFO.loop_cnt > 0)
            fprintf (f, ", expand=%d", dep_info->VECTOR_INFO.loop_cnt);
       } 
   
/* line 3550 "FUnparse.puma" */
   fprintf (f, "\n");
  }
  }
   return;
yyL1:;

/* line 3553 "FUnparse.puma" */
  {
/* line 3557 "FUnparse.puma" */
 if (dep_info->VECTOR_INFO.selection & kSELECT_NOVECTOR)
       fprintf (f, "!CDIR novector\n");
     if (dep_info->VECTOR_INFO.selection & kSELECT_SHORT)
       fprintf (f, "!CDIR shortloop\n");
     if (dep_info->VECTOR_INFO.selection & kSELECT_EXPAND)
       { if (dep_info->VECTOR_INFO.loop_cnt > 0)
            fprintf (f, "!CDIR expand=%d\n", dep_info->VECTOR_INFO.loop_cnt);
       } 
   
  }
   return;

  }
;
}

static void SizeUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree size)
# else
(size)
 register tTree size;
# endif
{
/* line 3576 "FUnparse.puma" */

char string[256];

  if (size->Kind == kCONST_EXP) {
  if (size->CONST_EXP.C->Kind == kINT_CONSTANT) {
/* line 3580 "FUnparse.puma" */
  {
/* line 3581 "FUnparse.puma" */
   if (! ((size->CONST_EXP.C->INT_CONSTANT.value >= 0))) goto yyL1;
  {
/* line 3582 "FUnparse.puma" */
   fprintf (f, "*%d", size->CONST_EXP.C->INT_CONSTANT.value);
  }
  }
   return;
yyL1:;

  }
  }
/* line 3585 "FUnparse.puma" */
  {
/* line 3586 "FUnparse.puma" */
   fprintf (f, "(KIND=");
/* line 3587 "FUnparse.puma" */
   ExpUnparse (size, 0, 0);
/* line 3588 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

;
}

static void EndUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 3602 "FUnparse.puma" */

/* string is used globally */

/* line 3606 "FUnparse.puma" */
  {
/* line 3608 "FUnparse.puma" */
   if (! ((target_language != FORTRAN_90))) goto yyL1;
  {
/* line 3609 "FUnparse.puma" */
   if (! ((target_language != FORTRAN_95))) goto yyL1;
  {
/* line 3611 "FUnparse.puma" */
   fprintf (f, "\n");
  }
  }
  }
   return;
yyL1:;

  if (t->Kind == kPROC_DECL) {
/* line 3614 "FUnparse.puma" */
  {
/* line 3616 "FUnparse.puma" */
   GetString (t->PROC_DECL.Ident, string);
/* line 3617 "FUnparse.puma" */
   fprintf (f, " SUBROUTINE %s\n", string);
  }
   return;

  }
  if (t->Kind == kFUNC_DECL) {
/* line 3620 "FUnparse.puma" */
  {
/* line 3622 "FUnparse.puma" */
   GetString (t->FUNC_DECL.Ident, string);
/* line 3623 "FUnparse.puma" */
   fprintf (f, " FUNCTION %s\n", string);
  }
   return;

  }
  if (t->Kind == kPROGRAM_DECL) {
/* line 3626 "FUnparse.puma" */
  {
/* line 3628 "FUnparse.puma" */
   GetString (t->PROGRAM_DECL.Ident, string);
/* line 3629 "FUnparse.puma" */
   fprintf (f, " PROGRAM %s\n", string);
  }
   return;

  }
  if (t->Kind == kMODULE_DECL) {
/* line 3632 "FUnparse.puma" */
  {
/* line 3634 "FUnparse.puma" */
   GetString (t->MODULE_DECL.Ident, string);
/* line 3635 "FUnparse.puma" */
   fprintf (f, " MODULE %s\n", string);
  }
   return;

  }
/* line 3638 "FUnparse.puma" */
  {
/* line 3639 "FUnparse.puma" */
   fprintf (f, "\n");
  }
   return;

;
}

static void PrefixUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_DECL) {
/* line 3652 "FUnparse.puma" */
  {
/* line 3654 "FUnparse.puma" */
   if (! ((t->FUNC_DECL.IsRecursive))) goto yyL1;
  {
/* line 3655 "FUnparse.puma" */
   fprintf (f, "RECURSIVE ");
/* line 3656 "FUnparse.puma" */
   goto yyL1;
  }
  }
yyL1:;

/* line 3659 "FUnparse.puma" */
  {
/* line 3661 "FUnparse.puma" */
   if (! ((t->FUNC_DECL.IsPure))) goto yyL2;
  {
/* line 3662 "FUnparse.puma" */
   fprintf (f, "PURE ");
/* line 3663 "FUnparse.puma" */
   goto yyL2;
  }
  }
yyL2:;

/* line 3666 "FUnparse.puma" */
  {
/* line 3668 "FUnparse.puma" */
   if (! ((t->FUNC_DECL.HPFExtrinsic != DefaultId ()))) goto yyL3;
  {
/* line 3669 "FUnparse.puma" */
   GetString (t->FUNC_DECL.HPFExtrinsic, string);
/* line 3670 "FUnparse.puma" */
   fprintf (f, "extrinsic (%s) ", string);
/* line 3671 "FUnparse.puma" */
   goto yyL3;
  }
  }
yyL3:;

  if (t->FUNC_DECL.RESULT_TYPE->Kind == kDUMMY_TYPE) {
/* line 3674 "FUnparse.puma" */
   return;

  }
/* line 3677 "FUnparse.puma" */
  {
/* line 3679 "FUnparse.puma" */
   Unparse (t->FUNC_DECL.RESULT_TYPE);
/* line 3680 "FUnparse.puma" */
   fprintf (f, " ");
  }
   return;

  }
  if (t->Kind == kPROC_DECL) {
/* line 3683 "FUnparse.puma" */
  {
/* line 3685 "FUnparse.puma" */
   if (! ((t->PROC_DECL.IsRecursive))) goto yyL6;
  {
/* line 3686 "FUnparse.puma" */
   fprintf (f, "recursive ");
/* line 3687 "FUnparse.puma" */
   goto yyL6;
  }
  }
yyL6:;

/* line 3690 "FUnparse.puma" */
  {
/* line 3692 "FUnparse.puma" */
   if (! ((t->PROC_DECL.IsPure))) goto yyL7;
  {
/* line 3693 "FUnparse.puma" */
   fprintf (f, "pure ");
/* line 3694 "FUnparse.puma" */
   goto yyL7;
  }
  }
yyL7:;

/* line 3697 "FUnparse.puma" */
  {
/* line 3699 "FUnparse.puma" */
   if (! ((t->PROC_DECL.HPFExtrinsic != DefaultId ()))) goto yyL8;
  {
/* line 3700 "FUnparse.puma" */
   GetString (t->PROC_DECL.HPFExtrinsic, string);
/* line 3701 "FUnparse.puma" */
   fprintf (f, "extrinsic (%s) ", string);
/* line 3702 "FUnparse.puma" */
   goto yyL8;
  }
  }
yyL8:;

  }
;
}

static void DspKindUnparse
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
/* line 3715 "FUnparse.puma" */
  {
/* line 3716 "FUnparse.puma" */
   if (! ((kind == kFIXED_DSP))) goto yyL1;
  {
/* line 3717 "FUnparse.puma" */
   fprintf (f, "fixed_dsp");
  }
  }
   return;
yyL1:;

/* line 3720 "FUnparse.puma" */
  {
/* line 3721 "FUnparse.puma" */
   if (! ((kind == kATTACH_DSP))) goto yyL2;
  {
/* line 3722 "FUnparse.puma" */
   fprintf (f, "attach_dsp");
  }
  }
   return;
yyL2:;

/* line 3725 "FUnparse.puma" */
  {
/* line 3726 "FUnparse.puma" */
   if (! ((kind == kALLOCATE_DSP))) goto yyL3;
  {
/* line 3727 "FUnparse.puma" */
   fprintf (f, "allocate_dsp");
  }
  }
   return;
yyL3:;

/* line 3730 "FUnparse.puma" */
  {
/* line 3731 "FUnparse.puma" */
   if (! ((kind == kTEMPLATE_DSP))) goto yyL4;
  {
/* line 3732 "FUnparse.puma" */
   fprintf (f, "template_dsp");
  }
  }
   return;
yyL4:;

/* line 3735 "FUnparse.puma" */
  {
/* line 3736 "FUnparse.puma" */
   if (! ((kind == kTOPOLOGY_DSP))) goto yyL5;
  {
/* line 3737 "FUnparse.puma" */
   fprintf (f, "topology_dsp");
  }
  }
   return;
yyL5:;

/* line 3740 "FUnparse.puma" */
  {
/* line 3741 "FUnparse.puma" */
   if (! ((kind == kDUMMY_DSP))) goto yyL6;
  {
/* line 3742 "FUnparse.puma" */
   fprintf (f, "dummy_dsp");
  }
  }
   return;
yyL6:;

/* line 3745 "FUnparse.puma" */
  {
/* line 3746 "FUnparse.puma" */
   if (! ((kind == kASSUMED_DSP))) goto yyL7;
  {
/* line 3747 "FUnparse.puma" */
   fprintf (f, "assumed_dsp");
  }
  }
   return;
yyL7:;

/* line 3750 "FUnparse.puma" */
  {
/* line 3751 "FUnparse.puma" */
   if (! ((kind == kLOCAL_DSP))) goto yyL8;
  {
/* line 3752 "FUnparse.puma" */
   fprintf (f, "local_dsp");
  }
  }
   return;
yyL8:;

/* line 3755 "FUnparse.puma" */
  {
/* line 3756 "FUnparse.puma" */
   fprintf (f, ":-");
  }
   return;

;
}

static void HPFBodyUnparse
# if defined __STDC__ | defined __cplusplus
(register int line, register tTree body, register int kind)
# else
(line, body, kind)
 register int line;
 register tTree body;
 register int kind;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 3773 "FUnparse.puma" */
  {
/* line 3775 "FUnparse.puma" */
   LCR (line);
/* line 3776 "FUnparse.puma" */
   Unparse (body);
  }
   return;

  }
  }
/* line 3779 "FUnparse.puma" */
  {
/* line 3781 "FUnparse.puma" */
   fprintf (f, " begin");
/* line 3782 "FUnparse.puma" */
   LCR (line);
/* line 3783 "FUnparse.puma" */
   IncIndent ();
/* line 3784 "FUnparse.puma" */
   Unparse (body);
/* line 3785 "FUnparse.puma" */
   DecIndent ();
/* line 3786 "FUnparse.puma" */
 if (kind == 0)
          fprintf (f,"!hpf$ end on\n");
       else if (kind == 1)
          fprintf (f,"!hpf$ end resident\n");
       else if (kind == 2)
          fprintf (f,"!hpf$ end new\n");
       else
          fprintf (f,"!hpf$ end reduction\n");
    
  }
   return;

;
}

static void ResidentUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree resident_vars)
# else
(resident_vars)
 register tTree resident_vars;
# endif
{
/* line 3805 "FUnparse.puma" */
  {
/* line 3806 "FUnparse.puma" */
   if (! ((resident_vars == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (resident_vars->Kind == kBTV_LIST) {
  if (resident_vars->BTV_LIST.Elem->Kind == kDUMMY_VAR) {
  if (resident_vars->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 3809 "FUnparse.puma" */
  {
/* line 3811 "FUnparse.puma" */
   fprintf (f, ", resident");
  }
   return;

  }
  }
/* line 3814 "FUnparse.puma" */
  {
/* line 3816 "FUnparse.puma" */
   fprintf (f, ", resident (");
/* line 3817 "FUnparse.puma" */
   Unparse (resident_vars);
/* line 3818 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  }
;
}

static void NewUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree new_vars)
# else
(new_vars)
 register tTree new_vars;
# endif
{
/* line 3823 "FUnparse.puma" */
  {
/* line 3824 "FUnparse.puma" */
   if (! ((new_vars == NoTree))) goto yyL1;
  }
   return;
yyL1:;

  if (new_vars->Kind == kBTV_EMPTY) {
/* line 3827 "FUnparse.puma" */
   return;

  }
  if (new_vars->Kind == kBTV_LIST) {
/* line 3830 "FUnparse.puma" */
  {
/* line 3832 "FUnparse.puma" */
   fprintf (f, ", new (");
/* line 3833 "FUnparse.puma" */
   Unparse (new_vars);
/* line 3834 "FUnparse.puma" */
   fprintf (f, ")");
  }
   return;

  }
;
}

static void ResolveACFHome
# if defined __STDC__ | defined __cplusplus
(register tTree home_body, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(home_body, yyP6, yyP5, yyP4)
 register tTree home_body;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
  if (home_body->Kind == kACF_LIST) {
  if (home_body->ACF_LIST.Elem->Kind == kACF_NEW) {
  if (home_body->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 3846 "FUnparse.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 3850 "FUnparse.puma" */
   ResolveACFHome (home_body->ACF_LIST.Elem->ACF_NEW.NEW_BODY, & yyV1, & yyV2, & yyV3);
/* line 3852 "FUnparse.puma" */
   if (! ((yyV3 == NoTree))) goto yyL1;
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = home_body->ACF_LIST.Elem->ACF_NEW.NEW_VAR;
   return;
 }
yyL1:;

  }
  }
  if (home_body->ACF_LIST.Elem->Kind == kACF_RESIDENT) {
  if (home_body->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 3855 "FUnparse.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 3860 "FUnparse.puma" */
   ResolveACFHome (home_body->ACF_LIST.Elem->ACF_RESIDENT.RESIDENT_BODY, & yyV1, & yyV2, & yyV3);
/* line 3862 "FUnparse.puma" */
   if (! ((yyV2 == NoTree))) goto yyL2;
  }
   * yyP6 = yyV1;
   * yyP5 = home_body->ACF_LIST.Elem->ACF_RESIDENT.RESIDENT_VAR;
   * yyP4 = yyV3;
   return;
 }
yyL2:;

  }
  }
  }
/* line 3865 "FUnparse.puma" */
   * yyP6 = home_body;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

static rbool IsDummyParam
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
  if (param->VAR_PARAM.V->ADDR.E->Kind == kDUMMY_EXP) {
/* line 3876 "FUnparse.puma" */
   return rtrue;

  }
  }
  }
  if (param->Kind == kVALUE_PARAM) {
  if (param->VALUE_PARAM.E->Kind == kDUMMY_EXP) {
/* line 3879 "FUnparse.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

static void SMParUnparse
# if defined __STDC__ | defined __cplusplus
(register tTree red_vars, register tTree shared_vars, register tTree local_vars)
# else
(red_vars, shared_vars, local_vars)
 register tTree red_vars;
 register tTree shared_vars;
 register tTree local_vars;
# endif
{
/* line 3890 "FUnparse.puma" */
 {
  rbool cont;
  {
/* line 3894 "FUnparse.puma" */
   cont = ! EmptyList (shared_vars) || ! EmptyList (local_vars);
/* line 3895 "FUnparse.puma" */
   SMVarUnparse (0, red_vars, cont);
/* line 3896 "FUnparse.puma" */
   cont = ! EmptyList (local_vars);
/* line 3897 "FUnparse.puma" */
   SMVarUnparse (1, shared_vars, cont);
/* line 3898 "FUnparse.puma" */
   cont = rfalse;
/* line 3899 "FUnparse.puma" */
   SMVarUnparse (2, local_vars, cont);
  }
   return;
 }

;
}

static void SMVarUnparse
# if defined __STDC__ | defined __cplusplus
(register int kind, register tTree var_list, register rbool cont)
# else
(kind, var_list, cont)
 register int kind;
 register tTree var_list;
 register rbool cont;
# endif
{
/* line 3904 "FUnparse.puma" */
  {
/* line 3906 "FUnparse.puma" */
   if (! ((EmptyList (var_list)))) goto yyL1;
  }
   return;
yyL1:;

/* line 3909 "FUnparse.puma" */
  {
/* line 3911 "FUnparse.puma" */
 if (kind == 0) fprintf (f, "reduction(");
     if (kind == 1) fprintf (f, "shared(");
     if (kind == 2)
        { if (sm_parallelization == SGI_MP)
             fprintf (f, "local(");
            else
             fprintf (f, "private(");
        }
     Unparse (var_list);
     fprintf (f, ")");
     if (cont) fprintf (f, ", ");
   
  }
   return;

;
}

static rbool EmptyList
# if defined __STDC__ | defined __cplusplus
(register tTree var_list)
# else
(var_list)
 register tTree var_list;
# endif
{
/* line 3927 "FUnparse.puma" */
  {
/* line 3928 "FUnparse.puma" */
   if (! ((var_list == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (var_list->Kind == kBTV_EMPTY) {
/* line 3931 "FUnparse.puma" */
   return rtrue;

  }
  return rfalse;
}

static void SMGetParLoop
# if defined __STDC__ | defined __cplusplus
(register tTree body, register rbool * yyP8, register tTree * yyP7)
# else
(body, yyP8, yyP7)
 register tTree body;
 register rbool * yyP8;
 register tTree * yyP7;
# endif
{
  if (body->Kind == kACF_LIST) {
  if (body->ACF_LIST.Elem->Kind == kACF_DO) {
  if (body->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 3937 "FUnparse.puma" */
   * yyP8 = rtrue;
   * yyP7 = body->ACF_LIST.Elem;
   return;

  }
  }
  }
/* line 3940 "FUnparse.puma" */
   * yyP8 = rfalse;
   * yyP7 = NoTree;
   return;

;
}

static void SelectorUnparse
# if defined __STDC__ | defined __cplusplus
(register int selector)
# else
(selector)
 register int selector;
# endif
{
/* line 3945 "FUnparse.puma" */
 {
  rbool first;
  {
/* line 3949 "FUnparse.puma" */
 first = rtrue;  

     if (selector & kSELECT_NOVECTOR)
        { if (!first) fprintf (f,"/");
          fprintf (f, "novector"); first = rfalse;
        }

     if (selector & kSELECT_SHORT)
        { if (!first) fprintf (f,"/");
          fprintf (f, "short"); first = rfalse;
        }

     if (selector & kSELECT_EXPAND)
        { if (!first) fprintf (f,"/");
          fprintf (f, "expand"); first = rfalse;
        }

     if (selector & kSELECT_CONCUR)
        { if (!first) fprintf (f,"/");
          fprintf (f, "concur"); first = rfalse;
        }
   
  }
   return;
 }

;
}

static void PrintIdent
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 3981 "FUnparse.puma" */

char string [MAX_ID_LENGTH];

/* line 3985 "FUnparse.puma" */
  {
/* line 3987 "FUnparse.puma" */
   GetString (name, string);
/* line 3988 "FUnparse.puma" */
   fprintf (f, "%s", string);
  }
   return;

;
}

void BeginUnparse ARGS ((void))
{
/* line 167 "FUnparse.puma" */

  f = fopen ("unparse.f","w");
  indent = 0;

}

void CloseUnparse ARGS ((void))
{
/* line 173 "FUnparse.puma" */

  fclose (f);

}
