# include "UnitDefs.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 22 "UnitDefs.puma" */


# include "Idents.h"

# include "StringM.h"

# include "protocol.h"

# include "MakeDefs.h"
# include "DefTable.h"  
# include "Objects.h"      /* MakeNewObject */

# include "Nesting.h"

# define MODULE "UnitDefs"

    /*****************************************************
    *                                                    *
    *  global =  ProgramCounter : counts PROGRAM_DECL    *
    *                                                    *
    *****************************************************/

static int ProgramCounter = 0;     /* counter for MAIN programs */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyUnitDefs.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* UnitDefs_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module UnitDefs, routine %s failed\n",
  yyFunction);
 UnitDefs_Exit ();
}

void UseModule ARGS ((tDefinitions obj, tTree renamings));
void UseOnlyModule ARGS ((tDefinitions obj, tTree names));
static void CheckModuleDefinitions ARGS ((tDefinitions obj));
static void EnterAllDeclarations ARGS ((tDefinitions all, tTree renamings));
static void EnterNamedDeclarations ARGS ((tDefinitions all, tTree names));
static void MakeVisible ARGS ((tDefinitions obj, tIdent old_id, tIdent new_id));
static void EnterRenameEntry ARGS ((tDefinitions obj, tTree renamings, rbool done));
static void DoNotHideDummy ARGS ((tDefinitions obj, tDefinitions hide_obj));
static tDefinitions MyCopyObject ARGS ((tDefinitions obj, tIdent new_id));
void DeclareUnits ARGS ((tTree t, tDefinitions father));
static rbool IsGeneric ARGS ((tDefinitions obj));
static void CheckProgram ARGS ((tTree t));
static tDefinitions MakeDummyObject ARGS ((tTree t, tDefinitions unit));
static rbool IsDummyRoutine ARGS ((tDefinitions obj, tTree new_decl));
static rbool IsDummyFunction ARGS ((tDefinitions obj, tTree new_decl));

void UseModule
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree renamings)
# else
(obj, renamings)
 register tDefinitions obj;
 register tTree renamings;
# endif
{
/* line 58 "UnitDefs.puma" */
  {
/* line 60 "UnitDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return;
yyL1:;

  if (obj->Kind == kModuleObject) {
/* line 63 "UnitDefs.puma" */
  {
/* line 65 "UnitDefs.puma" */
   CheckModuleDefinitions (obj);
/* line 66 "UnitDefs.puma" */
   EnterAllDeclarations (obj->ModuleObject.Declarations, renamings);
  }
   return;

  }
/* line 69 "UnitDefs.puma" */
   return;

;
}

void UseOnlyModule
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree names)
# else
(obj, names)
 register tDefinitions obj;
 register tTree names;
# endif
{
/* line 80 "UnitDefs.puma" */
  {
/* line 82 "UnitDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return;
yyL1:;

  if (obj->Kind == kModuleObject) {
/* line 85 "UnitDefs.puma" */
  {
/* line 87 "UnitDefs.puma" */
   CheckModuleDefinitions (obj);
/* line 88 "UnitDefs.puma" */
   EnterNamedDeclarations (obj->ModuleObject.Declarations, names);
  }
   return;

  }
/* line 91 "UnitDefs.puma" */
   return;

;
}

static void CheckModuleDefinitions
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kModuleObject) {
/* line 104 "UnitDefs.puma" */
  {
/* line 106 "UnitDefs.puma" */
   if (! ((obj->ModuleObject.decl == NoTree))) goto yyL1;
  }
   return;
yyL1:;

/* line 109 "UnitDefs.puma" */
 {
  tTree SaveUnit;
  {
/* line 111 "UnitDefs.puma" */
   if (! ((obj->ModuleObject.uses == 0))) goto yyL2;
  {
/* line 117 "UnitDefs.puma" */
   SaveUnit = GetCurrentUnit ();
/* line 119 "UnitDefs.puma" */
   NestCloseUnit (SaveUnit);
/* line 120 "UnitDefs.puma" */
   MakeUnitDefs (obj->ModuleObject.decl);
/* line 121 "UnitDefs.puma" */
   NestOpenUnit (SaveUnit);
  }
  }
   return;
 }
yyL2:;

/* line 124 "UnitDefs.puma" */
  {
/* line 126 "UnitDefs.puma" */
   if (! ((obj->ModuleObject.uses == 1))) goto yyL3;
  {
/* line 130 "UnitDefs.puma" */
   error_protocol ("cycle in USE of modules");
  }
  }
   return;
yyL3:;

  }
;
}

static void EnterAllDeclarations
# if defined __STDC__ | defined __cplusplus
(register tDefinitions all, register tTree renamings)
# else
(all, renamings)
 register tDefinitions all;
 register tTree renamings;
# endif
{
  if (all->Kind == kENTRY_LIST) {
/* line 141 "UnitDefs.puma" */
  {
/* line 143 "UnitDefs.puma" */
   EnterAllDeclarations (all->ENTRY_LIST.Next, renamings);
/* line 144 "UnitDefs.puma" */
   EnterRenameEntry (all->ENTRY_LIST.Elem, renamings, rfalse);
  }
   return;

  }
  if (all->Kind == kENTRY_EMPTY) {
/* line 147 "UnitDefs.puma" */
   return;

  }
/* line 150 "UnitDefs.puma" */
  {
/* line 151 "UnitDefs.puma" */
   failure_protocol (MODULE, "EnterAllDeclarations", NoTree);
  }
   return;

;
}

static void EnterNamedDeclarations
# if defined __STDC__ | defined __cplusplus
(register tDefinitions all, register tTree names)
# else
(all, names)
 register tDefinitions all;
 register tTree names;
# endif
{
 yyRecursion:
  if (names->Kind == kDECL_LIST) {
/* line 162 "UnitDefs.puma" */
  {
/* line 164 "UnitDefs.puma" */
   EnterNamedDeclarations (all, names->DECL_LIST.Elem);
/* line 165 "UnitDefs.puma" */
   names = names->DECL_LIST.Next;
   goto yyRecursion;
  }

  }
  if (names->Kind == kDECL_EMPTY) {
/* line 168 "UnitDefs.puma" */
   return;

  }
  if (names->Kind == kNAME_DECL) {
/* line 171 "UnitDefs.puma" */
  {
/* line 173 "UnitDefs.puma" */
   MakeVisible (GetDeclEntry (names->NAME_DECL.Ident, all), names->NAME_DECL.Ident, names->NAME_DECL.Ident);
  }
   return;

  }
  if (names->Kind == kRENAME_DECL) {
/* line 176 "UnitDefs.puma" */
  {
/* line 178 "UnitDefs.puma" */
   MakeVisible (GetDeclEntry (names->RENAME_DECL.oldname, all), names->RENAME_DECL.oldname, names->RENAME_DECL.Ident);
  }
   return;

  }
/* line 181 "UnitDefs.puma" */
  {
/* line 182 "UnitDefs.puma" */
   failure_protocol (MODULE, "EnterNamedDeclarations", names);
  }
   return;

;
}

static void MakeVisible
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tIdent old_id, register tIdent new_id)
# else
(obj, old_id, new_id)
 register tDefinitions obj;
 register tIdent old_id;
 register tIdent new_id;
# endif
{
/* line 193 "UnitDefs.puma" */

char string[60], msg[100];

/* line 197 "UnitDefs.puma" */
  {
/* line 199 "UnitDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 201 "UnitDefs.puma" */
   GetString (old_id, string);
/* line 202 "UnitDefs.puma" */
   sprintf (msg, "%s not available in the MODULE", string);
/* line 203 "UnitDefs.puma" */
   error_protocol (msg);
  }
  }
   return;
yyL1:;

/* line 206 "UnitDefs.puma" */
  {
/* line 208 "UnitDefs.puma" */
   if (! ((obj->Object.private == Private))) goto yyL2;
  {
/* line 209 "UnitDefs.puma" */
   GetString (old_id, string);
/* line 210 "UnitDefs.puma" */
   sprintf (msg, "%s is private in the MODULE", string);
/* line 211 "UnitDefs.puma" */
   error_protocol (msg);
  }
  }
   return;
yyL2:;

/* line 214 "UnitDefs.puma" */
  {
/* line 216 "UnitDefs.puma" */
   if (! ((old_id == new_id))) goto yyL3;
  {
/* line 217 "UnitDefs.puma" */
   InsertEntry (obj);
  }
  }
   return;
yyL3:;

/* line 220 "UnitDefs.puma" */
  {
/* line 222 "UnitDefs.puma" */
   InsertEntry (MyCopyObject (obj, new_id));
  }
   return;

;
}

static void EnterRenameEntry
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree renamings, register rbool done)
# else
(obj, renamings, done)
 register tDefinitions obj;
 register tTree renamings;
 register rbool done;
# endif
{
 yyRecursion:
/* line 237 "UnitDefs.puma" */
  {
/* line 239 "UnitDefs.puma" */
   if (! ((obj->Object.private == Private))) goto yyL1;
  }
   return;
yyL1:;

  if (renamings->Kind == kDECL_EMPTY) {
/* line 242 "UnitDefs.puma" */
  {
/* line 244 "UnitDefs.puma" */
   if (! ((! done))) goto yyL2;
  {
/* line 246 "UnitDefs.puma" */
   DoNotHideDummy (obj, GetLocalObject (obj->Object.Ident));
/* line 248 "UnitDefs.puma" */
   InsertEntry (obj);
  }
  }
   return;
yyL2:;

  }
  if (renamings->Kind == kDECL_LIST) {
  if (renamings->DECL_LIST.Elem->Kind == kRENAME_DECL) {
/* line 251 "UnitDefs.puma" */
  {
/* line 253 "UnitDefs.puma" */
   if (! ((obj->Object.Ident == renamings->DECL_LIST.Elem->RENAME_DECL.oldname))) goto yyL3;
  {
/* line 255 "UnitDefs.puma" */
   DoNotHideDummy (obj, GetLocalObject (obj->Object.Ident));
/* line 257 "UnitDefs.puma" */
   InsertEntry (MyCopyObject (obj, renamings->DECL_LIST.Elem->RENAME_DECL.Ident));
/* line 261 "UnitDefs.puma" */
   renamings = renamings->DECL_LIST.Next;
   done = rtrue;
   goto yyRecursion;
  }
  }
yyL3:;

  }
  }
;
}

static void DoNotHideDummy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions hide_obj)
# else
(obj, hide_obj)
 register tDefinitions obj;
 register tDefinitions hide_obj;
# endif
{
/* line 272 "UnitDefs.puma" */
  {
/* line 274 "UnitDefs.puma" */
   if (! ((hide_obj == NoObject))) goto yyL1;
  }
   return;
yyL1:;

/* line 277 "UnitDefs.puma" */
  {
/* line 279 "UnitDefs.puma" */
   if (! ((IsVarDummy (hide_obj)))) goto yyL2;
  {
/* line 281 "UnitDefs.puma" */
 error_protocol ("USE hides dummy argument");
     tree_protocol ("dummy = ", hide_obj->Object.decl);
     tree_protocol ("used  = ", obj->Object.decl);
   
  }
  }
   return;
yyL2:;

;
}

static tDefinitions MyCopyObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tIdent new_id)
# else
(obj, new_id)
 register tDefinitions obj;
 register tIdent new_id;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 297 "UnitDefs.puma" */
   return mVarObject (new_id, obj->VarObject.decl, obj->VarObject.private, obj->VarObject.in, obj->VarObject.Kind, obj->VarObject.arr_kind, obj->VarObject.target, obj->VarObject.trace, obj->VarObject.tree, obj->VarObject.dsp_kind, obj->VarObject.sequence, CopyTree (obj->VarObject.select), CopyTree (obj->VarObject.shadow), obj->VarObject.uses, obj->VarObject.Dist);

  }
  if (obj->Kind == kFuncObject) {
/* line 305 "UnitDefs.puma" */
   return mFuncObject (new_id, obj->FuncObject.decl, obj->FuncObject.private, obj->FuncObject.in, obj->FuncObject.Kind, obj->FuncObject.Declarations);

  }
  if (obj->Kind == kProcObject) {
/* line 310 "UnitDefs.puma" */
   return mProcObject (new_id, obj->ProcObject.decl, obj->ProcObject.private, obj->ProcObject.in, obj->ProcObject.Kind, obj->ProcObject.Declarations);

  }
  if (obj->Kind == kGenericObject) {
/* line 315 "UnitDefs.puma" */
   return mGenericObject (new_id, obj->GenericObject.decl, obj->GenericObject.private, obj->GenericObject.in, obj->GenericObject.Interfaces);

  }
/* line 320 "UnitDefs.puma" */
  {
/* line 322 "UnitDefs.puma" */
   error_protocol ("cannot use an entity");
/* line 323 "UnitDefs.puma" */
   obj_protocol ("this entity cannot be used", obj);
  }
   return obj;

}

void DeclareUnits
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions father)
# else
(t, father)
 register tTree t;
 register tDefinitions father;
# endif
{
/* line 346 "UnitDefs.puma" */
 
char s[MAX_ID_LENGTH], msg[MAX_LINE_LENGTH]; 

 yyRecursion:
  if (t->Kind == kUNIT_LIST) {
/* line 350 "UnitDefs.puma" */
  {
/* line 352 "UnitDefs.puma" */
   set_protocol_stmt (t->UNIT_LIST.Elem);
/* line 353 "UnitDefs.puma" */
   DeclareUnits (t->UNIT_LIST.Elem, father);
/* line 354 "UnitDefs.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kUNIT_EMPTY) {
/* line 357 "UnitDefs.puma" */
   return;

  }
  if (t->Kind == kMODULE_PROC_DECL) {
/* line 360 "UnitDefs.puma" */
  {
/* line 362 "UnitDefs.puma" */
   if (! ((father == NoObject))) goto yyL3;
  {
/* line 363 "UnitDefs.puma" */
   error_protocol ("MODULE PROCEDURE only in generic interfaces allowed");
  }
  }
   return;
yyL3:;

  if (father->Kind == kGenericObject) {
/* line 366 "UnitDefs.puma" */
 {
  tDefinitions obj;
  {
/* line 372 "UnitDefs.puma" */
   obj = GetGlobalObject (t->MODULE_PROC_DECL.Ident);
/* line 374 "UnitDefs.puma" */
 if (obj == NoObject)

        { GetString (t->MODULE_PROC_DECL.Ident, s);
          sprintf (msg, "MODULE PROCEDURE %s not available", s);
          error_protocol (msg);
        }

      else if (obj == GetLocalObject (t->MODULE_PROC_DECL.Ident))
        error_protocol ("name used twice in generic interface");
      else
        InsertEntry (obj);

     t->MODULE_PROC_DECL.Object = obj;
   
  }
   return;
 }

  }
/* line 390 "UnitDefs.puma" */
  {
/* line 392 "UnitDefs.puma" */
   error_protocol ("MODULE PROCEDURE only in generic interfaces allowed");
  }
   return;

  }
  if (Tree_IsType (t, kUNIT_NODE)) {
/* line 395 "UnitDefs.puma" */
 {
  tDefinitions old_obj;
  {
/* line 399 "UnitDefs.puma" */
   old_obj = GetDeclEntry (t->UNIT_NODE.Ident, GetCurrentScope ());
/* line 401 "UnitDefs.puma" */
   if (! ((old_obj != NoObject))) goto yyL6;
  {
/* line 403 "UnitDefs.puma" */
 if (IsDummyRoutine (old_obj, t) || IsDummyFunction (old_obj, t))

       { 

         old_obj = MakeDummyObject (t, father);

         ChangeEntry (t->UNIT_NODE.Ident, old_obj);

       }

      else

       { GetString (t->UNIT_NODE.Ident, s);
         sprintf (msg, "subprogram %s redefines something\n", s);
         simple_error_protocol (msg);
         obj_protocol ("old object was : ", old_obj);
   
         old_obj = NoObject;   

       }

     t->UNIT_NODE.Object = old_obj;

   
  }
  }
   return;
 }
yyL6:;

/* line 429 "UnitDefs.puma" */
  {
/* line 431 "UnitDefs.puma" */
   CheckProgram (t);
/* line 433 "UnitDefs.puma" */
 t->UNIT_NODE.Object = MakeNewObject (t, father);
     InsertEntry (t->UNIT_NODE.Object);
   
  }
   return;

  }
/* line 438 "UnitDefs.puma" */
  {
/* line 440 "UnitDefs.puma" */
   failure_protocol (MODULE, "DeclareUnits", t);
  }
   return;

;
}

static rbool IsGeneric
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 445 "UnitDefs.puma" */
  {
/* line 446 "UnitDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 447 "UnitDefs.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (obj->Kind == kGenericObject) {
/* line 450 "UnitDefs.puma" */
   return rtrue;

  }
  return rfalse;
}

static void CheckProgram
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 461 "UnitDefs.puma" */
 
char s[50], msg[156]; 

  if (t->Kind == kPROGRAM_DECL) {
/* line 465 "UnitDefs.puma" */
  {
/* line 467 "UnitDefs.puma" */
 if (GetCurrentScope () != GetUnitEntries ())

       { 

         tree_error_protocol ("PROGRAM not allowed here", t);
       }

     if (ProgramCounter > 1)

       { 

         GetString (t->PROGRAM_DECL.Ident, s);
         sprintf (msg, "PROGRAM %s : is %d. main program", s, ProgramCounter);
         simple_error_protocol (msg);
       }

     

     ProgramCounter = 1;

   
  }
   return;

  }
;
}

static tDefinitions MakeDummyObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions unit)
# else
(t, unit)
 register tTree t;
 register tDefinitions unit;
# endif
{
  if (t->Kind == kPROC_DECL) {
/* line 492 "UnitDefs.puma" */
   return mProcObject (t->PROC_DECL.Ident, t, Default, unit, DummyRoutine, mENTRY_EMPTY ());

  }
  if (t->Kind == kFUNC_DECL) {
/* line 498 "UnitDefs.puma" */
   return mFuncObject (t->FUNC_DECL.Ident, t, Default, unit, DummyRoutine, mENTRY_EMPTY ());

  }
/* line 504 "UnitDefs.puma" */
  {
/* line 506 "UnitDefs.puma" */
   failure_protocol (MODULE, "MakeDummyObject", t);
  }
   return NoObject;

}

static rbool IsDummyRoutine
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree new_decl)
# else
(obj, new_decl)
 register tDefinitions obj;
 register tTree new_decl;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (obj->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kDUMMY_TYPE) {
  if (new_decl->Kind == kPROC_DECL) {
/* line 519 "UnitDefs.puma" */
   return rtrue;

  }
  }
  }
  }
  return rfalse;
}

static rbool IsDummyFunction
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree new_decl)
# else
(obj, new_decl)
 register tDefinitions obj;
 register tTree new_decl;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (obj->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kDUMMY_TYPE) {
  if (new_decl->Kind == kFUNC_DECL) {
/* line 524 "UnitDefs.puma" */
   return rtrue;

  }
  }
  }
  }
  return rfalse;
}

void BeginUnitDefs ARGS ((void))
{
}

void CloseUnitDefs ARGS ((void))
{
}
