# include "Types.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 77 "Types.puma" */


# include "Idents.h"
# include "protocol.h"
# include "DefTable.h"
# include "Objects.h"
# include "TreeOps.h"
# include "protocol.h"
# include "Intrinsics.h"
# include "Expressions.h"

# define MODULE "Types"

# define ALIGN_SIZE 4

void OutType 
# if defined __STDC__ | defined __cplusplus
(char *Str, type_rec t)
# else
(Str, t)
 char *Str;
 type_rec t;
# endif

{ switch (t.type_kind) {

  case kDUMMY_TYPE     : sprintf (Str, "no_type", t.type_size); break;
  case kINTEGER_TYPE   : sprintf (Str, "INTEGER*%d", t.type_size); break;
  case kBOOLEAN_TYPE   : sprintf (Str, "LOGICAL*%d", t.type_size); break;
  case kREAL_TYPE      : sprintf (Str, "REAL*%d", t.type_size); break;
  case kCOMPLEX_TYPE   : sprintf (Str, "COMPLEX*%d", t.type_size); break;
  case kSTRING_TYPE    : if (t.type_size == -1)
                            sprintf (Str, "CHARACTER*(*)", t.type_size);
                           else
                            sprintf (Str, "CHARACTER*%d", t.type_size);
                         break;
  case kTYPE_ID        : sprintf (Str, "TYPE (..)"); break;
  default              : sprintf (Str, "<type_kind=%d,size=%d>",
                                  t.type_kind, t.type_size); 
  }

} /* OutType */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTypes.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Types_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Types, routine %s failed\n",
  yyFunction);
 Types_Exit ();
}

tTree GetObjectType ARGS ((tDefinitions obj));
tTree GetVariableType ARGS ((tTree var));
tTree GetBaseType ARGS ((tTree t));
static tTree VarType ARGS ((tDefinitions v));
tTree TreeType ARGS ((tTree var));
rbool IsDummyType ARGS ((tTree t));
rbool IsArrayType ARGS ((tTree type));
rbool IsDerivedType ARGS ((tTree type));
rbool IsStringType ARGS ((tTree type));
int TreeSize ARGS ((tTree t));
void GetExpType ARGS ((tTree exp, type_rec * yyP1));
static void GetExpListType ARGS ((tTree explist, type_rec * yyP2));
void GetParamType ARGS ((tTree param, type_rec * yyP3));
static void GetParamListType ARGS ((tTree explist, type_rec * yyP4));
void GetTypeRecord ARGS ((tTree type, type_rec * yyP5));
void GetOp1Type ARGS ((tTree op, type_rec type1, type_rec * yyP6));
void GetOp2Type ARGS ((tTree op, type_rec t1, type_rec t2, type_rec * yyP7));
rbool LegalAssignmentTypes ARGS ((type_rec t1, type_rec t2));
static rbool IsNumOp ARGS ((tTree op));
static rbool IsBoolOp ARGS ((tTree op));
static rbool IsRelOp ARGS ((tTree op));
static void GetIntrFuncType ARGS ((tIdent name, tTree params, type_rec * yyP8));
static void TypeCombination ARGS ((type_rec type1, type_rec type2, type_rec * yyP9));
rbool IsSubType ARGS ((type_rec type1, type_rec type2));
rbool SameTypeRecord ARGS ((type_rec type1, type_rec type2));
static rbool IsNumType ARGS ((type_rec type));
static rbool IsBoolType ARGS ((type_rec type));
static rbool IsStringTypeKind ARGS ((type_rec type));
static void GetIntegerType ARGS ((type_rec * yyP10));
static void GetRealType ARGS ((int size, type_rec * yyP11));
static void GetComplexType ARGS ((int size, type_rec * yyP12));
static void GetLogicalType ARGS ((type_rec * yyP13));
static void GetStringType ARGS ((type_rec * yyP14));
tTree GetTypeZero ARGS ((tTree texp));
rbool IsSameExpType ARGS ((tTree t1, tTree t2));
rbool IsSameBaseType ARGS ((tTree t1, tTree t2));
int GetObjectSize ARGS ((tDefinitions obj));
static int GetTypeSize ARGS ((tTree type));
static int DerivedTypeSize ARGS ((tDefinitions obj));
static int ComponentsSize ARGS ((tDefinitions components));
static int FormalSize ARGS ((tTree formals));
static int AddSizes ARGS ((int size1, int size2));
static int MultSizes ARGS ((int size1, int size2));
static int EvaluateSize ARGS ((tTree size));
int TargetTypeSize ARGS ((tTree t));
static void AlignedDerTypeSize ARGS ((tDefinitions type_obj, int * yyP16, int * yyP15));
static void AlignedComponentsSize ARGS ((tDefinitions components, int cur_size, int * yyP18, int * yyP17));
static void AddCompSize ARGS ((tDefinitions obj, tTree type, int cur_size, int * yyP20, int * yyP19));
static void MaxAlignment ARGS ((int align1, int align2, int * yyP21));
static int AlignedSize ARGS ((int size, int alignment));
static void AlignedTypeSize ARGS ((tTree type, int * yyP23, int * yyP22));
static void AlignedPtrSize ARGS ((int * yyP25, int * yyP24));
static void AlignedDefIntSize ARGS ((int * yyP27, int * yyP26));
static void AlignedDefAddrSize ARGS ((int * yyP29, int * yyP28));
static void RealAlign ARGS ((int size, int * yyP31, int * yyP30));
static void ComplexAlign ARGS ((int size, int * yyP33, int * yyP32));

tTree GetObjectType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
 yyRecursion:
/* line 139 "Types.puma" */
  {
/* line 140 "Types.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (obj->Kind == kVarObject) {
  if (obj->VarObject.decl->Kind == kVAR_DECL) {
/* line 144 "Types.puma" */
   return obj->VarObject.decl->VAR_DECL.VAL;

  }
  if (obj->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 149 "Types.puma" */
   return obj->VarObject.decl->VAR_PARAM_DECL.VAL;

  }
  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 154 "Types.puma" */
  {
/* line 156 "Types.puma" */
   if (! ((obj->FuncObject.decl->FUNC_DECL.RESULT_ID == DefaultId ()))) goto yyL4;
  }
   return obj->FuncObject.decl->FUNC_DECL.RESULT_TYPE;
yyL4:;

/* line 161 "Types.puma" */
   obj = GetFuncVarObj (obj);
   goto yyRecursion;

  }
  if (obj->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 166 "Types.puma" */
   return obj->FuncObject.decl->STMT_FUNC_DECL.RESULT_TYPE;

  }
  }
/* line 170 "Types.puma" */
  {
/* line 171 "Types.puma" */
   obj_protocol ("GetObjectType - this object has no type : ", obj);
  }
   return NoTree;

}

tTree GetVariableType
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kVAR_OBJ) {
/* line 181 "Types.puma" */
   return GetObjectType (var->VAR_OBJ.Object);

  }
  if (var->Kind == kUSED_VAR) {
/* line 185 "Types.puma" */
   var = var->USED_VAR.VARNAME;
   goto yyRecursion;

  }
  if (var->Kind == kLOOP_VAR) {
/* line 189 "Types.puma" */
   var = var->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 193 "Types.puma" */
   return GetBaseType (GetVariableType (var->INDEXED_VAR.IND_VAR));

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 197 "Types.puma" */
   return GetBaseType (GetVariableType (var->SUBSTRING_VAR.IND_VAR));

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 201 "Types.puma" */
   return GetObjectType (var->SELECTED_VAR.SELECTOR->REC_COMP.Object);

  }
/* line 205 "Types.puma" */
  {
/* line 206 "Types.puma" */
   failure_protocol (MODULE, "GetVariableType", var);
  }
   return NoTree;

}

tTree GetBaseType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
/* line 216 "Types.puma" */
  {
/* line 217 "Types.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return t;
yyL1:;


  switch (t->Kind) {
  case kDUMMY_TYPE:
/* line 221 "Types.puma" */
   return t;

  case kINTEGER_TYPE:
/* line 225 "Types.puma" */
   return t;

  case kREAL_TYPE:
/* line 229 "Types.puma" */
   return t;

  case kBOOLEAN_TYPE:
/* line 233 "Types.puma" */
   return t;

  case kCOMPLEX_TYPE:
/* line 237 "Types.puma" */
   return t;

  case kSTRING_TYPE:
/* line 241 "Types.puma" */
   return t;

  case kTYPE_ID:
/* line 245 "Types.puma" */
   return t;

  case kARRAY_TYPE:
/* line 249 "Types.puma" */
   t = t->ARRAY_TYPE.ARRAY_COMP_TYPE;
   goto yyRecursion;

  }

/* line 253 "Types.puma" */
  {
/* line 254 "Types.puma" */
   failure_protocol (MODULE, "GetBaseType", t);
  }
   return NoTree;

}

static tTree VarType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 264 "Types.puma" */
   return GetBaseType (GetObjectType (v));

}

tTree TreeType
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 270 "Types.puma" */
   return GetBaseType (GetVariableType (var));

}

rbool IsDummyType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kDUMMY_TYPE) {
/* line 282 "Types.puma" */
   return rtrue;

  }
  if (t->Kind == kALIGN_TYPE) {
/* line 285 "Types.puma" */
   return rtrue;

  }
  if (t->Kind == kARRAY_TYPE) {
/* line 288 "Types.puma" */
  {
/* line 289 "Types.puma" */
   if (! ((IsDummyType (t->ARRAY_TYPE.ARRAY_COMP_TYPE)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

rbool IsArrayType
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
/* line 300 "Types.puma" */
  {
/* line 301 "Types.puma" */
   if (! ((type == NoTree))) goto yyL1;
  {
/* line 302 "Types.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (type->Kind == kARRAY_TYPE) {
/* line 305 "Types.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsDerivedType
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
/* line 316 "Types.puma" */
  {
/* line 317 "Types.puma" */
   if (! ((type == NoTree))) goto yyL1;
  {
/* line 318 "Types.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (type->Kind == kTYPE_ID) {
/* line 321 "Types.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsStringType
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
/* line 332 "Types.puma" */
  {
/* line 333 "Types.puma" */
   if (! ((type == NoTree))) goto yyL1;
  {
/* line 334 "Types.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (type->Kind == kSTRING_TYPE) {
/* line 337 "Types.puma" */
   return rtrue;

  }
  return rfalse;
}

int TreeSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (Tree_IsType (t, kTYPE_NODE)) {
/* line 348 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 350 "Types.puma" */
   GetTypeRecord (t, & yyV1);
/* line 352 "Types.puma" */
 if (yyV1.type_kind == kTYPE_ID)
        yyV1.type_size = DerivedTypeSize ((tObject) yyV1.type_size);
    
  }
   return yyV1 . type_size;
 }

  }
/* line 359 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 361 "Types.puma" */
   GetExpType (t, & yyV1);
/* line 363 "Types.puma" */
 if (yyV1.type_kind == kTYPE_ID)
        yyV1.type_size = DerivedTypeSize ((tObject) yyV1.type_size);
    
  }
   return yyV1 . type_size;
 }

}

void GetExpType
# if defined __STDC__ | defined __cplusplus
(register tTree exp, type_rec * yyP1)
# else
(exp, yyP1)
 register tTree exp;
 type_rec * yyP1;
# endif
{

  switch (exp->Kind) {
  case kINDEXED_VAR:
/* line 387 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 389 "Types.puma" */
   GetExpType (exp->INDEXED_VAR.IND_VAR, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kSELECTED_VAR:
/* line 392 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 394 "Types.puma" */
   GetTypeRecord (VarType (exp->SELECTED_VAR.SELECTOR->REC_COMP.Object), & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kSUBSTRING_VAR:
/* line 397 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 399 "Types.puma" */
   GetExpType (exp->SUBSTRING_VAR.IND_VAR, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kUSED_VAR:
/* line 402 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 404 "Types.puma" */
   GetTypeRecord (TreeType (exp), & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kLOOP_VAR:
/* line 407 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 409 "Types.puma" */
   GetTypeRecord (TreeType (exp), & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kVAR_EXP:
/* line 412 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 414 "Types.puma" */
   GetExpType (exp->VAR_EXP.V, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kPERM_EXP:
/* line 417 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 419 "Types.puma" */
   GetExpType (exp->PERM_EXP.VAL, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kADDR:
/* line 422 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 424 "Types.puma" */
   GetExpType (exp->ADDR.E, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kVAR_PARAM:
/* line 427 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 429 "Types.puma" */
   GetExpType (exp->VAR_PARAM.V, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kBT_PARAM:
  case kVALUE_PARAM:
  case kNAMED_PARAM:
  case kPROC_PARAM:
  case kFUNC_PARAM:
  case kFORMAT_PARAM:
  case kRETURN_PARAM:
  case kNO_PARAM:
/* line 432 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 434 "Types.puma" */
   GetParamType (exp, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kDO_EXP:
/* line 437 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 439 "Types.puma" */
   GetExpListType (exp->DO_EXP.BODY, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kARRAY_EXP:
/* line 442 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 444 "Types.puma" */
   GetExpListType (exp->ARRAY_EXP.ELEMENTS, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kSLICE_EXP:
/* line 447 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 449 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kOP1_EXP:
/* line 452 "Types.puma" */
 {
  type_rec yyV1;
  type_rec yyV2;
  {
/* line 454 "Types.puma" */
   GetExpType (exp->OP1_EXP.OPND, & yyV1);
/* line 455 "Types.puma" */
   GetOp1Type (exp->OP1_EXP.EXP_OP1, yyV1, & yyV2);
  }
   * yyP1 = yyV2;
   return;
 }

  case kOP_EXP:
/* line 458 "Types.puma" */
 {
  type_rec yyV1;
  type_rec yyV2;
  type_rec yyV3;
  {
/* line 460 "Types.puma" */
   GetExpType (exp->OP_EXP.OPND1, & yyV1);
/* line 461 "Types.puma" */
   GetExpType (exp->OP_EXP.OPND2, & yyV2);
/* line 462 "Types.puma" */
   GetOp2Type (exp->OP_EXP.EXP_OP, yyV1, yyV2, & yyV3);
  }
   * yyP1 = yyV3;
   return;
 }

  case kFUNC_CALL_EXP:
/* line 465 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 467 "Types.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL16;
  {
/* line 469 "Types.puma" */
   GetIntrFuncType (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1);
  }
  }
   * yyP1 = yyV1;
   return;
 }
yyL16:;

/* line 472 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 476 "Types.puma" */
   GetTypeRecord (VarType (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object), & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kBOUND_EXP:
/* line 479 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 481 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kRANK_EXP:
/* line 484 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 486 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  case kCONST_EXP:
  if (exp->CONST_EXP.C->Kind == kINT_CONSTANT) {
/* line 489 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 491 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (exp->CONST_EXP.C->Kind == kBOOL_CONSTANT) {
/* line 494 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 496 "Types.puma" */
   GetLogicalType (& yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (exp->CONST_EXP.C->Kind == kREAL_CONSTANT) {
/* line 499 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 501 "Types.puma" */
   GetRealType (exp->CONST_EXP.C->REAL_CONSTANT.kind, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (exp->CONST_EXP.C->Kind == kCOMPLEX_CONSTANT) {
/* line 504 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 506 "Types.puma" */
   GetComplexType (2 * default_real_size, & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
  if (exp->CONST_EXP.C->Kind == kSTRING_CONSTANT) {
/* line 509 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 511 "Types.puma" */
   GetStringType (& yyV1);
/* line 512 "Types.puma" */
 yyV1.type_size = LengthSt (exp->CONST_EXP.C->STRING_CONSTANT.value);  
  }
   * yyP1 = yyV1;
   return;
 }

  }
  break;
  case kTYPE_EXP:
/* line 515 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 519 "Types.puma" */
 rtype.type_kind = kTYPE_ID;
     rtype.type_size = (int) exp->TYPE_EXP.ID->TYPE_OBJ.Object;   
   
  }
   * yyP1 = rtype;
   return;
 }

  case kDUMMY_EXP:
/* line 524 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 528 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP1 = rtype;
   return;
 }

  }

/* line 533 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 535 "Types.puma" */
   GetRealType (default_real_size, & yyV1);
/* line 537 "Types.puma" */
   failure_protocol (MODULE, "GetExpType", exp);
  }
   * yyP1 = yyV1;
   return;
 }

;
}

static void GetExpListType
# if defined __STDC__ | defined __cplusplus
(register tTree explist, type_rec * yyP2)
# else
(explist, yyP2)
 register tTree explist;
 type_rec * yyP2;
# endif
{
  if (explist->Kind == kBTE_EMPTY) {
/* line 556 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 560 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP2 = rtype;
   return;
 }

  }
  if (explist->Kind == kBTE_LIST) {
  if (explist->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 565 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 567 "Types.puma" */
   GetExpType (explist->BTE_LIST.Elem, & yyV1);
  }
   * yyP2 = yyV1;
   return;
 }

  }
/* line 570 "Types.puma" */
 {
  type_rec yyV1;
  type_rec yyV2;
  type_rec yyV3;
  {
/* line 572 "Types.puma" */
   GetExpType (explist->BTE_LIST.Elem, & yyV1);
/* line 573 "Types.puma" */
   GetExpListType (explist->BTE_LIST.Next, & yyV2);
/* line 575 "Types.puma" */
   TypeCombination (yyV1, yyV2, & yyV3);
  }
   * yyP2 = yyV3;
   return;
 }

  }
/* line 578 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 580 "Types.puma" */
   failure_protocol (MODULE, "GetExpListType", explist);
/* line 581 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP2 = yyV1;
   return;
 }

;
}

void GetParamType
# if defined __STDC__ | defined __cplusplus
(register tTree param, type_rec * yyP3)
# else
(param, yyP3)
 register tTree param;
 type_rec * yyP3;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
/* line 592 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 594 "Types.puma" */
   GetExpType (param->VAR_PARAM.V->ADDR.E, & yyV1);
  }
   * yyP3 = yyV1;
   return;
 }

  }
/* line 597 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 599 "Types.puma" */
   GetExpType (param->VAR_PARAM.V, & yyV1);
  }
   * yyP3 = yyV1;
   return;
 }

  }
  if (param->Kind == kNO_PARAM) {
/* line 602 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 606 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP3 = rtype;
   return;
 }

  }
  if (param->Kind == kFUNC_PARAM) {
/* line 611 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 615 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP3 = rtype;
   return;
 }

  }
  if (param->Kind == kPROC_PARAM) {
/* line 620 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 624 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP3 = rtype;
   return;
 }

  }
  if (param->Kind == kRETURN_PARAM) {
/* line 629 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 631 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP3 = yyV1;
   return;
 }

  }
/* line 634 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 638 "Types.puma" */
   failure_protocol (MODULE, "GetParamType", param);
  }
   * yyP3 = rtype;
   return;
 }

;
}

static void GetParamListType
# if defined __STDC__ | defined __cplusplus
(register tTree explist, type_rec * yyP4)
# else
(explist, yyP4)
 register tTree explist;
 type_rec * yyP4;
# endif
{
  if (explist->Kind == kBTP_EMPTY) {
/* line 651 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 655 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP4 = rtype;
   return;
 }

  }
  if (explist->Kind == kBTP_LIST) {
  if (explist->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 660 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 662 "Types.puma" */
   GetParamType (explist->BTP_LIST.Elem, & yyV1);
  }
   * yyP4 = yyV1;
   return;
 }

  }
/* line 665 "Types.puma" */
 {
  type_rec yyV1;
  type_rec yyV2;
  type_rec yyV3;
  {
/* line 667 "Types.puma" */
   GetParamType (explist->BTP_LIST.Elem, & yyV1);
/* line 668 "Types.puma" */
   GetParamListType (explist->BTP_LIST.Next, & yyV2);
/* line 669 "Types.puma" */
   TypeCombination (yyV1, yyV2, & yyV3);
  }
   * yyP4 = yyV3;
   return;
 }

  }
/* line 672 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 674 "Types.puma" */
   failure_protocol (MODULE, "GetParamListType", explist);
/* line 675 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP4 = yyV1;
   return;
 }

;
}

void GetTypeRecord
# if defined __STDC__ | defined __cplusplus
(register tTree type, type_rec * yyP5)
# else
(type, yyP5)
 register tTree type;
 type_rec * yyP5;
# endif
{
/* line 688 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 690 "Types.puma" */
   if (! ((type == NoTree))) goto yyL1;
  {
/* line 694 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
  }
   * yyP5 = rtype;
   return;
 }
yyL1:;


  switch (type->Kind) {
  case kINTEGER_TYPE:
/* line 699 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 703 "Types.puma" */
 rtype.type_kind = kINTEGER_TYPE;
     rtype.type_size = EvaluateSize (type->INTEGER_TYPE.SIZE);
   
  }
   * yyP5 = rtype;
   return;
 }

  case kREAL_TYPE:
/* line 708 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 712 "Types.puma" */
 rtype.type_kind = kREAL_TYPE;
     rtype.type_size = EvaluateSize (type->REAL_TYPE.SIZE);
   
  }
   * yyP5 = rtype;
   return;
 }

  case kCOMPLEX_TYPE:
/* line 717 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 721 "Types.puma" */
 rtype.type_kind = kCOMPLEX_TYPE;
     rtype.type_size = EvaluateSize (type->COMPLEX_TYPE.SIZE);
   
  }
   * yyP5 = rtype;
   return;
 }

  case kBOOLEAN_TYPE:
/* line 726 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 730 "Types.puma" */
 rtype.type_kind = kBOOLEAN_TYPE;
     rtype.type_size = EvaluateSize (type->BOOLEAN_TYPE.SIZE);
   
  }
   * yyP5 = rtype;
   return;
 }

  case kSTRING_TYPE:
/* line 735 "Types.puma" */
 {
  type_rec rtype;
  rbool found;
  int val;
  {
/* line 741 "Types.puma" */
   GetIntConstValue (type->STRING_TYPE.LENGTH, & found, & val);
/* line 743 "Types.puma" */
 rtype.type_kind = kSTRING_TYPE;
     rtype.type_size = -1;           
     if (found)
        rtype.type_size = val;
   
  }
   * yyP5 = rtype;
   return;
 }

  case kDUMMY_TYPE:
/* line 750 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 754 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP5 = rtype;
   return;
 }

  case kTYPE_ID:
/* line 759 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 763 "Types.puma" */
 rtype.type_kind = kTYPE_ID;
     rtype.type_size = (int) type->TYPE_ID.ID->TYPE_OBJ.Object;
   
  }
   * yyP5 = rtype;
   return;
 }

  }

/* line 768 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 771 "Types.puma" */
   error_protocol ("could not get the type");
/* line 772 "Types.puma" */
   tree_protocol ("this is the unknown type : ", type);
  }
   * yyP5 = rtype;
   return;
 }

;
}

void GetOp1Type
# if defined __STDC__ | defined __cplusplus
(register tTree op, type_rec type1, type_rec * yyP6)
# else
(op, type1, yyP6)
 register tTree op;
 type_rec type1;
 type_rec * yyP6;
# endif
{
  if (op->Kind == kOP1_NOT) {
/* line 783 "Types.puma" */
  {
/* line 785 "Types.puma" */
   if (! ((IsBoolType (type1)))) goto yyL1;
  }
   * yyP6 = type1;
   return;
yyL1:;

  }
  if (op->Kind == kOP1_SIGN) {
/* line 788 "Types.puma" */
  {
/* line 790 "Types.puma" */
   if (! ((IsNumType (type1)))) goto yyL2;
  }
   * yyP6 = type1;
   return;
yyL2:;

  }
  if (op->Kind == kOP1_PSIGN) {
/* line 793 "Types.puma" */
  {
/* line 795 "Types.puma" */
   if (! ((IsNumType (type1)))) goto yyL3;
  }
   * yyP6 = type1;
   return;
yyL3:;

  }
/* line 798 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 802 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
    rtype.type_size = 0;
  
  }
   * yyP6 = rtype;
   return;
 }

;
}

void GetOp2Type
# if defined __STDC__ | defined __cplusplus
(register tTree op, type_rec t1, type_rec t2, type_rec * yyP7)
# else
(op, t1, t2, yyP7)
 register tTree op;
 type_rec t1;
 type_rec t2;
 type_rec * yyP7;
# endif
{
/* line 815 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 817 "Types.puma" */
   if (! ((IsNumOp (op)))) goto yyL1;
  {
/* line 819 "Types.puma" */
   if (! ((IsNumType (t1)))) goto yyL1;
  {
/* line 820 "Types.puma" */
   if (! ((IsNumType (t2)))) goto yyL1;
  {
/* line 822 "Types.puma" */
   TypeCombination (t1, t2, & yyV1);
  }
  }
  }
  }
   * yyP7 = yyV1;
   return;
 }
yyL1:;

/* line 825 "Types.puma" */
  {
/* line 827 "Types.puma" */
   if (! ((IsBoolOp (op)))) goto yyL2;
  {
/* line 829 "Types.puma" */
   if (! ((IsBoolType (t1)))) goto yyL2;
  {
/* line 830 "Types.puma" */
   if (! ((IsBoolType (t2)))) goto yyL2;
  }
  }
  }
   * yyP7 = t1;
   return;
yyL2:;

/* line 833 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 835 "Types.puma" */
   if (! ((IsRelOp (op)))) goto yyL3;
  {
/* line 837 "Types.puma" */
   if (! ((IsNumType (t1)))) goto yyL3;
  {
/* line 838 "Types.puma" */
   if (! ((IsNumType (t2)))) goto yyL3;
  {
/* line 840 "Types.puma" */
   GetLogicalType (& yyV1);
  }
  }
  }
  }
   * yyP7 = yyV1;
   return;
 }
yyL3:;

/* line 843 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 845 "Types.puma" */
   if (! ((IsRelOp (op)))) goto yyL4;
  {
/* line 847 "Types.puma" */
   if (! ((IsStringTypeKind (t1)))) goto yyL4;
  {
/* line 848 "Types.puma" */
   if (! ((IsStringTypeKind (t2)))) goto yyL4;
  {
/* line 850 "Types.puma" */
   GetLogicalType (& yyV1);
  }
  }
  }
  }
   * yyP7 = yyV1;
   return;
 }
yyL4:;

  if (op->Kind == kOP_CONCAT) {
/* line 853 "Types.puma" */
  {
/* line 855 "Types.puma" */
   if (! ((IsStringTypeKind (t1)))) goto yyL5;
  {
/* line 856 "Types.puma" */
   if (! ((IsStringTypeKind (t2)))) goto yyL5;
  {
/* line 858 "Types.puma" */
 if ((t2.type_size == -1) || (t1.type_size == -1))
       t1.type_size = -1;
     else
       t1.type_size = t1.type_size + t2.type_size;
  
  }
  }
  }
   * yyP7 = t1;
   return;
yyL5:;

  }
/* line 865 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 869 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
    rtype.type_size = 0;
  
  }
   * yyP7 = rtype;
   return;
 }

;
}

rbool LegalAssignmentTypes
# if defined __STDC__ | defined __cplusplus
(type_rec t1, type_rec t2)
# else
(t1, t2)
 type_rec t1;
 type_rec t2;
# endif
{
/* line 882 "Types.puma" */
  {
/* line 884 "Types.puma" */
   if (! ((IsNumType (t1)))) goto yyL1;
  {
/* line 885 "Types.puma" */
   if (! ((IsNumType (t2)))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 888 "Types.puma" */
  {
/* line 890 "Types.puma" */
   if (! ((IsBoolType (t1)))) goto yyL2;
  {
/* line 891 "Types.puma" */
   if (! ((IsBoolType (t2)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 894 "Types.puma" */
  {
/* line 896 "Types.puma" */
   if (! ((IsStringTypeKind (t1)))) goto yyL3;
  {
/* line 897 "Types.puma" */
   if (! ((IsStringTypeKind (t2)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

/* line 900 "Types.puma" */
  {
/* line 902 "Types.puma" */
   if (! ((t1 . type_kind == kTYPE_ID))) goto yyL4;
  {
/* line 903 "Types.puma" */
   if (! ((t2 . type_kind == kTYPE_ID))) goto yyL4;
  {
/* line 904 "Types.puma" */
   if (! ((t1 . type_size == t2 . type_size))) goto yyL4;
  }
  }
  }
   return rtrue;
yyL4:;

  return rfalse;
}

static rbool IsNumOp
# if defined __STDC__ | defined __cplusplus
(register tTree op)
# else
(op)
 register tTree op;
# endif
{
  if (op->Kind == kOP_PLUS) {
/* line 917 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_MINUS) {
/* line 918 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_TIMES) {
/* line 919 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_DIVIDE) {
/* line 920 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_EXPO) {
/* line 921 "Types.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsBoolOp
# if defined __STDC__ | defined __cplusplus
(register tTree op)
# else
(op)
 register tTree op;
# endif
{
  if (op->Kind == kOP_EQV) {
/* line 933 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_NEQV) {
/* line 934 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_OR) {
/* line 935 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_XOR) {
/* line 936 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_AND) {
/* line 937 "Types.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool IsRelOp
# if defined __STDC__ | defined __cplusplus
(register tTree op)
# else
(op)
 register tTree op;
# endif
{
  if (op->Kind == kOP_EQ) {
/* line 949 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_LE) {
/* line 950 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_GE) {
/* line 951 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_NE) {
/* line 952 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_LT) {
/* line 953 "Types.puma" */
   return rtrue;

  }
  if (op->Kind == kOP_GT) {
/* line 954 "Types.puma" */
   return rtrue;

  }
  return rfalse;
}

static void GetIntrFuncType
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree params, type_rec * yyP8)
# else
(name, params, yyP8)
 register tIdent name;
 register tTree params;
 type_rec * yyP8;
# endif
{
/* line 974 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 976 "Types.puma" */
   if (! (((name == IsIdent ("MAX")) || (name == IsIdent ("MIN"))))) goto yyL1;
  {
/* line 977 "Types.puma" */
   GetParamListType (params, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL1:;

/* line 980 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 982 "Types.puma" */
   if (! (((name == IsIdent ("MAX0")) || (name == IsIdent ("MIN0"))))) goto yyL2;
  {
/* line 983 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL2:;

/* line 986 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 988 "Types.puma" */
   if (! (((name == IsIdent ("AMAX1")) || (name == IsIdent ("AMIN1"))))) goto yyL3;
  {
/* line 989 "Types.puma" */
   GetRealType (default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL3:;

/* line 992 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 994 "Types.puma" */
   if (! (((name == IsIdent ("DMAX1", 5)) || (name == IsIdent ("DMIN1"))))) goto yyL4;
  {
/* line 995 "Types.puma" */
   GetRealType (2 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL4:;

/* line 998 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1000 "Types.puma" */
   if (! (((name == IsIdent ("AMAX0")) || (name == IsIdent ("AMAX0"))))) goto yyL5;
  {
/* line 1001 "Types.puma" */
   GetRealType (default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL5:;

/* line 1004 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1006 "Types.puma" */
   if (! (((name == IsIdent ("MAX1")) || (name == IsIdent ("MIN1"))))) goto yyL6;
  {
/* line 1007 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL6:;

/* line 1037 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1039 "Types.puma" */
   if (! (((name == IsIdent ("AINT")) || (name == IsIdent ("ANINT")) || (name == IsIdent ("CONJG")) || (name == IsIdent ("DIM")) || (name == IsIdent ("MOD")) || (name == IsIdent ("SIGN"))))) goto yyL7;
  {
/* line 1047 "Types.puma" */
   GetParamListType (params, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL7:;

/* line 1050 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1052 "Types.puma" */
   if (! (((name == IsIdent ("IDIM")) || (name == IsIdent ("ISIGN")) || (name == IsIdent ("MOD"))))) goto yyL8;
  {
/* line 1056 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL8:;

/* line 1059 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1061 "Types.puma" */
   if (! (((name == IsIdent ("AINT")) || (name == IsIdent ("ANINT")) || (name == IsIdent ("DIM")) || (name == IsIdent ("AMOD")) || (name == IsIdent ("SIGN"))))) goto yyL9;
  {
/* line 1068 "Types.puma" */
   GetRealType (default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL9:;

/* line 1071 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1073 "Types.puma" */
   if (! (((name == IsIdent ("DINT")) || (name == IsIdent ("DNINT")) || (name == IsIdent ("DDIM")) || (name == IsIdent ("DMOD")) || (name == IsIdent ("DSIGN"))))) goto yyL10;
  {
/* line 1080 "Types.puma" */
   GetRealType (2 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL10:;

/* line 1083 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1085 "Types.puma" */
   if (! ((name == IsIdent ("DCONJG")))) goto yyL11;
  {
/* line 1087 "Types.puma" */
   GetComplexType (4 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL11:;

/* line 1148 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1150 "Types.puma" */
   if (! ((GetIntrinsicKind (GetIntrinsicObject (name)) == kMATHEMATICAL))) goto yyL12;
  {
/* line 1152 "Types.puma" */
   GetParamListType (params, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL12:;

  if (params->Kind == kBTP_LIST) {
/* line 1189 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1191 "Types.puma" */
   if (! ((name == IsIdent ("ABS")))) goto yyL13;
  {
/* line 1193 "Types.puma" */
   GetParamType (params->BTP_LIST.Elem, & yyV1);
/* line 1197 "Types.puma" */
 if (yyV1.type_kind == kCOMPLEX_TYPE)

       { yyV1.type_kind = kREAL_TYPE;
         yyV1.type_size = yyV1.type_size / 2;
       }
   
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL13:;

  }
/* line 1205 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1207 "Types.puma" */
   if (! (((name == IsIdent ("IABS")) || (name == IsIdent ("INT")) || (name == IsIdent ("IFIX")) || (name == IsIdent ("IDINT")) || (name == IsIdent ("NINT")) || (name == IsIdent ("IDNINT"))))) goto yyL14;
  {
/* line 1215 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL14:;

/* line 1218 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1220 "Types.puma" */
   if (! (((name == IsIdent ("ABS")) || (name == IsIdent ("CABS")) || (name == IsIdent ("AIMAG")) || (name == IsIdent ("REAL")) || (name == IsIdent ("FLOAT")) || (name == IsIdent ("SNGL"))))) goto yyL15;
  {
/* line 1228 "Types.puma" */
   GetRealType (default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL15:;

/* line 1231 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1233 "Types.puma" */
   if (! (((name == IsIdent ("DABS")) || (name == IsIdent ("CDABS")) || (name == IsIdent ("DIMAG")) || (name == IsIdent ("DBLE")) || (name == IsIdent ("DPROD"))))) goto yyL16;
  {
/* line 1240 "Types.puma" */
   GetRealType (2 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL16:;

  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
/* line 1243 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1245 "Types.puma" */
   if (! ((name == IsIdent ("CMPLX")))) goto yyL17;
  {
/* line 1246 "Types.puma" */
   GetComplexType (2 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL17:;

  }
/* line 1249 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1251 "Types.puma" */
   if (! ((name == IsIdent ("CMPLX")))) goto yyL18;
  {
/* line 1252 "Types.puma" */
   GetParamType (params->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL18:;

  }
  }
  }
/* line 1255 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1257 "Types.puma" */
   if (! ((name == IsIdent ("DCMPLX")))) goto yyL19;
  {
/* line 1258 "Types.puma" */
   GetComplexType (4 * default_real_size, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL19:;

/* line 1280 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1282 "Types.puma" */
   if (! (((name == IsIdent ("CHAR")) || (name == IsIdent ("ACHAR"))))) goto yyL20;
  {
/* line 1283 "Types.puma" */
   GetStringType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL20:;

/* line 1286 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1288 "Types.puma" */
   if (! (((name == IsIdent ("LGE")) || (name == IsIdent ("LGT")) || (name == IsIdent ("LLE")) || (name == IsIdent ("LLT"))))) goto yyL21;
  {
/* line 1293 "Types.puma" */
   GetLogicalType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL21:;

/* line 1296 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1298 "Types.puma" */
   if (! (((name == IsIdent ("ICHAR")) || (name == IsIdent ("IACHAR")) || (name == IsIdent ("LEN")) || (name == IsIdent ("LEN_TRIM")) || (name == IsIdent ("VERIFY")) || (name == IsIdent ("INDEX"))))) goto yyL22;
  {
/* line 1305 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL22:;

/* line 1323 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1325 "Types.puma" */
   if (! ((name == IsIdent ("EXPONENT")))) goto yyL23;
  {
/* line 1327 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL23:;

/* line 1340 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1342 "Types.puma" */
   if (! ((name == IsIdent ("BTEST")))) goto yyL24;
  {
/* line 1343 "Types.puma" */
   GetLogicalType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL24:;

/* line 1352 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1354 "Types.puma" */
   if (! ((name == IsIdent ("TRIM")))) goto yyL25;
  {
/* line 1355 "Types.puma" */
   GetStringType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL25:;

  if (params->Kind == kBTP_LIST) {
/* line 1364 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1366 "Types.puma" */
   if (! ((IntrFuncElemental (name)))) goto yyL26;
  {
/* line 1367 "Types.puma" */
   GetParamListType (params, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL26:;

/* line 1376 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1378 "Types.puma" */
   if (! ((name == IsIdent ("COUNT")))) goto yyL27;
  {
/* line 1379 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL27:;

/* line 1382 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1384 "Types.puma" */
   if (! ((IntrFuncRed (name)))) goto yyL28;
  {
/* line 1385 "Types.puma" */
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL28:;

  if (params->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 1388 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1390 "Types.puma" */
   if (! ((name == IsIdent ("COUNT_PREFIX")))) goto yyL29;
  {
/* line 1391 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL29:;

/* line 1394 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1396 "Types.puma" */
   if (! ((name == IsIdent ("COUNT_SUFFIX")))) goto yyL30;
  {
/* line 1397 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL30:;

/* line 1400 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1402 "Types.puma" */
   if (! ((IntrFuncScatter (name)))) goto yyL31;
  {
/* line 1403 "Types.puma" */
   GetParamType (params->BTP_LIST.Next->BTP_LIST.Elem, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL31:;

  }
/* line 1406 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1408 "Types.puma" */
   if (! ((IntrFuncScan (name)))) goto yyL32;
  {
/* line 1409 "Types.puma" */
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL32:;

  }
/* line 1412 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1413 "Types.puma" */
   if (! ((IntrFuncLocRed (name)))) goto yyL33;
  {
/* line 1414 "Types.puma" */
   GetIntegerType (& yyV1);
  }
  }
   * yyP8 = yyV1;
   return;
 }
yyL33:;

 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GRADE_DOWN"))) {
/* line 1417 "Types.puma" */
  {
/* line 1418 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GRADE_UP"))) {
/* line 1421 "Types.puma" */
  {
/* line 1422 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SORT_UP"))) {
  if (params->Kind == kBTP_LIST) {
/* line 1425 "Types.puma" */
  {
/* line 1426 "Types.puma" */
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SORT_DOWN"))) {
  if (params->Kind == kBTP_LIST) {
/* line 1429 "Types.puma" */
  {
/* line 1430 "Types.puma" */
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SELECTED_INT_KIND"))) {
/* line 1433 "Types.puma" */
  {
/* line 1434 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SELECTED_REAL_KIND"))) {
/* line 1437 "Types.puma" */
  {
/* line 1438 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("LBOUND"))) {
/* line 1441 "Types.puma" */
  {
/* line 1442 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("UBOUND"))) {
/* line 1445 "Types.puma" */
  {
/* line 1446 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SIZE"))) {
/* line 1449 "Types.puma" */
  {
/* line 1450 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("SHAPE"))) {
/* line 1453 "Types.puma" */
  {
/* line 1454 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("PROCESSORS_SHAPE"))) {
/* line 1457 "Types.puma" */
  {
/* line 1458 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("ACTIVE_PROCS_SHAPE"))) {
/* line 1461 "Types.puma" */
  {
/* line 1462 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("ALLOCATED"))) {
/* line 1465 "Types.puma" */
  {
/* line 1466 "Types.puma" */
   GetLogicalType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("ASSOCIATED"))) {
/* line 1469 "Types.puma" */
  {
/* line 1470 "Types.puma" */
   GetLogicalType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("PRESENT"))) {
/* line 1473 "Types.puma" */
  {
/* line 1474 "Types.puma" */
   GetLogicalType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("NUMBER_OF_PROCESSORS"))) {
/* line 1477 "Types.puma" */
  {
/* line 1478 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("ACTIVE_NUM_PROCS"))) {
/* line 1481 "Types.puma" */
  {
/* line 1482 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("MY_PROCESSOR"))) {
/* line 1485 "Types.puma" */
  {
/* line 1486 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GLOBAL_LBOUND"))) {
/* line 1489 "Types.puma" */
  {
/* line 1490 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GLOBAL_UBOUND"))) {
/* line 1493 "Types.puma" */
  {
/* line 1494 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GLOBAL_SIZE"))) {
/* line 1497 "Types.puma" */
  {
/* line 1498 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("GLOBAL_SHAPE"))) {
/* line 1501 "Types.puma" */
  {
/* line 1502 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("LOCAL_BLKCNT"))) {
/* line 1505 "Types.puma" */
  {
/* line 1506 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("LOCAL_LINDEX"))) {
/* line 1509 "Types.puma" */
  {
/* line 1510 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("LOCAL_UINDEX"))) {
/* line 1513 "Types.puma" */
  {
/* line 1514 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("KIND"))) {
/* line 1517 "Types.puma" */
  {
/* line 1518 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("DIGITS"))) {
/* line 1521 "Types.puma" */
  {
/* line 1522 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("EPSILON"))) {
  if (params->Kind == kBTP_LIST) {
/* line 1525 "Types.puma" */
  {
/* line 1527 "Types.puma" */
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("HUGE"))) {
  if (params->Kind == kBTP_LIST) {
/* line 1530 "Types.puma" */
  {
/* line 1532 "Types.puma" */
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("TINY"))) {
  if (params->Kind == kBTP_LIST) {
/* line 1535 "Types.puma" */
  {
/* line 1537 "Types.puma" */
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("MINEXPONENT"))) {
/* line 1540 "Types.puma" */
  {
/* line 1541 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("MAXEXPONENT"))) {
/* line 1544 "Types.puma" */
  {
/* line 1545 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("PRECISION"))) {
/* line 1548 "Types.puma" */
  {
/* line 1549 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("RADIX"))) {
/* line 1552 "Types.puma" */
  {
/* line 1553 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
 {
  type_rec yyV1;
  if (equaltIdent (name, IsIdent ("RANGE"))) {
/* line 1556 "Types.puma" */
  {
/* line 1557 "Types.puma" */
   GetIntegerType (& yyV1);
  }
   * yyP8 = yyV1;
   return;

  }
 }
  if (params->Kind == kBTP_LIST) {
/* line 1566 "Types.puma" */
 {
  type_rec yyV1;
  {
/* line 1567 "Types.puma" */
   GetParamType (params->BTP_LIST.Elem, & yyV1);
  }
   * yyP8 = yyV1;
   return;
 }

  }
/* line 1570 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 1574 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE; 
/* line 1576 "Types.puma" */
   obj_protocol ("no type for this intrinsic object : ", GetIntrinsicObject (name));
  }
   * yyP8 = rtype;
   return;
 }

;
}

static void TypeCombination
# if defined __STDC__ | defined __cplusplus
(type_rec type1, type_rec type2, type_rec * yyP9)
# else
(type1, type2, yyP9)
 type_rec type1;
 type_rec type2;
 type_rec * yyP9;
# endif
{
/* line 1595 "Types.puma" */
  {
/* line 1597 "Types.puma" */
   if (! ((SameTypeRecord (type1, type2)))) goto yyL1;
  }
   * yyP9 = type1;
   return;
yyL1:;

/* line 1600 "Types.puma" */
  {
/* line 1602 "Types.puma" */
   if (! ((IsSubType (type1, type2)))) goto yyL2;
  }
   * yyP9 = type2;
   return;
yyL2:;

/* line 1605 "Types.puma" */
  {
/* line 1607 "Types.puma" */
   if (! ((IsSubType (type2, type1)))) goto yyL3;
  }
   * yyP9 = type1;
   return;
yyL3:;

/* line 1610 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 1614 "Types.puma" */
 rtype.type_kind = kDUMMY_TYPE;
     rtype.type_size = 0;
   
  }
   * yyP9 = rtype;
   return;
 }

;
}

rbool IsSubType
# if defined __STDC__ | defined __cplusplus
(type_rec type1, type_rec type2)
# else
(type1, type2)
 type_rec type1;
 type_rec type2;
# endif
{
/* line 1629 "Types.puma" */
  {
/* line 1630 "Types.puma" */
   if (! ((type1 . type_kind == type2 . type_kind))) goto yyL1;
  {
/* line 1631 "Types.puma" */
   if (! ((type1 . type_kind == kTYPE_ID))) goto yyL1;
  {
/* line 1632 "Types.puma" */
   if (! ((type1 . type_size == type2 . type_size))) goto yyL1;
  }
  }
  }
   return rtrue;
yyL1:;

/* line 1635 "Types.puma" */
  {
/* line 1636 "Types.puma" */
   if (! ((type1 . type_kind == type2 . type_kind))) goto yyL2;
  {
/* line 1637 "Types.puma" */
   if (! ((type1 . type_kind != kTYPE_ID))) goto yyL2;
  {
/* line 1638 "Types.puma" */
   if (! ((type1 . type_size <= type2 . type_size))) goto yyL2;
  }
  }
  }
   return rtrue;
yyL2:;

/* line 1641 "Types.puma" */
  {
/* line 1642 "Types.puma" */
   if (! ((type1 . type_kind == kDUMMY_TYPE))) goto yyL3;
  }
   return rtrue;
yyL3:;

/* line 1645 "Types.puma" */
  {
/* line 1646 "Types.puma" */
   if (! ((type1 . type_kind == kINTEGER_TYPE))) goto yyL4;
  {
/* line 1647 "Types.puma" */
   if (! ((type2 . type_kind == kREAL_TYPE))) goto yyL4;
  }
  }
   return rtrue;
yyL4:;

/* line 1650 "Types.puma" */
  {
/* line 1651 "Types.puma" */
   if (! ((type1 . type_kind == kINTEGER_TYPE))) goto yyL5;
  {
/* line 1652 "Types.puma" */
   if (! ((type2 . type_kind == kCOMPLEX_TYPE))) goto yyL5;
  }
  }
   return rtrue;
yyL5:;

/* line 1655 "Types.puma" */
  {
/* line 1656 "Types.puma" */
   if (! ((type1 . type_kind == kREAL_TYPE))) goto yyL6;
  {
/* line 1657 "Types.puma" */
   if (! ((type2 . type_kind == kCOMPLEX_TYPE))) goto yyL6;
  }
  }
   return rtrue;
yyL6:;

  return rfalse;
}

rbool SameTypeRecord
# if defined __STDC__ | defined __cplusplus
(type_rec type1, type_rec type2)
# else
(type1, type2)
 type_rec type1;
 type_rec type2;
# endif
{
/* line 1670 "Types.puma" */
  {
/* line 1672 "Types.puma" */
   if (! ((type1 . type_kind == type2 . type_kind))) goto yyL1;
  {
/* line 1673 "Types.puma" */
   if (! ((type1 . type_size == type2 . type_size))) goto yyL1;
  }
  }
   return rtrue;
yyL1:;

/* line 1676 "Types.puma" */
  {
/* line 1678 "Types.puma" */
   if (! ((type1 . type_kind == type2 . type_kind))) goto yyL2;
  {
/* line 1679 "Types.puma" */
   if (! ((type1 . type_kind == kSTRING_TYPE))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static rbool IsNumType
# if defined __STDC__ | defined __cplusplus
(type_rec type)
# else
(type)
 type_rec type;
# endif
{
/* line 1685 "Types.puma" */
  {
/* line 1686 "Types.puma" */
   if (! ((type . type_kind == kINTEGER_TYPE))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 1689 "Types.puma" */
  {
/* line 1690 "Types.puma" */
   if (! ((type . type_kind == kREAL_TYPE))) goto yyL2;
  }
   return rtrue;
yyL2:;

/* line 1693 "Types.puma" */
  {
/* line 1694 "Types.puma" */
   if (! ((type . type_kind == kCOMPLEX_TYPE))) goto yyL3;
  }
   return rtrue;
yyL3:;

  return rfalse;
}

static rbool IsBoolType
# if defined __STDC__ | defined __cplusplus
(type_rec type)
# else
(type)
 type_rec type;
# endif
{
/* line 1699 "Types.puma" */
  {
/* line 1700 "Types.puma" */
   if (! ((type . type_kind == kBOOLEAN_TYPE))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

static rbool IsStringTypeKind
# if defined __STDC__ | defined __cplusplus
(type_rec type)
# else
(type)
 type_rec type;
# endif
{
/* line 1705 "Types.puma" */
  {
/* line 1706 "Types.puma" */
   if (! ((type . type_kind == kSTRING_TYPE))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

static void GetIntegerType
# if defined __STDC__ | defined __cplusplus
(type_rec * yyP10)
# else
(yyP10)
 type_rec * yyP10;
# endif
{
/* line 1717 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 1721 "Types.puma" */
 rtype.type_kind = kINTEGER_TYPE;
    rtype.type_size = default_int_size;
  
  }
   * yyP10 = rtype;
   return;
 }

;
}

static void GetRealType
# if defined __STDC__ | defined __cplusplus
(register int size, type_rec * yyP11)
# else
(size, yyP11)
 register int size;
 type_rec * yyP11;
# endif
{
/* line 1728 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 1732 "Types.puma" */
 rtype.type_kind = kREAL_TYPE;
    rtype.type_size = size;
  
  }
   * yyP11 = rtype;
   return;
 }

;
}

static void GetComplexType
# if defined __STDC__ | defined __cplusplus
(register int size, type_rec * yyP12)
# else
(size, yyP12)
 register int size;
 type_rec * yyP12;
# endif
{
/* line 1739 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 1743 "Types.puma" */
 rtype.type_kind = kCOMPLEX_TYPE;
    rtype.type_size = size;
  
  }
   * yyP12 = rtype;
   return;
 }

;
}

static void GetLogicalType
# if defined __STDC__ | defined __cplusplus
(type_rec * yyP13)
# else
(yyP13)
 type_rec * yyP13;
# endif
{
/* line 1750 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 1754 "Types.puma" */
 rtype.type_kind = kBOOLEAN_TYPE;
    rtype.type_size = default_int_size;
  
  }
   * yyP13 = rtype;
   return;
 }

;
}

static void GetStringType
# if defined __STDC__ | defined __cplusplus
(type_rec * yyP14)
# else
(yyP14)
 type_rec * yyP14;
# endif
{
/* line 1761 "Types.puma" */
 {
  type_rec rtype;
  {
/* line 1765 "Types.puma" */
 rtype.type_kind = kSTRING_TYPE;
    rtype.type_size = -1;            
  
  }
   * yyP14 = rtype;
   return;
 }

;
}

tTree GetTypeZero
# if defined __STDC__ | defined __cplusplus
(register tTree texp)
# else
(texp)
 register tTree texp;
# endif
{
/* line 1778 "Types.puma" */
 {
  type_rec yyV1;
  tTree zero;
  {
/* line 1780 "Types.puma" */
   GetExpType (texp, & yyV1);
/* line 1784 "Types.puma" */
 zero = NoTree;

     switch (yyV1.type_kind) {

     case kINTEGER_TYPE :  zero = mCONST_EXP (mINT_CONSTANT (0));
                           break;
     case kBOOLEAN_TYPE :  zero = mCONST_EXP (mBOOL_CONSTANT (rfalse));
                           break;
     case kREAL_TYPE : if (yyV1.type_size == default_real_size)
                          zero = mCONST_EXP (mREAL_CONSTANT (PutString("0.0",3),
                                                           default_real_size));
                    if (yyV1.type_size == 2*default_real_size)
                       zero = mCONST_EXP (mREAL_CONSTANT (PutString("0.0d0",5),
                                                         2*default_real_size));
                    break;

     case kCOMPLEX_TYPE : if (yyV1.type_size == 2*default_real_size)

                    zero = mCONST_EXP (mCOMPLEX_CONSTANT (PutString("0.0",3),
                                                          PutString("0.0",3)));
                    break;

     case kSTRING_TYPE : error_protocol ("strings not supported here");
                         zero = mCONST_EXP (mSTRING_CONSTANT(
                                             PutString (" ", 1)));
                         break;

       } 

      if (zero == NoTree)
        {  error_protocol ("zero value for the type not found");
           tree_protocol  ("needed for ", texp);
           zero = mCONST_EXP (mINT_CONSTANT (0));
        }

    
  }
   return zero;
 }

}

rbool IsSameExpType
# if defined __STDC__ | defined __cplusplus
(register tTree t1, register tTree t2)
# else
(t1, t2)
 register tTree t1;
 register tTree t2;
# endif
{
/* line 1833 "Types.puma" */
 {
  type_rec yyV1;
  type_rec yyV2;
  {
/* line 1835 "Types.puma" */
   GetExpType (t1, & yyV1);
/* line 1836 "Types.puma" */
   GetExpType (t2, & yyV2);
/* line 1837 "Types.puma" */
   if (! ((yyV1 . type_kind == yyV2 . type_kind))) goto yyL1;
  {
/* line 1838 "Types.puma" */
   if (! ((yyV1 . type_size == yyV2 . type_size))) goto yyL1;
  }
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

rbool IsSameBaseType
# if defined __STDC__ | defined __cplusplus
(register tTree t1, register tTree t2)
# else
(t1, t2)
 register tTree t1;
 register tTree t2;
# endif
{
/* line 1843 "Types.puma" */

char msg[150];

/* line 1847 "Types.puma" */
 {
  type_rec yyV1;
  type_rec yyV2;
  {
/* line 1849 "Types.puma" */
   GetTypeRecord (t1, & yyV1);
/* line 1850 "Types.puma" */
   GetTypeRecord (t2, & yyV2);
/* line 1859 "Types.puma" */
   if (! ((yyV1 . type_kind == yyV2 . type_kind))) goto yyL1;
  {
/* line 1860 "Types.puma" */
   if (! ((yyV1 . type_size == yyV2 . type_size))) goto yyL1;
  }
  }
   return rtrue;
 }
yyL1:;

  return rfalse;
}

int GetObjectSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
/* line 1877 "Types.puma" */
   return GetTypeSize (GetObjectType (obj));

}

static int GetTypeSize
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
/* line 1888 "Types.puma" */
  {
/* line 1889 "Types.puma" */
   if (! ((type == NoTree))) goto yyL1;
  }
   return - 1;
yyL1:;


  switch (type->Kind) {
  case kINTEGER_TYPE:
/* line 1893 "Types.puma" */
   return EvaluateSize (type->INTEGER_TYPE.SIZE);

  case kREAL_TYPE:
/* line 1898 "Types.puma" */
   return EvaluateSize (type->REAL_TYPE.SIZE);

  case kCOMPLEX_TYPE:
/* line 1903 "Types.puma" */
   return EvaluateSize (type->COMPLEX_TYPE.SIZE);

  case kBOOLEAN_TYPE:
/* line 1908 "Types.puma" */
   return EvaluateSize (type->BOOLEAN_TYPE.SIZE);

  case kSTRING_TYPE:
/* line 1913 "Types.puma" */
   return EvaluateSize (type->STRING_TYPE.LENGTH);

  case kDUMMY_TYPE:
/* line 1918 "Types.puma" */
   return - 1;

  case kTYPE_ID:
/* line 1923 "Types.puma" */
   return DerivedTypeSize (type->TYPE_ID.ID->TYPE_OBJ.Object);

  case kARRAY_TYPE:
/* line 1928 "Types.puma" */
  {
/* line 1930 "Types.puma" */
   if (! ((IsExplicitShape (type->ARRAY_TYPE.ARRAY_INDEX_TYPES)))) goto yyL9;
  }
   return MultSizes (FormalSize (type->ARRAY_TYPE.ARRAY_INDEX_TYPES), GetTypeSize (type->ARRAY_TYPE.ARRAY_COMP_TYPE)) + default_addr_size;
yyL9:;

/* line 1936 "Types.puma" */
  {
/* line 1938 "Types.puma" */
   if (! ((IsDeferredShape (type->ARRAY_TYPE.ARRAY_INDEX_TYPES)))) goto yyL10;
  }
   return GetTypeSize (type->ARRAY_TYPE.ARRAY_COMP_TYPE) * 2 + default_int_size * (TreeListLength (type->ARRAY_TYPE.ARRAY_INDEX_TYPES) + 1) + default_addr_size;
yyL10:;

  break;
  }

/* line 1947 "Types.puma" */
  {
/* line 1948 "Types.puma" */
   failure_protocol (MODULE, "GetTypeSize", type);
  }
   return - 1;

}

static int DerivedTypeSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kTypeObject) {
/* line 1960 "Types.puma" */
 {
  int size;
  {
/* line 1964 "Types.puma" */
   size = ComponentsSize (obj->TypeObject.Components);
  }
   return size;
 }

  }
 yyAbort ("DerivedTypeSize");
 { int yyDummy; return yyDummy; }
}

static int ComponentsSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions components)
# else
(components)
 register tDefinitions components;
# endif
{
  if (components->Kind == kENTRY_LIST) {
/* line 1971 "Types.puma" */
   return AddSizes (ComponentsSize (components->ENTRY_LIST.Next), GetObjectSize (components->ENTRY_LIST.Elem));

  }
  if (components->Kind == kENTRY_EMPTY) {
/* line 1975 "Types.puma" */
   return 0;

  }
 yyAbort ("ComponentsSize");
 { int yyDummy; return yyDummy; }
}

static int FormalSize
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
  if (formals->Kind == kSHAPE_LIST) {
/* line 1985 "Types.puma" */
   return MultSizes (FormalSize (formals->SHAPE_LIST.Elem), FormalSize (formals->SHAPE_LIST.Next));

  }
  if (formals->Kind == kSHAPE_EMPTY) {
/* line 1989 "Types.puma" */
   return 1;

  }
  if (formals->Kind == kEXPLICIT_SHAPE) {
/* line 1993 "Types.puma" */
 {
  int val1;
  int val2;
  rbool found;
  {
/* line 1999 "Types.puma" */
   GetIntConstValue (formals->EXPLICIT_SHAPE.LOWER, & found, & val1);
/* line 2000 "Types.puma" */
   if (! ((found))) goto yyL3;
  {
/* line 2001 "Types.puma" */
   GetIntConstValue (formals->EXPLICIT_SHAPE.UPPER, & found, & val2);
/* line 2002 "Types.puma" */
   if (! ((found))) goto yyL3;
  }
  }
   return val2 - val1 + 1;
 }
yyL3:;

  }
  if (Tree_IsType (formals, kSHAPE_SPEC)) {
/* line 2006 "Types.puma" */
   return - 1;

  }
 yyAbort ("FormalSize");
 { int yyDummy; return yyDummy; }
}

static int AddSizes
# if defined __STDC__ | defined __cplusplus
(register int size1, register int size2)
# else
(size1, size2)
 register int size1;
 register int size2;
# endif
{
/* line 2016 "Types.puma" */
  {
/* line 2017 "Types.puma" */
   if (! ((size1 == - 1))) goto yyL1;
  }
   return - 1;
yyL1:;

/* line 2021 "Types.puma" */
  {
/* line 2022 "Types.puma" */
   if (! ((size2 == - 1))) goto yyL2;
  }
   return - 1;
yyL2:;

/* line 2026 "Types.puma" */
   return size1 + size2;

}

static int MultSizes
# if defined __STDC__ | defined __cplusplus
(register int size1, register int size2)
# else
(size1, size2)
 register int size1;
 register int size2;
# endif
{
/* line 2037 "Types.puma" */
  {
/* line 2038 "Types.puma" */
   if (! ((size1 == - 1))) goto yyL1;
  }
   return - 1;
yyL1:;

/* line 2042 "Types.puma" */
  {
/* line 2043 "Types.puma" */
   if (! ((size2 == - 1))) goto yyL2;
  }
   return - 1;
yyL2:;

/* line 2047 "Types.puma" */
   return size1 * size2;

}

static int EvaluateSize
# if defined __STDC__ | defined __cplusplus
(register tTree size)
# else
(size)
 register tTree size;
# endif
{
/* line 2060 "Types.puma" */
 {
  rbool found;
  int val;
  {
/* line 2065 "Types.puma" */
   GetIntConstValue (size, & found, & val);
/* line 2066 "Types.puma" */
   if (! ((found))) goto yyL1;
  }
   return val;
 }
yyL1:;

/* line 2070 "Types.puma" */
   return - 1;

}

int TargetTypeSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kTYPE_ID) {
  if (t->TYPE_ID.ID->TYPE_OBJ.Object->Kind == kTypeObject) {
/* line 2087 "Types.puma" */
 {
  int yyV1;
  int yyV2;
  {
/* line 2089 "Types.puma" */
   AlignedDerTypeSize (t->TYPE_ID.ID->TYPE_OBJ.Object, & yyV1, & yyV2);
  }
   return yyV2;
 }

  }
  }
/* line 2100 "Types.puma" */
  {
/* line 2102 "Types.puma" */
   failure_protocol (MODULE, "TargetTypeSize", t);
  }
   return 0;

}

static void AlignedDerTypeSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions type_obj, register int * yyP16, register int * yyP15)
# else
(type_obj, yyP16, yyP15)
 register tDefinitions type_obj;
 register int * yyP16;
 register int * yyP15;
# endif
{
  if (type_obj->Kind == kTypeObject) {
/* line 2119 "Types.puma" */
 {
  int yyV1;
  int yyV2;
  {
/* line 2121 "Types.puma" */
   AlignedComponentsSize (type_obj->TypeObject.Components, 0, & yyV1, & yyV2);
  }
   * yyP16 = yyV1;
   * yyP15 = AlignedSize (yyV2, yyV1);
   return;
 }

  }
/* line 2124 "Types.puma" */
  {
/* line 2126 "Types.puma" */
   failure_protocol (MODULE, "AlignedDerTypeSize", type_obj->Object.decl);
  }
   * yyP16 = 1;
   * yyP15 = 0;
   return;

;
}

static void AlignedComponentsSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions components, register int cur_size, register int * yyP18, register int * yyP17)
# else
(components, cur_size, yyP18, yyP17)
 register tDefinitions components;
 register int cur_size;
 register int * yyP18;
 register int * yyP17;
# endif
{
  if (components->Kind == kENTRY_LIST) {
/* line 2145 "Types.puma" */
 {
  int yyV1;
  int yyV2;
  int yyV3;
  int yyV4;
  int yyV5;
  {
/* line 2147 "Types.puma" */
   AddCompSize (components->ENTRY_LIST.Elem, GetObjectType (components->ENTRY_LIST.Elem), cur_size, & yyV1, & yyV2);
/* line 2151 "Types.puma" */
   AlignedComponentsSize (components->ENTRY_LIST.Next, yyV2, & yyV3, & yyV4);
/* line 2153 "Types.puma" */
   MaxAlignment (yyV1, yyV3, & yyV5);
  }
   * yyP18 = yyV5;
   * yyP17 = yyV4;
   return;
 }

  }
  if (components->Kind == kENTRY_EMPTY) {
/* line 2156 "Types.puma" */
   * yyP18 = 1;
   * yyP17 = cur_size;
   return;

  }
;
}

static void AddCompSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree type, register int cur_size, register int * yyP20, register int * yyP19)
# else
(obj, type, cur_size, yyP20, yyP19)
 register tDefinitions obj;
 register tTree type;
 register int cur_size;
 register int * yyP20;
 register int * yyP19;
# endif
{
/* line 2168 "Types.puma" */
 {
  int yyV1;
  int yyV2;
  {
/* line 2170 "Types.puma" */
   if (! ((VarRank (obj) == 0))) goto yyL1;
  {
/* line 2171 "Types.puma" */
   if (! ((IsPointerObject (obj)))) goto yyL1;
  {
/* line 2173 "Types.puma" */
   AlignedPtrSize (& yyV1, & yyV2);
/* line 2175 "Types.puma" */
   yyV2 = AlignedSize (cur_size, yyV1) + yyV2;
  }
  }
  }
   * yyP20 = yyV1;
   * yyP19 = yyV2;
   return;
 }
yyL1:;

  if (type->Kind == kTYPE_ID) {
/* line 2178 "Types.puma" */
 {
  int yyV1;
  int yyV2;
  {
/* line 2180 "Types.puma" */
   AlignedDerTypeSize (type->TYPE_ID.ID->TYPE_OBJ.Object, & yyV1, & yyV2);
/* line 2182 "Types.puma" */
   yyV2 = AlignedSize (cur_size, yyV1) + yyV2;
  }
   * yyP20 = yyV1;
   * yyP19 = yyV2;
   return;
 }

  }
  if (type->Kind == kARRAY_TYPE) {
/* line 2185 "Types.puma" */
 {
  int no_indexes;
  int yyV1;
  int yyV2;
  int yyV3;
  int yyV4;
  int yyV5;
  {
/* line 2187 "Types.puma" */
   if (! ((IsExplicitShape (type->ARRAY_TYPE.ARRAY_INDEX_TYPES)))) goto yyL3;
  {
/* line 2190 "Types.puma" */
   no_indexes = FormalSize (type->ARRAY_TYPE.ARRAY_INDEX_TYPES);
/* line 2192 "Types.puma" */
   AlignedTypeSize (type->ARRAY_TYPE.ARRAY_COMP_TYPE, & yyV1, & yyV2);
/* line 2193 "Types.puma" */
   yyV2 = no_indexes * yyV2;
/* line 2195 "Types.puma" */
   yyV2 = AlignedSize (cur_size, yyV1) + yyV2;
/* line 2199 "Types.puma" */
   AlignedDefAddrSize (& yyV3, & yyV4);
/* line 2201 "Types.puma" */
   yyV2 = AlignedSize (yyV2, yyV3) + yyV4;
/* line 2203 "Types.puma" */
   MaxAlignment (yyV1, yyV3, & yyV5);
  }
  }
   * yyP20 = yyV5;
   * yyP19 = yyV2;
   return;
 }
yyL3:;

/* line 2206 "Types.puma" */
 {
  int yyV1;
  int yyV2;
  int yyV3;
  int yyV4;
  int yyV5;
  int yyV6;
  int yyV7;
  {
/* line 2208 "Types.puma" */
   if (! ((IsDeferredShape (type->ARRAY_TYPE.ARRAY_INDEX_TYPES)))) goto yyL4;
  {
/* line 2212 "Types.puma" */
   AlignedTypeSize (type->ARRAY_TYPE.ARRAY_COMP_TYPE, & yyV1, & yyV2);
/* line 2213 "Types.puma" */
   yyV2 = 2 * yyV2;
/* line 2215 "Types.puma" */
   yyV2 = AlignedSize (cur_size, yyV1) + yyV2;
/* line 2217 "Types.puma" */
   AlignedDefIntSize (& yyV3, & yyV4);
/* line 2219 "Types.puma" */
   yyV4 = (TreeListLength (type->ARRAY_TYPE.ARRAY_INDEX_TYPES) + 1) * yyV4;
/* line 2221 "Types.puma" */
   yyV2 = AlignedSize (yyV2, yyV3) + yyV4;
/* line 2225 "Types.puma" */
   AlignedDefAddrSize (& yyV5, & yyV6);
/* line 2227 "Types.puma" */
   yyV2 = AlignedSize (yyV2, yyV5) + yyV6;
/* line 2229 "Types.puma" */
   MaxAlignment (yyV1, yyV5, & yyV7);
  }
  }
   * yyP20 = yyV7;
   * yyP19 = yyV2;
   return;
 }
yyL4:;

  }
/* line 2232 "Types.puma" */
 {
  int yyV1;
  int yyV2;
  {
/* line 2234 "Types.puma" */
   AlignedTypeSize (type, & yyV1, & yyV2);
/* line 2236 "Types.puma" */
   yyV2 = AlignedSize (cur_size, yyV1) + yyV2;
  }
   * yyP20 = yyV1;
   * yyP19 = yyV2;
   return;
 }

;
}

static void MaxAlignment
# if defined __STDC__ | defined __cplusplus
(register int align1, register int align2, register int * yyP21)
# else
(align1, align2, yyP21)
 register int align1;
 register int align2;
 register int * yyP21;
# endif
{
/* line 2246 "Types.puma" */
  {
/* line 2248 "Types.puma" */
   if (! ((align1 < align2))) goto yyL1;
  }
   * yyP21 = align2;
   return;
yyL1:;

/* line 2251 "Types.puma" */
   * yyP21 = align1;
   return;

;
}

static int AlignedSize
# if defined __STDC__ | defined __cplusplus
(register int size, register int alignment)
# else
(size, alignment)
 register int size;
 register int alignment;
# endif
{
/* line 2271 "Types.puma" */
  {
/* line 2273 "Types.puma" */
   if (! (((size % alignment) == 0))) goto yyL1;
  }
   return size;
yyL1:;

/* line 2278 "Types.puma" */
   return alignment * ((size + alignment - 1) / alignment);

}

static void AlignedTypeSize
# if defined __STDC__ | defined __cplusplus
(register tTree type, register int * yyP23, register int * yyP22)
# else
(type, yyP23, yyP22)
 register tTree type;
 register int * yyP23;
 register int * yyP22;
# endif
{
  if (type->Kind == kSTRING_TYPE) {
/* line 2296 "Types.puma" */
   * yyP23 = 1;
   * yyP22 = GetTypeSize (type);
   return;

  }
  if (type->Kind == kREAL_TYPE) {
/* line 2299 "Types.puma" */
 {
  int yyV1;
  int yyV2;
  {
/* line 2301 "Types.puma" */
   RealAlign (GetTypeSize (type), & yyV1, & yyV2);
  }
   * yyP23 = yyV1;
   * yyP22 = yyV2;
   return;
 }

  }
  if (type->Kind == kCOMPLEX_TYPE) {
/* line 2304 "Types.puma" */
 {
  int yyV1;
  int yyV2;
  {
/* line 2306 "Types.puma" */
   ComplexAlign (GetTypeSize (type), & yyV1, & yyV2);
  }
   * yyP23 = yyV1;
   * yyP22 = yyV2;
   return;
 }

  }
/* line 2309 "Types.puma" */
   * yyP23 = 4;
   * yyP22 = GetTypeSize (type);
   return;

;
}

static void AlignedPtrSize
# if defined __STDC__ | defined __cplusplus
(register int * yyP25, register int * yyP24)
# else
(yyP25, yyP24)
 register int * yyP25;
 register int * yyP24;
# endif
{
/* line 2314 "Types.puma" */
   * yyP25 = 4;
   * yyP24 = 24;
   return;

;
}

static void AlignedDefIntSize
# if defined __STDC__ | defined __cplusplus
(register int * yyP27, register int * yyP26)
# else
(yyP27, yyP26)
 register int * yyP27;
 register int * yyP26;
# endif
{
/* line 2319 "Types.puma" */
   * yyP27 = 4;
   * yyP26 = default_int_size;
   return;

;
}

static void AlignedDefAddrSize
# if defined __STDC__ | defined __cplusplus
(register int * yyP29, register int * yyP28)
# else
(yyP29, yyP28)
 register int * yyP29;
 register int * yyP28;
# endif
{
/* line 2324 "Types.puma" */
   * yyP29 = 4;
   * yyP28 = default_addr_size;
   return;

;
}

static void RealAlign
# if defined __STDC__ | defined __cplusplus
(register int size, register int * yyP31, register int * yyP30)
# else
(size, yyP31, yyP30)
 register int size;
 register int * yyP31;
 register int * yyP30;
# endif
{
/* line 2329 "Types.puma" */
  {
/* line 2331 "Types.puma" */
   if (! ((size % 8 == 0))) goto yyL1;
  }
   * yyP31 = 8;
   * yyP30 = size;
   return;
yyL1:;

/* line 2334 "Types.puma" */
   * yyP31 = 4;
   * yyP30 = size;
   return;

;
}

static void ComplexAlign
# if defined __STDC__ | defined __cplusplus
(register int size, register int * yyP33, register int * yyP32)
# else
(size, yyP33, yyP32)
 register int size;
 register int * yyP33;
 register int * yyP32;
# endif
{
/* line 2339 "Types.puma" */
  {
/* line 2341 "Types.puma" */
   if (! ((size % 8 == 0))) goto yyL1;
  }
   * yyP33 = 8;
   * yyP32 = size;
   return;
yyL1:;

/* line 2344 "Types.puma" */
   * yyP33 = 4;
   * yyP32 = size;
   return;

;
}

void BeginTypes ARGS ((void))
{
}

void CloseTypes ARGS ((void))
{
}
