# include "TriDenT.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 35 "TriDenT.puma" */


# include <stdio.h>
# include <string.h>

# include "Idents.h"
# include "StringM.h"

# include "Expressions.h"
# include "Transform.h"

# include "CodeGeneral.h"
# include "Distributions.h"
# include "Types.h"
# include "Rank.h"
# include "protocol.h"

# define  MODULE "TriDenT"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTriDenT.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* TriDenT_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TriDenT, routine %s failed\n",
  yyFunction);
 TriDenT_Exit ();
}

static tIdent MakeTriDenTId ARGS ((String name));
tTree TriDenTMakeDsp ARGS ((tTree var, int kind));
tTree TriDenTArrayMakeDsp ARGS ((tTree var, int kind));
static tIdent GetRaggedName ARGS ((tDefinitions obj));
tTree TriDenTSetSize ARGS ((tTree var, tTree dim_list, int kind));
static void SetSizeParams ARGS ((tTree dim_list, int level, tTree params, tTree * yyP1));
tTree TriDenTArrayDefine ARGS ((tTree var, tTree dim_list, int kind));
tTree TriDenTAllocate ARGS ((tTree var, int kind));
tTree TriDenTFree ARGS ((tTree var, int kind));
tTree TriDenTOffset ARGS ((tDefinitions obj, tTree indexes));
tTree TriDenTDistribute ARGS ((tTree var, int kind));
tTree TriDenTIsLocal ARGS ((tDefinitions obj, int dim, tTree val));
static void GetVarObject ARGS ((tTree var, tDefinitions * yyP2));
static void GetSizeOfObject ARGS ((tDefinitions obj, int * yyP3));
static void GetObjDistributionData ARGS ((tDefinitions obj, tDefinitions * yyP7, tDefinitions * yyP6, tDefinitions * yyP5, tDefinitions * yyP4));

static tIdent MakeTriDenTId
# if defined __STDC__ | defined __cplusplus
(String name)
# else
(name)
 String name;
# endif
{
/* line 65 "TriDenT.puma" */

char s [100];

/* line 69 "TriDenT.puma" */
  {
/* line 70 "TriDenT.puma" */
 sprintf (s, "TRIDENT_%s", name);
  
  }
   return MakeIdent (s, strlen (s));

}

tTree TriDenTMakeDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 82 "TriDenT.puma" */
 {
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  tDefinitions yyV1;
  {
/* line 89 "TriDenT.puma" */
   GetVarObject (var, & yyV1);
/* line 91 "TriDenT.puma" */
   params = mBTP_EMPTY ();
/* line 92 "TriDenT.puma" */
   param = ExpToVarParam (MakeConstant (VarRank (yyV1)));
/* line 93 "TriDenT.puma" */
   params = mBTP_LIST (param, params);
/* line 95 "TriDenT.puma" */
   cname = MakeTriDenTId ("tree_make_dsp");
/* line 97 "TriDenT.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 98 "TriDenT.puma" */
   params = mBTP_LIST (param, params);
/* line 100 "TriDenT.puma" */
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
   return call;
 }

}

tTree TriDenTArrayMakeDsp
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 111 "TriDenT.puma" */
 {
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  tDefinitions yyV1;
  int yyV2;
  {
/* line 118 "TriDenT.puma" */
   GetVarObject (var, & yyV1);
/* line 119 "TriDenT.puma" */
   GetSizeOfObject (yyV1, & yyV2);
/* line 121 "TriDenT.puma" */
   params = mBTP_EMPTY ();
/* line 122 "TriDenT.puma" */
   param = ExpToVarParam (MakeConstant (yyV2));
/* line 123 "TriDenT.puma" */
   params = mBTP_LIST (param, params);
/* line 124 "TriDenT.puma" */
   param = ExpToVarParam (MakeConstant (VarRank (yyV1)));
/* line 125 "TriDenT.puma" */
   params = mBTP_LIST (param, params);
/* line 127 "TriDenT.puma" */
   cname = MakeTriDenTId ("array_make_dsp");
/* line 129 "TriDenT.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 130 "TriDenT.puma" */
   params = mBTP_LIST (param, params);
/* line 132 "TriDenT.puma" */
   param = mVAR_PARAM (MakeUsedVarA (GetRaggedName (yyV1), DSP_SUFFIX));
/* line 133 "TriDenT.puma" */
   params = mBTP_LIST (param, params);
/* line 135 "TriDenT.puma" */
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
   return call;
 }

}

static tIdent GetRaggedName
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Object.in->Kind == kRaggedObject) {
/* line 141 "TriDenT.puma" */
   return obj->Object.in->RaggedObject.Ident;

  }
 yyAbort ("GetRaggedName");
 { tIdent yyDummy; return yyDummy; }
}

tTree TriDenTSetSize
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree dim_list, register int kind)
# else
(var, dim_list, kind)
 register tTree var;
 register tTree dim_list;
 register int kind;
# endif
{
/* line 158 "TriDenT.puma" */
 {
  tTree param;
  tTree call;
  tIdent cname;
  tTree yyV1;
  {
/* line 164 "TriDenT.puma" */
   SetSizeParams (dim_list, 0, mBTP_EMPTY (), & yyV1);
/* line 166 "TriDenT.puma" */
   cname = MakeTriDenTId ("set_size");
/* line 168 "TriDenT.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 169 "TriDenT.puma" */
   yyV1 = mBTP_LIST (param, yyV1);
/* line 171 "TriDenT.puma" */
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), yyV1));
  }
   return call;
 }

}

static void SetSizeParams
# if defined __STDC__ | defined __cplusplus
(register tTree dim_list, register int level, register tTree params, register tTree * yyP1)
# else
(dim_list, level, params, yyP1)
 register tTree dim_list;
 register int level;
 register tTree params;
 register tTree * yyP1;
# endif
{
  if (dim_list->Kind == kBTE_LIST) {
  if (dim_list->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (dim_list->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 177 "TriDenT.puma" */
 {
  tTree new_params;
  {
/* line 181 "TriDenT.puma" */
   new_params = mBTP_LIST (ExpToVarParam (MakeConstant (level)), params);
/* line 182 "TriDenT.puma" */
   new_params = mBTP_LIST (ExpToVarParam (dim_list->BTE_LIST.Elem->SLICE_EXP.STOP), new_params);
/* line 183 "TriDenT.puma" */
   new_params = mBTP_LIST (ExpToVarParam (dim_list->BTE_LIST.Elem->SLICE_EXP.FIRST), new_params);
  }
   * yyP1 = new_params;
   return;
 }

  }
  }
/* line 186 "TriDenT.puma" */
 {
  tTree yyV1;
  {
/* line 188 "TriDenT.puma" */
   SetSizeParams (dim_list->BTE_LIST.Next, level + 1, AppendParam (params, ExpToVarParam (dim_list->BTE_LIST.Elem)), & yyV1);
  }
   * yyP1 = yyV1;
   return;
 }

  }
/* line 192 "TriDenT.puma" */
  {
/* line 194 "TriDenT.puma" */
   failure_protocol (MODULE, "SetSizeParams", dim_list);
  }
   * yyP1 = NoTree;
   return;

;
}

tTree TriDenTArrayDefine
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree dim_list, register int kind)
# else
(var, dim_list, kind)
 register tTree var;
 register tTree dim_list;
 register int kind;
# endif
{
/* line 205 "TriDenT.puma" */
 {
  tTree param;
  tTree params;
  tTree call;
  tIdent cname;
  tDefinitions yyV1;
  {
/* line 212 "TriDenT.puma" */
   GetVarObject (var, & yyV1);
/* line 214 "TriDenT.puma" */
   params = mBTP_EMPTY ();
/* line 215 "TriDenT.puma" */
   param = ExpToVarParam (MakeConstant (VarRank (yyV1)));
/* line 216 "TriDenT.puma" */
   params = mBTP_LIST (param, params);
/* line 218 "TriDenT.puma" */
   cname = MakeTriDenTId ("array_define");
/* line 220 "TriDenT.puma" */
   param = mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX));
/* line 221 "TriDenT.puma" */
   params = mBTP_LIST (param, params);
/* line 223 "TriDenT.puma" */
   param = mVAR_PARAM (MakeUsedVarA (GetRaggedName (yyV1), DSP_SUFFIX));
/* line 224 "TriDenT.puma" */
   params = mBTP_LIST (param, params);
/* line 226 "TriDenT.puma" */
   call = mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
  }
   return call;
 }

}

tTree TriDenTAllocate
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 238 "TriDenT.puma" */
 {
  tTree params;
  tTree call;
  {
/* line 243 "TriDenT.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), mBTP_EMPTY ());
/* line 246 "TriDenT.puma" */
 call  = mPROC_OBJ (MakeTriDenTId ("tree_allocated")); 
/* line 248 "TriDenT.puma" */
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
   return call;
 }

}

tTree TriDenTFree
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 264 "TriDenT.puma" */
 {
  tTree params;
  tTree call;
  {
/* line 269 "TriDenT.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), mBTP_EMPTY ());
/* line 272 "TriDenT.puma" */
 call  = mPROC_OBJ (MakeTriDenTId ("tree_free")); 
/* line 274 "TriDenT.puma" */
   call = mACF_BASIC (mCALL_STMT (call, params));
  }
   return call;
 }

}

tTree TriDenTOffset
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tTree indexes)
# else
(obj, indexes)
 register tDefinitions obj;
 register tTree indexes;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.in->Kind == kRaggedObject) {
/* line 290 "TriDenT.puma" */
 {
  tTree param;
  tTree params;
  tTree call;
  {
/* line 296 "TriDenT.puma" */
 params = ExpListToVarParamList (indexes);

     param  = ExpToVarParam (MakeConstant (VarRank (obj)));
     params = mBTP_LIST (param, params);

     param  = mVAR_PARAM (MakeUsedVarA (obj->VarObject.in->RaggedObject.Ident, DSP_SUFFIX));
     params = mBTP_LIST (param, params);

     call   = mPROC_OBJ (MakeTriDenTId ("offset"));
     DefineNewHelpFn (MakeTriDenTId ("offset"));
     call = mFUNC_CALL_EXP (call, params);
   
  }
   return call;
 }

  }
  }
 yyAbort ("TriDenTOffset");
 { tTree yyDummy; return yyDummy; }
}

tTree TriDenTDistribute
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 322 "TriDenT.puma" */
 {
  tDefinitions yyV1;
  tDefinitions yyV2;
  tDefinitions yyV3;
  tDefinitions yyV4;
  tDefinitions yyV5;
  tTree param;
  tTree params;
  tIdent cname;
  {
/* line 324 "TriDenT.puma" */
   GetVarObject (var, & yyV1);
/* line 326 "TriDenT.puma" */
   GetObjDistributionData (yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
/* line 328 "TriDenT.puma" */
   if (! ((yyV1 == yyV2))) goto yyL1;
  {
/* line 334 "TriDenT.puma" */
   params = MakeDistributeParams (yyV5);
/* line 335 "TriDenT.puma" */
   params = mBTP_LIST (MakeTopologyParam (GetTopologyObj (yyV2)), params);
/* line 337 "TriDenT.puma" */
   cname = MakeTriDenTId ("tree_distribute");
/* line 339 "TriDenT.puma" */
   params = mBTP_LIST (mVAR_PARAM (MakeVarSuffixA (var, DSP_SUFFIX)), params);
  }
  }
   return mACF_BASIC (mCALL_STMT (mPROC_OBJ (cname), params));
 }
yyL1:;

/* line 345 "TriDenT.puma" */
   return NoTree;

}

tTree TriDenTIsLocal
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int dim, register tTree val)
# else
(obj, dim, val)
 register tDefinitions obj;
 register int dim;
 register tTree val;
# endif
{
  if (obj->Kind == kVarObject) {
  if (obj->VarObject.in->Kind == kRaggedObject) {
/* line 354 "TriDenT.puma" */
 {
  tTree paramlist;
  tTree call;
  {
/* line 359 "TriDenT.puma" */
 paramlist = mBTP_EMPTY ();
     paramlist = mBTP_LIST (ExpToVarParam (val), paramlist);
     paramlist = mBTP_LIST (ExpToVarParam (MakeConstant (dim)),
                            paramlist);
     paramlist = mBTP_LIST (mVAR_PARAM (MakeUsedVarA (obj->VarObject.in->RaggedObject.Ident, "_DSP")),
                            paramlist);
     call = mPROC_OBJ (MakeTriDenTId ("is_local"));
     DefineNewHelpFn (MakeTriDenTId ("is_local"));
     call = mFUNC_CALL_EXP (call, paramlist);
  
  }
   return call;
 }

  }
  }
 yyAbort ("TriDenTIsLocal");
 { tTree yyDummy; return yyDummy; }
}

static void GetVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tDefinitions * yyP2)
# else
(var, yyP2)
 register tTree var;
 register tDefinitions * yyP2;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 381 "TriDenT.puma" */
   * yyP2 = var->USED_VAR.VARNAME->VAR_OBJ.Object;
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 384 "TriDenT.puma" */
   * yyP2 = var->SELECTED_VAR.SELECTOR->REC_COMP.Object;
   return;

  }
/* line 387 "TriDenT.puma" */
  {
/* line 389 "TriDenT.puma" */
   failure_protocol (MODULE, "GetVarObject", var);
  }
   * yyP2 = NoObject;
   return;

;
}

static void GetSizeOfObject
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register int * yyP3)
# else
(obj, yyP3)
 register tDefinitions obj;
 register int * yyP3;
# endif
{
/* line 400 "TriDenT.puma" */
  {
/* line 402 "TriDenT.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 403 "TriDenT.puma" */
   failure_protocol (MODULE, "GetSizeOfObject", NoTree);
  }
  }
   * yyP3 = 0;
   return;
yyL1:;

  if (obj->Kind == kTemplateObject) {
/* line 406 "TriDenT.puma" */
   * yyP3 = 0;
   return;

  }
  if (obj->Kind == kVarObject) {
/* line 409 "TriDenT.puma" */
   * yyP3 = TreeSize (GetBaseType (GetObjectType (obj)));
   return;

  }
/* line 412 "TriDenT.puma" */
  {
/* line 414 "TriDenT.puma" */
   failure_protocol (MODULE, "GetSizeOfObject", obj->Object.decl);
  }
   * yyP3 = 0;
   return;

;
}

static void GetObjDistributionData
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions * yyP7, register tDefinitions * yyP6, register tDefinitions * yyP5, register tDefinitions * yyP4)
# else
(obj, yyP7, yyP6, yyP5, yyP4)
 register tDefinitions obj;
 register tDefinitions * yyP7;
 register tDefinitions * yyP6;
 register tDefinitions * yyP5;
 register tDefinitions * yyP4;
# endif
{
  if (obj->Kind == kRaggedObject) {
  if (obj->RaggedObject.Dist->Mapping.spec->Kind == kMapDist) {
/* line 426 "TriDenT.puma" */
   * yyP7 = obj;
   * yyP6 = obj->RaggedObject.Dist->Mapping.spec;
   * yyP5 = obj->RaggedObject.Dist->Mapping.spec->MapDist.Distribution->Distribution.ArrayList;
   * yyP4 = obj->RaggedObject.Dist->Mapping.spec->MapDist.Distribution->Distribution.ArrayList;
   return;

  }
  if (obj->RaggedObject.Dist->Mapping.spec->Kind == kMapAlign) {
/* line 431 "TriDenT.puma" */
   * yyP7 = obj->RaggedObject.Dist->Mapping.spec->MapAlign.Alignment->Alignment.template_obj;
   * yyP6 = obj->RaggedObject.Dist->Mapping.spec;
   * yyP5 = obj->RaggedObject.Dist->Mapping.spec->MapAlign.Alignment->Alignment.TargetList;
   * yyP4 = obj->RaggedObject.Dist->Mapping.spec->MapAlign.Alignment->Alignment.SourceList;
   return;

  }
  }
/* line 437 "TriDenT.puma" */
  {
/* line 439 "TriDenT.puma" */
   obj_error_protocol ("no distribution for this object", obj);
/* line 440 "TriDenT.puma" */
   failure_protocol (MODULE, "GetObjDistributionData", obj->Object.decl);
  }
   * yyP7 = NoObject;
   * yyP6 = NoObject;
   * yyP5 = NoObject;
   * yyP4 = NoObject;
   return;

;
}

void BeginTriDenT ARGS ((void))
{
}

void CloseTriDenT ARGS ((void))
{
}
