# include "TreeOps.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 47 "TreeOps.puma" */


# define MODULE "TreeOps"

# include "Idents.h"
# include "StringM.h"
# include "protocol.h"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTreeOps.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* TreeOps_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TreeOps, routine %s failed\n",
  yyFunction);
 TreeOps_Exit ();
}

int TreeListLength ARGS ((tTree t));
tTree TreeListGet ARGS ((tTree list, int n));
tIdent TreeVarName ARGS ((tTree var));
tIdent GetGenericId ARGS ((tTree t));
tIdent MakeOperatorId ARGS ((tTree t));
rbool IsDeferredShape ARGS ((tTree formals));
rbool IsAssumedShape ARGS ((tTree formals));
rbool IsExplicitShape ARGS ((tTree formals));
rbool IsAssumedSize ARGS ((tTree formals));
int IsVarInExp ARGS ((tIdent name, tTree exp));
rbool IsForallLoop ARGS ((tTree loop));
rbool IsIndepLoop ARGS ((tTree loop));
rbool IsIndepDoLoop ARGS ((tTree loop));
rbool IsSelector ARGS ((tTree t));
int GetLayout ARGS ((rbool is_f77, int model));
int GeneralIndexListLength ARGS ((tTree t));
tDefinitions GetVarAccessObject ARGS ((tTree var));
tTree GetUsedVar ARGS ((tTree var));

int TreeListLength
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 67 "TreeOps.puma" */
  {
/* line 68 "TreeOps.puma" */
   if (! (t == NoTree)) goto yyL1;
  }
   return 0;
yyL1:;


  switch (t->Kind) {
  case kACF_LIST:
/* line 72 "TreeOps.puma" */
   return 1 + TreeListLength (t->ACF_LIST.Next);

  case kACF_EMPTY:
/* line 76 "TreeOps.puma" */
   return 0;

  case kBTE_LIST:
/* line 80 "TreeOps.puma" */
   return 1 + TreeListLength (t->BTE_LIST.Next);

  case kBTE_EMPTY:
/* line 84 "TreeOps.puma" */
   return 0;

  case kBTV_LIST:
/* line 88 "TreeOps.puma" */
   return (1 + TreeListLength (t->BTV_LIST.Next));

  case kBTV_EMPTY:
/* line 92 "TreeOps.puma" */
   return 0;

  case kBTP_LIST:
/* line 96 "TreeOps.puma" */
   return (1 + TreeListLength (t->BTP_LIST.Next));

  case kBTP_EMPTY:
/* line 100 "TreeOps.puma" */
   return 0;

  case kSHAPE_LIST:
/* line 104 "TreeOps.puma" */
   return (1 + TreeListLength (t->SHAPE_LIST.Next));

  case kSHAPE_EMPTY:
/* line 108 "TreeOps.puma" */
   return 0;

  case kDECL_LIST:
/* line 112 "TreeOps.puma" */
   return (1 + TreeListLength (t->DECL_LIST.Next));

  case kDECL_EMPTY:
/* line 116 "TreeOps.puma" */
   return 0;

  case kUNIT_LIST:
/* line 120 "TreeOps.puma" */
   return (1 + TreeListLength (t->UNIT_LIST.Next));

  case kUNIT_EMPTY:
/* line 124 "TreeOps.puma" */
   return 0;

  case kDIST_LIST:
/* line 128 "TreeOps.puma" */
   return (1 + TreeListLength (t->DIST_LIST.Next));

  case kDIST_EMPTY:
/* line 132 "TreeOps.puma" */
   return 0;

  case kON_LIST:
/* line 136 "TreeOps.puma" */
   return (1 + TreeListLength (t->ON_LIST.Next));

  case kON_EMPTY:
/* line 140 "TreeOps.puma" */
   return 0;

  case kSHADOW_LIST:
/* line 144 "TreeOps.puma" */
   return (1 + TreeListLength (t->SHADOW_LIST.Next));

  case kSHADOW_EMPTY:
/* line 148 "TreeOps.puma" */
   return 0;

  case kSELECT_LIST:
/* line 152 "TreeOps.puma" */
   return (1 + TreeListLength (t->SELECT_LIST.Next));

  case kSELECT_EMPTY:
/* line 156 "TreeOps.puma" */
   return 0;

  }

/* line 160 "TreeOps.puma" */
  {
/* line 161 "TreeOps.puma" */
   failure_protocol ("Objects", "TreeListLength", t);
  }
   return 0;

}

tTree TreeListGet
# if defined __STDC__ | defined __cplusplus
(register tTree list, register int n)
# else
(list, n)
 register tTree list;
 register int n;
# endif
{
 yyRecursion:
/* line 173 "TreeOps.puma" */
  {
/* line 174 "TreeOps.puma" */
   if (! ((n <= 0))) goto yyL1;
  {
/* line 175 "TreeOps.puma" */
   failure_protocol ("Types", "TreeListGet (n<=0)", list);
  }
  }
   return list;
yyL1:;

  if (list->Kind == kSHAPE_LIST) {
  if (equalint (n, 1)) {
/* line 181 "TreeOps.puma" */
   return list->SHAPE_LIST.Elem;

  }
/* line 185 "TreeOps.puma" */
   list = list->SHAPE_LIST.Next;
   n = n - 1;
   goto yyRecursion;

  }
  if (list->Kind == kBTE_LIST) {
  if (equalint (n, 1)) {
/* line 189 "TreeOps.puma" */
   return list->BTE_LIST.Elem;

  }
/* line 193 "TreeOps.puma" */
   list = list->BTE_LIST.Next;
   n = n - 1;
   goto yyRecursion;

  }
/* line 197 "TreeOps.puma" */
  {
/* line 198 "TreeOps.puma" */
   failure_protocol (MODULE, "TreeListGet", list);
  }
   return list;

}

tIdent TreeVarName
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:

  switch (var->Kind) {
  case kVAR_OBJ:
/* line 210 "TreeOps.puma" */
   return var->VAR_OBJ.Ident;

  case kUSED_VAR:
/* line 214 "TreeOps.puma" */
   var = var->USED_VAR.VARNAME;
   goto yyRecursion;

  case kLOOP_VAR:
/* line 218 "TreeOps.puma" */
   var = var->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;

  case kVAR_PARAM:
/* line 222 "TreeOps.puma" */
   var = var->VAR_PARAM.V;
   goto yyRecursion;

  case kVAR_EXP:
/* line 226 "TreeOps.puma" */
   var = var->VAR_EXP.V;
   goto yyRecursion;

  case kSUBSTRING_VAR:
/* line 230 "TreeOps.puma" */
   var = var->SUBSTRING_VAR.IND_VAR;
   goto yyRecursion;

  case kINDEXED_VAR:
/* line 234 "TreeOps.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  case kSELECTED_VAR:
/* line 238 "TreeOps.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;

  case kREMOTE_VAR:
/* line 242 "TreeOps.puma" */
   var = var->REMOTE_VAR.VAR;
   goto yyRecursion;

  }

/* line 246 "TreeOps.puma" */
  {
/* line 247 "TreeOps.puma" */
   failure_protocol (MODULE, "TreeVarName", var);
  }
   return DefaultId ();

}

tIdent GetGenericId
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kID_GENERIC_SPEC) {
/* line 259 "TreeOps.puma" */
   return t->ID_GENERIC_SPEC.name;

  }
  if (t->Kind == kOP_GENERIC_SPEC) {
/* line 264 "TreeOps.puma" */
   return MakeOperatorId (t->OP_GENERIC_SPEC.OPERATOR);

  }
  if (t->Kind == kASSIGN_GENERIC_SPEC) {
/* line 269 "TreeOps.puma" */
   return MakeIdent ("=", 1);

  }
  if (t->Kind == kNO_GENERIC_SPEC) {
/* line 274 "TreeOps.puma" */
   return DefaultId ();

  }
/* line 279 "TreeOps.puma" */
  {
/* line 280 "TreeOps.puma" */
   failure_protocol (MODULE, "GetGenericId", t);
  }
   return DefaultId ();

}

tIdent MakeOperatorId
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kOP_EQ:
/* line 292 "TreeOps.puma" */
   return MakeIdent (".eq.", 4);

  case kOP_NE:
/* line 293 "TreeOps.puma" */
   return MakeIdent (".ne.", 4);

  case kOP_LE:
/* line 294 "TreeOps.puma" */
   return MakeIdent (".le.", 4);

  case kOP_LT:
/* line 295 "TreeOps.puma" */
   return MakeIdent (".lt.", 4);

  case kOP_GE:
/* line 296 "TreeOps.puma" */
   return MakeIdent (".ge.", 4);

  case kOP_GT:
/* line 297 "TreeOps.puma" */
   return MakeIdent (".gt.", 4);

  case kOP_PLUS:
/* line 299 "TreeOps.puma" */
   return MakeIdent ("+", 1);

  case kOP_MINUS:
/* line 300 "TreeOps.puma" */
   return MakeIdent ("-", 1);

  case kOP_OR:
/* line 301 "TreeOps.puma" */
   return MakeIdent (".or.", 4);

  case kOP_XOR:
/* line 302 "TreeOps.puma" */
   return MakeIdent (".xor.", 5);

  case kOP_CONCAT:
/* line 303 "TreeOps.puma" */
   return MakeIdent ("//", 2);

  case kOP_TIMES:
/* line 304 "TreeOps.puma" */
   return MakeIdent ("*", 1);

  case kOP_DIVIDE:
/* line 305 "TreeOps.puma" */
   return MakeIdent ("/", 1);

  case kOP_AND:
/* line 306 "TreeOps.puma" */
   return MakeIdent (".and.", 5);

  case kOP_EQV:
/* line 307 "TreeOps.puma" */
   return MakeIdent (".eqv.", 5);

  case kOP_NEQV:
/* line 308 "TreeOps.puma" */
   return MakeIdent (".neqv.", 6);

  case kOP_EXPO:
/* line 309 "TreeOps.puma" */
   return MakeIdent ("**", 2);

  case kOP1_NOT:
/* line 311 "TreeOps.puma" */
   return MakeIdent (".not.", 5);

  case kOP1_SIGN:
/* line 312 "TreeOps.puma" */
   return MakeIdent ("-", 1);

  case kOP1_PSIGN:
/* line 313 "TreeOps.puma" */
   return MakeIdent ("+", 1);

  case kOP_DEFINED:
/* line 315 "TreeOps.puma" */
   return t->OP_DEFINED.opname;

  }

/* line 317 "TreeOps.puma" */
  {
/* line 318 "TreeOps.puma" */
   failure_protocol (MODULE, "MakeOperatorId", t);
  }
   return DefaultId ();

}

rbool IsDeferredShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
/* line 337 "TreeOps.puma" */
  {
/* line 338 "TreeOps.puma" */
   if (! ((formals == NoTree))) goto yyL1;
  {
/* line 339 "TreeOps.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (formals->Kind == kSHAPE_EMPTY) {
/* line 342 "TreeOps.puma" */
   return rtrue;

  }
  if (formals->Kind == kSHAPE_LIST) {
/* line 345 "TreeOps.puma" */
  {
/* line 346 "TreeOps.puma" */
   if (! ((IsDeferredShape (formals->SHAPE_LIST.Elem)))) goto yyL3;
  {
/* line 347 "TreeOps.puma" */
   if (! ((IsDeferredShape (formals->SHAPE_LIST.Next)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  if (formals->Kind == kDEFERRED_SHAPE) {
/* line 350 "TreeOps.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsAssumedShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
/* line 359 "TreeOps.puma" */
  {
/* line 360 "TreeOps.puma" */
   if (! ((formals == NoTree))) goto yyL1;
  {
/* line 361 "TreeOps.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (formals->Kind == kSHAPE_EMPTY) {
/* line 364 "TreeOps.puma" */
   return rtrue;

  }
  if (formals->Kind == kSHAPE_LIST) {
/* line 367 "TreeOps.puma" */
  {
/* line 368 "TreeOps.puma" */
   if (! ((IsAssumedShape (formals->SHAPE_LIST.Elem)))) goto yyL3;
  {
/* line 369 "TreeOps.puma" */
   if (! ((IsAssumedShape (formals->SHAPE_LIST.Next)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  if (formals->Kind == kDEFERRED_SHAPE) {
/* line 372 "TreeOps.puma" */
   return rtrue;

  }
  if (formals->Kind == kASSUMED_SHAPE) {
/* line 375 "TreeOps.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsExplicitShape
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
/* line 384 "TreeOps.puma" */
  {
/* line 386 "TreeOps.puma" */
   if (! ((formals == NoTree))) goto yyL1;
  {
/* line 387 "TreeOps.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (formals->Kind == kSHAPE_EMPTY) {
/* line 390 "TreeOps.puma" */
   return rtrue;

  }
  if (formals->Kind == kSHAPE_LIST) {
/* line 393 "TreeOps.puma" */
  {
/* line 394 "TreeOps.puma" */
   if (! ((IsExplicitShape (formals->SHAPE_LIST.Elem)))) goto yyL3;
  {
/* line 395 "TreeOps.puma" */
   if (! ((IsExplicitShape (formals->SHAPE_LIST.Next)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  if (formals->Kind == kEXPLICIT_SHAPE) {
/* line 398 "TreeOps.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsAssumedSize
# if defined __STDC__ | defined __cplusplus
(register tTree formals)
# else
(formals)
 register tTree formals;
# endif
{
/* line 407 "TreeOps.puma" */
  {
/* line 408 "TreeOps.puma" */
   if (! ((formals == NoTree))) goto yyL1;
  {
/* line 409 "TreeOps.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (formals->Kind == kSHAPE_LIST) {
  if (formals->SHAPE_LIST.Elem->Kind == kASSUMED_SIZE) {
  if (formals->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
/* line 412 "TreeOps.puma" */
   return rtrue;

  }
  }
/* line 415 "TreeOps.puma" */
  {
/* line 417 "TreeOps.puma" */
   if (! ((IsExplicitShape (formals->SHAPE_LIST.Elem)))) goto yyL3;
  {
/* line 418 "TreeOps.puma" */
   if (! ((IsAssumedSize (formals->SHAPE_LIST.Next)))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

int IsVarInExp
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree exp)
# else
(name, exp)
 register tIdent name;
 register tTree exp;
# endif
{
 yyRecursion:
/* line 431 "TreeOps.puma" */
  {
/* line 433 "TreeOps.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  }
   return 0;
yyL1:;


  switch (exp->Kind) {
  case kVAR_OBJ:
/* line 437 "TreeOps.puma" */
  {
/* line 439 "TreeOps.puma" */
   if (! ((name == exp->VAR_OBJ.Ident))) goto yyL2;
  }
   return 1;
yyL2:;

/* line 443 "TreeOps.puma" */
   return 0;

  case kUSED_VAR:
/* line 448 "TreeOps.puma" */
   exp = exp->USED_VAR.VARNAME;
   goto yyRecursion;

  case kLOOP_VAR:
/* line 452 "TreeOps.puma" */
   exp = exp->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;

  case kINDEXED_VAR:
/* line 456 "TreeOps.puma" */
   return (IsVarInExp (name, exp->INDEXED_VAR.IND_VAR) + IsVarInExp (name, exp->INDEXED_VAR.IND_EXPS));

  case kSELECTED_VAR:
/* line 460 "TreeOps.puma" */
   exp = exp->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;

  case kSUBSTRING_VAR:
/* line 464 "TreeOps.puma" */
   return (IsVarInExp (name, exp->SUBSTRING_VAR.IND_VAR) + IsVarInExp (name, exp->SUBSTRING_VAR.IND_EXP));

  case kBTV_LIST:
/* line 468 "TreeOps.puma" */
   return (IsVarInExp (name, exp->BTV_LIST.Elem) + IsVarInExp (name, exp->BTV_LIST.Next));

  case kBTV_EMPTY:
/* line 472 "TreeOps.puma" */
   return 0;

  case kVAR_EXP:
/* line 476 "TreeOps.puma" */
   exp = exp->VAR_EXP.V;
   goto yyRecursion;

  case kBTE_LIST:
/* line 480 "TreeOps.puma" */
   return (IsVarInExp (name, exp->BTE_LIST.Elem) + IsVarInExp (name, exp->BTE_LIST.Next));

  case kBTE_EMPTY:
/* line 484 "TreeOps.puma" */
   return 0;

  case kSLICE_EXP:
/* line 488 "TreeOps.puma" */
   return (IsVarInExp (name, exp->SLICE_EXP.FIRST) + IsVarInExp (name, exp->SLICE_EXP.STOP) + IsVarInExp (name, exp->SLICE_EXP.INC));

  case kDUMMY_EXP:
/* line 493 "TreeOps.puma" */
   return 0;

  case kCONST_EXP:
/* line 497 "TreeOps.puma" */
   return 0;

  case kADDR:
/* line 501 "TreeOps.puma" */
   return (IsVarInExp (name, exp->ADDR.E));

  case kOP_EXP:
/* line 505 "TreeOps.puma" */
   return (IsVarInExp (name, exp->OP_EXP.OPND1) + IsVarInExp (name, exp->OP_EXP.OPND2));

  case kOP1_EXP:
/* line 509 "TreeOps.puma" */
   return (IsVarInExp (name, exp->OP1_EXP.OPND));

  case kDO_EXP:
/* line 513 "TreeOps.puma" */
   return IsVarInExp (name, exp->DO_EXP.BODY) + IsVarInExp (name, exp->DO_EXP.BODY);

  case kPERM_EXP:
/* line 517 "TreeOps.puma" */
   exp = exp->PERM_EXP.VAL;
   goto yyRecursion;

  case kARRAY_EXP:
/* line 521 "TreeOps.puma" */
   exp = exp->ARRAY_EXP.ELEMENTS;
   goto yyRecursion;

  case kTYPE_EXP:
/* line 525 "TreeOps.puma" */
   exp = exp->TYPE_EXP.ELEMENTS;
   goto yyRecursion;

  case kBOUND_EXP:
/* line 529 "TreeOps.puma" */
   return 0;

  case kRANK_EXP:
/* line 533 "TreeOps.puma" */
   return 0;

  case kFUNC_CALL_EXP:
/* line 537 "TreeOps.puma" */
   exp = exp->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;

  case kBTP_LIST:
/* line 541 "TreeOps.puma" */
   return (IsVarInExp (name, exp->BTP_LIST.Elem) + IsVarInExp (name, exp->BTP_LIST.Next));

  case kBTP_EMPTY:
/* line 545 "TreeOps.puma" */
   return 0;

  case kVAR_PARAM:
/* line 549 "TreeOps.puma" */
   return (IsVarInExp (name, exp->VAR_PARAM.V));

  case kNO_PARAM:
/* line 553 "TreeOps.puma" */
   return 0;

  case kFUNC_PARAM:
/* line 557 "TreeOps.puma" */
   return 0;

  case kPROC_PARAM:
/* line 561 "TreeOps.puma" */
   return 0;

  }

/* line 565 "TreeOps.puma" */
  {
/* line 566 "TreeOps.puma" */
   failure_protocol (MODULE, "IsVarInExp", exp);
  }
   return 0;

}

rbool IsForallLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_FORALL) {
/* line 578 "TreeOps.puma" */
   return rtrue;

  }
  return rfalse;
}

rbool IsIndepLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 583 "TreeOps.puma" */
   return rtrue;

  }
  }
  if (loop->Kind == kACF_FORALL) {
  if (loop->ACF_FORALL.FORALL_DEP_INFO->Kind == kINDEP_INFO) {
/* line 586 "TreeOps.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool IsIndepDoLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kACF_DO) {
  if (loop->ACF_DO.DO_DEP_INFO->Kind == kINDEP_INFO) {
/* line 591 "TreeOps.puma" */
   return rtrue;

  }
  }
  return rfalse;
}

rbool IsSelector
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kREC_COMP) {
/* line 596 "TreeOps.puma" */
   return rtrue;

  }
  return rfalse;
}

int GetLayout
# if defined __STDC__ | defined __cplusplus
(register rbool is_f77, register int model)
# else
(is_f77, model)
 register rbool is_f77;
 register int model;
# endif
{
/* line 607 "TreeOps.puma" */
  {
/* line 609 "TreeOps.puma" */
   if (! ((! is_f77))) goto yyL1;
  {
/* line 610 "TreeOps.puma" */
   if (! ((model == HPF_SERIAL))) goto yyL1;
  }
  }
   return kHPF_SERIAL_LAYOUT;
yyL1:;

/* line 615 "TreeOps.puma" */
  {
/* line 617 "TreeOps.puma" */
   if (! ((! is_f77))) goto yyL2;
  {
/* line 618 "TreeOps.puma" */
   if (! ((model == HPF_LOCAL))) goto yyL2;
  }
  }
   return kHPF_LOCAL_LAYOUT;
yyL2:;

/* line 623 "TreeOps.puma" */
  {
/* line 625 "TreeOps.puma" */
   if (! ((! is_f77))) goto yyL3;
  }
   return kHPF_GLOBAL_LAYOUT;
yyL3:;

/* line 632 "TreeOps.puma" */
  {
/* line 634 "TreeOps.puma" */
   if (! ((model == HPF_LOCAL))) goto yyL4;
  }
   return kF77_LOCAL_LAYOUT;
yyL4:;

/* line 640 "TreeOps.puma" */
   return kF77_SERIAL_LAYOUT;

}

int GeneralIndexListLength
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
/* line 653 "TreeOps.puma" */
  {
/* line 655 "TreeOps.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return 0;
yyL1:;

  if (t->Kind == kUSED_VAR) {
/* line 659 "TreeOps.puma" */
   return 0;

  }
  if (t->Kind == kLOOP_VAR) {
/* line 664 "TreeOps.puma" */
   return 0;

  }
  if (t->Kind == kSUBSTRING_VAR) {
/* line 669 "TreeOps.puma" */
   return 1;

  }
  if (t->Kind == kINDEXED_VAR) {
/* line 674 "TreeOps.puma" */
   return GeneralIndexListLength (t->INDEXED_VAR.IND_VAR) + TreeListLength (t->INDEXED_VAR.IND_EXPS);

  }
  if (t->Kind == kSELECTED_VAR) {
/* line 681 "TreeOps.puma" */
   return GeneralIndexListLength (t->SELECTED_VAR.SELEC_VAR) + 1;

  }
  if (t->Kind == kREMOTE_VAR) {
/* line 686 "TreeOps.puma" */
   t = t->REMOTE_VAR.VAR;
   goto yyRecursion;

  }
/* line 691 "TreeOps.puma" */
  {
/* line 693 "TreeOps.puma" */
   failure_protocol (MODULE, "GeneralIndexListLength (not var)", t);
  }
   return 0;

}

tDefinitions GetVarAccessObject
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kINDEXED_VAR) {
/* line 706 "TreeOps.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 711 "TreeOps.puma" */
   var = var->SUBSTRING_VAR.IND_VAR;
   goto yyRecursion;

  }
  if (var->Kind == kVAR_OBJ) {
/* line 716 "TreeOps.puma" */
   return var->VAR_OBJ.Object;

  }
  if (var->Kind == kUSED_VAR) {
/* line 721 "TreeOps.puma" */
   var = var->USED_VAR.VARNAME;
   goto yyRecursion;

  }
  if (var->Kind == kLOOP_VAR) {
/* line 726 "TreeOps.puma" */
   var = var->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 731 "TreeOps.puma" */
   return var->SELECTED_VAR.SELECTOR->REC_COMP.Object;

  }
/* line 736 "TreeOps.puma" */
   return NoObject;

}

tTree GetUsedVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kUSED_VAR) {
/* line 743 "TreeOps.puma" */
   return var;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 748 "TreeOps.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 753 "TreeOps.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;

  }
  if (var->Kind == kVAR_PARAM) {
/* line 758 "TreeOps.puma" */
   var = var->VAR_PARAM.V;
   goto yyRecursion;

  }
/* line 763 "TreeOps.puma" */
  {
/* line 765 "TreeOps.puma" */
   failure_protocol (MODULE, "GetUsedVar", var);
  }
   return NoTree;

}

void BeginTreeOps ARGS ((void))
{
}

void CloseTreeOps ARGS ((void))
{
}
