# include "Traverse.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 43 "Traverse.puma" */


# include <stdio.h>
# include "protocol.h"
# include "Tree.h"
# include "Idents.h"
# include "StringM.h"

# include "ArrayData.h"     /* SetActualOverlap */

# include "Transform.h"     /* ReplaceACF, ReplaceDECL */
# include "Nesting.h"

# define MODULE "Traverse"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTraverse.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Traverse_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Traverse, routine %s failed\n",
  yyFunction);
 Traverse_Exit ();
}

static rbool IsUnitDecl ARGS ((tTree t));
void FullTraverseAST ARGS ((tTree t, UserSubroutine visit));
static rbool FalsePredicate ARGS ((tTree t));
void TraverseAST ARGS ((tTree t, UserPredicate pred, UserSubroutine visit));
tTree ReplaceAST ARGS ((tTree t, UserPredicate pred, UserFunction visit));
static void SetStatement ARGS ((tTree t));

static rbool IsUnitDecl
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kFUNC_DECL) {
/* line 68 "Traverse.puma" */
   return rtrue;

  }
  if (t->Kind == kPROC_DECL) {
/* line 69 "Traverse.puma" */
   return rtrue;

  }
  if (t->Kind == kMODULE_DECL) {
/* line 70 "Traverse.puma" */
   return rtrue;

  }
  if (t->Kind == kBLOCK_DATA_DECL) {
/* line 71 "Traverse.puma" */
   return rtrue;

  }
  if (t->Kind == kPROGRAM_DECL) {
/* line 72 "Traverse.puma" */
   return rtrue;

  }
  return rfalse;
}

void FullTraverseAST
# if defined __STDC__ | defined __cplusplus
(register tTree t, UserSubroutine visit)
# else
(t, visit)
 register tTree t;
 UserSubroutine visit;
# endif
{
/* line 84 "Traverse.puma" */
  {
/* line 86 "Traverse.puma" */
   TraverseAST (t, FalsePredicate, visit);
  }
   return;

;
}

static rbool FalsePredicate
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  return rfalse;
}

void TraverseAST
# if defined __STDC__ | defined __cplusplus
(register tTree t, UserPredicate pred, UserSubroutine visit)
# else
(t, pred, visit)
 register tTree t;
 UserPredicate pred;
 UserSubroutine visit;
# endif
{
 yyRecursion:
/* line 102 "Traverse.puma" */
  {
/* line 103 "Traverse.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return;
yyL1:;

/* line 106 "Traverse.puma" */
  {
/* line 108 "Traverse.puma" */
 if (IsUnitDecl (t)) NestOpenUnit (t); 
/* line 110 "Traverse.puma" */
   visit (t);
/* line 111 "Traverse.puma" */
   goto yyL2;
  }
yyL2:;

/* line 114 "Traverse.puma" */
  {
/* line 116 "Traverse.puma" */
   if (! ((pred (t)))) goto yyL3;
  {
/* line 118 "Traverse.puma" */
 if (IsUnitDecl (t)) NestCloseUnit (t); 
  }
  }
   return;
yyL3:;


  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 127 "Traverse.puma" */
  {
/* line 129 "Traverse.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_LIST:
/* line 132 "Traverse.puma" */
  {
/* line 134 "Traverse.puma" */
   TraverseAST (t->UNIT_LIST.Elem, pred, visit);
/* line 135 "Traverse.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 138 "Traverse.puma" */
   return;

  case kPROGRAM_DECL:
/* line 141 "Traverse.puma" */
  {
/* line 143 "Traverse.puma" */
   TraverseAST (t->PROGRAM_DECL.PROGRAM_BODY, pred, visit);
/* line 144 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 147 "Traverse.puma" */
  {
/* line 149 "Traverse.puma" */
   TraverseAST (t->PROC_DECL.PROC_BODY, pred, visit);
/* line 150 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 153 "Traverse.puma" */
  {
/* line 155 "Traverse.puma" */
   TraverseAST (t->FUNC_DECL.FUNC_BODY, pred, visit);
/* line 156 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 159 "Traverse.puma" */
  {
/* line 161 "Traverse.puma" */
   TraverseAST (t->BLOCK_DATA_DECL.DATA_BODY, pred, visit);
/* line 162 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 165 "Traverse.puma" */
  {
/* line 167 "Traverse.puma" */
   TraverseAST (t->MODULE_DECL.MODULE_BODY, pred, visit);
/* line 168 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_PROC_DECL:
/* line 171 "Traverse.puma" */
   return;

  case kBODY_NODE:
/* line 180 "Traverse.puma" */
  {
/* line 182 "Traverse.puma" */
   TraverseAST (t->BODY_NODE.DECLS, pred, visit);
/* line 183 "Traverse.puma" */
   TraverseAST (t->BODY_NODE.NEW_DECLS, pred, visit);
/* line 184 "Traverse.puma" */
   TraverseAST (t->BODY_NODE.STATS, pred, visit);
/* line 185 "Traverse.puma" */
   t = t->BODY_NODE.INTERNALS;
   goto yyRecursion;
  }

  case kDECL_LIST:
/* line 194 "Traverse.puma" */
  {
/* line 196 "Traverse.puma" */
   set_protocol_stmt (t->DECL_LIST.Elem);
/* line 197 "Traverse.puma" */
   TraverseAST (t->DECL_LIST.Elem, pred, visit);
/* line 198 "Traverse.puma" */
   t = t->DECL_LIST.Next;
   goto yyRecursion;
  }

  case kDECL_EMPTY:
/* line 201 "Traverse.puma" */
   return;

  case kVAR_DECL:
/* line 204 "Traverse.puma" */
  {
/* line 206 "Traverse.puma" */
   t = t->VAR_DECL.VAL;
   goto yyRecursion;
  }

  case kTYPE_DECL:
/* line 209 "Traverse.puma" */
  {
/* line 211 "Traverse.puma" */
   t = t->TYPE_DECL.VAL;
   goto yyRecursion;
  }

  case kINTERFACE_DECL:
/* line 214 "Traverse.puma" */
  {
/* line 216 "Traverse.puma" */
   t = t->INTERFACE_DECL.ITEMS;
   goto yyRecursion;
  }

  case kDECL_NODE:
  case kNAME_DECL:
  case kRENAME_DECL:
  case kENTITY_DECL:
  case kCOMMON_DECL:
  case kNAMELIST_DECL:
  case kTEMPLATE_DECL:
  case kRAGGED_DECL:
  case kPROCESSORS_DECL:
  case kSUB_PROCS_DECL:
  case kINHERIT_DECL:
  case kRANGE_DECL:
  case kSTMT_FUNC_DECL:
  case kVAR_PARAM_DECL:
  case kRET_PARAM_DECL:
  case kIMPLICIT_DECL:
  case kUSE_DECL:
  case kONLY_USE_DECL:
  case kEQV_DECL:
  case kDATA_DECL:
  case kFORMAT_DECL:
  case kDIMENSION_DECL:
  case kINIT_DATA_DECL:
  case kTYPESPEC_DECL:
  case kALLOCATABLE_DECL:
  case kEXTERNAL_DECL:
  case kINTENT_DECL:
  case kINTRINSIC_DECL:
  case kOPTIONAL_DECL:
  case kPOINTER_DECL:
  case kSAVE_DECL:
  case kTARGET_DECL:
  case kPARAMETER_DECL:
  case kPUBLIC_DECL:
  case kPRIVATE_DECL:
  case kSEQUENCE_DECL:
  case kDISTRIBUTE_DECL:
  case kALIGN_DECL:
  case kSHADOW_DECL:
  case kSHARED_DECL:
  case kDYNAMIC_DECL:
  case kTRACE_DECL:
  case kTREE_DECL:
  case kNODSP_DECL:
  case kSELECT_DECL:
  case kHPF_SEQUENCE_DECL:
  case kNOSEQUENCE_DECL:
  case kLAYOUT_DECL:
  case kPASS_BY_DECL:
  case kMAP_TO_DECL:
/* line 219 "Traverse.puma" */
   return;

  case kARRAY_TYPE:
/* line 228 "Traverse.puma" */
  {
/* line 230 "Traverse.puma" */
   TraverseAST (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, pred, visit);
/* line 231 "Traverse.puma" */
   t = t->ARRAY_TYPE.ARRAY_COMP_TYPE;
   goto yyRecursion;
  }

  case kSHAPE_LIST:
/* line 240 "Traverse.puma" */
  {
/* line 242 "Traverse.puma" */
   TraverseAST (t->SHAPE_LIST.Elem, pred, visit);
/* line 243 "Traverse.puma" */
   t = t->SHAPE_LIST.Next;
   goto yyRecursion;
  }

  case kSHAPE_EMPTY:
/* line 246 "Traverse.puma" */
   return;

  case kEXPLICIT_SHAPE:
/* line 249 "Traverse.puma" */
  {
/* line 251 "Traverse.puma" */
   TraverseAST (t->EXPLICIT_SHAPE.LOWER, pred, visit);
/* line 252 "Traverse.puma" */
   t = t->EXPLICIT_SHAPE.UPPER;
   goto yyRecursion;
  }

  case kSHAPE_SPEC:
  case kASSUMED_SHAPE:
  case kDEFERRED_SHAPE:
  case kASSUMED_SIZE:
/* line 255 "Traverse.puma" */
   return;

  case kRECORD_TYPE:
/* line 258 "Traverse.puma" */
  {
/* line 260 "Traverse.puma" */
   NestOpenType (t);
/* line 261 "Traverse.puma" */
   TraverseAST (t->RECORD_TYPE.COMPONENTS, pred, visit);
/* line 262 "Traverse.puma" */
   NestCloseType (t);
  }
   return;

  case kTYPE_NODE:
  case kDUMMY_TYPE:
  case kALIGN_TYPE:
  case kINTEGER_TYPE:
  case kREAL_TYPE:
  case kBOOLEAN_TYPE:
  case kCOMPLEX_TYPE:
  case kSTRING_TYPE:
  case kTYPE_ID:
/* line 265 "Traverse.puma" */
   return;

  case kACF_LIST:
/* line 274 "Traverse.puma" */
  {
/* line 276 "Traverse.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 277 "Traverse.puma" */
   TraverseAST (t->ACF_LIST.Elem, pred, visit);
/* line 278 "Traverse.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 281 "Traverse.puma" */
   return;

  case kACF_BASIC:
/* line 284 "Traverse.puma" */
  {
/* line 286 "Traverse.puma" */
   t = t->ACF_BASIC.BASIC_STMT;
   goto yyRecursion;
  }

  case kACF_DUMMY:
/* line 289 "Traverse.puma" */
   return;

  case kACF_LOOP:
/* line 292 "Traverse.puma" */
  {
/* line 294 "Traverse.puma" */
   t = t->ACF_LOOP.LOOP_BODY;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 297 "Traverse.puma" */
  {
/* line 299 "Traverse.puma" */
   TraverseAST (t->ACF_WHILE.WHILE_EXP, pred, visit);
/* line 300 "Traverse.puma" */
   t = t->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;
  }

  case kACF_DO:
/* line 303 "Traverse.puma" */
  {
/* line 305 "Traverse.puma" */
   TraverseAST (t->ACF_DO.DO_ID, pred, visit);
/* line 306 "Traverse.puma" */
   TraverseAST (t->ACF_DO.DO_RANGE, pred, visit);
/* line 307 "Traverse.puma" */
   TraverseAST (t->ACF_DO.DO_BODY, pred, visit);
/* line 308 "Traverse.puma" */
   TraverseAST (t->ACF_DO.DO_DEP_INFO, pred, visit);
/* line 309 "Traverse.puma" */
   t = t->ACF_DO.DO_HOME_INFO;
   goto yyRecursion;
  }

  case kACF_FORALL:
/* line 312 "Traverse.puma" */
  {
/* line 314 "Traverse.puma" */
   TraverseAST (t->ACF_FORALL.FORALL_ID, pred, visit);
/* line 315 "Traverse.puma" */
   TraverseAST (t->ACF_FORALL.FORALL_RANGE, pred, visit);
/* line 316 "Traverse.puma" */
   TraverseAST (t->ACF_FORALL.FORALL_BODY, pred, visit);
/* line 317 "Traverse.puma" */
   TraverseAST (t->ACF_FORALL.FORALL_DEP_INFO, pred, visit);
/* line 318 "Traverse.puma" */
   t = t->ACF_FORALL.FORALL_HOME_INFO;
   goto yyRecursion;
  }

  case kACF_IF:
/* line 321 "Traverse.puma" */
  {
/* line 323 "Traverse.puma" */
   TraverseAST (t->ACF_IF.IF_EXP, pred, visit);
/* line 324 "Traverse.puma" */
   TraverseAST (t->ACF_IF.THEN_PART, pred, visit);
/* line 325 "Traverse.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_WHERE:
/* line 328 "Traverse.puma" */
  {
/* line 330 "Traverse.puma" */
   TraverseAST (t->ACF_WHERE.WHERE_EXP, pred, visit);
/* line 331 "Traverse.puma" */
   TraverseAST (t->ACF_WHERE.TRUE_PART, pred, visit);
/* line 332 "Traverse.puma" */
   t = t->ACF_WHERE.FALSE_PART;
   goto yyRecursion;
  }

  case kACF_HOME:
/* line 335 "Traverse.puma" */
  {
/* line 337 "Traverse.puma" */
   TraverseAST (t->ACF_HOME.HOME_VAR, pred, visit);
/* line 338 "Traverse.puma" */
   t = t->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  case kACF_RESIDENT:
/* line 341 "Traverse.puma" */
  {
/* line 343 "Traverse.puma" */
   TraverseAST (t->ACF_RESIDENT.RESIDENT_VAR, pred, visit);
/* line 344 "Traverse.puma" */
   t = t->ACF_RESIDENT.RESIDENT_BODY;
   goto yyRecursion;
  }

  case kACF_PARALLEL:
/* line 347 "Traverse.puma" */
  {
/* line 349 "Traverse.puma" */
   TraverseAST (t->ACF_PARALLEL.REDUCTION_VARS, pred, visit);
/* line 350 "Traverse.puma" */
   TraverseAST (t->ACF_PARALLEL.SHARED_VARS, pred, visit);
/* line 351 "Traverse.puma" */
   TraverseAST (t->ACF_PARALLEL.LOCAL_VARS, pred, visit);
/* line 352 "Traverse.puma" */
   t = t->ACF_PARALLEL.PARALLEL_BODY;
   goto yyRecursion;
  }

  case kACF_CRITICAL:
/* line 355 "Traverse.puma" */
  {
/* line 357 "Traverse.puma" */
   t = t->ACF_CRITICAL.CRITICAL_BODY;
   goto yyRecursion;
  }

  case kACF_NEW:
/* line 360 "Traverse.puma" */
  {
/* line 363 "Traverse.puma" */
   t = t->ACF_NEW.NEW_BODY;
   goto yyRecursion;
  }

  case kACF_REDUCTION:
/* line 366 "Traverse.puma" */
  {
/* line 369 "Traverse.puma" */
   TraverseAST (t->ACF_REDUCTION.REDUCTION_VAR, pred, visit);
/* line 370 "Traverse.puma" */
   t = t->ACF_REDUCTION.REDUCTION_BODY;
   goto yyRecursion;
  }

  case kACF_BARRIER:
/* line 373 "Traverse.puma" */
   return;

  case kON_PROC_CLAUSE:
/* line 376 "Traverse.puma" */
  {
/* line 378 "Traverse.puma" */
   t = t->ON_PROC_CLAUSE.ON_PROC;
   goto yyRecursion;
  }

  case kON_VAR_CLAUSE:
/* line 381 "Traverse.puma" */
  {
/* line 383 "Traverse.puma" */
   t = t->ON_VAR_CLAUSE.ON_VAR;
   goto yyRecursion;
  }

  case kON_ALL_CLAUSE:
/* line 386 "Traverse.puma" */
   return;

  case kON_HOST_CLAUSE:
/* line 389 "Traverse.puma" */
   return;

  case kACF_ON:
/* line 392 "Traverse.puma" */
  {
/* line 394 "Traverse.puma" */
   t = t->ACF_ON.ON_BODY;
   goto yyRecursion;
  }

  case kACF_TASK_REGION:
/* line 397 "Traverse.puma" */
  {
/* line 399 "Traverse.puma" */
   t = t->ACF_TASK_REGION.TASK_BODY;
   goto yyRecursion;
  }

  case kACF_MOVE:
/* line 402 "Traverse.puma" */
  {
/* line 404 "Traverse.puma" */
   t = t->ACF_MOVE.MOVE_STMT;
   goto yyRecursion;
  }

  case kACF_CASE:
/* line 407 "Traverse.puma" */
  {
/* line 409 "Traverse.puma" */
   TraverseAST (t->ACF_CASE.CASE_EXP, pred, visit);
/* line 410 "Traverse.puma" */
   t = t->ACF_CASE.CASE_ALTS;
   goto yyRecursion;
  }

  case kSELECTED_ACF_LIST:
/* line 419 "Traverse.puma" */
  {
/* line 421 "Traverse.puma" */
   TraverseAST (t->SELECTED_ACF_LIST.Elem, pred, visit);
/* line 422 "Traverse.puma" */
   t = t->SELECTED_ACF_LIST.Next;
   goto yyRecursion;
  }

  case kSELECTED_ACF_EMPTY:
/* line 425 "Traverse.puma" */
   return;

  case kSELECTED_ACF_NODE:
/* line 428 "Traverse.puma" */
  {
/* line 430 "Traverse.puma" */
   TraverseAST (t->SELECTED_ACF_NODE.SELECT_LIST, pred, visit);
/* line 431 "Traverse.puma" */
   t = t->SELECTED_ACF_NODE.SELECT_ACFS;
   goto yyRecursion;
  }

  case kASSIGN_STMT:
/* line 440 "Traverse.puma" */
  {
/* line 442 "Traverse.puma" */
   TraverseAST (t->ASSIGN_STMT.ASSIGN_VAR, pred, visit);
/* line 443 "Traverse.puma" */
   t = t->ASSIGN_STMT.ASSIGN_EXP;
   goto yyRecursion;
  }

  case kPTR_ASSIGN_STMT:
/* line 446 "Traverse.puma" */
  {
/* line 448 "Traverse.puma" */
   TraverseAST (t->PTR_ASSIGN_STMT.ASSIGN_VAR, pred, visit);
/* line 449 "Traverse.puma" */
   t = t->PTR_ASSIGN_STMT.ASSIGN_EXP;
   goto yyRecursion;
  }

  case kLABEL_ASSIGN_STMT:
/* line 452 "Traverse.puma" */
  {
/* line 454 "Traverse.puma" */
   t = t->LABEL_ASSIGN_STMT.LABEL_VAR;
   goto yyRecursion;
  }

  case kFORMAT_STMT:
/* line 457 "Traverse.puma" */
   return;

  case kCALL_STMT:
/* line 460 "Traverse.puma" */
  {
/* line 462 "Traverse.puma" */
   t = t->CALL_STMT.CALL_PARAMS;
   goto yyRecursion;
  }

  case kMOVE_STMT:
/* line 465 "Traverse.puma" */
  {
/* line 467 "Traverse.puma" */
   TraverseAST (t->MOVE_STMT.TARGET, pred, visit);
/* line 468 "Traverse.puma" */
   TraverseAST (t->MOVE_STMT.SOURCE, pred, visit);
/* line 469 "Traverse.puma" */
   t = t->MOVE_STMT.MASK;
   goto yyRecursion;
  }

  case kSCATTER_STMT:
/* line 472 "Traverse.puma" */
  {
/* line 474 "Traverse.puma" */
   TraverseAST (t->SCATTER_STMT.BASE, pred, visit);
/* line 475 "Traverse.puma" */
   TraverseAST (t->SCATTER_STMT.ARRAY, pred, visit);
/* line 476 "Traverse.puma" */
   TraverseAST (t->SCATTER_STMT.INDEXES, pred, visit);
/* line 477 "Traverse.puma" */
   t = t->SCATTER_STMT.MASK;
   goto yyRecursion;
  }

  case kREDUCTION_STMT:
/* line 480 "Traverse.puma" */
  {
/* line 482 "Traverse.puma" */
   t = t->REDUCTION_STMT.ELEMS;
   goto yyRecursion;
  }

  case kBROADCAST_STMT:
/* line 485 "Traverse.puma" */
  {
/* line 487 "Traverse.puma" */
   t = t->BROADCAST_STMT.ELEMS;
   goto yyRecursion;
  }

  case kGOTO_STMT:
/* line 490 "Traverse.puma" */
   return;

  case kASS_GOTO_STMT:
/* line 493 "Traverse.puma" */
  {
/* line 495 "Traverse.puma" */
   TraverseAST (t->ASS_GOTO_STMT.GOTO_VAR, pred, visit);
/* line 496 "Traverse.puma" */
   t = t->ASS_GOTO_STMT.LABELS;
   goto yyRecursion;
  }

  case kCOMP_GOTO_STMT:
/* line 499 "Traverse.puma" */
  {
/* line 501 "Traverse.puma" */
   TraverseAST (t->COMP_GOTO_STMT.GOTO_LABELS, pred, visit);
/* line 502 "Traverse.puma" */
   t = t->COMP_GOTO_STMT.GOTO_EXP;
   goto yyRecursion;
  }

  case kIO_STMT:
/* line 505 "Traverse.puma" */
  {
/* line 507 "Traverse.puma" */
   TraverseAST (t->IO_STMT.IO_SPECS, pred, visit);
/* line 508 "Traverse.puma" */
   t = t->IO_STMT.IO_ITEMS;
   goto yyRecursion;
  }

  case kCOMP_IF_STMT:
/* line 511 "Traverse.puma" */
  {
/* line 513 "Traverse.puma" */
   t = t->COMP_IF_STMT.IF_EXP;
   goto yyRecursion;
  }

  case kSTOP_STMT:
/* line 516 "Traverse.puma" */
   return;

  case kPAUSE_STMT:
/* line 519 "Traverse.puma" */
   return;

  case kEXIT_STMT:
/* line 522 "Traverse.puma" */
   return;

  case kCYCLE_STMT:
/* line 525 "Traverse.puma" */
   return;

  case kRETURN_STMT:
/* line 528 "Traverse.puma" */
  {
/* line 530 "Traverse.puma" */
   t = t->RETURN_STMT.RETURN_EXP;
   goto yyRecursion;
  }

  case kREDUCE_STMT:
/* line 533 "Traverse.puma" */
  {
/* line 535 "Traverse.puma" */
   t = t->REDUCE_STMT.RED_PARAMS;
   goto yyRecursion;
  }

  case kALLOCATE_STMT:
/* line 538 "Traverse.puma" */
  {
/* line 540 "Traverse.puma" */
   TraverseAST (t->ALLOCATE_STMT.PARAMS, pred, visit);
/* line 541 "Traverse.puma" */
   t = t->ALLOCATE_STMT.STATUS;
   goto yyRecursion;
  }

  case kDEALLOCATE_STMT:
/* line 544 "Traverse.puma" */
  {
/* line 546 "Traverse.puma" */
   TraverseAST (t->DEALLOCATE_STMT.PARAMS, pred, visit);
/* line 547 "Traverse.puma" */
   t = t->DEALLOCATE_STMT.STATUS;
   goto yyRecursion;
  }

  case kACCESS_STMT:
/* line 550 "Traverse.puma" */
  {
/* line 552 "Traverse.puma" */
   t = t->ACCESS_STMT.VAR;
   goto yyRecursion;
  }

  case kCREATE_DSP_STMT:
/* line 555 "Traverse.puma" */
  {
/* line 557 "Traverse.puma" */
   t = t->CREATE_DSP_STMT.VAR;
   goto yyRecursion;
  }

  case kINHERIT_DSP_STMT:
/* line 561 "Traverse.puma" */
  {
/* line 563 "Traverse.puma" */
   t = t->INHERIT_DSP_STMT.VAR;
   goto yyRecursion;
  }

  case kFREE_DSP_STMT:
/* line 566 "Traverse.puma" */
  {
/* line 568 "Traverse.puma" */
   t = t->FREE_DSP_STMT.VAR;
   goto yyRecursion;
  }

  case kREG_SHADOW_GET:
/* line 571 "Traverse.puma" */
  {
/* line 573 "Traverse.puma" */
   SetActualOverlap (t);
/* line 575 "Traverse.puma" */
   t = t->REG_SHADOW_GET.SHADOW_VAR;
   goto yyRecursion;
  }

  case kIND_SHADOW_CREATE:
/* line 578 "Traverse.puma" */
   return;

  case kIND_SHADOW_GET:
/* line 581 "Traverse.puma" */
   return;

  case kIND_SHADOW_PUT:
/* line 584 "Traverse.puma" */
   return;

  case kIND_SHADOW_SET:
/* line 587 "Traverse.puma" */
   return;

  case kIND_SHADOW_FREE:
/* line 590 "Traverse.puma" */
  {
/* line 592 "Traverse.puma" */
   t = t->IND_SHADOW_FREE.INDEX_VAR;
   goto yyRecursion;
  }

  case kDIRTY_STMT:
/* line 595 "Traverse.puma" */
  {
/* line 597 "Traverse.puma" */
   t = t->DIRTY_STMT.ELEMS;
   goto yyRecursion;
  }

  case kNULLIFY_STMT:
/* line 600 "Traverse.puma" */
  {
/* line 602 "Traverse.puma" */
   t = t->NULLIFY_STMT.PARAMS;
   goto yyRecursion;
  }

  case kREALIGN_STMT:
/* line 605 "Traverse.puma" */
   return;

  case kREDISTRIBUTE_STMT:
/* line 608 "Traverse.puma" */
   return;

  case kDUMMY_EXP:
/* line 618 "Traverse.puma" */
   return;

  case kCONST_EXP:
/* line 621 "Traverse.puma" */
   return;

  case kARRAY_EXP:
/* line 624 "Traverse.puma" */
  {
/* line 626 "Traverse.puma" */
   t = t->ARRAY_EXP.ELEMENTS;
   goto yyRecursion;
  }

  case kBOUND_EXP:
/* line 629 "Traverse.puma" */
  {
/* line 631 "Traverse.puma" */
   t = t->BOUND_EXP.VAR;
   goto yyRecursion;
  }

  case kRANK_EXP:
/* line 634 "Traverse.puma" */
   return;

  case kSIZE_EXP:
/* line 637 "Traverse.puma" */
   return;

  case kSLICE_EXP:
/* line 640 "Traverse.puma" */
  {
/* line 642 "Traverse.puma" */
   TraverseAST (t->SLICE_EXP.FIRST, pred, visit);
/* line 643 "Traverse.puma" */
   TraverseAST (t->SLICE_EXP.STOP, pred, visit);
/* line 644 "Traverse.puma" */
   t = t->SLICE_EXP.INC;
   goto yyRecursion;
  }

  case kOP_EXP:
/* line 647 "Traverse.puma" */
  {
/* line 649 "Traverse.puma" */
   TraverseAST (t->OP_EXP.OPND1, pred, visit);
/* line 650 "Traverse.puma" */
   t = t->OP_EXP.OPND2;
   goto yyRecursion;
  }

  case kOP1_EXP:
/* line 653 "Traverse.puma" */
  {
/* line 655 "Traverse.puma" */
   t = t->OP1_EXP.OPND;
   goto yyRecursion;
  }

  case kTYPE_EXP:
/* line 658 "Traverse.puma" */
  {
/* line 660 "Traverse.puma" */
   t = t->TYPE_EXP.ELEMENTS;
   goto yyRecursion;
  }

  case kPERM_EXP:
/* line 663 "Traverse.puma" */
  {
/* line 665 "Traverse.puma" */
   t = t->PERM_EXP.VAL;
   goto yyRecursion;
  }

  case kVAR_EXP:
/* line 668 "Traverse.puma" */
  {
/* line 670 "Traverse.puma" */
   t = t->VAR_EXP.V;
   goto yyRecursion;
  }

  case kDO_EXP:
/* line 673 "Traverse.puma" */
  {
/* line 675 "Traverse.puma" */
   TraverseAST (t->DO_EXP.DO_ID, pred, visit);
/* line 676 "Traverse.puma" */
   TraverseAST (t->DO_EXP.RANGE, pred, visit);
/* line 677 "Traverse.puma" */
   t = t->DO_EXP.BODY;
   goto yyRecursion;
  }

  case kFUNC_CALL_EXP:
/* line 680 "Traverse.puma" */
  {
/* line 682 "Traverse.puma" */
   t = t->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;
  }

  case kBTE_LIST:
/* line 691 "Traverse.puma" */
  {
/* line 693 "Traverse.puma" */
   TraverseAST (t->BTE_LIST.Elem, pred, visit);
/* line 694 "Traverse.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  case kBTE_EMPTY:
/* line 697 "Traverse.puma" */
   return;

  case kVAR_OBJ:
/* line 706 "Traverse.puma" */
   return;

  case kUSED_VAR:
/* line 709 "Traverse.puma" */
  {
/* line 711 "Traverse.puma" */
   t = t->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  case kLOOP_VAR:
/* line 714 "Traverse.puma" */
  {
/* line 716 "Traverse.puma" */
   t = t->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;
  }

  case kDUMMY_VAR:
/* line 719 "Traverse.puma" */
   return;

  case kREMOTE_VAR:
/* line 722 "Traverse.puma" */
  {
/* line 724 "Traverse.puma" */
   t = t->REMOTE_VAR.VAR;
   goto yyRecursion;
  }

  case kSELECTED_VAR:
/* line 727 "Traverse.puma" */
  {
/* line 729 "Traverse.puma" */
   t = t->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }

  case kSUBSTRING_VAR:
/* line 732 "Traverse.puma" */
  {
/* line 734 "Traverse.puma" */
   TraverseAST (t->SUBSTRING_VAR.IND_VAR, pred, visit);
/* line 735 "Traverse.puma" */
   t = t->SUBSTRING_VAR.IND_EXP;
   goto yyRecursion;
  }

  case kINDEXED_VAR:
/* line 738 "Traverse.puma" */
  {
/* line 740 "Traverse.puma" */
   TraverseAST (t->INDEXED_VAR.IND_VAR, pred, visit);
/* line 741 "Traverse.puma" */
   t = t->INDEXED_VAR.IND_EXPS;
   goto yyRecursion;
  }

  case kDO_VAR:
/* line 744 "Traverse.puma" */
  {
/* line 746 "Traverse.puma" */
   TraverseAST (t->DO_VAR.DO_ID, pred, visit);
/* line 747 "Traverse.puma" */
   TraverseAST (t->DO_VAR.RANGE, pred, visit);
/* line 748 "Traverse.puma" */
   t = t->DO_VAR.BODY;
   goto yyRecursion;
  }

  case kPERM_VAR:
/* line 751 "Traverse.puma" */
  {
/* line 753 "Traverse.puma" */
   t = t->PERM_VAR.VAL;
   goto yyRecursion;
  }

  case kADDR:
/* line 756 "Traverse.puma" */
  {
/* line 758 "Traverse.puma" */
   t = t->ADDR.E;
   goto yyRecursion;
  }

  case kBTV_LIST:
/* line 767 "Traverse.puma" */
  {
/* line 769 "Traverse.puma" */
   TraverseAST (t->BTV_LIST.Elem, pred, visit);
/* line 770 "Traverse.puma" */
   t = t->BTV_LIST.Next;
   goto yyRecursion;
  }

  case kBTV_EMPTY:
/* line 773 "Traverse.puma" */
   return;

  case kBTP_LIST:
/* line 782 "Traverse.puma" */
  {
/* line 784 "Traverse.puma" */
   TraverseAST (t->BTP_LIST.Elem, pred, visit);
/* line 785 "Traverse.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  case kBTP_EMPTY:
/* line 788 "Traverse.puma" */
   return;

  case kVAR_PARAM:
/* line 791 "Traverse.puma" */
  {
/* line 793 "Traverse.puma" */
   t = t->VAR_PARAM.V;
   goto yyRecursion;
  }

  case kNO_PARAM:
/* line 796 "Traverse.puma" */
   return;

  case kNAMED_PARAM:
/* line 799 "Traverse.puma" */
  {
/* line 801 "Traverse.puma" */
   t = t->NAMED_PARAM.VAL;
   goto yyRecursion;
  }

  case kFUNC_PARAM:
/* line 804 "Traverse.puma" */
   return;

  case kPROC_PARAM:
/* line 807 "Traverse.puma" */
   return;

  case kLABEL_LIST:
/* line 816 "Traverse.puma" */
  {
/* line 818 "Traverse.puma" */
   t = t->LABEL_LIST.Next;
   goto yyRecursion;
  }

  case kLABEL_EMPTY:
/* line 821 "Traverse.puma" */
   return;

  case kSERIAL_INFO:
/* line 830 "Traverse.puma" */
   return;

  case kVECTOR_INFO:
/* line 833 "Traverse.puma" */
   return;

  case kPARDO_INFO:
/* line 836 "Traverse.puma" */
   return;

  case kINDEP_INFO:
/* line 839 "Traverse.puma" */
   return;

  case kNO_HOME_INFO:
/* line 848 "Traverse.puma" */
   return;

  case kCOMM_INFO:
/* line 851 "Traverse.puma" */
  {
/* line 853 "Traverse.puma" */
 if (t->COMM_INFO.home_var != NoTree) TraverseAST (t->COMM_INFO.home_var, pred, visit); 
  }
   return;

  case kON_INFO:
/* line 856 "Traverse.puma" */
   return;

  case kDEFAULT_PROCESSOR_ARRAY:
/* line 865 "Traverse.puma" */
   return;

  case kANY_PROCESSOR_ARRAY:
/* line 868 "Traverse.puma" */
   return;

  case kPROCESSOR_ARRAY:
/* line 871 "Traverse.puma" */
   return;

  case kPROCESSOR_SUBSET:
/* line 874 "Traverse.puma" */
  {
/* line 876 "Traverse.puma" */
   t = t->PROCESSOR_SUBSET.SUBSCRIPTS;
   goto yyRecursion;
  }

  }

/* line 879 "Traverse.puma" */
  {
/* line 881 "Traverse.puma" */
   failure_protocol (MODULE, "TraverseAST", t);
  }
   return;

;
}

tTree ReplaceAST
# if defined __STDC__ | defined __cplusplus
(register tTree t, UserPredicate pred, UserFunction visit)
# else
(t, pred, visit)
 register tTree t;
 UserPredicate pred;
 UserFunction visit;
# endif
{
/* line 902 "Traverse.puma" */
  {
/* line 904 "Traverse.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return t;
yyL1:;

/* line 910 "Traverse.puma" */
  {
/* line 912 "Traverse.puma" */
   if (! ((pred (t)))) goto yyL2;
  {
/* line 914 "Traverse.puma" */
   SetStatement (t);
  }
  }
   return visit (t);
yyL2:;


  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 925 "Traverse.puma" */
  {
/* line 927 "Traverse.puma" */
 t->COMP_UNIT.COMP_ELEMENTS = ReplaceAST (t->COMP_UNIT.COMP_ELEMENTS, pred, visit); 
  }
   return visit (t);

  case kUNIT_LIST:
/* line 932 "Traverse.puma" */
 {
  tTree new_unit;
  {
/* line 936 "Traverse.puma" */
 new_unit = ReplaceAST (t->UNIT_LIST.Elem, pred, visit);
     t->UNIT_LIST.Next     = ReplaceAST (t->UNIT_LIST.Next, pred, visit);
     new_unit = ReplaceUNIT (t, new_unit, t->UNIT_LIST.Next);
   
  }
   return new_unit;
 }

  case kUNIT_EMPTY:
/* line 944 "Traverse.puma" */
   return t;

  case kPROGRAM_DECL:
/* line 949 "Traverse.puma" */
  {
/* line 951 "Traverse.puma" */
   NestOpenUnit (t);
/* line 952 "Traverse.puma" */
 t->PROGRAM_DECL.PROGRAM_BODY = ReplaceAST (t->PROGRAM_DECL.PROGRAM_BODY, pred, visit); 
/* line 953 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return visit (t);

  case kPROC_DECL:
/* line 957 "Traverse.puma" */
  {
/* line 959 "Traverse.puma" */
   NestOpenUnit (t);
/* line 960 "Traverse.puma" */
 t->PROC_DECL.PROC_BODY = ReplaceAST (t->PROC_DECL.PROC_BODY, pred, visit); 
/* line 961 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return visit (t);

  case kFUNC_DECL:
/* line 965 "Traverse.puma" */
  {
/* line 967 "Traverse.puma" */
   NestOpenUnit (t);
/* line 968 "Traverse.puma" */
 t->FUNC_DECL.FUNC_BODY = ReplaceAST (t->FUNC_DECL.FUNC_BODY, pred, visit); 
/* line 969 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return visit (t);

  case kBLOCK_DATA_DECL:
/* line 973 "Traverse.puma" */
  {
/* line 975 "Traverse.puma" */
   NestOpenUnit (t);
/* line 976 "Traverse.puma" */
 t->BLOCK_DATA_DECL.DATA_BODY = ReplaceAST (t->BLOCK_DATA_DECL.DATA_BODY, pred, visit); 
/* line 977 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return visit (t);

  case kMODULE_DECL:
/* line 981 "Traverse.puma" */
  {
/* line 983 "Traverse.puma" */
   NestOpenUnit (t);
/* line 984 "Traverse.puma" */
 t->MODULE_DECL.MODULE_BODY = ReplaceAST (t->MODULE_DECL.MODULE_BODY, pred, visit); 
/* line 985 "Traverse.puma" */
   NestCloseUnit (t);
  }
   return visit (t);

  case kMODULE_PROC_DECL:
/* line 989 "Traverse.puma" */
   return visit (t);

  case kBODY_NODE:
/* line 1000 "Traverse.puma" */
  {
/* line 1002 "Traverse.puma" */
 t->BODY_NODE.DECLS     = ReplaceAST (t->BODY_NODE.DECLS, pred, visit);
     t->BODY_NODE.NEW_DECLS = ReplaceAST (t->BODY_NODE.NEW_DECLS, pred, visit);
     t->BODY_NODE.STATS     = ReplaceAST (t->BODY_NODE.STATS, pred, visit);
     t->BODY_NODE.INTERNALS = ReplaceAST (t->BODY_NODE.INTERNALS, pred, visit);
   
  }
   return visit (t);

  case kDECL_LIST:
/* line 1016 "Traverse.puma" */
 {
  tTree new_decl;
  {
/* line 1020 "Traverse.puma" */
   set_protocol_stmt (t->DECL_LIST.Elem);
/* line 1022 "Traverse.puma" */
 new_decl = ReplaceAST (t->DECL_LIST.Elem, pred, visit);
     t->DECL_LIST.Next     = ReplaceAST (t->DECL_LIST.Next, pred, visit);
     new_decl = ReplaceDECL (t, new_decl, t->DECL_LIST.Next);
   
  }
   return new_decl;
 }

  case kDECL_EMPTY:
/* line 1030 "Traverse.puma" */
   return t;

  case kVAR_DECL:
/* line 1035 "Traverse.puma" */
  {
/* line 1037 "Traverse.puma" */
 t->VAR_DECL.VAL = ReplaceAST (t->VAR_DECL.VAL, pred, visit); 
  }
   return visit (t);

  case kTYPE_DECL:
/* line 1042 "Traverse.puma" */
  {
/* line 1044 "Traverse.puma" */
 t->TYPE_DECL.VAL = ReplaceAST (t->TYPE_DECL.VAL, pred, visit); 
  }
   return visit (t);

  case kINTERFACE_DECL:
/* line 1049 "Traverse.puma" */
  {
/* line 1051 "Traverse.puma" */
 t->INTERFACE_DECL.ITEMS = ReplaceAST (t->INTERFACE_DECL.ITEMS, pred, visit); 
  }
   return visit (t);

  case kDISTRIBUTE_DECL:
/* line 1056 "Traverse.puma" */
  {
/* line 1058 "Traverse.puma" */
 t->DISTRIBUTE_DECL.TARGET = ReplaceAST (t->DISTRIBUTE_DECL.TARGET, pred, visit); 
  }
   return visit (t);

  case kDECL_NODE:
  case kNAME_DECL:
  case kRENAME_DECL:
  case kENTITY_DECL:
  case kCOMMON_DECL:
  case kNAMELIST_DECL:
  case kTEMPLATE_DECL:
  case kRAGGED_DECL:
  case kPROCESSORS_DECL:
  case kSUB_PROCS_DECL:
  case kINHERIT_DECL:
  case kRANGE_DECL:
  case kSTMT_FUNC_DECL:
  case kVAR_PARAM_DECL:
  case kRET_PARAM_DECL:
  case kIMPLICIT_DECL:
  case kUSE_DECL:
  case kONLY_USE_DECL:
  case kEQV_DECL:
  case kDATA_DECL:
  case kFORMAT_DECL:
  case kDIMENSION_DECL:
  case kINIT_DATA_DECL:
  case kTYPESPEC_DECL:
  case kALLOCATABLE_DECL:
  case kEXTERNAL_DECL:
  case kINTENT_DECL:
  case kINTRINSIC_DECL:
  case kOPTIONAL_DECL:
  case kPOINTER_DECL:
  case kSAVE_DECL:
  case kTARGET_DECL:
  case kPARAMETER_DECL:
  case kPUBLIC_DECL:
  case kPRIVATE_DECL:
  case kSEQUENCE_DECL:
  case kALIGN_DECL:
  case kSHADOW_DECL:
  case kSHARED_DECL:
  case kDYNAMIC_DECL:
  case kTRACE_DECL:
  case kTREE_DECL:
  case kNODSP_DECL:
  case kSELECT_DECL:
  case kHPF_SEQUENCE_DECL:
  case kNOSEQUENCE_DECL:
  case kLAYOUT_DECL:
  case kPASS_BY_DECL:
  case kMAP_TO_DECL:
/* line 1063 "Traverse.puma" */
   return visit (t);

  case kARRAY_TYPE:
/* line 1074 "Traverse.puma" */
  {
/* line 1076 "Traverse.puma" */
 t->ARRAY_TYPE.ARRAY_INDEX_TYPES = ReplaceAST (t->ARRAY_TYPE.ARRAY_INDEX_TYPES, pred, visit); 
     t->ARRAY_TYPE.ARRAY_COMP_TYPE   = ReplaceAST (t->ARRAY_TYPE.ARRAY_COMP_TYPE,   pred, visit); 
   
  }
   return visit (t);

  case kEXPLICIT_SHAPE:
/* line 1083 "Traverse.puma" */
  {
/* line 1085 "Traverse.puma" */
 t->EXPLICIT_SHAPE.LOWER = ReplaceAST (t->EXPLICIT_SHAPE.LOWER, pred, visit); 
     t->EXPLICIT_SHAPE.UPPER = ReplaceAST (t->EXPLICIT_SHAPE.UPPER,  pred, visit);
   
  }
   return visit (t);

  case kSHAPE_SPEC:
  case kASSUMED_SHAPE:
  case kDEFERRED_SHAPE:
  case kASSUMED_SIZE:
/* line 1091 "Traverse.puma" */
   return visit (t);

  case kRECORD_TYPE:
/* line 1095 "Traverse.puma" */
  {
/* line 1097 "Traverse.puma" */
   NestOpenType (t);
/* line 1098 "Traverse.puma" */
 t->RECORD_TYPE.COMPONENTS = ReplaceAST (t->RECORD_TYPE.COMPONENTS, pred, visit); 
/* line 1099 "Traverse.puma" */
   NestCloseType (t);
  }
   return visit (t);

  case kTYPE_NODE:
  case kDUMMY_TYPE:
  case kALIGN_TYPE:
  case kINTEGER_TYPE:
  case kREAL_TYPE:
  case kBOOLEAN_TYPE:
  case kCOMPLEX_TYPE:
  case kSTRING_TYPE:
  case kTYPE_ID:
/* line 1104 "Traverse.puma" */
   return visit (t);

  case kSHAPE_LIST:
/* line 1109 "Traverse.puma" */
  {
/* line 1111 "Traverse.puma" */
 t->SHAPE_LIST.Elem = ReplaceAST (t->SHAPE_LIST.Elem, pred, visit); 
     t->SHAPE_LIST.Next = ReplaceAST (t->SHAPE_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kSHAPE_EMPTY:
/* line 1118 "Traverse.puma" */
   return visit (t);

  case kACF_LIST:
/* line 1129 "Traverse.puma" */
 {
  tTree newacf;
  {
/* line 1133 "Traverse.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 1135 "Traverse.puma" */
 newacf = ReplaceAST (t->ACF_LIST.Elem, pred, visit);            
     t->ACF_LIST.Next   = ReplaceAST (t->ACF_LIST.Next, pred, visit);            
   
/* line 1139 "Traverse.puma" */
   newacf = ReplaceACF (t, newacf, t->ACF_LIST.Next);
  }
   return newacf;
 }

  case kACF_EMPTY:
/* line 1144 "Traverse.puma" */
   return t;

  case kACF_BASIC:
/* line 1149 "Traverse.puma" */
  {
/* line 1151 "Traverse.puma" */
 t->ACF_BASIC.BASIC_STMT = ReplaceAST (t->ACF_BASIC.BASIC_STMT, pred, visit); 
  }
   return visit (t);

  case kACF_DUMMY:
/* line 1156 "Traverse.puma" */
   return visit (t);

  case kACF_WHILE:
/* line 1161 "Traverse.puma" */
  {
/* line 1163 "Traverse.puma" */
 t->ACF_WHILE.WHILE_EXP  = ReplaceAST (t->ACF_WHILE.WHILE_EXP, pred, visit);
     t->ACF_WHILE.WHILE_BODY = ReplaceAST (t->ACF_WHILE.WHILE_BODY, pred, visit);
   
/* line 1167 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_LOOP:
/* line 1172 "Traverse.puma" */
  {
/* line 1174 "Traverse.puma" */
 t->ACF_LOOP.LOOP_BODY = ReplaceAST (t->ACF_LOOP.LOOP_BODY, pred, visit); 
/* line 1176 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_DO:
/* line 1181 "Traverse.puma" */
  {
/* line 1183 "Traverse.puma" */
 t->ACF_DO.DO_ID       = ReplaceAST (t->ACF_DO.DO_ID, pred, visit);
     t->ACF_DO.DO_RANGE    = ReplaceAST (t->ACF_DO.DO_RANGE, pred, visit);
     t->ACF_DO.DO_DEP_INFO = ReplaceAST (t->ACF_DO.DO_DEP_INFO, pred, visit);
   
/* line 1188 "Traverse.puma" */
   IncLoopNesting (t);
/* line 1190 "Traverse.puma" */
 t->ACF_DO.DO_BODY  = ReplaceAST (t->ACF_DO.DO_BODY, pred, visit); 
/* line 1192 "Traverse.puma" */
   DecLoopNesting (t);
/* line 1194 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_FORALL:
/* line 1199 "Traverse.puma" */
  {
/* line 1201 "Traverse.puma" */
 t->ACF_FORALL.FORALL_ID       = ReplaceAST (t->ACF_FORALL.FORALL_ID, pred, visit);
     t->ACF_FORALL.FORALL_RANGE    = ReplaceAST (t->ACF_FORALL.FORALL_RANGE, pred, visit);
     t->ACF_FORALL.FORALL_DEP_INFO = ReplaceAST (t->ACF_FORALL.FORALL_DEP_INFO, pred, visit);
   
/* line 1206 "Traverse.puma" */
   IncLoopNesting (t);
/* line 1208 "Traverse.puma" */
 t->ACF_FORALL.FORALL_BODY  = ReplaceAST (t->ACF_FORALL.FORALL_BODY, pred, visit); 
/* line 1210 "Traverse.puma" */
   DecLoopNesting (t);
/* line 1212 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_IF:
/* line 1217 "Traverse.puma" */
  {
/* line 1219 "Traverse.puma" */
 t->ACF_IF.IF_EXP    = ReplaceAST (t->ACF_IF.IF_EXP,    pred, visit);
     t->ACF_IF.THEN_PART = ReplaceAST (t->ACF_IF.THEN_PART, pred, visit);
     t->ACF_IF.ELSE_PART = ReplaceAST (t->ACF_IF.ELSE_PART, pred, visit);
   
/* line 1226 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_WHERE:
/* line 1231 "Traverse.puma" */
  {
/* line 1233 "Traverse.puma" */
 t->ACF_WHERE.WHERE_EXP = ReplaceAST (t->ACF_WHERE.WHERE_EXP, pred, visit);
     t->ACF_WHERE.TRUE_PART = ReplaceAST (t->ACF_WHERE.TRUE_PART, pred, visit);
     t->ACF_WHERE.FALSE_PART = ReplaceAST (t->ACF_WHERE.FALSE_PART, pred, visit);
   
/* line 1238 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_HOME:
/* line 1243 "Traverse.puma" */
  {
/* line 1245 "Traverse.puma" */
 t->ACF_HOME.HOME_VAR = ReplaceAST (t->ACF_HOME.HOME_VAR, pred, visit);
     t->ACF_HOME.HOME_BODY = ReplaceAST (t->ACF_HOME.HOME_BODY, pred, visit);
   
/* line 1249 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_RESIDENT:
/* line 1254 "Traverse.puma" */
  {
/* line 1256 "Traverse.puma" */
 t->ACF_RESIDENT.RESIDENT_VAR = ReplaceAST (t->ACF_RESIDENT.RESIDENT_VAR, pred, visit);
     t->ACF_RESIDENT.RESIDENT_BODY = ReplaceAST (t->ACF_RESIDENT.RESIDENT_BODY, pred, visit);
   
/* line 1260 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_PARALLEL:
/* line 1265 "Traverse.puma" */
  {
/* line 1267 "Traverse.puma" */
 t->ACF_PARALLEL.REDUCTION_VARS    = ReplaceAST (t->ACF_PARALLEL.REDUCTION_VARS, pred, visit);
     t->ACF_PARALLEL.SHARED_VARS = ReplaceAST (t->ACF_PARALLEL.SHARED_VARS, pred, visit);
     t->ACF_PARALLEL.LOCAL_VARS  = ReplaceAST (t->ACF_PARALLEL.LOCAL_VARS, pred, visit);
     t->ACF_PARALLEL.PARALLEL_BODY    = ReplaceAST (t->ACF_PARALLEL.PARALLEL_BODY, pred, visit);
   
/* line 1273 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_CRITICAL:
/* line 1278 "Traverse.puma" */
  {
/* line 1280 "Traverse.puma" */
 t->ACF_CRITICAL.CRITICAL_BODY = ReplaceAST (t->ACF_CRITICAL.CRITICAL_BODY, pred, visit); 
/* line 1282 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_NEW:
/* line 1287 "Traverse.puma" */
  {
/* line 1289 "Traverse.puma" */
 
     t->ACF_NEW.NEW_BODY = ReplaceAST (t->ACF_NEW.NEW_BODY, pred, visit);
   
/* line 1293 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_BARRIER:
/* line 1298 "Traverse.puma" */
   return visit (t);

  case kACF_REDUCTION:
/* line 1303 "Traverse.puma" */
  {
/* line 1306 "Traverse.puma" */
 t->ACF_REDUCTION.REDUCTION_VAR  = ReplaceAST (t->ACF_REDUCTION.REDUCTION_VAR, pred, visit);
     t->ACF_REDUCTION.REDUCTION_BODY = ReplaceAST (t->ACF_REDUCTION.REDUCTION_BODY, pred, visit);
   
/* line 1310 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kON_PROC_CLAUSE:
/* line 1315 "Traverse.puma" */
  {
/* line 1317 "Traverse.puma" */
 t->ON_PROC_CLAUSE.ON_PROC = ReplaceAST (t->ON_PROC_CLAUSE.ON_PROC, pred, visit); 
  }
   return visit (t);

  case kON_VAR_CLAUSE:
/* line 1321 "Traverse.puma" */
  {
/* line 1323 "Traverse.puma" */
 t->ON_VAR_CLAUSE.ON_VAR = ReplaceAST (t->ON_VAR_CLAUSE.ON_VAR, pred, visit); 
  }
   return visit (t);

  case kON_ALL_CLAUSE:
/* line 1327 "Traverse.puma" */
   return visit (t);

  case kON_HOST_CLAUSE:
/* line 1332 "Traverse.puma" */
   return visit (t);

  case kACF_ON:
/* line 1337 "Traverse.puma" */
  {
/* line 1339 "Traverse.puma" */
 t->ACF_ON.ON_BODY = ReplaceAST (t->ACF_ON.ON_BODY, pred, visit); 
  }
   return visit (t);

  case kACF_TASK_REGION:
/* line 1344 "Traverse.puma" */
  {
/* line 1346 "Traverse.puma" */
 t->ACF_TASK_REGION.TASK_BODY = ReplaceAST (t->ACF_TASK_REGION.TASK_BODY, pred, visit); 
/* line 1348 "Traverse.puma" */
   set_protocol_stmt (t);
  }
   return visit (t);

  case kACF_MOVE:
/* line 1353 "Traverse.puma" */
  {
/* line 1355 "Traverse.puma" */
 t->ACF_MOVE.MOVE_STMT = ReplaceAST (t->ACF_MOVE.MOVE_STMT, pred, visit); 
  }
   return visit (t);

  case kACF_CASE:
/* line 1360 "Traverse.puma" */
  {
/* line 1362 "Traverse.puma" */
 t->ACF_CASE.CASE_EXP = ReplaceAST (t->ACF_CASE.CASE_EXP, pred, visit);
     t->ACF_CASE.CASE_ALTS = ReplaceAST (t->ACF_CASE.CASE_ALTS, pred, visit);
   
  }
   return visit (t);

  case kSELECTED_ACF_LIST:
/* line 1374 "Traverse.puma" */
  {
/* line 1376 "Traverse.puma" */
 t->SELECTED_ACF_LIST.Elem = ReplaceAST (t->SELECTED_ACF_LIST.Elem, pred, visit);
     t->SELECTED_ACF_LIST.Next = ReplaceAST (t->SELECTED_ACF_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kSELECTED_ACF_EMPTY:
/* line 1382 "Traverse.puma" */
   return visit (t);

  case kSELECTED_ACF_NODE:
/* line 1386 "Traverse.puma" */
  {
/* line 1388 "Traverse.puma" */
 t->SELECTED_ACF_NODE.SELECT_LIST = ReplaceAST (t->SELECTED_ACF_NODE.SELECT_LIST, pred, visit);
     t->SELECTED_ACF_NODE.SELECT_ACFS   = ReplaceAST (t->SELECTED_ACF_NODE.SELECT_ACFS, pred, visit);
   
  }
   return visit (t);

  case kASSIGN_STMT:
/* line 1400 "Traverse.puma" */
  {
/* line 1402 "Traverse.puma" */
 t->ASSIGN_STMT.ASSIGN_VAR = ReplaceAST (t->ASSIGN_STMT.ASSIGN_VAR, pred, visit);
     t->ASSIGN_STMT.ASSIGN_EXP = ReplaceAST (t->ASSIGN_STMT.ASSIGN_EXP, pred, visit);
   
  }
   return visit (t);

  case kPTR_ASSIGN_STMT:
/* line 1408 "Traverse.puma" */
  {
/* line 1410 "Traverse.puma" */
 t->PTR_ASSIGN_STMT.ASSIGN_VAR = ReplaceAST (t->PTR_ASSIGN_STMT.ASSIGN_VAR, pred, visit);
     t->PTR_ASSIGN_STMT.ASSIGN_EXP = ReplaceAST (t->PTR_ASSIGN_STMT.ASSIGN_EXP, pred, visit);
   
  }
   return visit (t);

  case kLABEL_ASSIGN_STMT:
/* line 1416 "Traverse.puma" */
  {
/* line 1418 "Traverse.puma" */
 t->LABEL_ASSIGN_STMT.LABEL_VAR = ReplaceAST (t->LABEL_ASSIGN_STMT.LABEL_VAR, pred, visit); 
  }
   return visit (t);

  case kFORMAT_STMT:
/* line 1422 "Traverse.puma" */
   return visit (t);

  case kCALL_STMT:
/* line 1426 "Traverse.puma" */
  {
/* line 1428 "Traverse.puma" */
 t->CALL_STMT.CALL_PARAMS = ReplaceAST (t->CALL_STMT.CALL_PARAMS, pred, visit); 
  }
   return visit (t);

  case kMOVE_STMT:
/* line 1432 "Traverse.puma" */
  {
/* line 1434 "Traverse.puma" */
 t->MOVE_STMT.TARGET = ReplaceAST (t->MOVE_STMT.TARGET, pred, visit); 
     t->MOVE_STMT.SOURCE = ReplaceAST (t->MOVE_STMT.SOURCE, pred, visit); 
     t->MOVE_STMT.MASK   = ReplaceAST (t->MOVE_STMT.MASK, pred, visit); 
   
  }
   return visit (t);

  case kSCATTER_STMT:
/* line 1441 "Traverse.puma" */
  {
/* line 1443 "Traverse.puma" */
 t->SCATTER_STMT.BASE    = ReplaceAST (t->SCATTER_STMT.BASE, pred, visit); 
     t->SCATTER_STMT.ARRAY   = ReplaceAST (t->SCATTER_STMT.ARRAY, pred, visit); 
     t->SCATTER_STMT.INDEXES = ReplaceAST (t->SCATTER_STMT.INDEXES, pred, visit); 
     t->SCATTER_STMT.MASK    = ReplaceAST (t->SCATTER_STMT.MASK, pred, visit); 
   
  }
   return visit (t);

  case kBROADCAST_STMT:
/* line 1451 "Traverse.puma" */
  {
/* line 1453 "Traverse.puma" */
 t->BROADCAST_STMT.ELEMS = ReplaceAST (t->BROADCAST_STMT.ELEMS, pred, visit); 
  }
   return visit (t);

  case kGOTO_STMT:
/* line 1458 "Traverse.puma" */
   return visit (t);

  case kASS_GOTO_STMT:
/* line 1462 "Traverse.puma" */
  {
/* line 1464 "Traverse.puma" */
 t->ASS_GOTO_STMT.GOTO_VAR = ReplaceAST (t->ASS_GOTO_STMT.GOTO_VAR, pred, visit); 
  }
   return visit (t);

  case kREDUCTION_STMT:
/* line 1468 "Traverse.puma" */
  {
/* line 1470 "Traverse.puma" */
 t->REDUCTION_STMT.ELEMS = ReplaceAST (t->REDUCTION_STMT.ELEMS, pred, visit); 
  }
   return visit (t);

  case kCOMP_GOTO_STMT:
/* line 1475 "Traverse.puma" */
  {
/* line 1477 "Traverse.puma" */
 t->COMP_GOTO_STMT.GOTO_EXP = ReplaceAST (t->COMP_GOTO_STMT.GOTO_EXP, pred, visit); 
  }
   return visit (t);

  case kIO_STMT:
/* line 1481 "Traverse.puma" */
  {
/* line 1483 "Traverse.puma" */
 t->IO_STMT.IO_SPECS = ReplaceAST (t->IO_STMT.IO_SPECS, pred, visit);
     t->IO_STMT.IO_ITEMS = ReplaceAST (t->IO_STMT.IO_ITEMS, pred, visit);
   
  }
   return visit (t);

  case kCOMP_IF_STMT:
/* line 1489 "Traverse.puma" */
  {
/* line 1491 "Traverse.puma" */
 t->COMP_IF_STMT.IF_EXP = ReplaceAST (t->COMP_IF_STMT.IF_EXP, pred, visit); 
  }
   return visit (t);

  case kSTOP_STMT:
/* line 1495 "Traverse.puma" */
   return visit (t);

  case kPAUSE_STMT:
/* line 1499 "Traverse.puma" */
   return visit (t);

  case kEXIT_STMT:
/* line 1503 "Traverse.puma" */
   return visit (t);

  case kCYCLE_STMT:
/* line 1507 "Traverse.puma" */
   return visit (t);

  case kRETURN_STMT:
/* line 1511 "Traverse.puma" */
  {
/* line 1513 "Traverse.puma" */
 t->RETURN_STMT.RETURN_EXP = ReplaceAST (t->RETURN_STMT.RETURN_EXP, pred, visit); 
  }
   return visit (t);

  case kREDUCE_STMT:
/* line 1518 "Traverse.puma" */
  {
/* line 1520 "Traverse.puma" */
 t->REDUCE_STMT.RED_PARAMS = ReplaceAST (t->REDUCE_STMT.RED_PARAMS, pred, visit); 
  }
   return visit (t);

  case kALLOCATE_STMT:
/* line 1525 "Traverse.puma" */
  {
/* line 1527 "Traverse.puma" */
 t->ALLOCATE_STMT.PARAMS = ReplaceAST (t->ALLOCATE_STMT.PARAMS, pred, visit);
     t->ALLOCATE_STMT.STATUS = ReplaceAST (t->ALLOCATE_STMT.STATUS, pred, visit);
   
  }
   return visit (t);

  case kDEALLOCATE_STMT:
/* line 1534 "Traverse.puma" */
  {
/* line 1536 "Traverse.puma" */
 t->DEALLOCATE_STMT.PARAMS = ReplaceAST (t->DEALLOCATE_STMT.PARAMS, pred, visit);
     t->DEALLOCATE_STMT.STATUS = ReplaceAST (t->DEALLOCATE_STMT.STATUS, pred, visit);
   
  }
   return visit (t);

  case kACCESS_STMT:
/* line 1543 "Traverse.puma" */
  {
/* line 1545 "Traverse.puma" */
 t->ACCESS_STMT.VAR = ReplaceAST (t->ACCESS_STMT.VAR, pred, visit); 
  }
   return visit (t);

  case kCREATE_DSP_STMT:
/* line 1550 "Traverse.puma" */
  {
/* line 1552 "Traverse.puma" */
 t->CREATE_DSP_STMT.VAR     = ReplaceAST (t->CREATE_DSP_STMT.VAR, pred, visit);
     
   
  }
   return visit (t);

  case kINHERIT_DSP_STMT:
/* line 1559 "Traverse.puma" */
  {
/* line 1561 "Traverse.puma" */
 t->INHERIT_DSP_STMT.VAR     = ReplaceAST (t->INHERIT_DSP_STMT.VAR, pred, visit);
     
   
  }
   return visit (t);

  case kFREE_DSP_STMT:
/* line 1568 "Traverse.puma" */
  {
/* line 1570 "Traverse.puma" */
 t->FREE_DSP_STMT.VAR = ReplaceAST (t->FREE_DSP_STMT.VAR, pred, visit); 
  }
   return visit (t);

  case kREG_SHADOW_GET:
/* line 1575 "Traverse.puma" */
  {
/* line 1577 "Traverse.puma" */
   SetActualOverlap (t);
/* line 1578 "Traverse.puma" */
 t->REG_SHADOW_GET.SHADOW_VAR = ReplaceAST (t->REG_SHADOW_GET.SHADOW_VAR, pred, visit); 
  }
   return visit (t);

  case kIND_SHADOW_CREATE:
/* line 1582 "Traverse.puma" */
   return visit (t);

  case kIND_SHADOW_FREE:
/* line 1587 "Traverse.puma" */
   return visit (t);

  case kIND_SHADOW_GET:
/* line 1592 "Traverse.puma" */
   return visit (t);

  case kIND_SHADOW_SET:
/* line 1597 "Traverse.puma" */
   return visit (t);

  case kIND_SHADOW_PUT:
/* line 1602 "Traverse.puma" */
   return visit (t);

  case kDIRTY_STMT:
/* line 1607 "Traverse.puma" */
  {
/* line 1609 "Traverse.puma" */
 t->DIRTY_STMT.ELEMS = ReplaceAST (t->DIRTY_STMT.ELEMS, pred, visit); 
  }
   return visit (t);

  case kNULLIFY_STMT:
/* line 1614 "Traverse.puma" */
  {
/* line 1616 "Traverse.puma" */
 t->NULLIFY_STMT.PARAMS = ReplaceAST (t->NULLIFY_STMT.PARAMS, pred, visit); 
  }
   return visit (t);

  case kREALIGN_STMT:
/* line 1620 "Traverse.puma" */
   return visit (t);

  case kREDISTRIBUTE_STMT:
/* line 1625 "Traverse.puma" */
  {
/* line 1627 "Traverse.puma" */
 t->REDISTRIBUTE_STMT.TARGET = ReplaceAST (t->REDISTRIBUTE_STMT.TARGET, pred, visit); 
  }
   return visit (t);

  case kDUMMY_EXP:
/* line 1639 "Traverse.puma" */
   return visit (t);

  case kCONST_EXP:
/* line 1643 "Traverse.puma" */
   return visit (t);

  case kARRAY_EXP:
/* line 1647 "Traverse.puma" */
  {
/* line 1649 "Traverse.puma" */
 t->ARRAY_EXP.ELEMENTS = ReplaceAST (t->ARRAY_EXP.ELEMENTS, pred, visit); 
  }
   return visit (t);

  case kBOUND_EXP:
/* line 1653 "Traverse.puma" */
  {
/* line 1655 "Traverse.puma" */
 t->BOUND_EXP.VAR = ReplaceAST (t->BOUND_EXP.VAR, pred, visit); 
  }
   return visit (t);

  case kRANK_EXP:
/* line 1660 "Traverse.puma" */
   return visit (t);

  case kSIZE_EXP:
/* line 1665 "Traverse.puma" */
   return visit (t);

  case kPERM_EXP:
/* line 1670 "Traverse.puma" */
  {
/* line 1672 "Traverse.puma" */
 t->PERM_EXP.VAL = ReplaceAST (t->PERM_EXP.VAL, pred, visit); 
  }
   return visit (t);

  case kSLICE_EXP:
/* line 1676 "Traverse.puma" */
  {
/* line 1678 "Traverse.puma" */
 t->SLICE_EXP.FIRST = ReplaceAST (t->SLICE_EXP.FIRST, pred, visit);
     t->SLICE_EXP.STOP  = ReplaceAST (t->SLICE_EXP.STOP, pred,  visit);
     t->SLICE_EXP.INC   = ReplaceAST (t->SLICE_EXP.INC, pred,  visit);
   
  }
   return visit (t);

  case kOP_EXP:
/* line 1685 "Traverse.puma" */
  {
/* line 1687 "Traverse.puma" */
 t->OP_EXP.OPND1 = ReplaceAST (t->OP_EXP.OPND1, pred, visit);
     t->OP_EXP.OPND2 = ReplaceAST (t->OP_EXP.OPND2, pred, visit);
   
  }
   return visit (t);

  case kOP1_EXP:
/* line 1693 "Traverse.puma" */
  {
/* line 1695 "Traverse.puma" */
 t->OP1_EXP.OPND = ReplaceAST (t->OP1_EXP.OPND, pred, visit); 
  }
   return visit (t);

  case kTYPE_EXP:
/* line 1700 "Traverse.puma" */
  {
/* line 1702 "Traverse.puma" */
 t->TYPE_EXP.ELEMENTS = ReplaceAST (t->TYPE_EXP.ELEMENTS, pred, visit); 
  }
   return visit (t);

  case kVAR_EXP:
/* line 1706 "Traverse.puma" */
  {
/* line 1708 "Traverse.puma" */
 t->VAR_EXP.V = ReplaceAST (t->VAR_EXP.V, pred, visit); 
  }
   return visit (t);

  case kDO_EXP:
/* line 1712 "Traverse.puma" */
  {
/* line 1714 "Traverse.puma" */
 t->DO_EXP.DO_ID = ReplaceAST (t->DO_EXP.DO_ID, pred, visit);
     t->DO_EXP.RANGE = ReplaceAST (t->DO_EXP.RANGE, pred, visit);
     t->DO_EXP.BODY  = ReplaceAST (t->DO_EXP.BODY, pred, visit);
   
  }
   return visit (t);

  case kFUNC_CALL_EXP:
/* line 1721 "Traverse.puma" */
  {
/* line 1723 "Traverse.puma" */
 t->FUNC_CALL_EXP.FUNC_PARAMS = ReplaceAST (t->FUNC_CALL_EXP.FUNC_PARAMS, pred, visit); 
  }
   return visit (t);

  case kBTE_LIST:
/* line 1733 "Traverse.puma" */
  {
/* line 1735 "Traverse.puma" */
 t->BTE_LIST.Elem = ReplaceAST (t->BTE_LIST.Elem, pred, visit);
     t->BTE_LIST.Next = ReplaceAST (t->BTE_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kBTE_EMPTY:
/* line 1741 "Traverse.puma" */
   return visit (t);

  case kVAR_OBJ:
/* line 1751 "Traverse.puma" */
   return visit (t);

  case kUSED_VAR:
/* line 1755 "Traverse.puma" */
  {
/* line 1757 "Traverse.puma" */
 t->USED_VAR.VARNAME = ReplaceAST (t->USED_VAR.VARNAME, pred, visit); 
  }
   return visit (t);

  case kLOOP_VAR:
/* line 1761 "Traverse.puma" */
  {
/* line 1763 "Traverse.puma" */
 t->LOOP_VAR.LOOP_VARNAME = ReplaceAST (t->LOOP_VAR.LOOP_VARNAME, pred, visit); 
  }
   return visit (t);

  case kDUMMY_VAR:
/* line 1767 "Traverse.puma" */
   return visit (t);

  case kREMOTE_VAR:
/* line 1771 "Traverse.puma" */
  {
/* line 1773 "Traverse.puma" */
 t->REMOTE_VAR.VAR = ReplaceAST (t->REMOTE_VAR.VAR, pred, visit); 
  }
   return visit (t);

  case kSELECTED_VAR:
/* line 1777 "Traverse.puma" */
  {
/* line 1779 "Traverse.puma" */
 t->SELECTED_VAR.SELEC_VAR = ReplaceAST (t->SELECTED_VAR.SELEC_VAR, pred, visit); 
  }
   return visit (t);

  case kSUBSTRING_VAR:
/* line 1783 "Traverse.puma" */
  {
/* line 1785 "Traverse.puma" */
 t->SUBSTRING_VAR.IND_VAR    = ReplaceAST (t->SUBSTRING_VAR.IND_VAR, pred, visit); 
     t->SUBSTRING_VAR.IND_EXP = ReplaceAST (t->SUBSTRING_VAR.IND_EXP, pred, visit);
   
  }
   return visit (t);

  case kINDEXED_VAR:
/* line 1791 "Traverse.puma" */
  {
/* line 1793 "Traverse.puma" */
 t->INDEXED_VAR.IND_VAR = ReplaceAST (t->INDEXED_VAR.IND_VAR, pred, visit);
     t->INDEXED_VAR.IND_EXPS = ReplaceAST (t->INDEXED_VAR.IND_EXPS, pred, visit);
   
  }
   return visit (t);

  case kPERM_VAR:
/* line 1799 "Traverse.puma" */
  {
/* line 1801 "Traverse.puma" */
 t->PERM_VAR.VAL = ReplaceAST (t->PERM_VAR.VAL, pred, visit); 
  }
   return visit (t);

  case kADDR:
/* line 1805 "Traverse.puma" */
  {
/* line 1807 "Traverse.puma" */
 t->ADDR.E = ReplaceAST (t->ADDR.E, pred, visit); 
  }
   return visit (t);

  case kDO_VAR:
/* line 1811 "Traverse.puma" */
  {
/* line 1813 "Traverse.puma" */
 t->DO_VAR.DO_ID    = ReplaceAST (t->DO_VAR.DO_ID, pred, visit);
     t->DO_VAR.RANGE = ReplaceAST (t->DO_VAR.RANGE, pred, visit);
     t->DO_VAR.BODY  = ReplaceAST (t->DO_VAR.BODY, pred, visit);
   
  }
   return visit (t);

  case kBTV_LIST:
/* line 1826 "Traverse.puma" */
  {
/* line 1828 "Traverse.puma" */
 t->BTV_LIST.Elem = ReplaceAST (t->BTV_LIST.Elem, pred, visit);
     t->BTV_LIST.Next = ReplaceAST (t->BTV_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kBTV_EMPTY:
/* line 1834 "Traverse.puma" */
   return visit (t);

  case kBTP_LIST:
/* line 1844 "Traverse.puma" */
  {
/* line 1846 "Traverse.puma" */
 t->BTP_LIST.Elem = ReplaceAST (t->BTP_LIST.Elem, pred, visit); 
     t->BTP_LIST.Next = ReplaceAST (t->BTP_LIST.Next, pred, visit);
   
  }
   return visit (t);

  case kBTP_EMPTY:
/* line 1852 "Traverse.puma" */
   return visit (t);

  case kVAR_PARAM:
/* line 1856 "Traverse.puma" */
  {
/* line 1858 "Traverse.puma" */
 t->VAR_PARAM.V = ReplaceAST (t->VAR_PARAM.V, pred, visit); 
  }
   return visit (t);

  case kNO_PARAM:
/* line 1862 "Traverse.puma" */
   return visit (t);

  case kNAMED_PARAM:
/* line 1866 "Traverse.puma" */
  {
/* line 1868 "Traverse.puma" */
 t->NAMED_PARAM.VAL = ReplaceAST (t->NAMED_PARAM.VAL, pred, visit); 
  }
   return visit (t);

  case kFUNC_PARAM:
/* line 1872 "Traverse.puma" */
   return visit (t);

  case kPROC_PARAM:
/* line 1876 "Traverse.puma" */
   return visit (t);

  case kSERIAL_INFO:
/* line 1886 "Traverse.puma" */
   return visit (t);

  case kVECTOR_INFO:
/* line 1891 "Traverse.puma" */
   return visit (t);

  case kPARDO_INFO:
/* line 1896 "Traverse.puma" */
   return visit (t);

  case kINDEP_INFO:
/* line 1901 "Traverse.puma" */
   return visit (t);

  case kNO_HOME_INFO:
/* line 1912 "Traverse.puma" */
   return visit (t);

  case kCOMM_INFO:
/* line 1917 "Traverse.puma" */
  {
/* line 1919 "Traverse.puma" */
 if (t->COMM_INFO.home_var != NoTree)
        t->COMM_INFO.home_var = ReplaceAST (t->COMM_INFO.home_var, pred, visit);
   
  }
   return visit (t);

  case kON_INFO:
/* line 1926 "Traverse.puma" */
   return visit (t);

  case kDEFAULT_PROCESSOR_ARRAY:
/* line 1937 "Traverse.puma" */
   return visit (t);

  case kANY_PROCESSOR_ARRAY:
/* line 1942 "Traverse.puma" */
   return visit (t);

  case kPROCESSOR_ARRAY:
/* line 1947 "Traverse.puma" */
   return visit (t);

  case kPROCESSOR_SUBSET:
/* line 1952 "Traverse.puma" */
  {
/* line 1954 "Traverse.puma" */
 t->PROCESSOR_SUBSET.SUBSCRIPTS = ReplaceAST (t->PROCESSOR_SUBSET.SUBSCRIPTS, pred, visit); 
  }
   return visit (t);

  }

/* line 1959 "Traverse.puma" */
  {
/* line 1961 "Traverse.puma" */
   failure_protocol (MODULE, "ReplaceAST", t);
  }
   return NoTree;

}

static void SetStatement
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kREG_SHADOW_GET) {
/* line 1973 "Traverse.puma" */
  {
/* line 1975 "Traverse.puma" */
   SetActualOverlap (t);
  }
   return;

  }
;
}

void BeginTraverse ARGS ((void))
{
}

void CloseTraverse ARGS ((void))
{
}
