# include "Transform.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 77 "Transform.puma" */


# include <stdio.h>
# include <string.h>

# include "Tree.h"
# include "Idents.h"
# include "StringM.h"
# include "DefTable.h"       /*              */
# include "Expressions.h"    /* MakeConstant */
# include "protocol.h"
# include "BuildTree.h"      /* use some same simple functionality */

# define MODULE "Transform"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTransform.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Transform_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Transform, routine %s failed\n",
  yyFunction);
 Transform_Exit ();
}

tTree CombineACF ARGS ((tTree list1, tTree list2));
tTree CompleteACFs ARGS ((tTree list));
tTree CombineDECL ARGS ((tTree list1, tTree list2));
tTree CombineBTP ARGS ((tTree list1, tTree list2));
tTree CompleteBTPs ARGS ((tTree list));
tTree CombineBTV ARGS ((tTree list1, tTree list2));
tTree CompleteBTVs ARGS ((tTree list));
tTree CombineBTE ARGS ((tTree list1, tTree list2));
tTree ReplaceACF ARGS ((tTree old, tTree newelem, tTree newnext));
static rbool IsEmptyStmt ARGS ((tTree t));
static void ReplaceACF_Set ARGS ((tTree newelem, int line, int save_label));
tTree ReplaceUNIT ARGS ((tTree old, tTree newelem, tTree newnext));
tTree ReplaceDECL ARGS ((tTree old, tTree newelem, tTree newnext));
tTree ReplaceBTP ARGS ((tTree old, tTree newelem, tTree newnext));
tTree AppendDECLS ARGS ((tTree t, tTree newlist));
static int DeclLevel ARGS ((tTree decl));
tTree ExpToVarParam ARGS ((tTree exp));
tTree ExpListToVarParamList ARGS ((tTree explist));
tTree VarParamToExp ARGS ((tTree param));
void SetVarParamAttributes ARGS ((tTree p, int intent));
tTree GetStringParams ARGS ((tIdent name));
tTree AppendParam ARGS ((tTree param_list, tTree param));
tTree ConcatParams ARGS ((tTree list1, tTree list2));
tTree ConcatVars ARGS ((tTree list1, tTree list2));
tTree AppendBody ARGS ((tTree list1, tTree list2));
tTree ComposeNewACF ARGS ((tTree pre, tTree s, tTree post));
tTree MakeIntegerType ARGS ((int size));
tTree MakeRealType ARGS ((int size));
tTree MakeLogicalType ARGS ((int size));
tTree MakeStringType ARGS ((int size));
tTree MakeStmtList ARGS ((tTree stmt));
tTree MakeVarDeclA ARGS ((tIdent id, String n, tTree val));
tTree MakeVarDeclAn ARGS ((tIdent id, String n, int no, tTree val));
tIdent MakeNewId ARGS ((tIdent id, String n));
tTree MakeUsedVarA ARGS ((tIdent id, String n));
tTree MakeRecCompA ARGS ((tIdent id, String n));
tTree MakeUsedVarAn ARGS ((tIdent id, String n, int no));
tTree MakeRecCompAn ARGS ((tIdent id, String n, int no));
tTree MakeVarParamDeclA ARGS ((tIdent id, String n));
tTree MakeVarParamDeclAn ARGS ((tIdent id, String n, int no));
tTree MakeVarSuffixA ARGS ((tTree var, String n));
tTree MakeVarSuffixAn ARGS ((tTree var, String n, int no));
static tIdent MakeIdentSuffixA ARGS ((tIdent ident, String n));
static tIdent MakeIdentSuffixAn ARGS ((tIdent ident, String n, int no));
void SetVarObject ARGS ((tTree var));
void LineACFNode ARGS ((tTree node, int line));
void LabelACFNode ARGS ((tTree node, int label));

tTree CombineACF
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
/* line 105 "Transform.puma" */
  {
/* line 106 "Transform.puma" */
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kACF_EMPTY) {
/* line 110 "Transform.puma" */
   return list2;

  }
  if (list1->Kind == kACF_LIST) {
/* line 114 "Transform.puma" */
  {
/* line 115 "Transform.puma" */
   if (! ((list1->ACF_LIST.Next == NoTree))) goto yyL3;
  {
/* line 116 "Transform.puma" */
 list1->ACF_LIST.Next = list2; 
  }
  }
   return list1;
yyL3:;

  if (list1->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 120 "Transform.puma" */
  {
/* line 121 "Transform.puma" */
 list1->ACF_LIST.Next = list2; 
  }
   return list1;

  }
/* line 125 "Transform.puma" */
  {
/* line 126 "Transform.puma" */
 list1->ACF_LIST.Next = CombineACF (list1->ACF_LIST.Next, list2); 
  }
   return list1;

  }
  if (Tree_IsType (list1, kACF_NODE)) {
/* line 130 "Transform.puma" */
   return mACF_LIST (list1, list2);

  }
/* line 134 "Transform.puma" */
  {
/* line 135 "Transform.puma" */
   failure_protocol (MODULE, "CombineACF", list1);
  }
   return NoTree;

}

tTree CompleteACFs
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
/* line 141 "Transform.puma" */
  {
/* line 143 "Transform.puma" */
   if (! ((list == NoTree))) goto yyL1;
  }
   return mACF_EMPTY ();
yyL1:;

  if (list->Kind == kACF_EMPTY) {
/* line 147 "Transform.puma" */
   return list;

  }
  if (list->Kind == kACF_LIST) {
/* line 152 "Transform.puma" */
  {
/* line 154 "Transform.puma" */
 list->ACF_LIST.Next = CompleteACFs (list->ACF_LIST.Next); 
  }
   return list;

  }
  if (Tree_IsType (list, kACF_NODE)) {
/* line 158 "Transform.puma" */
   return mACF_LIST (list, mACF_EMPTY ());

  }
/* line 163 "Transform.puma" */
  {
/* line 164 "Transform.puma" */
   failure_protocol (MODULE, "CompleteACFS", list);
  }
   return list;

}

tTree CombineDECL
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
/* line 179 "Transform.puma" */
  {
/* line 181 "Transform.puma" */
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kDECL_EMPTY) {
/* line 185 "Transform.puma" */
   return list2;

  }
  if (list1->Kind == kDECL_LIST) {
/* line 190 "Transform.puma" */
  {
/* line 192 "Transform.puma" */
   if (! ((list1->DECL_LIST.Next == NoTree))) goto yyL3;
  {
/* line 193 "Transform.puma" */
 list1->DECL_LIST.Next = list2; 
  }
  }
   return list1;
yyL3:;

  if (list1->DECL_LIST.Next->Kind == kDECL_EMPTY) {
/* line 197 "Transform.puma" */
  {
/* line 198 "Transform.puma" */
 list1->DECL_LIST.Next = list2; 
  }
   return list1;

  }
/* line 202 "Transform.puma" */
  {
/* line 203 "Transform.puma" */
 list1->DECL_LIST.Next = CombineDECL (list1->DECL_LIST.Next, list2); 
  }
   return list1;

  }
  if (Tree_IsType (list1, kDECL_NODE)) {
/* line 207 "Transform.puma" */
   return mDECL_LIST (list1, list2);

  }
/* line 212 "Transform.puma" */
  {
/* line 213 "Transform.puma" */
   failure_protocol (MODULE, "CombineDECL", list1);
  }
   return NoTree;

}

tTree CombineBTP
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
/* line 228 "Transform.puma" */
  {
/* line 229 "Transform.puma" */
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kBTP_EMPTY) {
/* line 233 "Transform.puma" */
   return list2;

  }
  if (list1->Kind == kBTP_LIST) {
/* line 237 "Transform.puma" */
  {
/* line 238 "Transform.puma" */
   if (! ((list1->BTP_LIST.Next == NoTree))) goto yyL3;
  {
/* line 239 "Transform.puma" */
 list1->BTP_LIST.Next = list2; 
  }
  }
   return list1;
yyL3:;

  if (list1->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 243 "Transform.puma" */
  {
/* line 244 "Transform.puma" */
 list1->BTP_LIST.Next = list2; 
  }
   return list1;

  }
/* line 248 "Transform.puma" */
  {
/* line 249 "Transform.puma" */
 list1->BTP_LIST.Next = CombineBTP (list1->BTP_LIST.Next, list2); 
  }
   return list1;

  }
/* line 253 "Transform.puma" */
   return mBTP_LIST (list1, list2);

}

tTree CompleteBTPs
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
/* line 259 "Transform.puma" */
  {
/* line 260 "Transform.puma" */
   if (! ((list == NoTree))) goto yyL1;
  }
   return mBTP_EMPTY ();
yyL1:;

  if (list->Kind == kBTP_EMPTY) {
/* line 264 "Transform.puma" */
   return list;

  }
  if (list->Kind == kBTP_LIST) {
/* line 268 "Transform.puma" */
  {
/* line 269 "Transform.puma" */
 list->BTP_LIST.Next = CompleteBTPs (list->BTP_LIST.Next); 
  }
   return list;

  }
/* line 273 "Transform.puma" */
  {
/* line 274 "Transform.puma" */
   failure_protocol (MODULE, "CompleteBTPS", list);
  }
   return list;

}

tTree CombineBTV
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
/* line 289 "Transform.puma" */
  {
/* line 290 "Transform.puma" */
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kBTV_EMPTY) {
/* line 294 "Transform.puma" */
   return list2;

  }
  if (list1->Kind == kBTV_LIST) {
/* line 298 "Transform.puma" */
  {
/* line 299 "Transform.puma" */
   if (! ((list1->BTV_LIST.Next == NoTree))) goto yyL3;
  {
/* line 300 "Transform.puma" */
 list1->BTV_LIST.Next = list2; 
  }
  }
   return list1;
yyL3:;

  if (list1->BTV_LIST.Next->Kind == kBTV_EMPTY) {
/* line 304 "Transform.puma" */
  {
/* line 305 "Transform.puma" */
 list1->BTV_LIST.Next = list2; 
  }
   return list1;

  }
/* line 309 "Transform.puma" */
  {
/* line 310 "Transform.puma" */
 list1->BTV_LIST.Next = CombineBTV (list1->BTV_LIST.Next, list2); 
  }
   return list1;

  }
/* line 314 "Transform.puma" */
   return mBTV_LIST (list1, list2);

}

tTree CompleteBTVs
# if defined __STDC__ | defined __cplusplus
(register tTree list)
# else
(list)
 register tTree list;
# endif
{
/* line 320 "Transform.puma" */
  {
/* line 321 "Transform.puma" */
   if (! ((list == NoTree))) goto yyL1;
  }
   return mBTV_EMPTY ();
yyL1:;

  if (list->Kind == kBTV_EMPTY) {
/* line 325 "Transform.puma" */
   return list;

  }
  if (list->Kind == kBTV_LIST) {
/* line 329 "Transform.puma" */
  {
/* line 330 "Transform.puma" */
 list->BTV_LIST.Next = CompleteBTVs (list->BTV_LIST.Next); 
  }
   return list;

  }
/* line 334 "Transform.puma" */
  {
/* line 335 "Transform.puma" */
   failure_protocol (MODULE, "CompleteBTVS", list);
  }
   return list;

}

tTree CombineBTE
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
/* line 350 "Transform.puma" */
  {
/* line 351 "Transform.puma" */
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kBTE_EMPTY) {
/* line 355 "Transform.puma" */
   return list2;

  }
  if (list1->Kind == kBTE_LIST) {
/* line 359 "Transform.puma" */
  {
/* line 360 "Transform.puma" */
   if (! ((list1->BTE_LIST.Next == NoTree))) goto yyL3;
  {
/* line 361 "Transform.puma" */
 list1->BTE_LIST.Next = list2; 
  }
  }
   return list1;
yyL3:;

  if (list1->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 365 "Transform.puma" */
  {
/* line 366 "Transform.puma" */
 list1->BTE_LIST.Next = list2; 
  }
   return list1;

  }
/* line 370 "Transform.puma" */
  {
/* line 371 "Transform.puma" */
 list1->BTE_LIST.Next = CombineBTE (list1->BTE_LIST.Next, list2); 
  }
   return list1;

  }
/* line 375 "Transform.puma" */
   return mBTE_LIST (list1, list2);

}

tTree ReplaceACF
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree newelem, register tTree newnext)
# else
(old, newelem, newnext)
 register tTree old;
 register tTree newelem;
 register tTree newnext;
# endif
{
  if (old->Kind == kACF_LIST) {
/* line 402 "Transform.puma" */
  {
/* line 406 "Transform.puma" */
   if (! ((old->ACF_LIST.Elem->ACF_NODE.Label == 0))) goto yyL1;
  {
/* line 408 "Transform.puma" */
   if (! ((IsEmptyStmt (newelem)))) goto yyL1;
  }
  }
   return newnext;
yyL1:;

/* line 421 "Transform.puma" */
 {
  tTree elem1;
  {
/* line 425 "Transform.puma" */
   if (! ((IsEmptyStmt (newelem)))) goto yyL2;
  {
/* line 429 "Transform.puma" */
 

      elem1 = mACF_DUMMY ();
      SetACFNode (elem1, old->ACF_LIST.Elem->ACF_NODE.Label, old->ACF_LIST.Elem->ACF_NODE.Line);
      old->ACF_LIST.Elem = elem1;
      old->ACF_LIST.Next = newnext;
    
  }
  }
   return old;
 }
yyL2:;

/* line 445 "Transform.puma" */
  {
/* line 446 "Transform.puma" */
   if (! ((old->ACF_LIST.Elem == newelem))) goto yyL3;
  {
/* line 447 "Transform.puma" */
 old->ACF_LIST.Next = newnext; 
  }
  }
   return old;
yyL3:;

  if (Tree_IsType (newelem, kACF_NODE)) {
/* line 457 "Transform.puma" */
 {
  int save_label;
  {
/* line 462 "Transform.puma" */
 save_label = old->ACF_LIST.Elem->ACF_NODE.Label;  
       old->ACF_LIST.Elem->ACF_NODE.Label  = 0;          
       if (save_label != 0) newelem->ACF_NODE.Label  = save_label;
       newelem->ACF_NODE.Line   = old->ACF_LIST.Elem->ACF_NODE.Line;
       old->ACF_LIST.Elem = newelem;
       old->ACF_LIST.Next = newnext;   
     
  }
   return old;
 }

  }
  if (newelem->Kind == kACF_LIST) {
/* line 478 "Transform.puma" */
 {
  int save_label;
  {
/* line 483 "Transform.puma" */
 save_label = old->ACF_LIST.Elem->ACF_NODE.Label;  
      old->ACF_LIST.Elem->ACF_NODE.Label = 0;           
      ReplaceACF_Set (newelem, old->ACF_LIST.Elem->ACF_NODE.Line, save_label);
      if (save_label != 0) newelem->ACF_LIST.Elem->ACF_NODE.Label  = save_label;
    
  }
   return CombineACF (newelem, newnext);
 }

  }
  }
/* line 491 "Transform.puma" */
  {
/* line 493 "Transform.puma" */
   failure2_protocol (MODULE, "ReplaceACF", old, newelem);
  }
   return NoTree;

}

static rbool IsEmptyStmt
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 500 "Transform.puma" */
  {
/* line 502 "Transform.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (t->Kind == kACF_EMPTY) {
/* line 505 "Transform.puma" */
   return rtrue;

  }
  return rfalse;
}

static void ReplaceACF_Set
# if defined __STDC__ | defined __cplusplus
(register tTree newelem, register int line, register int save_label)
# else
(newelem, line, save_label)
 register tTree newelem;
 register int line;
 register int save_label;
# endif
{
  if (newelem->Kind == kACF_LIST) {
/* line 516 "Transform.puma" */
  {
/* line 518 "Transform.puma" */
 newelem->ACF_LIST.Elem->ACF_NODE.Line = line;
     if (newelem->ACF_LIST.Elem->ACF_NODE.Label == save_label) newelem->ACF_LIST.Elem->ACF_NODE.Label = 0;
     if (newelem->ACF_LIST.Next != NoTree)
        ReplaceACF_Set (newelem->ACF_LIST.Next, line, save_label);
   
  }
   return;

  }
;
}

tTree ReplaceUNIT
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree newelem, register tTree newnext)
# else
(old, newelem, newnext)
 register tTree old;
 register tTree newelem;
 register tTree newnext;
# endif
{
  if (old->Kind == kUNIT_LIST) {
/* line 537 "Transform.puma" */
  {
/* line 539 "Transform.puma" */
   if (! ((newelem == NoTree))) goto yyL1;
  }
   return old->UNIT_LIST.Next;
yyL1:;

  if (Tree_IsType (newelem, kUNIT_NODE)) {
/* line 543 "Transform.puma" */
  {
/* line 547 "Transform.puma" */
 old->UNIT_LIST.Elem = newelem;
     old->UNIT_LIST.Next = newnext;
   
  }
   return old;

  }
  }
/* line 553 "Transform.puma" */
  {
/* line 555 "Transform.puma" */
   failure2_protocol (MODULE, "ReplaceUNIT", newelem, newnext);
  }
   return NoTree;

}

tTree ReplaceDECL
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree newelem, register tTree newnext)
# else
(old, newelem, newnext)
 register tTree old;
 register tTree newelem;
 register tTree newnext;
# endif
{
  if (old->Kind == kDECL_LIST) {
/* line 571 "Transform.puma" */
  {
/* line 572 "Transform.puma" */
   if (! ((newelem == NoTree))) goto yyL1;
  }
   return old->DECL_LIST.Next;
yyL1:;

  if (Tree_IsType (newelem, kDECL_NODE)) {
/* line 576 "Transform.puma" */
  {
/* line 581 "Transform.puma" */
 old->DECL_LIST.Elem = newelem;
     old->DECL_LIST.Next = newnext;
   
  }
   return old;

  }
  if (newelem->Kind == kDECL_LIST) {
/* line 587 "Transform.puma" */
 {
  tTree hdecl;
  {
/* line 592 "Transform.puma" */
 hdecl = newelem;
     while (hdecl->DECL_LIST.Next != NoTree)
         hdecl = hdecl->DECL_LIST.Next;
     hdecl->DECL_LIST.Next = newnext;
   
  }
   return newelem;
 }

  }
  }
/* line 600 "Transform.puma" */
  {
/* line 601 "Transform.puma" */
   failure2_protocol (MODULE, "ReplaceDECL", newelem, newnext);
  }
   return NoTree;

}

tTree ReplaceBTP
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree newelem, register tTree newnext)
# else
(old, newelem, newnext)
 register tTree old;
 register tTree newelem;
 register tTree newnext;
# endif
{
  if (old->Kind == kBTP_LIST) {
/* line 617 "Transform.puma" */
  {
/* line 618 "Transform.puma" */
   if (! ((newelem == NoTree))) goto yyL1;
  }
   return old->BTP_LIST.Next;
yyL1:;

  if (Tree_IsType (newelem, kBT_PARAM)) {
/* line 622 "Transform.puma" */
  {
/* line 627 "Transform.puma" */
 old->BTP_LIST.Elem = newelem;
     old->BTP_LIST.Next = newnext;
   
  }
   return old;

  }
  if (newelem->Kind == kBTP_LIST) {
/* line 633 "Transform.puma" */
 {
  tTree hdecl;
  {
/* line 638 "Transform.puma" */
 hdecl = newelem;
     while (hdecl->BTP_LIST.Next != NoTree)
         hdecl = hdecl->BTP_LIST.Next;
     hdecl->BTP_LIST.Next = newnext;
   
  }
   return newelem;
 }

  }
  }
/* line 646 "Transform.puma" */
  {
/* line 647 "Transform.puma" */
   failure2_protocol (MODULE, "ReplaceBTP", newelem, newnext);
  }
   return NoTree;

}

tTree AppendDECLS
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tTree newlist)
# else
(t, newlist)
 register tTree t;
 register tTree newlist;
# endif
{
/* line 659 "Transform.puma" */
  {
/* line 660 "Transform.puma" */
   if (! (newlist == NoTree)) goto yyL1;
  {
/* line 661 "Transform.puma" */
   printf ("AppendDECLS: newlist = NoTree\n");
/* line 662 "Transform.puma" */
   exit (- 1);
  }
  }
   return t;
yyL1:;

/* line 666 "Transform.puma" */
  {
/* line 667 "Transform.puma" */
   if (! ((t == NoTree))) goto yyL2;
  }
   return newlist;
yyL2:;

  if (t->Kind == kDECL_LIST) {
  if (t->DECL_LIST.Elem->Kind == kSTMT_FUNC_DECL) {
  if (newlist->Kind == kDECL_LIST) {
  if (newlist->DECL_LIST.Elem->Kind == kSTMT_FUNC_DECL) {
/* line 671 "Transform.puma" */
  {
/* line 672 "Transform.puma" */
 t->DECL_LIST.Next = AppendDECLS (t->DECL_LIST.Next, newlist); 
  }
   return t;

  }
  }
  }
  if (newlist->Kind == kDECL_LIST) {
/* line 676 "Transform.puma" */
  {
/* line 680 "Transform.puma" */
   if (! ((DeclLevel (newlist->DECL_LIST.Elem) < DeclLevel (t->DECL_LIST.Elem)))) goto yyL4;
  }
   return AppendDECLS (newlist, t);
yyL4:;

  }
/* line 685 "Transform.puma" */
  {
/* line 686 "Transform.puma" */
 t->DECL_LIST.Next = AppendDECLS (t->DECL_LIST.Next, newlist); 
  }
   return t;

  }
  if (t->Kind == kDECL_EMPTY) {
/* line 690 "Transform.puma" */
   return newlist;

  }
 yyAbort ("AppendDECLS");
 { tTree yyDummy; return yyDummy; }
}

static int DeclLevel
# if defined __STDC__ | defined __cplusplus
(register tTree decl)
# else
(decl)
 register tTree decl;
# endif
{
  if (decl->Kind == kIMPLICIT_DECL) {
/* line 696 "Transform.puma" */
   return 0;

  }
  if (decl->Kind == kUSE_DECL) {
/* line 697 "Transform.puma" */
   return 1;

  }
  if (decl->Kind == kDATA_DECL) {
/* line 698 "Transform.puma" */
   return 4;

  }
  if (decl->Kind == kSTMT_FUNC_DECL) {
/* line 699 "Transform.puma" */
   return 5;

  }
/* line 700 "Transform.puma" */
   return 2;

}

tTree ExpToVarParam
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kVAR_EXP) {
/* line 710 "Transform.puma" */
   return (mVAR_PARAM (exp->VAR_EXP.V));

  }
/* line 714 "Transform.puma" */
   return (mVAR_PARAM (mADDR (exp)));

}

tTree ExpListToVarParamList
# if defined __STDC__ | defined __cplusplus
(register tTree explist)
# else
(explist)
 register tTree explist;
# endif
{
  if (explist->Kind == kBTE_LIST) {
/* line 720 "Transform.puma" */
   return mBTP_LIST (ExpToVarParam (explist->BTE_LIST.Elem), ExpListToVarParamList (explist->BTE_LIST.Next));

  }
  if (explist->Kind == kBTE_EMPTY) {
/* line 725 "Transform.puma" */
   return mBTP_EMPTY ();

  }
 yyAbort ("ExpListToVarParamList");
 { tTree yyDummy; return yyDummy; }
}

tTree VarParamToExp
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (param->VAR_PARAM.V->Kind == kADDR) {
/* line 732 "Transform.puma" */
   return param->VAR_PARAM.V->ADDR.E;

  }
/* line 737 "Transform.puma" */
   return mVAR_EXP (param->VAR_PARAM.V);

  }
/* line 742 "Transform.puma" */
  {
/* line 743 "Transform.puma" */
   failure_protocol (MODULE, "VarParamToExp", param);
  }
   return param;

}

void SetVarParamAttributes
# if defined __STDC__ | defined __cplusplus
(register tTree p, register int intent)
# else
(p, intent)
 register tTree p;
 register int intent;
# endif
{
  if (p->Kind == kVAR_PARAM) {
/* line 753 "Transform.puma" */
  {
/* line 755 "Transform.puma" */
 p->VAR_PARAM.intent = intent; 
  }
   return;

  }
/* line 758 "Transform.puma" */
  {
/* line 760 "Transform.puma" */
   failure_protocol (MODULE, "SetVarParamAttributes", p);
  }
   return;

;
}

tTree GetStringParams
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
/* line 769 "Transform.puma" */

char sname [100];
int  slength;
tTree param, paramlist;

/* line 775 "Transform.puma" */
  {
/* line 776 "Transform.puma" */
 GetString (name, sname);
    slength = strlen (sname);
    param = ExpToVarParam (MakeConstant (slength));
    paramlist = mBTP_LIST (param, NoTree);
    param = mCONST_EXP (mSTRING_CONSTANT (PutString (sname, slength)));
    param = ExpToVarParam (param);
    paramlist = mBTP_LIST (param, paramlist);
  
  }
   return paramlist;

}

tTree AppendParam
# if defined __STDC__ | defined __cplusplus
(register tTree param_list, register tTree param)
# else
(param_list, param)
 register tTree param_list;
 register tTree param;
# endif
{
  if (param_list->Kind == kBTP_EMPTY) {
/* line 797 "Transform.puma" */
   return mBTP_LIST (param, param_list);

  }
  if (param_list->Kind == kBTP_LIST) {
/* line 802 "Transform.puma" */
  {
/* line 804 "Transform.puma" */
 param_list->BTP_LIST.Next = AppendParam (param_list->BTP_LIST.Next, param); 
  }
   return param_list;

  }
/* line 809 "Transform.puma" */
  {
/* line 811 "Transform.puma" */
   failure2_protocol (MODULE, "AppendParam", param_list, param);
  }
   return NoTree;

}

tTree ConcatParams
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
/* line 824 "Transform.puma" */
  {
/* line 825 "Transform.puma" */
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kBTP_EMPTY) {
/* line 829 "Transform.puma" */
   return list2;

  }
  if (list1->Kind == kBTP_LIST) {
/* line 833 "Transform.puma" */
  {
/* line 834 "Transform.puma" */
 list1->BTP_LIST.Next = ConcatParams (list1->BTP_LIST.Next, list2); 
  }
   return list1;

  }
  if (Tree_IsType (list1, kBT_PARAM)) {
/* line 838 "Transform.puma" */
   return mBTP_LIST (list1, list2);

  }
/* line 842 "Transform.puma" */
  {
/* line 843 "Transform.puma" */
   failure2_protocol (MODULE, "ConcatParams", list1, list2);
  }
   return list2;

}

tTree ConcatVars
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
/* line 849 "Transform.puma" */
  {
/* line 850 "Transform.puma" */
   if (! ((list1 == NoTree))) goto yyL1;
  }
   return list2;
yyL1:;

  if (list1->Kind == kBTV_EMPTY) {
/* line 854 "Transform.puma" */
   return list2;

  }
  if (list1->Kind == kBTV_LIST) {
/* line 858 "Transform.puma" */
  {
/* line 859 "Transform.puma" */
 list1->BTV_LIST.Next = ConcatVars (list1->BTV_LIST.Next, list2); 
  }
   return list1;

  }
  if (Tree_IsType (list1, kBT_VAR)) {
/* line 863 "Transform.puma" */
   return mBTV_LIST (list1, list2);

  }
/* line 867 "Transform.puma" */
  {
/* line 868 "Transform.puma" */
   failure2_protocol (MODULE, "ConcatVars", list1, list2);
  }
   return list2;

}

tTree AppendBody
# if defined __STDC__ | defined __cplusplus
(register tTree list1, register tTree list2)
# else
(list1, list2)
 register tTree list1;
 register tTree list2;
# endif
{
  if (list1->Kind == kACF_EMPTY) {
/* line 883 "Transform.puma" */
  {
/* line 884 "Transform.puma" */
   if (! ((list2 == NoTree))) goto yyL1;
  }
   return list1;
yyL1:;

  if (list2->Kind == kACF_LIST) {
/* line 888 "Transform.puma" */
  {
/* line 889 "Transform.puma" */
 list2->ACF_LIST.Next = AppendBody (list1, list2->ACF_LIST.Next); 
  }
   return list2;

  }
  if (Tree_IsType (list2, kACF_NODE)) {
/* line 893 "Transform.puma" */
   return mACF_LIST (list2, list1);

  }
  }
  if (list1->Kind == kACF_LIST) {
/* line 897 "Transform.puma" */
  {
/* line 898 "Transform.puma" */
 list1->ACF_LIST.Next = AppendBody (list1->ACF_LIST.Next, list2); 
  }
   return list1;

  }
/* line 902 "Transform.puma" */
  {
/* line 903 "Transform.puma" */
   failure2_protocol (MODULE, "AppendBody", list1, list2);
  }
   return NoTree;

}

tTree ComposeNewACF
# if defined __STDC__ | defined __cplusplus
(register tTree pre, register tTree s, register tTree post)
# else
(pre, s, post)
 register tTree pre;
 register tTree s;
 register tTree post;
# endif
{
/* line 909 "Transform.puma" */
  {
/* line 911 "Transform.puma" */
   if (! ((pre == NoTree))) goto yyL1;
  {
/* line 912 "Transform.puma" */
   if (! ((post == NoTree))) goto yyL1;
  }
  }
   return s;
yyL1:;

/* line 917 "Transform.puma" */
   return CombineACF (pre, CombineACF (s, post));

}

tTree MakeIntegerType
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
/* line 924 "Transform.puma" */
   return mINTEGER_TYPE (mCONST_EXP (mINT_CONSTANT (size)));

}

tTree MakeRealType
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
/* line 930 "Transform.puma" */
   return mREAL_TYPE (mCONST_EXP (mINT_CONSTANT (size)));

}

tTree MakeLogicalType
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
/* line 936 "Transform.puma" */
   return mBOOLEAN_TYPE (mCONST_EXP (mINT_CONSTANT (size)));

}

tTree MakeStringType
# if defined __STDC__ | defined __cplusplus
(register int size)
# else
(size)
 register int size;
# endif
{
/* line 942 "Transform.puma" */
   return mSTRING_TYPE (mCONST_EXP (mINT_CONSTANT (size)));

}

tTree MakeStmtList
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_EMPTY) {
/* line 954 "Transform.puma" */
   return stmt;

  }
  if (stmt->Kind == kACF_LIST) {
/* line 959 "Transform.puma" */
   return stmt;

  }
  if (Tree_IsType (stmt, kACF_NODE)) {
/* line 964 "Transform.puma" */
   return mACF_LIST (stmt, mACF_EMPTY ());

  }
/* line 969 "Transform.puma" */
  {
/* line 970 "Transform.puma" */
   failure_protocol (MODULE, "MakeStmtList", stmt);
  }
   return NoTree;

}

tTree MakeVarDeclA
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n, register tTree val)
# else
(id, n, val)
 register tIdent id;
 String n;
 register tTree val;
# endif
{
/* line 984 "Transform.puma" */

char hstring[250];
tIdent hid;

/* line 989 "Transform.puma" */
  {
/* line 990 "Transform.puma" */
 GetString (id, hstring);
     strcat (hstring, n);
     hid = MakeIdent (hstring, strlen (hstring));
   
  }
   return (mVAR_DECL (hid, 0, val));

}

tTree MakeVarDeclAn
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n, register int no, register tTree val)
# else
(id, n, no, val)
 register tIdent id;
 String n;
 register int no;
 register tTree val;
# endif
{
/* line 1007 "Transform.puma" */

char hstring[250];
tIdent hid;

/* line 1012 "Transform.puma" */
  {
/* line 1013 "Transform.puma" */
 GetString (id, hstring);
     sprintf (hstring, "%s%s%d", hstring, n, no);
     hid = MakeIdent (hstring, strlen (hstring));
   
  }
   return (mVAR_DECL (hid, 0, val));

}

tIdent MakeNewId
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n)
# else
(id, n)
 register tIdent id;
 String n;
# endif
{
/* line 1030 "Transform.puma" */

char hstring[MAX_ID_LENGTH];

/* line 1034 "Transform.puma" */
  {
/* line 1036 "Transform.puma" */
   GetString (id, hstring);
/* line 1037 "Transform.puma" */
   strcat (hstring, n);
  }
   return MakeIdent (hstring, strlen (hstring));

}

tTree MakeUsedVarA
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n)
# else
(id, n)
 register tIdent id;
 String n;
# endif
{
/* line 1044 "Transform.puma" */

char hstring[250];
tIdent hid;
tTree v;

/* line 1050 "Transform.puma" */
  {
/* line 1051 "Transform.puma" */
 GetString (id, hstring);
     strcat (hstring, n);
     hid = MakeIdent (hstring, strlen (hstring));
     v = mVAR_OBJ (0, hid);
     v->VAR_OBJ.Object = NoObject;
   
  }
   return mUSED_VAR (v);

}

tTree MakeRecCompA
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n)
# else
(id, n)
 register tIdent id;
 String n;
# endif
{
/* line 1062 "Transform.puma" */

char hstring[250];
tIdent hid;
tTree v;

/* line 1068 "Transform.puma" */
  {
/* line 1070 "Transform.puma" */
 GetString (id, hstring);
     strcat (hstring, n);
     hid = MakeIdent (hstring, strlen (hstring));
     v = mREC_COMP (hid);
     v->REC_COMP.Object = NoObject;
   
  }
   return v;

}

tTree MakeUsedVarAn
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n, register int no)
# else
(id, n, no)
 register tIdent id;
 String n;
 register int no;
# endif
{
/* line 1089 "Transform.puma" */

char hstring[250];
tIdent hid;
tTree v;

/* line 1095 "Transform.puma" */
  {
/* line 1096 "Transform.puma" */
 GetString (id, hstring);
     sprintf (hstring, "%s%s%d", hstring, n, no);
     hid = MakeIdent (hstring, strlen (hstring));
     v = mVAR_OBJ (0, hid);
     v->VAR_OBJ.Object = NoObject;
   
  }
   return mUSED_VAR (v);

}

tTree MakeRecCompAn
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n, register int no)
# else
(id, n, no)
 register tIdent id;
 String n;
 register int no;
# endif
{
/* line 1107 "Transform.puma" */

char hstring[250];
tIdent hid;
tTree v;

/* line 1113 "Transform.puma" */
  {
/* line 1115 "Transform.puma" */
 GetString (id, hstring);
     sprintf (hstring, "%s%s%d", hstring, n, no);
     hid = MakeIdent (hstring, strlen (hstring));
     v = mREC_COMP (hid);
     v->REC_COMP.Object = NoObject;
   
  }
   return v;

}

tTree MakeVarParamDeclA
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n)
# else
(id, n)
 register tIdent id;
 String n;
# endif
{
/* line 1134 "Transform.puma" */

char hstring[250];
tIdent hid;

/* line 1139 "Transform.puma" */
  {
/* line 1140 "Transform.puma" */
 GetString (id, hstring);
     strcat (hstring, n);
     hid = MakeIdent (hstring, strlen (hstring));
   
  }
   return (mVAR_PARAM_DECL (hid, 0, mDUMMY_TYPE ()));

}

tTree MakeVarParamDeclAn
# if defined __STDC__ | defined __cplusplus
(register tIdent id, String n, register int no)
# else
(id, n, no)
 register tIdent id;
 String n;
 register int no;
# endif
{
/* line 1157 "Transform.puma" */

char hstring[250];
tIdent hid;

/* line 1162 "Transform.puma" */
  {
/* line 1163 "Transform.puma" */
 GetString (id, hstring);
     sprintf (hstring, "%s%s%d", hstring, n, no);
     hid = MakeIdent (hstring, strlen (hstring));
   
  }
   return (mVAR_PARAM_DECL (hid, 0, mDUMMY_TYPE ()));

}

tTree MakeVarSuffixA
# if defined __STDC__ | defined __cplusplus
(register tTree var, String n)
# else
(var, n)
 register tTree var;
 String n;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 1181 "Transform.puma" */
 {
  tTree v;
  {
/* line 1185 "Transform.puma" */
 v = mVAR_OBJ (0, MakeIdentSuffixA (var->USED_VAR.VARNAME->VAR_OBJ.Ident, n));
     v->VAR_OBJ.Object = NoObject;
   
  }
   return mUSED_VAR (v);
 }

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 1191 "Transform.puma" */
 {
  tTree v;
  {
/* line 1195 "Transform.puma" */
 v = mREC_COMP (MakeIdentSuffixA (var->SELECTED_VAR.SELECTOR->REC_COMP.Ident, n));
     v->REC_COMP.Object = NoObject;
   
  }
   return mSELECTED_VAR (CopyTree (var->SELECTED_VAR.SELEC_VAR), v);
 }

  }
/* line 1201 "Transform.puma" */
  {
/* line 1203 "Transform.puma" */
   failure_protocol (MODULE, "MakeVarSuffixA", var);
  }
   return NoTree;

}

tTree MakeVarSuffixAn
# if defined __STDC__ | defined __cplusplus
(register tTree var, String n, register int no)
# else
(var, n, no)
 register tTree var;
 String n;
 register int no;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 1209 "Transform.puma" */
 {
  tTree v;
  {
/* line 1213 "Transform.puma" */
 v = mVAR_OBJ (0, MakeIdentSuffixAn (var->USED_VAR.VARNAME->VAR_OBJ.Ident, n, no));
     v->VAR_OBJ.Object = NoObject;
   
  }
   return mUSED_VAR (v);
 }

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 1219 "Transform.puma" */
 {
  tTree v;
  {
/* line 1223 "Transform.puma" */
 v = mREC_COMP (MakeIdentSuffixAn (var->SELECTED_VAR.SELECTOR->REC_COMP.Ident, n, no));
     v->REC_COMP.Object = NoObject;
   
  }
   return mSELECTED_VAR (CopyTree (var->SELECTED_VAR.SELEC_VAR), v);
 }

  }
/* line 1230 "Transform.puma" */
  {
/* line 1232 "Transform.puma" */
   failure_protocol (MODULE, "MakeVarSuffixA", var);
  }
   return NoTree;

}

static tIdent MakeIdentSuffixA
# if defined __STDC__ | defined __cplusplus
(register tIdent ident, String n)
# else
(ident, n)
 register tIdent ident;
 String n;
# endif
{
/* line 1244 "Transform.puma" */

char   name[250];
tIdent new_id;

/* line 1249 "Transform.puma" */
  {
/* line 1251 "Transform.puma" */
   GetString (ident, name);
/* line 1252 "Transform.puma" */
   strcat (name, n);
  }
   return MakeIdent (name, strlen (name));

}

static tIdent MakeIdentSuffixAn
# if defined __STDC__ | defined __cplusplus
(register tIdent ident, String n, register int no)
# else
(ident, n, no)
 register tIdent ident;
 String n;
 register int no;
# endif
{
/* line 1258 "Transform.puma" */

char   name[250];
tIdent new_id;

/* line 1263 "Transform.puma" */
  {
/* line 1265 "Transform.puma" */
   GetString (ident, name);
/* line 1266 "Transform.puma" */
   sprintf (name, "%s%s%d", name, n, no);
  }
   return MakeIdent (name, strlen (name));

}

void SetVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kVAR_OBJ) {
/* line 1278 "Transform.puma" */
  {
/* line 1280 "Transform.puma" */
 var->VAR_OBJ.Object = GetGlobalObject (var->VAR_OBJ.Ident); 
  }
   return;

  }
  if (var->Kind == kUSED_VAR) {
/* line 1283 "Transform.puma" */
  {
/* line 1285 "Transform.puma" */
   var = var->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 1288 "Transform.puma" */
  {
/* line 1290 "Transform.puma" */
   var = var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
/* line 1293 "Transform.puma" */
  {
/* line 1295 "Transform.puma" */
   failure_protocol (MODULE, "SetVarObject", var);
  }
   return;

;
}

void LineACFNode
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int line)
# else
(node, line)
 register tTree node;
 register int line;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
/* line 1307 "Transform.puma" */
  {
/* line 1309 "Transform.puma" */
   node->ACF_NODE.Line = line;
  }
   return;

  }
;
}

void LabelACFNode
# if defined __STDC__ | defined __cplusplus
(register tTree node, register int label)
# else
(node, label)
 register tTree node;
 register int label;
# endif
{
  if (Tree_IsType (node, kACF_NODE)) {
/* line 1314 "Transform.puma" */
  {
/* line 1316 "Transform.puma" */
   node->ACF_NODE.Label = label;
  }
   return;

  }
;
}

void BeginTransform ARGS ((void))
{
}

void CloseTransform ARGS ((void))
{
}
