# include "Temporary.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 57 "Temporary.puma" */


# undef DEBUG

# define MODULE "Temporary"

# include <string.h>

# include "Idents.h"
# include "DynArray.h"         /* dynamic array for used declarations */

# include "protocol.h"

# include "DefTable.h"

# include "TreeOps.h"           /* TreeListLength                   */
# include "Transform.h"         /* AppendDECLS, CombineACF          */
# include "Types.h"             /* ArrayCompType                    */
# include "Expressions.h"       /* EqualExpression                  */
# include "Shapes.h"            /* GetFormalShape, MakeShapedVar   */

# include "Nesting.h"           /* GetCurrentUnitObj                */
# include "Objects.h"           /* MakeNewObject                    */
# include "TempVars.h"          /* MakeTempVar, ...                 */

# include "ExpDescriptor.h"
# include "HomeDescriptor.h"
# include "Expansion.h"

static tTree new_decls;         /* global used for new declarations */

static tTree new_allocate;
static tTree new_deallocate;

     /***************************************************************
     *                                                              *
     *  Dynamic Table of temporary declarations in use              *
     *                                                              *
     *  - temporaries in this table are in use                      *
     *  - all other temporaries will be reused if possible          *
     *                                                              *
     ***************************************************************/

static tTree *used_decls;
static tTree used_loop_decl[MAX_FORALL];
static int   used_counter = 0;
static unsigned long  used_max     = 0;

void VerifyUsedArray ()
{
  if (used_decls == (tTree *) 0)
   { printf ("Could not extend used declarations array to size %d\n", used_max);
     printf ("Internal Error\n");
     exit (-1);
   }

} /* VerifyUsedArray */

void InitUsedDecls ()

{ int i;

  used_counter = 0;

  if (used_max == 0)
     { used_max = 30;
       MakeArray ( (char * *) &used_decls, &used_max, 
                   (unsigned long) sizeof (tTree));
     }

  for (i=0; i<MAX_FORALL; i++)
    used_loop_decl [i] = NoTree;

} /* InitUsedDecls */

void FreeUsedDecls ()

{ int i;

  used_counter = 0;

  for (i=0; i<MAX_FORALL; i++)
    used_loop_decl [i] = NoTree;

} /* FreeUsedDecls */

void UseDeclaration (decl)
tTree decl;
{
  if (used_counter == used_max)
    { /* extend the dynamic array before */
      ExtendArray ((char **) &used_decls, &used_max, 
                   (unsigned long) sizeof (tTree));
      VerifyUsedArray ();
    }

  used_decls [used_counter] = decl;
  used_counter ++;

} /* UseDeclaration */

int IsDeclUsed (decl)
tTree decl;
{  int found, i;
   i = 0;
   found = 0;
   while ((i < used_counter) && (found == 0))
     { if (used_decls[i] == decl)
          found = 1;
        else
          i++;
     }
 
   return (found);

} /* IsDeclUsed */

# define kVarTemporary     0
# define kScalarTemporary  1



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTemporary.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Temporary_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Temporary, routine %s failed\n",
  yyFunction);
 Temporary_Exit ();
}

void TemporaryInit ARGS ((tTree t));
void TemporaryDone ARGS ((tTree t));
void FreeTemporaries ARGS ((tTree * yyP2, tTree * yyP1));
tTree MakeScalarTemporary ARGS ((tTree exp));
tTree GetScalarTemporary ARGS ((tTree type));
tTree GetLoopTemporary ARGS ((int n));
tTree GetVarTemporary ARGS ((tTree var));
void GetMemoryStmts ARGS ((tTree * yyP4, tTree * yyP3));
static tTree Decl2VarObj ARGS ((tTree decl));
static rbool MatchScalar ARGS ((tTree decl, tTree type));
static rbool IsTheSameType ARGS ((tTree type1, tTree type2));
static tTree MakeNewScalarTemporary ARGS ((tTree type));
static void MakeReplMapping ARGS ((tDefinitions obj));
static tTree CopyObjectType ARGS ((tTree decl));
tTree GetVDTemporary ARGS ((pvar vard));
tTree GetVDPtrTemporary ARGS ((pvar vard));
static tTree GetTempByDescriptor ARGS ((pvar vard, rbool is_pointer));
static tIdent NewTemporaryId ARGS ((int n, int kind));

void TemporaryInit
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 187 "Temporary.puma" */
  {
/* line 189 "Temporary.puma" */
   new_decls = mDECL_EMPTY ();
/* line 190 "Temporary.puma" */
   new_allocate = NoTree;
/* line 191 "Temporary.puma" */
   new_deallocate = NoTree;
/* line 192 "Temporary.puma" */
   InitUsedDecls ();
  }
   return;

  }
/* line 195 "Temporary.puma" */
  {
/* line 196 "Temporary.puma" */
   failure_protocol ("Temporary", "TemporaryInit", t);
  }
   return;

;
}

void TemporaryDone
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 207 "Temporary.puma" */
  {
/* line 211 "Temporary.puma" */
 if (used_counter != 0)
       printf ("Internal Error: temporaries are not all freed\n");
   
/* line 217 "Temporary.puma" */
   tree_protocol ("These are the new created temporaries : \n", new_decls);
/* line 219 "Temporary.puma" */
 t->BODY_NODE.NEW_DECLS = AppendDECLS (t->BODY_NODE.NEW_DECLS, new_decls);  
  }
   return;

  }
/* line 222 "Temporary.puma" */
  {
/* line 223 "Temporary.puma" */
   failure_protocol ("Temporary", "TemporaryDone", t);
  }
   return;

;
}

void FreeTemporaries
# if defined __STDC__ | defined __cplusplus
(register tTree * yyP2, register tTree * yyP1)
# else
(yyP2, yyP1)
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 234 "Temporary.puma" */
 {
  tTree NewAllocates;
  tTree NewDeallocates;
  {
/* line 239 "Temporary.puma" */
 NewAllocates   = NoTree;
    NewDeallocates = NoTree;
    FreeUsedDecls ();        
  
  }
   * yyP2 = NewAllocates;
   * yyP1 = NewDeallocates;
   return;
 }

;
}

tTree MakeScalarTemporary
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
/* line 255 "Temporary.puma" */
 {
  var_descriptor vard;
  {
/* line 259 "Temporary.puma" */
   MakeReplicatedDescriptor (& vard);
/* line 260 "Temporary.puma" */
   SetExpType (exp, & vard);
/* line 262 "Temporary.puma" */
   NoExpansion (& vard);
  }
   return GetVDTemporary (& vard);
 }

}

tTree GetScalarTemporary
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
/* line 278 "Temporary.puma" */
 {
  tTree decl;
  {
/* line 282 "Temporary.puma" */
   decl = MakeNewScalarTemporary (type);
  }
   return mUSED_VAR (Decl2VarObj (decl));
 }

}

tTree GetLoopTemporary
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
/* line 297 "Temporary.puma" */
 {
  tTree temp;
  {
/* line 300 "Temporary.puma" */
 temp = used_loop_decl[n-1];

     if (temp == NoTree)
       { temp = GetScalarTemporary (MakeIntegerType (default_int_size));
         temp->Kind = kLOOP_VAR;
         used_loop_decl [n-1] = temp;
       }
      else
       temp = CopyTree (temp);
   
  }
   return temp;
 }

}

tTree GetVarTemporary
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 326 "Temporary.puma" */
 {
  var_descriptor vard;
  rbool found;
  {
/* line 331 "Temporary.puma" */
   GetVarDescriptor (var, & found, & vard);
/* line 332 "Temporary.puma" */
 if (!found)
      { error_protocol ("could not get temporary for var");
        tree_protocol ("no descriptor for this variable", var);
      }
  
  }
   return GetVDTemporary (& vard);
 }

}

void GetMemoryStmts
# if defined __STDC__ | defined __cplusplus
(register tTree * yyP4, register tTree * yyP3)
# else
(yyP4, yyP3)
 register tTree * yyP4;
 register tTree * yyP3;
# endif
{
/* line 342 "Temporary.puma" */
 {
  tTree allocate_stmt;
  tTree deallocate_stmt;
  {
/* line 347 "Temporary.puma" */
 allocate_stmt   = new_allocate;
    deallocate_stmt = new_deallocate;
    new_allocate    = NoTree;
    new_deallocate  = NoTree;
  
  }
   * yyP4 = allocate_stmt;
   * yyP3 = deallocate_stmt;
   return;
 }

;
}

static tTree Decl2VarObj
# if defined __STDC__ | defined __cplusplus
(register tTree decl)
# else
(decl)
 register tTree decl;
# endif
{
  if (decl->Kind == kVAR_DECL) {
/* line 364 "Temporary.puma" */
 {
  tDefinitions obj;
  tTree t;
  {
/* line 369 "Temporary.puma" */
 obj = GetLocalObject (decl->VAR_DECL.Ident);
     if (obj == NoObject)
       failure_protocol ("Temporary", "Decl2VarObj : no object", decl);
     t = mVAR_OBJ (0, decl->VAR_DECL.Ident);
     t->VAR_OBJ.Object = obj;
   
  }
   return t;
 }

  }
/* line 378 "Temporary.puma" */
  {
/* line 379 "Temporary.puma" */
   failure_protocol ("Temporary", "Decl2VarObj", decl);
  }
   return NoTree;

}

static rbool MatchScalar
# if defined __STDC__ | defined __cplusplus
(register tTree decl, register tTree type)
# else
(decl, type)
 register tTree decl;
 register tTree type;
# endif
{
  if (decl->Kind == kVAR_DECL) {
/* line 391 "Temporary.puma" */
  {
/* line 392 "Temporary.puma" */
   if (! ((IsTheSameType (decl->VAR_DECL.VAL, type)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool IsTheSameType
# if defined __STDC__ | defined __cplusplus
(register tTree type1, register tTree type2)
# else
(type1, type2)
 register tTree type1;
 register tTree type2;
# endif
{
  if (type1->Kind == kINTEGER_TYPE) {
  if (type2->Kind == kINTEGER_TYPE) {
/* line 397 "Temporary.puma" */
  {
/* line 398 "Temporary.puma" */
   if (! ((type1->INTEGER_TYPE.SIZE == type2->INTEGER_TYPE.SIZE))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  if (type1->Kind == kREAL_TYPE) {
  if (type2->Kind == kREAL_TYPE) {
/* line 401 "Temporary.puma" */
  {
/* line 402 "Temporary.puma" */
   if (! ((type1->REAL_TYPE.SIZE == type2->REAL_TYPE.SIZE))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  if (type1->Kind == kBOOLEAN_TYPE) {
  if (type2->Kind == kBOOLEAN_TYPE) {
/* line 405 "Temporary.puma" */
  {
/* line 406 "Temporary.puma" */
   if (! ((type1->BOOLEAN_TYPE.SIZE == type2->BOOLEAN_TYPE.SIZE))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  }
  if (type1->Kind == kCOMPLEX_TYPE) {
  if (type2->Kind == kCOMPLEX_TYPE) {
/* line 409 "Temporary.puma" */
  {
/* line 410 "Temporary.puma" */
   if (! ((type1->COMPLEX_TYPE.SIZE == type2->COMPLEX_TYPE.SIZE))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  }
  if (type1->Kind == kSTRING_TYPE) {
  if (type2->Kind == kSTRING_TYPE) {
/* line 413 "Temporary.puma" */
  {
/* line 414 "Temporary.puma" */
   if (! ((EqualExpression (type1->STRING_TYPE.LENGTH, type2->STRING_TYPE.LENGTH)))) goto yyL5;
  }
   return rtrue;
yyL5:;

  }
  }
  return rfalse;
}

static tTree MakeNewScalarTemporary
# if defined __STDC__ | defined __cplusplus
(register tTree type)
# else
(type)
 register tTree type;
# endif
{
/* line 427 "Temporary.puma" */
 {
  tIdent id;
  tTree decl;
  tDefinitions obj;
  {
/* line 433 "Temporary.puma" */
 id = NewTemporaryId (TreeListLength (new_decls), kScalarTemporary); 

       

    decl = mVAR_DECL (id, 0, CopyTree (type));

    new_decls = mDECL_LIST (decl, new_decls);  
   
    obj = MakeNewObject (decl, GetCurrentUnitObject ());

    MakeReplMapping (obj);

    InsertEntry (obj);

  
  }
   return decl;
 }

}

static void MakeReplMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj)
# else
(obj)
 register tDefinitions obj;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 454 "Temporary.puma" */
  {
/* line 456 "Temporary.puma" */
 obj->VarObject.Dist->Mapping.spec  = mMapReplicated ();
     obj->VarObject.Dist->Mapping.range = mRangeNone ();
   
  }
   return;

  }
;
}

static tTree CopyObjectType
# if defined __STDC__ | defined __cplusplus
(register tTree decl)
# else
(decl)
 register tTree decl;
# endif
{
 yyRecursion:
  if (decl->Kind == kVAR_DECL) {
/* line 469 "Temporary.puma" */
   decl = decl->VAR_DECL.VAL;
   goto yyRecursion;

  }
  if (decl->Kind == kVAR_PARAM_DECL) {
/* line 473 "Temporary.puma" */
   decl = decl->VAR_PARAM_DECL.VAL;
   goto yyRecursion;

  }
  if (decl->Kind == kARRAY_TYPE) {
/* line 477 "Temporary.puma" */
   return mARRAY_TYPE (CopyObjectType (decl->ARRAY_TYPE.ARRAY_INDEX_TYPES), CopyTree (decl->ARRAY_TYPE.ARRAY_COMP_TYPE));

  }
  if (decl->Kind == kSHAPE_LIST) {
/* line 481 "Temporary.puma" */
   return mSHAPE_LIST (mDEFERRED_SHAPE (), CopyObjectType (decl->SHAPE_LIST.Next));

  }
/* line 485 "Temporary.puma" */
   return CopyTree (decl);

}

tTree GetVDTemporary
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 503 "Temporary.puma" */
   return GetTempByDescriptor (vard, rfalse);

}

tTree GetVDPtrTemporary
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 510 "Temporary.puma" */
   return GetTempByDescriptor (vard, rtrue);

}

static tTree GetTempByDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard, register rbool is_pointer)
# else
(vard, is_pointer)
 pvar vard;
 register rbool is_pointer;
# endif
{
/* line 517 "Temporary.puma" */
 {
  tIdent new_id;
  tTree new_decl;
  tTree dist_decl;
  tTree used_var;
  {
/* line 524 "Temporary.puma" */
 new_id = NewTemporaryId (TreeListLength (new_decls), kVarTemporary);

#ifdef DEBUG
    if (is_pointer)
      printf ("get pointer temporary for the following descriptor :\n");
     else
      printf ("get temporary for the following descriptor :\n");
    PrintVarDescriptor (vard);
#endif

    MakeAttTempVar (new_id, vard, is_pointer,
                    &used_var, &new_decl, &dist_decl,
                    &new_allocate, &new_deallocate   );

    

    if (dist_decl == NoTree)
       new_decls = mDECL_LIST (new_decl, new_decls); 
      else
       new_decls = mDECL_LIST (new_decl, mDECL_LIST (dist_decl, new_decls)); 

                  

    

  
  }
   return used_var;
 }

}

static tIdent NewTemporaryId
# if defined __STDC__ | defined __cplusplus
(register int n, register int kind)
# else
(n, kind)
 register int n;
 register int kind;
# endif
{
/* line 568 "Temporary.puma" */

char string[MAX_ID_LENGTH];
tIdent new_id;

/* line 573 "Temporary.puma" */
  {
/* line 575 "Temporary.puma" */
 if (kind == kVarTemporary)
       sprintf (string, "TMP%d", n+1);
     else
       sprintf (string, "I%d", n+1);

    new_id = MakeIdent (string, strlen (string));
    if (GetLocalObject(new_id) != NoObject)
      new_id = NewTemporaryId (n+1, kind);
  
  }
   return new_id;

}

void BeginTemporary ARGS ((void))
{
}

void CloseTemporary ARGS ((void))
{
}
