# include "TempVars.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 47 "TempVars.puma" */


# undef DEBUG

# include "Idents.h"
# include "protocol.h"

# include "Transform.h" 
# include "DefTable.h"

# include "Objects.h"      /* MakeNewObject */
# include "Rank.h"         /* MakeNewObject */
# include "MapDefs.h"      /* SetDistributions, SetAlignments */
# include "ChangeDefs.h"   /* MakeObjAllocatable              */
# include "Expressions.h"  /* MakeConstant                    */
# include "Descriptor.h"   /* IsTemplateDescriptor            */
# include "SemMap.h"       /* EvalObjSpecMapping              */

# include "Nesting.h"      /* access to outer loops           */

# define MODULE "TempVars"

     /***************************************************************
     *                                                              *
     *   Global Data needed for the creation of a temporary Var     *
     *                                                              *
     ***************************************************************/

static tTree allocate_stmt     = NoTree;
static tTree deallocate_stmt   = NoTree;

static tTree        reaching_allocate     = NoTree;

       /* new_decls stands for VAR_DECL + ALIGN/DISTRIBUTE */

static tTree temp_formals  [MAX_DIMENSIONS];

    /* data global needed for the allocate statement */

static tTree temp_actuals  [MAX_DIMENSIONS];

    /* data global needed for the distribute statement */

static int   temp_distribution_kind [MAX_DIMENSIONS];
static tTree temp_distribution_size [MAX_DIMENSIONS];

    /* data global needed for the new use of the temporary variable

      template_vardim[i] = 0 : no array dim is aligned to template dim i
      template_vardim[i] = k : array dim k is aligned to template dim i

    */

static int template_vardim [MAX_DIMENSIONS];
static int template_mult   [MAX_DIMENSIONS];
static int template_add    [MAX_DIMENSIONS];

    /* data global needed for alignment directive */

static tTree global_var;
static rbool global_error;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTempVars.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* TempVars_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempVars, routine %s failed\n",
  yyFunction);
 TempVars_Exit ();
}

void MakeTempVar ARGS ((tIdent name, pvar vard, tTree * yyP5, tTree * yyP4, tTree * yyP3, tTree * yyP2, tTree * yyP1));
void MakeAttTempVar ARGS ((tIdent name, pvar vard, rbool is_pointer, tTree * yyP10, tTree * yyP9, tTree * yyP8, tTree * yyP7, tTree * yyP6));
static tTree MakeVarDeclaration ARGS ((tIdent name, int line, int rank, pvar vard));
static tTree MakeDeferredShape ARGS ((int n));
static tTree MakeVDType ARGS ((pvar vard));
static void MakeMemoryStmts ARGS ((tIdent id, int rank, pvar vard, rbool is_pointer));
static void MakeDspStmts ARGS ((tIdent id, int kind, tTree indexes, tTree * yyP12, tTree * yyP11));
static tTree MakeExplicitShape ARGS ((tTree exp));
static tTree MakeUsedVar ARGS ((tIdent id, int rank));
static void PreCompute ARGS ((pvar vard, int * temp_rank));
static tTree TranslateActual ARGS ((tTree exp));
static void SetActual ARGS ((int pos, tTree low, tTree up, tTree inc));
static void SetFormal ARGS ((int pos, tTree low, tTree up));
static tTree MakeDistributeDecl ARGS ((tIdent name, int line, int new_rank, pvar vard));
static tTree MakeAlignDecl ARGS ((tIdent name, int line, int new_rank, pvar vard));
static void SetTemplateObject ARGS ((tTree t, tDefinitions template));
static tTree MakeUse ARGS ((tIdent id));
static void SetReachingInfo ARGS ((tTree used_var, pvar vard));
static void GetSpecMapping ARGS ((tDefinitions obj, tDefinitions * yyP13));
static void GetTemplateInfo ARGS ((tTree reach_info, tTree * yyP15, tDefinitions * yyP14));
static rbool IsAlignedDescriptor ARGS ((pvar vard));
static void SetObjAllocatable ARGS ((tDefinitions new_obj));
static void SetObjPointer ARGS ((tDefinitions new_obj));
static void MakeObjReplicated ARGS ((tDefinitions t));
static void MakeObjNoRange ARGS ((tDefinitions t));

void MakeTempVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name, pvar vard, register tTree * yyP5, register tTree * yyP4, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(name, vard, yyP5, yyP4, yyP3, yyP2, yyP1)
 register tIdent name;
 pvar vard;
 register tTree * yyP5;
 register tTree * yyP4;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 127 "TempVars.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
/* line 129 "TempVars.puma" */
   MakeAttTempVar (name, vard, rfalse, & yyV1, & yyV2, & yyV3, & yyV4, & yyV5);
  }
   * yyP5 = yyV1;
   * yyP4 = yyV2;
   * yyP3 = yyV3;
   * yyP2 = yyV4;
   * yyP1 = yyV5;
   return;
 }

;
}

void MakeAttTempVar
# if defined __STDC__ | defined __cplusplus
(register tIdent name, pvar vard, register rbool is_pointer, register tTree * yyP10, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7, register tTree * yyP6)
# else
(name, vard, is_pointer, yyP10, yyP9, yyP8, yyP7, yyP6)
 register tIdent name;
 pvar vard;
 register rbool is_pointer;
 register tTree * yyP10;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
 register tTree * yyP6;
# endif
{
/* line 136 "TempVars.puma" */
 {
  tTree var_decl;
  tTree dist_decl;
  tDefinitions new_obj;
  tTree used_var;
  int line;
  int yyV1;
  {
/* line 144 "TempVars.puma" */
 global_error = rfalse;

      global_var = vard->var_tree;

      

      line = get_protocol_line ();

#ifdef DEBUG
      printf ("MakeTempVar for the following var descriptor:\n");
      PrintVarDescriptor (vard);
#endif

    
/* line 159 "TempVars.puma" */
   PreCompute (vard, & yyV1);
/* line 161 "TempVars.puma" */
 var_decl  = MakeVarDeclaration (name, line, yyV1, vard);

#ifdef DEBUG
      FileUnparse (stdout, var_decl); printf (" is the complete decl\n");
#endif

      

      new_obj = MakeNewObject (var_decl, GetCurrentUnitObject ());
      InsertEntry (new_obj);

      if (is_pointer)

         SetObjPointer (new_obj);       

       else if (yyV1 > 0)

         SetObjAllocatable (new_obj);   

      if (yyV1 == 0) 

         { dist_decl = NoTree;   
           MakeObjReplicated (new_obj);  
         }

       else if (vard->topology_rank < 1)

         { 

           dist_decl  = MakeDistributeDecl (name, line, yyV1, vard);

#ifdef DEBUG
           printf ("Distribution: ");
           FileUnparse (stdout, dist_decl);
           printf ("\n");
#endif

           SetDistributions (dist_decl, GetCurrentUnitObject());
           EvalObjSpecMapping  (new_obj);

         }

       else if (!IsAlignedDescriptor (vard))

         { 

           dist_decl  = MakeDistributeDecl (name, line, yyV1, vard);

#ifdef DEBUG
           printf ("Distribution: ");
           FileUnparse (stdout, dist_decl);
           printf ("\n");
#endif

           SetDistributions (dist_decl, GetCurrentUnitObject());
           EvalObjSpecMapping  (new_obj);

         }

       else

         { 

           dist_decl  = MakeAlignDecl (name, line, yyV1, vard);

#ifdef DEBUG
           printf ("Alignment: ");
           FileUnparse (stdout, dist_decl);
           printf ("\n");
#endif

           SetAlignments (dist_decl, GetCurrentUnitObject ());
           EvalObjSpecMapping  (new_obj);

         }

      MakeObjNoRange (new_obj);

      MakeMemoryStmts (name, yyV1, vard, is_pointer);

      used_var = MakeUsedVar (name, yyV1);

      SetReachingInfo (used_var, vard);

      if (global_error)
        { error_protocol ("could not create temporary");
          used_var = NoTree;
        }

    
  }
   * yyP10 = used_var;
   * yyP9 = var_decl;
   * yyP8 = dist_decl;
   * yyP7 = allocate_stmt;
   * yyP6 = deallocate_stmt;
   return;
 }

;
}

static tTree MakeVarDeclaration
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int line, register int rank, pvar vard)
# else
(name, line, rank, vard)
 register tIdent name;
 register int line;
 register int rank;
 pvar vard;
# endif
{
/* line 264 "TempVars.puma" */
  {
/* line 266 "TempVars.puma" */
   if (! ((rank == 0))) goto yyL1;
  }
   return mVAR_DECL (name, line, MakeVDType (vard));
yyL1:;

/* line 271 "TempVars.puma" */
  {
/* line 273 "TempVars.puma" */
   if (! ((IsTemplateDescriptor (vard)))) goto yyL2;
  }
   return mTEMPLATE_DECL (name, line, MakeDeferredShape (rank));
yyL2:;

/* line 278 "TempVars.puma" */
   return mVAR_DECL (name, line, mARRAY_TYPE (MakeDeferredShape (rank), MakeVDType (vard)));

}

static tTree MakeDeferredShape
# if defined __STDC__ | defined __cplusplus
(register int n)
# else
(n)
 register int n;
# endif
{
/* line 292 "TempVars.puma" */
 {
  tTree type_decl;
  tTree type_index;
  {
/* line 297 "TempVars.puma" */
 int i;
 
     type_decl = mSHAPE_EMPTY ();
 
     for (i=0; i<n; i++)
       {  type_index = mDEFERRED_SHAPE ();
          type_decl = mSHAPE_LIST (type_index, type_decl);
       }
   
  }
   return type_decl;
 }

}

static tTree MakeVDType
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 318 "TempVars.puma" */
 {
  tTree result;
  {
/* line 322 "TempVars.puma" */
 if (vard->type_kind == kINTEGER_TYPE)
       result = MakeIntegerType (vard->type_size);
     else if (vard->type_kind == kREAL_TYPE)
       result = MakeRealType (vard->type_size);
     else if (vard->type_kind == kBOOLEAN_TYPE)
       result = MakeLogicalType (vard->type_size);
     else if (vard->type_kind == kCOMPLEX_TYPE)
       result = mCOMPLEX_TYPE (MakeConstant (vard->type_size));
     else if (vard->type_kind == kSTRING_TYPE)
       result = mSTRING_TYPE (MakeConstant (0));
     else
       result = MakeIntegerType (default_int_size);
  
  }
   return result;
 }

}

static void MakeMemoryStmts
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int rank, pvar vard, register rbool is_pointer)
# else
(id, rank, vard, is_pointer)
 register tIdent id;
 register int rank;
 pvar vard;
 register rbool is_pointer;
# endif
{
/* line 349 "TempVars.puma" */
  {
/* line 351 "TempVars.puma" */
   if (! ((rank == 0))) goto yyL1;
  {
/* line 353 "TempVars.puma" */
   allocate_stmt = NoTree;
/* line 354 "TempVars.puma" */
   deallocate_stmt = NoTree;
/* line 355 "TempVars.puma" */
   reaching_allocate = NoTree;
  }
  }
   return;
yyL1:;

/* line 358 "TempVars.puma" */
 {
  tTree indexes;
  tTree stmt;
  {
/* line 360 "TempVars.puma" */
   if (! ((IsTemplateDescriptor (vard)))) goto yyL2;
  {
/* line 366 "TempVars.puma" */
 int i;

#ifdef DEBUG
     printf ("generate create_dsp/free_dsp, rank = %d\n", rank);
#endif

     stmt = MakeUse (id);
     stmt = mFREE_DSP_STMT (stmt, kTEMPLATE_DSP);
     stmt = mACF_BASIC (stmt);

     deallocate_stmt = stmt;

#ifdef DEBUG
     printf ("free_dsp : ");
     FileUnparse (stdout, deallocate_stmt);
     printf ("\n");
#endif

     indexes = mBTE_EMPTY ();
     for (i=rank-1; i>=0; i--)
        indexes = mBTE_LIST (temp_formals[i], indexes);

     reaching_allocate = indexes;

     indexes = mSHAPE_EMPTY ();
     for (i=rank-1; i>=0; i--)
        indexes = mSHAPE_LIST (MakeExplicitShape(temp_formals[i]), indexes);

     stmt = MakeUse (id);
     stmt = mCREATE_DSP_STMT (stmt, indexes, kTEMPLATE_DSP);
     stmt = mACF_BASIC (stmt);

     allocate_stmt = stmt;

#ifdef DEBUG
     printf ("create dsp : ");
     FileUnparse (stdout, allocate_stmt);
     printf ("\n");
#endif

   
  }
  }
   return;
 }
yyL2:;

/* line 409 "TempVars.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 411 "TempVars.puma" */
   if (! ((is_pointer))) goto yyL3;
  {
/* line 413 "TempVars.puma" */
   MakeDspStmts (id, kALLOCATE_DSP, MakeDeferredShape (rank), & yyV1, & yyV2);
/* line 416 "TempVars.puma" */
 allocate_stmt   = CombineACF (yyV1, NoTree);
     deallocate_stmt = CombineACF (yyV2, NoTree);

     reaching_allocate = NoTree;    
   
  }
  }
   return;
 }
yyL3:;

/* line 423 "TempVars.puma" */
 {
  tTree indexes;
  tTree stmt;
  int idim;
  tTree yyV1;
  tTree yyV2;
  {
/* line 429 "TempVars.puma" */
   MakeDspStmts (id, kALLOCATE_DSP, MakeDeferredShape (rank), & yyV1, & yyV2);
/* line 432 "TempVars.puma" */
 
#ifdef DEBUG
     printf ("generate allocate/deallocate, rank = %d\n", rank);
#endif

     stmt = MakeUse (id);
     stmt = mBTP_LIST (mVAR_PARAM (stmt), mBTP_EMPTY());
     stmt = mDEALLOCATE_STMT (stmt, mDUMMY_VAR ());
     stmt = mACF_BASIC (stmt);

     deallocate_stmt = CombineACF (yyV2, NoTree);
     deallocate_stmt = CombineACF (stmt, deallocate_stmt);
      
#ifdef DEBUG
     printf ("deallocate/free_dsp : ");
     FileUnparse (stdout, deallocate_stmt);
     printf ("\n");
#endif

     indexes = mBTE_EMPTY ();
     for (idim=rank-1; idim>=0; idim--)
        indexes = mBTE_LIST (temp_formals[idim], indexes);

     reaching_allocate = indexes;

     stmt = MakeUse (id);
     stmt = mINDEXED_VAR (stmt, indexes);
     stmt = mBTP_LIST (mVAR_PARAM (stmt), mBTP_EMPTY());
     stmt = mALLOCATE_STMT (stmt, mDUMMY_VAR ());
     stmt = mACF_BASIC (stmt);

     allocate_stmt = mACF_LIST (stmt, NoTree);
     allocate_stmt = CombineACF (yyV1, allocate_stmt);

#ifdef DEBUG
     printf ("allocate : ");
     FileUnparse (stdout, allocate_stmt);
     printf ("\n");
#endif

   
  }
   return;
 }

;
}

static void MakeDspStmts
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int kind, register tTree indexes, register tTree * yyP12, register tTree * yyP11)
# else
(id, kind, indexes, yyP12, yyP11)
 register tIdent id;
 register int kind;
 register tTree indexes;
 register tTree * yyP12;
 register tTree * yyP11;
# endif
{
/* line 486 "TempVars.puma" */
 {
  tTree create_stmt;
  tTree free_stmt;
  {
/* line 491 "TempVars.puma" */
   free_stmt = MakeUse (id);
/* line 492 "TempVars.puma" */
   free_stmt = mFREE_DSP_STMT (free_stmt, kind);
/* line 493 "TempVars.puma" */
   free_stmt = mACF_BASIC (free_stmt);
/* line 495 "TempVars.puma" */
   create_stmt = MakeUse (id);
/* line 496 "TempVars.puma" */
   create_stmt = mCREATE_DSP_STMT (create_stmt, indexes, kind);
/* line 497 "TempVars.puma" */
   create_stmt = mACF_BASIC (create_stmt);
  }
   * yyP12 = create_stmt;
   * yyP11 = free_stmt;
   return;
 }

;
}

static tTree MakeExplicitShape
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kSLICE_EXP) {
/* line 508 "TempVars.puma" */
 {
  tTree shape;
  {
/* line 512 "TempVars.puma" */
 shape = mEXPLICIT_SHAPE (CopyTree(exp->SLICE_EXP.FIRST), CopyTree(exp->SLICE_EXP.STOP)); 
  }
   return shape;
 }

  }
/* line 517 "TempVars.puma" */
  {
/* line 518 "TempVars.puma" */
   failure_protocol (MODULE, "MakeExplicitShape", exp);
  }
   return NoTree;

}

static tTree MakeUsedVar
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register int rank)
# else
(id, rank)
 register tIdent id;
 register int rank;
# endif
{
/* line 530 "TempVars.puma" */
  {
/* line 531 "TempVars.puma" */
   if (! ((rank == 0))) goto yyL1;
  }
   return MakeUse (id);
yyL1:;

/* line 535 "TempVars.puma" */
 {
  tTree result;
  {
/* line 539 "TempVars.puma" */
 int i;

     result = mBTE_EMPTY ();
     for (i=rank-1; i>=0; i--)
        result = mBTE_LIST (temp_actuals[i], result);

     result = mINDEXED_VAR (MakeUse (id), result);

#ifdef DEBUG
     printf ("new temp_var access : ");
     FileUnparse (stdout, result);
     printf ("\n");
#endif

   
  }
   return result;
 }

}

static void PreCompute
# if defined __STDC__ | defined __cplusplus
(pvar vard, register int * temp_rank)
# else
(vard, temp_rank)
 pvar vard;
 register int * temp_rank;
# endif
{
/* line 570 "TempVars.puma" */

int i, loop;
tTree a_low, a_up, a_inc;       /* actual   extension    */
tTree t_low, t_up, t_inc;       /* extension of temporay */

/* line 576 "TempVars.puma" */
 {
  int new_rank;
  {
/* line 580 "TempVars.puma" */
 int   dist;
     tTree size;
     int   tdim;
     rbool  is_aligned;

     new_rank = 0;

     if (!vard->expanded)
       failure_protocol (MODULE, "PreCompute, no expansion", NoTree);

     is_aligned = (vard->template_obj != NoObject);

     

     for (i=0; i < vard->template_rank; i++)
        template_vardim [i] = 0;
     
     for (i=0; i < vard->formal_rank; i++)

        { a_low = vard->actual_shape[i][0];
          a_up  = vard->actual_shape[i][1];
          a_inc = vard->actual_shape[i][2];

          if (a_low == a_up)

            { a_low  = TranslateActual (a_low);
              a_up   = a_low;
            }

          

          t_low  = vard->expand_shape[i][0];
          t_up   = vard->expand_shape[i][1];

          if (vard->topology_rank < 1)

             { dist = 0;
               size = NoTree;
             }

            else
             { dist = vard->distribution_kind [i];
               size = vard->distribution_size [i];
             }

          if (t_low == t_up)

             { 

               if ((dist != 0) && is_aligned)

                  { 

                  }

             }

            else

             { 

               SetFormal (new_rank, t_low, t_up);
               SetActual (new_rank, a_low, a_up, a_inc);

               if ((dist != 0) && is_aligned)

                  { 

                    tdim = vard->template_dim[i];

                    template_vardim [tdim-1] = new_rank + 1;
                    template_mult   [tdim-1] = vard->align_mult[i];
                    template_add    [tdim-1] = vard->align_add [i];
                  }

               temp_distribution_kind [new_rank] = dist;
               temp_distribution_size [new_rank] = size;
               new_rank++;

             }

        }; 

    
  }
   * temp_rank = new_rank;
   return;
 }

;
}

static tTree TranslateActual
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
/* line 676 "TempVars.puma" */
  {
/* line 677 "TempVars.puma" */
   if (! ((exp == NoTree))) goto yyL1;
  }
   return exp;
yyL1:;

  if (exp->Kind == kLOOP_VAR) {
/* line 681 "TempVars.puma" */
   return mVAR_EXP (exp);

  }
/* line 685 "TempVars.puma" */
   return exp;

}

static void SetActual
# if defined __STDC__ | defined __cplusplus
(register int pos, register tTree low, register tTree up, register tTree inc)
# else
(pos, low, up, inc)
 register int pos;
 register tTree low;
 register tTree up;
 register tTree inc;
# endif
{
/* line 699 "TempVars.puma" */
  {
/* line 700 "TempVars.puma" */
   if (! ((low == up))) goto yyL1;
  {
/* line 701 "TempVars.puma" */
 temp_actuals[pos] = CopyTree (low); 
  }
  }
   return;
yyL1:;

/* line 704 "TempVars.puma" */
 {
  tTree inc1;
  {
/* line 708 "TempVars.puma" */
 if (inc == NoTree)
         inc1 = mDUMMY_EXP ();
        else
         inc1 = CopyTree (inc);

      temp_actuals[pos] = mSLICE_EXP (CopyTree (low), CopyTree (up), inc1);
    
  }
   return;
 }

;
}

static void SetFormal
# if defined __STDC__ | defined __cplusplus
(register int pos, register tTree low, register tTree up)
# else
(pos, low, up)
 register int pos;
 register tTree low;
 register tTree up;
# endif
{
/* line 729 "TempVars.puma" */
  {
/* line 730 "TempVars.puma" */
   if (! ((low == up))) goto yyL1;
  {
/* line 731 "TempVars.puma" */
   if (! ((low != NoTree))) goto yyL1;
  {
/* line 732 "TempVars.puma" */
   if (! ((TreeRank (low) > 0))) goto yyL1;
  {
/* line 733 "TempVars.puma" */
 global_error = rtrue; 
  }
  }
  }
  }
   return;
yyL1:;

/* line 736 "TempVars.puma" */
 {
  tTree temp_low;
  tTree temp_up;
  int local;
  {
/* line 743 "TempVars.puma" */
 local = 0;

      if (low == NoTree)
         temp_low = mBOUND_EXP (global_var, pos+1, 0, local);
        else
         temp_low = CopyTree (low);

      if (up == NoTree)
         temp_up = mBOUND_EXP (global_var, pos+1, 1, local);
        else
         temp_up = CopyTree (up);

      temp_formals [pos] = mSLICE_EXP (temp_low,
                                       temp_up,
                                       mDUMMY_EXP ()); 
    
  }
   return;
 }

;
}

static tTree MakeDistributeDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int line, register int new_rank, pvar vard)
# else
(name, line, new_rank, vard)
 register tIdent name;
 register int line;
 register int new_rank;
 pvar vard;
# endif
{
/* line 774 "TempVars.puma" */
  {
/* line 776 "TempVars.puma" */
   if (! ((vard -> topology_rank == - 1))) goto yyL1;
  }
   return mDISTRIBUTE_DECL (name, line, mREPL_DISTRIBUTION (0), mDEFAULT_PROCESSOR_ARRAY ());
yyL1:;

/* line 785 "TempVars.puma" */
  {
/* line 787 "TempVars.puma" */
   if (! ((vard -> topology_rank <= 0))) goto yyL2;
  }
   return mDISTRIBUTE_DECL (name, line, mREPL_DISTRIBUTION (0), mDEFAULT_PROCESSOR_ARRAY ());
yyL2:;

/* line 796 "TempVars.puma" */
 {
  tTree mapping;
  tTree target;
  {
/* line 801 "TempVars.puma" */
 int i, rank, dist;
     tTree size;

     rank = vard->formal_rank;

     mapping = mDIST_EMPTY ();

     for (i=new_rank; i>0; i--)

       { dist = temp_distribution_kind [i-1];
         size = temp_distribution_size [i-1];
 
         if (size == NoTree) 
             size = mDUMMY_EXP();
           else
             size = CopyTree (size);

         if (dist == kBLOCK_DIM)
            mapping = mDIST_LIST (mBLOCK_DISTRIBUTION (size), mapping);
          else if (dist == kCYCLIC_DIM)
            mapping = mDIST_LIST (mCYCLIC_DISTRIBUTION (size), mapping);
          else
            mapping = mDIST_LIST (mSERIAL_DISTRIBUTION (), mapping);

       } 
  
   
/* line 829 "TempVars.puma" */
   target = mDEFAULT_PROCESSOR_ARRAY ();
  }
   return mDISTRIBUTE_DECL (name, line, mNODE_DISTRIBUTION (0, mapping), target);
 }

}

static tTree MakeAlignDecl
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register int line, register int new_rank, pvar vard)
# else
(name, line, new_rank, vard)
 register tIdent name;
 register int line;
 register int new_rank;
 pvar vard;
# endif
{
/* line 852 "TempVars.puma" */
 {
  tTree align_decl;
  {
/* line 856 "TempVars.puma" */
 tTree source_list, spec_list, item;
    tIdent item_id, template_id;
    int i, vdim, template_rank;
    int mult, add;
    tObject template_obj;

#ifdef DEBUG
    printf ("MakeAlignDecl, rank = %d\n", new_rank);
#endif 

    source_list = mBTE_EMPTY ();
    item_id = MakeIdent ("I", 1);
    for (i=new_rank; i>0; i--)
      { item = mVAR_EXP (MakeUsedVarAn (item_id, "", i));
        source_list = mBTE_LIST (item, source_list);
      }

    template_obj  = vard->template_obj;
    template_rank = VarRank (template_obj);
    spec_list = mBTE_EMPTY();

    for (i=template_rank; i>0; i--)
      { vdim = template_vardim[i-1];
        mult = template_mult[i-1];
        add  = template_add [i-1];
        if (vdim > 0)
           { item = mVAR_EXP (MakeUsedVarAn (item_id, "", vdim));
             item = AddConstant (MultConstant (item, mult), add);
           }
          else
           item = mDUMMY_EXP();
        spec_list = mBTE_LIST (item, spec_list);
      }

    spec_list = mALIGN_SPEC (0, mTEMP_OBJ (DefaultId()), spec_list);
    SetTemplateObject (spec_list, template_obj);
    align_decl = mALIGN_DECL (name, line, source_list, spec_list);
     
  
  }
   return align_decl;
 }

}

static void SetTemplateObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions template)
# else
(t, template)
 register tTree t;
 register tDefinitions template;
# endif
{
 yyRecursion:
  if (t->Kind == kALIGN_SPEC) {
/* line 901 "TempVars.puma" */
  {
/* line 903 "TempVars.puma" */
   t = t->ALIGN_SPEC.TEMPNAME;
   goto yyRecursion;
  }

  }
  if (t->Kind == kTEMP_OBJ) {
/* line 906 "TempVars.puma" */
  {
/* line 908 "TempVars.puma" */
 t->TEMP_OBJ.Object = template;
      t->TEMP_OBJ.Ident  = template->Object.Ident;
    
  }
   return;

  }
;
}

static tTree MakeUse
# if defined __STDC__ | defined __cplusplus
(register tIdent id)
# else
(id)
 register tIdent id;
# endif
{
/* line 923 "TempVars.puma" */
 {
  tTree var;
  {
/* line 927 "TempVars.puma" */
 var = mVAR_OBJ (0, id);
    var->VAR_OBJ.Object = GetGlobalObject (id);
  
  }
   return mUSED_VAR (var);
 }

}

static void SetReachingInfo
# if defined __STDC__ | defined __cplusplus
(register tTree used_var, pvar vard)
# else
(used_var, vard)
 register tTree used_var;
 pvar vard;
# endif
{
 yyRecursion:
  if (used_var->Kind == kINDEXED_VAR) {
/* line 941 "TempVars.puma" */
  {
/* line 943 "TempVars.puma" */
   used_var = used_var->INDEXED_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
  if (used_var->Kind == kUSED_VAR) {
/* line 946 "TempVars.puma" */
  {
/* line 948 "TempVars.puma" */
   used_var = used_var->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  }
  if (used_var->Kind == kVAR_OBJ) {
/* line 951 "TempVars.puma" */
  {
/* line 953 "TempVars.puma" */
   if (! ((VarRank (used_var->VAR_OBJ.Object) == 0))) goto yyL3;
  {
/* line 955 "TempVars.puma" */
 used_var->VAR_OBJ.Reaching = NoTree; 
  }
  }
   return;
yyL3:;

/* line 958 "TempVars.puma" */
 {
  tDefinitions yyV1;
  {
/* line 960 "TempVars.puma" */
   if (! ((vard -> topology_rank < 1))) goto yyL4;
  {
/* line 962 "TempVars.puma" */
   GetSpecMapping (used_var->VAR_OBJ.Object, & yyV1);
/* line 964 "TempVars.puma" */
 used_var->VAR_OBJ.Reaching = mREACHING_INFO (reaching_allocate, reaching_allocate, yyV1, yyV1); 
  }
  }
   return;
 }
yyL4:;

/* line 967 "TempVars.puma" */
 {
  tDefinitions yyV1;
  {
/* line 969 "TempVars.puma" */
   if (! ((IsTemplateDescriptor (vard)))) goto yyL5;
  {
/* line 971 "TempVars.puma" */
   GetSpecMapping (used_var->VAR_OBJ.Object, & yyV1);
/* line 973 "TempVars.puma" */
 used_var->VAR_OBJ.Reaching = mREACHING_INFO (reaching_allocate, reaching_allocate, yyV1, yyV1); 
  }
  }
   return;
 }
yyL5:;

/* line 976 "TempVars.puma" */
 {
  tTree yyV1;
  tDefinitions yyV2;
  tDefinitions yyV3;
  {
/* line 978 "TempVars.puma" */
   GetTemplateInfo (vard -> reach_info, & yyV1, & yyV2);
/* line 979 "TempVars.puma" */
   GetSpecMapping (used_var->VAR_OBJ.Object, & yyV3);
/* line 981 "TempVars.puma" */
 used_var->VAR_OBJ.Reaching = mREACHING_INFO (reaching_allocate, yyV1, yyV3, yyV2); 
  }
   return;
 }

  }
/* line 985 "TempVars.puma" */
  {
/* line 987 "TempVars.puma" */
   failure_protocol (MODULE, "SetReachingInfo", used_var);
  }
   return;

;
}

static void GetSpecMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions obj, register tDefinitions * yyP13)
# else
(obj, yyP13)
 register tDefinitions obj;
 register tDefinitions * yyP13;
# endif
{
  if (obj->Kind == kVarObject) {
/* line 996 "TempVars.puma" */
   * yyP13 = obj->VarObject.Dist->Mapping.spec;
   return;

  }
  if (obj->Kind == kTemplateObject) {
/* line 999 "TempVars.puma" */
   * yyP13 = obj->TemplateObject.Dist->Mapping.spec;
   return;

  }
/* line 1002 "TempVars.puma" */
  {
/* line 1004 "TempVars.puma" */
   failure_protocol (MODULE, "GetDistribuiton", obj->Object.decl);
  }
   * yyP13 = NoDefinitions;
   return;

;
}

static void GetTemplateInfo
# if defined __STDC__ | defined __cplusplus
(register tTree reach_info, register tTree * yyP15, register tDefinitions * yyP14)
# else
(reach_info, yyP15, yyP14)
 register tTree reach_info;
 register tTree * yyP15;
 register tDefinitions * yyP14;
# endif
{
/* line 1013 "TempVars.puma" */
  {
/* line 1015 "TempVars.puma" */
   if (! ((reach_info == NoTree))) goto yyL1;
  }
   * yyP15 = NoTree;
   * yyP14 = NoDefinitions;
   return;
yyL1:;

  if (reach_info->Kind == kREACHING_INFO) {
/* line 1018 "TempVars.puma" */
   * yyP15 = reach_info->REACHING_INFO.temp_allocate;
   * yyP14 = reach_info->REACHING_INFO.temp_distribution;
   return;

  }
/* line 1021 "TempVars.puma" */
  {
/* line 1023 "TempVars.puma" */
   failure_protocol (MODULE, "GetTemplateInfo", reach_info);
  }
   * yyP15 = NoTree;
   * yyP14 = NoDefinitions;
   return;

;
}

static rbool IsAlignedDescriptor
# if defined __STDC__ | defined __cplusplus
(pvar vard)
# else
(vard)
 pvar vard;
# endif
{
/* line 1038 "TempVars.puma" */
  {
/* line 1040 "TempVars.puma" */
   if (! ((IsTemplateDescriptor (vard)))) goto yyL1;
  {
/* line 1041 "TempVars.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 1044 "TempVars.puma" */
  {
/* line 1045 "TempVars.puma" */
   if (! ((vard -> template_obj != NoObject))) goto yyL2;
  }
   return rtrue;
yyL2:;

  return rfalse;
}

static void SetObjAllocatable
# if defined __STDC__ | defined __cplusplus
(register tDefinitions new_obj)
# else
(new_obj)
 register tDefinitions new_obj;
# endif
{
  if (new_obj->Kind == kVarObject) {
/* line 1060 "TempVars.puma" */
  {
/* line 1062 "TempVars.puma" */
   MakeObjAllocatable (new_obj);
  }
   return;

  }
;
}

static void SetObjPointer
# if defined __STDC__ | defined __cplusplus
(register tDefinitions new_obj)
# else
(new_obj)
 register tDefinitions new_obj;
# endif
{
  if (new_obj->Kind == kVarObject) {
/* line 1067 "TempVars.puma" */
  {
/* line 1069 "TempVars.puma" */
   MakeObjPointer (new_obj);
  }
   return;

  }
;
}

static void MakeObjReplicated
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kVarObject) {
/* line 1083 "TempVars.puma" */
  {
/* line 1085 "TempVars.puma" */
 t->VarObject.Dist->Mapping.spec = mMapReplicated (); 
  }
   return;

  }
  if (t->Kind == kTemplateObject) {
/* line 1088 "TempVars.puma" */
  {
/* line 1090 "TempVars.puma" */
 t->TemplateObject.Dist->Mapping.spec = mMapReplicated (); 
  }
   return;

  }
/* line 1093 "TempVars.puma" */
  {
/* line 1094 "TempVars.puma" */
   failure_protocol (MODULE, "MakeObjReplicated", t->Object.decl);
  }
   return;

;
}

static void MakeObjNoRange
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
  if (t->Kind == kVarObject) {
/* line 1099 "TempVars.puma" */
  {
/* line 1101 "TempVars.puma" */
 t->VarObject.Dist->Mapping.range = mRangeNone (); 
  }
   return;

  }
  if (t->Kind == kTemplateObject) {
/* line 1104 "TempVars.puma" */
  {
/* line 1106 "TempVars.puma" */
 t->TemplateObject.Dist->Mapping.range = mRangeNone (); 
  }
   return;

  }
/* line 1109 "TempVars.puma" */
  {
/* line 1110 "TempVars.puma" */
   failure_protocol (MODULE, "MakeObjNoRange", t->Object.decl);
  }
   return;

;
}

void BeginTempVars ARGS ((void))
{
}

void CloseTempVars ARGS ((void))
{
}
