# include "TempFunctions.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 29 "TempFunctions.puma" */


# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "Objects.h"
# include "Intrinsics.h"
# include "Rank.h"
# include "Expansion.h"
# include "MoveControl.h" 
# include "Transform.h"             /*   CombineACF           */
# include "TempAssigns.h"           /*   MakeTemporaryStmt    */

# include "Types.h"                 /*   IsSameExpType        */
# include "Traverse.h"              /*   ReplaceAST           */

# include "ExpDescriptor.h"         /*   GetExpDescriptor     */
# include "NewStatements.h"         /*   ExpandNewStatements  */

# define MODULE "TempFunctions"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTempFunctions.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* TempFunctions_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempFunctions, routine %s failed\n",
  yyFunction);
 TempFunctions_Exit ();
}

static void TempFunctions ARGS ((tTree exp, tTree * yyP3, tTree * yyP2, tTree * yyP1));
void MakeTempFunctions ARGS ((tTree t));
static rbool StopMakeFuncStmts ARGS ((tTree t));
static tTree DoMakeFuncStmts ARGS ((tTree t));
static tTree BasicFuncStmts ARGS ((tTree t));
static void AssignFuncStmts ARGS ((tTree t, rbool masked, tTree * yyP5, tTree * yyP4));
static rbool HandledFunctionCall ARGS ((tTree var, tTree exp));
static void ParallelFuncStmts ARGS ((tTree t, rbool where_mask, tTree * yyP7, tTree * yyP6));
static rbool AllowedFunctionExpression ARGS ((tTree exp));
static tTree MakeVarTree ARGS ((tTree old, tTree new));

static void TempFunctions
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(exp, yyP3, yyP2, yyP1)
 register tTree exp;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{

  switch (exp->Kind) {
  case kADDR:
/* line 68 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 72 "TempFunctions.puma" */
   TempFunctions (exp->ADDR.E, & yyV1, & yyV2, & yyV3);
  }
   * yyP3 = MakeVarTree (exp, yyV1);
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kDUMMY_EXP:
/* line 75 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kCONST_EXP:
/* line 78 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kARRAY_EXP:
/* line 81 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 83 "TempFunctions.puma" */
   TempFunctions (exp->ARRAY_EXP.ELEMENTS, & yyV1, & yyV2, & yyV3);
/* line 85 "TempFunctions.puma" */
 exp->ARRAY_EXP.ELEMENTS = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kBOUND_EXP:
/* line 88 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kRANK_EXP:
/* line 91 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kSLICE_EXP:
/* line 94 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  tTree yyV8;
  tTree yyV9;
  {
/* line 97 "TempFunctions.puma" */
   TempFunctions (exp->SLICE_EXP.FIRST, & yyV1, & yyV2, & yyV3);
/* line 98 "TempFunctions.puma" */
   TempFunctions (exp->SLICE_EXP.STOP, & yyV4, & yyV5, & yyV6);
/* line 99 "TempFunctions.puma" */
   TempFunctions (exp->SLICE_EXP.INC, & yyV7, & yyV8, & yyV9);
/* line 101 "TempFunctions.puma" */
 exp->SLICE_EXP.FIRST = yyV1; exp->SLICE_EXP.STOP = yyV4; exp->SLICE_EXP.INC = yyV7; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, CombineACF (yyV5, yyV8));
   * yyP1 = CombineACF (yyV9, CombineACF (yyV6, yyV3));
   return;
 }

  case kOP_EXP:
/* line 104 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 106 "TempFunctions.puma" */
   TempFunctions (exp->OP_EXP.OPND1, & yyV1, & yyV2, & yyV3);
/* line 107 "TempFunctions.puma" */
   TempFunctions (exp->OP_EXP.OPND2, & yyV4, & yyV5, & yyV6);
/* line 108 "TempFunctions.puma" */
 exp->OP_EXP.OPND1 = yyV1; exp->OP_EXP.OPND2 = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kOP1_EXP:
/* line 111 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 112 "TempFunctions.puma" */
   TempFunctions (exp->OP1_EXP.OPND, & yyV1, & yyV2, & yyV3);
/* line 113 "TempFunctions.puma" */
 exp->OP1_EXP.OPND = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kPERM_EXP:
/* line 116 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 117 "TempFunctions.puma" */
   TempFunctions (exp->PERM_EXP.VAL, & yyV1, & yyV2, & yyV3);
/* line 118 "TempFunctions.puma" */
 exp->PERM_EXP.VAL = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kVAR_EXP:
/* line 121 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 122 "TempFunctions.puma" */
   TempFunctions (exp->VAR_EXP.V, & yyV1, & yyV2, & yyV3);
/* line 123 "TempFunctions.puma" */
 exp->VAR_EXP.V = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kDO_EXP:
/* line 126 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 128 "TempFunctions.puma" */
   TempFunctions (exp->DO_EXP.BODY, & yyV1, & yyV2, & yyV3);
/* line 130 "TempFunctions.puma" */
   if (! (((yyV2 != NoTree) || (yyV3 != NoTree)))) goto yyL12;
  {
/* line 132 "TempFunctions.puma" */
   error_protocol ("temporaries in implied do needed (function call)");
  }
  }
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
 }
yyL12:;

/* line 135 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 137 "TempFunctions.puma" */
   TempFunctions (exp->DO_EXP.RANGE, & yyV1, & yyV2, & yyV3);
/* line 139 "TempFunctions.puma" */
 exp->DO_EXP.RANGE = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kTYPE_EXP:
/* line 142 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 144 "TempFunctions.puma" */
   TempFunctions (exp->TYPE_EXP.ELEMENTS, & yyV1, & yyV2, & yyV3);
/* line 146 "TempFunctions.puma" */
 exp->TYPE_EXP.ELEMENTS = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kFUNC_CALL_EXP:
/* line 149 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 151 "TempFunctions.puma" */
   if (! ((AllowedFunctionExpression (exp)))) goto yyL15;
  {
/* line 153 "TempFunctions.puma" */
   TempFunctions (exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3);
/* line 155 "TempFunctions.puma" */
 exp->FUNC_CALL_EXP.FUNC_PARAMS = yyV1; 
  }
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }
yyL15:;

/* line 158 "TempFunctions.puma" */
 {
  var_descriptor vard;
  rbool found;
  tTree pre_stmts;
  tTree post_stmts;
  tTree tmp_var;
  tTree assign;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 161 "TempFunctions.puma" */
  
/* line 170 "TempFunctions.puma" */
   TempFunctions (exp->FUNC_CALL_EXP.FUNC_PARAMS, & yyV1, & yyV2, & yyV3);
/* line 172 "TempFunctions.puma" */
   GetExpDescriptor (exp, & found, & vard);
/* line 173 "TempFunctions.puma" */
   if (! ((found))) goto yyL16;
  {
/* line 175 "TempFunctions.puma" */
   NoExpansion (& vard);
/* line 177 "TempFunctions.puma" */
   MakeTemporaryStmt (exp, & vard, & pre_stmts, & tmp_var, & assign, & post_stmts);
/* line 181 "TempFunctions.puma" */
   pre_stmts = CombineACF (CombineACF (pre_stmts, yyV2), CombineACF (assign, yyV3));
  }
  }
   * yyP3 = mVAR_EXP (tmp_var);
   * yyP2 = pre_stmts;
   * yyP1 = post_stmts;
   return;
 }
yyL16:;

/* line 185 "TempFunctions.puma" */
  {
/* line 187 "TempFunctions.puma" */
   error_protocol ("could not create own statement for function call");
/* line 188 "TempFunctions.puma" */
   tree_protocol ("unresolved function call is : ", exp);
  }
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kBTE_LIST:
/* line 191 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 193 "TempFunctions.puma" */
   TempFunctions (exp->BTE_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 194 "TempFunctions.puma" */
   TempFunctions (exp->BTE_LIST.Next, & yyV4, & yyV5, & yyV6);
/* line 196 "TempFunctions.puma" */
 exp->BTE_LIST.Elem = yyV1; exp->BTE_LIST.Next = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kBTE_EMPTY:
/* line 199 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kBTP_LIST:
/* line 202 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 204 "TempFunctions.puma" */
   TempFunctions (exp->BTP_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 205 "TempFunctions.puma" */
   TempFunctions (exp->BTP_LIST.Next, & yyV4, & yyV5, & yyV6);
/* line 206 "TempFunctions.puma" */
 exp->BTP_LIST.Elem = yyV1; exp->BTP_LIST.Next = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kBTP_EMPTY:
/* line 209 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kNAMED_PARAM:
/* line 212 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 213 "TempFunctions.puma" */
   TempFunctions (exp->NAMED_PARAM.VAL, & yyV1, & yyV2, & yyV3);
/* line 214 "TempFunctions.puma" */
 exp->NAMED_PARAM.VAL = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kVAR_PARAM:
/* line 217 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 218 "TempFunctions.puma" */
   TempFunctions (exp->VAR_PARAM.V, & yyV1, & yyV2, & yyV3);
/* line 219 "TempFunctions.puma" */
 exp->VAR_PARAM.V = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kNO_PARAM:
/* line 222 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kPROC_PARAM:
/* line 225 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kFUNC_PARAM:
/* line 228 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kUSED_VAR:
/* line 231 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kLOOP_VAR:
/* line 234 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kPERM_VAR:
/* line 237 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 238 "TempFunctions.puma" */
   TempFunctions (exp->PERM_VAR.VAL, & yyV1, & yyV2, & yyV3);
/* line 239 "TempFunctions.puma" */
 exp->PERM_VAR.VAL = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kINDEXED_VAR:
/* line 242 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 244 "TempFunctions.puma" */
   TempFunctions (exp->INDEXED_VAR.IND_VAR, & yyV1, & yyV2, & yyV3);
/* line 245 "TempFunctions.puma" */
   TempFunctions (exp->INDEXED_VAR.IND_EXPS, & yyV4, & yyV5, & yyV6);
/* line 246 "TempFunctions.puma" */
 exp->INDEXED_VAR.IND_VAR = yyV1; exp->INDEXED_VAR.IND_EXPS = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kSUBSTRING_VAR:
/* line 249 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 251 "TempFunctions.puma" */
   TempFunctions (exp->SUBSTRING_VAR.IND_VAR, & yyV1, & yyV2, & yyV3);
/* line 252 "TempFunctions.puma" */
   TempFunctions (exp->SUBSTRING_VAR.IND_EXP, & yyV4, & yyV5, & yyV6);
/* line 253 "TempFunctions.puma" */
 exp->SUBSTRING_VAR.IND_VAR = yyV1; exp->SUBSTRING_VAR.IND_EXP = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kSELECTED_VAR:
/* line 256 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 258 "TempFunctions.puma" */
   TempFunctions (exp->SELECTED_VAR.SELEC_VAR, & yyV1, & yyV2, & yyV3);
/* line 259 "TempFunctions.puma" */
 exp->SELECTED_VAR.SELEC_VAR = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  case kBTV_LIST:
/* line 262 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 264 "TempFunctions.puma" */
   TempFunctions (exp->BTV_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 265 "TempFunctions.puma" */
   TempFunctions (exp->BTV_LIST.Next, & yyV4, & yyV5, & yyV6);
/* line 266 "TempFunctions.puma" */
 exp->BTV_LIST.Elem = yyV1; exp->BTV_LIST.Next = yyV4; 
  }
   * yyP3 = exp;
   * yyP2 = CombineACF (yyV2, yyV5);
   * yyP1 = CombineACF (yyV6, yyV3);
   return;
 }

  case kBTV_EMPTY:
/* line 269 "TempFunctions.puma" */
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

  case kDO_VAR:
/* line 272 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 273 "TempFunctions.puma" */
   TempFunctions (exp->DO_VAR.BODY, & yyV1, & yyV2, & yyV3);
/* line 274 "TempFunctions.puma" */
   if (! (((yyV2 != NoTree) || (yyV3 != NoTree)))) goto yyL35;
  {
/* line 275 "TempFunctions.puma" */
   error_protocol ("temporaries in implied do needed (function call)");
  }
  }
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;
 }
yyL35:;

/* line 278 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 279 "TempFunctions.puma" */
   TempFunctions (exp->DO_VAR.RANGE, & yyV1, & yyV2, & yyV3);
/* line 280 "TempFunctions.puma" */
 exp->DO_VAR.RANGE = yyV1; 
  }
   * yyP3 = exp;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  }

/* line 283 "TempFunctions.puma" */
  {
/* line 284 "TempFunctions.puma" */
   failure_protocol (MODULE, "TempFunctions", exp);
  }
   * yyP3 = exp;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

void MakeTempFunctions
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBODY_NODE) {
/* line 295 "TempFunctions.puma" */
  {
/* line 297 "TempFunctions.puma" */
 t->BODY_NODE.STATS = ReplaceAST (t->BODY_NODE.STATS, StopMakeFuncStmts, DoMakeFuncStmts); 
  }
   return;

  }
/* line 300 "TempFunctions.puma" */
  {
/* line 301 "TempFunctions.puma" */
   failure_protocol (MODULE, "MakeTempFunctions", t);
  }
   return;

;
}

static rbool StopMakeFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
/* line 318 "TempFunctions.puma" */
   return rtrue;

  }
  if (t->Kind == kACF_WHERE) {
/* line 324 "TempFunctions.puma" */
   return rtrue;

  }
/* line 327 "TempFunctions.puma" */
  {
/* line 328 "TempFunctions.puma" */
   return rfalse;
  }

}

static tTree DoMakeFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_IF) {
/* line 339 "TempFunctions.puma" */
 {
  tTree new;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 343 "TempFunctions.puma" */
   TempFunctions (t->ACF_IF.IF_EXP, & yyV1, & yyV2, & yyV3);
/* line 345 "TempFunctions.puma" */
 t->ACF_IF.IF_EXP = yyV1;  

     if (yyV2 != NoTree)
       { stmt_protocol ("function calls extracted");
         tree_protocol ("pre_stmts  : \n", yyV2);
       }

     if (yyV3 != NoTree)
       { error_protocol ("post statements for extracting functions in IF");
         tree_protocol ("post_stmts : \n", yyV3);
       }

     new = CombineACF (yyV2, mACF_LIST (t, NoTree));

   
  }
   return new;
 }

  }
  if (t->Kind == kACF_WHILE) {
/* line 363 "TempFunctions.puma" */
 {
  tTree new;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 367 "TempFunctions.puma" */
   TempFunctions (t->ACF_WHILE.WHILE_EXP, & yyV1, & yyV2, & yyV3);
/* line 369 "TempFunctions.puma" */
 t->ACF_WHILE.WHILE_EXP = yyV1;  

     if (yyV2 != NoTree)
       { stmt_protocol ("function calls extracted for WHILE");
         tree_protocol ("pre_stmts  : \n", yyV2);
         t->ACF_WHILE.WHILE_BODY = AppendBody (t->ACF_WHILE.WHILE_BODY, CopyTree (yyV2));
       }

     if (yyV3 != NoTree)
       { error_protocol ("post statements for extracting functions in WHILE");
         tree_protocol ("post_stmts : \n", yyV3);
       }

     new = CombineACF (yyV2, mACF_LIST (t, NoTree));

   
  }
   return new;
 }

  }
  if (t->Kind == kACF_BASIC) {
/* line 389 "TempFunctions.puma" */
 {
  tTree new;
  {
/* line 393 "TempFunctions.puma" */
   new = BasicFuncStmts (t);
/* line 395 "TempFunctions.puma" */
 if (new != t)
       tree_protocol ("function calls extracted : \n", new);
  
  }
   return new;
 }

  }
  if (t->Kind == kACF_WHERE) {
/* line 402 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 404 "TempFunctions.puma" */
   ParallelFuncStmts (t, rfalse, & yyV1, & yyV2);
/* line 406 "TempFunctions.puma" */
 if (yyV1 != NoTree)

      { stmt_protocol ("function calls extracted for WHERE");
        tree_protocol ("pre_stmts  : \n", yyV1);
        tree_protocol ("post_stmts : \n", yyV2);
      }
  
  }
   return CombineACF (yyV1, CombineACF (t, yyV2));
 }

  }
  if (t->Kind == kACF_FORALL) {
/* line 417 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 419 "TempFunctions.puma" */
   ParallelFuncStmts (t, rfalse, & yyV1, & yyV2);
/* line 421 "TempFunctions.puma" */
 if (yyV1 != NoTree)
      { stmt_protocol ("function calls extracted in FORALL");
        tree_protocol ("pre_stmts  : \n", yyV1);
        tree_protocol ("post_stmts : \n", yyV2);
      }
  
  }
   return CombineACF (yyV1, CombineACF (t, yyV2));
 }

  }
  if (t->Kind == kACF_DO) {
/* line 431 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 433 "TempFunctions.puma" */
   TempFunctions (t->ACF_DO.DO_RANGE, & yyV1, & yyV2, & yyV3);
/* line 434 "TempFunctions.puma" */
 t->ACF_DO.DO_RANGE = yyV1; 
  }
   return CombineACF (yyV2, CombineACF (t, yyV3));
 }

  }
/* line 438 "TempFunctions.puma" */
   return t;

}

static tTree BasicFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kIO_STMT) {
/* line 450 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 452 "TempFunctions.puma" */
   TempFunctions (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS, & yyV1, & yyV2, & yyV3);
/* line 453 "TempFunctions.puma" */
   TempFunctions (t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS, & yyV4, & yyV5, & yyV6);
/* line 455 "TempFunctions.puma" */
 t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_SPECS = yyV1; t->ACF_BASIC.BASIC_STMT->IO_STMT.IO_ITEMS = yyV4; 
/* line 457 "TempFunctions.puma" */
   yyV2 = CombineACF (yyV2, yyV5);
/* line 458 "TempFunctions.puma" */
   yyV3 = CombineACF (yyV6, yyV3);
  }
   return ComposeNewACF (yyV2, t, yyV3);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 463 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 465 "TempFunctions.puma" */
   TempFunctions (t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS, & yyV1, & yyV2, & yyV3);
/* line 467 "TempFunctions.puma" */
 t->ACF_BASIC.BASIC_STMT->CALL_STMT.CALL_PARAMS = yyV1; 
  }
   return ComposeNewACF (yyV2, t, yyV3);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kCOMP_IF_STMT) {
/* line 472 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 474 "TempFunctions.puma" */
   TempFunctions (t->ACF_BASIC.BASIC_STMT->COMP_IF_STMT.IF_EXP, & yyV1, & yyV2, & yyV3);
/* line 476 "TempFunctions.puma" */
 t->ACF_BASIC.BASIC_STMT->COMP_IF_STMT.IF_EXP = yyV1; 
  }
   return ComposeNewACF (yyV2, t, yyV3);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 481 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 483 "TempFunctions.puma" */
   AssignFuncStmts (t->ACF_BASIC.BASIC_STMT, rfalse, & yyV1, & yyV2);
  }
   return ComposeNewACF (yyV1, t, yyV2);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kPTR_ASSIGN_STMT) {
/* line 488 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 490 "TempFunctions.puma" */
   TempFunctions (t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2, & yyV3);
/* line 491 "TempFunctions.puma" */
   TempFunctions (t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_EXP, & yyV4, & yyV5, & yyV6);
/* line 493 "TempFunctions.puma" */
 t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_VAR = yyV1; t->ACF_BASIC.BASIC_STMT->PTR_ASSIGN_STMT.ASSIGN_EXP = yyV4; 
/* line 495 "TempFunctions.puma" */
   yyV2 = CombineACF (yyV2, yyV5);
/* line 496 "TempFunctions.puma" */
   yyV3 = CombineACF (yyV6, yyV3);
  }
   return ComposeNewACF (yyV2, t, yyV3);
 }

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
/* line 501 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 503 "TempFunctions.puma" */
   TempFunctions (t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS, & yyV1, & yyV2, & yyV3);
/* line 505 "TempFunctions.puma" */
 t->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS = yyV1; 
  }
   return ComposeNewACF (yyV2, t, yyV3);
 }

  }
/* line 510 "TempFunctions.puma" */
   return t;

  }
 yyAbort ("BasicFuncStmts");
 { tTree yyDummy; return yyDummy; }
}

static void AssignFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t, register rbool masked, register tTree * yyP5, register tTree * yyP4)
# else
(t, masked, yyP5, yyP4)
 register tTree t;
 register rbool masked;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
  if (t->Kind == kASSIGN_STMT) {
  if (t->ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 532 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 534 "TempFunctions.puma" */
   if (! ((! masked))) goto yyL1;
  {
/* line 535 "TempFunctions.puma" */
   if (! ((HandledFunctionCall (t->ASSIGN_STMT.ASSIGN_VAR, t->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL1;
  {
/* line 537 "TempFunctions.puma" */
   TempFunctions (t->ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2, & yyV3);
/* line 538 "TempFunctions.puma" */
   TempFunctions (t->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS, & yyV4, & yyV5, & yyV6);
/* line 540 "TempFunctions.puma" */
 t->ASSIGN_STMT.ASSIGN_EXP->FUNC_CALL_EXP.FUNC_PARAMS = yyV4; t->ASSIGN_STMT.ASSIGN_VAR = yyV1; 
/* line 542 "TempFunctions.puma" */
   yyV2 = CombineACF (yyV2, yyV5);
/* line 543 "TempFunctions.puma" */
   yyV3 = CombineACF (yyV6, yyV3);
  }
  }
  }
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }
yyL1:;

  }
  if (t->ASSIGN_STMT.ASSIGN_EXP->Kind == kTYPE_EXP) {
/* line 546 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 548 "TempFunctions.puma" */
   if (! ((! masked))) goto yyL2;
  {
/* line 549 "TempFunctions.puma" */
   if (! ((TreeRank (t->ASSIGN_STMT.ASSIGN_VAR) == TreeRank (t->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
/* line 550 "TempFunctions.puma" */
   if (! ((IsSameExpType (t->ASSIGN_STMT.ASSIGN_VAR, t->ASSIGN_STMT.ASSIGN_EXP)))) goto yyL2;
  {
/* line 552 "TempFunctions.puma" */
   TempFunctions (t->ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2, & yyV3);
/* line 553 "TempFunctions.puma" */
   TempFunctions (t->ASSIGN_STMT.ASSIGN_EXP->TYPE_EXP.ELEMENTS, & yyV4, & yyV5, & yyV6);
/* line 555 "TempFunctions.puma" */
 t->ASSIGN_STMT.ASSIGN_EXP->TYPE_EXP.ELEMENTS = yyV4; t->ASSIGN_STMT.ASSIGN_VAR = yyV1; 
/* line 557 "TempFunctions.puma" */
   yyV2 = CombineACF (yyV2, yyV5);
/* line 558 "TempFunctions.puma" */
   yyV3 = CombineACF (yyV6, yyV3);
  }
  }
  }
  }
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }
yyL2:;

  }
/* line 563 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 565 "TempFunctions.puma" */
   TempFunctions (t->ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2, & yyV3);
/* line 566 "TempFunctions.puma" */
   TempFunctions (t->ASSIGN_STMT.ASSIGN_EXP, & yyV4, & yyV5, & yyV6);
/* line 568 "TempFunctions.puma" */
 t->ASSIGN_STMT.ASSIGN_VAR = yyV1; t->ASSIGN_STMT.ASSIGN_EXP = yyV4; 
/* line 570 "TempFunctions.puma" */
   yyV2 = CombineACF (yyV2, yyV5);
/* line 571 "TempFunctions.puma" */
   yyV3 = CombineACF (yyV6, yyV3);
  }
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

  }
/* line 574 "TempFunctions.puma" */
  {
/* line 576 "TempFunctions.puma" */
   failure_protocol (MODULE, "AssignFuncStmts", t);
  }
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

static rbool HandledFunctionCall
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp)
# else
(var, exp)
 register tTree var;
 register tTree exp;
# endif
{
/* line 589 "TempFunctions.puma" */
  {
/* line 591 "TempFunctions.puma" */
   if (! ((TreeRank (var) != TreeRank (exp)))) goto yyL1;
  {
/* line 592 "TempFunctions.puma" */
   return rfalse;
  }
  }
yyL1:;

/* line 595 "TempFunctions.puma" */
  {
/* line 597 "TempFunctions.puma" */
   if (! ((! IsSameExpType (var, exp)))) goto yyL2;
  {
/* line 598 "TempFunctions.puma" */
   return rfalse;
  }
  }
yyL2:;

  if (var->Kind == kINDEXED_VAR) {
/* line 601 "TempFunctions.puma" */
  {
/* line 603 "TempFunctions.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL3;
  {
/* line 604 "TempFunctions.puma" */
   return rfalse;
  }
  }
yyL3:;

  }
/* line 607 "TempFunctions.puma" */
   return rtrue;

}

static void ParallelFuncStmts
# if defined __STDC__ | defined __cplusplus
(register tTree t, register rbool where_mask, register tTree * yyP7, register tTree * yyP6)
# else
(t, where_mask, yyP7, yyP6)
 register tTree t;
 register rbool where_mask;
 register tTree * yyP7;
 register tTree * yyP6;
# endif
{
  if (t->Kind == kACF_FORALL) {
/* line 619 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
/* line 622 "TempFunctions.puma" */
   TempFunctions (t->ACF_FORALL.FORALL_RANGE, & yyV1, & yyV2, & yyV3);
/* line 624 "TempFunctions.puma" */
 t->ACF_FORALL.FORALL_RANGE = yyV1; 
/* line 626 "TempFunctions.puma" */
   ParallelFuncStmts (t->ACF_FORALL.FORALL_BODY, where_mask, & yyV4, & yyV5);
/* line 628 "TempFunctions.puma" */
   ExpandNewStatements (yyV4, t, t->ACF_FORALL.Line);
/* line 629 "TempFunctions.puma" */
   ExpandNewStatements (yyV5, t, t->ACF_FORALL.Line);
/* line 631 "TempFunctions.puma" */
   yyV4 = CombineACF (yyV2, yyV4);
/* line 632 "TempFunctions.puma" */
   yyV5 = CombineACF (yyV5, yyV3);
  }
   * yyP7 = yyV4;
   * yyP6 = yyV5;
   return;
 }

  }
  if (t->Kind == kACF_WHERE) {
/* line 635 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  {
/* line 639 "TempFunctions.puma" */
   TempFunctions (t->ACF_WHERE.WHERE_EXP, & yyV1, & yyV2, & yyV3);
/* line 641 "TempFunctions.puma" */
   ParallelFuncStmts (t->ACF_WHERE.TRUE_PART, rtrue, & yyV4, & yyV5);
/* line 642 "TempFunctions.puma" */
   ParallelFuncStmts (t->ACF_WHERE.FALSE_PART, rtrue, & yyV6, & yyV7);
/* line 644 "TempFunctions.puma" */
 t->ACF_WHERE.WHERE_EXP = yyV1; 
/* line 646 "TempFunctions.puma" */
   yyV2 = CombineACF (yyV2, CombineACF (yyV4, yyV6));
/* line 647 "TempFunctions.puma" */
   yyV3 = CombineACF (yyV7, CombineACF (yyV5, yyV3));
  }
   * yyP7 = yyV2;
   * yyP6 = yyV3;
   return;
 }

  }
  if (t->Kind == kACF_IF) {
/* line 650 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  {
/* line 654 "TempFunctions.puma" */
   TempFunctions (t->ACF_IF.IF_EXP, & yyV1, & yyV2, & yyV3);
/* line 658 "TempFunctions.puma" */
   ParallelFuncStmts (t->ACF_IF.THEN_PART, rfalse, & yyV4, & yyV5);
/* line 659 "TempFunctions.puma" */
   ParallelFuncStmts (t->ACF_IF.ELSE_PART, rfalse, & yyV6, & yyV7);
/* line 661 "TempFunctions.puma" */
 t->ACF_IF.IF_EXP = yyV1; 
/* line 663 "TempFunctions.puma" */
   yyV2 = CombineACF (yyV2, CombineACF (yyV4, yyV6));
/* line 664 "TempFunctions.puma" */
   yyV3 = CombineACF (yyV7, CombineACF (yyV5, yyV3));
  }
   * yyP7 = yyV2;
   * yyP6 = yyV3;
   return;
 }

  }
  if (t->Kind == kACF_LIST) {
/* line 667 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 669 "TempFunctions.puma" */
   ParallelFuncStmts (t->ACF_LIST.Elem, where_mask, & yyV1, & yyV2);
/* line 670 "TempFunctions.puma" */
   ParallelFuncStmts (t->ACF_LIST.Next, where_mask, & yyV3, & yyV4);
/* line 672 "TempFunctions.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 673 "TempFunctions.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP7 = yyV1;
   * yyP6 = yyV2;
   return;
 }

  }
  if (t->Kind == kACF_EMPTY) {
/* line 676 "TempFunctions.puma" */
   * yyP7 = NoTree;
   * yyP6 = NoTree;
   return;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 679 "TempFunctions.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 681 "TempFunctions.puma" */
   AssignFuncStmts (t->ACF_BASIC.BASIC_STMT, where_mask, & yyV1, & yyV2);
  }
   * yyP7 = yyV1;
   * yyP6 = yyV2;
   return;
 }

  }
  }
/* line 684 "TempFunctions.puma" */
  {
/* line 686 "TempFunctions.puma" */
   failure_protocol (MODULE, "ParallelFuncStmts", t);
  }
   * yyP7 = NoTree;
   * yyP6 = NoTree;
   return;

;
}

static rbool AllowedFunctionExpression
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kFUNC_CALL_EXP) {
/* line 703 "TempFunctions.puma" */
  {
/* line 705 "TempFunctions.puma" */
   if (! ((IsStmtCall (exp)))) goto yyL1;
  }
   return rtrue;
yyL1:;

/* line 708 "TempFunctions.puma" */
  {
/* line 710 "TempFunctions.puma" */
   if (! ((IsF77Call (exp)))) goto yyL2;
  {
/* line 711 "TempFunctions.puma" */
   if (! ((! IsSerialCall (exp)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 714 "TempFunctions.puma" */
  {
/* line 716 "TempFunctions.puma" */
   if (! ((! IsIntrCall (exp)))) goto yyL3;
  {
/* line 717 "TempFunctions.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 720 "TempFunctions.puma" */
  {
/* line 722 "TempFunctions.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL4;
  {
/* line 723 "TempFunctions.puma" */
   if (! ((IntrFuncElemental (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL4;
  {
/* line 724 "TempFunctions.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident != IsIdent ("MERGE")))) goto yyL4;
  }
  }
  }
   return rtrue;
yyL4:;

/* line 727 "TempFunctions.puma" */
  {
/* line 729 "TempFunctions.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL5;
  {
/* line 730 "TempFunctions.puma" */
   if (! ((IntrFuncInquiry (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL5;
  {
/* line 731 "TempFunctions.puma" */
   if (! ((! IntrFuncShape (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident)))) goto yyL5;
  {
/* line 732 "TempFunctions.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident != IsIdent ("ACTIVE_NUM_PROCS")))) goto yyL5;
  }
  }
  }
  }
   return rtrue;
yyL5:;

/* line 735 "TempFunctions.puma" */
  {
/* line 737 "TempFunctions.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL6;
  {
/* line 738 "TempFunctions.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("SPREAD")))) goto yyL6;
  }
  }
   return rtrue;
yyL6:;

/* line 741 "TempFunctions.puma" */
  {
/* line 743 "TempFunctions.puma" */
   if (! ((IsIntrCall (exp)))) goto yyL7;
  {
/* line 744 "TempFunctions.puma" */
   if (! ((exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident == IsIdent ("TRANSPOSE")))) goto yyL7;
  }
  }
   return rtrue;
yyL7:;

  }
  return rfalse;
}

static tTree MakeVarTree
# if defined __STDC__ | defined __cplusplus
(register tTree old, register tTree new)
# else
(old, new)
 register tTree old;
 register tTree new;
# endif
{
  if (old->Kind == kADDR) {
  if (new->Kind == kVAR_EXP) {
/* line 753 "TempFunctions.puma" */
   return new->VAR_EXP.V;

  }
/* line 758 "TempFunctions.puma" */
  {
/* line 760 "TempFunctions.puma" */
 old->ADDR.E = new; 
  }
   return old;

  }
 yyAbort ("MakeVarTree");
 { tTree yyDummy; return yyDummy; }
}

void BeginTempFunctions ARGS ((void))
{
}

void CloseTempFunctions ARGS ((void))
{
}
