# include "TempExp.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 35 "TempExp.puma" */


# include "protocol.h"

# include "Transform.h"       /* CombineACF                        */
# include "TreeOps.h"         /* CombineACF                        */

# include "Temporary.h"
# include "Distributions.h"
# include "Loops.h"           /*                                   */
# include "NewStatements.h"   /* ExpandNewStatements               */

# include "Nesting.h"         /* GetLoopId                         */
# include "ParNest.h"         /*                                   */
# include "Rank.h"            /*                                   */

# include "Expansion.h"      /* PrintableDescriptorVar            */
# include "Descriptor.h"      /* PrintableDescriptorVar            */
# include "Accepted.h"        /* PrintableDescriptorVar            */
# include "HomeDescriptor.h"  /* MakeHostDescriptor                */

# include "VarComm.h"         /* IsLocalVarRead, IsLocalVarWrite   */

# include "HomeTemps.h"       /* HomeTempVar                       */
# include "TempAssigns.h"
# include "ExpDescriptor.h"   /* SetExpType                        */

# include "IndShadow.h"       /* Indirect Shadows                  */

# define MODULE "TempExp"

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTempExp.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* TempExp_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempExp, routine %s failed\n",
  yyFunction);
 TempExp_Exit ();
}

void MakeLocalExp ARGS ((tTree exp, pvar home_vard, tTree * yyP3, tTree * yyP2, tTree * yyP1));
void MakeHostExp ARGS ((tTree exp, tTree * yyP6, tTree * yyP5, tTree * yyP4));
void MakeReplExp ARGS ((tTree exp, tTree * yyP9, tTree * yyP8, tTree * yyP7));
static void LocalizeExp ARGS ((tTree exp, pvar home_vard, tTree * yyP12, tTree * yyP11, tTree * yyP10));
static void LocalizeVarIndexes ARGS ((tTree var, pvar home_vard, tTree * yyP14, tTree * yyP13));
void MakeLocalParams ARGS ((tTree args, pvar home_vard, tTree * yyP16, tTree * yyP15));
void MakeLocalVarParam ARGS ((tTree var, int intent, pvar home_vard, tTree * yyP19, tTree * yyP18, tTree * yyP17));
void MakeLocalVarAccess ARGS ((tTree var, pvar home_vard, int intent, tTree * yyP22, tTree * yyP21, tTree * yyP20));
void MakeFullLocalIndexes ARGS ((tTree var, pvar home_vard, tTree * yyP24, tTree * yyP23));
static rbool IsSpreadAssign ARGS ((pvar home_vard, tTree exp));
static void SetParamExp ARGS ((tTree param, tTree exp));
static void MakeLocalIndex ARGS ((tTree index, pvar home, tTree * yyP27, tTree * yyP26, tTree * yyP25));
static void MyMakeTemporaryStmt ARGS ((tTree exp, pvar vard, tTree * yyP31, tTree * yyP30, tTree * yyP29, tTree * yyP28));
static rbool IsFullBroadcast ARGS ((tTree var));
static int ImpliedDos ARGS ((void));
static rbool ImpliedDoLoop ARGS ((tTree loop));

void MakeLocalExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar home_vard, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(exp, home_vard, yyP3, yyP2, yyP1)
 register tTree exp;
 pvar home_vard;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 90 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 92 "TempExp.puma" */
   LocalizeExp (exp, home_vard, & yyV1, & yyV2, & yyV3);
  }
   * yyP3 = yyV1;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

;
}

void MakeHostExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(exp, yyP6, yyP5, yyP4)
 register tTree exp;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
/* line 114 "TempExp.puma" */
 {
  var_descriptor vard;
  int dist;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 119 "TempExp.puma" */
   MakeHostDescriptor (& vard);
/* line 121 "TempExp.puma" */
   LocalizeExp (exp, & vard, & yyV1, & yyV2, & yyV3);
/* line 123 "TempExp.puma" */
 dist = TreeReadDistribution (yyV1);
    if ((dist < -1) || (dist > 0))
       { error_protocol ("failed to make host expression");
         tree_protocol  ("illegal expression is : ", exp);
         tree_protocol  ("pre statements : ", yyV2);
         tree_protocol  ("post statements : ", yyV3);
       }
  
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   * yyP4 = yyV3;
   return;
 }

;
}

void MakeReplExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(exp, yyP9, yyP8, yyP7)
 register tTree exp;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
/* line 151 "TempExp.puma" */
 {
  var_descriptor vard;
  int dist;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 156 "TempExp.puma" */
   MakeReplicatedDescriptor (& vard);
/* line 158 "TempExp.puma" */
   LocalizeExp (exp, & vard, & yyV1, & yyV2, & yyV3);
/* line 160 "TempExp.puma" */
 dist = TreeReadDistribution (yyV1);

    if (dist != 0)

       { char msg[128];
         error_protocol ("failed to make replicated expression");
         sprintf (msg, "illegal expression (dist = %d) is : ", dist);
         tree_protocol  (msg, exp);
       }
  
  }
   * yyP9 = yyV1;
   * yyP8 = yyV2;
   * yyP7 = yyV3;
   return;
 }

;
}

static void LocalizeExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar home_vard, register tTree * yyP12, register tTree * yyP11, register tTree * yyP10)
# else
(exp, home_vard, yyP12, yyP11, yyP10)
 register tTree exp;
 pvar home_vard;
 register tTree * yyP12;
 register tTree * yyP11;
 register tTree * yyP10;
# endif
{

  switch (exp->Kind) {
  case kDUMMY_EXP:
/* line 187 "TempExp.puma" */
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kCONST_EXP:
/* line 190 "TempExp.puma" */
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kBOUND_EXP:
/* line 193 "TempExp.puma" */
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kRANK_EXP:
/* line 196 "TempExp.puma" */
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kOP_EXP:
/* line 205 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 208 "TempExp.puma" */
   LocalizeExp (exp->OP_EXP.OPND1, home_vard, & yyV1, & yyV2, & yyV3);
/* line 209 "TempExp.puma" */
   LocalizeExp (exp->OP_EXP.OPND2, home_vard, & yyV4, & yyV5, & yyV6);
/* line 211 "TempExp.puma" */
 exp->OP_EXP.OPND1 = yyV1; 
     exp->OP_EXP.OPND2 = yyV4;
   
  }
   * yyP12 = exp;
   * yyP11 = CombineACF (yyV2, yyV5);
   * yyP10 = CombineACF (yyV6, yyV3);
   return;
 }

  case kOP1_EXP:
/* line 223 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 225 "TempExp.puma" */
   LocalizeExp (exp->OP1_EXP.OPND, home_vard, & yyV1, & yyV2, & yyV3);
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kFUNC_CALL_EXP:
/* line 234 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 242 "TempExp.puma" */
   MakeLocalParams (exp->FUNC_CALL_EXP.FUNC_PARAMS, home_vard, & yyV1, & yyV2);
  }
   * yyP12 = exp;
   * yyP11 = yyV1;
   * yyP10 = yyV2;
   return;
 }

  case kTYPE_EXP:
/* line 251 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 253 "TempExp.puma" */
   LocalizeExp (exp->TYPE_EXP.ELEMENTS, home_vard, & yyV1, & yyV2, & yyV3);
/* line 255 "TempExp.puma" */
 exp->TYPE_EXP.ELEMENTS = yyV1; 
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kARRAY_EXP:
/* line 264 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 266 "TempExp.puma" */
   LocalizeExp (exp->ARRAY_EXP.ELEMENTS, home_vard, & yyV1, & yyV2, & yyV3);
/* line 268 "TempExp.puma" */
 exp->ARRAY_EXP.ELEMENTS = yyV1; 
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kBTE_LIST:
/* line 271 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 273 "TempExp.puma" */
   LocalizeExp (exp->BTE_LIST.Elem, home_vard, & yyV1, & yyV2, & yyV3);
/* line 274 "TempExp.puma" */
   LocalizeExp (exp->BTE_LIST.Next, home_vard, & yyV4, & yyV5, & yyV6);
/* line 276 "TempExp.puma" */
   yyV2 = CombineACF (yyV2, yyV5);
/* line 277 "TempExp.puma" */
   yyV3 = CombineACF (yyV6, yyV3);
/* line 279 "TempExp.puma" */
 exp->BTE_LIST.Elem = yyV1; exp->BTE_LIST.Next = yyV4; 
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kBTE_EMPTY:
/* line 282 "TempExp.puma" */
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  case kSLICE_EXP:
/* line 285 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  tTree yyV8;
  tTree yyV9;
  {
/* line 287 "TempExp.puma" */
   LocalizeExp (exp->SLICE_EXP.FIRST, home_vard, & yyV1, & yyV2, & yyV3);
/* line 288 "TempExp.puma" */
   LocalizeExp (exp->SLICE_EXP.STOP, home_vard, & yyV4, & yyV5, & yyV6);
/* line 289 "TempExp.puma" */
   LocalizeExp (exp->SLICE_EXP.INC, home_vard, & yyV7, & yyV8, & yyV9);
/* line 291 "TempExp.puma" */
 exp->SLICE_EXP.FIRST = yyV1; exp->SLICE_EXP.STOP = yyV4; exp->SLICE_EXP.INC = yyV7;  
/* line 293 "TempExp.puma" */
   yyV2 = CombineACF (yyV2, CombineACF (yyV5, yyV8));
/* line 294 "TempExp.puma" */
   yyV3 = CombineACF (yyV9, CombineACF (yyV6, yyV3));
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  case kDO_EXP:
/* line 304 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 306 "TempExp.puma" */
   LocalizeExp (exp->DO_EXP.RANGE, home_vard, & yyV1, & yyV2, & yyV3);
/* line 308 "TempExp.puma" */
   IncParNesting (exp);
/* line 310 "TempExp.puma" */
   LocalizeExp (exp->DO_EXP.BODY, home_vard, & yyV4, & yyV5, & yyV6);
/* line 312 "TempExp.puma" */
 exp->DO_EXP.BODY = yyV4; exp->DO_EXP.RANGE = yyV1; 
/* line 314 "TempExp.puma" */
   DecParNesting (exp);
/* line 316 "TempExp.puma" */
   ExpandNewStatements (yyV5, exp, 0);
/* line 317 "TempExp.puma" */
   ExpandNewStatements (yyV6, exp, 0);
/* line 319 "TempExp.puma" */
   yyV5 = CombineACF (yyV2, yyV5);
/* line 320 "TempExp.puma" */
   yyV6 = CombineACF (yyV6, yyV3);
  }
   * yyP12 = exp;
   * yyP11 = yyV5;
   * yyP10 = yyV6;
   return;
 }

  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kREMOTE_VAR) {
/* line 323 "TempExp.puma" */
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

  }
/* line 336 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 338 "TempExp.puma" */
   if (! ((IsLocalVarRead (exp->VAR_EXP.V, home_vard)))) goto yyL15;
  {
/* line 340 "TempExp.puma" */
   LocalizeVarIndexes (exp->VAR_EXP.V, home_vard, & yyV1, & yyV2);
  }
  }
   * yyP12 = exp;
   * yyP11 = yyV1;
   * yyP10 = yyV2;
   return;
 }
yyL15:;

/* line 354 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 356 "TempExp.puma" */
   MakeLocalVarAccess (exp->VAR_EXP.V, home_vard, IntentIn, & yyV1, & yyV2, & yyV3);
/* line 359 "TempExp.puma" */
 exp->VAR_EXP.V = yyV1; 
  }
   * yyP12 = exp;
   * yyP11 = yyV2;
   * yyP10 = yyV3;
   return;
 }

  }

/* line 362 "TempExp.puma" */
  {
/* line 364 "TempExp.puma" */
   error_protocol ("LocalizeExp failed, could not localize computation");
/* line 365 "TempExp.puma" */
   tree_protocol ("illegal term  : ", exp);
  }
   * yyP12 = exp;
   * yyP11 = NoTree;
   * yyP10 = NoTree;
   return;

;
}

static void LocalizeVarIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, register tTree * yyP14, register tTree * yyP13)
# else
(var, home_vard, yyP14, yyP13)
 register tTree var;
 pvar home_vard;
 register tTree * yyP14;
 register tTree * yyP13;
# endif
{
  if (var->Kind == kREMOTE_VAR) {
/* line 377 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 379 "TempExp.puma" */
   LocalizeVarIndexes (var->REMOTE_VAR.VAR, home_vard, & yyV1, & yyV2);
  }
   * yyP14 = yyV1;
   * yyP13 = yyV2;
   return;
 }

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 382 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 384 "TempExp.puma" */
   LocalizeVarIndexes (var->SELECTED_VAR.SELEC_VAR, home_vard, & yyV1, & yyV2);
  }
   * yyP14 = yyV1;
   * yyP13 = yyV2;
   return;
 }

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 387 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
/* line 390 "TempExp.puma" */
   LocalizeVarIndexes (var->INDEXED_VAR.IND_VAR, home_vard, & yyV1, & yyV2);
/* line 391 "TempExp.puma" */
   LocalizeExp (var->INDEXED_VAR.IND_EXPS, home_vard, & yyV3, & yyV4, & yyV5);
/* line 393 "TempExp.puma" */
 var->INDEXED_VAR.IND_EXPS = yyV3; 
  }
   * yyP14 = CombineACF (yyV1, yyV4);
   * yyP13 = CombineACF (yyV5, yyV2);
   return;
 }

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 396 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
/* line 399 "TempExp.puma" */
   LocalizeVarIndexes (var->SUBSTRING_VAR.IND_VAR, home_vard, & yyV1, & yyV2);
/* line 400 "TempExp.puma" */
   LocalizeExp (var->SUBSTRING_VAR.IND_EXP, home_vard, & yyV3, & yyV4, & yyV5);
/* line 402 "TempExp.puma" */
 var->SUBSTRING_VAR.IND_EXP = yyV3; 
  }
   * yyP14 = CombineACF (yyV1, yyV4);
   * yyP13 = CombineACF (yyV5, yyV2);
   return;
 }

  }
  if (var->Kind == kUSED_VAR) {
/* line 405 "TempExp.puma" */
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

  }
  if (var->Kind == kLOOP_VAR) {
/* line 408 "TempExp.puma" */
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

  }
/* line 411 "TempExp.puma" */
   * yyP14 = NoTree;
   * yyP13 = NoTree;
   return;

;
}

void MakeLocalParams
# if defined __STDC__ | defined __cplusplus
(register tTree args, pvar home_vard, register tTree * yyP16, register tTree * yyP15)
# else
(args, home_vard, yyP16, yyP15)
 register tTree args;
 pvar home_vard;
 register tTree * yyP16;
 register tTree * yyP15;
# endif
{
  if (args->Kind == kBTP_LIST) {
/* line 423 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 425 "TempExp.puma" */
   MakeLocalParams (args->BTP_LIST.Elem, home_vard, & yyV1, & yyV2);
/* line 426 "TempExp.puma" */
   MakeLocalParams (args->BTP_LIST.Next, home_vard, & yyV3, & yyV4);
/* line 428 "TempExp.puma" */
   yyV1 = CombineACF (yyV1, yyV3);
/* line 429 "TempExp.puma" */
   yyV2 = CombineACF (yyV4, yyV2);
  }
   * yyP16 = yyV1;
   * yyP15 = yyV2;
   return;
 }

  }
  if (args->Kind == kBTP_EMPTY) {
/* line 432 "TempExp.puma" */
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
  if (args->Kind == kVAR_PARAM) {
  if (args->VAR_PARAM.V->Kind == kADDR) {
/* line 435 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 437 "TempExp.puma" */
   LocalizeExp (args->VAR_PARAM.V->ADDR.E, home_vard, & yyV1, & yyV2, & yyV3);
/* line 438 "TempExp.puma" */
   SetParamExp (args, yyV1);
  }
   * yyP16 = yyV2;
   * yyP15 = yyV3;
   return;
 }

  }
/* line 441 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 444 "TempExp.puma" */
   MakeLocalVarParam (args->VAR_PARAM.V, args->VAR_PARAM.intent, home_vard, & yyV1, & yyV2, & yyV3);
/* line 447 "TempExp.puma" */
 args->VAR_PARAM.V = yyV1; 
  }
   * yyP16 = yyV2;
   * yyP15 = yyV3;
   return;
 }

  }
  if (args->Kind == kNO_PARAM) {
/* line 450 "TempExp.puma" */
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
  if (args->Kind == kFUNC_PARAM) {
/* line 453 "TempExp.puma" */
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
  if (args->Kind == kPROC_PARAM) {
/* line 456 "TempExp.puma" */
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

  }
/* line 459 "TempExp.puma" */
  {
/* line 461 "TempExp.puma" */
   error_protocol ("MakeLocalParams failed, could not localize arguments");
/* line 462 "TempExp.puma" */
   tree_protocol ("illegal arg  : ", args);
  }
   * yyP16 = NoTree;
   * yyP15 = NoTree;
   return;

;
}

void MakeLocalVarParam
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int intent, pvar home_vard, register tTree * yyP19, register tTree * yyP18, register tTree * yyP17)
# else
(var, intent, home_vard, yyP19, yyP18, yyP17)
 register tTree var;
 register int intent;
 pvar home_vard;
 register tTree * yyP19;
 register tTree * yyP18;
 register tTree * yyP17;
# endif
{
  if (var->Kind == kDO_VAR) {
/* line 476 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 478 "TempExp.puma" */
   tree_protocol ("I/O argument will be localized : ", var);
/* line 482 "TempExp.puma" */
   MakeLocalVarAccess (var, home_vard, intent, & yyV1, & yyV2, & yyV3);
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   * yyP17 = yyV3;
   return;
 }

  }
/* line 488 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 490 "TempExp.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL2;
  {
/* line 492 "TempExp.puma" */
   tree_protocol ("scalar argument will be localized : ", var);
/* line 494 "TempExp.puma" */
   MakeLocalVarAccess (var, home_vard, intent, & yyV1, & yyV2, & yyV3);
  }
  }
   * yyP19 = yyV1;
   * yyP18 = yyV2;
   * yyP17 = yyV3;
   return;
 }
yyL2:;

/* line 500 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 502 "TempExp.puma" */
   if (! ((TreeRank (var) > 0))) goto yyL3;
  {
/* line 506 "TempExp.puma" */
   LocalizeVarIndexes (var, home_vard, & yyV1, & yyV2);
  }
  }
   * yyP19 = var;
   * yyP18 = yyV1;
   * yyP17 = yyV2;
   return;
 }
yyL3:;

;
}

void MakeLocalVarAccess
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, register int intent, register tTree * yyP22, register tTree * yyP21, register tTree * yyP20)
# else
(var, home_vard, intent, yyP22, yyP21, yyP20)
 register tTree var;
 pvar home_vard;
 register int intent;
 register tTree * yyP22;
 register tTree * yyP21;
 register tTree * yyP20;
# endif
{
  if (var->Kind == kDO_VAR) {
/* line 543 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 545 "TempExp.puma" */
   LocalizeExp (var->DO_VAR.RANGE, home_vard, & yyV1, & yyV2, & yyV3);
/* line 547 "TempExp.puma" */
   IncParNesting (var);
/* line 549 "TempExp.puma" */
   MakeLocalVarAccess (var->DO_VAR.BODY, home_vard, intent, & yyV4, & yyV5, & yyV6);
/* line 552 "TempExp.puma" */
   DecParNesting (var);
/* line 554 "TempExp.puma" */
 var->DO_VAR.BODY = yyV4; var->DO_VAR.RANGE = yyV1; 
/* line 556 "TempExp.puma" */
   ExpandNewStatements (yyV5, var, 0);
/* line 557 "TempExp.puma" */
   ExpandNewStatements (yyV6, var, 0);
/* line 559 "TempExp.puma" */
   yyV5 = CombineACF (yyV2, yyV5);
/* line 560 "TempExp.puma" */
   yyV6 = CombineACF (yyV6, yyV3);
  }
   * yyP22 = var;
   * yyP21 = yyV5;
   * yyP20 = yyV6;
   return;
 }

  }
  if (var->Kind == kBTV_LIST) {
/* line 563 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  {
/* line 565 "TempExp.puma" */
   MakeLocalVarAccess (var->BTV_LIST.Elem, home_vard, intent, & yyV1, & yyV2, & yyV3);
/* line 567 "TempExp.puma" */
   MakeLocalVarAccess (var->BTV_LIST.Next, home_vard, intent, & yyV4, & yyV5, & yyV6);
/* line 570 "TempExp.puma" */
 var->BTV_LIST.Elem = yyV1;
     var->BTV_LIST.Next = yyV4; 
   
/* line 574 "TempExp.puma" */
   yyV2 = CombineACF (yyV2, yyV5);
/* line 575 "TempExp.puma" */
   yyV3 = CombineACF (yyV6, yyV3);
  }
   * yyP22 = var;
   * yyP21 = yyV2;
   * yyP20 = yyV3;
   return;
 }

  }
  if (var->Kind == kBTV_EMPTY) {
/* line 578 "TempExp.puma" */
   * yyP22 = var;
   * yyP21 = NoTree;
   * yyP20 = NoTree;
   return;

  }
  if (var->Kind == kREMOTE_VAR) {
/* line 585 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 587 "TempExp.puma" */
   LocalizeVarIndexes (var->REMOTE_VAR.VAR, home_vard, & yyV1, & yyV2);
  }
   * yyP22 = var;
   * yyP21 = yyV1;
   * yyP20 = yyV2;
   return;
 }

  }
/* line 594 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 596 "TempExp.puma" */
   if (! ((intent == IntentIn))) goto yyL5;
  {
/* line 597 "TempExp.puma" */
   if (! ((IsLocalVarRead (var, home_vard)))) goto yyL5;
  {
/* line 599 "TempExp.puma" */
   LocalizeVarIndexes (var, home_vard, & yyV1, & yyV2);
  }
  }
  }
   * yyP22 = var;
   * yyP21 = yyV1;
   * yyP20 = yyV2;
   return;
 }
yyL5:;

/* line 606 "TempExp.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  {
/* line 611 "TempExp.puma" */
   if (! ((intent == IntentIn))) goto yyL6;
  {
/* line 612 "TempExp.puma" */
   if (! ((IsIndShadowVariable (var, home_vard)))) goto yyL6;
  {
/* line 616 "TempExp.puma" */
   MakeIndShadowGet (var, & pre_stmts, & post_stmts);
  }
  }
  }
   * yyP22 = var;
   * yyP21 = pre_stmts;
   * yyP20 = post_stmts;
   return;
 }
yyL6:;

/* line 623 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 625 "TempExp.puma" */
   if (! ((IsLocalVarWrite (var, home_vard)))) goto yyL7;
  {
/* line 627 "TempExp.puma" */
   LocalizeVarIndexes (var, home_vard, & yyV1, & yyV2);
  }
  }
   * yyP22 = var;
   * yyP21 = yyV1;
   * yyP20 = yyV2;
   return;
 }
yyL7:;

/* line 634 "TempExp.puma" */
 {
  tTree pre_stmts;
  tTree post_stmts;
  {
/* line 639 "TempExp.puma" */
   if (! ((intent == IntentOut))) goto yyL8;
  {
/* line 640 "TempExp.puma" */
   if (! ((IsIndShadowVariable (var, home_vard)))) goto yyL8;
  {
/* line 642 "TempExp.puma" */
   MakeIndShadowPut (var, & pre_stmts, & post_stmts);
  }
  }
  }
   * yyP22 = var;
   * yyP21 = pre_stmts;
   * yyP20 = post_stmts;
   return;
 }
yyL8:;

/* line 649 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 651 "TempExp.puma" */
   if (! ((IsLocalVarGlobal (var, home_vard)))) goto yyL9;
  {
/* line 657 "TempExp.puma" */
   if (! ((IsFullBroadcast (var)))) goto yyL9;
  {
/* line 659 "TempExp.puma" */
   LocalizeVarIndexes (var, home_vard, & yyV1, & yyV2);
  }
  }
  }
   * yyP22 = var;
   * yyP21 = yyV1;
   * yyP20 = yyV2;
   return;
 }
yyL9:;

/* line 669 "TempExp.puma" */
 {
  tTree tmp_var;
  tTree pre_stmts;
  tTree post_stmts;
  var_descriptor new_vard;
  {
/* line 675 "TempExp.puma" */
   if (! ((IsDescriptorVar (var)))) goto yyL10;
  {
/* line 679 "TempExp.puma" */
   tree_protocol ("communication temporary needed for : ", var);
/* line 681 "TempExp.puma" */
   HomeTempVar (var, home_vard, intent, & new_vard);
/* line 683 "TempExp.puma" */
   ParallelExpansion (& new_vard);
/* line 687 "TempExp.puma" */
   SetExpType (var, & new_vard);
/* line 689 "TempExp.puma" */
   tree_protocol ("new var access for localization ", PrintableDescriptorVar (& new_vard));
/* line 692 "TempExp.puma" */
   MakeTempVarStmt (var, intent, & new_vard, & tmp_var, & pre_stmts, & post_stmts);
  }
  }
   * yyP22 = tmp_var;
   * yyP21 = pre_stmts;
   * yyP20 = post_stmts;
   return;
 }
yyL10:;

  if (var->Kind == kINDEXED_VAR) {
/* line 696 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree tmp_var;
  tTree pre_stmts;
  tTree post_stmts;
  var_descriptor vard;
  {
/* line 698 "TempExp.puma" */
   MakeFullLocalIndexes (var->INDEXED_VAR.IND_EXPS, home_vard, & yyV1, & yyV2);
/* line 708 "TempExp.puma" */
   FullHomeTemp (var, home_vard, & vard);
/* line 709 "TempExp.puma" */
   ParallelExpansion (& vard);
/* line 711 "TempExp.puma" */
   tree_protocol ("new irregular var access for localization ", PrintableDescriptorVar (& vard));
/* line 713 "TempExp.puma" */
   MakeTempVarStmt (var, intent, & vard, & tmp_var, & pre_stmts, & post_stmts);
/* line 716 "TempExp.puma" */
   pre_stmts = CombineACF (yyV1, pre_stmts);
/* line 717 "TempExp.puma" */
   post_stmts = CombineACF (post_stmts, yyV2);
  }
   * yyP22 = tmp_var;
   * yyP21 = pre_stmts;
   * yyP20 = post_stmts;
   return;
 }

  }
/* line 720 "TempExp.puma" */
  {
/* line 722 "TempExp.puma" */
   error_protocol ("MakeLocalVarAccess failed, could not localize computation");
/* line 723 "TempExp.puma" */
   tree_protocol ("illegal term  : ", var);
  }
   * yyP22 = var;
   * yyP21 = NoTree;
   * yyP20 = NoTree;
   return;

;
}

void MakeFullLocalIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var, pvar home_vard, register tTree * yyP24, register tTree * yyP23)
# else
(var, home_vard, yyP24, yyP23)
 register tTree var;
 pvar home_vard;
 register tTree * yyP24;
 register tTree * yyP23;
# endif
{
  if (var->Kind == kINDEXED_VAR) {
/* line 734 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 736 "TempExp.puma" */
   MakeFullLocalIndexes (var->INDEXED_VAR.IND_EXPS, home_vard, & yyV1, & yyV2);
  }
   * yyP24 = yyV1;
   * yyP23 = yyV2;
   return;
 }

  }
  if (var->Kind == kBTE_LIST) {
/* line 739 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  tTree yyV5;
  {
/* line 742 "TempExp.puma" */
   MakeLocalIndex (var->BTE_LIST.Elem, home_vard, & yyV1, & yyV2, & yyV3);
/* line 743 "TempExp.puma" */
 var->BTE_LIST.Elem = yyV1; 
/* line 744 "TempExp.puma" */
   MakeFullLocalIndexes (var->BTE_LIST.Next, home_vard, & yyV4, & yyV5);
  }
   * yyP24 = CombineACF (yyV2, yyV4);
   * yyP23 = CombineACF (yyV5, yyV3);
   return;
 }

  }
  if (var->Kind == kBTE_EMPTY) {
/* line 747 "TempExp.puma" */
   * yyP24 = NoTree;
   * yyP23 = NoTree;
   return;

  }
/* line 750 "TempExp.puma" */
  {
/* line 752 "TempExp.puma" */
   failure_protocol (MODULE, "MakeFullLocalIndexes", var);
  }
   * yyP24 = NoTree;
   * yyP23 = NoTree;
   return;

;
}

static rbool IsSpreadAssign
# if defined __STDC__ | defined __cplusplus
(pvar home_vard, register tTree exp)
# else
(home_vard, exp)
 pvar home_vard;
 register tTree exp;
# endif
{
/* line 768 "TempExp.puma" */
  {
/* line 770 "TempExp.puma" */
   return rfalse;
  }

}

static void SetParamExp
# if defined __STDC__ | defined __cplusplus
(register tTree param, register tTree exp)
# else
(param, exp)
 register tTree param;
 register tTree exp;
# endif
{
  if (param->Kind == kVAR_PARAM) {
  if (exp->Kind == kVAR_EXP) {
/* line 788 "TempExp.puma" */
  {
/* line 789 "TempExp.puma" */
 param->VAR_PARAM.V = exp->VAR_EXP.V; 
  }
   return;

  }
  if (param->VAR_PARAM.V->Kind == kADDR) {
/* line 792 "TempExp.puma" */
  {
/* line 793 "TempExp.puma" */
 param->VAR_PARAM.V->ADDR.E = exp; 
  }
   return;

  }
/* line 796 "TempExp.puma" */
  {
/* line 797 "TempExp.puma" */
 param->VAR_PARAM.V = mADDR (exp); 
  }
   return;

  }
/* line 800 "TempExp.puma" */
  {
/* line 801 "TempExp.puma" */
   failure_protocol (MODULE, "SetParamExp", param);
  }
   return;

;
}

static void MakeLocalIndex
# if defined __STDC__ | defined __cplusplus
(register tTree index, pvar home, register tTree * yyP27, register tTree * yyP26, register tTree * yyP25)
# else
(index, home, yyP27, yyP26, yyP25)
 register tTree index;
 pvar home;
 register tTree * yyP27;
 register tTree * yyP26;
 register tTree * yyP25;
# endif
{
  if (index->Kind == kVAR_EXP) {
/* line 831 "TempExp.puma" */
  {
/* line 833 "TempExp.puma" */
   if (! ((IsFullLoopVar (index->VAR_EXP.V)))) goto yyL1;
  {
/* line 834 "TempExp.puma" */
   if (! ((IsLocalVarWrite (index->VAR_EXP.V, home)))) goto yyL1;
  }
  }
   * yyP27 = index;
   * yyP26 = NoTree;
   * yyP25 = NoTree;
   return;
yyL1:;

  }
/* line 840 "TempExp.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  var_descriptor vard;
  tTree yyV4;
  tTree yyV5;
  tTree yyV6;
  tTree yyV7;
  {
/* line 844 "TempExp.puma" */
   LocalizeExp (index, home, & yyV1, & yyV2, & yyV3);
/* line 848 "TempExp.puma" */
   FullHomeTemp (index, home, & vard);
/* line 850 "TempExp.puma" */
   MyMakeTemporaryStmt (yyV1, & vard, & yyV4, & yyV5, & yyV6, & yyV7);
/* line 852 "TempExp.puma" */
   yyV2 = CombineACF (yyV2, CombineACF (yyV5, yyV6));
/* line 853 "TempExp.puma" */
   yyV3 = CombineACF (yyV7, yyV3);
  }
   * yyP27 = yyV4;
   * yyP26 = yyV2;
   * yyP25 = yyV3;
   return;
 }

;
}

static void MyMakeTemporaryStmt
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP31, register tTree * yyP30, register tTree * yyP29, register tTree * yyP28)
# else
(exp, vard, yyP31, yyP30, yyP29, yyP28)
 register tTree exp;
 pvar vard;
 register tTree * yyP31;
 register tTree * yyP30;
 register tTree * yyP29;
 register tTree * yyP28;
# endif
{
/* line 864 "TempExp.puma" */
 {
  tTree post_stmt;
  tTree pre_stmt;
  tTree assign;
  tTree tmp_var;
  {
/* line 871 "TempExp.puma" */
   ParallelExpansion (vard);
/* line 872 "TempExp.puma" */
   MakeTemporaryStmt (exp, vard, & pre_stmt, & tmp_var, & assign, & post_stmt);
  }
   * yyP31 = mVAR_EXP (tmp_var);
   * yyP30 = pre_stmt;
   * yyP29 = assign;
   * yyP28 = post_stmt;
   return;
 }

;
}

static rbool IsFullBroadcast
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 888 "TempExp.puma" */
  {
/* line 890 "TempExp.puma" */
   if (! ((ImpliedDos () == 0))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (var->Kind == kUSED_VAR) {
/* line 893 "TempExp.puma" */
   return rtrue;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 896 "TempExp.puma" */
  {
/* line 900 "TempExp.puma" */
   if (! ((TreeListLength (var->INDEXED_VAR.IND_EXPS) == GeneralIndexListLength (var)))) goto yyL3;
  {
/* line 902 "TempExp.puma" */
   if (! ((GeneralIndexListLength (var) <= ImpliedDos ()))) goto yyL3;
  }
  }
   return rtrue;
yyL3:;

  }
  return rfalse;
}

static int ImpliedDos
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 925 "TempExp.puma" */
 {
  int n;
  {
/* line 929 "TempExp.puma" */
 int loop;

     n = 0;

     for (loop=1; loop <= OuterLoops(); loop++)
       if (ImpliedDoLoop (GetOuterLoop(loop)))
          n++;

   
  }
   return n;
 }

}

static rbool ImpliedDoLoop
# if defined __STDC__ | defined __cplusplus
(register tTree loop)
# else
(loop)
 register tTree loop;
# endif
{
  if (loop->Kind == kDO_EXP) {
/* line 944 "TempExp.puma" */
   return rtrue;

  }
  if (loop->Kind == kDO_VAR) {
/* line 947 "TempExp.puma" */
   return rtrue;

  }
  return rfalse;
}

void BeginTempExp ARGS ((void))
{
}

void CloseTempExp ARGS ((void))
{
}
