# include "TempAssigns.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 28 "TempAssigns.puma" */


# include "protocol.h"

# include "Transform.h"       /* CombineACF                        */
# include "Temporary.h"
# include "ExpDescriptor.h"   /* GetVarDescriptor                  */

# include "MoveControl.h"     /* GetMajorityVar                    */

# define MODULE "TempAssigns"

# undef DEBUG



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyTempAssigns.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* TempAssigns_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module TempAssigns, routine %s failed\n",
  yyFunction);
 TempAssigns_Exit ();
}

void MakeTemporaryStmt ARGS ((tTree exp, pvar vard, tTree * alloc, tTree * new_var, tTree * assign, tTree * dealloc));
void MakeTempVarStmt ARGS ((tTree var, int code, pvar vard, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static void SwitchAssignment ARGS ((tTree assign));
void MakeTempExpStmt ARGS ((tTree exp, tTree * yyP6, tTree * yyP5, tTree * yyP4));
void MakeTempAssignment ARGS ((tTree exp, pvar vard, tTree * yyP9, tTree * yyP8, tTree * yyP7));

void MakeTemporaryStmt
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * alloc, register tTree * new_var, register tTree * assign, register tTree * dealloc)
# else
(exp, vard, alloc, new_var, assign, dealloc)
 register tTree exp;
 pvar vard;
 register tTree * alloc;
 register tTree * new_var;
 register tTree * assign;
 register tTree * dealloc;
# endif
{
/* line 67 "TempAssigns.puma" */
 {
  tTree tmp_var;
  tTree stmt;
  tTree allocate;
  tTree deallocate;
  {
/* line 74 "TempAssigns.puma" */
 tmp_var = GetVDTemporary (vard);
 
     if (tmp_var == NoTree)
 
        { error_protocol ("could not create temporary");
          allocate = NoTree;
          deallocate = NoTree;
          (* new_var)    = NoTree;
          stmt       = NoTree;
        }
 
      else
 
        { stmt = mASSIGN_STMT (CopyTree(tmp_var), exp);
          
          stmt = mACF_LIST (mACF_BASIC (stmt), NoTree);
 
          GetMemoryStmts (&allocate, &deallocate);
          allocate = CombineACF (allocate, NoTree);
          deallocate = CombineACF (deallocate, NoTree);
        }
   
  }
   * alloc = allocate;
   * new_var = tmp_var;
   * assign = stmt;
   * dealloc = deallocate;
   return;
 }

;
}

void MakeTempVarStmt
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int code, pvar vard, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(var, code, vard, yyP3, yyP2, yyP1)
 register tTree var;
 register int code;
 pvar vard;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
/* line 121 "TempAssigns.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 123 "TempAssigns.puma" */
   if (! ((code == IntentIn))) goto yyL1;
  {
/* line 125 "TempAssigns.puma" */
   MakeTemporaryStmt (mVAR_EXP (var), vard, & yyV1, & yyV2, & yyV3, & yyV4);
  }
  }
   * yyP3 = yyV2;
   * yyP2 = CombineACF (yyV1, yyV3);
   * yyP1 = yyV4;
   return;
 }
yyL1:;

/* line 129 "TempAssigns.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 131 "TempAssigns.puma" */
   if (! ((code == IntentOut))) goto yyL2;
  {
/* line 133 "TempAssigns.puma" */
   MakeTemporaryStmt (mVAR_EXP (var), vard, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 136 "TempAssigns.puma" */
   SwitchAssignment (yyV3);
  }
  }
   * yyP3 = yyV2;
   * yyP2 = yyV1;
   * yyP1 = CombineACF (yyV3, yyV4);
   return;
 }
yyL2:;

/* line 140 "TempAssigns.puma" */
 {
  tTree assign1;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 145 "TempAssigns.puma" */
   MakeTemporaryStmt (mVAR_EXP (var), vard, & yyV1, & yyV2, & yyV3, & yyV4);
/* line 148 "TempAssigns.puma" */
   assign1 = CopyTree (yyV3);
/* line 149 "TempAssigns.puma" */
   SwitchAssignment (yyV3);
  }
   * yyP3 = yyV2;
   * yyP2 = CombineACF (yyV1, assign1);
   * yyP1 = CombineACF (yyV3, yyV4);
   return;
 }

;
}

static void SwitchAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
 yyRecursion:
  if (assign->Kind == kACF_LIST) {
/* line 162 "TempAssigns.puma" */
  {
/* line 163 "TempAssigns.puma" */
   assign = assign->ACF_LIST.Elem;
   goto yyRecursion;
  }

  }
  if (assign->Kind == kACF_BASIC) {
  if (assign->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
  if (assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
/* line 166 "TempAssigns.puma" */
 {
  tTree hvar;
  {
/* line 169 "TempAssigns.puma" */
 hvar = assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR; assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR = assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V; assign->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP->VAR_EXP.V = hvar; 
  }
   return;
 }

  }
  }
  }
/* line 172 "TempAssigns.puma" */
  {
/* line 173 "TempAssigns.puma" */
   failure_protocol (MODULE, "SwitchAssignment", assign);
  }
   return;

;
}

void MakeTempExpStmt
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(exp, yyP6, yyP5, yyP4)
 register tTree exp;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
/* line 204 "TempAssigns.puma" */
 {
  int found;
  rbool found1;
  tTree maj_var;
  var_descriptor vard;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 211 "TempAssigns.puma" */
   GetMajorityVar (exp, & found, & maj_var);
/* line 212 "TempAssigns.puma" */
   if (! ((found == 1))) goto yyL1;
  {
/* line 214 "TempAssigns.puma" */
   GetVarDescriptor (maj_var, & found1, & vard);
/* line 215 "TempAssigns.puma" */
   if (! ((found1))) goto yyL1;
  {
/* line 217 "TempAssigns.puma" */
   SetExpType (exp, & vard);
/* line 219 "TempAssigns.puma" */
   MakeTemporaryStmt (exp, & vard, & yyV1, & yyV2, & yyV3, & yyV4);
  }
  }
  }
   * yyP6 = mVAR_EXP (yyV2);
   * yyP5 = CombineACF (yyV1, yyV3);
   * yyP4 = yyV4;
   return;
 }
yyL1:;

/* line 222 "TempAssigns.puma" */
 {
  var_descriptor vard;
  rbool found;
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 227 "TempAssigns.puma" */
   GetExpDescriptor (exp, & found, & vard);
/* line 228 "TempAssigns.puma" */
   if (! ((found))) goto yyL2;
  {
/* line 230 "TempAssigns.puma" */
   MakeTemporaryStmt (exp, & vard, & yyV1, & yyV2, & yyV3, & yyV4);
  }
  }
   * yyP6 = mVAR_EXP (yyV2);
   * yyP5 = CombineACF (yyV1, yyV3);
   * yyP4 = yyV4;
   return;
 }
yyL2:;

/* line 233 "TempAssigns.puma" */
  {
/* line 235 "TempAssigns.puma" */
   error_protocol ("could not resolve for temporaries");
/* line 236 "TempAssigns.puma" */
   tree_protocol ("no descriptor for this expression : ", exp);
  }
   * yyP6 = exp;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

void MakeTempAssignment
# if defined __STDC__ | defined __cplusplus
(register tTree exp, pvar vard, register tTree * yyP9, register tTree * yyP8, register tTree * yyP7)
# else
(exp, vard, yyP9, yyP8, yyP7)
 register tTree exp;
 pvar vard;
 register tTree * yyP9;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
/* line 249 "TempAssigns.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  tTree yyV4;
  {
/* line 251 "TempAssigns.puma" */
   MakeTemporaryStmt (exp, vard, & yyV1, & yyV2, & yyV3, & yyV4);
  }
   * yyP9 = mVAR_EXP (yyV2);
   * yyP8 = CombineACF (yyV1, yyV3);
   * yyP7 = yyV4;
   return;
 }

;
}

void BeginTempAssigns ARGS ((void))
{
}

void CloseTempAssigns ARGS ((void))
{
}
