# include "StrUnparse.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 31 "StrUnparse.puma" */


# define  STR_LENGTH 1024

# include <string.h>

# include "Tree.h"
# include "Idents.h"
# include "StringM.h"
# include "TreeOps.h"

typedef char fstring[STR_LENGTH];



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyStrUnparse.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* StrUnparse_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module StrUnparse, routine %s failed\n",
  yyFunction);
 StrUnparse_Exit ();
}

void StrUnparse ARGS ((String str, int len, tTree t));

void StrUnparse
# if defined __STDC__ | defined __cplusplus
(String str, register int len, register tTree t)
# else
(str, len, t)
 String str;
 register int len;
 register tTree t;
# endif
{
 yyRecursion:
/* line 67 "StrUnparse.puma" */
  {
/* line 69 "StrUnparse.puma" */
   if (! ((t == NoTree))) goto yyL1;
  {
/* line 70 "StrUnparse.puma" */
   if (! ((len >= 6))) goto yyL1;
  {
/* line 71 "StrUnparse.puma" */
   sprintf (str, "NoTree");
  }
  }
  }
   return;
yyL1:;

/* line 74 "StrUnparse.puma" */
  {
/* line 76 "StrUnparse.puma" */
   if (! ((t == NoTree))) goto yyL2;
  {
/* line 77 "StrUnparse.puma" */
   sprintf (str, "");
  }
  }
   return;
yyL2:;


  switch (t->Kind) {
  case kPROC_OBJ:
/* line 80 "StrUnparse.puma" */
 {
  fstring hstr;
  {
/* line 84 "StrUnparse.puma" */
   GetString (t->PROC_OBJ.Ident, hstr);
/* line 85 "StrUnparse.puma" */
   if (! ((strlen (hstr) <= len))) goto yyL3;
  {
/* line 86 "StrUnparse.puma" */
   sprintf (str, "%s", hstr);
  }
  }
   return;
 }
yyL3:;

  break;
  case kVAR_OBJ:
/* line 89 "StrUnparse.puma" */
 {
  fstring hstr;
  {
/* line 93 "StrUnparse.puma" */
   GetString (t->VAR_OBJ.Ident, hstr);
/* line 94 "StrUnparse.puma" */
   if (! ((strlen (hstr) <= len))) goto yyL4;
  {
/* line 95 "StrUnparse.puma" */
   sprintf (str, "%s", hstr);
  }
  }
   return;
 }
yyL4:;

  break;
  case kUSED_VAR:
/* line 98 "StrUnparse.puma" */
  {
/* line 100 "StrUnparse.puma" */
   t = t->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  case kLOOP_VAR:
/* line 103 "StrUnparse.puma" */
  {
/* line 105 "StrUnparse.puma" */
   t = t->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;
  }

  case kINDEXED_VAR:
/* line 108 "StrUnparse.puma" */
 {
  fstring hstr;
  {
/* line 112 "StrUnparse.puma" */
   StrUnparse (str, len - 2, t->INDEXED_VAR.IND_VAR);
/* line 113 "StrUnparse.puma" */
   StrUnparse (hstr, len - strlen (str) - 2, t->INDEXED_VAR.IND_EXPS);
/* line 115 "StrUnparse.puma" */
   strcat (str, "(");
/* line 116 "StrUnparse.puma" */
   strcat (str, hstr);
/* line 117 "StrUnparse.puma" */
   strcat (str, ")");
  }
   return;
 }

  case kVAR_EXP:
/* line 120 "StrUnparse.puma" */
  {
/* line 122 "StrUnparse.puma" */
   t = t->VAR_EXP.V;
   goto yyRecursion;
  }

  case kBTE_EMPTY:
/* line 125 "StrUnparse.puma" */
  {
/* line 127 "StrUnparse.puma" */
   sprintf (str, "");
  }
   return;

  case kBTE_LIST:
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 130 "StrUnparse.puma" */
  {
/* line 132 "StrUnparse.puma" */
   t = t->BTE_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 135 "StrUnparse.puma" */
 {
  int minlen;
  fstring hstr;
  {
/* line 139 "StrUnparse.puma" */
   minlen = 2 * TreeListLength (t) - 1;
/* line 141 "StrUnparse.puma" */
   if (! ((minlen <= len))) goto yyL11;
  {
/* line 145 "StrUnparse.puma" */
   StrUnparse (str, len + 1 - minlen, t->BTE_LIST.Elem);
/* line 146 "StrUnparse.puma" */
   StrUnparse (hstr, len - strlen (str) - 1, t->BTE_LIST.Next);
/* line 148 "StrUnparse.puma" */
   strcat (str, ",");
/* line 149 "StrUnparse.puma" */
   strcat (str, hstr);
  }
  }
   return;
 }
yyL11:;

  break;
  case kCONST_EXP:
  if (t->CONST_EXP.C->Kind == kINT_CONSTANT) {
/* line 152 "StrUnparse.puma" */
  {
/* line 154 "StrUnparse.puma" */
   if (! ((len >= 5))) goto yyL12;
  {
/* line 155 "StrUnparse.puma" */
   sprintf (str, "%d", t->CONST_EXP.C->INT_CONSTANT.value);
  }
  }
   return;
yyL12:;

  }
  break;
  }

/* line 158 "StrUnparse.puma" */
  {
/* line 160 "StrUnparse.puma" */
   if (! ((len >= 1))) goto yyL13;
  {
/* line 161 "StrUnparse.puma" */
   sprintf (str, ".");
  }
  }
   return;
yyL13:;

/* line 164 "StrUnparse.puma" */
  {
/* line 166 "StrUnparse.puma" */
   sprintf (str, "");
  }
   return;

;
}

void BeginStrUnparse ARGS ((void))
{
}

void CloseStrUnparse ARGS ((void))
{
}
