# include "StmtDeps.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 49 "StmtDeps.puma" */


# include <stdio.h>
# include "Idents.h"
# include "StringM.h"
# include "FArguments.h"       /* IsOnlyReadParam */

# include "TreeOps.h"          /* TreeVarName     */
# include "Objects.h"          /* IsPureCall      */
# include "PTreeOps.h"         /* IsNewDefined    */

# include "protocol.h"

# define  MODULE "StmtDeps" 

# undef DEBUG

# define  READ_ACCESS   1
# define  WRITE_ACCESS  2
# define  INOUT_ACCESS  3

static char *access_strings [] =

    { "DEFAULT",
      "READ",
      "WRITE",
      "INOUT"
    };

       /*************************************************
       *                                                *
       *  Global Data for comparing two variables       *
       *                                                *
       *************************************************/
 
static Predicate  global_check_pred;
static Predicate  global_result_pred;

       /*************************************************
       *                                                *
       *  Data Structures for pushing Loops/News        *
       *                                                *
       *************************************************/
 
static int   Nesting1;            /* nesting depth for stmt1 */
static int   Nesting2;            /* nesting depth for stmt2 */

static tTree Nest1[MAX_FORALL];   /* DOLOCAL loops for maximal nesting */
static tTree Nest2[MAX_FORALL];   /* DOLOCAL loops for maximal nesting */

       /*************************************************
       *                                                *
       *  Data Structures for LoopNest to DepAnalysis   *
       *                                                *
       *************************************************/

static int   Loops1;            /* nesting depth for stmt1 */
static int   Loops2;            /* nesting depth for stmt2 */

static tTree LoopNest1[MAX_FORALL];   /* DOLOCAL loops for maximal nesting */
static tTree LoopNest2[MAX_FORALL];   /* DOLOCAL loops for maximal nesting */

static int   CommonLoops;

       /*************************************************
       *                                                *
       *  Data Structures for Parameters                *
       *                                                *
       *************************************************/

static tTree *Parameters;
static int   NoParameters;

       /*************************************************
       *                                                *
       *  global varaibles used for Dep Analysis        *
       *                                                *
       *************************************************/

static tTree global_stmt1, global_stmt2;

static tTree var1, var2;
static int   kind1, kind2;

static int   step;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyStmtDeps.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* StmtDeps_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module StmtDeps, routine %s failed\n",
  yyFunction);
 StmtDeps_Exit ();
}

void LoopDependence ARGS ((tTree loop, ptree params, int np, Predicate * yyP1));
void FusionDependence ARGS ((tTree stmt1, tTree stmt2, Predicate * yyP2));
static int CountOnLoops ARGS ((tTree spec));
static void FusionTestPredicate ARGS ((int n, Predicate * yyP3));
static void LoopIndepTestPredicate ARGS ((int n, Predicate * yyP4));
static void StmtDependence ARGS ((tTree stmt1, tTree stmt2, Predicate p, Predicate * yyP5));
static void TraverseVars ARGS ((tTree t));
static void TraverseIndexes ARGS ((tTree var));
static void SpecsIncreaseNesting ARGS ((tTree speclist));
static void SpecsDecreaseNesting ARGS ((tTree speclist));
static void IncreaseNesting ARGS ((tTree stmt));
static void DecreaseNesting ARGS ((void));
static void VisitVar ARGS ((tTree var, int kind));
static void ProveDependences ARGS ((tTree var1, int kind1, tTree var2, int kind2));
static void SetFullDependence ARGS ((void));
static void SetLoopStructures ARGS ((tTree var1, tTree var2, int * yyP6));
static rbool IsDoLoop ARGS ((tTree stmt));
static void SetNewInfo ARGS ((pPredVector p, int new));

void LoopDependence
# if defined __STDC__ | defined __cplusplus
(register tTree loop, ptree params, register int np, Predicate * yyP1)
# else
(loop, params, np, yyP1)
 register tTree loop;
 ptree params;
 register int np;
 Predicate * yyP1;
# endif
{
  if (loop->Kind == kACF_DO) {
/* line 145 "StmtDeps.puma" */
 {
  Predicate yyV1;
  Predicate yyV2;
  {
/* line 147 "StmtDeps.puma" */
 Parameters = params; NoParameters = np; 
/* line 149 "StmtDeps.puma" */
   LoopIndepTestPredicate (1, & yyV1);
/* line 150 "StmtDeps.puma" */
   StmtDependence (loop, loop, yyV1, & yyV2);
  }
   * yyP1 = yyV2;
   return;
 }

  }
;
}

void FusionDependence
# if defined __STDC__ | defined __cplusplus
(register tTree stmt1, register tTree stmt2, Predicate * yyP2)
# else
(stmt1, stmt2, yyP2)
 register tTree stmt1;
 register tTree stmt2;
 Predicate * yyP2;
# endif
{
  if (stmt1->Kind == kACF_DO) {
  if (stmt2->Kind == kACF_DO) {
/* line 161 "StmtDeps.puma" */
 {
  Predicate yyV1;
  Predicate yyV2;
  {
/* line 164 "StmtDeps.puma" */
   FusionTestPredicate (1, & yyV1);
/* line 166 "StmtDeps.puma" */
 NoParameters = 0; 
/* line 168 "StmtDeps.puma" */
   StmtDependence (stmt1, stmt2, yyV1, & yyV2);
  }
   * yyP2 = yyV2;
   return;
 }

  }
  }
  if (stmt1->Kind == kACF_ON) {
  if (stmt2->Kind == kACF_ON) {
/* line 171 "StmtDeps.puma" */
 {
  Predicate yyV1;
  Predicate yyV2;
  {
/* line 176 "StmtDeps.puma" */
   FusionTestPredicate (CountOnLoops (stmt1->ACF_ON.ON_SPECS), & yyV1);
/* line 178 "StmtDeps.puma" */
 NoParameters = 0; 
/* line 180 "StmtDeps.puma" */
   StmtDependence (stmt1, stmt2, yyV1, & yyV2);
  }
   * yyP2 = yyV2;
   return;
 }

  }
  }
/* line 183 "StmtDeps.puma" */
 {
  Predicate P;
  {
/* line 186 "StmtDeps.puma" */
   failure2_protocol (MODULE, "StmtDependence", stmt1, stmt2);
  }
   * yyP2 = P;
   return;
 }

;
}

static int CountOnLoops
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
 yyRecursion:
  if (spec->Kind == kON_EMPTY) {
/* line 197 "StmtDeps.puma" */
   return 0;

  }
  if (spec->Kind == kON_LIST) {
/* line 201 "StmtDeps.puma" */
   spec = spec->ON_LIST.Next;
   goto yyRecursion;

  }
/* line 211 "StmtDeps.puma" */
  {
/* line 212 "StmtDeps.puma" */
   failure_protocol (MODULE, "CountOnLoops", spec);
  }
   return 0;

}

static void FusionTestPredicate
# if defined __STDC__ | defined __cplusplus
(register int n, Predicate * yyP3)
# else
(n, yyP3)
 register int n;
 Predicate * yyP3;
# endif
{
/* line 230 "StmtDeps.puma" */

PredVector PV;
int k;
char str[100];

/* line 236 "StmtDeps.puma" */
 {
  Predicate P;
  {
/* line 240 "StmtDeps.puma" */
 PMakeFalse (&P);

      for (k=1; k<=n; k++)

       { 

         PVMakeForLoopNest (n, k-1, k-1, &PV);

         

         PVAndComponent    (&PV, k, -MaxInt, -1);

         POrVector (&P, &PV);

       }

      strcpy (str, "");
      POut (str, &P);

      

   
  }
   * yyP3 = P;
   return;
 }

;
}

static void LoopIndepTestPredicate
# if defined __STDC__ | defined __cplusplus
(register int n, Predicate * yyP4)
# else
(n, yyP4)
 register int n;
 Predicate * yyP4;
# endif
{
/* line 276 "StmtDeps.puma" */
 {
  Predicate yyV1;
  {
/* line 278 "StmtDeps.puma" */
   FusionTestPredicate (1, & yyV1);
  }
   * yyP4 = yyV1;
   return;
 }

;
}

static void StmtDependence
# if defined __STDC__ | defined __cplusplus
(register tTree stmt1, register tTree stmt2, Predicate p, Predicate * yyP5)
# else
(stmt1, stmt2, p, yyP5)
 register tTree stmt1;
 register tTree stmt2;
 Predicate p;
 Predicate * yyP5;
# endif
{
/* line 289 "StmtDeps.puma" */

char str[100];

/* line 293 "StmtDeps.puma" */
  {
/* line 295 "StmtDeps.puma" */
 Nesting1 = 0;
     Nesting2 = 0;
     CommonLoops = 0;
     global_check_pred = p;          
#ifdef DEBUG
     strcpy (str, "");
     POut (str, &global_check_pred);
     printf ("Stmt Dependence : check for p = %s\n", str);
     printf ("stmt 1 : \n");
     FileUnparse (stdout, stmt1);
     printf ("stmt 2 : \n");
     FileUnparse (stdout, stmt2);
#endif
     PMakeFalse (&global_result_pred); 
     step = 1;                       
     global_stmt1 = stmt1;
     global_stmt2 = stmt2;
   
/* line 314 "StmtDeps.puma" */
   TraverseVars (global_stmt1);
/* line 316 "StmtDeps.puma" */

#ifdef DEBUG
     strcpy (str, "");
     POut (str, &global_result_pred);
     printf ("Stmt Dependence : result p = %s\n", str);
#endif
   
  }
   * yyP5 = global_result_pred;
   return;

;
}

static void TraverseVars
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 341 "StmtDeps.puma" */
  {
/* line 343 "StmtDeps.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 349 "StmtDeps.puma" */
   TraverseVars (t->ACF_LIST.Elem);
/* line 350 "StmtDeps.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 353 "StmtDeps.puma" */
   return;

  case kACF_DUMMY:
/* line 356 "StmtDeps.puma" */
   return;

  case kACF_IF:
/* line 359 "StmtDeps.puma" */
  {
/* line 361 "StmtDeps.puma" */
   TraverseVars (t->ACF_IF.IF_EXP);
/* line 362 "StmtDeps.puma" */
   TraverseVars (t->ACF_IF.THEN_PART);
/* line 363 "StmtDeps.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_BASIC:
/* line 366 "StmtDeps.puma" */
  {
/* line 368 "StmtDeps.puma" */
   t = t->ACF_BASIC.BASIC_STMT;
   goto yyRecursion;
  }

  case kACF_DO:
/* line 380 "StmtDeps.puma" */
  {
/* line 382 "StmtDeps.puma" */
   VisitVar (t->ACF_DO.DO_ID, WRITE_ACCESS);
/* line 384 "StmtDeps.puma" */
   TraverseVars (t->ACF_DO.DO_RANGE);
/* line 386 "StmtDeps.puma" */
   IncreaseNesting (t);
/* line 387 "StmtDeps.puma" */
   TraverseVars (t->ACF_DO.DO_BODY);
/* line 388 "StmtDeps.puma" */
   DecreaseNesting ();
  }
   return;

  case kACF_NEW:
/* line 391 "StmtDeps.puma" */
  {
/* line 393 "StmtDeps.puma" */
   IncreaseNesting (t);
/* line 394 "StmtDeps.puma" */
   TraverseVars (t->ACF_NEW.NEW_BODY);
/* line 395 "StmtDeps.puma" */
   DecreaseNesting ();
  }
   return;

  case kACF_HOME:
/* line 398 "StmtDeps.puma" */
  {
/* line 400 "StmtDeps.puma" */
   t = t->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  case kACF_ON:
/* line 403 "StmtDeps.puma" */
  {
/* line 405 "StmtDeps.puma" */
   TraverseVars (t->ACF_ON.ON_SPECS);
/* line 407 "StmtDeps.puma" */
   SpecsIncreaseNesting (t->ACF_ON.ON_SPECS);
/* line 408 "StmtDeps.puma" */
   TraverseVars (t->ACF_ON.ON_BODY);
/* line 409 "StmtDeps.puma" */
   SpecsDecreaseNesting (t->ACF_ON.ON_SPECS);
  }
   return;

  case kON_LIST:
/* line 412 "StmtDeps.puma" */
  {
/* line 414 "StmtDeps.puma" */
   TraverseVars (t->ON_LIST.Elem);
/* line 415 "StmtDeps.puma" */
   t = t->ON_LIST.Next;
   goto yyRecursion;
  }

  case kON_EMPTY:
/* line 418 "StmtDeps.puma" */
   return;

  case kON_SPEC:
/* line 421 "StmtDeps.puma" */
  {
/* line 423 "StmtDeps.puma" */
   t = t->ON_SPEC.ON_VAL;
   goto yyRecursion;
  }

  case kACF_NODE:
  case kACF_WHERE:
  case kACF_CASE:
  case kACF_WHILE:
  case kACF_REPEAT:
  case kACF_LOOP:
  case kACF_FORALL:
  case kACF_FLOW_GRAPH:
  case kACF_ENTRY:
  case kACF_RESIDENT:
  case kACF_REDUCTION:
  case kACF_TASK_REGION:
  case kACF_PARALLEL:
  case kACF_CRITICAL:
  case kACF_RM_READ:
  case kACF_RM_WRITE:
  case kACF_MOVE:
  case kACF_BARRIER:
  case kACF_UPDATE:
/* line 426 "StmtDeps.puma" */
  {
/* line 428 "StmtDeps.puma" */
   SetFullDependence ();
  }
   return;

  case kCALL_STMT:
/* line 437 "StmtDeps.puma" */
  {
/* line 439 "StmtDeps.puma" */
   if (! ((IsPureCall (t->CALL_STMT.CALL_ID)))) goto yyL14;
  {
/* line 441 "StmtDeps.puma" */
   t = t->CALL_STMT.CALL_PARAMS;
   goto yyRecursion;
  }
  }
yyL14:;

/* line 444 "StmtDeps.puma" */
  {
/* line 448 "StmtDeps.puma" */
   SetFullDependence ();
  }
   return;

  case kIO_STMT:
/* line 451 "StmtDeps.puma" */
  {
/* line 455 "StmtDeps.puma" */
   SetFullDependence ();
  }
   return;

  case kASSIGN_STMT:
/* line 458 "StmtDeps.puma" */
  {
/* line 460 "StmtDeps.puma" */
   VisitVar (t->ASSIGN_STMT.ASSIGN_VAR, WRITE_ACCESS);
/* line 461 "StmtDeps.puma" */
   TraverseIndexes (t->ASSIGN_STMT.ASSIGN_VAR);
/* line 462 "StmtDeps.puma" */
   t = t->ASSIGN_STMT.ASSIGN_EXP;
   goto yyRecursion;
  }

  case kREDUCE_STMT:
  if (t->REDUCE_STMT.RED_PARAMS->Kind == kBTP_LIST) {
  if (t->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 465 "StmtDeps.puma" */
  {
/* line 467 "StmtDeps.puma" */
   t = t->REDUCE_STMT.RED_PARAMS->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  break;
  }


  switch (t->Kind) {
  case kBT_STMT:
  case kATOMIC_STMT:
  case kPTR_ASSIGN_STMT:
  case kLABEL_ASSIGN_STMT:
  case kGOTO_STMT:
  case kASS_GOTO_STMT:
  case kCOMP_GOTO_STMT:
  case kCOMP_IF_STMT:
  case kRETURN_STMT:
  case kPAUSE_STMT:
  case kEXIT_STMT:
  case kCYCLE_STMT:
  case kSTOP_STMT:
  case kFORMAT_STMT:
  case kINHERIT_DSP_STMT:
  case kCREATE_DSP_STMT:
  case kFREE_DSP_STMT:
  case kALLOCATE_STMT:
  case kDEALLOCATE_STMT:
  case kACCESS_STMT:
  case kNULLIFY_STMT:
  case kREDUCE_STMT:
  case kMOVE_STMT:
  case kSCATTER_STMT:
  case kREALIGN_STMT:
  case kREDISTRIBUTE_STMT:
  case kREG_SHADOW_GET:
  case kREG_SHADOW_PUT:
  case kREG_SHADOW_SET:
  case kIND_SHADOW_CREATE:
  case kIND_SHADOW_FREE:
  case kIND_SHADOW_GET:
  case kIND_SHADOW_PUT:
  case kIND_SHADOW_SET:
  case kBROADCAST_STMT:
  case kREDUCTION_STMT:
  case kDIRTY_STMT:
/* line 470 "StmtDeps.puma" */
  {
/* line 472 "StmtDeps.puma" */
   SetFullDependence ();
  }
   return;

  case kSLICE_EXP:
/* line 481 "StmtDeps.puma" */
  {
/* line 483 "StmtDeps.puma" */
   TraverseVars (t->SLICE_EXP.FIRST);
/* line 484 "StmtDeps.puma" */
   TraverseVars (t->SLICE_EXP.STOP);
/* line 485 "StmtDeps.puma" */
   t = t->SLICE_EXP.INC;
   goto yyRecursion;
  }

  case kDUMMY_EXP:
/* line 488 "StmtDeps.puma" */
   return;

  case kOP_EXP:
/* line 491 "StmtDeps.puma" */
  {
/* line 493 "StmtDeps.puma" */
   TraverseVars (t->OP_EXP.OPND1);
/* line 494 "StmtDeps.puma" */
   t = t->OP_EXP.OPND2;
   goto yyRecursion;
  }

  case kOP1_EXP:
/* line 497 "StmtDeps.puma" */
  {
/* line 499 "StmtDeps.puma" */
   t = t->OP1_EXP.OPND;
   goto yyRecursion;
  }

  case kCONST_EXP:
/* line 502 "StmtDeps.puma" */
   return;

  case kBOUND_EXP:
/* line 505 "StmtDeps.puma" */
   return;

  case kRANK_EXP:
/* line 508 "StmtDeps.puma" */
   return;

  case kUSED_VAR:
/* line 511 "StmtDeps.puma" */
   return;

  case kLOOP_VAR:
/* line 516 "StmtDeps.puma" */
   return;

  case kVAR_EXP:
/* line 521 "StmtDeps.puma" */
  {
/* line 523 "StmtDeps.puma" */
   VisitVar (t->VAR_EXP.V, READ_ACCESS);
/* line 524 "StmtDeps.puma" */
   TraverseIndexes (t->VAR_EXP.V);
  }
   return;

  case kFUNC_CALL_EXP:
/* line 527 "StmtDeps.puma" */
  {
/* line 529 "StmtDeps.puma" */
   t = t->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;
  }

  case kADDR:
/* line 532 "StmtDeps.puma" */
  {
/* line 534 "StmtDeps.puma" */
   t = t->ADDR.E;
   goto yyRecursion;
  }

  case kBTP_LIST:
/* line 543 "StmtDeps.puma" */
  {
/* line 545 "StmtDeps.puma" */
   TraverseVars (t->BTP_LIST.Elem);
/* line 546 "StmtDeps.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  case kBTP_EMPTY:
/* line 549 "StmtDeps.puma" */
   return;

  case kVAR_PARAM:
  if (t->VAR_PARAM.V->Kind == kADDR) {
/* line 552 "StmtDeps.puma" */
  {
/* line 554 "StmtDeps.puma" */
   t = t->VAR_PARAM.V->ADDR.E;
   goto yyRecursion;
  }

  }
/* line 557 "StmtDeps.puma" */
  {
/* line 559 "StmtDeps.puma" */
   if (! ((IsOnlyReadParam (t)))) goto yyL35;
  {
/* line 561 "StmtDeps.puma" */
   VisitVar (t->VAR_PARAM.V, READ_ACCESS);
/* line 562 "StmtDeps.puma" */
   TraverseIndexes (t->VAR_PARAM.V);
  }
  }
   return;
yyL35:;

/* line 565 "StmtDeps.puma" */
  {
/* line 567 "StmtDeps.puma" */
   if (! ((t->VAR_PARAM.intent == IntentOut))) goto yyL36;
  {
/* line 569 "StmtDeps.puma" */
   VisitVar (t->VAR_PARAM.V, WRITE_ACCESS);
/* line 570 "StmtDeps.puma" */
   TraverseIndexes (t->VAR_PARAM.V);
  }
  }
   return;
yyL36:;

/* line 573 "StmtDeps.puma" */
  {
/* line 577 "StmtDeps.puma" */
   VisitVar (t->VAR_PARAM.V, INOUT_ACCESS);
/* line 578 "StmtDeps.puma" */
   TraverseIndexes (t->VAR_PARAM.V);
  }
   return;

  case kNO_PARAM:
/* line 581 "StmtDeps.puma" */
   return;

  case kFUNC_PARAM:
/* line 584 "StmtDeps.puma" */
   return;

  case kPROC_PARAM:
/* line 587 "StmtDeps.puma" */
   return;

  }

/* line 596 "StmtDeps.puma" */
  {
/* line 597 "StmtDeps.puma" */
   failure_protocol (MODULE, "TraverseVars", t);
  }
   return;

;
}

static void TraverseIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
 yyRecursion:
  if (var->Kind == kINDEXED_VAR) {
/* line 611 "StmtDeps.puma" */
  {
/* line 613 "StmtDeps.puma" */
   TraverseIndexes (var->INDEXED_VAR.IND_VAR);
/* line 614 "StmtDeps.puma" */
   var = var->INDEXED_VAR.IND_EXPS;
   goto yyRecursion;
  }

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 617 "StmtDeps.puma" */
  {
/* line 619 "StmtDeps.puma" */
   var = var->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }

  }
  if (var->Kind == kSUBSTRING_VAR) {
/* line 622 "StmtDeps.puma" */
  {
/* line 624 "StmtDeps.puma" */
   TraverseIndexes (var->SUBSTRING_VAR.IND_VAR);
/* line 625 "StmtDeps.puma" */
   TraverseVars (var->SUBSTRING_VAR.IND_EXP);
  }
   return;

  }
  if (var->Kind == kUSED_VAR) {
/* line 628 "StmtDeps.puma" */
   return;

  }
  if (var->Kind == kBTE_LIST) {
/* line 630 "StmtDeps.puma" */
  {
/* line 632 "StmtDeps.puma" */
   TraverseVars (var->BTE_LIST.Elem);
/* line 633 "StmtDeps.puma" */
   var = var->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (var->Kind == kBTE_EMPTY) {
/* line 636 "StmtDeps.puma" */
   return;

  }
;
}

static void SpecsIncreaseNesting
# if defined __STDC__ | defined __cplusplus
(register tTree speclist)
# else
(speclist)
 register tTree speclist;
# endif
{
 yyRecursion:
  if (speclist->Kind == kON_LIST) {
/* line 647 "StmtDeps.puma" */
  {
/* line 649 "StmtDeps.puma" */
   SpecsIncreaseNesting (speclist->ON_LIST.Elem);
/* line 650 "StmtDeps.puma" */
   speclist = speclist->ON_LIST.Next;
   goto yyRecursion;
  }

  }
;
}

static void SpecsDecreaseNesting
# if defined __STDC__ | defined __cplusplus
(register tTree speclist)
# else
(speclist)
 register tTree speclist;
# endif
{
 yyRecursion:
  if (speclist->Kind == kON_LIST) {
/* line 662 "StmtDeps.puma" */
  {
/* line 664 "StmtDeps.puma" */
   SpecsDecreaseNesting (speclist->ON_LIST.Elem);
/* line 665 "StmtDeps.puma" */
   speclist = speclist->ON_LIST.Next;
   goto yyRecursion;
  }

  }
;
}

static void IncreaseNesting
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
/* line 678 "StmtDeps.puma" */
  {
/* line 680 "StmtDeps.puma" */
   if (! ((step == 1))) goto yyL1;
  {
/* line 682 "StmtDeps.puma" */
 Nest1[Nesting1] = stmt;
    Nesting1 ++;
  
  }
  }
   return;
yyL1:;

/* line 687 "StmtDeps.puma" */
  {
/* line 688 "StmtDeps.puma" */
   if (! ((step == 2))) goto yyL2;
  {
/* line 690 "StmtDeps.puma" */
 Nest2[Nesting2] = stmt;
    Nesting2 ++;
  
  }
  }
   return;
yyL2:;

/* line 695 "StmtDeps.puma" */
  {
/* line 696 "StmtDeps.puma" */
   failure_protocol (MODULE, "IncreaseNesting", stmt);
  }
   return;

;
}

static void DecreaseNesting
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 701 "StmtDeps.puma" */
  {
/* line 702 "StmtDeps.puma" */
   if (! ((step == 1))) goto yyL1;
  {
/* line 703 "StmtDeps.puma" */
 Nesting1 --; 
  }
  }
   return;
yyL1:;

/* line 706 "StmtDeps.puma" */
  {
/* line 707 "StmtDeps.puma" */
   if (! ((step == 2))) goto yyL2;
  {
/* line 708 "StmtDeps.puma" */
 Nesting2 --; 
  }
  }
   return;
yyL2:;

;
}

static void VisitVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, register int kind)
# else
(var, kind)
 register tTree var;
 register int kind;
# endif
{
/* line 719 "StmtDeps.puma" */
  {
/* line 721 "StmtDeps.puma" */
 if (step == 1)

        {  step++;
           kind1 = kind;
           var1  = var;
           TraverseVars (global_stmt2);
        }

      else if (step == 2)

        {  

           step++;
           kind2 = kind;
           var2  = var;
           ProveDependences (var1, kind1, var2, kind2);
        }

      step--;

    
  }
   return;

;
}

static void ProveDependences
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register int kind1, register tTree var2, register int kind2)
# else
(var1, kind1, var2, kind2)
 register tTree var1;
 register int kind1;
 register tTree var2;
 register int kind2;
# endif
{
/* line 752 "StmtDeps.puma" */

char PString [100];

/* line 756 "StmtDeps.puma" */
  {
/* line 758 "StmtDeps.puma" */

#ifdef DEBUG
    printf ("Check dependences between ");
    FileUnparse (stdout, var1); 
    printf (" (kind = %s) and ", access_strings[kind1]);
    FileUnparse (stdout, var2); 
    printf (" (kind = %s)\n", access_strings[kind2]);
#endif
    
/* line 767 "StmtDeps.puma" */
   goto yyL1;
  }
yyL1:;

/* line 770 "StmtDeps.puma" */
  {
/* line 772 "StmtDeps.puma" */
   if (! ((kind1 == READ_ACCESS))) goto yyL2;
  {
/* line 773 "StmtDeps.puma" */
   if (! ((kind2 == READ_ACCESS))) goto yyL2;
  }
  }
   return;
yyL2:;

/* line 776 "StmtDeps.puma" */
  {
/* line 780 "StmtDeps.puma" */
   if (! ((TreeVarName (var1) != TreeVarName (var2)))) goto yyL3;
  }
   return;
yyL3:;

  if (var1->Kind == kLOOP_VAR) {
  if (var2->Kind == kLOOP_VAR) {
/* line 783 "StmtDeps.puma" */
   return;

  }
  }
/* line 790 "StmtDeps.puma" */
 {
  PredVector PV;
  int k;
  int dim;
  int new;
  {
/* line 803 "StmtDeps.puma" */
 dim = global_check_pred.p_dim;

      SetLoopStructures (var1, var2, &new);

      for (k=0; k<dim; k++)

        { 

          PV = global_check_pred.p_arr[k];

#ifdef DEBUG
          strcpy (PString, "check for : ");
          PVOut (PString, &PV);
          printf (PString);
          printf (" #loops(1) = %d, #loops(2) = %d, #common = %d\n",
                    Loops1, Loops2, CommonLoops);
#endif
 
          SetNewInfo (&PV, new);

          Dependences (var1, LoopNest1, Loops1, var2, LoopNest2, Loops2,
                       CommonLoops, 0, Parameters, NoParameters, &PV);
 
#ifdef DEBUG
          strcpy (PString, "result is : ");
          PVOut (PString, &PV);
          printf (PString);
          printf (" for %d common loops\n", CommonLoops);
#endif 

          POrVector (&global_result_pred, &PV);

        }
 
      if (!PIsFalse (&global_result_pred))
 
        {
          stmt_protocol ("dependences");
          tree_protocol ("Variable1 = ", var1);
          tree_protocol ("Variable2 = ", var2);
          strcpy (PString, "Dependences : ");
          POut (PString, &global_result_pred);
          print_protocol (PString);
#ifdef DEBUG
          printf ("%s\n", PString);
#endif
        }
 
    
  }
   return;
 }

;
}

static void SetFullDependence
# if defined __STDC__ | defined __cplusplus
(void)
# else
()
# endif
{
/* line 875 "StmtDeps.puma" */
  {
/* line 877 "StmtDeps.puma" */
   global_result_pred = global_check_pred;
  }
   return;

;
}

static void SetLoopStructures
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2, register int * yyP6)
# else
(var1, var2, yyP6)
 register tTree var1;
 register tTree var2;
 register int * yyP6;
# endif
{
/* line 888 "StmtDeps.puma" */
 {
  int NewLoops;
  {
/* line 892 "StmtDeps.puma" */
 int i, common;
     int CommonNest;

     CommonNest  = 0;
     CommonLoops = 0;
     NewLoops = 0;

     Loops1 = 0;
     Loops2 = 0;

     

     for (i=0, common=1; (i < Nesting1) && (i < Nesting2) && common; i++)

       if (common = (Nest1[i] == Nest2[i])) CommonNest++;

#ifdef DEBUG
    printf ("SetLoopStructures, Nest1 = %d, Nest2 = %d, Common = %d\n",
             Nesting1, Nesting2, CommonNest);
#endif

     for (i=0; i<CommonNest; i++)

       { if (IsDoLoop (Nest1[i]))

           { LoopNest1 [Loops1++] = Nest1[i];
             LoopNest2 [Loops2++] = Nest2[i];
             CommonLoops++;
           }

          else if (IsNewDefined (var1, Nest1[i]))

           NewLoops = CommonLoops;
       }

     for (i=CommonNest; i<Nesting1; i++)

       { if (IsDoLoop (Nest1[i]))
           LoopNest1 [Loops1++] = Nest1[i];
          else if (IsNewDefined (var1, Nest1[i]))
           NewLoops = -1;   
       }


     for (i=CommonNest; i<Nesting2; i++)

       { if (IsDoLoop (Nest2[i]))
           LoopNest2 [Loops2++] = Nest2[i];
          else if (IsNewDefined (var2, Nest2[i]))
           NewLoops = -1;   
       }

     

#ifdef DEBUG
    printf ("SetLoops ready, Loops1 = %d, Loops2 = %d, Common = %d, New = %d\n",
             Loops1, Loops2, CommonLoops, NewLoops);
#endif

   
  }
   * yyP6 = NewLoops;
   return;
 }

;
}

static rbool IsDoLoop
# if defined __STDC__ | defined __cplusplus
(register tTree stmt)
# else
(stmt)
 register tTree stmt;
# endif
{
  if (stmt->Kind == kACF_DO) {
/* line 962 "StmtDeps.puma" */
   return rtrue;

  }
  return rfalse;
}

static void SetNewInfo
# if defined __STDC__ | defined __cplusplus
(pPredVector p, register int new)
# else
(p, new)
 pPredVector p;
 register int new;
# endif
{
/* line 976 "StmtDeps.puma" */
  {
/* line 978 "StmtDeps.puma" */
   if (! ((new < 0))) goto yyL1;
  {
/* line 980 "StmtDeps.puma" */
   PVSetFalse (p);
  }
  }
   return;
yyL1:;

/* line 983 "StmtDeps.puma" */
 {
  int i;
  {
/* line 985 "StmtDeps.puma" */
   if (! ((new > 0))) goto yyL2;
  {
/* line 989 "StmtDeps.puma" */
/* line 989 "StmtDeps.puma" */
   i = 1;
   while (i <= new) {
/* line 989 "StmtDeps.puma" */
   PVAndComponent (p, i, 0, 0);
/* line 989 "StmtDeps.puma" */
   i ++;
   }
  }
  }
   return;
 }
yyL2:;

;
}

void BeginStmtDeps ARGS ((void))
{
}

void CloseStmtDeps ARGS ((void))
{
}
