# include "ShowDefs.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 23 "ShowDefs.puma" */


# include "Idents.h"
# include "StringM.h"

# include "StrUnparse.h"
# include "Unparse.h"
# include "Rank.h"

# define MODULE "ShowDefs"

FILE *SemFile;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyShowDefs.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* ShowDefs_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module ShowDefs, routine %s failed\n",
  yyFunction);
 ShowDefs_Exit ();
}

void ShowDeclarations ARGS ((tDefinitions d));
static void ShowArrayKind ARGS ((int kind));
static void ShowType ARGS ((tTree t));
static void ShowShadowSpec ARGS ((tDefinitions v));
static void ShowMapping ARGS ((tDefinitions mapping));
void ShowSpecifiedMapping ARGS ((tDefinitions mapping));
static void ShowRangeMapping ARGS ((tDefinitions mapping));
static void ShowRangeSelections ARGS ((tDefinitions ranges));
static void ShowRangeSelector ARGS ((tDefinitions range));
static void ShowDistribution ARGS ((tDefinitions dist));
static void ShowAlignment ARGS ((tDefinitions align));
static void ShowTop ARGS ((tDefinitions top_obj));
static void ShowDimList ARGS ((tDefinitions dim));
static void ShowUse ARGS ((tDefinitions t));

void ShowDeclarations
# if defined __STDC__ | defined __cplusplus
(register tDefinitions d)
# else
(d)
 register tDefinitions d;
# endif
{
/* line 46 "ShowDefs.puma" */

char string[256]; 
int varrank;

 yyRecursion:
/* line 51 "ShowDefs.puma" */
  {
/* line 53 "ShowDefs.puma" */
   if (! ((d == NoDefinitions))) goto yyL1;
  }
   return;
yyL1:;

  if (d->Kind == kSCOPE_LIST) {
/* line 56 "ShowDefs.puma" */
  {
/* line 58 "ShowDefs.puma" */
   ShowDeclarations (d->SCOPE_LIST.Table);
/* line 59 "ShowDefs.puma" */
   d = d->SCOPE_LIST.Hidden;
   goto yyRecursion;
  }

  }
  if (d->Kind == kSCOPE_EMPTY) {
/* line 62 "ShowDefs.puma" */
   return;

  }
  if (d->Kind == kENTRY_LIST) {
/* line 65 "ShowDefs.puma" */
  {
/* line 67 "ShowDefs.puma" */
   ShowDeclarations (d->ENTRY_LIST.Next);
/* line 68 "ShowDefs.puma" */
   d = d->ENTRY_LIST.Elem;
   goto yyRecursion;
  }

  }
  if (d->Kind == kENTRY_EMPTY) {
/* line 71 "ShowDefs.puma" */
   return;

  }
  if (Definitions_IsType (d, kObject)) {
/* line 74 "ShowDefs.puma" */
  {
/* line 76 "ShowDefs.puma" */
   if (! ((d->Object.Ident == DefaultId ()))) goto yyL6;
  {
/* line 77 "ShowDefs.puma" */
   fprintf (SemFile, "default", string);
  }
  }
   return;
yyL6:;

/* line 80 "ShowDefs.puma" */
  {
/* line 82 "ShowDefs.puma" */
   GetString (d->Object.Ident, string);
/* line 83 "ShowDefs.puma" */
   fprintf (SemFile, "%s", string);
/* line 85 "ShowDefs.puma" */
 if (d->Object.in != NoObject)
       { GetString (d->Object.in->Object.Ident, string);
         fprintf (SemFile, " (in %s)", string);
       }
      else
         fprintf (SemFile, "(-)");
   
/* line 93 "ShowDefs.puma" */
   fprintf (SemFile, " : ");
/* line 94 "ShowDefs.puma" */
   goto yyL7;
  }
yyL7:;

  }
  if (d->Kind == kProcObject) {
  if (d->ProcObject.decl->Kind == kPROC_DECL) {
/* line 97 "ShowDefs.puma" */
  {
/* line 99 "ShowDefs.puma" */
   if (! ((d->ProcObject.Kind == UserRoutine))) goto yyL8;
  {
/* line 100 "ShowDefs.puma" */
   fprintf (SemFile, "user/external subroutine\n");
  }
  }
   return;
yyL8:;

/* line 103 "ShowDefs.puma" */
  {
/* line 104 "ShowDefs.puma" */
   if (! ((d->ProcObject.Kind == DummyRoutine))) goto yyL9;
  {
/* line 105 "ShowDefs.puma" */
   fprintf (SemFile, "dummy subroutine\n");
  }
  }
   return;
yyL9:;

/* line 108 "ShowDefs.puma" */
  {
/* line 110 "ShowDefs.puma" */
   if (! ((d->ProcObject.Kind == ModuleRoutine))) goto yyL10;
  {
/* line 111 "ShowDefs.puma" */
   fprintf (SemFile, "module subroutine\n");
  }
  }
   return;
yyL10:;

  }
  if (d->ProcObject.decl->Kind == kINTRINSIC_DECL) {
/* line 114 "ShowDefs.puma" */
  {
/* line 116 "ShowDefs.puma" */
   fprintf (SemFile, "intrinsic subroutine\n");
  }
   return;

  }
/* line 119 "ShowDefs.puma" */
  {
/* line 121 "ShowDefs.puma" */
   fprintf (SemFile, "unknown proc object\n", string);
/* line 122 "ShowDefs.puma" */
   FileUnparse (SemFile, d->ProcObject.decl);
/* line 123 "ShowDefs.puma" */
   WriteTree (SemFile, d->ProcObject.decl);
  }
   return;

  }
  if (d->Kind == kFuncObject) {
  if (d->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 126 "ShowDefs.puma" */
  {
/* line 128 "ShowDefs.puma" */
   if (! ((d->FuncObject.Kind == UserRoutine))) goto yyL13;
  {
/* line 129 "ShowDefs.puma" */
   fprintf (SemFile, "user/external function\n");
  }
  }
   return;
yyL13:;

/* line 132 "ShowDefs.puma" */
  {
/* line 134 "ShowDefs.puma" */
   if (! ((d->FuncObject.Kind == DummyRoutine))) goto yyL14;
  {
/* line 135 "ShowDefs.puma" */
   fprintf (SemFile, "dummy function\n");
  }
  }
   return;
yyL14:;

/* line 138 "ShowDefs.puma" */
  {
/* line 140 "ShowDefs.puma" */
   if (! ((d->FuncObject.Kind == ModuleRoutine))) goto yyL15;
  {
/* line 141 "ShowDefs.puma" */
   fprintf (SemFile, "module function\n");
  }
  }
   return;
yyL15:;

  }
  if (d->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
/* line 144 "ShowDefs.puma" */
  {
/* line 146 "ShowDefs.puma" */
   fprintf (SemFile, "statement function\n");
  }
   return;

  }
  if (d->FuncObject.decl->Kind == kINTRINSIC_DECL) {
/* line 149 "ShowDefs.puma" */
  {
/* line 151 "ShowDefs.puma" */
   fprintf (SemFile, "Intrinsic Function ");
/* line 153 "ShowDefs.puma" */
 switch (d->FuncObject.decl->INTRINSIC_DECL.class) {
       case kELEMENTAL        : fprintf (SemFile, "(elemental,"); break;
       case kTRANSFORMATIONAL : fprintf (SemFile, "(transformational,"); break;
       case kPURE             : fprintf (SemFile, "(pure,"); break;
       case kINQUIRY          : fprintf (SemFile, "(inquiry,"); break;
       default                : fprintf (SemFile, "(-,"); break;
       } 

       switch (d->FuncObject.decl->INTRINSIC_DECL.kind) {
       case kNUMERIC        : fprintf (SemFile, "numeric),"); break;
       case kMATHEMATICAL   : fprintf (SemFile, "mathematical),"); break;
       case kCHARACTER      : fprintf (SemFile, "character),"); break;
       case kKIND           : fprintf (SemFile, "kind),"); break;
       case kFLOATING       : fprintf (SemFile, "floating),"); break;
       case kREDUCTION      : fprintf (SemFile, "reduction),"); break;
       case kLOCREDUCTION   : fprintf (SemFile, "loc reduction),"); break;
       default              : fprintf (SemFile, "-)"); break;
       } 
     
  }
   return;

  }
  }
  if (d->Kind == kExternalObject) {
  if (d->ExternalObject.decl->Kind == kEXTERNAL_DECL) {
/* line 174 "ShowDefs.puma" */
  {
/* line 176 "ShowDefs.puma" */
   if (! ((d->ExternalObject.Kind == UserRoutine))) goto yyL18;
  {
/* line 177 "ShowDefs.puma" */
   fprintf (SemFile, "EXTERNAL (subroutine or function)\n");
  }
  }
   return;
yyL18:;

/* line 180 "ShowDefs.puma" */
  {
/* line 182 "ShowDefs.puma" */
   if (! ((d->ExternalObject.Kind == DummyRoutine))) goto yyL19;
  {
/* line 183 "ShowDefs.puma" */
   fprintf (SemFile, "EXTERNAL dummy (subroutine or function)\n");
  }
  }
   return;
yyL19:;

  }
  }
  if (d->Kind == kBlockObject) {
/* line 186 "ShowDefs.puma" */
  {
/* line 188 "ShowDefs.puma" */
   fprintf (SemFile, "Block Data\n");
  }
   return;

  }
  if (d->Kind == kVarObject) {
  if (d->VarObject.Kind->Kind == kVarDummy) {
/* line 191 "ShowDefs.puma" */
  {
/* line 198 "ShowDefs.puma" */
 if (d->VarObject.Kind->VarDummy.function == NoTree)
         fprintf (SemFile, "dummy, type = ");
        else
         fprintf (SemFile, "dummy result, type = ");
     
/* line 203 "ShowDefs.puma" */
   ShowType (d->VarObject.decl);
/* line 204 "ShowDefs.puma" */
   ShowShadowSpec (d);
/* line 205 "ShowDefs.puma" */
   ShowArrayKind (d->VarObject.arr_kind);
/* line 206 "ShowDefs.puma" */
   varrank = VarRank (d);
/* line 207 "ShowDefs.puma" */
   fprintf (SemFile, ", rank = %d\n    ", varrank);
/* line 208 "ShowDefs.puma" */
   ShowUse (d);
/* line 209 "ShowDefs.puma" */
 if (d->VarObject.Kind->VarDummy.optional)
          fprintf (SemFile, " optional ", d->VarObject.Kind->VarDummy.optional);
         else
          fprintf (SemFile, " mandatory  ", d->VarObject.Kind->VarDummy.optional);
     
/* line 214 "ShowDefs.puma" */
   fprintf (SemFile, " intent = %d ", d->VarObject.Kind->VarDummy.Intent);
/* line 215 "ShowDefs.puma" */
   ShowMapping (d->VarObject.Dist);
/* line 216 "ShowDefs.puma" */
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->VarObject.Kind->Kind == kVarParameter) {
/* line 219 "ShowDefs.puma" */
  {
/* line 224 "ShowDefs.puma" */
   fprintf (SemFile, "parameter, val = ");
/* line 225 "ShowDefs.puma" */
   FileUnparse (SemFile, d->VarObject.Kind->VarParameter.Val);
/* line 226 "ShowDefs.puma" */
   fprintf (SemFile, " type = ");
/* line 227 "ShowDefs.puma" */
   ShowType (d->VarObject.decl);
/* line 228 "ShowDefs.puma" */
   ShowShadowSpec (d);
/* line 229 "ShowDefs.puma" */
   varrank = VarRank (d);
/* line 230 "ShowDefs.puma" */
   fprintf (SemFile, " rank = %d", varrank);
/* line 231 "ShowDefs.puma" */
   fprintf (SemFile, " uses = %d/%d/%d ", d->VarObject.uses->VarUse.ArrayUse, d->VarObject.uses->VarUse.ReadUse, d->VarObject.uses->VarUse.WriteUse);
/* line 232 "ShowDefs.puma" */
   ShowMapping (d->VarObject.Dist);
/* line 233 "ShowDefs.puma" */
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->VarObject.Kind->Kind == kVarLocal) {
/* line 236 "ShowDefs.puma" */
  {
/* line 241 "ShowDefs.puma" */
   fprintf (SemFile, "local variable, type = ");
/* line 242 "ShowDefs.puma" */
   ShowType (d->VarObject.decl);
/* line 243 "ShowDefs.puma" */
   ShowShadowSpec (d);
/* line 244 "ShowDefs.puma" */
   ShowArrayKind (d->VarObject.arr_kind);
/* line 245 "ShowDefs.puma" */
   varrank = VarRank (d);
/* line 246 "ShowDefs.puma" */
   fprintf (SemFile, ", rank = %d", varrank);
/* line 247 "ShowDefs.puma" */
   ShowUse (d);
/* line 248 "ShowDefs.puma" */
   ShowMapping (d->VarObject.Dist);
/* line 249 "ShowDefs.puma" */
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->VarObject.Kind->Kind == kVarCommon) {
/* line 252 "ShowDefs.puma" */
  {
/* line 256 "ShowDefs.puma" */
   fprintf (SemFile, "common variable (in ");
/* line 257 "ShowDefs.puma" */
   GetString (d->VarObject.Kind->VarCommon.Block, string);
/* line 258 "ShowDefs.puma" */
   fprintf (SemFile, "/%s/), type = ", string);
/* line 259 "ShowDefs.puma" */
   ShowType (d->VarObject.decl);
/* line 260 "ShowDefs.puma" */
   ShowShadowSpec (d);
/* line 261 "ShowDefs.puma" */
   varrank = VarRank (d);
/* line 262 "ShowDefs.puma" */
   fprintf (SemFile, " rank = %d", varrank);
/* line 263 "ShowDefs.puma" */
   ShowUse (d);
/* line 264 "ShowDefs.puma" */
   ShowMapping (d->VarObject.Dist);
/* line 265 "ShowDefs.puma" */
   fprintf (SemFile, "\n");
  }
   return;

  }
  }
  if (d->Kind == kTypeObject) {
/* line 268 "ShowDefs.puma" */
  {
/* line 270 "ShowDefs.puma" */
   GetString (d->TypeObject.Ident, string);
/* line 271 "ShowDefs.puma" */
   fprintf (SemFile, "Type %s (derived)\n", string);
  }
   return;

  }
  if (d->Kind == kTemplateObject) {
/* line 274 "ShowDefs.puma" */
  {
/* line 276 "ShowDefs.puma" */
   fprintf (SemFile, "template, dim = (");
/* line 277 "ShowDefs.puma" */
   ShowType (d->TemplateObject.decl);
/* line 278 "ShowDefs.puma" */
   fprintf (SemFile, ") ");
/* line 279 "ShowDefs.puma" */
   ShowMapping (d->TemplateObject.Dist);
/* line 280 "ShowDefs.puma" */
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->Kind == kTopologyObject) {
/* line 283 "ShowDefs.puma" */
  {
/* line 285 "ShowDefs.puma" */
   if (! ((d->TopologyObject.Ident == DefaultId ()))) goto yyL27;
  {
/* line 286 "ShowDefs.puma" */
   fprintf (SemFile, "default topology (rank=%d)", d->TopologyObject.rank);
  }
  }
   return;
yyL27:;

/* line 289 "ShowDefs.puma" */
  {
/* line 291 "ShowDefs.puma" */
   fprintf (SemFile, "processors, dim = (");
/* line 292 "ShowDefs.puma" */
   ShowType (d->TopologyObject.decl);
/* line 293 "ShowDefs.puma" */
   fprintf (SemFile, ")");
/* line 294 "ShowDefs.puma" */
 if (d->TopologyObject.target != NoTree)
         { fprintf (SemFile, " mapped to ");
           FileUnparse (SemFile, d->TopologyObject.target);
         }
     
/* line 299 "ShowDefs.puma" */
   fprintf (SemFile, "\n");
  }
   return;

  }
  if (d->Kind == kNameListObject) {
/* line 302 "ShowDefs.puma" */
  {
/* line 304 "ShowDefs.puma" */
   fprintf (SemFile, "namelist\n");
  }
   return;

  }
  if (d->Kind == kGenericObject) {
/* line 307 "ShowDefs.puma" */
  {
/* line 309 "ShowDefs.puma" */
   fprintf (SemFile, "generic interface");
  }
   return;

  }
  if (Definitions_IsType (d, kObject)) {
/* line 312 "ShowDefs.puma" */
  {
/* line 314 "ShowDefs.puma" */
   GetString (d->Object.Ident, string);
/* line 315 "ShowDefs.puma" */
   fprintf (SemFile, "something\n");
  }
   return;

  }
;
}

static void ShowArrayKind
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
/* line 326 "ShowDefs.puma" */
  {
/* line 327 "ShowDefs.puma" */
 switch (kind) {

       case arr_default        : fprintf (SemFile, ", default"); break;
       case arr_allocatable    : fprintf (SemFile, ", allocatable"); break;
       case arr_pointer        : fprintf (SemFile, ", pointer"); break;
       case arr_fixed_size     : fprintf (SemFile, ", fixed size"); break;
       case arr_automatic      : fprintf (SemFile, ", automatic"); break;
       case arr_explicit_shape : fprintf (SemFile, ", explicit shape"); break;
       case arr_assumed_shape  : fprintf (SemFile, ", assummed shape"); break;
       case arr_assumed_size   : fprintf (SemFile, ", assummed size"); break;

       default :  fprintf (SemFile, ", illegal array kind"); 

      } 
   
  }
   return;

;
}

static void ShowType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kVAR_DECL) {
/* line 352 "ShowDefs.puma" */
  {
/* line 352 "ShowDefs.puma" */
   t = t->VAR_DECL.VAL;
   goto yyRecursion;
  }

  }
  if (t->Kind == kVAR_PARAM_DECL) {
/* line 353 "ShowDefs.puma" */
  {
/* line 353 "ShowDefs.puma" */
   t = t->VAR_PARAM_DECL.VAL;
   goto yyRecursion;
  }

  }
  if (t->Kind == kTEMPLATE_DECL) {
/* line 354 "ShowDefs.puma" */
  {
/* line 354 "ShowDefs.puma" */
   t = t->TEMPLATE_DECL.DIMENSIONS;
   goto yyRecursion;
  }

  }
  if (t->Kind == kPROCESSORS_DECL) {
/* line 355 "ShowDefs.puma" */
  {
/* line 355 "ShowDefs.puma" */
   t = t->PROCESSORS_DECL.DIMENSIONS;
   goto yyRecursion;
  }

  }
/* line 357 "ShowDefs.puma" */
  {
/* line 358 "ShowDefs.puma" */
   FileUnparse (SemFile, t);
  }
   return;

;
}

static void ShowShadowSpec
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
/* line 369 "ShowDefs.puma" */
  {
/* line 371 "ShowDefs.puma" */
   if (! ((v->VarObject.shadow == NoTree))) goto yyL1;
  }
   return;
yyL1:;

/* line 374 "ShowDefs.puma" */
  {
/* line 376 "ShowDefs.puma" */
   fprintf (SemFile, " shadow = ");
/* line 377 "ShowDefs.puma" */
   FileUnparse (SemFile, v->VarObject.shadow);
  }
   return;

  }
;
}

static void ShowMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions mapping)
# else
(mapping)
 register tDefinitions mapping;
# endif
{
/* line 388 "ShowDefs.puma" */
  {
/* line 390 "ShowDefs.puma" */
   ShowSpecifiedMapping (mapping->Mapping.spec);
/* line 391 "ShowDefs.puma" */
   fprintf (SemFile, ", range = ");
/* line 392 "ShowDefs.puma" */
   ShowRangeMapping (mapping->Mapping.range);
/* line 394 "ShowDefs.puma" */
 if (mapping->Mapping.shared) fprintf (SemFile, ", shared"); 
     if (mapping->Mapping.dynamic) fprintf (SemFile, ", dynamic"); 
   
  }
   return;

;
}

void ShowSpecifiedMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions mapping)
# else
(mapping)
 register tDefinitions mapping;
# endif
{
  if (mapping->Kind == kMapDefault) {
/* line 407 "ShowDefs.puma" */
  {
/* line 409 "ShowDefs.puma" */
   fprintf (SemFile, "map: default");
  }
   return;

  }
  if (mapping->Kind == kMapReplicated) {
/* line 412 "ShowDefs.puma" */
  {
/* line 414 "ShowDefs.puma" */
   fprintf (SemFile, "map: replicated");
  }
   return;

  }
  if (mapping->Kind == kMapDecl) {
/* line 417 "ShowDefs.puma" */
  {
/* line 419 "ShowDefs.puma" */
   fprintf (SemFile, "map: not evaluated");
  }
   return;

  }
  if (mapping->Kind == kMapDist) {
/* line 422 "ShowDefs.puma" */
  {
/* line 424 "ShowDefs.puma" */
   fprintf (SemFile, "map: dist ");
/* line 425 "ShowDefs.puma" */
   ShowDistribution (mapping->MapDist.Distribution);
  }
   return;

  }
  if (mapping->Kind == kMapAlign) {
/* line 428 "ShowDefs.puma" */
  {
/* line 430 "ShowDefs.puma" */
   fprintf (SemFile, "map: align ");
/* line 431 "ShowDefs.puma" */
   ShowAlignment (mapping->MapAlign.Alignment);
  }
   return;

  }
  if (mapping->Kind == kMapInherited) {
/* line 434 "ShowDefs.puma" */
  {
/* line 436 "ShowDefs.puma" */
   fprintf (SemFile, "map: inherited");
  }
   return;

  }
;
}

static void ShowRangeMapping
# if defined __STDC__ | defined __cplusplus
(register tDefinitions mapping)
# else
(mapping)
 register tDefinitions mapping;
# endif
{
  if (mapping->Kind == kRangeDefault) {
/* line 447 "ShowDefs.puma" */
  {
/* line 449 "ShowDefs.puma" */
   fprintf (SemFile, "default range");
  }
   return;

  }
  if (mapping->Kind == kRangeNone) {
/* line 452 "ShowDefs.puma" */
  {
/* line 454 "ShowDefs.puma" */
   fprintf (SemFile, "no range");
  }
   return;

  }
  if (mapping->Kind == kRangeDecl) {
/* line 457 "ShowDefs.puma" */
  {
/* line 459 "ShowDefs.puma" */
   fprintf (SemFile, "range not evaluated");
  }
   return;

  }
  if (mapping->Kind == kRangeSelection) {
/* line 462 "ShowDefs.puma" */
  {
/* line 464 "ShowDefs.puma" */
   ShowRangeSelections (mapping->RangeSelection.Selections);
  }
   return;

  }
;
}

static void ShowRangeSelections
# if defined __STDC__ | defined __cplusplus
(register tDefinitions ranges)
# else
(ranges)
 register tDefinitions ranges;
# endif
{
 yyRecursion:
  if (ranges->Kind == kRangeList) {
/* line 469 "ShowDefs.puma" */
  {
/* line 471 "ShowDefs.puma" */
   ShowRangeSelector (ranges->RangeList.Elem);
/* line 472 "ShowDefs.puma" */
   ranges = ranges->RangeList.Next;
   goto yyRecursion;
  }

  }
  if (ranges->Kind == kRangeEmpty) {
/* line 475 "ShowDefs.puma" */
   return;

  }
;
}

static void ShowRangeSelector
# if defined __STDC__ | defined __cplusplus
(register tDefinitions range)
# else
(range)
 register tDefinitions range;
# endif
{
  if (range->Kind == kRangeDist) {
/* line 486 "ShowDefs.puma" */
  {
/* line 488 "ShowDefs.puma" */
   fprintf (SemFile, ", range al = <");
/* line 489 "ShowDefs.puma" */
   ShowDimList (range->RangeDist.ArrayList);
/* line 490 "ShowDefs.puma" */
   fprintf (SemFile, ">)");
  }
   return;

  }
  if (range->Kind == kRangeAlign) {
/* line 493 "ShowDefs.puma" */
  {
/* line 495 "ShowDefs.puma" */
   ShowAlignment (range->RangeAlign.Alignment);
  }
   return;

  }
  if (range->Kind == kRangeReplicated) {
/* line 498 "ShowDefs.puma" */
  {
/* line 500 "ShowDefs.puma" */
   fprintf (SemFile, "replicated");
  }
   return;

  }
;
}

static void ShowDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dist)
# else
(dist)
 register tDefinitions dist;
# endif
{
/* line 505 "ShowDefs.puma" */
  {
/* line 507 "ShowDefs.puma" */
   fprintf (SemFile, "onto ");
/* line 508 "ShowDefs.puma" */
   ShowTop (dist->Distribution.top_obj);
/* line 509 "ShowDefs.puma" */
   fprintf (SemFile, ", al = <");
/* line 510 "ShowDefs.puma" */
   ShowDimList (dist->Distribution.ArrayList);
/* line 511 "ShowDefs.puma" */
   fprintf (SemFile, ">)");
  }
   return;

;
}

static void ShowAlignment
# if defined __STDC__ | defined __cplusplus
(register tDefinitions align)
# else
(align)
 register tDefinitions align;
# endif
{
/* line 516 "ShowDefs.puma" */

char string[256];

/* line 520 "ShowDefs.puma" */
  {
/* line 522 "ShowDefs.puma" */
   GetString (align->Alignment.template_obj->Object.Ident, string);
/* line 523 "ShowDefs.puma" */
   fprintf (SemFile, "aligned to %s, al = <", string);
/* line 524 "ShowDefs.puma" */
   ShowDimList (align->Alignment.SourceList);
/* line 525 "ShowDefs.puma" */
   fprintf (SemFile, ">, tl = <");
/* line 526 "ShowDefs.puma" */
   ShowDimList (align->Alignment.TargetList);
/* line 527 "ShowDefs.puma" */
   fprintf (SemFile, ">)");
  }
   return;

;
}

static void ShowTop
# if defined __STDC__ | defined __cplusplus
(register tDefinitions top_obj)
# else
(top_obj)
 register tDefinitions top_obj;
# endif
{
/* line 532 "ShowDefs.puma" */

char string[256];

/* line 536 "ShowDefs.puma" */
  {
/* line 538 "ShowDefs.puma" */
   if (! ((top_obj == NoObject))) goto yyL1;
  {
/* line 539 "ShowDefs.puma" */
   fprintf (SemFile, "*");
  }
  }
   return;
yyL1:;

  if (top_obj->Kind == kTopologyObject) {
/* line 542 "ShowDefs.puma" */
  {
/* line 544 "ShowDefs.puma" */
   if (! ((top_obj->TopologyObject.Ident == DefaultId ()))) goto yyL2;
  {
/* line 545 "ShowDefs.puma" */
   fprintf (SemFile, "#%d", top_obj->TopologyObject.rank);
  }
  }
   return;
yyL2:;

/* line 548 "ShowDefs.puma" */
  {
/* line 550 "ShowDefs.puma" */
   GetString (top_obj->TopologyObject.Ident, string);
/* line 551 "ShowDefs.puma" */
   fprintf (SemFile, "%s(%d)", string, top_obj->TopologyObject.rank);
  }
   return;

  }
;
}

static void ShowDimList
# if defined __STDC__ | defined __cplusplus
(register tDefinitions dim)
# else
(dim)
 register tDefinitions dim;
# endif
{
 yyRecursion:

  switch (dim->Kind) {
  case kDIM_EMPTY:
/* line 562 "ShowDefs.puma" */
   return;

  case kDIM_LIST:
  if (dim->DIM_LIST.Next->Kind == kDIM_EMPTY) {
/* line 565 "ShowDefs.puma" */
  {
/* line 566 "ShowDefs.puma" */
   dim = dim->DIM_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 569 "ShowDefs.puma" */
  {
/* line 570 "ShowDefs.puma" */
   ShowDimList (dim->DIM_LIST.Elem);
/* line 571 "ShowDefs.puma" */
   fprintf (SemFile, ",");
/* line 572 "ShowDefs.puma" */
   dim = dim->DIM_LIST.Next;
   goto yyRecursion;
  }

  case kSerialDimension:
/* line 575 "ShowDefs.puma" */
  {
/* line 576 "ShowDefs.puma" */
   fprintf (SemFile, "*");
  }
   return;

  case kReplicatedDimension:
/* line 579 "ShowDefs.puma" */
  {
/* line 580 "ShowDefs.puma" */
   fprintf (SemFile, "+");
  }
   return;

  case kEmbeddedDimension:
/* line 583 "ShowDefs.puma" */
  {
/* line 585 "ShowDefs.puma" */
 char str[20];
     StrUnparse (str, 20, dim->EmbeddedDimension.val);
     fprintf (SemFile,"%d->%s", dim->EmbeddedDimension.dimension, str);
   
  }
   return;

  case kAlignedDimension:
/* line 591 "ShowDefs.puma" */
  {
/* line 593 "ShowDefs.puma" */
 char add_str[20], mult_str[20];

     StrUnparse (add_str, 20, dim->AlignedDimension.add);
     StrUnparse (mult_str, 20, dim->AlignedDimension.mult);

     fprintf (SemFile,"%d->%d(%s*I+%s)", dim->AlignedDimension.dimension, dim->AlignedDimension.template_dim, 
                                         mult_str, add_str);
   
  }
   return;

  case kDistributedDimension:
/* line 603 "ShowDefs.puma" */
  {
/* line 605 "ShowDefs.puma" */
 char val[20];

     switch (dim->DistributedDimension.kind) {

      case kBLOCK_DIM      : StrUnparse (val, 20, dim->DistributedDimension.size);
                             fprintf (SemFile,"block(%s)", val); break;
      case kCYCLIC_DIM     : StrUnparse (val, 20, dim->DistributedDimension.size);
                             fprintf (SemFile,"cyclic(%s)", val); break;
      case kGEN_BLOCK_DIM  : fprintf (SemFile,"gen_block", dim->DistributedDimension.size); break;

      default              : fprintf (SemFile,":-");

     } 

   
  }
   return;

  }

;
}

static void ShowUse
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t)
# else
(t)
 register tDefinitions t;
# endif
{
/* line 630 "ShowDefs.puma" */
  {
/* line 632 "ShowDefs.puma" */
   fprintf (SemFile, " uses = %d/%d/%d ", t->VarObject.uses->VarUse.ArrayUse, t->VarObject.uses->VarUse.ReadUse, t->VarObject.uses->VarUse.WriteUse);
  }
   return;

;
}

void BeginShowDefs ARGS ((void))
{
}

void CloseShowDefs ARGS ((void))
{
}
