# include "Shapes.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 83 "Shapes.puma" */


# include "Tree.h"
# include "Idents.h"
# include "StringM.h"

# include "protocol.h"

# include "Definitions.h"
# include "Transform.h"     /* VarParamToExp */

# include "Expressions.h"   /* MakeConstant, ResolveExpression */

# include "Unparse.h"
# include "Rank.h" 
# include "Objects.h"       /* GetObjDimension   */
# include "Intrinsics.h"    /* GetIntrinsicClass */

# define MODULE "Shapes"



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yyShapes.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Shapes_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Shapes, routine %s failed\n",
  yyFunction);
 Shapes_Exit ();
}

void GetFormalShape ARGS ((tTree t, shape s));
static void GetFormalShapeObj ARGS ((tDefinitions t, tTree reach_info, shape s));
static void GetFormalShapeList ARGS ((tTree t, shape s, int n));
void PrintShape ARGS ((shape s));
tTree MakeShapedVar ARGS ((tTree var, shape shp));
tTree MakeFullShape ARGS ((tTree t));
static void MakeFullIndexShape ARGS ((tTree t, shape s, int n));
static tTree GetShapeExp ARGS ((shape s, int dim, int kind));
static tTree TranslateVar ARGS ((tTree var));
rbool IsWholeVar ARGS ((tTree t));
static rbool FullIndexSlices ARGS ((tTree t, shape s, int n));
static rbool FullIndexSlice ARGS ((tTree t, shape s, int n));
static rbool IsBoundExp ARGS ((tTree actual, tTree formal, tTree var, int dim, int kind));
tTree NormalizeShape ARGS ((tTree t));
rbool IsContiguousSection ARGS ((tTree t));
static rbool IsContiguousShape ARGS ((tTree t, shape s, int n));
static rbool SingleIndexes ARGS ((tTree indexes));
void GetActualShape ARGS ((tTree t, shape s));
static void GetArrayExpressionRange ARGS ((tTree elem, tTree * yyP3, tTree * yyP2, tTree * yyP1));
static void UpdateActualShape ARGS ((tTree indexes, shape s, int n));
static void NormalActualSlice ARGS ((tTree exp, tTree * yyP6, tTree * yyP5, tTree * yyP4));
static rbool IsMultiply ARGS ((tTree exp, int c, int * yyP7));
static shape MakeBestShape ARGS ((shape s1, shape s2));
static rbool IsItAStride1 ARGS ((tTree t));

void GetFormalShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
 yyRecursion:
  if (t->Kind == kINDEXED_VAR) {
/* line 115 "Shapes.puma" */
  {
/* line 117 "Shapes.puma" */
   t = t->INDEXED_VAR.IND_VAR;
   goto yyRecursion;
  }

  }
  if (t->Kind == kSELECTED_VAR) {
/* line 120 "Shapes.puma" */
  {
/* line 122 "Shapes.puma" */
   GetFormalShapeObj (t->SELECTED_VAR.SELECTOR->REC_COMP.Object, NoTree, s);
/* line 124 "Shapes.puma" */
 s->var = t; 
  }
   return;

  }
  if (t->Kind == kUSED_VAR) {
/* line 127 "Shapes.puma" */
  {
/* line 129 "Shapes.puma" */
   GetFormalShape (t->USED_VAR.VARNAME, s);
/* line 131 "Shapes.puma" */
 s->var = t; 
  }
   return;

  }
  if (t->Kind == kVAR_OBJ) {
/* line 134 "Shapes.puma" */
  {
/* line 136 "Shapes.puma" */
   GetFormalShapeObj (t->VAR_OBJ.Object, t->VAR_OBJ.Reaching, s);
/* line 138 "Shapes.puma" */
 s->var = NoTree; 
  }
   return;

  }
/* line 141 "Shapes.puma" */
  {
/* line 143 "Shapes.puma" */
   failure_protocol (MODULE, "GetFormalShape", t);
  }
   return;

;
}

static void GetFormalShapeObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions t, register tTree reach_info, shape s)
# else
(t, reach_info, s)
 register tDefinitions t;
 register tTree reach_info;
 shape s;
# endif
{
/* line 156 "Shapes.puma" */
  {
/* line 158 "Shapes.puma" */
   if (! ((VarRank (t) == 0))) goto yyL1;
  {
/* line 160 "Shapes.puma" */
 s->rank = 0; 
  }
  }
   return;
yyL1:;

/* line 163 "Shapes.puma" */
  {
/* line 165 "Shapes.puma" */
   if (! ((reach_info == NoTree))) goto yyL2;
  {
/* line 167 "Shapes.puma" */
   GetFormalShapeList (GetObjDimension (t), s, 1);
  }
  }
   return;
yyL2:;

  if (reach_info->Kind == kREACHING_INFO) {
/* line 170 "Shapes.puma" */
  {
/* line 172 "Shapes.puma" */
   if (! ((reach_info->REACHING_INFO.var_allocate == NoTree))) goto yyL3;
  {
/* line 174 "Shapes.puma" */
   GetFormalShapeList (GetObjDimension (t), s, 1);
  }
  }
   return;
yyL3:;

/* line 177 "Shapes.puma" */
  {
/* line 179 "Shapes.puma" */
   GetFormalShapeList (reach_info->REACHING_INFO.var_allocate, s, 1);
  }
   return;

  }
/* line 182 "Shapes.puma" */
  {
/* line 184 "Shapes.puma" */
   failure_protocol (MODULE, "GetFormalShapeObj", reach_info);
  }
   return;

;
}

static void GetFormalShapeList
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kBTE_LIST:
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 189 "Shapes.puma" */
  {
/* line 191 "Shapes.puma" */
   t = t->BTE_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 199 "Shapes.puma" */
  {
/* line 201 "Shapes.puma" */
   GetFormalShapeList (t->BTE_LIST.Elem, s, n);
/* line 202 "Shapes.puma" */
   t = t->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  case kSHAPE_LIST:
  if (t->SHAPE_LIST.Next->Kind == kSHAPE_EMPTY) {
/* line 194 "Shapes.puma" */
  {
/* line 196 "Shapes.puma" */
   t = t->SHAPE_LIST.Elem;
   goto yyRecursion;
  }

  }
/* line 205 "Shapes.puma" */
  {
/* line 207 "Shapes.puma" */
   GetFormalShapeList (t->SHAPE_LIST.Elem, s, n);
/* line 208 "Shapes.puma" */
   t = t->SHAPE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  case kEXPLICIT_SHAPE:
/* line 211 "Shapes.puma" */
  {
/* line 213 "Shapes.puma" */
 s->rank = n;
      s->bounds[n-1][0] = t->EXPLICIT_SHAPE.LOWER;
      s->bounds[n-1][1] = t->EXPLICIT_SHAPE.UPPER;
      s->bounds[n-1][2] = NoTree;
    
  }
   return;

  case kASSUMED_SIZE:
/* line 220 "Shapes.puma" */
  {
/* line 222 "Shapes.puma" */
 s->rank = n;
      s->bounds[n-1][0] = t->ASSUMED_SIZE.LOWER;        
      s->bounds[n-1][1] = (tTree) 1;  
      s->bounds[n-1][2] = NoTree;     
    
  }
   return;

  case kASSUMED_SHAPE:
/* line 229 "Shapes.puma" */
  {
/* line 231 "Shapes.puma" */
 s->rank = n;
      s->bounds[n-1][0] = t->ASSUMED_SHAPE.LOWER;        
      s->bounds[n-1][1] = NoTree;     
      s->bounds[n-1][2] = NoTree;     
    
  }
   return;

  case kSHAPE_SPEC:
  case kDEFERRED_SHAPE:
/* line 238 "Shapes.puma" */
  {
/* line 240 "Shapes.puma" */
 s->rank = n;
      s->bounds[n-1][0] = NoTree;    
      s->bounds[n-1][1] = NoTree;    
      s->bounds[n-1][2] = NoTree;    
    
  }
   return;

  case kSLICE_EXP:
/* line 247 "Shapes.puma" */
  {
/* line 249 "Shapes.puma" */
 s->rank = n;
      s->bounds[n-1][0] = t->SLICE_EXP.FIRST;
      s->bounds[n-1][1] = t->SLICE_EXP.STOP;
      s->bounds[n-1][2] = NoTree;
    
  }
   return;

  }

/* line 256 "Shapes.puma" */
  {
/* line 257 "Shapes.puma" */
   failure_protocol ("Shapes", "GetFormalShapeList", t);
  }
   return;

;
}

void PrintShape
# if defined __STDC__ | defined __cplusplus
(shape s)
# else
(s)
 shape s;
# endif
{
/* line 268 "Shapes.puma" */
  {
/* line 270 "Shapes.puma" */
 int i;

    printf ("Shape is : \n");

    for (i=0;i<s->rank;i++)
     { FileUnparse (stdout, s->bounds[i][0]);
       printf (" - ");
       FileUnparse (stdout, s->bounds[i][1]);
       if (s->bounds[i][2] != NoTree)
         { printf (" step ");
           FileUnparse (stdout, s->bounds[i][2]);
         }
       printf ("\n");
     }
  
  }
   return;

;
}

tTree MakeShapedVar
# if defined __STDC__ | defined __cplusplus
(register tTree var, shape shp)
# else
(var, shp)
 register tTree var;
 shape shp;
# endif
{
/* line 297 "Shapes.puma" */

int i;
tTree ind, slice;

/* line 302 "Shapes.puma" */
  {
/* line 304 "Shapes.puma" */
 ind = mBTE_EMPTY ();
     for (i=shp->rank; i>0; i--)
       { slice = mSLICE_EXP (GetShapeExp (shp, i, 0), 
                             GetShapeExp (shp, i, 1),
                             mDUMMY_EXP());
         ind = mBTE_LIST (slice, ind);
       }
   
  }
   return mINDEXED_VAR (var, ind);

}

tTree MakeFullShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 333 "Shapes.puma" */

struct_shape shp;

  if (t->Kind == kLOOP_VAR) {
/* line 337 "Shapes.puma" */
   return t;

  }
  if (t->Kind == kUSED_VAR) {
/* line 342 "Shapes.puma" */
  {
/* line 343 "Shapes.puma" */
   if (! ((VarRank (t->USED_VAR.VARNAME->VAR_OBJ.Object) == 0))) goto yyL2;
  }
   return t;
yyL2:;

/* line 347 "Shapes.puma" */
  {
/* line 349 "Shapes.puma" */
   GetFormalShape (t, & shp);
  }
   return MakeShapedVar (t, & shp);

  }
  if (t->Kind == kSELECTED_VAR) {
/* line 353 "Shapes.puma" */
  {
/* line 354 "Shapes.puma" */
   if (! ((VarRank (t->SELECTED_VAR.SELECTOR->REC_COMP.Object) == 0))) goto yyL4;
  }
   return t;
yyL4:;

/* line 358 "Shapes.puma" */
  {
/* line 359 "Shapes.puma" */
   GetFormalShape (t, & shp);
  }
   return MakeShapedVar (t, & shp);

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 363 "Shapes.puma" */
  {
/* line 365 "Shapes.puma" */
   GetFormalShape (t, & shp);
/* line 366 "Shapes.puma" */
   MakeFullIndexShape (t->INDEXED_VAR.IND_EXPS, & shp, 1);
  }
   return t;

  }
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 370 "Shapes.puma" */
  {
/* line 372 "Shapes.puma" */
   GetFormalShape (t, & shp);
/* line 373 "Shapes.puma" */
   MakeFullIndexShape (t->INDEXED_VAR.IND_EXPS, & shp, 1);
  }
   return t;

  }
  }
/* line 377 "Shapes.puma" */
  {
/* line 378 "Shapes.puma" */
   failure_protocol (MODULE, "MakeFullShape", t);
  }
   return t;

}

static void MakeFullIndexShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
 yyRecursion:
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 390 "Shapes.puma" */
  {
/* line 392 "Shapes.puma" */
 if (t->BTE_LIST.Elem->SLICE_EXP.FIRST->Kind == kDUMMY_EXP)
        t->BTE_LIST.Elem->SLICE_EXP.FIRST = GetShapeExp (s, n, 0);
     if (t->BTE_LIST.Elem->SLICE_EXP.STOP->Kind == kDUMMY_EXP)
        t->BTE_LIST.Elem->SLICE_EXP.STOP  = GetShapeExp (s, n, 1);
   
/* line 397 "Shapes.puma" */
   t = t->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
/* line 400 "Shapes.puma" */
  {
/* line 402 "Shapes.puma" */
   t = t->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTE_EMPTY) {
/* line 405 "Shapes.puma" */
   return;

  }
;
}

static tTree GetShapeExp
# if defined __STDC__ | defined __cplusplus
(shape s, register int dim, register int kind)
# else
(s, dim, kind)
 shape s;
 register int dim;
 register int kind;
# endif
{
/* line 416 "Shapes.puma" */
 {
  tTree exp;
  {
/* line 420 "Shapes.puma" */
 exp = s->bounds[dim-1][kind];

     if (exp == (tTree) 1 )  

       { exp = mBOUND_EXP (TranslateVar (s->var), dim, kind, 0); 
                
         error_protocol ("illegal array access on assumed-size array");
       }

      else if (exp == NoTree)
       exp = mBOUND_EXP (TranslateVar (s->var), dim, kind, 0);
   
  }
   return exp;
 }

}

static tTree TranslateVar
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 438 "Shapes.puma" */
   return var;

}

rbool IsWholeVar
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 479 "Shapes.puma" */

struct_shape shp;
rbool is;

  if (t->Kind == kUSED_VAR) {
/* line 484 "Shapes.puma" */
   return rtrue;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 487 "Shapes.puma" */
  {
/* line 489 "Shapes.puma" */
 GetFormalShape (t, &shp);
     is = FullIndexSlices (t->INDEXED_VAR.IND_EXPS, &shp, 0);
   
/* line 492 "Shapes.puma" */
   if (! ((is))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
/* line 495 "Shapes.puma" */
  {
/* line 496 "Shapes.puma" */
   return rfalse;
  }

  }
  if (t->Kind == kSELECTED_VAR) {
/* line 499 "Shapes.puma" */
  {
/* line 500 "Shapes.puma" */
   return rfalse;
  }

  }
/* line 503 "Shapes.puma" */
  {
/* line 504 "Shapes.puma" */
   failure_protocol ("Shapes", "IsWholeVar", t);
  }
   return rtrue;

}

static rbool FullIndexSlices
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
/* line 515 "Shapes.puma" */

rbool is;
int val;

 yyRecursion:
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 520 "Shapes.puma" */
  {
/* line 525 "Shapes.puma" */
   if (! (FullIndexSlice (t->BTE_LIST.Elem, s, n))) goto yyL1;
  {
/* line 526 "Shapes.puma" */
   t = t->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }
  }
yyL1:;

  }
  }
  if (t->Kind == kBTE_EMPTY) {
/* line 529 "Shapes.puma" */
   return rtrue;

  }
  return rfalse;
}

static rbool FullIndexSlice
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
/* line 534 "Shapes.puma" */

rbool is;
int val;

  if (t->Kind == kSLICE_EXP) {
/* line 539 "Shapes.puma" */
  {
/* line 543 "Shapes.puma" */
 is = IsBoundExp (t->SLICE_EXP.FIRST, s->bounds[n][0], s->var, n+1, 0);
     if (is)
       is = IsBoundExp (t->SLICE_EXP.STOP, s->bounds[n][1], s->var, n+1, 1);
     if (is)
        { SliceIncrement (t, &is, &val);
          if (is) is = (val == 1);
        }
   
/* line 551 "Shapes.puma" */
   if (! ((is))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  return rfalse;
}

static rbool IsBoundExp
# if defined __STDC__ | defined __cplusplus
(register tTree actual, register tTree formal, register tTree var, register int dim, register int kind)
# else
(actual, formal, var, dim, kind)
 register tTree actual;
 register tTree formal;
 register tTree var;
 register int dim;
 register int kind;
# endif
{
  if (actual->Kind == kDUMMY_EXP) {
/* line 563 "Shapes.puma" */
   return rtrue;

  }
  if (actual->Kind == kBOUND_EXP) {
/* line 566 "Shapes.puma" */
  {
/* line 568 "Shapes.puma" */
   if (! ((formal == NoTree))) goto yyL2;
  {
/* line 569 "Shapes.puma" */
   if (! ((kind == actual->BOUND_EXP.kind))) goto yyL2;
  {
/* line 570 "Shapes.puma" */
   if (! ((dim == actual->BOUND_EXP.dim))) goto yyL2;
  {
/* line 571 "Shapes.puma" */
   if (! ((actual->BOUND_EXP.local == 0))) goto yyL2;
  {
/* line 573 "Shapes.puma" */
   if (! ((EqualExpression (var, actual->BOUND_EXP.VAR)))) goto yyL2;
  }
  }
  }
  }
  }
   return rtrue;
yyL2:;

  }
/* line 576 "Shapes.puma" */
  {
/* line 578 "Shapes.puma" */
   if (! ((formal == NoTree))) goto yyL3;
  {
/* line 579 "Shapes.puma" */
   return rfalse;
  }
  }
yyL3:;

/* line 582 "Shapes.puma" */
  {
/* line 584 "Shapes.puma" */
   if (! ((EqualExpression (actual, formal)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  return rfalse;
}

tTree NormalizeShape
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 598 "Shapes.puma" */

tTree newvar;

  if (t->Kind == kUSED_VAR) {
/* line 602 "Shapes.puma" */
   return t;

  }
  if (t->Kind == kINDEXED_VAR) {
/* line 606 "Shapes.puma" */
  {
/* line 607 "Shapes.puma" */
 if (IsWholeVar(t))
       newvar = t->INDEXED_VAR.IND_VAR;
      else
       newvar = MakeFullShape (t);
   
  }
   return newvar;

  }
  if (t->Kind == kVAR_EXP) {
/* line 615 "Shapes.puma" */
  {
/* line 616 "Shapes.puma" */
 t->VAR_EXP.V = NormalizeShape (t->VAR_EXP.V); 
  }
   return t;

  }
/* line 620 "Shapes.puma" */
   return t;

}

rbool IsContiguousSection
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 640 "Shapes.puma" */

struct_shape s;

  if (t->Kind == kUSED_VAR) {
/* line 644 "Shapes.puma" */
   return rtrue;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 647 "Shapes.puma" */
  {
/* line 649 "Shapes.puma" */
 GetFormalShape (t, &s); 
/* line 650 "Shapes.puma" */
   if (! (IsContiguousShape (t->INDEXED_VAR.IND_EXPS, & s, 0))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  return rfalse;
}

static rbool IsContiguousShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s, register int n)
# else
(t, s, n)
 register tTree t;
 shape s;
 register int n;
# endif
{
/* line 655 "Shapes.puma" */

rbool is;
int val;

  if (t->Kind == kBTE_EMPTY) {
/* line 660 "Shapes.puma" */
   return rtrue;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 663 "Shapes.puma" */
  {
/* line 665 "Shapes.puma" */
   if (! (FullIndexSlice (t->BTE_LIST.Elem, s, n))) goto yyL2;
  {
/* line 666 "Shapes.puma" */
   if (! (IsContiguousShape (t->BTE_LIST.Next, s, n + 1))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

/* line 669 "Shapes.puma" */
  {
/* line 671 "Shapes.puma" */
   if (! (SingleIndexes (t->BTE_LIST.Next))) goto yyL3;
  {
/* line 672 "Shapes.puma" */
 SliceIncrement (t->BTE_LIST.Elem, &is, &val); 
/* line 673 "Shapes.puma" */
   if (! (is)) goto yyL3;
  {
/* line 674 "Shapes.puma" */
   if (! (val == 1)) goto yyL3;
  }
  }
  }
   return rtrue;
yyL3:;

  }
/* line 677 "Shapes.puma" */
  {
/* line 678 "Shapes.puma" */
   if (! (SingleIndexes (t->BTE_LIST.Next))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static rbool SingleIndexes
# if defined __STDC__ | defined __cplusplus
(register tTree indexes)
# else
(indexes)
 register tTree indexes;
# endif
{
 yyRecursion:
  if (indexes->Kind == kBTE_EMPTY) {
/* line 691 "Shapes.puma" */
   return rtrue;

  }
  if (indexes->Kind == kBTE_LIST) {
/* line 694 "Shapes.puma" */
  {
/* line 695 "Shapes.puma" */
   if (! ((TreeRank (indexes->BTE_LIST.Elem) == 0))) goto yyL2;
  {
/* line 696 "Shapes.puma" */
   indexes = indexes->BTE_LIST.Next;
   goto yyRecursion;
  }
  }
yyL2:;

  }
  return rfalse;
}

void GetActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree t, shape s)
# else
(t, s)
 register tTree t;
 shape s;
# endif
{
/* line 721 "Shapes.puma" */

int i;
struct_shape s2;

 yyRecursion:

  switch (t->Kind) {
  case kACF_WHERE:
/* line 730 "Shapes.puma" */
  {
/* line 732 "Shapes.puma" */
   GetActualShape (t->ACF_WHERE.WHERE_EXP, s);
/* line 733 "Shapes.puma" */
   GetActualShape (t->ACF_WHERE.TRUE_PART, & s2);
/* line 734 "Shapes.puma" */
   s = MakeBestShape (s, & s2);
/* line 735 "Shapes.puma" */
   GetActualShape (t->ACF_WHERE.FALSE_PART, & s2);
/* line 736 "Shapes.puma" */
   s = MakeBestShape (s, & s2);
  }
   return;

  case kACF_LIST:
/* line 739 "Shapes.puma" */
  {
/* line 741 "Shapes.puma" */
   GetActualShape (t->ACF_LIST.Elem, s);
/* line 742 "Shapes.puma" */
   GetActualShape (t->ACF_LIST.Next, & s2);
/* line 743 "Shapes.puma" */
   s = MakeBestShape (s, & s2);
  }
   return;

  case kACF_EMPTY:
/* line 746 "Shapes.puma" */
  {
/* line 747 "Shapes.puma" */
 s->rank = 0; 
  }
   return;

  case kACF_BASIC:
/* line 750 "Shapes.puma" */
  {
/* line 752 "Shapes.puma" */
   t = t->ACF_BASIC.BASIC_STMT;
   goto yyRecursion;
  }

  case kASSIGN_STMT:
/* line 755 "Shapes.puma" */
  {
/* line 757 "Shapes.puma" */
   GetActualShape (t->ASSIGN_STMT.ASSIGN_VAR, s);
/* line 758 "Shapes.puma" */
   GetActualShape (t->ASSIGN_STMT.ASSIGN_EXP, & s2);
/* line 759 "Shapes.puma" */
   s = MakeBestShape (s, & s2);
  }
   return;

  case kOP_EXP:
/* line 766 "Shapes.puma" */
  {
/* line 768 "Shapes.puma" */
   GetActualShape (t->OP_EXP.OPND1, s);
/* line 769 "Shapes.puma" */
   GetActualShape (t->OP_EXP.OPND2, & s2);
/* line 770 "Shapes.puma" */
   s = MakeBestShape (s, & s2);
  }
   return;

  case kOP1_EXP:
/* line 773 "Shapes.puma" */
  {
/* line 775 "Shapes.puma" */
   t = t->OP1_EXP.OPND;
   goto yyRecursion;
  }

  case kCONST_EXP:
/* line 778 "Shapes.puma" */
  {
/* line 779 "Shapes.puma" */
 s->rank = 0; 
  }
   return;

  case kADDR:
/* line 782 "Shapes.puma" */
  {
/* line 783 "Shapes.puma" */
   t = t->ADDR.E;
   goto yyRecursion;
  }

  case kARRAY_EXP:
  if (t->ARRAY_EXP.ELEMENTS->Kind == kBTE_LIST) {
  if (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 792 "Shapes.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 794 "Shapes.puma" */
   GetArrayExpressionRange (t->ARRAY_EXP.ELEMENTS->BTE_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 796 "Shapes.puma" */
 
     s->rank = 1;
     s->bounds[0][0] = yyV1;
     s->bounds[0][1] = yyV2;
     s->bounds[0][2] = yyV3;
     s->perm[0] = 1; 
   
  }
   return;
 }

  }
  }
/* line 805 "Shapes.puma" */
  {
/* line 807 "Shapes.puma" */
   error_protocol ("array expression cannot become a loop");
/* line 808 "Shapes.puma" */
   tree_error_protocol ("illegal array expression", t);
/* line 812 "Shapes.puma" */
 s->rank = 0; 
  }
   return;

  case kFUNC_CALL_EXP:
/* line 815 "Shapes.puma" */
  {
/* line 817 "Shapes.puma" */
   if (! ((IsIntrCall (t)))) goto yyL12;
  {
/* line 818 "Shapes.puma" */
   if (! ((GetIntrinsicClass (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object) == kELEMENTAL))) goto yyL12;
  {
/* line 822 "Shapes.puma" */
   t = t->FUNC_CALL_EXP.FUNC_PARAMS;
   goto yyRecursion;
  }
  }
  }
yyL12:;

  if (t->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kNO_PARAM) {
/* line 829 "Shapes.puma" */
  {
/* line 832 "Shapes.puma" */
   if (! ((IsIntrCall (t)))) goto yyL13;
  {
/* line 833 "Shapes.puma" */
   if (! ((IsIdent ("TRANSPOSE") == t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL13;
  {
/* line 835 "Shapes.puma" */
   GetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, s);
/* line 839 "Shapes.puma" */
 for (i=0; i<2; i++)

      { tTree help;

        help = s->bounds[0][i]; 
        s->bounds[0][i] = s->bounds[1][i];
        s->bounds[1][i] = help;
      }
   
  }
  }
  }
   return;
yyL13:;

  }
  if (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 854 "Shapes.puma" */
 {
  rbool found;
  int val;
  {
/* line 857 "Shapes.puma" */
   if (! ((IsIntrCall (t)))) goto yyL14;
  {
/* line 858 "Shapes.puma" */
   if (! ((IsIdent ("SPREAD") == t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))) goto yyL14;
  {
/* line 865 "Shapes.puma" */
   GetIntConstValue (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, & found, & val);
/* line 866 "Shapes.puma" */
   if (! ((found))) goto yyL14;
  {
/* line 868 "Shapes.puma" */
   GetActualShape (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, s);
/* line 870 "Shapes.puma" */
 

     for (i=s->rank; i >= val; i--)         

       { int j; 

         for (j=0; j<3; j++) s->bounds[i][j] = s->bounds[i-1][j];

         s->perm[i] = i+1;
       }

      

      s->perm[val-1] = val;
      s->bounds[val-1][0] = MakeConstant (1);
      s->bounds[val-1][1] = VarParamToExp (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Elem);
      s->bounds[val-1][2] = NoTree;
      s->rank = s->rank + 1;
   
  }
  }
  }
  }
   return;
 }
yyL14:;

  }
  }
  }
  }
/* line 891 "Shapes.puma" */
  {
/* line 893 "Shapes.puma" */
 
     s->rank = 0;
   
  }
   return;

  case kBTP_EMPTY:
/* line 905 "Shapes.puma" */
  {
/* line 907 "Shapes.puma" */
 s->rank = 0; 
  }
   return;

  case kBTP_LIST:
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 910 "Shapes.puma" */
  {
/* line 912 "Shapes.puma" */
   GetActualShape (t->BTP_LIST.Elem->VAR_PARAM.V, s);
/* line 913 "Shapes.puma" */
   GetActualShape (t->BTP_LIST.Next, & s2);
/* line 914 "Shapes.puma" */
   s = MakeBestShape (s, & s2);
  }
   return;

  }
/* line 917 "Shapes.puma" */
  {
/* line 919 "Shapes.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  case kVAR_EXP:
/* line 922 "Shapes.puma" */
  {
/* line 924 "Shapes.puma" */
   t = t->VAR_EXP.V;
   goto yyRecursion;
  }

  }

/* line 933 "Shapes.puma" */
  {
/* line 935 "Shapes.puma" */
   if (! ((TreeRank (t) == 0))) goto yyL21;
  {
/* line 936 "Shapes.puma" */
 s->rank = 0; 
  }
  }
   return;
yyL21:;

  if (t->Kind == kUSED_VAR) {
/* line 939 "Shapes.puma" */
  {
/* line 941 "Shapes.puma" */
 GetFormalShape (t, s);
      
      for (i=0;i<s->rank;i++)
         s->perm[i] = i+1;
    
  }
   return;

  }
  if (t->Kind == kSELECTED_VAR) {
/* line 950 "Shapes.puma" */
  {
/* line 952 "Shapes.puma" */
   if (! ((TreeRank (t->SELECTED_VAR.SELEC_VAR) > 0))) goto yyL23;
  {
/* line 954 "Shapes.puma" */
   t = t->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }
  }
yyL23:;

/* line 957 "Shapes.puma" */
  {
/* line 959 "Shapes.puma" */
 GetFormalShape (t, s);

      

      for (i=0;i<s->rank;i++) s->perm[i] = i+1;
    
  }
   return;

  }
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 967 "Shapes.puma" */
  {
/* line 969 "Shapes.puma" */
   if (! ((TreeRank (t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR) != 0))) goto yyL25;
  {
/* line 971 "Shapes.puma" */
   t = t->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR;
   goto yyRecursion;
  }
  }
yyL25:;

  }
/* line 974 "Shapes.puma" */
  {
/* line 976 "Shapes.puma" */
 GetFormalShape (t->INDEXED_VAR.IND_VAR, s);  

     s->rank = 0;
     UpdateActualShape (t->INDEXED_VAR.IND_EXPS, s, 0);  

   
  }
   return;

  }
/* line 984 "Shapes.puma" */
  {
/* line 986 "Shapes.puma" */
   failure_protocol (MODULE, "GetActualShape", t);
  }
   return;

;
}

static void GetArrayExpressionRange
# if defined __STDC__ | defined __cplusplus
(register tTree elem, register tTree * yyP3, register tTree * yyP2, register tTree * yyP1)
# else
(elem, yyP3, yyP2, yyP1)
 register tTree elem;
 register tTree * yyP3;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (elem->Kind == kSLICE_EXP) {
/* line 991 "Shapes.puma" */
   * yyP3 = elem->SLICE_EXP.FIRST;
   * yyP2 = elem->SLICE_EXP.STOP;
   * yyP1 = elem->SLICE_EXP.INC;
   return;

  }
  if (elem->Kind == kDO_EXP) {
/* line 994 "Shapes.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 996 "Shapes.puma" */
   GetArrayExpressionRange (elem->DO_EXP.RANGE, & yyV1, & yyV2, & yyV3);
  }
   * yyP3 = yyV1;
   * yyP2 = yyV2;
   * yyP1 = yyV3;
   return;
 }

  }
/* line 999 "Shapes.puma" */
  {
/* line 1001 "Shapes.puma" */
   error_protocol ("could not get shape of array expression");
/* line 1002 "Shapes.puma" */
   tree_protocol ("val is : ", elem);
  }
   * yyP3 = NoTree;
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void UpdateActualShape
# if defined __STDC__ | defined __cplusplus
(register tTree indexes, shape s, register int n)
# else
(indexes, s, n)
 register tTree indexes;
 shape s;
 register int n;
# endif
{
/* line 1019 "Shapes.puma" */

int r, m;
struct_shape h_shp;

 yyRecursion:
  if (indexes->Kind == kBTE_LIST) {
  if (indexes->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 1024 "Shapes.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 1028 "Shapes.puma" */
   NormalActualSlice (indexes->BTE_LIST.Elem, & yyV1, & yyV2, & yyV3);
/* line 1030 "Shapes.puma" */
 m = s->rank;
     s->bounds[m][0] = yyV1;
     s->bounds[m][1] = yyV2;
     s->bounds[m][2] = yyV3;
     s->perm[m] = m + 1; 
     s->rank = m + 1;
   
/* line 1038 "Shapes.puma" */
   indexes = indexes->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }
 }

  }
/* line 1041 "Shapes.puma" */
  {
/* line 1043 "Shapes.puma" */
 r = TreeRank(indexes->BTE_LIST.Elem);
     if (r > 0)
        { 
          if (r == 1)
            { GetActualShape (indexes->BTE_LIST.Elem, &h_shp);
              if (h_shp.rank != 1)
                 error_protocol ("unknown fatal error");
              m = s->rank;
              s->bounds[m][0] = h_shp.bounds[0][0];
              s->bounds[m][1] = h_shp.bounds[0][1];
              s->bounds[m][2] = h_shp.bounds[0][2];
              s->perm[m] = m+1;  
              s->rank = m+1;
            }
           else
             error_protocol ("illegal rank in indirect addressing");
         }
   
/* line 1061 "Shapes.puma" */
   indexes = indexes->BTE_LIST.Next;
   n = n + 1;
   goto yyRecursion;
  }

  }
  if (indexes->Kind == kBTE_EMPTY) {
/* line 1064 "Shapes.puma" */
   return;

  }
/* line 1067 "Shapes.puma" */
  {
/* line 1069 "Shapes.puma" */
   failure_protocol (MODULE, "UpdateActualShape", indexes);
  }
   return;

;
}

static void NormalActualSlice
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree * yyP6, register tTree * yyP5, register tTree * yyP4)
# else
(exp, yyP6, yyP5, yyP4)
 register tTree exp;
 register tTree * yyP6;
 register tTree * yyP5;
 register tTree * yyP4;
# endif
{
  if (exp->Kind == kSLICE_EXP) {
/* line 1079 "Shapes.puma" */
 {
  tTree new_lb;
  tTree new_ub;
  rbool found;
  int val;
  int yyV1;
  int yyV2;
  {
/* line 1089 "Shapes.puma" */
   SliceIncrement (exp, & found, & val);
/* line 1090 "Shapes.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 1091 "Shapes.puma" */
   if (! (((val != 1) && (val != - 1)))) goto yyL1;
  {
/* line 1093 "Shapes.puma" */
   if (! ((IsMultiply (exp->SLICE_EXP.FIRST, val, & yyV1)))) goto yyL1;
  {
/* line 1094 "Shapes.puma" */
   if (! ((IsMultiply (exp->SLICE_EXP.STOP, val, & yyV2)))) goto yyL1;
  {
/* line 1095 "Shapes.puma" */
   if (! ((yyV1 == yyV2))) goto yyL1;
  {
/* line 1097 "Shapes.puma" */
   new_lb = DivConstant (AddConstant (CopyTree (exp->SLICE_EXP.FIRST), - yyV1), val);
/* line 1098 "Shapes.puma" */
   new_ub = DivConstant (AddConstant (CopyTree (exp->SLICE_EXP.STOP), - yyV1), val);
  }
  }
  }
  }
  }
  }
   * yyP6 = new_lb;
   * yyP5 = new_ub;
   * yyP4 = DivConstant (CopyTree (exp->SLICE_EXP.INC), val);
   return;
 }
yyL1:;

/* line 1101 "Shapes.puma" */
   * yyP6 = exp->SLICE_EXP.FIRST;
   * yyP5 = exp->SLICE_EXP.STOP;
   * yyP4 = exp->SLICE_EXP.INC;
   return;

  }
/* line 1106 "Shapes.puma" */
  {
/* line 1108 "Shapes.puma" */
   failure_protocol (MODULE, "NomarliceSlice", exp);
  }
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   * yyP4 = NoTree;
   return;

;
}

static rbool IsMultiply
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register int c, register int * yyP7)
# else
(exp, c, yyP7)
 register tTree exp;
 register int c;
 register int * yyP7;
# endif
{
/* line 1114 "Shapes.puma" */
 {
  int a;
  int b;
  int m;
  rbool found;
  tTree var;
  {
/* line 1122 "Shapes.puma" */
   ResolveExpression (exp, & found, & a, & b, & var);
/* line 1123 "Shapes.puma" */
   if (! ((found))) goto yyL1;
  {
/* line 1124 "Shapes.puma" */
   if (! ((a % c == 0))) goto yyL1;
  {
/* line 1126 "Shapes.puma" */
 if (b >= 0) 
        m = b%c;
      else
        m = c + (b%c);
   
  }
  }
  }
   * yyP7 = m;
   return rtrue;
 }
yyL1:;

  return rfalse;
}

static shape MakeBestShape
# if defined __STDC__ | defined __cplusplus
(shape s1, shape s2)
# else
(s1, s2)
 shape s1;
 shape s2;
# endif
{
/* line 1147 "Shapes.puma" */
  {
/* line 1148 "Shapes.puma" */
   if (! ((s1 -> rank == 0))) goto yyL1;
  {
/* line 1149 "Shapes.puma" */
 *s1 = *s2; 
  }
  }
   return s1;
yyL1:;

/* line 1153 "Shapes.puma" */
  {
/* line 1154 "Shapes.puma" */
   if (! ((s2 -> rank == 0))) goto yyL2;
  }
   return s1;
yyL2:;

/* line 1158 "Shapes.puma" */
  {
/* line 1160 "Shapes.puma" */
   if (! ((s1 -> rank != s2 -> rank))) goto yyL3;
  {
/* line 1161 "Shapes.puma" */
   error_protocol ("illegal array statemet");
  }
  }
   return s1;
yyL3:;

/* line 1165 "Shapes.puma" */
  {
/* line 1167 "Shapes.puma" */
 int i, rank;

     rank = s1->rank;

     for (i=0; i<rank; i++)
       { if (IsItAStride1 (s1->bounds[i][2]))
            { 
            }
          else if (IsItAStride1 (s2->bounds[i][2]))
            { 
              s1->bounds[i][0] = s2->bounds[i][0];
              s1->bounds[i][1] = s2->bounds[i][1];
              s1->bounds[i][2] = s2->bounds[i][2];
            }
       }
   
  }
   return s1;

}

static rbool IsItAStride1
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
/* line 1194 "Shapes.puma" */
  {
/* line 1195 "Shapes.puma" */
   if (! ((t == NoTree))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (t->Kind == kDUMMY_EXP) {
/* line 1198 "Shapes.puma" */
   return rtrue;

  }
/* line 1201 "Shapes.puma" */
 {
  rbool found;
  int val;
  {
/* line 1206 "Shapes.puma" */
   GetIntConstValue (t, & found, & val);
/* line 1207 "Shapes.puma" */
   if (! ((found))) goto yyL3;
  {
/* line 1208 "Shapes.puma" */
   if (! ((val == 1))) goto yyL3;
  }
  }
   return rtrue;
 }
yyL3:;

  return rfalse;
}

void BeginShapes ARGS ((void))
{
}

void CloseShapes ARGS ((void))
{
}
