# include "SetDefs.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 31 "SetDefs.puma" */


# include "Idents.h"
# include "StringM.h"
# include "protocol.h"

# include "DefTable.h"

# include "Transform.h"     /* ExpToVarParam, ... */
# include "Types.h"         /* GetVariableType, ... */
# include "Rank.h"     
# include "Intrinsics.h"

# include "Objects.h"       /* MakeNewObject        */
# include "ChangeDefs.h"    /* MakeExternalxxxxCall */
# include "MapDefs.h"       
# include "Nesting.h"       /* GetCurrentUnitObject */ 

# define MODULE "SetDefs"

static int SubTopCounter = 0;



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySetDefs.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* SetDefs_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SetDefs, routine %s failed\n",
  yyFunction);
 SetDefs_Exit ();
}

void MakeACFDefs ARGS ((tTree t));
static void MakeStmtDefs ARGS ((tTree t));
static tTree MakeFuncCall ARGS ((tIdent id, tTree expressions));
static tTree MakeFuncParams ARGS ((tTree t));
static void MakeParamDefs ARGS ((tTree t));
static tTree DefExpToParameter ARGS ((tTree exp));
static void MakeProcParam ARGS ((tDefinitions Obj, tTree * result));
static tTree MakeProcObj ARGS ((tDefinitions Obj));
void MakeIndexDefs ARGS ((tTree t));
static rbool HasNamedExp ARGS ((tTree t));
void MakeVarDefs ARGS ((tTree t));
static void MakeOnClauseDefs ARGS ((tTree t));
static void MakeHomeDefs ARGS ((tTree t));
static void SetSelectedCompObj ARGS ((tTree sv, tTree type));
static void MakeSubstring ARGS ((tTree t));
static void MySetVarObject ARGS ((tTree t, tDefinitions obj));
static void SetHomeObject ARGS ((tTree t, tDefinitions obj));
static void SetObjUse ARGS ((tDefinitions v));
tTree CheckExp ARGS ((tTree exp));
static rbool IsArrayVariable ARGS ((tDefinitions Obj));
static tTree ObjTypePtr ARGS ((tDefinitions v));
static tTree VarSelect ARGS ((tTree var, tTree stype));
static tTree MakeTypeExp ARGS ((tIdent id, tTree exps));
void MakeTopologyDef ARGS ((tTree spec));
static void SetTopologyObject ARGS ((tTree t, tDefinitions obj));
static void MakeSubTopology ARGS ((tTree spec));

void MakeACFDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kACF_LIST:
/* line 68 "SetDefs.puma" */
  {
/* line 70 "SetDefs.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 71 "SetDefs.puma" */
   MakeACFDefs (t->ACF_LIST.Elem);
/* line 72 "SetDefs.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_DUMMY:
/* line 75 "SetDefs.puma" */
   return;

  case kACF_EMPTY:
/* line 78 "SetDefs.puma" */
   return;

  case kACF_BASIC:
/* line 81 "SetDefs.puma" */
  {
/* line 83 "SetDefs.puma" */
   MakeStmtDefs (t->ACF_BASIC.BASIC_STMT);
  }
   return;

  case kACF_IF:
/* line 86 "SetDefs.puma" */
  {
/* line 88 "SetDefs.puma" */
 t->ACF_IF.IF_EXP = CheckExp (t->ACF_IF.IF_EXP); 
/* line 90 "SetDefs.puma" */
   MakeACFDefs (t->ACF_IF.THEN_PART);
/* line 91 "SetDefs.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_WHERE:
/* line 94 "SetDefs.puma" */
  {
/* line 96 "SetDefs.puma" */
 t->ACF_WHERE.WHERE_EXP = CheckExp (t->ACF_WHERE.WHERE_EXP); 
/* line 98 "SetDefs.puma" */
   MakeACFDefs (t->ACF_WHERE.TRUE_PART);
/* line 99 "SetDefs.puma" */
   t = t->ACF_WHERE.FALSE_PART;
   goto yyRecursion;
  }

  case kACF_CASE:
/* line 102 "SetDefs.puma" */
  {
/* line 103 "SetDefs.puma" */
 t->ACF_CASE.CASE_EXP = CheckExp (t->ACF_CASE.CASE_EXP); 
/* line 104 "SetDefs.puma" */
   t = t->ACF_CASE.CASE_ALTS;
   goto yyRecursion;
  }

  case kSELECTED_ACF_LIST:
/* line 107 "SetDefs.puma" */
  {
/* line 108 "SetDefs.puma" */
   MakeACFDefs (t->SELECTED_ACF_LIST.Elem);
/* line 109 "SetDefs.puma" */
   t = t->SELECTED_ACF_LIST.Next;
   goto yyRecursion;
  }

  case kSELECTED_ACF_EMPTY:
/* line 112 "SetDefs.puma" */
   return;

  case kSELECTED_ACF_NODE:
/* line 115 "SetDefs.puma" */
  {
/* line 116 "SetDefs.puma" */
   MakeIndexDefs (t->SELECTED_ACF_NODE.SELECT_LIST);
/* line 117 "SetDefs.puma" */
   t = t->SELECTED_ACF_NODE.SELECT_ACFS;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 120 "SetDefs.puma" */
  {
/* line 121 "SetDefs.puma" */
 t->ACF_WHILE.WHILE_EXP = CheckExp (t->ACF_WHILE.WHILE_EXP); 
/* line 123 "SetDefs.puma" */
   t = t->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;
  }

  case kACF_LOOP:
/* line 126 "SetDefs.puma" */
  {
/* line 127 "SetDefs.puma" */
   t = t->ACF_LOOP.LOOP_BODY;
   goto yyRecursion;
  }

  case kACF_DO:
/* line 130 "SetDefs.puma" */
  {
/* line 132 "SetDefs.puma" */
   MakeVarDefs (t->ACF_DO.DO_ID);
/* line 133 "SetDefs.puma" */
 t->ACF_DO.DO_RANGE = CheckExp (t->ACF_DO.DO_RANGE);  
/* line 134 "SetDefs.puma" */
   t = t->ACF_DO.DO_BODY;
   goto yyRecursion;
  }

  case kACF_FORALL:
/* line 137 "SetDefs.puma" */
  {
/* line 139 "SetDefs.puma" */
   MakeVarDefs (t->ACF_FORALL.FORALL_ID);
/* line 140 "SetDefs.puma" */
 t->ACF_FORALL.FORALL_RANGE = CheckExp (t->ACF_FORALL.FORALL_RANGE);  
/* line 141 "SetDefs.puma" */
   t = t->ACF_FORALL.FORALL_BODY;
   goto yyRecursion;
  }

  case kACF_ENTRY:
/* line 144 "SetDefs.puma" */
  {
/* line 146 "SetDefs.puma" */
   tree_error_protocol ("entry statement not supported", t);
  }
   return;

  case kACF_HOME:
/* line 149 "SetDefs.puma" */
  {
/* line 151 "SetDefs.puma" */
   MakeOnClauseDefs (t->ACF_HOME.HOME_VAR);
/* line 152 "SetDefs.puma" */
   t = t->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  case kACF_RESIDENT:
/* line 155 "SetDefs.puma" */
  {
/* line 157 "SetDefs.puma" */
   MakeVarDefs (t->ACF_RESIDENT.RESIDENT_VAR);
/* line 158 "SetDefs.puma" */
   t = t->ACF_RESIDENT.RESIDENT_BODY;
   goto yyRecursion;
  }

  case kACF_NEW:
/* line 161 "SetDefs.puma" */
  {
/* line 163 "SetDefs.puma" */
   MakeVarDefs (t->ACF_NEW.NEW_VAR);
/* line 164 "SetDefs.puma" */
   t = t->ACF_NEW.NEW_BODY;
   goto yyRecursion;
  }

  case kACF_REDUCTION:
/* line 167 "SetDefs.puma" */
  {
/* line 169 "SetDefs.puma" */
   MakeVarDefs (t->ACF_REDUCTION.REDUCTION_VAR);
/* line 170 "SetDefs.puma" */
   t = t->ACF_REDUCTION.REDUCTION_BODY;
   goto yyRecursion;
  }

  case kACF_TASK_REGION:
/* line 173 "SetDefs.puma" */
  {
/* line 175 "SetDefs.puma" */
   t = t->ACF_TASK_REGION.TASK_BODY;
   goto yyRecursion;
  }

  }

/* line 178 "SetDefs.puma" */
  {
/* line 179 "SetDefs.puma" */
   failure_protocol (MODULE, "MakeACFDefs", t);
  }
   return;

;
}

static void MakeStmtDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{

  switch (t->Kind) {
  case kASSIGN_STMT:
/* line 190 "SetDefs.puma" */
  {
/* line 192 "SetDefs.puma" */
   MakeVarDefs (t->ASSIGN_STMT.ASSIGN_VAR);
/* line 193 "SetDefs.puma" */
 t->ASSIGN_STMT.ASSIGN_EXP = CheckExp (t->ASSIGN_STMT.ASSIGN_EXP); 
  }
   return;

  case kATOMIC_STMT:
/* line 196 "SetDefs.puma" */
  {
/* line 198 "SetDefs.puma" */
   MakeVarDefs (t->ATOMIC_STMT.ASSIGN_VAR);
/* line 199 "SetDefs.puma" */
 t->ATOMIC_STMT.ASSIGN_EXP = CheckExp (t->ATOMIC_STMT.ASSIGN_EXP); 
  }
   return;

  case kCALL_STMT:
/* line 202 "SetDefs.puma" */
  {
/* line 204 "SetDefs.puma" */
 t->CALL_STMT.CALL_ID->PROC_OBJ.Object = GetProcObject (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, GetCurrentUnitObject ()); 
/* line 206 "SetDefs.puma" */
   MakeParamDefs (t->CALL_STMT.CALL_PARAMS);
  }
   return;

  case kIO_STMT:
/* line 209 "SetDefs.puma" */
  {
/* line 211 "SetDefs.puma" */
   MakeParamDefs (t->IO_STMT.IO_SPECS);
/* line 212 "SetDefs.puma" */
   MakeParamDefs (t->IO_STMT.IO_ITEMS);
  }
   return;

  case kGOTO_STMT:
/* line 215 "SetDefs.puma" */
   return;

  case kLABEL_ASSIGN_STMT:
/* line 218 "SetDefs.puma" */
  {
/* line 219 "SetDefs.puma" */
   MakeVarDefs (t->LABEL_ASSIGN_STMT.LABEL_VAR);
  }
   return;

  case kPTR_ASSIGN_STMT:
/* line 222 "SetDefs.puma" */
  {
/* line 224 "SetDefs.puma" */
   MakeVarDefs (t->PTR_ASSIGN_STMT.ASSIGN_VAR);
/* line 225 "SetDefs.puma" */
 t->PTR_ASSIGN_STMT.ASSIGN_EXP = CheckExp (t->PTR_ASSIGN_STMT.ASSIGN_EXP); 
  }
   return;

  case kASS_GOTO_STMT:
/* line 228 "SetDefs.puma" */
  {
/* line 229 "SetDefs.puma" */
   MakeVarDefs (t->ASS_GOTO_STMT.GOTO_VAR);
  }
   return;

  case kCOMP_GOTO_STMT:
/* line 232 "SetDefs.puma" */
  {
/* line 233 "SetDefs.puma" */
 t->COMP_GOTO_STMT.GOTO_EXP = CheckExp (t->COMP_GOTO_STMT.GOTO_EXP); 
  }
   return;

  case kCOMP_IF_STMT:
/* line 236 "SetDefs.puma" */
  {
/* line 237 "SetDefs.puma" */
 t->COMP_IF_STMT.IF_EXP = CheckExp (t->COMP_IF_STMT.IF_EXP); 
  }
   return;

  case kRETURN_STMT:
/* line 240 "SetDefs.puma" */
  {
/* line 241 "SetDefs.puma" */
 t->RETURN_STMT.RETURN_EXP = CheckExp (t->RETURN_STMT.RETURN_EXP); 
  }
   return;

  case kFORMAT_STMT:
/* line 244 "SetDefs.puma" */
   return;

  case kSTOP_STMT:
/* line 247 "SetDefs.puma" */
  {
/* line 248 "SetDefs.puma" */
 t->STOP_STMT.STOP_CONST = CheckExp (t->STOP_STMT.STOP_CONST); 
  }
   return;

  case kEXIT_STMT:
/* line 251 "SetDefs.puma" */
   return;

  case kCYCLE_STMT:
/* line 254 "SetDefs.puma" */
   return;

  case kALLOCATE_STMT:
/* line 257 "SetDefs.puma" */
  {
/* line 259 "SetDefs.puma" */
   MakeParamDefs (t->ALLOCATE_STMT.PARAMS);
/* line 260 "SetDefs.puma" */
   MakeVarDefs (t->ALLOCATE_STMT.STATUS);
  }
   return;

  case kDEALLOCATE_STMT:
/* line 263 "SetDefs.puma" */
  {
/* line 265 "SetDefs.puma" */
   MakeParamDefs (t->DEALLOCATE_STMT.PARAMS);
/* line 266 "SetDefs.puma" */
   MakeVarDefs (t->DEALLOCATE_STMT.STATUS);
  }
   return;

  case kREDUCE_STMT:
/* line 272 "SetDefs.puma" */
  {
/* line 274 "SetDefs.puma" */
 t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Object = GetIntrinsicObject (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident);
     if (!IntrFuncRed (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident))
        error_protocol ("reduce function no reduction");
     if (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Object == NoObject)
        error_protocol ("reduce function not intrinsic");
   
/* line 281 "SetDefs.puma" */
   MakeParamDefs (t->REDUCE_STMT.RED_PARAMS);
  }
   return;

  case kREALIGN_STMT:
/* line 284 "SetDefs.puma" */
  {
/* line 286 "SetDefs.puma" */
   MakeVarDefs (t->REALIGN_STMT.ALIGNEE);
/* line 287 "SetDefs.puma" */
   MakeRealignDefs (t);
  }
   return;

  case kREDISTRIBUTE_STMT:
/* line 290 "SetDefs.puma" */
  {
/* line 292 "SetDefs.puma" */
   MakeRedistributeDefs (t);
  }
   return;

  case kNULLIFY_STMT:
/* line 295 "SetDefs.puma" */
  {
/* line 296 "SetDefs.puma" */
   MakeParamDefs (t->NULLIFY_STMT.PARAMS);
  }
   return;

  }

/* line 299 "SetDefs.puma" */
  {
/* line 300 "SetDefs.puma" */
   failure_protocol (MODULE, "MakeStmtDefs", t);
  }
   return;

;
}

static tTree MakeFuncCall
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree expressions)
# else
(id, expressions)
 register tIdent id;
 register tTree expressions;
# endif
{
/* line 313 "SetDefs.puma" */
   return mFUNC_CALL_EXP (mPROC_OBJ (id), MakeFuncParams (expressions));

}

static tTree MakeFuncParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
/* line 330 "SetDefs.puma" */
  {
/* line 332 "SetDefs.puma" */
 t->BTE_LIST.Elem  = MakeFuncParams (t->BTE_LIST.Elem);
     t->BTE_LIST.Next = MakeFuncParams (t->BTE_LIST.Next);

     t->Kind = kBTP_LIST;
   
  }
   return t;

  }
  if (t->Kind == kBTE_EMPTY) {
/* line 340 "SetDefs.puma" */
  {
/* line 342 "SetDefs.puma" */
 t->Kind = kBTP_EMPTY; 
  }
   return t;

  }
  if (t->Kind == kNAMED_EXP) {
/* line 347 "SetDefs.puma" */
  {
/* line 349 "SetDefs.puma" */
 t->NAMED_EXP.VAL = MakeFuncParams (t->NAMED_EXP.VAL); 

     t->Kind = kNAMED_PARAM;
   
  }
   return t;

  }
/* line 357 "SetDefs.puma" */
   return mVALUE_PARAM (t);

}

static void MakeParamDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_LIST) {

  switch (t->BTP_LIST.Elem->Kind) {
  case kVALUE_PARAM:
/* line 385 "SetDefs.puma" */
  {
/* line 387 "SetDefs.puma" */
 t->BTP_LIST.Elem = DefExpToParameter (t->BTP_LIST.Elem->VALUE_PARAM.E); 
/* line 388 "SetDefs.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  case kNAMED_PARAM:
  if (t->BTP_LIST.Elem->NAMED_PARAM.VAL->Kind == kVALUE_PARAM) {
/* line 391 "SetDefs.puma" */
  {
/* line 393 "SetDefs.puma" */
 t->BTP_LIST.Elem->NAMED_PARAM.VAL = DefExpToParameter (t->BTP_LIST.Elem->NAMED_PARAM.VAL->VALUE_PARAM.E); 
/* line 395 "SetDefs.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->BTP_LIST.Elem->NAMED_PARAM.VAL->Kind == kVAR_PARAM) {
/* line 400 "SetDefs.puma" */
  {
/* line 402 "SetDefs.puma" */
   MakeVarDefs (t->BTP_LIST.Elem->NAMED_PARAM.VAL->VAR_PARAM.V);
/* line 403 "SetDefs.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  break;
  case kVAR_PARAM:
/* line 406 "SetDefs.puma" */
  {
/* line 408 "SetDefs.puma" */
   MakeVarDefs (t->BTP_LIST.Elem->VAR_PARAM.V);
/* line 409 "SetDefs.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  case kNO_PARAM:
/* line 412 "SetDefs.puma" */
  {
/* line 414 "SetDefs.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  case kPROC_PARAM:
/* line 417 "SetDefs.puma" */
  {
/* line 419 "SetDefs.puma" */
 t->BTP_LIST.Elem->PROC_PARAM.P->PROC_OBJ.Object = GetProcObject (t->BTP_LIST.Elem->PROC_PARAM.P->PROC_OBJ.Ident, GetCurrentUnitObject ()); 
  }
   return;

  case kFUNC_PARAM:
/* line 422 "SetDefs.puma" */
  {
/* line 424 "SetDefs.puma" */
 t->BTP_LIST.Elem->FUNC_PARAM.F->PROC_OBJ.Object = GetFuncObject (t->BTP_LIST.Elem->FUNC_PARAM.F->PROC_OBJ.Ident, GetCurrentUnitObject ()); 
  }
   return;

  case kRETURN_PARAM:
/* line 427 "SetDefs.puma" */
  {
/* line 429 "SetDefs.puma" */
   error_protocol ("actual return parameter not handled");
  }
   return;

  }

  }
  if (t->Kind == kBTP_EMPTY) {
/* line 432 "SetDefs.puma" */
   return;

  }
/* line 435 "SetDefs.puma" */
  {
/* line 436 "SetDefs.puma" */
   failure_protocol (MODULE, "MakeParamDefs", t);
  }
   return;

;
}

static tTree DefExpToParameter
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
  if (exp->Kind == kNAMED_EXP) {
/* line 455 "SetDefs.puma" */
  {
/* line 457 "SetDefs.puma" */
 exp->NAMED_EXP.VAL = DefExpToParameter (exp->NAMED_EXP.VAL);
       exp->Kind = kNAMED_PARAM;
     
  }
   return exp;

  }
  if (exp->Kind == kVAR_EXP) {
  if (exp->VAR_EXP.V->Kind == kUSED_VAR) {
/* line 470 "SetDefs.puma" */
 {
  tTree yyV1;
  {
/* line 472 "SetDefs.puma" */
   MakeProcParam (GetGlobalObject (exp->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Ident), & yyV1);
/* line 474 "SetDefs.puma" */
   if (! ((yyV1 != NoTree))) goto yyL2;
  }
   return yyV1;
 }
yyL2:;

  }
  }
/* line 487 "SetDefs.puma" */
   return ExpToVarParam (CheckExp (exp));

}

static void MakeProcParam
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj, register tTree * result)
# else
(Obj, result)
 register tDefinitions Obj;
 register tTree * result;
# endif
{
/* line 500 "SetDefs.puma" */
  {
/* line 502 "SetDefs.puma" */
   if (! ((Obj == NoObject))) goto yyL1;
  }
   * result = NoTree;
   return;
yyL1:;

  if (Obj->Kind == kFuncObject) {
/* line 505 "SetDefs.puma" */
  {
/* line 509 "SetDefs.puma" */
   if (! ((Obj != GetCurrentUnitObject ()))) goto yyL2;
  }
   * result = mFUNC_PARAM (MakeProcObj (Obj));
   return;
yyL2:;

  }
  if (Obj->Kind == kProcObject) {
/* line 512 "SetDefs.puma" */
   * result = mPROC_PARAM (MakeProcObj (Obj));
   return;

  }
  if (Obj->Kind == kExternalObject) {
/* line 515 "SetDefs.puma" */
   * result = mPROC_PARAM (MakeProcObj (Obj));
   return;

  }
/* line 518 "SetDefs.puma" */
   * result = NoTree;
   return;

;
}

static tTree MakeProcObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
/* line 523 "SetDefs.puma" */
 {
  tTree p;
  {
/* line 527 "SetDefs.puma" */
 p = mPROC_OBJ (Obj->Object.Ident);
     p->PROC_OBJ.Object = Obj;
   
  }
   return p;
 }

}

void MakeIndexDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTE_LIST) {
/* line 544 "SetDefs.puma" */
  {
/* line 546 "SetDefs.puma" */
 t->BTE_LIST.Elem = CheckExp (t->BTE_LIST.Elem); 
/* line 548 "SetDefs.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTE_EMPTY) {
/* line 551 "SetDefs.puma" */
   return;

  }
/* line 554 "SetDefs.puma" */
  {
/* line 555 "SetDefs.puma" */
   failure_protocol (MODULE, "MakeIndexDefs", t);
  }
   return;

;
}

static rbool HasNamedExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kNAMED_EXP) {
/* line 568 "SetDefs.puma" */
   return rtrue;

  }
/* line 571 "SetDefs.puma" */
  {
/* line 573 "SetDefs.puma" */
   if (! ((HasNamedExp (t->BTE_LIST.Next)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  return rfalse;
}

void MakeVarDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kBTV_LIST:
/* line 590 "SetDefs.puma" */
  {
/* line 591 "SetDefs.puma" */
   MakeVarDefs (t->BTV_LIST.Elem);
/* line 592 "SetDefs.puma" */
   t = t->BTV_LIST.Next;
   goto yyRecursion;
  }

  case kBTV_EMPTY:
/* line 595 "SetDefs.puma" */
   return;

  case kDUMMY_VAR:
/* line 598 "SetDefs.puma" */
   return;

  case kUSED_VAR:
/* line 601 "SetDefs.puma" */
  {
/* line 602 "SetDefs.puma" */
   t = t->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  case kLOOP_VAR:
/* line 605 "SetDefs.puma" */
  {
/* line 606 "SetDefs.puma" */
   t = t->LOOP_VAR.LOOP_VARNAME;
   goto yyRecursion;
  }

  case kDO_VAR:
/* line 609 "SetDefs.puma" */
  {
/* line 610 "SetDefs.puma" */
   MakeVarDefs (t->DO_VAR.DO_ID);
/* line 611 "SetDefs.puma" */
 t->DO_VAR.RANGE = CheckExp (t->DO_VAR.RANGE); 
/* line 612 "SetDefs.puma" */
   t = t->DO_VAR.BODY;
   goto yyRecursion;
  }

  case kVAR_OBJ:
/* line 621 "SetDefs.puma" */
  {
/* line 625 "SetDefs.puma" */
   MySetVarObject (t, GetGlobalObject (t->VAR_OBJ.Ident));
  }
   return;

  case kINDEXED_VAR:
/* line 634 "SetDefs.puma" */
 {
  tTree tp;
  tDefinitions Obj;
  {
/* line 636 "SetDefs.puma" */
   MakeVarDefs (t->INDEXED_VAR.IND_VAR);
/* line 638 "SetDefs.puma" */
 if (HasNamedExp (t->INDEXED_VAR.IND_EXPS))
        error_protocol ("named expression as index expression");
   
/* line 642 "SetDefs.puma" */
   MakeIndexDefs (t->INDEXED_VAR.IND_EXPS);
/* line 649 "SetDefs.puma" */
 tp = GetVariableType (t->INDEXED_VAR.IND_VAR);
     if (tp == NoTree)
        { error_protocol ("type of indexed var unknown, illegal array");
          tree_protocol ("variable is ", t);
        }
      else if (IsStringType (tp))
        MakeSubstring (t);
      else if (!IsArrayType (tp))
        { error_protocol ("illegal array access (not an array)");
          tree_protocol ("variable is ", t);
          tree_protocol ("type is     ", tp);
        }
   
  }
   return;
 }

  case kSELECTED_VAR:
/* line 664 "SetDefs.puma" */
  {
/* line 666 "SetDefs.puma" */
   MakeVarDefs (t->SELECTED_VAR.SELEC_VAR);
/* line 667 "SetDefs.puma" */
   SetSelectedCompObj (t, GetVariableType (t->SELECTED_VAR.SELEC_VAR));
  }
   return;

  case kADDR:
/* line 670 "SetDefs.puma" */
  {
/* line 672 "SetDefs.puma" */
 t->ADDR.E = CheckExp (t->ADDR.E); 
  }
   return;

  }

/* line 675 "SetDefs.puma" */
  {
/* line 676 "SetDefs.puma" */
   failure_protocol (MODULE, "MakeVarDefs", t);
  }
   return;

;
}

static void MakeOnClauseDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kON_PROC_CLAUSE) {
/* line 687 "SetDefs.puma" */
  {
/* line 689 "SetDefs.puma" */
   MakeTopologyDef (t->ON_PROC_CLAUSE.ON_PROC);
  }
   return;

  }
  if (t->Kind == kON_VAR_CLAUSE) {
/* line 692 "SetDefs.puma" */
  {
/* line 694 "SetDefs.puma" */
   MakeHomeDefs (t->ON_VAR_CLAUSE.ON_VAR);
  }
   return;

  }
/* line 697 "SetDefs.puma" */
  {
/* line 698 "SetDefs.puma" */
   failure_protocol (MODULE, "MakeOnClauseDefs", t);
  }
   return;

;
}

static void MakeHomeDefs
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kUSED_VAR) {
/* line 709 "SetDefs.puma" */
  {
/* line 710 "SetDefs.puma" */
   t = t->USED_VAR.VARNAME;
   goto yyRecursion;
  }

  }
  if (t->Kind == kDUMMY_VAR) {
/* line 713 "SetDefs.puma" */
   return;

  }
  if (t->Kind == kVAR_OBJ) {
/* line 716 "SetDefs.puma" */
  {
/* line 720 "SetDefs.puma" */
   SetHomeObject (t, GetGlobalObject (t->VAR_OBJ.Ident));
  }
   return;

  }
  if (t->Kind == kINDEXED_VAR) {
/* line 723 "SetDefs.puma" */
  {
/* line 725 "SetDefs.puma" */
   MakeHomeDefs (t->INDEXED_VAR.IND_VAR);
/* line 726 "SetDefs.puma" */
   MakeIndexDefs (t->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
/* line 729 "SetDefs.puma" */
  {
/* line 730 "SetDefs.puma" */
   error_protocol ("illegal home variable");
/* line 731 "SetDefs.puma" */
   tree_protocol ("home : ", t);
  }
   return;

;
}

static void SetSelectedCompObj
# if defined __STDC__ | defined __cplusplus
(register tTree sv, register tTree type)
# else
(sv, type)
 register tTree sv;
 register tTree type;
# endif
{
 yyRecursion:
  if (sv->Kind == kSELECTED_VAR) {
/* line 742 "SetDefs.puma" */
  {
/* line 744 "SetDefs.puma" */
   if (! ((type == NoTree))) goto yyL1;
  {
/* line 745 "SetDefs.puma" */
   error_protocol ("type of selected var unknown");
/* line 746 "SetDefs.puma" */
   tree_protocol ("selected var is : ", sv);
  }
  }
   return;
yyL1:;

  if (type->Kind == kTYPE_ID) {
/* line 749 "SetDefs.puma" */
  {
/* line 751 "SetDefs.puma" */
   if (! ((type->TYPE_ID.ID->TYPE_OBJ.Object == NoObject))) goto yyL2;
  {
/* line 752 "SetDefs.puma" */
   error_protocol ("no scope for type components found");
/* line 753 "SetDefs.puma" */
   tree_protocol ("record type is ", type);
  }
  }
   return;
yyL2:;

  if (type->TYPE_ID.ID->TYPE_OBJ.Object->Kind == kTypeObject) {
/* line 756 "SetDefs.puma" */
  {
/* line 759 "SetDefs.puma" */
   if (! ((type->TYPE_ID.ID->TYPE_OBJ.Object->TypeObject.Components == NoEntries))) goto yyL3;
  {
/* line 760 "SetDefs.puma" */
   error_protocol ("use of undefined type");
/* line 761 "SetDefs.puma" */
   tree_protocol ("variable is : ", sv);
/* line 762 "SetDefs.puma" */
   tree_protocol ("type is : ", type);
  }
  }
   return;
yyL3:;

/* line 765 "SetDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 770 "SetDefs.puma" */
   Obj = GetDeclEntry (sv->SELECTED_VAR.SELECTOR->REC_COMP.Ident, type->TYPE_ID.ID->TYPE_OBJ.Object->TypeObject.Components);
/* line 772 "SetDefs.puma" */
 if (Obj == NoObject)

       { char msg[150], comp[100];

         GetString (sv->SELECTED_VAR.SELECTOR->REC_COMP.Ident, comp);
         sprintf (msg, "component %s not in derived type", comp);
         error_protocol (msg);
         tree_protocol ("illegal selected var : ", sv);
       }

   
/* line 784 "SetDefs.puma" */
   sv->SELECTED_VAR.SELECTOR->REC_COMP.Object = Obj;
  }
   return;
 }

  }
/* line 787 "SetDefs.puma" */
  {
/* line 789 "SetDefs.puma" */
   tree_error_protocol ("no type object found", sv);
/* line 790 "SetDefs.puma" */
   tree_protocol ("type of the var is ", type);
  }
   return;

  }
  if (type->Kind == kARRAY_TYPE) {
/* line 793 "SetDefs.puma" */
  {
/* line 797 "SetDefs.puma" */
   type = type->ARRAY_TYPE.ARRAY_COMP_TYPE;
   goto yyRecursion;
  }

  }
/* line 800 "SetDefs.puma" */
  {
/* line 802 "SetDefs.puma" */
   error_protocol ("illegal type for selected variable");
/* line 803 "SetDefs.puma" */
   tree_protocol ("selected var = ", sv);
/* line 804 "SetDefs.puma" */
   tree_protocol ("type         = ", type);
  }
   return;

  }
;
}

static void MakeSubstring
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kINDEXED_VAR) {
  if (t->INDEXED_VAR.IND_EXPS->Kind == kBTE_LIST) {
  if (t->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (t->INDEXED_VAR.IND_EXPS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 816 "SetDefs.puma" */
  {
/* line 817 "SetDefs.puma" */
 t->INDEXED_VAR.IND_EXPS = t->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem;
    t->Kind = kSUBSTRING_VAR;
  
  }
   return;

  }
  }
  }
  }
/* line 822 "SetDefs.puma" */
  {
/* line 823 "SetDefs.puma" */
   tree_error_protocol ("indexed access to string illegal", t);
  }
   return;

;
}

static void MySetVarObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kVAR_OBJ) {
/* line 834 "SetDefs.puma" */
 {
  tTree type;
  {
/* line 836 "SetDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 842 "SetDefs.puma" */
   type = mDUMMY_TYPE ();
/* line 844 "SetDefs.puma" */
 t->VAR_OBJ.Object = GetLocalVarEntity (t->VAR_OBJ.Ident, t->VAR_OBJ.Pos, GetCurrentUnitObject ()); 
  }
  }
   return;
 }
yyL1:;

  if (obj->Kind == kVarObject) {
/* line 847 "SetDefs.puma" */
  {
/* line 849 "SetDefs.puma" */
 t->VAR_OBJ.Object = obj;
     SetObjUse (obj);
   
  }
   return;

  }
  if (obj->Kind == kNameListObject) {
/* line 854 "SetDefs.puma" */
  {
/* line 856 "SetDefs.puma" */
 t->VAR_OBJ.Object = obj; 
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
/* line 859 "SetDefs.puma" */
  {
/* line 861 "SetDefs.puma" */
   error_protocol ("template cannot be used as a variable");
/* line 862 "SetDefs.puma" */
   tree_protocol ("the template is : ", t);
  }
   return;

  }
  if (obj->Kind == kProcObject) {
/* line 865 "SetDefs.puma" */
  {
/* line 867 "SetDefs.puma" */
   error_protocol ("variable and not subroutine expected");
/* line 868 "SetDefs.puma" */
   tree_protocol ("the element is : ", t);
  }
   return;

  }
  if (obj->Kind == kFuncObject) {
  if (obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 871 "SetDefs.puma" */
  {
/* line 876 "SetDefs.puma" */
   if (! ((obj->FuncObject.decl->FUNC_DECL.RESULT_ID != DefaultId ()))) goto yyL6;
  {
/* line 878 "SetDefs.puma" */
   if (! ((GetLocalObject (obj->FuncObject.decl->FUNC_DECL.RESULT_ID) == GetDeclEntry (obj->FuncObject.decl->FUNC_DECL.RESULT_ID, obj->FuncObject.Declarations)))) goto yyL6;
  {
/* line 880 "SetDefs.puma" */
 t->VAR_OBJ.Ident  = obj->FuncObject.decl->FUNC_DECL.RESULT_ID;
     t->VAR_OBJ.Object = GetLocalObject (obj->FuncObject.decl->FUNC_DECL.RESULT_ID);
   
  }
  }
  }
   return;
yyL6:;

/* line 885 "SetDefs.puma" */
  {
/* line 888 "SetDefs.puma" */
   error_protocol ("assignment to function name only in the function");
/* line 889 "SetDefs.puma" */
   obj_error_protocol ("function object : ", obj);
  }
   return;

  }
  }
/* line 892 "SetDefs.puma" */
  {
/* line 893 "SetDefs.puma" */
   error_protocol ("variable expected");
/* line 894 "SetDefs.puma" */
   obj_protocol ("set object is : ", obj);
  }
   return;

  }
;
}

static void SetHomeObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kVAR_OBJ) {
/* line 905 "SetDefs.puma" */
  {
/* line 907 "SetDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 908 "SetDefs.puma" */
   error_protocol ("unknown home");
/* line 909 "SetDefs.puma" */
   tree_protocol ("home var : ", t);
  }
  }
   return;
yyL1:;

  if (obj->Kind == kVarObject) {
/* line 912 "SetDefs.puma" */
  {
/* line 914 "SetDefs.puma" */
 t->VAR_OBJ.Object = obj;
     SetObjUse (obj);
   
  }
   return;

  }
  if (obj->Kind == kTemplateObject) {
/* line 919 "SetDefs.puma" */
  {
/* line 921 "SetDefs.puma" */
 t->VAR_OBJ.Object = obj; 
  }
   return;

  }
/* line 924 "SetDefs.puma" */
  {
/* line 925 "SetDefs.puma" */
   error_protocol ("variable/template expected");
/* line 926 "SetDefs.puma" */
   obj_protocol ("set object is : ", obj);
  }
   return;

  }
;
}

static void SetObjUse
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
/* line 943 "SetDefs.puma" */
  {
/* line 945 "SetDefs.puma" */
 v->VarObject.uses->VarUse.ReadUse += 1; 
  }
   return;

;
}

tTree CheckExp
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
 yyRecursion:

  switch (exp->Kind) {
  case kDUMMY_EXP:
/* line 958 "SetDefs.puma" */
   return exp;

  case kCONST_EXP:
/* line 963 "SetDefs.puma" */
   return exp;

  case kARRAY_EXP:
/* line 968 "SetDefs.puma" */
  {
/* line 970 "SetDefs.puma" */
 if (HasNamedExp (exp->ARRAY_EXP.ELEMENTS))
        error_protocol ("named expression in array expression");
   
/* line 974 "SetDefs.puma" */
   MakeIndexDefs (exp->ARRAY_EXP.ELEMENTS);
  }
   return exp;

  case kSLICE_EXP:
/* line 978 "SetDefs.puma" */
  {
/* line 980 "SetDefs.puma" */
 exp->SLICE_EXP.FIRST = CheckExp (exp->SLICE_EXP.FIRST);
     exp->SLICE_EXP.STOP  = CheckExp (exp->SLICE_EXP.STOP);
     exp->SLICE_EXP.INC   = CheckExp (exp->SLICE_EXP.INC);
   
  }
   return exp;

  case kOP_EXP:
/* line 988 "SetDefs.puma" */
  {
/* line 990 "SetDefs.puma" */
 exp->OP_EXP.OPND1 = CheckExp (exp->OP_EXP.OPND1);
     exp->OP_EXP.OPND2 = CheckExp (exp->OP_EXP.OPND2);
   
  }
   return exp;

  case kOP1_EXP:
/* line 997 "SetDefs.puma" */
  {
/* line 999 "SetDefs.puma" */
 exp->OP1_EXP.OPND = CheckExp (exp->OP1_EXP.OPND); 
  }
   return exp;

  case kNAMED_EXP:
/* line 1004 "SetDefs.puma" */
  {
/* line 1006 "SetDefs.puma" */
 exp->NAMED_EXP.VAL = CheckExp (exp->NAMED_EXP.VAL); 
  }
   return exp;

  case kVAR_EXP:
  if (exp->VAR_EXP.V->Kind == kINDEXED_VAR) {
  if (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS->Kind == kBTE_LIST) {
  if (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS->BTE_LIST.Elem->Kind == kSLICE_EXP) {
  if (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS->BTE_LIST.Next->Kind == kBTE_EMPTY) {
/* line 1019 "SetDefs.puma" */
  {
/* line 1023 "SetDefs.puma" */
   MakeVarDefs (exp->VAR_EXP.V);
  }
   return exp;

  }
  }
  }
  if (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 1033 "SetDefs.puma" */
 {
  tDefinitions Obj;
  {
/* line 1040 "SetDefs.puma" */
   Obj = GetGlobalObject (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
/* line 1042 "SetDefs.puma" */
   if (! ((IsArrayVariable (Obj)))) goto yyL9;
  {
/* line 1044 "SetDefs.puma" */
   MySetVarObject (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME, Obj);
/* line 1046 "SetDefs.puma" */
 if (HasNamedExp (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS))
        error_protocol ("named expression as index");
   
/* line 1050 "SetDefs.puma" */
   MakeIndexDefs (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
  }
  }
   return exp;
 }
yyL9:;

/* line 1060 "SetDefs.puma" */
 {
  tDefinitions Obj;
  tTree e;
  {
/* line 1066 "SetDefs.puma" */
   Obj = GetGlobalObject (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
/* line 1068 "SetDefs.puma" */
   if (! ((Obj != NoObject))) goto yyL10;
  {
/* line 1069 "SetDefs.puma" */
   if (! ((Obj -> Kind == kTypeObject))) goto yyL10;
  {
/* line 1073 "SetDefs.puma" */
 if (HasNamedExp (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS))
        error_protocol ("named expression in type expression");
   
/* line 1077 "SetDefs.puma" */
   MakeIndexDefs (exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
/* line 1081 "SetDefs.puma" */
  e = mTYPE_OBJ (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident);
      e->TYPE_OBJ.Object = Obj;
      e = mTYPE_EXP (e, exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
   
  }
  }
  }
   return e;
 }
yyL10:;

/* line 1095 "SetDefs.puma" */
   exp = MakeFuncCall (exp->VAR_EXP.V->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Ident, exp->VAR_EXP.V->INDEXED_VAR.IND_EXPS);
   goto yyRecursion;

  }
  }
/* line 1104 "SetDefs.puma" */
  {
/* line 1108 "SetDefs.puma" */
   MakeVarDefs (exp->VAR_EXP.V);
  }
   return exp;

  case kFUNC_CALL_EXP:
/* line 1112 "SetDefs.puma" */
  {
/* line 1114 "SetDefs.puma" */
 exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Object = GetFuncObject (exp->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, GetCurrentUnitObject()); 
/* line 1116 "SetDefs.puma" */
   MakeParamDefs (exp->FUNC_CALL_EXP.FUNC_PARAMS);
  }
   return exp;

  case kDO_EXP:
/* line 1121 "SetDefs.puma" */
  {
/* line 1122 "SetDefs.puma" */
   MakeVarDefs (exp->DO_EXP.DO_ID);
/* line 1123 "SetDefs.puma" */
 exp->DO_EXP.RANGE = CheckExp (exp->DO_EXP.RANGE); 
/* line 1124 "SetDefs.puma" */
   MakeIndexDefs (exp->DO_EXP.BODY);
  }
   return exp;

  }

/* line 1128 "SetDefs.puma" */
  {
/* line 1129 "SetDefs.puma" */
   failure_protocol (MODULE, "CheckExp", exp);
  }
   return exp;

}

static rbool IsArrayVariable
# if defined __STDC__ | defined __cplusplus
(register tDefinitions Obj)
# else
(Obj)
 register tDefinitions Obj;
# endif
{
/* line 1147 "SetDefs.puma" */
  {
/* line 1149 "SetDefs.puma" */
   if (! ((Obj == NoObject))) goto yyL1;
  {
/* line 1150 "SetDefs.puma" */
   return rfalse;
  }
  }
yyL1:;

  if (Obj->Kind == kVarObject) {
/* line 1153 "SetDefs.puma" */
  {
/* line 1155 "SetDefs.puma" */
   if (! ((VarRank (Obj) > 0))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (Obj->Kind == kFuncObject) {
  if (Obj->FuncObject.decl->Kind == kFUNC_DECL) {
/* line 1158 "SetDefs.puma" */
  {
/* line 1161 "SetDefs.puma" */
   if (! ((Obj == GetCurrentUnitObject ()))) goto yyL3;
  {
/* line 1165 "SetDefs.puma" */
   if (! ((! Obj->FuncObject.decl->FUNC_DECL.HAS_RES_ID))) goto yyL3;
  {
/* line 1167 "SetDefs.puma" */
   if (! ((IsArrayVariable (GetDeclEntry (Obj->FuncObject.decl->FUNC_DECL.RESULT_ID, Obj->FuncObject.Declarations))))) goto yyL3;
  }
  }
  }
   return rtrue;
yyL3:;

  }
  }
  return rfalse;
}

static tTree ObjTypePtr
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
/* line 1184 "SetDefs.puma" */
   return v->VarObject.decl->VAR_DECL.VAL;

  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
/* line 1188 "SetDefs.puma" */
   return v->VarObject.decl->VAR_PARAM_DECL.VAL;

  }
/* line 1198 "SetDefs.puma" */
  {
/* line 1199 "SetDefs.puma" */
   failure_protocol ("SetDefs", "ObjTypePtr (VarObject)", v->VarObject.decl);
  }
   return NoTree;

  }
  if (v->Kind == kFuncObject) {
/* line 1194 "SetDefs.puma" */
   return NoTree;

  }
/* line 1203 "SetDefs.puma" */
  {
/* line 1204 "SetDefs.puma" */
   failure_protocol ("SetDefs", "ObjTypePtr", v->Object.decl);
  }
   return NoTree;

}

static tTree VarSelect
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree stype)
# else
(var, stype)
 register tTree var;
 register tTree stype;
# endif
{
/* line 1218 "SetDefs.puma" */
  {
/* line 1219 "SetDefs.puma" */
   if (! ((stype == NoTree))) goto yyL1;
  }
   return NoTree;
yyL1:;

  if (var->Kind == kINDEXED_VAR) {
  if (stype->Kind == kARRAY_TYPE) {
/* line 1223 "SetDefs.puma" */
   return stype->ARRAY_TYPE.ARRAY_COMP_TYPE;

  }
/* line 1227 "SetDefs.puma" */
   return NoTree;

  }
/* line 1231 "SetDefs.puma" */
  {
/* line 1232 "SetDefs.puma" */
   failure2_protocol (MODULE, "VarSelect", var, stype);
  }
   return stype;

}

static tTree MakeTypeExp
# if defined __STDC__ | defined __cplusplus
(register tIdent id, register tTree exps)
# else
(id, exps)
 register tIdent id;
 register tTree exps;
# endif
{
/* line 1244 "SetDefs.puma" */

tTree v;

/* line 1248 "SetDefs.puma" */
  {
/* line 1249 "SetDefs.puma" */
 v = mTYPE_OBJ (id);
      v->TYPE_OBJ.Object = GetGlobalObject (id);
      v = mTYPE_EXP (v, exps); 
  }
   return v;

}

void MakeTopologyDef
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
  if (spec->Kind == kPROCESSOR_ARRAY) {
/* line 1266 "SetDefs.puma" */
  {
/* line 1268 "SetDefs.puma" */
   SetTopologyObject (spec->PROCESSOR_ARRAY.TOPNAME, GetGlobalObject (spec->PROCESSOR_ARRAY.TOPNAME->TOP_OBJ.Ident));
  }
   return;

  }
  if (spec->Kind == kPROCESSOR_SUBSET) {
/* line 1271 "SetDefs.puma" */
  {
/* line 1273 "SetDefs.puma" */
 char top_str [50];
     char sub_top_str [55];

     

     GetString (spec->PROCESSOR_SUBSET.FULLTOP->TOP_OBJ.Ident, top_str);
     sprintf (sub_top_str, "%s_%d", top_str, SubTopCounter++);
     spec->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Ident = IsIdent (sub_top_str);
   
/* line 1283 "SetDefs.puma" */
   MakeIndexDefs (spec->PROCESSOR_SUBSET.SUBSCRIPTS);
/* line 1284 "SetDefs.puma" */
   SetTopologyObject (spec->PROCESSOR_SUBSET.FULLTOP, GetGlobalObject (spec->PROCESSOR_SUBSET.FULLTOP->TOP_OBJ.Ident));
/* line 1285 "SetDefs.puma" */
   MakeSubTopology (spec);
  }
   return;

  }
/* line 1288 "SetDefs.puma" */
  {
/* line 1290 "SetDefs.puma" */
   failure_protocol (MODULE, "MakeTopologyDef", spec);
  }
   return;

;
}

static void SetTopologyObject
# if defined __STDC__ | defined __cplusplus
(register tTree t, register tDefinitions obj)
# else
(t, obj)
 register tTree t;
 register tDefinitions obj;
# endif
{
  if (t->Kind == kTOP_OBJ) {
/* line 1301 "SetDefs.puma" */
  {
/* line 1303 "SetDefs.puma" */
   if (! ((obj == NoObject))) goto yyL1;
  {
/* line 1305 "SetDefs.puma" */
   error_protocol ("unknown processor arrangement");
  }
  }
   return;
yyL1:;

  if (obj->Kind == kTopologyObject) {
/* line 1308 "SetDefs.puma" */
  {
/* line 1312 "SetDefs.puma" */
 t->TOP_OBJ.Object = obj; 
  }
   return;

  }
/* line 1315 "SetDefs.puma" */
  {
/* line 1317 "SetDefs.puma" */
   error_protocol ("processor arrangement expected");
/* line 1318 "SetDefs.puma" */
   obj_protocol ("illegal object is : ", obj);
  }
   return;

  }
/* line 1321 "SetDefs.puma" */
  {
/* line 1323 "SetDefs.puma" */
   failure_protocol (MODULE, "SetTopologyObject", t);
  }
   return;

;
}

static void MakeSubTopology
# if defined __STDC__ | defined __cplusplus
(register tTree spec)
# else
(spec)
 register tTree spec;
# endif
{
  if (spec->Kind == kPROCESSOR_SUBSET) {
/* line 1328 "SetDefs.puma" */
  {
/* line 1330 "SetDefs.puma" */
 spec->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Object = MakeNewObject (spec, GetCurrentUnitObject ()); 
     InsertEntry (spec->PROCESSOR_SUBSET.SUBTOP->TOP_OBJ.Object);
   
  }
   return;

  }
;
}

void BeginSetDefs ARGS ((void))
{
}

void CloseSetDefs ARGS ((void))
{
}
