# include "Semantic.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 44 "Semantic.puma" */

# include "Idents.h"
# include "StringM.h"
# include "Types.h"
# include "protocol.h"

# include "Transform.h"  /* CombineACF */
# include "Rank.h"
# include "TreeOps.h"

# include "Objects.h"
# include "DefTable.h"

# include "SemDecls.h"  /* SemDefinitions, SemDeclarations */
# include "SemExp.h"    /* SemExp, SemExpList              */
# include "SemCalling.h"
# include "SemIntr.h"
# include "SemMap.h"
# include "SemParallel.h"
# include "SemReduction.h"  /* MakeReduceStmt */
# include "SemPreds.h"

# include "Nesting.h"   /* Inc/DecLoopNesting       */

# include "Loops.h"     /* ForallVarCheck, HasOuterParallelLoop */

# define MODULE "Semantic"

/*********************************************************************
*                                                                    * 
*  Global Data for Semantic Analysis                                 * 
*                                                                    * 
*********************************************************************/

static tTree current_unit;

   /*  current_unit needed to check:

       - no return statement in main program 
       - common is defined in main unit

   */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySemantic.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* Semantic_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Semantic, routine %s failed\n",
  yyFunction);
 Semantic_Exit ();
}

void Semantic ARGS ((tTree t));
static void BodyCheck ARGS ((tTree body, tTree unit));
static void SemanticWhere ARGS ((tTree t, int whererank));
static void SemanticElseWhere ARGS ((tTree t, int whererank));
static void SemanticIO ARGS ((tTree t));
static void SemIOParams ARGS ((tTree items, int intent));
static tTree MakeDoVar ARGS ((tTree DoExp));
static void CheckReduceParams ARGS ((tTree t));
static void FindStatusParameter ARGS ((tTree params, tTree * yyP2, tTree * yyP1));
static void CheckStatusParameter ARGS ((tTree status));
static void CheckNullifyParams ARGS ((tTree t));
static void CheckNullifyParam ARGS ((tTree t));
static void CheckAllocParam ARGS ((tTree var));
static void CheckAllocateParams ARGS ((tTree t));
static void NormalAllocateParams ARGS ((tTree t));
static void CheckDeallocParameter ARGS ((tTree var));
static void CheckDeallocateParams ARGS ((tTree t));
static rbool IsVarArgument ARGS ((tTree t));
static void SemCaseAlternatives ARGS ((tTree alts, tTree case_exp));
static void SemCaseValueRanges ARGS ((tTree explist, tTree case_exp));
static void SemCaseValueRange ARGS ((tTree case_value, tTree case_exp));
static void SemCaseValue ARGS ((tTree case_value, tTree case_exp));
static void SemDoRange ARGS ((tTree range));

void Semantic
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:

  switch (t->Kind) {
  case kCOMP_UNIT:
/* line 97 "Semantic.puma" */
  {
/* line 99 "Semantic.puma" */
   Semantic (t->COMP_UNIT.USED_ELEMENTS);
/* line 100 "Semantic.puma" */
   t = t->COMP_UNIT.COMP_ELEMENTS;
   goto yyRecursion;
  }

  case kUNIT_EMPTY:
/* line 103 "Semantic.puma" */
   return;

  case kUNIT_LIST:
/* line 106 "Semantic.puma" */
  {
/* line 108 "Semantic.puma" */
   set_protocol_unit (t->UNIT_LIST.Elem);
/* line 109 "Semantic.puma" */
   current_unit = t->UNIT_LIST.Elem;
/* line 110 "Semantic.puma" */
   Semantic (t->UNIT_LIST.Elem);
/* line 111 "Semantic.puma" */
   t = t->UNIT_LIST.Next;
   goto yyRecursion;
  }

  case kPROGRAM_DECL:
/* line 123 "Semantic.puma" */
  {
/* line 125 "Semantic.puma" */
   NestOpenUnit (t);
/* line 126 "Semantic.puma" */
   SemDefinitions (GetCurrentScope ());
/* line 127 "Semantic.puma" */
   Semantic (t->PROGRAM_DECL.PROGRAM_BODY);
/* line 128 "Semantic.puma" */
   NestCloseUnit (t);
  }
   return;

  case kPROC_DECL:
/* line 131 "Semantic.puma" */
  {
/* line 133 "Semantic.puma" */
   NestOpenUnit (t);
/* line 134 "Semantic.puma" */
   SemDefinitions (GetCurrentScope ());
/* line 135 "Semantic.puma" */
   Semantic (t->PROC_DECL.PROC_BODY);
/* line 136 "Semantic.puma" */
   NestCloseUnit (t);
  }
   return;

  case kFUNC_DECL:
/* line 139 "Semantic.puma" */
  {
/* line 141 "Semantic.puma" */
   NestOpenUnit (t);
/* line 142 "Semantic.puma" */
   SemDefinitions (GetCurrentScope ());
/* line 143 "Semantic.puma" */
   Semantic (t->FUNC_DECL.FUNC_BODY);
/* line 144 "Semantic.puma" */
   NestCloseUnit (t);
  }
   return;

  case kMODULE_DECL:
/* line 147 "Semantic.puma" */
  {
/* line 149 "Semantic.puma" */
   NestOpenUnit (t);
/* line 150 "Semantic.puma" */
   SemDefinitions (GetCurrentScope ());
/* line 151 "Semantic.puma" */
   Semantic (t->MODULE_DECL.MODULE_BODY);
/* line 152 "Semantic.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBLOCK_DATA_DECL:
/* line 155 "Semantic.puma" */
  {
/* line 157 "Semantic.puma" */
   NestOpenUnit (t);
/* line 158 "Semantic.puma" */
   SemDefinitions (GetCurrentScope ());
/* line 159 "Semantic.puma" */
   Semantic (t->BLOCK_DATA_DECL.DATA_BODY);
/* line 160 "Semantic.puma" */
   NestCloseUnit (t);
  }
   return;

  case kBODY_NODE:
/* line 173 "Semantic.puma" */
  {
/* line 175 "Semantic.puma" */
   BodyCheck (t, current_unit);
/* line 176 "Semantic.puma" */
   SemDeclarations (t->BODY_NODE.DECLS, current_unit);
/* line 177 "Semantic.puma" */
   Semantic (t->BODY_NODE.STATS);
/* line 178 "Semantic.puma" */
   t = t->BODY_NODE.INTERNALS;
   goto yyRecursion;
  }

  case kACF_LIST:
/* line 187 "Semantic.puma" */
  {
/* line 189 "Semantic.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 190 "Semantic.puma" */
   Semantic (t->ACF_LIST.Elem);
/* line 191 "Semantic.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 194 "Semantic.puma" */
   return;

  case kACF_DUMMY:
/* line 197 "Semantic.puma" */
   return;

  case kACF_BASIC:
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 200 "Semantic.puma" */
  {
/* line 204 "Semantic.puma" */
 t->ACF_BASIC.BASIC_STMT = SemAssignment (t->ACF_BASIC.BASIC_STMT); 
  }
   return;

  }
  if (t->ACF_BASIC.BASIC_STMT->Kind == kATOMIC_STMT) {
/* line 207 "Semantic.puma" */
 {
  tTree new_assign;
  {
/* line 213 "Semantic.puma" */
 t->ACF_BASIC.BASIC_STMT->Kind = kASSIGN_STMT;
     t->ACF_BASIC.BASIC_STMT = SemAssignment (t->ACF_BASIC.BASIC_STMT);
     t->ACF_BASIC.BASIC_STMT = MakeReduceStmt (t->ACF_BASIC.BASIC_STMT);
   
  }
   return;
 }

  }
/* line 219 "Semantic.puma" */
  {
/* line 221 "Semantic.puma" */
   t = t->ACF_BASIC.BASIC_STMT;
   goto yyRecursion;
  }

  case kACF_IF:
/* line 224 "Semantic.puma" */
  {
/* line 226 "Semantic.puma" */
 t->ACF_IF.IF_EXP = SemExpression (t->ACF_IF.IF_EXP);

     if (!ScalarLogicalExpr (t->ACF_IF.IF_EXP))
        error_protocol ("no scalar rbool expression in if statement");
   
/* line 232 "Semantic.puma" */
   Semantic (t->ACF_IF.THEN_PART);
/* line 233 "Semantic.puma" */
   t = t->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_WHERE:
/* line 236 "Semantic.puma" */
 {
  int whererank;
  {
/* line 240 "Semantic.puma" */
 t->ACF_WHERE.WHERE_EXP = SemExpression (t->ACF_WHERE.WHERE_EXP);

     if (!LogicalExpr (t->ACF_WHERE.WHERE_EXP))
        error_protocol ("expression in WHERE must be logical");

     whererank = TreeRank (t->ACF_WHERE.WHERE_EXP);

     if (whererank > 0)

         { SemanticWhere     (t->ACF_WHERE.TRUE_PART, whererank);
           SemanticElseWhere (t->ACF_WHERE.FALSE_PART, whererank);
         }
        else
         error_protocol ("Illegal Rank of Expression in WHERE");
    
  }
   return;
 }

  case kACF_CASE:
/* line 257 "Semantic.puma" */
  {
/* line 259 "Semantic.puma" */
 t->ACF_CASE.CASE_EXP = SemExpression (t->ACF_CASE.CASE_EXP);

     if (!ScalarCaseExpr (t->ACF_CASE.CASE_EXP))
        error_protocol ("scalar numeric expression in CASE required");
   
/* line 265 "Semantic.puma" */
   SemCaseAlternatives (t->ACF_CASE.CASE_ALTS, t->ACF_CASE.CASE_EXP);
  }
   return;

  case kACF_LOOP:
/* line 268 "Semantic.puma" */
  {
/* line 270 "Semantic.puma" */
   t = t->ACF_LOOP.LOOP_BODY;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 273 "Semantic.puma" */
  {
/* line 275 "Semantic.puma" */
 t->ACF_WHILE.WHILE_EXP = SemExpression (t->ACF_WHILE.WHILE_EXP);

     if (!ScalarLogicalExpr (t->ACF_WHILE.WHILE_EXP))
        error_protocol ("no scalar rbool expression in do while statement");
   
/* line 281 "Semantic.puma" */
   t = t->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;
  }

  case kACF_FORALL:
/* line 284 "Semantic.puma" */
  {
/* line 286 "Semantic.puma" */
   IncLoopNesting (t);
/* line 288 "Semantic.puma" */
   SemVariable (t->ACF_FORALL.FORALL_ID);
/* line 290 "Semantic.puma" */
 if (!ScalarIntVariable (t->ACF_FORALL.FORALL_ID))
        error_protocol ("id in FORALL must be scalar integer variable");
   
/* line 294 "Semantic.puma" */
 t->ACF_FORALL.FORALL_RANGE = SemExpression (t->ACF_FORALL.FORALL_RANGE);   
/* line 296 "Semantic.puma" */
   Semantic (t->ACF_FORALL.FORALL_BODY);
/* line 298 "Semantic.puma" */
   SemParallel (t);
/* line 300 "Semantic.puma" */
   DecLoopNesting (t);
  }
   return;

  case kACF_DO:
/* line 303 "Semantic.puma" */
  {
/* line 305 "Semantic.puma" */
   IncLoopNesting (t);
/* line 307 "Semantic.puma" */
   SemVariable (t->ACF_DO.DO_ID);
/* line 309 "Semantic.puma" */
 if (!DoVariable (t->ACF_DO.DO_ID))
        error_protocol ("id in DO must be scalar int/real/double variable");
   
/* line 313 "Semantic.puma" */
   SemDoRange (t->ACF_DO.DO_RANGE);
/* line 314 "Semantic.puma" */
   Semantic (t->ACF_DO.DO_BODY);
/* line 315 "Semantic.puma" */
   SemParallel (t);
/* line 317 "Semantic.puma" */
   DecLoopNesting (t);
  }
   return;

  case kACF_ENTRY:
/* line 320 "Semantic.puma" */
  {
/* line 322 "Semantic.puma" */
   error_protocol ("ENTRY not supported");
  }
   return;

  case kACF_HOME:
/* line 325 "Semantic.puma" */
  {
/* line 327 "Semantic.puma" */
   Semantic (t->ACF_HOME.HOME_BODY);
/* line 329 "Semantic.puma" */
   SemParallel (t);
  }
   return;

  case kACF_RESIDENT:
/* line 332 "Semantic.puma" */
  {
/* line 334 "Semantic.puma" */
   Semantic (t->ACF_RESIDENT.RESIDENT_BODY);
/* line 336 "Semantic.puma" */
   SemParallel (t);
  }
   return;

  case kACF_NEW:
/* line 339 "Semantic.puma" */
  {
/* line 341 "Semantic.puma" */
   Semantic (t->ACF_NEW.NEW_BODY);
/* line 343 "Semantic.puma" */
   SemParallel (t);
  }
   return;

  case kACF_REDUCTION:
/* line 346 "Semantic.puma" */
  {
/* line 348 "Semantic.puma" */
   Semantic (t->ACF_REDUCTION.REDUCTION_BODY);
/* line 350 "Semantic.puma" */
   SemParallel (t);
  }
   return;

  case kACF_TASK_REGION:
/* line 353 "Semantic.puma" */
  {
/* line 355 "Semantic.puma" */
   Semantic (t->ACF_TASK_REGION.TASK_BODY);
/* line 357 "Semantic.puma" */
   SemParallel (t);
  }
   return;

  case kASSIGN_STMT:
/* line 360 "Semantic.puma" */
  {
/* line 362 "Semantic.puma" */
   failure_protocol (MODULE, "Semantic", t);
  }
   return;

  case kPTR_ASSIGN_STMT:
  if (t->PTR_ASSIGN_STMT.ASSIGN_EXP->Kind == kVAR_EXP) {
/* line 365 "Semantic.puma" */
   return;

  }
  if (t->PTR_ASSIGN_STMT.ASSIGN_EXP->Kind == kFUNC_CALL_EXP) {
/* line 371 "Semantic.puma" */
   return;

  }
/* line 377 "Semantic.puma" */
  {
/* line 379 "Semantic.puma" */
   error_protocol ("illegal pointer assignment");
  }
   return;

  case kLABEL_ASSIGN_STMT:
/* line 382 "Semantic.puma" */
  {
/* line 384 "Semantic.puma" */
   SemVariable (t->LABEL_ASSIGN_STMT.LABEL_VAR);
/* line 386 "Semantic.puma" */
 if (!ScalarIntVariable (t->LABEL_ASSIGN_STMT.LABEL_VAR))
        error_protocol ("not scalar integer variable in assign statement");
   
  }
   return;

  case kFORMAT_STMT:
/* line 391 "Semantic.puma" */
   return;

  case kIO_STMT:
/* line 394 "Semantic.puma" */
  {
/* line 396 "Semantic.puma" */
   SemanticIO (t);
  }
   return;

  case kCALL_STMT:
/* line 399 "Semantic.puma" */
  {
/* line 401 "Semantic.puma" */
   if (! ((t->CALL_STMT.CALL_ID->PROC_OBJ.Object == GetIntrinsicObject (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident)))) goto yyL36;
  {
/* line 405 "Semantic.puma" */
   SemParamList (t->CALL_STMT.CALL_PARAMS);
/* line 406 "Semantic.puma" */
   SemCalling (t);
/* line 408 "Semantic.puma" */
   SemIntrinsicSubroutine (t->CALL_STMT.CALL_ID->PROC_OBJ.Ident, t->CALL_STMT.CALL_PARAMS);
  }
  }
   return;
yyL36:;

/* line 411 "Semantic.puma" */
  {
/* line 415 "Semantic.puma" */
   SemParamList (t->CALL_STMT.CALL_PARAMS);
/* line 417 "Semantic.puma" */
 t->CALL_STMT.CALL_ID->PROC_OBJ.Object = IdentifyGenericRoutine (t, t->CALL_STMT.CALL_ID->PROC_OBJ.Object); 
/* line 419 "Semantic.puma" */
   SemParamList (t->CALL_STMT.CALL_PARAMS);
/* line 420 "Semantic.puma" */
   SemCalling (t);
  }
   return;

  case kGOTO_STMT:
/* line 423 "Semantic.puma" */
   return;

  case kASS_GOTO_STMT:
/* line 426 "Semantic.puma" */
  {
/* line 428 "Semantic.puma" */
   SemVariable (t->ASS_GOTO_STMT.GOTO_VAR);
/* line 430 "Semantic.puma" */
 if (!ScalarIntVariable (t->ASS_GOTO_STMT.GOTO_VAR))
        error_protocol ("not scalar integer variable in assigned goto stmt");
   
  }
   return;

  case kCOMP_GOTO_STMT:
/* line 435 "Semantic.puma" */
  {
/* line 437 "Semantic.puma" */
 t->COMP_GOTO_STMT.GOTO_EXP = SemExpression (t->COMP_GOTO_STMT.GOTO_EXP);

     if (!ScalarExpr (t->COMP_GOTO_STMT.GOTO_EXP))
        error_protocol ("not scalar expression in computed-goto-stmt");
   
  }
   return;

  case kCOMP_IF_STMT:
/* line 444 "Semantic.puma" */
  {
/* line 446 "Semantic.puma" */
 t->COMP_IF_STMT.IF_EXP = SemExpression (t->COMP_IF_STMT.IF_EXP);

     if (!ScalarNumExpr (t->COMP_IF_STMT.IF_EXP))
        error_protocol ("not scalar num expression in arithmetic if stmt");
   
  }
   return;

  case kSTOP_STMT:
/* line 453 "Semantic.puma" */
   return;

  case kPAUSE_STMT:
/* line 456 "Semantic.puma" */
   return;

  case kEXIT_STMT:
/* line 459 "Semantic.puma" */
   return;

  case kCYCLE_STMT:
/* line 462 "Semantic.puma" */
   return;

  case kRETURN_STMT:
/* line 465 "Semantic.puma" */
  {
/* line 467 "Semantic.puma" */
 t->RETURN_STMT.RETURN_EXP = SemExpression (t->RETURN_STMT.RETURN_EXP);

     if (!ScalarIntExpr (t->RETURN_STMT.RETURN_EXP))
        error_protocol ("not scalar integer expression in RETURN");

     if (current_unit->Kind == kPROGRAM_DECL)
        error_protocol ("RETURN not permitted in main program");
   
  }
   return;

  case kREDUCE_STMT:
/* line 477 "Semantic.puma" */
  {
/* line 479 "Semantic.puma" */
 

       if (!HasOuterParallelLoop ())
         error_protocol ("REDUCE only in parallel loops allowed");
       else
       { 
         if (    (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident != IsIdent("MINVAL"))
              && (t->REDUCE_STMT.RED_FUNC->PROC_OBJ.Ident != IsIdent("MAXVAL"))  
              && (TreeListLength (t->REDUCE_STMT.RED_PARAMS) > 2  )   )
           error_protocol ("REDUCE with too many parameters");
         CheckReduceParams (t->REDUCE_STMT.RED_PARAMS);
       }
    
  }
   return;

  case kALLOCATE_STMT:
/* line 494 "Semantic.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 496 "Semantic.puma" */
   FindStatusParameter (t->ALLOCATE_STMT.PARAMS, & yyV1, & yyV2);
/* line 497 "Semantic.puma" */
 t->ALLOCATE_STMT.STATUS = yyV2; 
      t->ALLOCATE_STMT.PARAMS = yyV1;
    
/* line 500 "Semantic.puma" */
   CheckAllocateParams (t->ALLOCATE_STMT.PARAMS);
/* line 501 "Semantic.puma" */
   CheckStatusParameter (t->ALLOCATE_STMT.STATUS);
  }
   return;
 }

  case kDEALLOCATE_STMT:
/* line 504 "Semantic.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 506 "Semantic.puma" */
   FindStatusParameter (t->DEALLOCATE_STMT.PARAMS, & yyV1, & yyV2);
/* line 507 "Semantic.puma" */
 t->DEALLOCATE_STMT.STATUS = yyV2; 
      t->DEALLOCATE_STMT.PARAMS = yyV1;
    
/* line 510 "Semantic.puma" */
   CheckDeallocateParams (t->DEALLOCATE_STMT.PARAMS);
/* line 511 "Semantic.puma" */
   CheckStatusParameter (t->DEALLOCATE_STMT.STATUS);
  }
   return;
 }

  case kNULLIFY_STMT:
/* line 514 "Semantic.puma" */
  {
/* line 515 "Semantic.puma" */
   CheckNullifyParams (t->NULLIFY_STMT.PARAMS);
  }
   return;

  case kREALIGN_STMT:
/* line 518 "Semantic.puma" */
  {
/* line 520 "Semantic.puma" */
 t->REALIGN_STMT.distribution = EvalAlignmentStmt (t); 
  }
   return;

  case kREDISTRIBUTE_STMT:
/* line 523 "Semantic.puma" */
  {
/* line 525 "Semantic.puma" */
   SemTopology (t->REDISTRIBUTE_STMT.TARGET);
/* line 527 "Semantic.puma" */
 t->REDISTRIBUTE_STMT.distribution = EvalDistributionStmt (t); 
  }
   return;

  }

/* line 530 "Semantic.puma" */
  {
/* line 531 "Semantic.puma" */
   failure_protocol (MODULE, "Semantic", t);
  }
   return;

;
}

static void BodyCheck
# if defined __STDC__ | defined __cplusplus
(register tTree body, register tTree unit)
# else
(body, unit)
 register tTree body;
 register tTree unit;
# endif
{
  if (body->Kind == kBODY_NODE) {
  if (body->BODY_NODE.STATS->Kind == kACF_EMPTY) {
  if (unit->Kind == kMODULE_DECL) {
/* line 547 "Semantic.puma" */
   return;

  }
  }
  if (unit->Kind == kMODULE_DECL) {
/* line 550 "Semantic.puma" */
  {
/* line 552 "Semantic.puma" */
   simple_error_protocol ("statements in MODULE not allowed");
  }
   return;

  }
  if (body->BODY_NODE.STATS->Kind == kACF_EMPTY) {
  if (body->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
  if (unit->Kind == kBLOCK_DATA_DECL) {
/* line 555 "Semantic.puma" */
   return;

  }
  }
  }
  if (body->BODY_NODE.INTERNALS->Kind == kUNIT_EMPTY) {
  if (unit->Kind == kBLOCK_DATA_DECL) {
/* line 560 "Semantic.puma" */
  {
/* line 561 "Semantic.puma" */
   simple_error_protocol ("statements in BLOCK_DATA not allowed");
  }
   return;

  }
  }
  if (unit->Kind == kBLOCK_DATA_DECL) {
/* line 564 "Semantic.puma" */
  {
/* line 565 "Semantic.puma" */
   simple_error_protocol ("internal subroutines in BLOCK_DATA not allowed");
  }
   return;

  }
  }
;
}

static void SemanticWhere
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int whererank)
# else
(t, whererank)
 register tTree t;
 register int whererank;
# endif
{
/* line 579 "Semantic.puma" */

char string[50];

 yyRecursion:
  if (t->Kind == kACF_LIST) {
/* line 583 "Semantic.puma" */
  {
/* line 584 "Semantic.puma" */
   set_protocol_stmt (t->ACF_LIST.Elem);
/* line 585 "Semantic.puma" */
   SemanticWhere (t->ACF_LIST.Elem, whererank);
/* line 586 "Semantic.puma" */
   t = t->ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kACF_EMPTY) {
/* line 589 "Semantic.puma" */
   return;

  }
  if (t->Kind == kACF_BASIC) {
  if (t->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 592 "Semantic.puma" */
 {
  int rank_lhs;
  int rank_rhs;
  {
/* line 597 "Semantic.puma" */
   SemVariable (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
/* line 599 "Semantic.puma" */
 t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP = SemExpression (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

     rank_lhs = TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
     rank_rhs = TreeRank (t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);

     if (rank_lhs != whererank)
      { error_protocol ("Assignment in WHERE has wrong rank");
        sprintf (string, "Rank of LHS = %d : " , rank_lhs);
        tree_protocol (string, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
        sprintf (string, "Rank of WHERE exp = %d : " , whererank);
        tree_protocol (string, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
      }
     if (rank_rhs > 0)
      { if (rank_lhs != rank_rhs)
         { error_protocol ("LHS and RHS have different rank");
           sprintf (string, "Rank of LHS = %d : " , rank_lhs);
           tree_protocol (string, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
           sprintf (string, "Rank of RHS = %d : " , rank_rhs);
           tree_protocol (string, t->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
         }
      }
   
  }
   return;
 }

  }
  }
  if (t->Kind == kACF_WHERE) {
/* line 623 "Semantic.puma" */
  {
/* line 624 "Semantic.puma" */
   error_protocol ("Nesting of WHERE not allowed until now");
  }
   return;

  }
/* line 627 "Semantic.puma" */
  {
/* line 628 "Semantic.puma" */
   error_protocol ("Illegal Statement in WHERE");
  }
   return;

;
}

static void SemanticElseWhere
# if defined __STDC__ | defined __cplusplus
(register tTree t, register int whererank)
# else
(t, whererank)
 register tTree t;
 register int whererank;
# endif
{
  if (t->Kind == kACF_LIST) {
  if (t->ACF_LIST.Elem->Kind == kACF_WHERE) {
  if (t->ACF_LIST.Next->Kind == kACF_EMPTY) {
/* line 642 "Semantic.puma" */
   return;

  }
  }
  }
/* line 645 "Semantic.puma" */
  {
/* line 647 "Semantic.puma" */
   SemanticWhere (t, whererank);
  }
   return;

;
}

static void SemanticIO
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kIO_STMT) {
/* line 658 "Semantic.puma" */
  {
/* line 660 "Semantic.puma" */
   if (! (((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("PRINT")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("WRITE"))))) goto yyL1;
  {
/* line 662 "Semantic.puma" */
   SemParamList (t->IO_STMT.IO_ITEMS);
/* line 663 "Semantic.puma" */
   SemIOParams (t->IO_STMT.IO_ITEMS, IntentIn);
  }
  }
   return;
yyL1:;

/* line 666 "Semantic.puma" */
  {
/* line 668 "Semantic.puma" */
   if (! ((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("READ")))) goto yyL2;
  {
/* line 670 "Semantic.puma" */
   SemParamList (t->IO_STMT.IO_ITEMS);
/* line 671 "Semantic.puma" */
   SemIOParams (t->IO_STMT.IO_ITEMS, IntentOut);
  }
  }
   return;
yyL2:;

/* line 674 "Semantic.puma" */
  {
/* line 676 "Semantic.puma" */
   if (! (((t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("OPEN")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("CLOSE")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("REWIND")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("BACKSPACE")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("INQUIRE")) || (t->IO_STMT.ID->PROC_OBJ.Ident == IsIdent ("ENDFILE"))))) goto yyL3;
  {
/* line 684 "Semantic.puma" */
   SemIOParams (t->IO_STMT.IO_ITEMS, IntentIn);
  }
  }
   return;
yyL3:;

/* line 687 "Semantic.puma" */
  {
/* line 689 "Semantic.puma" */
   error_protocol ("unknown I/O operation");
  }
   return;

  }
/* line 692 "Semantic.puma" */
  {
/* line 693 "Semantic.puma" */
   failure_protocol (MODULE, "SemanticIO", t);
  }
   return;

;
}

static void SemIOParams
# if defined __STDC__ | defined __cplusplus
(register tTree items, register int intent)
# else
(items, intent)
 register tTree items;
 register int intent;
# endif
{
 yyRecursion:
  if (items->Kind == kBTP_LIST) {
/* line 708 "Semantic.puma" */
  {
/* line 710 "Semantic.puma" */
   SemIOParams (items->BTP_LIST.Elem, intent);
/* line 711 "Semantic.puma" */
   items = items->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (items->Kind == kBTP_EMPTY) {
/* line 714 "Semantic.puma" */
   return;

  }
  if (items->Kind == kVAR_PARAM) {
  if (items->VAR_PARAM.V->Kind == kADDR) {
  if (items->VAR_PARAM.V->ADDR.E->Kind == kDO_EXP) {
/* line 717 "Semantic.puma" */
  {
/* line 719 "Semantic.puma" */
   if (! ((intent == IntentOut))) goto yyL3;
  {
/* line 723 "Semantic.puma" */
 items->VAR_PARAM.V = MakeDoVar (items->VAR_PARAM.V->ADDR.E); 
/* line 725 "Semantic.puma" */
   CheckIntention (items, intent);
  }
  }
   return;
yyL3:;

  }
  }
/* line 728 "Semantic.puma" */
  {
/* line 730 "Semantic.puma" */
   CheckIntention (items, intent);
  }
   return;

  }
/* line 733 "Semantic.puma" */
  {
/* line 735 "Semantic.puma" */
   error_protocol ("Cannot handle this READ parameter");
/* line 736 "Semantic.puma" */
   tree_protocol ("Parameter is ", items);
  }
   return;

;
}

static tTree MakeDoVar
# if defined __STDC__ | defined __cplusplus
(register tTree DoExp)
# else
(DoExp)
 register tTree DoExp;
# endif
{
  if (DoExp->Kind == kDO_EXP) {
/* line 747 "Semantic.puma" */
   return mDO_VAR (DoExp->DO_EXP.DO_ID, DoExp->DO_EXP.RANGE, MakeDoVar (DoExp->DO_EXP.BODY));

  }
  if (DoExp->Kind == kBTE_LIST) {
  if (DoExp->BTE_LIST.Elem->Kind == kVAR_EXP) {
/* line 751 "Semantic.puma" */
   return mBTV_LIST (DoExp->BTE_LIST.Elem->VAR_EXP.V, MakeDoVar (DoExp->BTE_LIST.Next));

  }
  if (DoExp->BTE_LIST.Elem->Kind == kDO_EXP) {
/* line 756 "Semantic.puma" */
   return mBTV_LIST (MakeDoVar (DoExp->BTE_LIST.Elem), MakeDoVar (DoExp->BTE_LIST.Next));

  }
/* line 760 "Semantic.puma" */
  {
/* line 762 "Semantic.puma" */
   error_protocol ("Illegal READ parameter in implied DO loop");
/* line 763 "Semantic.puma" */
   tree_protocol ("Expression is : ", DoExp->BTE_LIST.Elem);
  }
   return mBTV_LIST (mADDR (DoExp->BTE_LIST.Elem), MakeDoVar (DoExp->BTE_LIST.Next));

  }
  if (DoExp->Kind == kBTE_EMPTY) {
/* line 767 "Semantic.puma" */
   return mBTV_EMPTY ();

  }
 yyAbort ("MakeDoVar");
 { tTree yyDummy; return yyDummy; }
}

static void CheckReduceParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_EMPTY) {
/* line 781 "Semantic.puma" */
   return;

  }
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Next->Kind == kBTP_LIST) {
/* line 784 "Semantic.puma" */
  {
/* line 786 "Semantic.puma" */
 if (!IsVarArgument (t->BTP_LIST.Elem))
       { error_protocol ("Variable required for reduce");
         tree_protocol ("This parameter is not a variable : ", t->BTP_LIST.Elem);
       }
   
/* line 792 "Semantic.puma" */
   SemParameter (t->BTP_LIST.Elem);
/* line 793 "Semantic.puma" */
   SemParameter (t->BTP_LIST.Next->BTP_LIST.Elem);
/* line 795 "Semantic.puma" */
 if (TreeRank (t->BTP_LIST.Elem) != 0)
       { error_protocol ("only scalar variable in reduce");
         tree_protocol ("this variable is not scalar : ", t->BTP_LIST.Elem);
       }

     if (TreeRank (t->BTP_LIST.Next->BTP_LIST.Elem) != 0)
       { error_protocol ("only scalar expression in reduce");
         tree_protocol ("this expression is not scalar : ", t->BTP_LIST.Next->BTP_LIST.Elem);
       }
   
/* line 805 "Semantic.puma" */
   t = t->BTP_LIST.Next->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  }
/* line 808 "Semantic.puma" */
  {
/* line 809 "Semantic.puma" */
   error_protocol ("Illegal parameter list for REDUCE");
/* line 810 "Semantic.puma" */
   print_protocol ("REDUCE (f, var, exp, var, exp, ..., var, exp)");
  }
   return;

;
}

static void FindStatusParameter
# if defined __STDC__ | defined __cplusplus
(register tTree params, register tTree * yyP2, register tTree * yyP1)
# else
(params, yyP2, yyP1)
 register tTree params;
 register tTree * yyP2;
 register tTree * yyP1;
# endif
{
  if (params->Kind == kBTP_EMPTY) {
/* line 821 "Semantic.puma" */
   * yyP2 = params;
   * yyP1 = mDUMMY_VAR ();
   return;

  }
  if (params->Kind == kBTP_LIST) {
  if (params->BTP_LIST.Elem->Kind == kNAMED_PARAM) {
  if (params->BTP_LIST.Elem->NAMED_PARAM.VAL->Kind == kVAR_PARAM) {
  if (params->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 824 "Semantic.puma" */
  {
/* line 825 "Semantic.puma" */
   if (! ((params->BTP_LIST.Elem->NAMED_PARAM.Name == IsIdent ("STAT", 4)))) goto yyL2;
  }
   * yyP2 = params->BTP_LIST.Next;
   * yyP1 = params->BTP_LIST.Elem->NAMED_PARAM.VAL->VAR_PARAM.V;
   return;
yyL2:;

  }
  }
  }
/* line 828 "Semantic.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 829 "Semantic.puma" */
   FindStatusParameter (params->BTP_LIST.Next, & yyV1, & yyV2);
/* line 830 "Semantic.puma" */
 params->BTP_LIST.Next = yyV1; 
  }
   * yyP2 = params;
   * yyP1 = yyV2;
   return;
 }

  }
/* line 833 "Semantic.puma" */
  {
/* line 834 "Semantic.puma" */
   failure_protocol (MODULE, "FindStatusParameter", params);
  }
   * yyP2 = NoTree;
   * yyP1 = NoTree;
   return;

;
}

static void CheckStatusParameter
# if defined __STDC__ | defined __cplusplus
(register tTree status)
# else
(status)
 register tTree status;
# endif
{
  if (status->Kind == kDUMMY_VAR) {
/* line 839 "Semantic.puma" */
   return;

  }
/* line 844 "Semantic.puma" */
  {
/* line 846 "Semantic.puma" */
 if (!ScalarIntVariable (status))
        error_protocol ("status in ALLOCATE/DEALLOCATE must be scalar integer");
   
  }
   return;

;
}

static void CheckNullifyParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_LIST) {
/* line 859 "Semantic.puma" */
  {
/* line 861 "Semantic.puma" */
   SemParameter (t->BTP_LIST.Elem);
/* line 862 "Semantic.puma" */
   CheckNullifyParam (t->BTP_LIST.Elem);
/* line 863 "Semantic.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  if (t->Kind == kBTP_EMPTY) {
/* line 866 "Semantic.puma" */
   return;

  }
;
}

static void CheckNullifyParam
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
/* line 871 "Semantic.puma" */
  {
/* line 872 "Semantic.puma" */
   error_protocol ("illegal parameter for nullify");
  }
   return;

  }
/* line 875 "Semantic.puma" */
  {
/* line 877 "Semantic.puma" */
 if (!PointerObject (t->VAR_PARAM.V))
       error_protocol ("NULLIFY can only be appled to pointer variables");
  
  }
   return;

  }
/* line 882 "Semantic.puma" */
  {
/* line 883 "Semantic.puma" */
   error_protocol ("illegal parameter for nullify");
  }
   return;

;
}

static void CheckAllocParam
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kADDR) {
/* line 894 "Semantic.puma" */
  {
/* line 895 "Semantic.puma" */
   error_protocol ("expressions not allowed in ALLOCATE");
/* line 896 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 899 "Semantic.puma" */
  {
/* line 901 "Semantic.puma" */
   if (! ((TreeRank (var->INDEXED_VAR.IND_VAR) != TreeListLength (var->INDEXED_VAR.IND_EXPS)))) goto yyL2;
  {
/* line 902 "Semantic.puma" */
   error_protocol ("illegal number of dimensions in ALLOCATE");
/* line 903 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL2:;

  if (var->INDEXED_VAR.IND_VAR->Kind == kSELECTED_VAR) {
/* line 906 "Semantic.puma" */
  {
/* line 908 "Semantic.puma" */
   if (! ((TreeRank (var->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELEC_VAR) != 0))) goto yyL3;
  {
/* line 909 "Semantic.puma" */
   error_protocol ("only one component of type can be ALLOCATEd");
/* line 910 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL3:;

/* line 913 "Semantic.puma" */
  {
/* line 915 "Semantic.puma" */
   if (! ((! IsVarAllocatable (var->INDEXED_VAR.IND_VAR->SELECTED_VAR.SELECTOR->REC_COMP.Object)))) goto yyL4;
  {
/* line 916 "Semantic.puma" */
   error_protocol ("ALLOCATE : record component cannot be allocated");
/* line 917 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL4:;

/* line 920 "Semantic.puma" */
  {
/* line 924 "Semantic.puma" */
   NormalAllocateParams (var->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  if (var->INDEXED_VAR.IND_VAR->Kind == kUSED_VAR) {
/* line 927 "Semantic.puma" */
  {
/* line 929 "Semantic.puma" */
   if (! ((! IsVarAllocatable (var->INDEXED_VAR.IND_VAR->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL6;
  {
/* line 930 "Semantic.puma" */
   error_protocol ("Not allocatable array in ALLOCATE");
/* line 931 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL6:;

/* line 934 "Semantic.puma" */
  {
/* line 936 "Semantic.puma" */
   NormalAllocateParams (var->INDEXED_VAR.IND_EXPS);
  }
   return;

  }
  }
  if (var->Kind == kUSED_VAR) {
/* line 939 "Semantic.puma" */
  {
/* line 941 "Semantic.puma" */
   if (! ((IsTreeObject (var->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL8;
  }
   return;
yyL8:;

/* line 944 "Semantic.puma" */
  {
/* line 946 "Semantic.puma" */
   if (! ((IsPointerObject (var->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL9;
  }
   return;
yyL9:;

  }
/* line 949 "Semantic.puma" */
  {
/* line 951 "Semantic.puma" */
   error_protocol ("Illegal Parameter in ALLOCATE");
/* line 952 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
   return;

;
}

static void CheckAllocateParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 965 "Semantic.puma" */
  {
/* line 967 "Semantic.puma" */
   CheckAllocParam (t->BTP_LIST.Elem->VAR_PARAM.V);
/* line 968 "Semantic.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (t->Kind == kBTP_EMPTY) {
/* line 971 "Semantic.puma" */
   return;

  }
;
}

static void NormalAllocateParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTE_EMPTY) {
/* line 984 "Semantic.puma" */
   return;

  }
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Elem->Kind == kSLICE_EXP) {
/* line 987 "Semantic.puma" */
  {
/* line 989 "Semantic.puma" */
 if (!ScalarIntExpr (t->BTE_LIST.Elem->SLICE_EXP.FIRST))
        { error_protocol ("exp in ALLOCATE must be scalar integer expression");
          tree_protocol ("illegal expression is : ", t->BTE_LIST.Elem->SLICE_EXP.FIRST);
        }
     if (!ScalarIntExpr (t->BTE_LIST.Elem->SLICE_EXP.STOP))
        { error_protocol ("exp in ALLOCATE must be scalar integer expression");
          tree_protocol ("illegal expression is : ", t->BTE_LIST.Elem->SLICE_EXP.STOP);
        }
   
/* line 999 "Semantic.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
/* line 1002 "Semantic.puma" */
  {
/* line 1004 "Semantic.puma" */
 if (!ScalarIntExpr (t->BTE_LIST.Elem))
        { error_protocol ("exp in ALLOCATE must be scalar integer expression");
          tree_protocol ("illegal expression is : ", t->BTE_LIST.Elem);
        }

     t->BTE_LIST.Elem = mSLICE_EXP (mCONST_EXP(mINT_CONSTANT (1)), t->BTE_LIST.Elem, mDUMMY_EXP());

   
/* line 1013 "Semantic.puma" */
   t = t->BTE_LIST.Next;
   goto yyRecursion;
  }

  }
;
}

static void CheckDeallocParameter
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 1024 "Semantic.puma" */
  {
/* line 1026 "Semantic.puma" */
   if (! ((IsPointerObject (var->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL1;
  }
   return;
yyL1:;

/* line 1029 "Semantic.puma" */
  {
/* line 1031 "Semantic.puma" */
   if (! ((! IsVarAllocatable (var->USED_VAR.VARNAME->VAR_OBJ.Object)))) goto yyL2;
  {
/* line 1033 "Semantic.puma" */
   error_protocol ("Not allocatable array in DEALLOCATE");
/* line 1034 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL2:;

/* line 1037 "Semantic.puma" */
   return;

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 1040 "Semantic.puma" */
  {
/* line 1042 "Semantic.puma" */
   if (! ((TreeRank (var->SELECTED_VAR.SELEC_VAR) != 0))) goto yyL4;
  {
/* line 1044 "Semantic.puma" */
   error_protocol ("only one component of type can be DEALLOCATEd");
/* line 1045 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL4:;

/* line 1048 "Semantic.puma" */
  {
/* line 1050 "Semantic.puma" */
   if (! ((! IsVarAllocatable (var->SELECTED_VAR.SELECTOR->REC_COMP.Object)))) goto yyL5;
  {
/* line 1052 "Semantic.puma" */
   error_protocol ("DEALLOCATE : record component cannot be deallocated");
/* line 1053 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
  }
   return;
yyL5:;

/* line 1056 "Semantic.puma" */
   return;

  }
/* line 1061 "Semantic.puma" */
  {
/* line 1063 "Semantic.puma" */
   error_protocol ("Illegal Parameter in DEALLOCATE");
/* line 1064 "Semantic.puma" */
   tree_protocol ("wrong parameter is ", var);
  }
   return;

;
}

static void CheckDeallocateParams
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
 yyRecursion:
  if (t->Kind == kBTP_LIST) {
  if (t->BTP_LIST.Elem->Kind == kVAR_PARAM) {
/* line 1075 "Semantic.puma" */
  {
/* line 1077 "Semantic.puma" */
   CheckDeallocParameter (t->BTP_LIST.Elem->VAR_PARAM.V);
/* line 1078 "Semantic.puma" */
   t = t->BTP_LIST.Next;
   goto yyRecursion;
  }

  }
  }
  if (t->Kind == kBTP_EMPTY) {
/* line 1081 "Semantic.puma" */
   return;

  }
;
}

static rbool IsVarArgument
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kVAR_PARAM) {
  if (t->VAR_PARAM.V->Kind == kADDR) {
/* line 1092 "Semantic.puma" */
  {
/* line 1094 "Semantic.puma" */
   return rfalse;
  }

  }
/* line 1097 "Semantic.puma" */
   return rtrue;

  }
  return rfalse;
}

static void SemCaseAlternatives
# if defined __STDC__ | defined __cplusplus
(register tTree alts, register tTree case_exp)
# else
(alts, case_exp)
 register tTree alts;
 register tTree case_exp;
# endif
{
 yyRecursion:
  if (alts->Kind == kSELECTED_ACF_LIST) {
/* line 1108 "Semantic.puma" */
  {
/* line 1110 "Semantic.puma" */
   SemCaseAlternatives (alts->SELECTED_ACF_LIST.Elem, case_exp);
/* line 1111 "Semantic.puma" */
   alts = alts->SELECTED_ACF_LIST.Next;
   goto yyRecursion;
  }

  }
  if (alts->Kind == kSELECTED_ACF_EMPTY) {
/* line 1114 "Semantic.puma" */
   return;

  }
  if (alts->Kind == kSELECTED_ACF_NODE) {
/* line 1117 "Semantic.puma" */
  {
/* line 1119 "Semantic.puma" */
   SemCaseValueRanges (alts->SELECTED_ACF_NODE.SELECT_LIST, case_exp);
/* line 1120 "Semantic.puma" */
   Semantic (alts->SELECTED_ACF_NODE.SELECT_ACFS);
  }
   return;

  }
;
}

static void SemCaseValueRanges
# if defined __STDC__ | defined __cplusplus
(register tTree explist, register tTree case_exp)
# else
(explist, case_exp)
 register tTree explist;
 register tTree case_exp;
# endif
{
  if (explist->Kind == kBTE_LIST) {
/* line 1131 "Semantic.puma" */
  {
/* line 1133 "Semantic.puma" */
   SemCaseValueRanges (explist->BTE_LIST.Next, case_exp);
/* line 1134 "Semantic.puma" */
   SemCaseValueRange (explist->BTE_LIST.Elem, case_exp);
  }
   return;

  }
  if (explist->Kind == kBTE_EMPTY) {
/* line 1137 "Semantic.puma" */
   return;

  }
/* line 1140 "Semantic.puma" */
  {
/* line 1141 "Semantic.puma" */
   failure_protocol (MODULE, "SemCaseValueRanges", explist);
  }
   return;

;
}

static void SemCaseValueRange
# if defined __STDC__ | defined __cplusplus
(register tTree case_value, register tTree case_exp)
# else
(case_value, case_exp)
 register tTree case_value;
 register tTree case_exp;
# endif
{
  if (case_value->Kind == kSLICE_EXP) {
  if (case_value->SLICE_EXP.FIRST->Kind == kDUMMY_EXP) {
/* line 1152 "Semantic.puma" */
  {
/* line 1156 "Semantic.puma" */
   SemCaseValue (case_value->SLICE_EXP.STOP, case_exp);
  }
   return;

  }
  if (case_value->SLICE_EXP.STOP->Kind == kDUMMY_EXP) {
/* line 1159 "Semantic.puma" */
  {
/* line 1163 "Semantic.puma" */
   SemCaseValue (case_value->SLICE_EXP.FIRST, case_exp);
  }
   return;

  }
/* line 1166 "Semantic.puma" */
  {
/* line 1170 "Semantic.puma" */
   SemCaseValue (case_value->SLICE_EXP.FIRST, case_exp);
/* line 1171 "Semantic.puma" */
   SemCaseValue (case_value->SLICE_EXP.STOP, case_exp);
  }
   return;

  }
/* line 1174 "Semantic.puma" */
  {
/* line 1175 "Semantic.puma" */
   SemCaseValue (case_value, case_exp);
  }
   return;

;
}

static void SemCaseValue
# if defined __STDC__ | defined __cplusplus
(register tTree case_value, register tTree case_exp)
# else
(case_value, case_exp)
 register tTree case_value;
 register tTree case_exp;
# endif
{
/* line 1186 "Semantic.puma" */
  {
/* line 1188 "Semantic.puma" */
 if (!ScalarCaseExpr (case_value))
        error_protocol ("scalar numeric expression in CASE required");
   
  }
   return;

;
}

static void SemDoRange
# if defined __STDC__ | defined __cplusplus
(register tTree range)
# else
(range)
 register tTree range;
# endif
{
  if (range->Kind == kSLICE_EXP) {
  if (range->SLICE_EXP.INC->Kind == kDUMMY_EXP) {
/* line 1201 "Semantic.puma" */
  {
/* line 1203 "Semantic.puma" */
 range->SLICE_EXP.FIRST  = SemExpression (range->SLICE_EXP.FIRST);
     range->SLICE_EXP.STOP  = SemExpression (range->SLICE_EXP.STOP);

     if (!ScalarNumExpr (range->SLICE_EXP.FIRST))
        error_protocol ("start value in DO no scalar numerical expression");
     if (!ScalarNumExpr (range->SLICE_EXP.STOP))
        error_protocol ("stop value in DO no scalar numerical expression");
   
  }
   return;

  }
/* line 1213 "Semantic.puma" */
  {
/* line 1215 "Semantic.puma" */
 range->SLICE_EXP.FIRST  = SemExpression (range->SLICE_EXP.FIRST);
     range->SLICE_EXP.STOP  = SemExpression (range->SLICE_EXP.STOP);
     range->SLICE_EXP.INC = SemExpression (range->SLICE_EXP.INC);

     if (!ScalarNumExpr (range->SLICE_EXP.FIRST))
        error_protocol ("start value in DO no scalar numerical expression");
     if (!ScalarNumExpr (range->SLICE_EXP.STOP))
        error_protocol ("stop value in DO no scalar numerical expression");
     if (!ScalarNumExpr (range->SLICE_EXP.INC))
        error_protocol ("stride value in DO no scalar numerical expression");
   
  }
   return;

  }
/* line 1228 "Semantic.puma" */
  {
/* line 1229 "Semantic.puma" */
   failure_protocol (MODULE, "SemDoRange", range);
  }
   return;

;
}

void BeginSemantic ARGS ((void))
{
}

void CloseSemantic ARGS ((void))
{
}
