# include "SemReduction.h"
# ifdef __cplusplus
extern "C" {
# include "General.h"
# include "rSystem.h"
}
# else
# include "General.h"
# include "rSystem.h"
# endif
# include <stdio.h>
# include "Tree.h"
# include "Definitions.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef rfalse
# define rfalse 0
# endif
# ifndef rtrue
# define rtrue 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = (free -= yyAlignedSize (sizeof (type))) >= start ? \
   (tree) free : alloc (sizeof (type)); \
  init (ptr, kind);
# else
# define yyALLOC(tree, free, start, alloc, type, make, ptr, kind, init) \
  ptr = make (kind);
# endif

/* line 49 "SemReduction.puma" */


# include "Idents.h"
# include "StringM.h"
# include "Types.h"
# include "protocol.h"
 
# include "TreeOps.h"
# include "Objects.h"
# include "Rank.h"
# include "Transform.h"

# include "Expressions.h"  /* MinusExpression */
 
# define MODULE "SemReduction"

# undef DEBUG

/*********************************************************************
*                                                                    *
*  Global variables used for TraverseReduction                       *
*                                                                    *
*    global_red_var, global_red_fn, global_red_kind                  *
*    global_replace, global_error                                    *
*                                                                    *
*********************************************************************/

static tTree global_red_fn = NoTree; /* used to check that not two different
                                        kinds of reductions are applied      */

static tTree global_red_var;

static int global_red_kind = kDEFAULT_REDUCTION;

static rbool global_replace;  /* replace reductions with REDUCE stmt  */
static rbool global_error;    /* set to TRUE if error occurs          */



# ifndef yyWrite
# define yyWrite(s) (void) fputs (s, yyf)
# endif
# ifndef yyWriteNl
# define yyWriteNl (void) fputc ('\n', yyf)
# endif

# include "yySemReduction.h"

static void yyExit ARGS ((void)) { rExit (1); }

void (* SemReduction_Exit) ARGS ((void)) = yyExit;

# ifdef UNIX
static FILE * yyf = stdout;
# else
static FILE * yyf;
# endif
static rbool yyb;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module SemReduction, routine %s failed\n",
  yyFunction);
 SemReduction_Exit ();
}

rbool IsLegalReduction ARGS ((tTree stmts, tTree red_var, tTree red_fn));
void IdentifyReduction ARGS ((tTree stmts, tTree red_var, int * yyP3, tTree * yyP2, int * yyP1));
static void TraverseReduction ARGS ((tTree stmts));
static tTree HandleReduction ARGS ((tTree stmt, tTree red_var, tTree red_fn, tTree red_exp));
static void VerifyNoReductionUse ARGS ((tTree exp));
static void VerifyScalarReduction ARGS ((tTree var));
static void VerifyReductionKind ARGS ((int kind));
static void VerifyReductionFunction ARGS ((tTree fn));
static tTree MakeReduce ARGS ((int kind, tTree fn, tTree var, tTree red_exp));
static void SetReductionKind ARGS ((int kind));
static void SetReductionFunction ARGS ((tTree fn));
static rbool EqualReduction ARGS ((tTree red1, tTree red2));
tTree MakeReduceStmt ARGS ((tTree assign));
static void GetTheVariable ARGS ((tTree var, tTree * yyP4));
void CheckRedStmt ARGS ((tTree stmt, tTree * red_var, tTree * yyP6, tTree * yyP5));
static void CheckIfReduction ARGS ((tTree e1, tTree op, tTree e2, tTree var, tTree exp, tTree * yyP8, tTree * yyP7));
void CheckReduction ARGS ((tTree var, tTree exp, tTree red_var, tTree * yyP10, tTree * yyP9));
static tTree MakeRedFn ARGS ((tTree op));
static rbool RedVarUse ARGS ((tTree exp, tTree red_var));
static rbool IsReductionVariable ARGS ((tTree var, tTree red_var));
static rbool EqualVariable ARGS ((tTree var1, tTree var2));

rbool IsLegalReduction
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, register tTree red_var, register tTree red_fn)
# else
(stmts, red_var, red_fn)
 register tTree stmts;
 register tTree red_var;
 register tTree red_fn;
# endif
{
/* line 99 "SemReduction.puma" */
  {
/* line 103 "SemReduction.puma" */
   global_red_var = red_var;
/* line 104 "SemReduction.puma" */
   global_red_fn = red_fn;
/* line 105 "SemReduction.puma" */
   global_red_kind = kPRIVATE_REDUCTION;
/* line 106 "SemReduction.puma" */
   global_replace = rfalse;
/* line 107 "SemReduction.puma" */
   global_error = rfalse;
/* line 109 "SemReduction.puma" */
   TraverseReduction (stmts);
/* line 111 "SemReduction.puma" */
   if (! ((! global_error))) goto yyL1;
  }
   return rtrue;
yyL1:;

  return rfalse;
}

void IdentifyReduction
# if defined __STDC__ | defined __cplusplus
(register tTree stmts, register tTree red_var, register int * yyP3, register tTree * yyP2, register int * yyP1)
# else
(stmts, red_var, yyP3, yyP2, yyP1)
 register tTree stmts;
 register tTree red_var;
 register int * yyP3;
 register tTree * yyP2;
 register int * yyP1;
# endif
{
/* line 128 "SemReduction.puma" */
  {
/* line 132 "SemReduction.puma" */
   global_red_var = red_var;
/* line 133 "SemReduction.puma" */
   global_red_fn = NoTree;
/* line 134 "SemReduction.puma" */
   global_red_kind = kDEFAULT_REDUCTION;
/* line 135 "SemReduction.puma" */
   global_replace = rtrue;
/* line 136 "SemReduction.puma" */
   global_error = rfalse;
/* line 138 "SemReduction.puma" */

#ifdef DEBUG
     printf ("IdentifyReduction for variable ");
     FileUnparse (stdout, red_var);
     printf ("\n");
#endif
   
/* line 146 "SemReduction.puma" */
   TraverseReduction (stmts);
/* line 148 "SemReduction.puma" */

#ifdef DEBUG
     printf ("IdentifyReduction for variable ");
     FileUnparse (stdout, red_var);
     printf (" finished, red_kind = %d, red_fn = ", global_red_kind);
     FileUnparse (stdout, global_red_fn);
     printf ("\n");
#endif
   
  }
   * yyP3 = global_error;
   * yyP2 = global_red_fn;
   * yyP1 = global_red_kind;
   return;

;
}

static void TraverseReduction
# if defined __STDC__ | defined __cplusplus
(register tTree stmts)
# else
(stmts)
 register tTree stmts;
# endif
{
 yyRecursion:

  switch (stmts->Kind) {
  case kACF_LIST:
/* line 172 "SemReduction.puma" */
 {
  tTree red_var;
  tTree yyV1;
  tTree yyV2;
  {
/* line 174 "SemReduction.puma" */
   set_protocol_stmt (stmts->ACF_LIST.Elem);
/* line 178 "SemReduction.puma" */
   red_var = global_red_var;
/* line 180 "SemReduction.puma" */
   CheckRedStmt (stmts->ACF_LIST.Elem, & red_var, & yyV1, & yyV2);
/* line 182 "SemReduction.puma" */
   if (! ((yyV1 != NoTree))) goto yyL1;
  {
/* line 184 "SemReduction.puma" */
 stmts->ACF_LIST.Elem = HandleReduction (stmts->ACF_LIST.Elem, red_var, yyV1, yyV2); 
/* line 186 "SemReduction.puma" */
   stmts = stmts->ACF_LIST.Next;
   goto yyRecursion;
  }
  }
 }
yyL1:;

/* line 189 "SemReduction.puma" */
  {
/* line 191 "SemReduction.puma" */
   set_protocol_stmt (stmts->ACF_LIST.Elem);
/* line 193 "SemReduction.puma" */
   TraverseReduction (stmts->ACF_LIST.Elem);
/* line 194 "SemReduction.puma" */
   stmts = stmts->ACF_LIST.Next;
   goto yyRecursion;
  }

  case kACF_EMPTY:
/* line 197 "SemReduction.puma" */
   return;

  case kACF_DUMMY:
/* line 200 "SemReduction.puma" */
   return;

  case kACF_BASIC:
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 203 "SemReduction.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 205 "SemReduction.puma" */
   CheckReduction (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, global_red_var, & yyV1, & yyV2);
/* line 207 "SemReduction.puma" */
   if (! ((yyV1 != NoTree))) goto yyL5;
  {
/* line 209 "SemReduction.puma" */

#ifdef DEBUG
     printf ("Reduction Statement of ");
     FileUnparse (stdout, global_red_var);
     printf (" : ");
     FileUnparse (stdout, stmts->ACF_BASIC.BASIC_STMT);
     printf ("\n");
#endif
   
/* line 221 "SemReduction.puma" */
   VerifyScalarReduction (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
/* line 223 "SemReduction.puma" */
   VerifyReductionFunction (yyV1);
/* line 224 "SemReduction.puma" */
   VerifyReductionKind (kPRIVATE_REDUCTION);
/* line 226 "SemReduction.puma" */
   if ((global_replace)) {
/* line 227 "SemReduction.puma" */
 stmts->ACF_BASIC.BASIC_STMT = MakeReduce (kPRIVATE_REDUCTION, yyV1, stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, yyV2);  
   }
  }
  }
   return;
 }
yyL5:;

/* line 231 "SemReduction.puma" */
  {
/* line 233 "SemReduction.puma" */
   VerifyNoReductionUse (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR);
/* line 234 "SemReduction.puma" */
   VerifyNoReductionUse (stmts->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP);
  }
   return;

  }
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kREDUCE_STMT) {
  if (stmts->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->Kind == kBTP_LIST) {
/* line 237 "SemReduction.puma" */
 {
  tTree yyV1;
  {
/* line 241 "SemReduction.puma" */
   GetTheVariable (stmts->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_PARAMS->BTP_LIST.Elem, & yyV1);
/* line 243 "SemReduction.puma" */
   if (! ((IsReductionVariable (yyV1, global_red_var)))) goto yyL7;
  {
/* line 245 "SemReduction.puma" */
   VerifyReductionFunction (stmts->ACF_BASIC.BASIC_STMT->REDUCE_STMT.RED_FUNC);
/* line 246 "SemReduction.puma" */
   VerifyReductionKind (stmts->ACF_BASIC.BASIC_STMT->REDUCE_STMT.red_kind);
  }
  }
   return;
 }
yyL7:;

  }
  }
  if (stmts->ACF_BASIC.BASIC_STMT->Kind == kCALL_STMT) {
/* line 249 "SemReduction.puma" */
   return;

  }
/* line 254 "SemReduction.puma" */
   return;

  case kACF_IF:
/* line 257 "SemReduction.puma" */
  {
/* line 259 "SemReduction.puma" */
   VerifyNoReductionUse (stmts->ACF_IF.IF_EXP);
/* line 261 "SemReduction.puma" */
   TraverseReduction (stmts->ACF_IF.THEN_PART);
/* line 262 "SemReduction.puma" */
   stmts = stmts->ACF_IF.ELSE_PART;
   goto yyRecursion;
  }

  case kACF_FORALL:
/* line 265 "SemReduction.puma" */
  {
/* line 267 "SemReduction.puma" */
   VerifyNoReductionUse (stmts->ACF_FORALL.FORALL_ID);
/* line 268 "SemReduction.puma" */
   VerifyNoReductionUse (stmts->ACF_FORALL.FORALL_RANGE);
/* line 271 "SemReduction.puma" */
   stmts = stmts->ACF_FORALL.FORALL_BODY;
   goto yyRecursion;
  }

  case kACF_DO:
/* line 274 "SemReduction.puma" */
  {
/* line 276 "SemReduction.puma" */
   VerifyNoReductionUse (stmts->ACF_DO.DO_ID);
/* line 277 "SemReduction.puma" */
   VerifyNoReductionUse (stmts->ACF_DO.DO_RANGE);
/* line 279 "SemReduction.puma" */
   stmts = stmts->ACF_DO.DO_BODY;
   goto yyRecursion;
  }

  case kACF_WHILE:
/* line 282 "SemReduction.puma" */
  {
/* line 284 "SemReduction.puma" */
   VerifyNoReductionUse (stmts->ACF_WHILE.WHILE_EXP);
/* line 286 "SemReduction.puma" */
   stmts = stmts->ACF_WHILE.WHILE_BODY;
   goto yyRecursion;
  }

  case kACF_HOME:
/* line 289 "SemReduction.puma" */
  {
/* line 291 "SemReduction.puma" */
   stmts = stmts->ACF_HOME.HOME_BODY;
   goto yyRecursion;
  }

  case kACF_RESIDENT:
/* line 294 "SemReduction.puma" */
  {
/* line 296 "SemReduction.puma" */
   stmts = stmts->ACF_RESIDENT.RESIDENT_BODY;
   goto yyRecursion;
  }

  case kACF_NEW:
/* line 299 "SemReduction.puma" */
  {
/* line 301 "SemReduction.puma" */
   stmts = stmts->ACF_NEW.NEW_BODY;
   goto yyRecursion;
  }

  case kACF_REDUCTION:
/* line 304 "SemReduction.puma" */
  {
/* line 306 "SemReduction.puma" */
   stmts = stmts->ACF_REDUCTION.REDUCTION_BODY;
   goto yyRecursion;
  }

  }

/* line 309 "SemReduction.puma" */
  {
/* line 311 "SemReduction.puma" */
   failure_protocol (MODULE, "TraverseReduction", stmts);
  }
   return;

;
}

static tTree HandleReduction
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree red_var, register tTree red_fn, register tTree red_exp)
# else
(stmt, red_var, red_fn, red_exp)
 register tTree stmt;
 register tTree red_var;
 register tTree red_fn;
 register tTree red_exp;
# endif
{
  if (Tree_IsType (stmt, kACF_NODE)) {
/* line 322 "SemReduction.puma" */
 {
  tTree new;
  {
/* line 326 "SemReduction.puma" */
   new = stmt;
/* line 328 "SemReduction.puma" */

#ifdef DEBUG
     printf ("Reduction Statement of ");
     FileUnparse (stdout, global_red_var);
     printf (" : ");
     FileUnparse (stdout, stmt);
     printf ("\n");
#endif
   
/* line 340 "SemReduction.puma" */
   VerifyScalarReduction (red_var);
/* line 342 "SemReduction.puma" */
   VerifyReductionFunction (red_fn);
/* line 343 "SemReduction.puma" */
   VerifyReductionKind (kPRIVATE_REDUCTION);
/* line 345 "SemReduction.puma" */
   if ((global_replace)) {
/* line 347 "SemReduction.puma" */
   new = MakeReduce (kPRIVATE_REDUCTION, red_fn, red_var, red_exp);
/* line 348 "SemReduction.puma" */
   new = mACF_BASIC (new);
/* line 350 "SemReduction.puma" */
   LineACFNode (new, stmt->ACF_NODE.Line);
/* line 351 "SemReduction.puma" */
   LabelACFNode (new, stmt->ACF_NODE.Label);
   }
  }
   return new;
 }

  }
 yyAbort ("HandleReduction");
 { tTree yyDummy; return yyDummy; }
}

static void VerifyNoReductionUse
# if defined __STDC__ | defined __cplusplus
(register tTree exp)
# else
(exp)
 register tTree exp;
# endif
{
/* line 371 "SemReduction.puma" */
  {
/* line 373 "SemReduction.puma" */
   if (! ((! RedVarUse (exp, global_red_var)))) goto yyL1;
  }
   return;
yyL1:;

/* line 376 "SemReduction.puma" */
  {
/* line 378 "SemReduction.puma" */
   if (! ((! global_replace))) goto yyL2;
  {
/* line 380 "SemReduction.puma" */
   global_error = rtrue;
  }
  }
   return;
yyL2:;

/* line 383 "SemReduction.puma" */
  {
/* line 385 "SemReduction.puma" */
   error_protocol ("illegal use of reduction variable");
/* line 386 "SemReduction.puma" */
   tree_protocol ("reduction variable: ", global_red_var);
  }
   return;

;
}

static void VerifyScalarReduction
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
/* line 395 "SemReduction.puma" */
  {
/* line 397 "SemReduction.puma" */
   if (! ((TreeRank (var) == 0))) goto yyL1;
  }
   return;
yyL1:;

/* line 400 "SemReduction.puma" */
  {
/* line 402 "SemReduction.puma" */
   if (! ((! global_replace))) goto yyL2;
  {
/* line 404 "SemReduction.puma" */
   global_error = rtrue;
  }
  }
   return;
yyL2:;

/* line 407 "SemReduction.puma" */
  {
/* line 409 "SemReduction.puma" */
   error_protocol ("reductions on array variables not allowed");
/* line 410 "SemReduction.puma" */
   tree_protocol ("reduction variable: ", global_red_var);
  }
   return;

;
}

static void VerifyReductionKind
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
/* line 419 "SemReduction.puma" */
  {
/* line 421 "SemReduction.puma" */
   if (! ((global_red_kind == kDEFAULT_REDUCTION))) goto yyL1;
  {
/* line 423 "SemReduction.puma" */
   global_red_kind = kind;
  }
  }
   return;
yyL1:;

/* line 426 "SemReduction.puma" */
  {
/* line 428 "SemReduction.puma" */
   if (! ((kind == global_red_kind))) goto yyL2;
  }
   return;
yyL2:;

/* line 432 "SemReduction.puma" */
  {
/* line 434 "SemReduction.puma" */
   if (! ((! global_replace))) goto yyL3;
  {
/* line 436 "SemReduction.puma" */
   global_error = rtrue;
  }
  }
   return;
yyL3:;

/* line 439 "SemReduction.puma" */
  {
/* line 441 "SemReduction.puma" */
   error_protocol ("different kind of reduction");
  }
   return;

;
}

static void VerifyReductionFunction
# if defined __STDC__ | defined __cplusplus
(register tTree fn)
# else
(fn)
 register tTree fn;
# endif
{
/* line 450 "SemReduction.puma" */
  {
/* line 452 "SemReduction.puma" */
   if (! ((global_red_fn == NoTree))) goto yyL1;
  {
/* line 454 "SemReduction.puma" */
   global_red_fn = fn;
  }
  }
   return;
yyL1:;

/* line 457 "SemReduction.puma" */
  {
/* line 459 "SemReduction.puma" */
   if (! ((EqualReduction (fn, global_red_fn)))) goto yyL2;
  }
   return;
yyL2:;

/* line 462 "SemReduction.puma" */
  {
/* line 464 "SemReduction.puma" */
   if (! ((! global_replace))) goto yyL3;
  {
/* line 466 "SemReduction.puma" */
   global_error = rtrue;
  }
  }
   return;
yyL3:;

/* line 469 "SemReduction.puma" */
  {
/* line 471 "SemReduction.puma" */
   error_protocol ("different use of reduction");
/* line 472 "SemReduction.puma" */
   tree_protocol ("reduction here   : ", fn);
/* line 473 "SemReduction.puma" */
   tree_protocol ("reduction before : ", global_red_fn);
  }
   return;

;
}

static tTree MakeReduce
# if defined __STDC__ | defined __cplusplus
(register int kind, register tTree fn, register tTree var, register tTree red_exp)
# else
(kind, fn, var, red_exp)
 register int kind;
 register tTree fn;
 register tTree var;
 register tTree red_exp;
# endif
{
/* line 484 "SemReduction.puma" */
 {
  tTree param1;
  tTree param2;
  tTree s;
  {
/* line 490 "SemReduction.puma" */
 param1 = mVAR_PARAM (var);
     SetVarParamAttributes (param1, IntentInOut);
     param2 = ExpToVarParam (red_exp);
     SetVarParamAttributes (param2, IntentIn);
     s = mREDUCE_STMT (kind, fn, mBTP_LIST (param1, 
                                   mBTP_LIST (param2, mBTP_EMPTY())));
   
  }
   return s;
 }

}

static void SetReductionKind
# if defined __STDC__ | defined __cplusplus
(register int kind)
# else
(kind)
 register int kind;
# endif
{
/* line 511 "SemReduction.puma" */
  {
/* line 513 "SemReduction.puma" */
   if (! ((global_red_kind == kDEFAULT_REDUCTION))) goto yyL1;
  {
/* line 515 "SemReduction.puma" */
   global_red_kind = kind;
  }
  }
   return;
yyL1:;

/* line 518 "SemReduction.puma" */
  {
/* line 520 "SemReduction.puma" */
   if (! ((kind == global_red_kind))) goto yyL2;
  }
   return;
yyL2:;

/* line 523 "SemReduction.puma" */
  {
/* line 525 "SemReduction.puma" */
   error_protocol ("different kind of reduction");
  }
   return;

;
}

static void SetReductionFunction
# if defined __STDC__ | defined __cplusplus
(register tTree fn)
# else
(fn)
 register tTree fn;
# endif
{
/* line 530 "SemReduction.puma" */
  {
/* line 532 "SemReduction.puma" */
   if (! ((global_red_fn == NoTree))) goto yyL1;
  {
/* line 534 "SemReduction.puma" */
   global_red_fn = fn;
  }
  }
   return;
yyL1:;

/* line 537 "SemReduction.puma" */
  {
/* line 539 "SemReduction.puma" */
   if (! ((EqualReduction (fn, global_red_fn)))) goto yyL2;
  }
   return;
yyL2:;

/* line 542 "SemReduction.puma" */
  {
/* line 544 "SemReduction.puma" */
   error_protocol ("different use of reduction");
/* line 545 "SemReduction.puma" */
   tree_protocol ("reduction here   : ", fn);
/* line 546 "SemReduction.puma" */
   tree_protocol ("reduction before : ", global_red_fn);
  }
   return;

;
}

static rbool EqualReduction
# if defined __STDC__ | defined __cplusplus
(register tTree red1, register tTree red2)
# else
(red1, red2)
 register tTree red1;
 register tTree red2;
# endif
{
  if (red1->Kind == kPROC_OBJ) {
  if (red2->Kind == kPROC_OBJ) {
/* line 551 "SemReduction.puma" */
  {
/* line 553 "SemReduction.puma" */
   if (! ((red1->PROC_OBJ.Ident == red2->PROC_OBJ.Ident))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  return rfalse;
}

tTree MakeReduceStmt
# if defined __STDC__ | defined __cplusplus
(register tTree assign)
# else
(assign)
 register tTree assign;
# endif
{
  if (assign->Kind == kASSIGN_STMT) {
/* line 564 "SemReduction.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  tTree yyV3;
  {
/* line 566 "SemReduction.puma" */
   GetTheVariable (assign->ASSIGN_STMT.ASSIGN_VAR, & yyV1);
/* line 568 "SemReduction.puma" */
   if (! ((yyV1 != NoTree))) goto yyL1;
  {
/* line 570 "SemReduction.puma" */
   CheckReduction (assign->ASSIGN_STMT.ASSIGN_VAR, assign->ASSIGN_STMT.ASSIGN_EXP, yyV1, & yyV2, & yyV3);
/* line 572 "SemReduction.puma" */
   if (! ((yyV2 != NoTree))) goto yyL1;
  }
  }
   return MakeReduce (kATOMIC_REDUCTION, yyV2, assign->ASSIGN_STMT.ASSIGN_VAR, yyV3);
 }
yyL1:;

  }
/* line 577 "SemReduction.puma" */
  {
/* line 579 "SemReduction.puma" */
   error_protocol ("illegal statement for atomic operation");
  }
   return assign;

}

static void GetTheVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree * yyP4)
# else
(var, yyP4)
 register tTree var;
 register tTree * yyP4;
# endif
{
  if (var->Kind == kUSED_VAR) {
/* line 594 "SemReduction.puma" */
   * yyP4 = var;
   return;

  }
  if (var->Kind == kINDEXED_VAR) {
/* line 597 "SemReduction.puma" */
 {
  tTree yyV1;
  {
/* line 599 "SemReduction.puma" */
   GetTheVariable (var->INDEXED_VAR.IND_VAR, & yyV1);
  }
   * yyP4 = yyV1;
   return;
 }

  }
  if (var->Kind == kSELECTED_VAR) {
/* line 602 "SemReduction.puma" */
 {
  tTree yyV1;
  {
/* line 604 "SemReduction.puma" */
   GetTheVariable (var->SELECTED_VAR.SELEC_VAR, & yyV1);
  }
   * yyP4 = yyV1;
   return;
 }

  }
  if (var->Kind == kVAR_PARAM) {
/* line 607 "SemReduction.puma" */
 {
  tTree yyV1;
  {
/* line 609 "SemReduction.puma" */
   GetTheVariable (var->VAR_PARAM.V, & yyV1);
  }
   * yyP4 = yyV1;
   return;
 }

  }
/* line 612 "SemReduction.puma" */
  {
/* line 614 "SemReduction.puma" */
   failure_protocol (MODULE, "GetTheVariable", var);
  }
   * yyP4 = NoTree;
   return;

;
}

void CheckRedStmt
# if defined __STDC__ | defined __cplusplus
(register tTree stmt, register tTree * red_var, register tTree * yyP6, register tTree * yyP5)
# else
(stmt, red_var, yyP6, yyP5)
 register tTree stmt;
 register tTree * red_var;
 register tTree * yyP6;
 register tTree * yyP5;
# endif
{
  if (stmt->Kind == kACF_BASIC) {
  if (stmt->ACF_BASIC.BASIC_STMT->Kind == kASSIGN_STMT) {
/* line 633 "SemReduction.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 635 "SemReduction.puma" */
   if (! (((* red_var) == NoTree))) goto yyL1;
  {
/* line 637 "SemReduction.puma" */
   (* red_var) = stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR;
/* line 639 "SemReduction.puma" */
   CheckReduction (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, & yyV1, & yyV2);
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL1:;

/* line 642 "SemReduction.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 646 "SemReduction.puma" */
   CheckReduction (stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, (* red_var), & yyV1, & yyV2);
/* line 648 "SemReduction.puma" */
   if ((yyV1 != NoTree)) {
/* line 648 "SemReduction.puma" */
   (* red_var) = stmt->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR;
   }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }

  }
  }
  if (stmt->Kind == kACF_IF) {
  if (stmt->ACF_IF.THEN_PART->Kind == kACF_LIST) {
  if (stmt->ACF_IF.THEN_PART->ACF_LIST.Next->Kind == kACF_EMPTY) {
  if (stmt->ACF_IF.ELSE_PART->Kind == kACF_EMPTY) {
/* line 651 "SemReduction.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 655 "SemReduction.puma" */
   if (stmt->ACF_IF.IF_EXP->Kind != kOP_EXP) goto yyL3;
/* line 656 "SemReduction.puma" */
   if (stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->Kind != kACF_BASIC) goto yyL3;
   if (stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind != kASSIGN_STMT) goto yyL3;
/* line 659 "SemReduction.puma" */
   if (! ((stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.Label == 0))) goto yyL3;
  {
/* line 660 "SemReduction.puma" */
   if (! (((* red_var) == NoTree))) goto yyL3;
  {
/* line 662 "SemReduction.puma" */
   (* red_var) = stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR;
/* line 664 "SemReduction.puma" */
   CheckIfReduction (stmt->ACF_IF.IF_EXP->OP_EXP.OPND1, stmt->ACF_IF.IF_EXP->OP_EXP.EXP_OP, stmt->ACF_IF.IF_EXP->OP_EXP.OPND2, stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, & yyV1, & yyV2);
  }
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL3:;

/* line 667 "SemReduction.puma" */
 {
  tTree yyV1;
  tTree yyV2;
  {
/* line 671 "SemReduction.puma" */
   if (stmt->ACF_IF.IF_EXP->Kind != kOP_EXP) goto yyL4;
/* line 672 "SemReduction.puma" */
   if (stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->Kind != kACF_BASIC) goto yyL4;
   if (stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->Kind != kASSIGN_STMT) goto yyL4;
/* line 675 "SemReduction.puma" */
   if (! ((stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.Label == 0))) goto yyL4;
  {
/* line 676 "SemReduction.puma" */
   if (! ((IsReductionVariable (stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, (* red_var))))) goto yyL4;
  {
/* line 678 "SemReduction.puma" */
   CheckIfReduction (stmt->ACF_IF.IF_EXP->OP_EXP.OPND1, stmt->ACF_IF.IF_EXP->OP_EXP.EXP_OP, stmt->ACF_IF.IF_EXP->OP_EXP.OPND2, stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR, stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_EXP, & yyV1, & yyV2);
/* line 680 "SemReduction.puma" */
   if ((yyV1 != NoTree)) {
/* line 680 "SemReduction.puma" */
   (* red_var) = stmt->ACF_IF.THEN_PART->ACF_LIST.Elem->ACF_BASIC.BASIC_STMT->ASSIGN_STMT.ASSIGN_VAR;
   }
  }
  }
  }
   * yyP6 = yyV1;
   * yyP5 = yyV2;
   return;
 }
yyL4:;

  }
  }
  }
  }
/* line 683 "SemReduction.puma" */
   * yyP6 = NoTree;
   * yyP5 = NoTree;
   return;

;
}

static void CheckIfReduction
# if defined __STDC__ | defined __cplusplus
(register tTree e1, register tTree op, register tTree e2, register tTree var, register tTree exp, register tTree * yyP8, register tTree * yyP7)
# else
(e1, op, e2, var, exp, yyP8, yyP7)
 register tTree e1;
 register tTree op;
 register tTree e2;
 register tTree var;
 register tTree exp;
 register tTree * yyP8;
 register tTree * yyP7;
# endif
{
  if (op->Kind == kOP_GT) {
  if (e2->Kind == kVAR_EXP) {
/* line 699 "SemReduction.puma" */
 {
  tTree red_fn;
  {
/* line 703 "SemReduction.puma" */
   if (! ((IsReductionVariable (e2->VAR_EXP.V, var)))) goto yyL1;
  {
/* line 704 "SemReduction.puma" */
   if (! ((EqualExpression (e1, exp)))) goto yyL1;
  {
/* line 705 "SemReduction.puma" */
   if (! ((! RedVarUse (exp, var)))) goto yyL1;
  {
/* line 707 "SemReduction.puma" */
   red_fn = mPROC_OBJ (IsIdent ("MAXVAL"));
  }
  }
  }
  }
   * yyP8 = red_fn;
   * yyP7 = exp;
   return;
 }
yyL1:;

  }
  }
  if (e1->Kind == kVAR_EXP) {
  if (op->Kind == kOP_LT) {
/* line 712 "SemReduction.puma" */
 {
  tTree red_fn;
  {
/* line 716 "SemReduction.puma" */
   if (! ((IsReductionVariable (e1->VAR_EXP.V, var)))) goto yyL2;
  {
/* line 717 "SemReduction.puma" */
   if (! ((EqualExpression (e2, exp)))) goto yyL2;
  {
/* line 718 "SemReduction.puma" */
   if (! ((! RedVarUse (exp, var)))) goto yyL2;
  {
/* line 720 "SemReduction.puma" */
   red_fn = mPROC_OBJ (IsIdent ("MAXVAL"));
  }
  }
  }
  }
   * yyP8 = red_fn;
   * yyP7 = exp;
   return;
 }
yyL2:;

  }
  }
  if (op->Kind == kOP_LT) {
  if (e2->Kind == kVAR_EXP) {
/* line 725 "SemReduction.puma" */
 {
  tTree red_fn;
  {
/* line 729 "SemReduction.puma" */
   if (! ((IsReductionVariable (e2->VAR_EXP.V, var)))) goto yyL3;
  {
/* line 730 "SemReduction.puma" */
   if (! ((EqualExpression (e1, exp)))) goto yyL3;
  {
/* line 731 "SemReduction.puma" */
   if (! ((! RedVarUse (exp, var)))) goto yyL3;
  {
/* line 733 "SemReduction.puma" */
   red_fn = mPROC_OBJ (IsIdent ("MINVAL"));
  }
  }
  }
  }
   * yyP8 = red_fn;
   * yyP7 = exp;
   return;
 }
yyL3:;

  }
  }
  if (e1->Kind == kVAR_EXP) {
  if (op->Kind == kOP_GT) {
/* line 738 "SemReduction.puma" */
 {
  tTree red_fn;
  {
/* line 742 "SemReduction.puma" */
   if (! ((IsReductionVariable (e1->VAR_EXP.V, var)))) goto yyL4;
  {
/* line 743 "SemReduction.puma" */
   if (! ((EqualExpression (e2, exp)))) goto yyL4;
  {
/* line 744 "SemReduction.puma" */
   if (! ((! RedVarUse (exp, var)))) goto yyL4;
  {
/* line 746 "SemReduction.puma" */
   red_fn = mPROC_OBJ (IsIdent ("MINVAL"));
  }
  }
  }
  }
   * yyP8 = red_fn;
   * yyP7 = exp;
   return;
 }
yyL4:;

  }
  }
/* line 751 "SemReduction.puma" */
   * yyP8 = NoTree;
   * yyP7 = NoTree;
   return;

;
}

void CheckReduction
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree exp, register tTree red_var, register tTree * yyP10, register tTree * yyP9)
# else
(var, exp, red_var, yyP10, yyP9)
 register tTree var;
 register tTree exp;
 register tTree red_var;
 register tTree * yyP10;
 register tTree * yyP9;
# endif
{
/* line 763 "SemReduction.puma" */
  {
/* line 765 "SemReduction.puma" */
   if (! ((! IsReductionVariable (var, red_var)))) goto yyL1;
  }
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;
yyL1:;

  if (exp->Kind == kOP_EXP) {
  if (exp->OP_EXP.EXP_OP->Kind == kOP_MINUS) {
  if (exp->OP_EXP.OPND1->Kind == kVAR_EXP) {
/* line 770 "SemReduction.puma" */
  {
/* line 773 "SemReduction.puma" */
   if (! ((IsReductionVariable (exp->OP_EXP.OPND1->VAR_EXP.V, red_var)))) goto yyL2;
  {
/* line 774 "SemReduction.puma" */
   if (! ((EqualVariable (var, exp->OP_EXP.OPND1->VAR_EXP.V)))) goto yyL2;
  {
/* line 775 "SemReduction.puma" */
   if (! ((! RedVarUse (exp->OP_EXP.OPND2, red_var)))) goto yyL2;
  }
  }
  }
   * yyP10 = mPROC_OBJ (IsIdent ("SUM"));
   * yyP9 = MinusExpression (exp->OP_EXP.OPND2);
   return;
yyL2:;

  }
  }
  if (exp->OP_EXP.EXP_OP->Kind == kOP_DIVIDE) {
  if (exp->OP_EXP.OPND1->Kind == kVAR_EXP) {
/* line 780 "SemReduction.puma" */
  {
/* line 783 "SemReduction.puma" */
   if (! ((IsReductionVariable (exp->OP_EXP.OPND1->VAR_EXP.V, red_var)))) goto yyL3;
  {
/* line 784 "SemReduction.puma" */
   if (! ((EqualVariable (var, exp->OP_EXP.OPND1->VAR_EXP.V)))) goto yyL3;
  {
/* line 785 "SemReduction.puma" */
   if (! ((! RedVarUse (exp->OP_EXP.OPND2, red_var)))) goto yyL3;
  }
  }
  }
   * yyP10 = mPROC_OBJ (IsIdent ("PRODUCT"));
   * yyP9 = InverseExpression (exp->OP_EXP.OPND2);
   return;
yyL3:;

  }
  }
  if (exp->OP_EXP.OPND1->Kind == kVAR_EXP) {
/* line 788 "SemReduction.puma" */
  {
/* line 790 "SemReduction.puma" */
   if (! ((IsReductionVariable (exp->OP_EXP.OPND1->VAR_EXP.V, red_var)))) goto yyL4;
  {
/* line 791 "SemReduction.puma" */
   if (! ((EqualVariable (var, exp->OP_EXP.OPND1->VAR_EXP.V)))) goto yyL4;
  {
/* line 792 "SemReduction.puma" */
   if (! ((! RedVarUse (exp->OP_EXP.OPND2, red_var)))) goto yyL4;
  }
  }
  }
   * yyP10 = MakeRedFn (exp->OP_EXP.EXP_OP);
   * yyP9 = exp->OP_EXP.OPND2;
   return;
yyL4:;

  }
  if (exp->OP_EXP.OPND2->Kind == kVAR_EXP) {
/* line 795 "SemReduction.puma" */
  {
/* line 797 "SemReduction.puma" */
   if (! ((IsReductionVariable (exp->OP_EXP.OPND2->VAR_EXP.V, red_var)))) goto yyL5;
  {
/* line 798 "SemReduction.puma" */
   if (! ((EqualVariable (var, exp->OP_EXP.OPND2->VAR_EXP.V)))) goto yyL5;
  {
/* line 799 "SemReduction.puma" */
   if (! ((! RedVarUse (exp->OP_EXP.OPND1, red_var)))) goto yyL5;
  }
  }
  }
   * yyP10 = MakeRedFn (exp->OP_EXP.EXP_OP);
   * yyP9 = exp->OP_EXP.OPND1;
   return;
yyL5:;

  }
  }
  if (exp->Kind == kFUNC_CALL_EXP) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 802 "SemReduction.puma" */
  {
/* line 807 "SemReduction.puma" */
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL6;
  {
/* line 808 "SemReduction.puma" */
   if (! ((IsReductionVariable (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V, red_var)))) goto yyL6;
  {
/* line 809 "SemReduction.puma" */
   if (! ((EqualVariable (var, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL6;
  {
/* line 810 "SemReduction.puma" */
   if (! ((! RedVarUse (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem, red_var)))) goto yyL6;
  }
  }
  }
  }
   * yyP10 = MakeRedFn (exp->FUNC_CALL_EXP.FUNC_ID);
   * yyP9 = VarParamToExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
   return;
yyL6:;

  }
  }
  }
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->Kind == kVAR_PARAM) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
/* line 813 "SemReduction.puma" */
  {
/* line 818 "SemReduction.puma" */
   if (! ((IsIntrCall (exp->FUNC_CALL_EXP.FUNC_ID)))) goto yyL7;
  {
/* line 819 "SemReduction.puma" */
   if (! ((IsReductionVariable (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V, red_var)))) goto yyL7;
  {
/* line 820 "SemReduction.puma" */
   if (! ((EqualVariable (var, exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem->VAR_PARAM.V)))) goto yyL7;
  {
/* line 821 "SemReduction.puma" */
   if (! ((! RedVarUse (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem, red_var)))) goto yyL7;
  }
  }
  }
  }
   * yyP10 = MakeRedFn (exp->FUNC_CALL_EXP.FUNC_ID);
   * yyP9 = VarParamToExp (exp->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Next->BTP_LIST.Elem);
   return;
yyL7:;

  }
  }
  }
  }
  }
/* line 824 "SemReduction.puma" */
   * yyP10 = NoTree;
   * yyP9 = NoTree;
   return;

;
}

static tTree MakeRedFn
# if defined __STDC__ | defined __cplusplus
(register tTree op)
# else
(op)
 register tTree op;
# endif
{
  if (op->Kind == kOP_PLUS) {
/* line 837 "SemReduction.puma" */
   return mPROC_OBJ (IsIdent ("SUM"));

  }
  if (op->Kind == kOP_TIMES) {
/* line 842 "SemReduction.puma" */
   return mPROC_OBJ (IsIdent ("PRODUCT"));

  }
  if (op->Kind == kOP_OR) {
/* line 847 "SemReduction.puma" */
   return mPROC_OBJ (IsIdent ("ANY"));

  }
  if (op->Kind == kOP_AND) {
/* line 852 "SemReduction.puma" */
   return mPROC_OBJ (IsIdent ("ALL"));

  }
  if (op->Kind == kOP_NEQV) {
/* line 857 "SemReduction.puma" */
   return mPROC_OBJ (IsIdent ("PARITY"));

  }
  if (op->Kind == kPROC_OBJ) {
/* line 862 "SemReduction.puma" */
  {
/* line 864 "SemReduction.puma" */
   if (! ((op->PROC_OBJ.Ident == IsIdent ("MIN")))) goto yyL6;
  }
   return mPROC_OBJ (IsIdent ("MINVAL"));
yyL6:;

/* line 868 "SemReduction.puma" */
  {
/* line 870 "SemReduction.puma" */
   if (! ((op->PROC_OBJ.Ident == IsIdent ("MAX")))) goto yyL7;
  }
   return mPROC_OBJ (IsIdent ("MAXVAL"));
yyL7:;

/* line 874 "SemReduction.puma" */
  {
/* line 876 "SemReduction.puma" */
   if (! ((op->PROC_OBJ.Ident == IsIdent ("IAND")))) goto yyL8;
  }
   return mPROC_OBJ (IsIdent ("IALL"));
yyL8:;

/* line 880 "SemReduction.puma" */
  {
/* line 882 "SemReduction.puma" */
   if (! ((op->PROC_OBJ.Ident == IsIdent ("IOR")))) goto yyL9;
  }
   return mPROC_OBJ (IsIdent ("IANY"));
yyL9:;

/* line 886 "SemReduction.puma" */
  {
/* line 888 "SemReduction.puma" */
   if (! ((op->PROC_OBJ.Ident == IsIdent ("IEOR")))) goto yyL10;
  }
   return mPROC_OBJ (IsIdent ("IPARITY"));
yyL10:;

  }
/* line 892 "SemReduction.puma" */
   return NoTree;

}

static rbool RedVarUse
# if defined __STDC__ | defined __cplusplus
(register tTree exp, register tTree red_var)
# else
(exp, red_var)
 register tTree exp;
 register tTree red_var;
# endif
{
/* line 904 "SemReduction.puma" */
  {
/* line 906 "SemReduction.puma" */
   if (! ((IsVarInExp (TreeVarName (red_var), exp)))) goto yyL1;
  }
   return rtrue;
yyL1:;

  if (exp->Kind == kVAR_EXP) {
/* line 909 "SemReduction.puma" */
  {
/* line 911 "SemReduction.puma" */
   if (! ((IsReductionVariable (exp->VAR_EXP.V, red_var)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  if (exp->Kind == kOP_EXP) {
/* line 914 "SemReduction.puma" */
  {
/* line 916 "SemReduction.puma" */
   if (! ((RedVarUse (exp->OP_EXP.OPND1, red_var) || RedVarUse (exp->OP_EXP.OPND2, red_var)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (exp->Kind == kOP1_EXP) {
/* line 919 "SemReduction.puma" */
  {
/* line 921 "SemReduction.puma" */
   if (! ((RedVarUse (exp->OP1_EXP.OPND, red_var)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

static rbool IsReductionVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var, register tTree red_var)
# else
(var, red_var)
 register tTree var;
 register tTree red_var;
# endif
{
  if (var->Kind == kUSED_VAR) {
  if (red_var->Kind == kUSED_VAR) {
/* line 932 "SemReduction.puma" */
  {
/* line 934 "SemReduction.puma" */
   if (! ((var->USED_VAR.VARNAME->VAR_OBJ.Object == red_var->USED_VAR.VARNAME->VAR_OBJ.Object))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  if (var->Kind == kINDEXED_VAR) {
  if (red_var->Kind == kUSED_VAR) {
/* line 937 "SemReduction.puma" */
  {
/* line 939 "SemReduction.puma" */
   if (! ((IsReductionVariable (var->INDEXED_VAR.IND_VAR, red_var)))) goto yyL2;
  }
   return rtrue;
yyL2:;

  }
  }
  if (var->Kind == kREMOTE_VAR) {
  if (red_var->Kind == kUSED_VAR) {
/* line 942 "SemReduction.puma" */
  {
/* line 944 "SemReduction.puma" */
   if (! ((IsReductionVariable (var->REMOTE_VAR.VAR, red_var)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  }
  return rfalse;
}

static rbool EqualVariable
# if defined __STDC__ | defined __cplusplus
(register tTree var1, register tTree var2)
# else
(var1, var2)
 register tTree var1;
 register tTree var2;
# endif
{
  if (var1->Kind == kUSED_VAR) {
  if (var2->Kind == kUSED_VAR) {
/* line 958 "SemReduction.puma" */
  {
/* line 960 "SemReduction.puma" */
   if (! ((var1->USED_VAR.VARNAME->VAR_OBJ.Object == var2->USED_VAR.VARNAME->VAR_OBJ.Object))) goto yyL1;
  }
   return rtrue;
yyL1:;

  }
  }
  if (var1->Kind == kINDEXED_VAR) {
  if (var2->Kind == kINDEXED_VAR) {
/* line 963 "SemReduction.puma" */
  {
/* line 965 "SemReduction.puma" */
   if (! ((EqualVariable (var1->INDEXED_VAR.IND_VAR, var2->INDEXED_VAR.IND_VAR)))) goto yyL2;
  {
/* line 966 "SemReduction.puma" */
   if (! ((EqualIndexes (var1->INDEXED_VAR.IND_EXPS, var2->INDEXED_VAR.IND_EXPS)))) goto yyL2;
  }
  }
   return rtrue;
yyL2:;

  }
  }
  if (var1->Kind == kREMOTE_VAR) {
/* line 969 "SemReduction.puma" */
  {
/* line 971 "SemReduction.puma" */
   if (! ((EqualVariable (var1->REMOTE_VAR.VAR, var2)))) goto yyL3;
  }
   return rtrue;
yyL3:;

  }
  if (var2->Kind == kREMOTE_VAR) {
/* line 974 "SemReduction.puma" */
  {
/* line 976 "SemReduction.puma" */
   if (! ((EqualVariable (var1, var2->REMOTE_VAR.VAR)))) goto yyL4;
  }
   return rtrue;
yyL4:;

  }
  return rfalse;
}

void BeginSemReduction ARGS ((void))
{
}

void CloseSemReduction ARGS ((void))
{
}
